      REAL FUNCTION ERF(X)
C-----------------------------------------------------------------------
C     ERROR FUNCTION ROUTINE
C
C --- USING RATIONAL CHEBYSHEV APPROXIMATIONS, ERF(X) AND ERFC(X) ARE
C     COMPUTED TO ABOUT 1 PART IN 10**16.  SEE W. J. CODY, MATHEMATICS
C     OF COMPUTATION,23,107,631. (JULY 1969).
C --- COMPUTATIONS ARE DONE IN REAL*8.  FOR SINGLE PRECISION CALLS
C     THE ACCURACY DROPS VIA TRUNCATION TO ABOUT 1 IN 10**7.
C --- THE VARIOUS COMPUTATIONAL CUTOFFS ARE IDENTICAL TO IBM'S.
C *** V3.21
C
C ARGUMENTS:
C   PASSED:
C   RETURNED:
C
C I/O: NONE
C
C CALLING ROUTINES: FLOW  LIFTIN  LVDF  WRAP
C
C EXTERNAL ROUTINES:
C
C ENTRY POINTS:  DERF  DERFC  ERFC
C
C INTRINSIC FUNCTIONS: ABS  DABS  DEXP
C
C INCLUDE FILES: NONE
C
C COMMON BLOCKS: NONE
C
C-----------------------------------------------------------------------
C
      REAL X
      INTEGER IENTER

      DOUBLE PRECISION XX,DERF,DERFC
      DOUBLE PRECISION CERF,CERFC,SQRTPI
      DOUBLE PRECISION X1,X2,X3,X4,X5,X6,X7,X8,X10
      DOUBLE PRECISION P10,P12,P14,P16,P18,Q10,Q12,Q14,Q16,Q18
      DOUBLE PRECISION P20,P21,P22,P23,P24,P25,P26,P27,P28
      DOUBLE PRECISION Q20,Q21,Q22,Q23,Q24,Q25,Q26,Q27,Q28
      DOUBLE PRECISION P30,P32,P34,P36,P38,P3A,Q30,Q32,Q34,Q36,Q38,Q3A
C
      DATA SQRTPI/1.772453850905516D0/
      DATA P10/3.209377589138469D3/,P12/3.774852376853020D2/,
     R P14/1.138641541510502D2/,P16/3.161123743870566D0/,
     R P18/1.857777061846032D-1/,Q10/2.844236833439171D3/,
     R Q12/1.282616526077372D3/,Q14/2.440246379344442D2/,
     R Q16/2.360129095234412D1/,Q18/1.0D0/
      DATA P20/1.230339354797997D3/,P21/2.051078377826071D3/,
     R P22/1.712047612634071D3/,P23/8.819522212417691D2/,
     R P24/2.986351381974001D2/,P25/6.611919063714163D1/,
     R P26/8.883149794388376D0/,P27/5.641884969886701D-1/,
     R P28/2.153115354744038D-8/,Q20/1.230339354803749D3/,
     R Q21/3.439367674143722D3/,Q22/4.362619090143247D3/,
     R Q23/3.290799235733460D3/,Q24/1.621389574566690D3/,
     R Q25/5.371811018620099D2/,Q26/1.176939508913125D2/,
     R Q27/1.574492611070983D1/,Q28/1.0D0/
      DATA P30/6.587491615298378D-4/,P32/1.608378514874228D-2/,
     R P34/1.257817261112292D-1/,P36/3.603448999498044D-1/,
     R P38/3.053266349612323D-1/,P3A/1.631538713730210D-2/,
     R Q30/2.335204976268692D-3/,Q32/6.051834131244132D-2/,
     R Q34/5.279051029514284D-1/,Q36/1.872952849923460D0/,
     R Q38/2.568520192289822D0/,Q3A/1.0D0/
      IENTER=1
      CERF=1.0
      IF(X.LT.0.0) CERF=-1.0
      X1=ABS(X)
      IF(X1.GE.3.919206) GO TO 50
      GO TO 6
C
      ENTRY ERFC(X)
C
      IENTER=2
      CERFC=0.0
      IF(X.LT.0.0) CERFC=2.0
      IF(X.GE.13.306 .OR. X.LE.-3.919206) GO TO 50
      X1=ABS(X)
      GO TO 6
C
      ENTRY DERF(XX)
C
      IENTER=3
      CERF=1.0
      IF(XX.LT.0.0) CERF=-1.0
      X1=DABS(XX)
      IF(X1.GE.6.092368) GO TO 50
      GO TO 4
C
      ENTRY DERFC(XX)
C
      IENTER=4
      CERFC=0.0
      IF(XX.LT.0.0) CERFC=2.0
      IF(XX.GE.13.306 .OR. XX.LE.-6.092368) GO TO 50
      X1=DABS(XX)
    4 X=XX
    6 X2=X1*X1
      X4=X2*X2
      X6=X4*X2
      X8=X4*X4
      IF(X1.LE.0.5) GO TO 10
      IF(X1.GE.4.0) GO TO 30
C (20)METHOD 2.  FOR X BETWEEN 0.5 AND 4.0
      X3=X2*X1
      X5=X4*X1
      X7=X6*X1
      CERFC=DEXP(-X2)*(P20+P21*X1+P22*X2+P23*X3+P24*X4+P25*X5+P26*X6+
     X P27*X7+P28*X8)/(Q20+Q21*X1+Q22*X2+Q23*X3+Q24*X4+Q25*X5+Q26*X6+
     X Q27*X7+Q28*X8)
      IF(X.LT.0.0) CERFC=2.0-CERFC
      CERF=1.0-CERFC
      GO TO 50
   10 CERF=X1*(P10+P12*X2+P14*X4+P16*X6+P18*X8)/(Q10+Q12*X2+Q14*X4+
     X Q16*X6+Q18*X8)
      IF(X.LT.0.0) CERF=-CERF
      CERFC=1.0-CERF
      GO TO 50
   30 X10=X8*X2
      CERFC=-(P30+P32/X2+P34/X4+P36/X6+P38/X8+P3A/X10)/(Q30+Q32/X2+
     X Q34/X4+Q36/X6+Q38/X8+Q3A/X10)/X2+1.0/SQRTPI
      CERFC=CERFC*DEXP(-X2)/X1
      IF(X.LT.0.0) CERFC=2.0-CERFC
      CERF=1.0-CERFC
   50 GO TO (51,52,53,54),IENTER
   51 ERF=CERF
      RETURN
   52 ERFC=CERFC
      RETURN
   53 DERF=CERF
      RETURN
   54 DERFC=CERFC
      RETURN
      END
