      SUBROUTINE FLAT(QS,HEIGHT)
C-----------------------------------------------------------------------
C PURPOSE: PERFORM FLAT TERRAIN CALCULATIONS
C
C ARGUMENTS:
C   PASSED:
C       QS      REAL    EMISSION RATE (G/SEC)
C       HEIGHT  REAL    RECEPTOR HEIGHT ABOVE THE SURFACE (M)
C   RETURNED: NONE
C
C I/O:
C   INPUT: NONE
C   OUTPUT: UNIT=IOUT  CONCENTRATIONS
C
C CALLING ROUTINES: LIFT  SEQMOD
C
C EXTERNAL ROUTINES: NONE
C
C INTRINSIC FUNCTIONS: COS  EXP  SIN  SQRT
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: CONST  IO  PARAMS  PASL  PASVAL  VARS
C
C-----------------------------------------------------------------------
C
        INCLUDE 'PARAMS.INC'
        INCLUDE 'CONST.CMN'
        INCLUDE 'IO.CMN'
        INCLUDE 'PARAMS.CMN'
        INCLUDE 'PASL.CMN'
        INCLUDE 'PASVAL.CMN'
        INCLUDE 'VARS.CMN'

C  DEFINE ARGUMNETS
      REAL HEIGHT, QS

C  DEFINE LOCAL VARIABLES
      REAL   ARGMAX, ARGY, ARGZM, ARGZP, CO, DHM, DHP, DUMC, DUMS, 
     1       DX, DY, FACY, ROTFLO, SY, SYSQ, SZ, SZSQ, TENSIX, 
     2       TERMZM, TERMZP, TR, XRPF, XSPF, YRPF, YSPF, YT, ZT

      DATA ARGMAX/30./,TENSIX/1000000./
C
C  INITIALIZE CONCENTRATION
      C=0.0
C  ORIENT X-AXIS ALONG THE DIRECTION OF THE FLOW
      ROTFLO=PIBY2+PHIM
      DUMS=SIN(ROTFLO)
      DUMC=COS(ROTFLO)
      XSPF=XS*DUMC+YS*DUMS
      YSPF=-XS*DUMS+YS*DUMC
      XRPF=XR*DUMC+YR*DUMS
      YRPF=-XR*DUMS+YR*DUMC
C  CALCULATE THE DISTANCE TO THE RECEPTOR
      DX=XRPF-XSPF
      DY=YRPF-YSPF
C  CALCULATE TIME-OF-TRAVEL TO RECEPTOR
      TR=DX/UV
      ZT=TR+ZTV
      YT=TR+YTV
      IF(TR .LE. 0.) THEN
         IF(ICASE .EQ. 1 .OR.ICASE .EQ. 3) WRITE(IOUT,100) NR
         RETURN
      ENDIF
C  CALCULATE SIGMA-Z            ....EQN. 19
      SZ=SIGW*ZT/SQRT( 1.0 + 0.5*ZT/TTLZ)
      SZSQ=SZ*SZ
C  CALCULATE SIGMA-Y            ....EQN. 26
      SY=SIGV*YT/SQRT(1.+.5*YT/TTLY)
      SYSQ=SY*SY
C  COMPUTE THE CONCENTRATION IN MICROGRAMS/M**3
      TERMZP = 0.0
      TERMZM = 0.0
      DHP=HPL+HEIGHT
      DHM=HPL-HEIGHT
      CO=QS*TENSIX
      ARGY = 0.5*DY*DY/SYSQ
C  CONCENTRATION IS ZERO IF HORIZONTAL FACTOR IS ZERO
      IF(ARGY .LT. ARGMAX) THEN
         FACY = EXP(-ARGY)
         ARGZP = 0.5*DHP*DHP/SZSQ
         ARGZM = 0.5*DHM*DHM/SZSQ
         IF(ARGZP .LT. ARGMAX) TERMZP = EXP(-ARGZP)
         IF(ARGZM .LT. ARGMAX) TERMZM = EXP(-ARGZM)
         C=CO*FACY*(TERMZP+TERMZM)/(2.*PI*UV*SY*SZ)
      ENDIF
      IF(ICASE .EQ. 1 .OR. ICASE .EQ. 3) THEN
           WRITE(IOUT,101) NR,DX,DY,Z,DHM,SY,SZ,SY,SZ,C
      END IF
100   FORMAT(1X,I3,' NO FLAT CALCULATION; REC. UPWIND OF SOURCE')
101   FORMAT(/1X,I3,' F ',F8.1,3X,F8.1,2X,F7.1,2X,F7.1,1X,2F6.1,1X,
     1  2F6.1,1X,1PE10.4)
      RETURN
      END
