      SUBROUTINE FLOWSP(X,Y,Z,uti,vslp,wslp,pert,ALF,U)
C-----------------------------------------------------------------------FLW00020
C  DESCRIPTION:                                                         FLW00030
C     COMPUTES THE PERTURBATION WINDS UP,VP,WP AT THE POINT (X,Y,Z)     FLW00040
C     ABOVE THE SURFACE OF A ROTATED GAUSSIAN HILL.                     FLW00070
C                                                                       FLW00110
C *** THIS STRATIFIED FLOW CALCULATION ACCOUNTS FOR ARBITRARY           FLW00120
C     STRATIFICATION, N/U, (INCLUDING NEUTRAL) IN THE NEAR FIELD        FLW00130
C     OF THE HILL (I.E. X < LX, Y < LY, Z << LX OR LY ).                FLW00140
C *** LINEAR WIND SHEAR CORRECTIONS ARE ADDED IN SUCH THAT NEUTRAL      FLW00150
C     DEFLECTIONS ARE CORRECT TO LOWEST ORDER IN THE SHEAR GRADIENT.    FLW00160
C *** U''/U = 0 IS ASSUMED BUT N/U IS COMPUTED FROM FR ABOVE HC.        FLW00170
C                                                                       FLW00180
C ARGUMENTS:                                                            FLW00190
C   PASSED                                                              FLW00200
C       X       REAL    X COORDINATE (POSITIVE DOWNWIND OF HILL CENTER) FLW00210
C       Y       REAL    Y COORDINATE (POSITIVE LEFT OF HILL CENTER)     FLW00220
C       Z       REAL    Z COORDINATE (POSITIVE ABOVE HILL SURFACE)      FLW00230
C   RETURNED                                                            FLW00240
C       uti     REAL    inverse of total speed in x-direction           FLW00250
C       vslp    REAL    slope of flow vector with x in y-direction      FLW00260
C       wslp    REAL    slope of flow vector with x in z-direction      FLW00270
C                                                                       FLW00300
C CALLING ROUTINES:                                                     FLW00310
C                                                                       FLW00320
C EXTERNAL ROUTINES: HILHGT SPEED                                       FLW00330
C                                                                       FLW00340
C INTRINSIC FUNCTIONS:                                                  FLW00350
C                                                                       FLW00360
C INCLUDE FILES:                                                        FLW00370
C                                                                       FLW00380
C COMMON BLOCKS:                                                        FLW00390
C----------------------------------------------------------------------CFLW00400
C                                                                       FLW00410
      INCLUDE 'PARAMS.INC'                                              FLW00420
      INCLUDE 'CONST.CMN'                                               FLW00440
      INCLUDE 'PASL.CMN'                                                FLW00450
C      INCLUDE 'VARS.CMN'                                                FLW00460
      INCLUDE 'FLVAR.CMN'
C                                                                       FLW00470
C  DEFINE ARGUMENTS
      REAL  ALF, PERT, UTI, VSLP, WSLP, X, Y, Z

C  DEFINE LOCAL VARIABLES
      REAL AD0, AD1, AD2, AF0, AF1, AF2, AF2SHR, ARG, AST, ASTDS2, 
     1     CSZ, EFAC, EXPARG, FOUR, G0X, G1X, GAMLX, GAMLX2, GAMP, 
     2     HALF, HHLX2E, HH0, HH1, HHM, HHXY, HHXYM, ONE, QX, 
     3     SHRC, SHRF, SHRFDZ, SI, SUM, SSZ, SZ, T0, T1, T2, 
     4     TERM1, TERM2, TERM3, TI0, TI1, TI2, TWO, TZFAC, TZFDZ, 
     5     U, UI, U0, UP, VP, WP, XDLX, XM, XMDLX, XMDLX2, 
     6     YDLY, YDLY2, YM, YMDLY, ZERO, ZFACI, ZFACDZ
      REAL*4 I,IDY,IDZ,IDX,IDXX,IDXY,IDXZ                               FLW00490
      REAL*4 IX,IXDY                                                    FLW00500

      DATA ZERO/0.0/,ONE/1.0/,TWO/2.0/,FOUR/4.0/,HALF/0.5/
C                                                                       FLW00540
C *** MOST OF THIS CODE COMPUTES I AND ITS INTEGRALS AND DERIVATIVES.   FLW00550
C     THE NOTATION IS SEEN IN THE EXAMPLE IXDY, WHICH IS I INTEGRATED   FLW00560
C     ONCE IN X (FROM -INFINITY TO X) AND DIFFERENTIATED IN Y.          FLW00570
C                                                                       FLW00580
C
C *** COMPUTE DIMENSIONLESS COORDINATES
      XDLX = X * LXI                                                    FLW00710
      YDLY = Y * LYI                                                    FLW00720
      YDLY2 = YDLY * YDLY                                               FLW00730
C                                                                       FLW00740
C *** COMPUTE THE MODIFIED COORDINATES XM,YM AND THEIR                  FLW00750
C     DIMENSIONLESS FORMS XMDLX,YMDLY.                                  FLW00760
      XM = X + GAM*LX*LX*Y                                              FLW00770
      YM = Y + GAM*LY*LY*X                                              FLW00780
      XMDLX = XM * LXI                                                  FLW00790
      XMDLX2 = XMDLX * XMDLX                                            FLW00800
      YMDLY = YM * LYI                                                  FLW00810
c     YMDLY2 = YMDLY * YMDLY                                            FLW00820
C                                                                       FLW00830
      GAMLX = GAM * LX                                                  FLW00840
      GAMLX2 = GAMLX * GAMLX                                            FLW00850
      GAMP = ONE - GAMLX2*LY*LY                                         FLW00860
c     GAMP2 = GAMP * GAMP                                               FLW00870
C                                                                       FLW00880
C     HHXY = HH * HILHGT(X,Y)   BUT COMPUTE IN CODE BELOW.              FLW00890
      ARG = XDLX*XDLX + YDLY*YDLY + 2.0*GAM*X*Y                         FLW00900
      IF(ARG .GT. 30.) ARG = 30.                                        FLW00910
      EXPARG = EXP(-ARG)                                                FLW00920
      HHXY = HH * EXPARG                                                FLW00930
C                                                                       FLW00940
C *** OBTAIN CORRECT WIND SPEED, U, USING SPEED                         FLW00950
C                                                                       FLW00960
C *** USE THE WS AT HALF PLUME RISE INSTEAD OF SPEED - DBS 7/93
C      U = SPEED(HHXY+Z)                                                 FLW00970
      UI = ONE / U                                                      FLW00980
C                                                                       FLW00990
C     COMPUTE THE SHEAR FACTORS THAT ARE NEEDED.                        FLW01000
C                                                                       FLW01010
C      U0 = AMIN1(SPEED(HHXY),U)                                         FLW01020
C *** ASSUME A CONSTANT WIND SPEED PROFILE FOR UNSTABLE - DBS 7/93
      U0 = U
      SHRF = SQRT(U0*UI)                                                FLW01030
      SHRFDZ = -HALF * ALF * UI                                         FLW01040
      SHRC=HALF*ALF/U0                                                  FLW01050
C *** COMPUTE THE ADDITIONAL Z SUPRESSION FACTOR FROM NEUTRAL FLOW MATCHFLW01060
      ZFACI = ONE / (ONE + LNI * Z)                                     FLW01070
      ZFACDZ = -TWO * LNI * ZFACI                                       FLW01080
C *** COMBINE WITH SHEAR FACTOR TO GIVE TOTAL Z ADJUSTMENT FACTOR.      FLW01090
      TZFAC = SHRF * ZFACI * ZFACI                                      FLW01100
      TZFDZ = SHRFDZ + ZFACDZ                                           FLW01110
c     TZFDZZ = TZFDZ*TZFDZ - SHRFDZ*ALF*UI - ZFACDZ*LNI*ZFACI           FLW01120
C                                                                       FLW01260
      AST = TWO * RTPII * S2 * LZ * PII * B0N2 - SHRC                   FLW01270
C --- ASTDS2 IS ACTUALLY AST/(S*BVUI)                                   FLW01280
      ASTDS2 = TWO * RTPII * LZ * PII * HASYM                           FLW01290
C --- HHM IS THE COEFFICIENT OF I AT X=Y=0                              FLW01300
      HHM = HH * LN / (ONE + B02)                                       FLW01310
C --- HHXYM IS THE COEFFICIENT OF I AWAY FROM HILL CREST                FLW01320
      HHXYM = HHM * EXPARG                                              FLW01330
C *** COMPUTE THE STRATIFICATION HEIGHT, SZ.                            FLW01340
      SZ = S * Z                                                        FLW01350
C                                                                       FLW01360
C *** COMPUTE THE VARIOUS 'ANGULAR FACTORS', AFN, AND THEIR DERIVATIVES,FLW01370
C     ADN, CONDITIONED ON THE VALUE OF SZ.                              FLW01380
      IF(SZ .LE. 0.005) THEN                                            FLW01390
         CSZ = ONE                                                      FLW01400
         SSZ = SZ                                                       FLW01410
         AF1 = Z                                                        FLW01420
         AD1 = ONE                                                      FLW01430
c        ADD1 = S * SZ                                                  FLW01440
      ELSE                                                              FLW01450
         SI  = ONE / S                                                  FLW01460
         CSZ = COS(SZ)                                                  FLW01470
         SSZ = SIN(SZ)                                                  FLW01480
         AF1 = SSZ * SI                                                 FLW01490
         AD1 = CSZ                                                      FLW01500
c        ADD1 = -S * SSZ                                                FLW01510
      ENDIF                                                             FLW01520
C                                                                       FLW01530
C     AF0 = CSZ / ZFACI                                                 FLW01540
C     AD0 = LNI * CSZ  -  S * SSZ / ZFACI                               FLW01550
C *** OVERRIDE AF0=CSZ WITH AF0=ONE. 10/8/86                            FLW01560
      AF0 = ONE / ZFACI                                                 FLW01570
      AD0 =  LNI                                                        FLW01580
c     ADD0 = -S2 / ZFACI                                                FLW01590
      AF2SHR = TWO * LNI + SHRC                                         FLW01600
      AF2 = S * CSZ + AF2SHR * SSZ                                      FLW01610
      AD2 = -S2 * SSZ + AF2SHR * S * CSZ                                FLW01620
c     ADD2 = -S2 * (S * CSZ + AF2SHR * SSZ)                             FLW01630
C                                                                       FLW01640
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR I.                         FLW01650
      T0 = ONE                                                          FLW01660
      T1 = -AST                                                         FLW01670
C ??? T2 = -ASTDS2*XMDLX                                                FLW01680
C ---------- TRY SETTING T2=0. FOR XM LESS THAN ZERO ------------       FLW01690
      T2 = 0.                                                           FLW01700
      IF(XM .GE. 0.) T2 = -ASTDS2*XMDLX                                 FLW01710
C                                                                       FLW01720
      TI0 = T0 * AF0                                                    FLW01730
      TI1 = T1 * AF1                                                    FLW01740
      TI2 = T2 * AF2                                                    FLW01750
      SUM = TI0 + TI1 + TI2                                             FLW01760
C                                                                       FLW01770
C *** COMPUTE THE BASIC QUANTITY I.   ....EQN. A-27                     FLW01780
      I = TZFAC * HHXYM * SUM                                           FLW01790
C                                                                       FLW01800
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IDZ.                       FLW01810
      TI0 = T0 * AD0                                                    FLW01820
      TI1 = T1 * AD1                                                    FLW01830
      TI2 = T2 * AD2                                                    FLW01840
      SUM = TI0 + TI1 + TI2                                             FLW01850
C                                                                       FLW01860
C *** COMPUTE THE DERIVATIVE OF I WITH RESPECT TO Z.  ....EQN. A-28     FLW01870
      TERM1 = TZFAC * HHXYM * SUM                                       FLW01880
      IDZ =  TERM1  +  TZFDZ * I                                        FLW01890
C                                                                       FLW01900
C                                                                       FLW02000
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IDX AND IDXZ.              FLW02010
C     T0 = ZERO                                                         FLW02020
C     T1 = ZERO                                                         FLW02030
      T2 = -ASTDS2 * LXI                                                FLW02040
C                                                                       FLW02050
C     TI0 = T0 * AF0                                                    FLW02060
C     TI1 = T1 * AF1                                                    FLW02070
      TI2 = T2 * AF2                                                    FLW02080
C     SUM = TI0 + TI1 + TI2                                             FLW02090
      SUM = TI2                                                         FLW02100
C                                                                       FLW02110
C *** COMPUTE THE QUANTITY IDX.    ....EQN. A-30                        FLW02120
      TERM2 = TZFAC * HHXYM * SUM                                       FLW02130
      IDX = -TWO * XMDLX * LXI * I  +  TERM2                            FLW02140
C                                                                       FLW02150
C     NOW COMPUTE THE D/DZ TERMS.                                       FLW02160
C     TI0 = T0 * AD0                                                    FLW02170
C     TI1 = T1 * AD1                                                    FLW02180
      TI2 = T2 * AD2                                                    FLW02190
C     SUM = TI0 + TI1 + TI2                                             FLW02200
      SUM = TI2                                                         FLW02210
C                                                                       FLW02220
C *** COMPUTE THE DERIVATIVE OF IDX WITH RESPECT TO Z.  ....EQN. A-32   FLW02230
      TERM3 = TZFAC*HHXYM*SUM                                           FLW02240
      IDXZ = -TWO*XMDLX*LXI*IDZ + TZFDZ*TERM2 + TERM3                   FLW02250
C                                                                       FLW02260
C                                                                       FLW02270
C *** COMPUTE THE QUANTITIES NEEDED FOR IDXX.                           FLW02280
C     T0 = ZERO                                                         FLW02290
C     T1 = ZERO                                                         FLW02300
C     T2 = ZERO                                                         FLW02310
C                                                                       FLW02320
C     TI0 = T0 * AF0                                                    FLW02330
C     TI1 = T1 * AF1                                                    FLW02340
C     TI2 = T2 * AF2                                                    FLW02350
C     SUM = TI0 + TI1 + TI2                                             FLW02360
      SUM = ZERO                                                        FLW02370
C                                                                       FLW02380
C *** COMPUTE THE QUANTITY IDXX.  ....EQN. A-31                         FLW02390
      IDXX = -TWO * LXI2 * (ONE + TWO * XMDLX2) * I  -                  FLW02400
     X       FOUR * XMDLX * LXI * IDX  +  TZFAC * HHXYM * SUM           FLW02410
C                                                                       FLW02420
C                                                                       FLW02430
C                                                                       FLW02440
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IDY.                       FLW02450
C     T0 = ZERO                                                         FLW02460
C     T1 = ZERO                                                         FLW02470
      T2 = -ASTDS2 * GAMLX                                              FLW02480
C                                                                       FLW02490
C     TI0 = T0 * AF0                                                    FLW02500
C     TI1 = T1 * AF1                                                    FLW02510
      TI2 = T2 * AF2                                                    FLW02520
C     SUM = TI0 + TI1 + TI2                                             FLW02530
      SUM = TI2                                                         FLW02540
C                                                                       FLW02550
C *** COMPUTE THE QUANTITY IDY.   ....EQN. A-33                         FLW02560
      IDY = -TWO * LYI * YMDLY * I  +  TZFAC * HHXYM * SUM              FLW02570
C                                                                       FLW02660
C                                                                       FLW02670
C *** COMPUTE THE QUANTITIES NEEDED FOR IDXY.                           FLW02680
C     T0 = ZERO                                                         FLW02690
C     T1 = ZERO                                                         FLW02700
C     T2 = ZERO                                                         FLW02710
C                                                                       FLW02720
C     TI0 = T0 * AF0                                                    FLW02730
C     TI1 = T1 * AF1                                                    FLW02740
C     TI2 = T2 * AF2                                                    FLW02750
C     SUM = TI0 + TI1 + TI2                                             FLW02760
      SUM = ZERO                                                        FLW02770
C                                                                       FLW02780
C *** COMPUTE THE QUANTITY IDXY.     ....EQN. A-36                      FLW02790
      IDXY = -TWO * (GAM  +  TWO * XM * YM * LXI2 * LYI2) * I  -        FLW02800
     X       TWO * XMDLX * LXI * IDY  -                                 FLW02810
     X       TWO * YMDLY * LYI * IDX  +  TZFAC * HHXYM * SUM            FLW02820
C                                                                       FLW02830
C                                                                       FLW02840
C ****************************************************************      FLW02850
C --- COMPUTE THE GNX AND GNXX FACTORS.                                 FLW02890
C $$$ G0X = HALF * SQRPI * ( ONE + ERF(XMDLX) )                         FLW02900
C --- INSERT THE FOLLOWING FIX TO KILL LAT. DEFL. GROWTH. 10/1/86       FLW02910
      G0X = HALF * SQRPI * ( ONE - ERF( ABS(XMDLX) )  )                 FLW02920
C                                                                       FLW02930
      IF(XMDLX2 .GT.30.) XMDLX2 = 30.                                   FLW02940
      G1X = -HALF * EXP(-XMDLX2)                                        FLW02950
c     G0XX = XMDLX * G0X - G1X                                          FLW02960
c     G1XX = -HALF * G0X                                                FLW02970
C                                                                       FLW02980
C     QX = YDLY2 - GAMLX2 * Y * Y                                       FLW03110
      QX = YDLY2 * GAMP                                                 FLW03120
      IF(QX .GT.30.) QX = 30.                                           FLW03130
      EFAC = EXP(-QX)                                                   FLW03140
      HHLX2E = HHM * LX * LX * EFAC                                     FLW03150
C                                                                       FLW03310
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IX.                        FLW03320
      T0 = +G0X                                                         FLW03330
      T1 = -G0X                                                         FLW03340
      T1 = AST * T1                                                     FLW03350
      T2 = -ASTDS2*G1X                                                  FLW03360
C                                                                       FLW03370
      TI0 = T0 * AF0                                                    FLW03380
      TI1 = T1 * AF1                                                    FLW03390
      TI2 = T2 * AF2                                                    FLW03400
      SUM = TI0 + TI1 + TI2                                             FLW03410
C                                                                       FLW03420
C *** COMPUTE THE QUANTITY IX.     ....EQN. A-41                        FLW03430
      IX = TZFAC * HHLX2E * LXI * SUM                                   FLW03440
C                                                                       FLW03450
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IXDY.                      FLW03460
C     HHJ = GAMLX * EXP(-XMDLX2) * XMDLX**J  BUT SEE G1X                FLW03470
      HH0 = -TWO * G1X * GAMLX                                          FLW03480
      HH1 = HH0 * XMDLX                                                 FLW03490
c     HH2 = HH1 * XMDLX                                                 FLW03500
      T0 = HH0                                                          FLW03510
      T1 = -HH0                                                         FLW03520
      T1 = AST * T1                                                     FLW03530
      T2 = -ASTDS2*HH1                                                  FLW03540
C                                                                       FLW03550
      TI0 = T0 * AF0                                                    FLW03560
      TI1 = T1 * AF1                                                    FLW03570
      TI2 = T2 * AF2                                                    FLW03580
      SUM = TI0 + TI1 + TI2                                             FLW03590
C                                                                       FLW03600
C *** COMPUTE THE QUANTITY IXDY.        ....EQN. A-45                   FLW03610
      IXDY = -TWO * LYI2 * Y * GAMP * IX  +  TZFAC * HHLX2E * LXI * SUM FLW03620
C                                                                       FLW03630
C                                                                       FLW03640
C                                                                       FLW04190
C ****************************************************************      FLW04200
C                                                                       FLW04210
C *** COMPUTE THE PERTURBATION VELOCITIES.   ...EQNS. A-22B,C,D         FLW04220
C                                                                       FLW04230
C *** NOW COMPUTE THE ALONG-WIND VELOCITY PERTURBATION AS               FLW04240
C     UP/U = -(IDXX + (BV*UI)**2 * I )                                  FLW04250
C     NOTE THAT THIS IS JUST THE NEGATIVE OF THE PERTURBATION           FLW04260
C     PRESSURE DIVIDED BY RHO(0)*U**2.                                  FLW04270
      TERM3 = BVUI2 * I                                                 FLW04280
      UP = -(IDXX + TERM3)                                              FLW04290
C *** COMPUTE THE NON-LINEAR PERTURBATION ALA HUNT ET AL.               FLW04300
C!!!!!UPNL = ( -ONE + SQRT( ABS(ONE + TWO*UP) )  ) * U                  FLW04310
      UP = UP * U                                                       FLW04320
C                                                                       FLW04330
C *** NOW COMPUTE THE LATERAL VELOCITY PERTURBATION AS                  FLW04340
C     VP/U = -(IDXY + (BV*UI)**2 * IXDY)                                FLW04350
      TERM3 = BVUI2 * IXDY                                              FLW04360
      VP = -(IDXY + TERM3) * U                                          FLW04370
C                                                                       FLW04380
C *** NOW COMPUTE THE VERTICAL VELOCITY PERTURBATION AS -(D/DZ) IDX.    FLW04390
      WP = -IDXZ * U                                                    FLW04400
C                                                                       FLW04410
C ***********************************************************           FLW04420
C                                                                       FLW04490
c  Calculate slope of trajectory from wind components
      uti=1./(u+up)
      vslp=vp*uti
      wslp=wp*uti

c  Calculate relative magnitude of perturbation
      pert=SQRT(up*up+vp*vp+wp*wp)/u

      RETURN                                                            FLW04500
      END                                                               FLW04510
