        REAL FUNCTION GETSV(Z2)
C-----------------------------------------------------------------------
C PURPOSE:  THIS ROUTINE RETURNS A VALUE OF SIGMA-V AT THE DESIRED
C           HEIGHT BY SCALING AN EXISTING OBSERVATION OR COMPUTING
C           SIGMA-V FROM SURFACE VARIABLES.
C
C ARGUMENTS
C  PASSED:
C       Z2    REAL      HEIGHT ABOVE GROUND AT WHICH SIGMA-V IS TO
C                       BE COMPUTED (M)
C
C  RETURNED:
C       GETSV REAL      THE RETURNED VALUE OF SIGMA-V
C
C I/O: NONE
C
C CALLING ROUTINES: GETUV  SEQMOD
C
C EXTERNAL ROUTINES: KLOSE
C
C INTRINSIC FUNCTIONS: NONE
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: SFCMET PROFIL
C
C-----------------------------------------------------------------------
C
      INCLUDE   'PARAMS.INC'
C      INCLUDE   'SFCMET.CMN'
      INCLUDE   'PROFIL.CMN'
C
C       DEFINE ARGUMENTS
        REAL    Z2
C
C       DEFINE LOCAL VARIABLES
        INTEGER LEV,    N,      NNEW
        REAL    DX, DZ, SV1, SV3, SVNEW(MAXLEV), HTNEW(MAXLEV), 
     &          SVMISS, Z1, Z3
        DATA    SVMISS/ 0.0/
C
C       EXAMINE DATA AND SELECT ONLY NONMISSING VALUES
C
        NNEW = 0
        DO 100 N = 1,NHT
           IF(SVHR(N) .LT. SVMISS ) GO TO 100
           NNEW = NNEW + 1
           SVNEW(NNEW) = SVHR(N)
           HTNEW(NNEW) = HT(N)
100     CONTINUE
C
        IF(NNEW .GE. 1) THEN
            LEV = KLOSE(HTNEW, NNEW, Z2)
            IF(LEV.EQ.0) THEN
                Z1 = HTNEW(1)
                SV1 = SVNEW(1)
              ELSE
                Z1 = HTNEW(LEV)
                SV1 = SVNEW(LEV)
            ENDIF
        ENDIF
C
C       IF NO OBSERVATIONS, RETURN MISSING VALUE OF SIGMA-V
C
        IF(NNEW .EQ. 0) THEN
            GETSV = -9.99
            RETURN
        ENDIF
C
C       IN THIS SECTION, THERE IS AT LEAST ONE GOOD OBSERVATION
C
C       USE INTERPOLATION IF POSSIBLE; OTHERWISE, USE CLOSEST OBS.
C
        IF(LEV.GE.1 .AND. LEV.LT.NNEW) THEN
            SV3 = SVNEW(LEV+1)
            Z3 = HTNEW(LEV+1)
            DX = SV3 - SV1
            DZ = Z3 - Z1
            GETSV = SV1 + (Z2-Z1)*(DX/DZ)
          ELSE
            GETSV = SV1
        ENDIF
        RETURN
        END
