        REAL FUNCTION GETSW(Z2)
C-----------------------------------------------------------------------
C PURPOSE:  THIS ROUTINE RETURNS A VALUE OF SIGMA-W AT THE DESIRED
C           HEIGHT BY SCALING AN EXISTING OBSERVATION OR COMPUTING
C           SIGMA-W FROM SURFACE VARIABLES.
C
C ARGUMENTS
C  PASSED:
C       Z2    REAL      HEIGHT ABOVE GROUND AT WHICH SIGMA-W IS TO
C                       BE COMPUTED (M)
C
C  RETURNED:
C       GETSW REAL      THE RETURNED VALUE OF SIGMA-W
C
C I/O: NONE
C
C CALLING ROUTINES: SEQMOD
C
C EXTERNAL ROUTINES: KLOSE
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: SFCMET PROFIL PARAMS
C
C-----------------------------------------------------------------------
C
      INCLUDE   'PARAMS.INC'
C      INCLUDE   'SFCMET.CMN'
      INCLUDE   'PROFIL.CMN'
C
C       DEFINE ARGUMENTS
        REAL    Z2
C
C       DEFINE LOCAL VARIABLES
        INTEGER LEV,    N,      NNEW
        REAL    DX, DZ, SW1, SW3, SWNEW(MAXLEV), HTNEW(MAXLEV), 
     &          SWMISS, Z1, Z3
        DATA    SWMISS/ 0.0/
C
C       EXAMINE DATA AND SELECT ONLY NONMISSING VALUES
C
        NNEW = 0
        DO 100 N = 1,NHT
           IF(SWHR(N) .LT. SWMISS ) GO TO 100
           NNEW = NNEW + 1
           SWNEW(NNEW) = SWHR(N)
           HTNEW(NNEW) = HT(N)
100     CONTINUE
C
        IF(NNEW .GE. 1) THEN
            LEV = KLOSE(HTNEW, NNEW, Z2)
            IF(LEV.EQ.0) THEN
                Z1 = HTNEW(1)
                SW1 = SWNEW(1)
              ELSE
                Z1 = HTNEW(LEV)
                SW1 = SWNEW(LEV)
            ENDIF
        ENDIF
C
C       OF NO OBSERVATIONS, RETURN MISSING VALUE IF SIGMA-W
C
        IF(NNEW .EQ. 0) THEN
            GETSW = -9.99
            RETURN
        ENDIF
C
C       IN THIS SECTION, THERE IS AT LEAST ONE GOOD OBSERVATION
C
C       USE INTERPOLATION IF POSSIBLE; OTHERWISE, USE CLOSEST OBS.
C
        IF(LEV.GE.1 .AND. LEV.LT.NNEW) THEN
            SW3 = SWNEW(LEV+1)
            Z3 = HTNEW(LEV+1)
            DX = SW3 - SW1
            DZ = Z3 - Z1
            GETSW = SW1 + (Z2-Z1)*(DX/DZ)
          ELSE
            GETSW = SW1
        ENDIF
        RETURN
        END
