      REAL FUNCTION HILHGT(X,Y)
C-----------------------------------------------------------------------
C DESCRIPTION: COMPUTES THE FRACTIONAL HILL HEIGHT AT
C               THE POSITION (X,Y) FOR A ROTATED GAUSSIAN HILL.
C
C ARGUMENTS:
C   PASSED:
C       X,Y     REAL    LOCATION AT WHICH HEIGHT IS NEEDED  (M)
C
C I/O: NONE
C
C CALLING ROUTINES: FLOW  PATH
C
C EXTERNAL ROUTINES: NONE
C
C INTRINSIC FUNCTIONS: EXP
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: PASL
C
C-----------------------------------------------------------------------
C
      INCLUDE   'PARAMS.INC'
      INCLUDE   'PASL.CMN'
C
C       DEFINE ARGUMENTS
      REAL      X, Y
C
C       DEFINE LOCAL VARIABLES
      REAL      Q, XDLX, YDLY
C
C                              ....EQN. A-25
      XDLX = X / LX
      YDLY = Y / LY
      Q = XDLX*XDLX + YDLY*YDLY + 2.0*GAM*X*Y
C  NOTE THAT HILROT PROVIDES CROSSTERM GAM FOR A ROTATED HILL
      IF(Q .GT. 30.) Q = 30.
      HILHGT = EXP(-Q)
C
      RETURN
      END
