        SUBROUTINE INPAR
C----------------------------------------------------------------------
C   PURPOSE:
C       THIS SUBROUTINE READS AND PRINTS THE PROGRAM I/O SWITCHES,
C       PROGRAM CONVERSION FACTORS AND CONSTANTS, AND OTHER
C       MISCELLANEOUS SWITCHES.  THESE VALUES ARE SAVED IN PARAMS.CMN.
C
C   ARGUMENTS:
C    PASSED: NONE
C    RETURNED: NONE
C
C   I/O:
C   INPUT FROM UNIT 5:
C       LINE 1: SWITCHES (0 OR 1) FOR SEVERAL PROGRAM OPTIONS
C       LINE 2: HORIZ. AND VERT. CONVERSION FACTORS, LATITUDE AND
C               LONGITUDE OF SITE, TIME ZONE, POLLUTANT #
C
C   OUTPUT TO UNIT 6:
C       PRINTOUT OF VALUES OF SWITCHES AND PARAMETERS READ IN
C
C   CALLING PROGRAM: CTDMPLUS (MAIN)
C
C   EXTERNALS: PAGE,    TOPN
C
C   INCLUDE FILES: NONE
C
C   COMMON BLOCKS: IO, PARAMS
C
C-----------------------------------------------------------------------
C
      INCLUDE   'IO.CMN'
      INCLUDE   'PARAMS.CMN'
C
C       DEFINE LOCAL VARIABLES
        REAL            DTR,    OMEGA,  DUMMY(1)

C
C       READ INPUT PARAMETERS
C
        READ(IN,*) ICASE, ITOPN, ICONC, IMIX,
     1             IWS1, ISIGV, IWD, ICHIQ, ISOR, IUNSTA, ISTKTP

C
        READ(IN,*) HORIZ,VERT,ALAT,ALONG,TZONE,IPOL
C
C       DEFAULT INPUTS
        IF(ICASE .LT. 0  .OR.  ICASE .GT. 3) ICASE = 3
        IF(ITOPN .NE. 0  .AND.  ITOPN .NE. 1) ITOPN = 1
        IF(ICONC .LT. 0  .OR.  ICONC. GT. 3) ICONC = 0
        IF (IUNSTA .NE. 0 .AND. IUNSTA .NE. 1 .AND. IUNSTA .NE. 2)
     &    IUNSTA = 1
        IF (ISOR .LT. 0 .OR. ISOR .GT. 2) ISOR = 0
        IF (ISTKTP .NE. 0 .AND. ISTKTP .NE. 1) ISTKTP = 0
C
C       WRITE INPUT PARAMETERS
C
        WRITE(IOUT,6010) ICASE,ITOPN,ICONC
        WRITE(IOUT,6020) IMIX,IWS1,ISIGV,IWD,ICHIQ, ISOR, 
     &                   IUNSTA, ISTKTP
        WRITE(IOUT,6040) HORIZ,VERT
        WRITE(IOUT,6050) ALAT,ALONG,TZONE,IPOL
C
C       INITIALIZE TOP N ARRAYS
        IF(ITOPN .EQ. 1) CALL TOPN(DUMMY,1,-1,' ')
C
C       NEGATIVE USED BY WRITIT TO INDICATE FIRST TIME THROUGH
        IF(ICONC .EQ. 3) ICONC = -3
C
        OMEGA=7.292E-5
        DTR=0.01745329
        CORIOL=2.0*OMEGA*SIN(ALAT*DTR)
        RETURN
C
6010    FORMAT(/////,10X,'INPUT/OUTPUT SWITCHES (1 = USE THIS OPTION, ',
     1  '0 = DO NOT USE OPTION )',//,10X,
     2  'ICASE:  INCLUDE CASE-STUDY PRINTOUT: 0 = NONE, ', 
     2  '1 = STABLE ONLY, ',/,25X,'2 = UNSTABLE ONLY  ',
     3  '3 = ALL HOURS',T78,I1,/,10X,
     4  'ITOPN:  CREATE TOP 4 TABLE AT END OF RUN',
     5  T78,I1,/,10X,
     6  'ICONC:  CONCENTRATION OUTPUT:  0 = NONE, 1 = BINARY, ',
     7  '2/3 = TEXT',T78,I1,/)
6020    FORMAT(/,10X,'INTERNAL PROGRAM SWITCHES',//,10X,
     1  'IMIX: (IF 1, USE ON-SITE MIXING HEIGHT OBSERVATIONS       ',/,
     2  15X,' (OFF-SITE IF NOT AVAILABLE); IF 0, VICE VERSA)',
     3  T78,I1,/,10X,
     4  'IWS1:  (IF 1, SET MINIMUM WIND SPEED TO 1.0 M/S)             ',
     5  T78,I1,/,10X,
     6  'ISIGV: (HORIZ. TURB. INTENSITY DATA (0=SIGMA-THETA ',
     6  '1=SIGMA-V)',T78,I1,/,10X,
     A  'IWD:   (IF 1, SCALE WIND DIRECTION WITH HEIGHT)              ',
     B  T78,I1,/,10X,
     C  'ICHIQ: (IF 1, MODEL OUTPUTS CHI/Q;  OTHERWISE IT OUTPUTS CHI)',
     D  T78,I1,/,10X,
     E  'ISOR: (SOURCE CONTRIBUTION FILE: 0 = NONE, 1 = TEXT, ',
     F   '2 = BINARY',T78,I1,/,10X,
     G  'IUNSTA: (IF 0, MODEL WILL NOT READ RAWIN FILE OR CALCULATE ',
     H  /,25X,'UNSTABLE HOURS)  ',T78,I1,/,10X,
     I  'ISTKTP: (IF 1, SET CONC TO 0.0 FOR RECEPTORS BELOW STACK TOP)',
     J  T78,I1)
6040    FORMAT(/,10X,'FOR HORIZONTAL SCALE, MULTIPLY USER UNITS BY ',
     1  F10.4,' TO GET METERS.',/,10X,'FOR ELEVATION, ',
     2  'MULTIPLY USER UNITS BY ',F10.4,' TO GET METERS.',/)
6050    FORMAT(10X,'SITE LATITUDE (> 0 IF NORTH) = ',F6.3,/,
     1  10X,'SITE LONGITUDE (> 0 IF WEST) = ',F7.3,/,
     2  10X,'SITE TIME ZONE (> 0 IF WEST) = ',F5.0,/,
     3  10X,'POLLUTANT # (FOR HOURLY EMISSIONS) = ',I4)
C
        END

