      SUBROUTINE PATH(TH,TL,TU,X,YI,ZI,ALF,FR,ILOOP)
C----------------------------------------------------------------------
C  DESCRIPTION:
C     COMPUTES THE POSITION OF THE STREAMLINE THAT PASSES THROUGH THE
C     POINT AT (-INFINITY,YI,ZI) FOR ANY X ASSUMING A GAUSSIAN HILL
C     FUNCTION H(a,b)=HH*EXP(-(a/AH)**2-(b/BH)**2).  LOCAL DEFORMATION
C     FACTORS Th,Tl,Tu ARE COMPUTED AT (X,Y,Z).
C     NOTE THAT THE X-AXIS IS ALIGNED WITH THE INCIDENT FLOW.
C
C  ARGUMENTS:
C    PASSED:
C       X       REAL    DISTANCE ALONG FLOW AT WHICH STREAMLINE COORD.
C                       ARE FOUND (M)
C       YI,ZI   REAL    STREAMLINE COORD. FAR FROM HILL (M)
C    RETURNED:
C     TH,TL,TU  REAL    LOCAL DEFORMATION OR STRAIN FACTORS
C
C I/O: NONE
C
C CALLING ROUTINES: LIFTIN
C
C EXTERNALS ROUTINES:  FLOW  HILHGT
C
C INTRINSIC FUNCTIONS:  ABS  SIGN
C
C INCLUDE FILESL PARAMS.INC
C
C COMMON BLOCKS: CONST  PARAMS  PASL  VARS
C
C-----------------------------------------------------------------------
C
      INCLUDE 'PARAMS.INC'
C      INCLUDE 'PARAMS.CMN'
C      INCLUDE 'CONST.CMN'
      INCLUDE 'PASL.CMN'
C      INCLUDE 'VARS.CMN'
C
C  DEFINE ARGUMENTS
      REAL   ALF, FR, TH, TL, TU, X, YI, ZI

C  DEFINE LOCAL VARIABLES
      REAL     ASPECT, CRIT, DEL1, DEL2, DEL3, DENY, DENZ, DSMALL, 
     1         ERRY, ERRZ, ETA1, ETA2, ETA3, FRINCR, FRSAVE, 
     2         H1, H2, H3, STEP, THI, TLCALC, TLI, TLRES, WEIGHT, 
     3         Y1, Y2, Y3, YSTEP, Z1, Z2, Z3, ZSTEP
      INTEGER  NITER, MXITER

      DATA CRIT/0.005/
      DATA SMALL/0.00001/
      DSMALL=.01*HH
      YSTEP=0.5*LY
      ZSTEP=0.5*HH
                  
C     INITIALIZE ENDLESS LOOP FLAG
      ILOOP = 0

C *** SET INITIAL GUESSES FOR Y AND Z
      ZI=AMAX1(ZI,DSMALL)
      Y1=1.5*YI
      Z1=.75*ZI
      Y2=1.01*YI
      Z2=.3*ZI
      IF(YI .EQ. 0.) Y2=DSMALL
C      IF(ZI .EQ. 0.) Z2=DSMALL
C *** COMPUTE THE STREAMLINE DEFLECTIONS FOR THE FIRST GUESSES
C       ETA IS THE VERTICAL DEFLECTION, DEL IS THE LATERAL DEFLECTION
C       H1 IS ELEVATION OF SURFACE BENEATH THE FIRST-GUESS POSITION
C       H2 IS ELEVATION OF SURFACE BENEATH THE SECOND-GUESS POSITION
      CALL FLOW(X,Y1,Z1,ETA1,DEL1,THI,TLI,TU,ALF,FR)
      H1=HH*HILHGT(X,Y1)
      CALL FLOW(X,Y2,Z2,ETA2,DEL2,THI,TLI,TU,ALF,FR)
      H2=HH*HILHGT(X,Y2)
      NITER=0
      MXITER = 500
      FRSAVE = FR
      FRINCR = 0.5 * FR
C
C *** ITERATE UNTIL THE STREAMLINE IS FOUND TO WITHIN CRIT * HH
C *** NEW GUESS
C
10    DENY=Y1-Y2+DEL2-DEL1
      IF(DENY .EQ. 0.) THEN
         Y3=Y2
      ELSE
         Y3=(Y1*(YI+DEL2)-Y2*(YI+DEL1))/DENY
C *** RESTRICT RATE OF CHANGE OF POSITION ESTIMATE
         STEP=Y3-Y2
         IF(ABS(STEP) .GT. YSTEP) Y3=Y2+SIGN(YSTEP,STEP)
      ENDIF
      DENZ=Z1+H1-ETA1+ETA2-Z2-H2
C      IF(DENZ .EQ. 0.) THEN
C         Z3=Z2
      Z2MZ1=Z2-Z1
      IF (ABS(Z2MZ1) .LE. SMALL .OR. ABS(DENZ) .LE. SMALL) THEN
         Z3=ZI*Z2/(Z2+H2-ETA2)
      ELSE
         Z3=(Z1*(ZI+ETA2-H2)-Z2*(ZI+ETA1-H1))/DENZ
C *** RESTRICT RATE OF CHANGE OF POSITION ESTIMATE
         STEP=Z3-Z2
         IF(ABS(STEP) .GT. ZSTEP) Z3=Z2+SIGN(ZSTEP,STEP)
      ENDIF
      NITER=NITER+1
C
C     IF ITERATION DOES NOT CONVERGE, ADJUST FR UPWARD IN STEPS
C     UNTIL CONVERGE OCCURS
C
      IF(NITER .GT. MXITER) THEN
          FR = FR + FRINCR
          IF(FR .GT. 10.0) THEN
C              STOP 'ENDLESS LOOP IN PATH' -- CHANGED 2/11/91 DJB
            ILOOP = 1
            RETURN
          ENDIF
          MXITER = 100
          NITER = 0
      ENDIF
C     COMPUTE QUANTITIES NOW FOR THE NEW GUESS.
      CALL FLOW(X,Y3,Z3,ETA3,DEL3,THI,TLI,TU,ALF,FR)
      H3=HH*HILHGT(X,Y3)
C *** COMPUTE THE ERROR IN THE SOLUTION SCALED BY HH
      ERRY=ABS((Y3-DEL3-YI)/LY)
      ERRZ=ABS((Z3+H3-ETA3-ZI)/HH)
C
C *** QUIT IF ERROR CRITERIA SATISFIED.
      IF(ERRY .LT. CRIT .AND. ERRZ .LT. CRIT) GO TO 50
      Y1=Y2
      Z1=Z2
      H1=H2
      ETA1=ETA2
      DEL1=DEL2
      Y2=Y3
      Z2=Z3
      H2=H3
      ETA2=ETA3
      DEL2=DEL3
      GO TO 10
              
   50 CONTINUE
      FR = FRSAVE
C
C *** COMPUTE T-FACTORS: IN MOST CASES, TL IS A RESIDUAL
C
      TH=1./THI
      TL=THI/TU
C
C     IF A LONG RIDGE, CONSIDER CALCULATED VALUE OF TL.  IF ASPECT RATIO
C     IS 3 OR LESS, KEEP TL AS A RESIDUAL.  IF ASPECT RATIO EXCEEDS 3,
C     USE A COMBINATION OF RESIDUAL VALUE AND CALCULATED VALUE AS A
C     FUNCTION OF ASPECT RATIO
C
      ASPECT = LY/LX
      IF(ASPECT.GT.3.0 .AND. ABS(1.0 - TLI) .LT. 0.1) THEN
          TLRES = TL
          TLCALC = 1.0/TLI
          WEIGHT = ((ASPECT - 3.0)/ASPECT) ** 0.25
          TL = TLCALC * WEIGHT + TLRES * (1.0 - WEIGHT)
          TU = THI/TL
      ENDIF
      RETURN
      END
