        SUBROUTINE PSRCE(SND, CSD, IZZ, Y, XP, XS, YS, XR,YR)
C-----------------------------------------------------------------------
C PURPOSE:  THIS ROUTINE COMPUTES DOWNWIND AND CROSSWIND DISTANCES TO
C           A RECEPTOR FROM THE PLUME AXIS
C
C ARGUMENTS
C  PASSED:
C       SND     REAL    SINE OF WIND DIRECTION ANGLE (DEG. FROM N)
C       CSD     REAL    COSINE OF WIND DIRECTION ANGLE
C
C  RETURNED:
C       IZZ     INT     = 1 IF AN UPWIND RECEPTOR, OTHERWISE 0
C       Y       REAL    CROSSWIND DISTANCE FROM PLUME AXIS, M
C       XP      REAL    DOWNWIND DISTANCE FROM SOURCE ALONG PLUME
C                               TRAJECTORY, M
C I/O: NONE
C
C EXTERNAL ROUTINES: NONE
C
C CALLING ROUTINES: SEQMOD  DAYCALC
C
C INTRINSIC FUNCTIONS: SQRT
C
C COMMON BLOCKS: PASVAL
C
C-----------------------------------------------------------------------
C
C      INCLUDE 'PARAMS.INC'
C      INCLUDE 'PASVAL.CMN'
C
        REAL            SND, CSD, X1, XP, XR, XS, Y, Y1, YR, YS     
        INTEGER         IZZ
        INTEGER         NO,     YES
C
        DATA            NO/0/
        DATA            YES/1/
C
        X1 = (XS-XR)
        Y1 = (YS-YR)
C
C
C       XP = DOWNWIND DISTANCE ALONG PLUME PATH TO RECEPTOR
C       Y = DISTANCE PERPENDICULAR TO PLUME CENTERLINE TO RECEPTOR
C
        XP = Y1*CSD + X1*SND
        Y = X1*CSD - Y1*SND
C
C       IF IZZ = YES, RECEPTOR IS UPWIND
C
        IF( XP .LE. 0.) THEN
            IZZ = YES
          ELSE
            IF( XP .LT. 10.) XP = 10.
            IZZ = NO
        ENDIF
        RETURN
        END
