        SUBROUTINE RDSFC(EOR)
C-----------------------------------------------------------------------
C PURPOSE: THIS ROUTINE READS THE CURRENT HOUR'S SURFACE DATA
C
C ARGUMENTS
C  PASSED: NONE
C  RETURNED:
C       EOR     INT     END OF FILE INDICATOR 0=NO, 1=YES
C
C I/O:
C   INPUT       UNIT=INSFC     FILE 'SURFACE'
C
C CALLING ROUTINES: SEQMOD
C
C EXTERNAL ROUTINES: NONE
C
C INTRINSIC FUNCTIONS: NONE
C
C COMMON BLOCKS: IO     PARAMS  SFCMET  TIME
C-----------------------------------------------------------------------
C
      INCLUDE 'IO.CMN'
      INCLUDE 'PARAMS.CMN'
      INCLUDE 'SFCMET.CMN'
      INCLUDE 'TIME.CMN'
C
        REAL            XMH1, XMH2
        INTEGER         EOR,    NO,     YES
        DATA            NO/0/,  YES/1/
C
C       READ SURFACE DATA FOR CURRENT HOUR
C
        READ(INSFC,*,END=100) KYR,KMO,KDY,KJCD,KHR,XMH1,XMH2,
     2       USTAR0,EL,Z0
C
C       SET MIXING HEIGHT FROM FLAG
        IF(IMIX .EQ. 0 .OR. XMH1 .LE. 0.0) THEN
            XMH = XMH2
          ELSE
            XMH = XMH1
        ENDIF
        IF(XMH.LT.0.0) XMH = 99999.
C
C       COMPUTE WSTAR FOR THIS HOUR
C       SAVE WSTAR IN WSTAR0 FOR COMPARISONS DURING UNSTABLE HOURS
        IF(EL .GT. 0.0) THEN
C           STABLE
            WSTAR = 0.0
          ELSE
C           UNSTABLE
            WSTAR = USTAR0*(XMH/(-0.4*EL))**0.33333
            WSTAR0 = WSTAR
        ENDIF
        EOR = NO
        RETURN
100     EOR = YES
        JCD = 99999
        RETURN
        END
