        SUBROUTINE SIGB(DELH,   SIGYB,  SIGZB)
C-----------------------------------------------------------------------
C PURPOSE: CALCULATE SIGMA-Y AND SIGMA-Z CONTRIBUTION DUE TO BUOYANCY
C               INDUCED GROWTH
C
C ASSUMPTIONS: THE CONTRIBUTION DUE TO BOUYANCY IS A FUNCTION OF THE
C               PLUME RISE AND IS THE SAME FOR SIGMA-Y AND SIGMA-Z.
C
C ARGUMENTS:
C   PASSED:
C       DELH    REAL    PLUME RISE ABOVE STACK TOP (M)
C   RETURNED:
C       SIGYB   REAL    SIGMA-Y DUE TO BUOYANCY
C       SIGZB   REAL    SIGMA-Z DUE TO BUOYANCY
C
C I/O: NONE
C
C CALLING ROUTINES: SEQMOD
C
C EXTERNAL ROUTINES: NONE
C
C-----------------------------------------------------------------------
C
        REAL            DELH,   SIGYB,  SIGZB
C                     0.2857143 = 1/3.5
C
C       EQN 31 OF CTDMPLUS USER'S GUIDE
C
        SIGYB = (DELH*0.2857143)
        SIGZB = SIGYB
        RETURN
        END
