      REAL FUNCTION SPEED(Z)
C-----------------------------------------------------------------------
C  DESCRIPTION: COMPUTES THE UNPERTURBED FLOW SPEED AT HEIGHT Z
C               ABOVE HC BASED ON A LINEAR SPEED GRADIENT ALF AND THE
C               SPEED AT PLUME HEIGHT.
C
C  ARGUMENTS:
C   PASSED:
C       Z       REAL    HEIGHT (M)
C
C I/O: NONE
C
C CALLING ROUTINES: FLOW
C
C EXTERNAL ROUTINES: NONE
C
C INTRINSIC FUNCTIONS: NONE
C
C INCLUDE FILES: NONE
C
C COMMON BLOCKS: VARS
C----------------------------------------------------------------------
C
      INCLUDE   'VARS.CMN'

C  DEFINE ARGUMENTS
      REAL  Z

      SPEED = US + ALF * ( Z + HC - HPL )
      IF( SPEED .LT. 1.0 ) SPEED = 1.0
C
      RETURN
      END
