       SUBROUTINE SUN(JCD,TZONE,BLAT,ALONG,HRRISE,HRSET)
C-----------------------------------------------------------------------
C PURPOSE:
C      SUN WILL COMPUTE THE HOURS OF SUNRISE AND SUNSET AT A GIVEN
C      LOCATION FOR A GIVEN DAY OF THE YEAR.
C
C ARGUMENTS
C  PASSED:
C       JCD     INT     JULIAN DAY  (INPUT)
C       TZONE   REAL    TIME ZONE (# OF HOURS BEFORE GMT, > 0 IN WEST)
C       BLAT    REAL    LATITUDE, POSITIVE NORTH
C       ALONG   REAL    LONGITUDE, POSITIVE WEST
C
C  RETURNED:
C       HRRISE  REAL    HOUR OF SUNRISE (WITH FRACTIONAL PART)
C       HRSET   REAL    HOUR OF SUNSET (WITH FRACTIONAL PART)
C
C
C EXTERNAL ROUTINES: NONE
C
C CALLING ROUTINES: SEQMOD
C
C INTRINSIC FUNCTIONS: FLOAT SIN COS TAN ASIN ACOS
C
C REFERENCES: ADAPTED FROM EPA PREPROCESSOR "RAMMET"
C
C-----------------------------------------------------------------------
C
C
       INTEGER JCD
       REAL ALAT, ALONG, AMM, BLAT, D, DAY, DELTA, DR, DR2, H2, 
     1      HRRISE, HRSET, SIGMA, TZONE
C
       DAY=FLOAT(JCD)
       ALAT = BLAT/57.29578
C
       D = DAY/365.242 * 360.
       DR = D/57.29578
       DR2 = 2.0 * DR
       SIGMA = D + 273.9348 + 1.914827*SIN(DR) - 0.079525*COS(DR) +
     X 0.019938*SIN(DR2) - 0.00162*COS(DR2)
       AMM = 12.0 + 0.12357*SIN(DR) - 0.004289*COS(DR) +
     X 0.153809*SIN(DR2) + 0.060783*COS(DR2)
C                   0.39785=SIN(23.44383)
       DELTA = ASIN(0.39785*SIN(SIGMA/57.29578))
       H2 = ACOS(-TAN(ALAT)*TAN(DELTA)) * 57.29578
       HRRISE = AMM - (H2 - ALONG)/15. - TZONE
       HRSET = AMM + (H2 + ALONG)/15. - TZONE
C
       RETURN
       END
