        SUBROUTINE TOPN(CHI, NREC, IFLAG, GGSS)
C-----------------------------------------------------------------------
C SUBROUTINE: TOPN
C
C PURPOSE: INITIALIZE, UPDATE OR PRINTOUT TOP N TABLE. N IS DEFINED BY
C       THE PARAMETER MAXTOP IN 'PARAMS.INC'
C
C ARGUMENTS:
C    PASSED:
C       CHI     REAL    CONCENTRATION ARRAY
C       NREC    INT     NUMBER OF RECEPTORS
C       IFLAG   INT     -1 = INITIALIZE ARRAY
C                        0 = CHECK TOP 5
C                       +1 = PRINT RESULTS
C       GGSS    CHAR    CHARACTER 'G' OR 'S' FOR CONCENTRATION UNITS
C    RETURNED: NONE
C
C I/O:
C    INPUT: NONE
C
C    OUTPUT: TOP5 TABLE TO UNIT IOUT
C
C CALLING ROUTINES: SEQMOD  INPAR
C
C EXTERNAL ROUTINES: PAGE
C
C INTRINSIC FUNCTIONS: MOD
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: IO.CMN TIME.CMN TOP.CMN
C
C-----------------------------------------------------------------------
C
        INCLUDE        'PARAMS.INC'
        INCLUDE        'IO.CMN'
        INCLUDE        'TIME.CMN'
        INCLUDE        'TOP.CMN'
C
C       DEFINE ARGUMENTS
        INTEGER NREC, IFLAG
        REAL    CHI(NREC)
        CHARACTER       GGSS
C
C       DEFINE LOCAL VARIABLES
        INTEGER I, IT, J, NR, YES, NRTOP(MAXTOP), KONTIN
        CHARACTER CHR1(MAXTOP,MAXREC), STAR, BLANK
        CHARACTER*7 CONTIN(2)
        DATA YES/1/, KONTIN/1/
        DATA STAR/'*'/, BLANK/' '/, CONTIN/'       ','(CONT.)'/
C
C       START
        IF( IFLAG ) 100, 200, 300
C
C       INITIALIZE TOP ARRAY
100     DO 110 I=1,MAXTOP
            TOPTOP(I) = -9999.
            DO 120 J=1,MAXREC
                CTOP(I,J) = -999.
                TOPTIM(I,J) = 0
120         CONTINUE
110     CONTINUE
        GO TO 900
C
C       CHECK FOR TOP MAXTOP AT EACH RECEPTOR
200     DO 210 NR=1,NREC
            IF(CHI(NR) .GT. CTOP(MAXTOP,NR)) THEN
                DO 220 IT = MAXTOP-1, 1, -1
                    IF( CHI(NR) .LE. CTOP(IT,NR) ) GOTO 230
                    CTOP(IT+1,NR) = CTOP(IT,NR)
                    TOPTIM(IT+1,NR) = TOPTIM(IT,NR)
                    IF(IT .EQ. 1) THEN
                        CTOP(1,NR) = CHI(NR)
                        TOPTIM(1,NR) = KJCD * 100 + KHR
                        GO TO 240
                    ENDIF
220             CONTINUE
230             CTOP(IT+1,NR) = CHI(NR)
                TOPTIM(IT+1,NR) = KJCD * 100 + KHR
240             CONTINUE
            ENDIF
210     CONTINUE
C
        GO TO 900
C
C       FIND TOP EACH MAXTOP
300     DO  310 I=1,MAXTOP
            DO  320 J=1,NREC
                IF(CTOP(I,J) .GT. TOPTOP(I)) THEN
                        NRTOP(I) = J
                        TOPTOP(I) = CTOP(I,J)
                ENDIF
                CHR1(I,J) = BLANK
320         CONTINUE
310     CONTINUE
        DO  330 I=1,MAXTOP
            CHR1(I,NRTOP(I)) = STAR
330     CONTINUE
C
C       PRINT TOP ARRAY
        DO 350 NR=1,NREC
                IF(MOD(NR,40) .EQ. 1) THEN
                        IF(NR .GT. 1) KONTIN = 2
                        CALL PAGE(YES)
                        WRITE(IOUT,6010) MAXTOP, GGSS, CONTIN(KONTIN)
                ENDIF
                IF(MOD(NR,10) .EQ. 1) WRITE(IOUT,6020)
                WRITE(IOUT,6030) NR,(CTOP(I,NR),CHR1(I,NR),
     &                  (TOPTIM(I,NR)/100),(MOD(TOPTIM(I,NR),100)),
     &                  I=1,MAXTOP)
350     CONTINUE
C
900     RETURN
C
6010    FORMAT(
     &  ' REC       TOP ',I1,' CONCENTRATIONS [U',A1,'/M**3] AT EACH ',
     &  'RECEPTOR            ',A7,/,
     &  '  #    HIGHEST (JCD,HR)    SECOND (JCD,HR)     THIRD (JCD,HR)',
     &  '    FOURTH (JCD,HR)',/,
     &  ' ---  -----------------  -----------------  -----------------',
     &  '  -----------------')
6020    FORMAT(' ')
6030    FORMAT(1X,I3,4(2X,1PE8.2,A1,'(',I3,',',I2,')'))
        END
