        SUBROUTINE TRANPR(XP,TRISE)
C-----------------------------------------------------------------------
C PURPOSE: THIS ROUTINE CALCULATES THE TRANSITIONAL PLUME RISE
C          FOR THE UNSTABLE CASE.
C
C METHODS:
C
C       THE TRANSITIONAL PLUME RISE IS CALCULATED WITH THE THIRD EQUATION
C       OF SUBROUTINE URISE, WHERE XTRANS IS THE MINIMUM OF THE DOWNWIND
C       DISTANCE XP OR THE FINAL PLUME RISE DISTANCE X.
C               EQN (3)  1.6*(FB*X*X)**0.3333/U,
C                      X =119*F**0.4 IF FB>55; X = 49*F**0.625 IF FB<=55
C
C       THE ABOVE EQUATION CORRESPONDS TO EQUATION 11 IN THE 
C       CTDMPLUS USER'S GUIDE.
C
C ASSUMPTIONS:
C       - CONVERGENCE IS REACHED WHEN TWO CONSECUTIVE ESTIMATES ARE
C         WITHIN 1%
C       - MINIMUM WIND SPEED IS 0.1 M/S
C
C ARGUMENTS:
C   PASSED: NONE
C   RETURNED:
C       RISE    REAL    TRANSITIONAL PLUME RISE ABOVE RECEPTOR.
C
C COMMON: STACK  SFCMET VARS
C
C CALLING ROUTINES: SEQMOD  DAYCALC
C
C EXTERNAL ROUTINES:
C       GETWS - FUNCTION WHICH RETURNS THE WIND SPEED AT HEIGHT Z
C       PICK4 - SUBROUTINE WHICH RETURNS THE MINIMUM VALUE OF FOUR
C               VARIABLES AND A FLAG INDICATING WHICH VARIABLE WAS
C               PICKED
C
C INTRINSIC FUNCTIONS: ABS
C
C-----------------------------------------------------------------------
C
C
      INCLUDE   'STACK.CMN'
C      INCLUDE   'SFCMET.CMN'
      INCLUDE   'VARS.CMN'
C
C   DEFINE ARGUMENTS
        REAL     XP, TRISE

C       DEFINE LOCAL VARIABLES
        REAL    A, UP, DHO, DH2, DHG, ERROR
        INTEGER ITR, MAXITR
C
        DATA    MAXITR/5/
        DATA    ERROR/ 0.01/
C
        US = AMAX1(USTKTP,0.1)
C
C       FOR BUOYANT PLUME RISE, THE WIND SPEED USED IN THE CALCULATION
C       IS THAT HALFWAY BETWEEN THE STACK-TOP HEIGHT AND THE LATEST
C       PLUME HEIGHT ESTIMATE.  SINCE PLUME RISE (DHG) IS A
C       FUNCTION OF THE WIND SPEED USED IN THE COMPUTATION, AN ITERATIVE
C       SCHEME MUST BE USED.  FOR THE FIRST GUESS, THE WIND SPEED USED
C       IS THAT AT STACK-TOP HEIGHT (US).  A MAXIMUM OF 5 ITERATIONS IS
C       ATTEMPTED.  FOR EACH ITERATION, THE PLUME RISE (FOR GETTING
C       PLUME RISE MIDPOINT METEOROLOGICAL VARIABLES) IS SET TO THE
C       AVERAGE OF THE PREVIOUS 2 ESTIMATES.  DH0 IS THE SECOND OLDEST
C       GUESS, WHILE DH<1,2,3,4> IS THE MOST RECENT GUESS.
C
C------------EQUATION (3)

        UP = US
        DHG = 1.6*(FB*XP*XP)**0.33333/UP
        DHO = DHG
        UP=GETWS(HS+0.5*DHG)
        DO 115 ITR=1,MAXITR
            DH2 = 1.6*(FB*XP*XP)**0.33333/UP
            IF(ABS(DH2-DHG) .LT. ERROR*DH2) GO TO 120
            IF(ITR .EQ. 1 .AND. DH2 .GT. DHG) GO TO 120
            UP=GETWS(HS+0.5*DH2)
            DHG=0.5*(DHO+DH2)
            DHO = DH2
            IF(UP .LE. 0.0) GO TO 120
115     CONTINUE
120     TRISE = DHG
C
C  STACK-TIP DOWNWASH SECTION
C
        A = 2.0*AMAX1(0.0,1.5-VS/USTKTP)
        TRISE = TRISE - A*DS - SQRT(8.*A/3.14159) * DS
        RETURN
        END

