        SUBROUTINE URISE(DELH,  IRISE, USTKTP, US)
C-----------------------------------------------------------------------
C SUBROUTINE: URISE
C
C PURPOSE: THIS ROUTINE CALCULATES FINAL PLUME RISE FOR THE UNSTABLE
C               CASE ( L < 0 ).
C
C METHODS:
C
C       IF THE BUOYANCY FLUX (FB) IS ZERO THEN THE MOMENTUM RISE IS
C               EQN (1)  3*D*VS/U
C       OTHERWISE THE PLUME RISE IS THE MINIMUM VALUE FROM THE FOLLOWING
C       EQUATIONS:
C               EQN (2)  1.3*FB/(U*USTAR**2) * (1+HS/DELH)**0.6667
C               EQN (3)  1.6*(FB*X*X)**0.3333/U,
C                      X =119*F**0.4 IF FB>55; X = 49*F**0.625 IF FB<=55
C               EQN (4)  4.3*(FB/U)**0.6 * HSTAR**-0.4
C               EQN (5)  FB/(U*0.4*WSTAR)**2 * (1+2*HS/DELH)**2
C
C       IN THE CTDM USER'S GUIDE, THE ABOVE EQUATIONS (1-5) CORRESPOND
C       TO EQUATIONS 10a, 14, 11, 12, AND 13, RESPECTIVELY.
C
C ASSUMPTIONS:
C       - CONVERGENCE IS REACHED WHEN TWO CONSECUTIVE ESTIMATES ARE
C         WITHIN 1%
C       - MINIMUM WIND SPEED IS 0.1 M/S
C
C ARGUMENTS:
C   PASSED: NONE
C   RETURNED:
C       DELH    REAL    FINAL PLUME RISE ABOVE STACK TOP (M)
C       IRISE   INT     FLAG INDICATING WHICH PLUME RISE EQUATION WAS
C                               USED TO CALCULATE DELH
C
C COMMON: STACK  SFCMET VARS
C
C CALLING ROUTINES: SEQMOD
C
C EXTERNAL ROUTINES:
C       GETWS - FUNCTION WHICH RETURNS THE WIND SPEED AT HEIGHT Z
C       PICK4 - SUBROUTINE WHICH RETURNS THE MINIMUM VALUE OF FOUR
C               VARIABLES AND A FLAG INDICATING WHICH VARIABLE WAS
C               PICKED
C
C INTRINSIC FUNCTIONS: ABS
C
C-----------------------------------------------------------------------
C
        REAL            DELH, DHO
        INTEGER         IRISE, ITR
C
      INCLUDE   'STACK.CMN'
      INCLUDE   'SFCMET.CMN'
C      INCLUDE   'VARS.CMN'
C
C       DEFINE LOCAL VARIABLES
        REAL    HSTAR,  HSTAR4, WD,     US,     UP,     USTAR2,
     1          DH1,    DH2,    DH3,    DH4,    DHG,    VONKAR, 
     2          ERROR,  USTKTP
        INTEGER MAXITR
C
        DATA    MAXITR/5/
        DATA    ERROR/ 0.01/
        DATA    VONKAR/ 0.40/
C
        US = AMAX1(USTKTP,0.1)
        USTAR2=USTAR0*USTAR0
C TEST FOR MOMENTUM RISE
        IF(FB .GT. 0.0) GO TO 100
C------------EQUATION (1)
        DELH=3.0*DS*VS/US
        IRISE=1
        RETURN
C
C       FOR BUOYANT PLUME RISE, THE WIND SPEED USED IN THE CALCULATION
C       IS THAT HALFWAY BETWEEN THE STACK-TOP HEIGHT AND THE LATEST
C       PLUME HEIGHT ESTIMATE.  SINCE FINAL PLUME RISE (DHG) IS A
C       FUNCTION OF THE WIND SPEED USED IN THE COMPUTATION, AN ITERATIVE
C       SCHEME MUST BE USED.  FOR THE FIRST GUESS, THE WIND SPEED USED
C       IS THAT AT STACK-TOP HEIGHT (US).  A MAXIMUM OF 5 ITERATIONS IS
C       ATTEMPTED.  FOR EACH ITERATION, THE PLUME RISE (FOR GETTING
C       PLUME RISE MIDPOINT METEOROLOGICAL VARIABLES) IS SET TO THE
C       AVERAGE OF THE PREVIOUS 2 ESTIMATES.  DH0 IS THE SECOND OLDEST
C       GUESS, WHILE DH<1,2,3,4> IS THE MOST RECENT GUESS.
C
C------------EQUATION (2)
100     UP=US
        DHG=1.3*FB/(UP*USTAR2)
        DHO = DHG
        UP=GETWS(HS+0.5*DHG)
        DO 110 ITR = 1,MAXITR
            DH1=1.3*FB/(UP*USTAR2)*(1.0+HS/DHG)**0.6666667
            IF(ABS(DH1-DHG) .LT. ERROR*DH1) GO TO 112
            UP=GETWS(HS+0.5*DH1)
            DHG=0.5*(DHO+DH1)
            DHO = DH1
110     CONTINUE
112     DH1 = DHG
C------------EQUATION (3)
        UP = US
        DHG = 1.6*(FB*XFIN*XFIN)**0.33333/UP
        DHO = DHG
        UP=GETWS(HS+0.5*DHG)
        DO 115 ITR=1,MAXITR
            DH2 = 1.6*(FB*XFIN*XFIN)**0.33333/UP
            IF(ABS(DH2-DHG) .LT. ERROR*DH2) GO TO 120
            IF(ITR .EQ. 1 .AND. DH2 .GT. DHG) GO TO 120
            UP=GETWS(HS+0.5*DH2)
            DHG=0.5*(DHO+DH2)
            DHO = DH2
            IF(UP .LE. 0.0) GO TO 120
115     CONTINUE
120     DH2=DHG
C------------EQUATION (4)
        UP=US
        HSTAR = -USTAR0**3/(VONKAR*EL)
        HSTAR4 = 1.0/(HSTAR**0.40)
        DHG=4.3*(FB/UP)**0.60*HSTAR4
        DHO = DHG
        UP=GETWS(HS+0.5*DHG)
        DO 130 ITR=1,MAXITR
            DH3=4.3*(FB/UP)**0.60*HSTAR4
            IF(ABS(DH3-DHG) .LT. ERROR*DH3) GO TO 140
            UP=GETWS(HS+0.5*DH3)
            DHG=0.5*(DHO+DH3)
            DHO = DH3
130     CONTINUE
        DH3 = DHG
C------------EQUATION (5)
140     UP=US
        WD=0.4*WSTAR
        DHG=FB/(UP*WD*WD)
        DHO = DHG
        DO 150 ITR = 1,MAXITR
            DH4=FB/(UP*WD*WD)*(1.0+2.0*HS/DHG)**2
            IF(ABS(DH4-DHG) .LT. ERROR*DH4) GO TO 160
            UP=GETWS(HS+0.5*DH4)
            DHG = (DHO+DH4)/2.0
            DHO = DH4
150     CONTINUE
        DH4 = DHG
C
C       PICK MINIMUM RISE FROM EQUATIONS (2), (3), (4), (5)
C
160     CALL PICK4(DH1, DH2, DH3, DH4, DELH, IRISE)
        IRISE=IRISE+1
C
        RETURN
        END
