      SUBROUTINE WRAPIN(TMU,TNU,SMU,SNU,XSMAJ,YSMAJ)
C----------------------------------------------------------------------
C PURPOSE: COMPUTES VARIOUS QUANTITIES DESCRIBING FLOW AROUND
C               AN ELLIPSE.
C
C ARGUMENTS:
C    PASSED:
C       TMU,TNU         REAL    ELLIPTIC COORDINATES OF TOWER
C       SMU,SNU	        REAL    ELLIPTIC COORDINATES OF SOURCE
C     XSMAJ,YSMAJ       REAL    CARTESIAN COORDINATES OF SOURCE (M)
C                               (X-AXIS LIES ALONG MAJOR AXIS)
C    RETURNED:          NONE
C
C I/O: NONE
C
C CALLING ROUTINES: SEQMOD
C
C EXTERNAL ROUTINES: NONE
C
C INTRINSIC FUNCTIONS: ABS ATAN COS COSH SIGN SIN SINH SQRT TAN TANH
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: CONST  PARAMS  PASVAL  PASW  VARS
C
C-----------------------------------------------------------------------
C
      INCLUDE   'PARAMS.INC'
      INCLUDE   'CONST.CMN'
C      INCLUDE   'PARAMS.CMN'
      INCLUDE   'PASVAL.CMN'
      INCLUDE   'PASW.CMN'
      INCLUDE   'VARS.CMN'
C
C       DEFINE ARGUMENTS
      REAL      TMU, TNU, SMU, SNU, XSMAJ, YSMAJ
C
C       DEFINE LOCAL VARIABLES
      REAL      ABSALF, ANG, CAL, CB, CHECK, CTMU,
     *          CTNU, DUM1, DUM2, SAL, SB, SDUM, SFAC,
     *          SNUAL, SSMU, SSNU, SSNUAL, SSRC, STMU, STNU, STNUAL,
     *          TADEN, TALPHA, TANUM, TDUM, TPHIT, TSMU, TTMU, TTNU
C
      AXRAT=AAXW/BAXW
      TTNU=TAN(TNU)
      TTMU=TANH(TMU)
      CTNU=COS(TNU)
      CTMU=COSH(TMU)
      STNU=SIN(TNU)
      STMU=SINH(TMU)
      TSMU=TANH(SMU)
      SSNU=SIN(SNU)
      SSMU=SINH(SMU)
      DUM1=TTNU/CTMU**2
      DUM2=TTMU/CTNU**2
C  ANG IS WIND DIR. (AT TOWER) REL. TO MAJOR AXIS; RANGE -180 TO 180
      ANG=THTAH-THTA
      IF(ANG .LT. -180.) ANG=ANG+360.
      IF(ANG .GT. 180.) ANG=ANG-360.
      ANG=ANG*DTOR
C  FIND TANGENT OF WIND DIR MEAS AT TOWER RELATIVE TO MAJOR AXIS (CCW)
      TPHIT=TAN(ANG)
C  FIND ALPHAW (SEE BATCHELOR FOR CONVENTIONS)....EQN. A-50
      TANUM = (DUM1+TPHIT*DUM2)/AXRAT+(TTNU**2+TTMU**2)*TPHIT
      TADEN = (1.+(TTMU*TTNU)**2)/AXRAT+DUM2+TPHIT*DUM1
      IF(TADEN .NE. 0.0) THEN
          TALPHA = -TANUM/TADEN
          ALPHAW = ATAN(TALPHA)
        ELSE
          ALPHAW = PIBY2
      ENDIF
C  MAKE SURE THAT DOT PRODUCT OF VECTORS ALONG ANG AND -ALPHAW IS POS.
      CHECK=COS(ANG)*COS(-ALPHAW)+SIN(ANG)*SIN(-ALPHAW)
      IF(CHECK .LT. 0.) ALPHAW=ALPHAW-SIGN(PI,ALPHAW)
C  FIND SPEED AT INFINITY (SINF)....EQN. A-51
      STNUAL=SIN(TNU+ALPHAW)
      TDUM=((AXRAT**2-1.)*STNU**2+1.)/STMU**2+AXRAT**2+1.+2.*AXRAT/TTMU
      TDUM=TDUM/(1.+(STNUAL/STMU)**2)
      SINF=UV*SQRT(TDUM)/(AXRAT+1.)
C  FIND SPEED AT THE SOURCE
      SNUAL=SNU+ALPHAW
      IF(ABS(SNUAL) .GT. PI) SNUAL=SNUAL-SIGN(TWOPI,SNUAL)
      SSNUAL=SIN(SNUAL)
      SDUM=((AXRAT**2-1.)*SSNU**2+1.)/SSMU**2+AXRAT**2+1.+2.*AXRAT/TSMU
      SDUM=(1.+(SSNUAL/SSMU)**2)/SDUM
      SSRC=UV*SQRT(SDUM*TDUM)
C  FIND VALUE OF STREAMFCN THROUGH SOURCE (PSIHAT=PSI/(SINF(AAXW+BAXW))
C                               ....EQN. A-52
      PSIHAT=-SSMU*SSNUAL
C  APPROX. DISTANCE BETWEEN PSI AND STAGNATION STREAMLINE NEAR SOURCE
      D=ABS(PSIHAT*(AAXW+BAXW)*SINF/SSRC)
C  FIND BETA  ....EQN. A-54
      ABSALF=ABS(ALPHAW)
      BETA=-ALPHAW
      IF(ABS(ABSALF-PIBY2) .GT. SMALL .AND. ABS(ABSALF-PI) .GT. SMALL
     *   .AND. ABSALF .GT. SMALL) THEN
         BETA=ATAN(-AXRAT*TAN(ALPHAW))
         CHECK=COS(-ALPHAW)*COS(BETA)+SIN(-ALPHAW)*SIN(BETA)
         IF(CHECK .LT. 0.) BETA=BETA-SIGN(PI,BETA)
      ENDIF
      CAL=COS(ALPHAW)
      SAL=SIN(ALPHAW)
      CB=COS(BETA)
      SB=SIN(BETA)
C  PROJECT SPEEDS AT INFINITY, SOURCE, AND TOWER ONTO THE BETA-LINE
      SFAC = -1.0 / COS(ANG-BETA)
      SINFBE=SINF*SFAC
      UVBETA=UV*SFAC
C  FIND THE X-BETA COORD OF THE STAG. PT. AND THE SOURCE
      XOBETA=AAXW*CAL*CB-BAXW*SAL*SB
      XSBETA=XSMAJ*CB+YSMAJ*SB
C  CALCULATE THE DISTANCE TO THE IMPINGEMENT POINT
      SOBETA=XOBETA-XSBETA
C  IF THE SOURCE IS INSIDE THE ELLIPSE, MOVE IT OUTSIDE FOR TRAVEL TIME
C  CALCULATIONS ONLY
C  SAVE THE UNMODIFIED VALUE FOR XSBETA
      XSBSAV = XSBETA
      IF (SMU .LT. 0) THEN
        XSBETA = XOBETA * 1.01
        SOBETA = -XOBETA * 0.01
      ENDIF
      SO = SOBETA / SFAC
      RETURN
      END
