
      SUBROUTINE UTM2LL( X, Y, Z, LON, LAT )

C***********************************************************************
C Version "@(#)$Header$"
C EDSS/Models-3 I/O API.
C Copyright (C) 1992-2002 MCNC and Carlie J. Coats, Jr., and
C (C) 2003 Baron Advanced Meteorological Systems
C Distributed under the GNU LESSER GENERAL PUBLIC LICENSE version 2.1
C See file "LGPL.txt" for conditions of use.
C.........................................................................
C  subroutine body starts at line  108
C
C  FUNCTION:
C     Convert UTM zone-Z coordinates X-Y to LAT-LON coords
C
C  PRECONDITIONS REQUIRED:  none
C
C  SUBROUTINES AND FUNCTIONS CALLED:
C       USGS National Mapping Division General Cartographic Transformation
C       Package, routine GTPZ0()
C
C  REVISION  HISTORY:
C       Prototype 6/1995 by CJC, adapted from UAM EPS MAPUTG() 
C       X,Y are now in meters.
C       Version 10/1995 uses GTPZ0()
C       Version 4/2003 by Carlie J. Coats, Jr., BAMS:  support for 
C       additional (non-GRS80) spheres, via INITSPHERES/SPHEREDAT
C***********************************************************************

      IMPLICIT NONE


C...........   ARGUMENTS:

      REAL      X       !  UTM easting  in meters
      REAL      Y       !  UTM northing in meters
      INTEGER   Z       !  UTM zone
      REAL      LON     !  East longitude in decimal degrees
      REAL      LAT     !  North latitude in decimal degrees

CC...........   PARAMETERS:
C
C      REAL*8      PI 
C      REAL*8      RPI180
C      PARAMETER ( PI     = 3.14159 26535 89793 23846 26433 83279D0 ,
C     &            RPI180 = 180.0D0 / PI )


C...........   External Functions

        INTEGER         INIT3           !  from M3IO
        LOGICAL         INITSPHERES, SPHEREDAT
        EXTERNAL        INIT3, INITSPHERES, SPHEREDAT


C.......   LOCAL VARIABLES:
C.......   Arguments for GTPZ0:

      REAL*8            CRDIN( 2 )      !  input coordinates x,y
      INTEGER           INSYS           !  input projection code
      INTEGER           INZONE          !  input utm zone, etc.
      REAL*8            TPARIN( 15 )    !  input projection parameters
      INTEGER           INUNIT          !  input units code
      INTEGER           INSPH           !  spheroid code
      INTEGER           IPR             !  error print flag
      INTEGER           JPR             !  projection parameter print flag
      INTEGER           LEMSG           !  error message unit number
      INTEGER           LPARM           !  projection parameter unit number
      REAL*8            CRDIO( 2 )      !  output coordinates x,y
      INTEGER           IOSYS           !  output projection code
      INTEGER           IOZONE          !  output utm zone, etc.
      REAL*8            TPARIO( 15 )    !  output projection parameters
      INTEGER           IOUNIT          !  output units code
      INTEGER           LN27            !  NAD1927 file unit number
      INTEGER           LN83            !  NAD1983 file unit number
      CHARACTER*128     FN27            !  NAD1927 file name
      CHARACTER*128     FN83            !  NAD1983 file name
      INTEGER           LENGTH          !  NAD* record-length
      INTEGER           IFLG            !  error flag

C...........   SAVED LOCAL VARIABLES and their descriptions:
C...........   NOTE:  the ANSI standard requires the use of SAVE statements
C...........   for variables which must retain their values from call to call.

        LOGICAL         FIRSTIME
        DATA            FIRSTIME / .TRUE. /

C.......   Error codes for GTPZ0:

      CHARACTER*64      MESG( 9 )
      DATA              MESG /
     &  'Illegal input system code INSYS',
     &  'Illegal output system code IOSYS',
     &  'Illegal input unit code INUNIT',
     &  'Illegal output unit code IOUNIT',
     &  'Inconsistent unit and system codes for input',
     &  'Inconsistent unit and system codes for output',
     &  'Illegal input zone code INZONE',
     &  'Illegal output zone code IOZONE',
     &  'Projection-specific error' /

        SAVE   FIRSTIME, MESG


C***********************************************************************
C   begin body of subroutine  UTM2LL()

        IF ( FIRSTIME ) THEN
            FIRSTIME = .FALSE.
            IF ( .NOT. INITSPHERES() ) THEN
                CALL M3WARN( 'UTM2LL',0,0,'Bad geodetic sphere info' )
            END IF
        END IF          !  if firstime

C.......   Set up input arguments for GTPZ0()

        CRDIN( 1 ) = DBLE( X )
        CRDIN( 2 ) = DBLE( Y )
        INSYS  = 1
        INZONE = Z
        INUNIT = 2       !  meters
        INSPH  = 8       !  GRS 1980 spheroid
        IPR    = 0       !  print error messages, if any
        JPR    = 1       !  do NOT print projection parameters
        LEMSG  = INIT3() !  unit number for log file
        LPARM  = LEMSG   !  projection parameters file
        IOSYS  = 0       !  geographic (lat-lon)
        IOUNIT = 4       !  output units: degrees
        
C.......   Set up and call GTPZ0()

        IF ( .NOT.SPHEREDAT( INSPH, TPARIN, TPARIO ) ) THEN
            CALL M3WARN( 'UTM2LL',0,0,'Bad geodetic sphere info' )
        END IF

        CALL GTPZ0( CRDIN, INSYS, INZONE, TPARIN, INUNIT, INSPH, 
     &              IPR, JPR, LEMSG, LPARM, CRDIO, IOSYS, IOZONE, 
     &              TPARIO, IOUNIT, LN27, LN83, FN27, FN83, LENGTH, 
     &              IFLG )

        IF ( IFLG .NE. 0 ) THEN
            IFLG = MAX( MIN( 9, IFLG ), 1 )     !  trap between 1 and 9
            CALL M3WARN( 'UTM2LL', 0,0, MESG( IFLG ) )
        END IF

C.......   Decode output arguments for GTPZ0()

      LON = SNGL( CRDIO( 1 ) )
      LAT = SNGL( CRDIO( 2 ) )


        RETURN
        END

