#!/bin/bash
if ( [ "$1" == "-h" ] || [ "$1" == "--help" ] ) ; then
    echo "Usage: compile_netcdf_windows.sh"
    echo "Used to download and compile the netCDF libraries under MinGW, for Windows"
    exit
fi

# Set the version of netCDF to get/compile.  3.6.x and 4.1.[23] did not compile
# cleanly (with no further user intervention) under MinGW 20110802.

ver=4.1.1

# Make sure we have wget in the MinGW environment

if [ ! -e /bin/wget.exe ]; then
    mingw-get install msys-wget
fi

# Get the tar file from UCAR

if [ ! -e netcdf-$ver.tar.gz ]; then
    echo "Downloading netCDF"
    wget --quiet http://www.unidata.ucar.edu/downloads/netcdf/ftp/netcdf-$ver.tar.gz
fi

# If it's already installed, remove the previous version -- this script is
# supposed to do everything by itself, right out of the box.

if [ -e netcdf-$ver-mingw ]; then
    rm -rf netcdf-$ver-mingw
fi

# Unpack the tar file

echo "Unpacking netCDF"
tar zxf netcdf-$ver.tar.gz
mv netcdf-$ver netcdf-$ver-mingw
cd netcdf-$ver-mingw

# Run configure

echo "Configuring netCDF"
./configure --prefix=$PWD --enable-f90 --disable-cxx --disable-cxx-4 >& netcdf.configure.out 2>&1

# Compile

echo "Compiling netCDF"
make >& netcdf.make.out 2>&1

# Install, though it doesn't really install anything in the MS Windows system

echo "Intalling netCDF"
make install >& netcdf.make.install.out 2>&1
