c     PROGRAM AERSCREEN
c============================================================================
c     Purpose:  To generate screening level concentrations using
c               AERMOD model tools.
c
c     AERSCREEN Workgroup: Jim Haywood, Michigan Department of Environmental Quality
c                          Roger W. Brode, U.S. Environmental Protection Agency (OAQPS)
c                          Karen Wesson, U.S. Environmental Protection Agency (OAQPS)
c                          Bob Paine, ENSR
c                          LLoyd Schulman, TRC
c                          James Thurman, U.S. Environmental Protection Agency (OAQPS)
c
c     Date: September 27, 2007 (07311)
c
c     Description:
c
c     The program interactively generates concentrations for screening
c     purposes.  This program prompts the user for data to run exising AERMOD,
c     AERMAP, and BPIPPRIME programs.  Resulting data is reviewed and sorted
c     to provide the user with conservative, screening level results.
c
c     Similar to previous screening software, this program provides for a
c     single stack.  Building wake effect is considered based on user provided
c     data and BPIPRIME technology.
c
c     Actual terrain data is incorporated using either 7.5 Minute or
c     1-Degree DEM data.  The user must provide refined UTM coordinates.
c     The user must list all DEM files in a text file named "DEMlist.txt"
c     prior to the run.  All DEM files must be fully processed before the run.
c
c     Meteorology data is provided by the MAKEMET program.  This program is
c     provided as a stand-alone program to allow the user to run refined
c     AERMOD in screen mode using worse-case meteorology.
c
c     1-Hour concentration impacts are directly predicted by the AERSCREEN
c     procedure.  Impacts for 3-hour, 8-hour, 24-hour and annual are estimated
c     by ratios derived by running multiple year data set from several
c     locations around the United States.  The ratios are based on 95th
c     percentile.
c
c ===========================================================================
c --- Version 21112
c ---	reset chi to 0 if distance to max concentration < 2 km in invmax	
c ---	add debug statement if shoreline concentration is set t0 0
c ---	initialize ldefault to true
c --- Version 16216
c --- modified module main1 and subroutines readinp, validate, writetolog, metdata,
c --- and makemet2 to allow for the option to adjust surface friction velocity u*
c --- modified subroutine makeinput to remove BETA flag for POINTHOR and POINTCAP
c --- sources
c --- modified subroutine output to output only non-zero minimum building widths
c --- and information about u* adjustment
c --- modified subroutine subsetmet to correct bug related to surface filename
c --- when used in subroutine output
c --- Version 15181
c --- modified subroutine makemet2 to include the prompt not to use the
c --- optional u* adjustment included in MAKEMET version 15181
c --- modified subroutine plumehgt to calculate stable and unstable cases of plume height
c --- and pass the stack top values of potential temperature and lapse rate as well
c --- as the buoyancy and momentum fluxes.
c --- added subroutine recalcplume to calculate effective plume height for fumigation
c --- calculations based on PCALC in AERMOD
c --- allow option to run fumigation options only, and not full AERSCREEN run.
c --- added ustack, hsp, and deltah1 outputs to output file in addition to final pume height
c --- allow variable bpipfile to be bpipprm.inp or user entered BPIPPRIME input file
c --- move system call to bpipprime to subroutine readbpip
c --- remove as many system calls to copy and delete files as possible
c --- created subroutine writeinp to write final AERMOD.INP file to AERSCREEN.INP
c --- and non-default AERSCREEN input file if applicable
c --- assign filenames of maximum concentration file, debug concentration file,
c --- aerscreen output file, and aerscreen logfile in subroutine getoutfil.
c --- no longer perform a system call if non-default names used.
c --- added variables rundate and runtime to module main1 and eliminated local assignments
c --- of those variables in subroutines.
c --- eliminated copy of the MAKEMET output to AERSCREEN.SFC and AERSCREEN.PFL
c --- in subroutine makeinput.  Actual filenames will be used in the AERMOD.INP
c --- file generated by makeinput. Also declared sfcfil and pflfil in main1 module.
c --- corrected bug in writetolog subroutine for flare diameter.  only
c --- diameter in inches was being written to the log file.
c --- added a "debug" option to allow intermediate output from PROBE and
c --- FLOWSECTOR to be written to a text file similar in format to
c --- the maximum concentration by distance file.
c --- modified maximum concentration file to output the diagnonal associated
c --- with maximum concentrations for AREA sources.
c --- added subroutine setdebug for user prompts of debug option
c --- modified subroutine writeout to write to the maximum concentration file
c --- or debug file depending on file unit specified in call statement
c --- added code in subroutine metdata that if user selects option 3
c --- for surface characteristics by accident, hit return to return
c --- to option selection when prompted for filename
c --- modified subroutines validate and writetolog for fumigation
c --- and debug inputs
c --- added subroutine for inversion break-up fumigation
c --- added fumigation and debug inputs in subroutine readinp
c --- added fumigation and debug checks in subroutine checkdat
c --- added subroutine fuminp for user prompts of fumigation data
c --- added character variable quote1 to replace '"' in format statements
c --- modifed subroutine metdata to allow user to enter <return> when
c --- enter the AERSURFACE filename to go back to the surface characteristics
c --- option list
c --- Version 14147
c --- Modified subroutine makeinput to be compatabile with AERMOD version 14134
c --- by removing the blank line at the top of AERMOD.INP.
c --- Note:  Older AERSCREEN.INP files will continue to work with this version
c --- corrected assignment for discrete receptors from discdat='N' to discflag='N' to
c --- assign to correct variable type in subroutine readinp
c --- of AERSCREEN.
c --- created new variable refdist for use in subroutines makegrid and maketerrain to replace
c --- variable numpt in the refine receptor stage.  This was done to avoid
c --- confusion with the use of numpt in earlier calculations in makegrid.
c --- refdist is also set to the probe distance if refdist exceeds the probe
c --- distance.
c --- modified routine findmax to read AERMOD version number correctly
c --- independent of AERMOD version #.
c --- Version 11126
c --- Modified subroutine maketerrain to accomodate new 12-character source ids
c --- Modified subroutine readinp to set discflag='N' and discfile='NA' when
c --- discrete receptor data section not found in AERSCREEN.INP
c --- Version 11076
c --- Corrected bug with xdist calculation in subroutine maketerrain
c --- now use probe distance as reference distance to avoid
c --- hill height scale changing
c --- Version 11060
c --- add comments to code
c --- if discrete receptor use not listed in AERSCREEN.INP
c --- assume no discrete receptor use
c --- if output filename option not listed in AERSCREEN.INP
c --- assume default output filename AERSCREEN.OUT
c --- add code to subroutine output to notify user of new .inp and .log
c --- filenames if not using default aerscreen.out
c --- correct references from FLOWVECTOR to FLOWSECTOR
c --- changed write statements with "BPIP" to "BPIPPRM"
c --- allow user to copy aermod, makemet, aermap, or bpipprm executables
c --- if not found in current folder
c --- moved checks to after validate and all are checked
c --- at same time.
c --- only check for bpipprm if downwash used and only check
c --- for aermap if terrain used.
c --- change subroutine getoutfil to remove reminder that
c --- filename cannot be AERSCREEN.LOG.  This is redundant
c --- since user is told file must have .OUT extension
c --- also removed check in subroutine readinp to check for
c --- output filename of AERSCREEN.LOG
c --- updated subroutine checkdat to remove reference to
c --- AERSCREEN.LOG in error statement
c --- Version 11053
c --- "\" no longer added automatically to nadpath.  AERSCREEN
c --- checks to see if needed.
c --- Added logical variables to subroutine readinp to ensure that 
c --- all data lines are present and that the emissions data line
c --- is read before the building data line
c --- Use subroutine upcase to capitalize the variable line when
c --- reading data from AERSCREEN.INP
c --- added capability that discrete receptors can be entered as
c --- meters, kilometers, feet, or miles
c --- using 1st line of discrete receptor file
c --- first line must be "units:" or "UNITS:" followed by meters,
c --- feet, kilometers or miles
c --- no no units given, assume meters, but units line must be
c --- present or AERSCREEN aborts or re-prompts for filename
c --- Version 11048
c --- Changed subroutine downwash so that if downwash is turned off
c --- user cannot change any parameters but must turn on downwash first
c --- if downwash included, and BPIP input file being used, user cannot
c --- change other parameters without turning off BPIP input file first
c --- if changing minimum and maximum ambient temperatures from the options list
c --- and setting to the defaults, AERSCREEN now automatically does it without
c --- the user getting the prompt to enter for defaults
c --- write base elevation when terrain not being used
c --- created new subroutine to get output filename
c --- output filename must have .out or .OUT extension
c --- write the new AERSCREEN.INP file to a file that has the
c --- same naming convention as the output file (default AERSCREEN.OUT = AERSCREEN.INP)
c --- also copy the log file in similar fashion, except when user stops AERSCREEN in VALIDATE
c --- added subroutine to deallocate arrays
c --- Version 11038
c --- User can now enter up to 10 discrete receptor distances to include
c --- with the regular receptor network using a simple text file
c --- only receptors between the ambient and probe distance, and are non-duplicates
c --- of the regular network are used.
c --- Version 11027
c --- Changes made based on user comments from users duing beta testing
c --- and other changes due to bug fixes or other enhancements
c --- period Aug. 16, 2010 - Sept. 17, 2010
c --- Added code to check for existence of demlist.txt before any processing of
c --- terrain and stop AERSCREEN if not found
c --- Added DOMAINXY to AERMAP.INP files to window out domain in terrain file(s)
c --- to decrease AERMAP runtimes
c --- User no longer has to include the "\" in the NADGRIDS pathway
c --- Corrected bug related to placement of ambient receptors for AREA sources
c --- ambient receptors were not being placed on non-zero diagonals
c --- User can specify NO2 chemistry
c ---   from prompts user specifies that chemistry is not used or use OLM or PVMRM
c ---   if OLM or PVMRM, user specifies NO2/NOx instack ratio, ozone background
c ---   concentration and units
c ---   NO2EQUIL, NO2 equlibrium ratio is hard-wired as AERMOD default 0.9
c ---   POLLUTID is set to NO2
c ---   if user wishes to enter NO2 chemistry via aerscreen.inp, appropriate
c ---   variables can be added in CO pathway
c --- User can now specify output filename or keep default AERSCREEN.OUT file
c ---   If user-specified name used, max_conc_distance.txt uses part of filename
c --- Surface characteristics checked for reasonable values
c ---   When entering data via the prompts, if albedo is negative or greater than 1.0
c ---   the user is notified of an invalid response and prompted to re-enter the data
c ---   If albedo is negative or greater than 1.0 in aerscreen.inp, AERSCREEN notifies
c ---   the user and stops processing
c ---   When entering data via the prompts, if surface roughness is negative
c ---   the user is notified of an invalid response and prompted to re-enter the data
c ---   If surface roughness is negative in aerscreen.inp, AERSCREEN notifies
c ---   the user and stops processing
c ---   if Bowen ratio is less than 10.0 or greater than 10.0, thens 
c ---   AERSCREEN warns user
c ---   if surface roughness is less than 0.001 or greater than 4.0 m
c ---   AERSCREEN warns the user.  If less than 0.001, surface roughness
c ---   is reset to 0.001
c ---   If external surface characteristics file is used, routine readaer
c ---   checks to make sure all temporal periods and spatial sectors accounted for
c --- Made subroutine checkanswer more generic to accept negative numbers and check
c --- check character variables
c --- Created subroutine checkline that reads AERSCREEN.INP to make sure all variables
c --- are accounted for and that numeric fields are indeed numeric, i.e. do not include
c --- non-numeric related characters
c --- prompt user to correct UTM zone or NAD datum when invalid
c --- subroutine downwash checks for invalid building parameters when exiting subroutine
c ---   this occurs if downwash was initially set to no in aerscreen.inp and building
c ---   parameters were zero but were not checked because downwash not requested.
c ---   this is a check in case the user turned on downwash but may have forgotten
c ---   to change parameters
c --- added subroutine checkbpip to check the user-supplied BPIP input file to make sure
c --- process flag is set to "P" and that only one stack is listed in file
c --- variable ipass is now part of module main1.  ipass indicates if aerscreen.inp
c --- data being used or data entered via prompts
c --- changed variable accoord to read complete string for LATLON or UTM when
c --- entering terrain coordinates in subroutine getdem
c --- changed subroutines makegrid and output so that coordinates format matches that output
c --- by AERMAP
c --- Distances in max_conc_distance.txt now 2 decimal places
c --- changed probe distance input units from km to meters
c --- warn user that if probe distance is not a multiple of 25 m
c --- probe distance reset to highet distance that is multiple of 25 m
c ---   if probe distance is entered as 1,031 m, reset to 1,050 m and warn
c ---   user.  This is for easier grid spacing determination
c --- changed probe distance spacing:
c ---  0 to 5 km:  25 m spacing
c ---   > 5km : 100 receptors
c --- checkdat logical variables now part of module main1 and set in readinp
c --- to simplify logic in subroutine checkdat
c --- fixdum logical variables added for circle and area sources.
c ---   for the area source, this variable makes sure that the rotation
c ---   angle in aerscreen.inp is 0.0
c ---   for the circular source, this variable makes sure that the number
c ---   of vertices is 20.
c --- allow use of negative stack temperature and notify user that is a
c --- delta T between stack and ambient temperature.
c --- warn user if exit velocity reset to 1E-05
c --- warn user if terrain coordinates are zero and UTM and terrain being used
c --- corrected bug in demlist.txt for terrain files in quotations
c --- add warning if ambient temperatures exceed reasonable values, i.e. world records
c --- Version 07/20/2010
c --- Moved flagpole receptor prompts to terrain portion of prompts inputs
c --- changed prompts for surface characteristics to single user specified, AERMET,
c --- or external file (AERSURFACE or AERMET stage 3 input file)
c --- added capability to differentiate between primary and secondary surface
c --- characteristics when reading AERMET stage 3 file.  This in anticipation
c --- of an update to AERMET which will allow 2 sets of surface characteristics
c --- when processing onsite and NWS data
c --- Version 06/17/2010
c --- Variable receptor spacing now multiples of 25 or 50 m
c --- Version 06/14/2010
c --- added variable receptor spacing based on distance
c --- added warning to user that NADGRID files missing when entering data via prompts
c --- changed readaer to be more generic in reading surface characteristics
c --- subroutine previously followed strict AERSURFACE format
c --- Version 02/08/2010
c --- corrected code to read surface characteristics from AERMET stage 3 input file
c --- or AERSURFACE file to make it more general
c --- incorporated other comments from AIWG users
c --- Version 10/26/2009
c ---- in output subroutine, flowsector analysis, max. concentration
c --- by direction was based on worst case's temporal sector
c --- so worst case for each direction was not the worst case for the
c --- direction but worst case for the direction relative to the temporal
c --- sector of the worst case.
c --- have corrected this so that the worst case for a direction is the overall
c --- worst case for that direction
c --- Version 10/6/2009
c --- add check for grid files in subroutine getnadgrid
c --- Version 10/6/2009
c --- added check to read entire AERMAP.LST in subroutine oldmap
c --- to ensure that receptor distances and directions match
c --- current run.  If different, AERMAP will be rerun
c --- Also check coordinates from AERMAP.DAT in subroutine makegrid
c --- if coordinates' distance and direction do not match distance
c --- and direction of loop in makegrid, AERSCREEN will abort
c --- dated 9/9/2009 version 252
c --- added error check for probe distance < fence line distance
c --- subroutine added to check probe distance and ambient distance
c --- when entering data via prompts or changing data via prompts
c --- if entering data from AERSCREEN.INP, and probe distance < ambient then
c --- produce error and stop AERSCREEN.
c --- dated 8/28/2009 version 240
c --- made NADPATH permanent part of demlist.txt
c --- if grid files in current directory, user should put PWD or pwd for current directory
c --- and AERSCREEN will know not to look for a path
c --- dated 8/5/02009 version 217
c --- added checks for invalid option selection (numbers greater than 100) in 
c --- individual menus
c --- dated 7/7/2009 version 188
c --- added error checks on AERSCREEN.INP and prompts
c ---     minimum building dimension greater than max building dimension
c ---     min temperature >= max temperature
c ---     other error checks
c --- added FILEFORM EXP in output files from AERMOD for use with new AERMOD
c --- and removed creation of unformatted files and reading of unformatted files to get max concentrations
c --- made output for distance file scientific
c --- changed max_conc_distance.txt to max_conc_distance.txt
c --- dated 6/8/2009
c --- added horizontal and capped stacks
c --- dated 6/5/2009
c --- removed 5 km probe distance for flat terrain, or downwash no terrain, and rectangular area sources
c --- probe distance now set by user for all casles
c --- dated 3/2/2009
c --- made most arrays allocatable
c --- updated NADCON and UTMGEO to incorporate new AERMAP
c --- updated demlist.txt to include line for NAD grids files location
c --- dated 11/03/2008
c --- changed write statements to have format statements instead of imbedded formats
c --- changed logic for metric or English units so that duplicate statements were not
c --- needed at the prompts.  A variable called units1 is used to denote the appropriate
c --- units.
c --- Version RODFT
c --- dated 10/6/2008
c --- concentrations now output using G format.
c --- dated 09/30/2008:
c --- UTMGEO updated from AERMAP to allow negative longitudes for the western hemisphere
c --- added NADCON to convert input coordinates from NAD 27 to NAD 83 if necessary
c --- doing the conversion will cause AERSCREEN to pass NAD 83 UTM coordinates to AERMAP 
c --- always.
c --- User will be notified of conversions
c --- Version 08269
c --- dated 09/25/2008:
c --- impact at ambient distance in AERSCREEN.OUT, now maximum impact at ambient distance
c --- independent of direction and meteorology of maximum overall impact
c --- previously, it was in the same direction and used same meteorology as overall maximum impact
c --- Version 08261
c --- dated 09/17/2008:
c --- modified getDEMs and downwash routines so that if building or terrain effects cannot be included
c --- such as for area or volume sources, user is notified and nothing is done.
c --- modified getDEMs and downwash to skip prompts if the downwash and terrain are initially requested
c --- but set to no after initial inputs (iskip=2).
c --- switched prompt order of maximum and minimum building dimensions to match input file
c --- output surface characteristics to log file
c --- Version 08240
c --- dated 08/27/2008:
c --- added comments to AERMOD.INP to denote what temporal/spatial sector is used
c --- and to denote ambient receptor and automatic receptors
c --- Added call to UTMGEO in getDEMs when getting source coordinates to match
c --- call to UTMGEO in readinp.
c --- added option in getDEMs to input source coordinates as lat/lon or UTM
c --- if lat/lon, units will be switched to UTM and a message written to the log
c --- file and new AERSCREEN.INP file.
c --- Version 08232
c --- dated 08/19/2008:
c --- TOXICS option for area sources to speed up runtime
c --- changed seasonal surface characteristics so that seasons are 
c --- same order regardless of whether AERMET tables or AERSURFACE
c --- currently, order for AERMET is different than AERSURFACE
c --- remap AERMET to AERSURFACE order
c --- new order is: winter,spring,summer,fall
c --- old AERMET order:  spring,summer,fall,winter
c --- variables albedo, bowen, and roughlen in MAIN1 are AERMET order
c --- Version 08225
c --- dated 08/12/2008:
c --- changed order of input variables in AERSCREEN.INP
c --- moved terrain flag to terrain data line
c --- moved building flag to building data line
c --- moved flagpole flag to units/prompts data line
c --- corrected x,y calculations for rectangular area sources
c --- in MAKEGRID so that y is calculated for all receptors
c --- Version 08203
c --- dated 08/05/2008:
c --- changed prompts for stack elevation to read as source elevation
c --- added code to have binary output included in AERMOD output and for AERSCREEN
c --- to read binary output or AERMOD.OUT file when overflow in rank file and AERSCREEN.PLT
c --- add subroutine to convert lowercase to uppercase for flags, i.e. convert "y" to "Y"
C --- this will eliminate ".or." in IF statements
c --- if user enters data through prompts using English units, variable units is switched
c --- from "E" or "e" to "m" in subroutine validate
c --- and new logical variable lswitch is set to .true. and logical variable lmetric
c --- is set to .true.
c --- this is done because the new AERSCREEN.INP file has the metric equivalent of the
c --- English units.
c --- User is notified of the change in the DOS window, AERSCREEN.log and AERSCREEN.INP
c --- PROFBASE and stack elevation now user entered values and are not overwritten unless
c --- specified by user.
c --- if terrain is used, values are user entered or AERMAP derived
c --- if flat terrain, values are user entered or 0 by default
c --- added flag to input file to denote if AERMAP is to override
c --- created logical variables for terrain, downwash, and flagpole receptor use
c --- created logical variables for each source type
c --- created logical variable for metric units 
c --- subroutine oldmap now checks for terrain input filenames and ambient distance to
c --- compare against older AERMAP run to see if AERMAP needs to be run for stage 2
c --- changed probe (stage 1) receptors from 100 points @ 50 m spacing to 200 points @ 25 m spacing
c --- this gives a finer gradient for choosing maxsector and maxtemp of highconc
c --- changed diag=NINT(diag/5.)+1 to diag=INT(diag/5.)+2 to always have one line of receptors past the diagonal
c --- updated rectangular area sources to "rotate" when using multiple surface roughness sectors. 
c --- rectangular area sources only run in flat terrain mode.
c --- Modified subroutine makeinput to take 3 inputs (sector, temporal, and roughness sector) and no longer calls findsector
c --- findsector now called before makeinput in subroutines probe, flowsector, and refine
c --- corrected subroutine findsector when using multiple sectors.  Subroutine was using the flow direction
c --- not wind direction, so surface characteristics downstream (flow direction) of the source were being used, 
c --- not upstream.
c --- Version 08101
c --- dated 04/24/2008:
c --- made variable diag part of the module main1 and removed all declarations in subroutines
c --- and changed flowsector to no longer include it as an argument
c --- moved probe distance prompt before terrain prompt
c --- made code that writes final messages to logfile a subroutine
c --- dated 04/10/2008:
c --- updated aermodqa and aermapqa to use module main1 and no longer use the error
c --- codes as arguments
c --- removed variable iaer to denote AERSURFACE output being used and used isurf=9 to denote AERSURFACE
c --- Added a prompt to the user when the AERMAP input parameters from a previous run are the same as
c --- the current run, to use those parameters or rerun for stage 2 when using terrain.
c --- Give each file its own unique file unit
c --- Version 08100
c --- dated 04/09/2008:
c --- updated log and screen writes to better inform user of temporal resolution
c --- moved temporal and sector loops inside makemet2, so makemet2 is only called 
c --- once and now uses the main1 module for variables
c --- Version 08087 (draft Beta release version)
c --- Date 03/27/2008:
c --- Renamed code and input/output files from ASCREEN to AERSCREEN
c --- Added code in subroutine readDEM to accept new data types for AERMAP
c --- D for DEM, N for NED. 7 and 1 kept in code.  Note that N will not work until
c --- new version of AERMAP supporting NED is done
c --- changed averaging time factors in output to use max of profiles
c --- removed common blocks and added module main1
c --- removed block data profile and initialized surface characteristics from 
c --- AERMET tables in module main1
c --- Added new 2 dimensional arrays of surface characteristics with max dimensions 12x12
c --- arrays are:  alb - albedo, bow - bowen ratio, rough - surface roughness
c --- Added two variables ntemp and nsec to represent temporal resolution and number of sectors 
c --- of surface characteristics alb, bow, and rough
c --- Added variable iaer denoting whether to use AERSURFACE output for surface characteristics
c --- Added variable aersurf denoting AERSURFACE output or AERMET stage 3 input filename with
c --- AERSURFACE characteristics
c --- Added subroutine readaer to read AERSURFACE output
c --- Added subroutine surface to assign user input surface characteristics, AERMET table 
c --- surface characteristics, or AERSURFACE surface characteristics to arrays alb, bow, and rough
c --- user default will have dimensions (1,1), AERMET tables (4,1), and AERSURFACE from (1,1) to (12,12)
c --- added temporal resolution argument to subroutine makeinput
c --- moved the call of makemet2 from probe to surface.  Met files created for each temporal sector combination
c --- Added temporal loop to subroutine flowsector
c --- Added code to only call probe when no buildings and no terrain
c --- Added code to flowsector to calculate number of receptors based on probe distance (moved from probe)
c --- Made variables highconc, terrhghts, and distance from 1-D arrays (dim=36) to 2-D (12,36) where 12 is
c --- maximum temporal resolution
c --- Subroutine refine now finds maximum concentration and copies correct met files to AERSCREEN.SFC
c --- and AERSCREEN.PFL
c --- updated code that writes output and log file to reflect AERSURFACE input
c --- updated code that writes new input file to reflect AERSURFACE input
c --- Version 07311  (draft Beta release version)
c --- Date - 11/07/2007:
c --- Added code to specify PROFBASE, met station elevation, by user
c --- If elevated terrain is used, the value given by the user is overridden
c --- by the source elevation, otherwise the value used is given by the user
c --- Default value is 0
c --- User can now specify the probe distance (probedist) in kilometers or miles.  Default values
c --- are 10 km or 6.21 miles.  This is for either flat or elevated terrain.
c --- Stage 1 AERMOD still uses 5,000 m as the probe distance
c --- Specifying the probe distance eliminates the question of whether any receptors are
c --- at elevations higher than the source.
c --- changed format statement in subroutine readinp for reading stack elevation to account that
c --- ascreen.inp is from aermod.inp and original format does not work.
c --- Date - 09/27/2007:
c --- Added subroutine writetolog, which is basically the same
c --- subroutine as validate and writes input information to the
c --- ascreen.log file after the user has finalized source, terrain,
c --- building, receptor, and meteorological information.
c --- Changed the name for the common block for ilog from blank to log.
c --- Version 07260  (draft Beta release version)
c --- Date - 09/17/2007:
c --- Added FLAGPOLE receptor height option.  User enters whether to use
c --- flagpole receptors and if so, user enters height or
c --- accepts zero as default flagpole receptor height
c --- Added subroutine AERMODQA to read AERMOD.OUT file and check to 
c --- successful or unsuccessful run.  Also checks for error and
c --- warning messages, as well as to ensure correct stage of
c --- ASCREEN was being processed in AERMOD.
c --- Added subroutine AERMAPQA to read AERMAP.OUT file and check for 
c --- successful or unsuccessful run.  Also checks for error and
c --- warning messages, as well as to ensure correct stage of
c --- ASCREEN was being processed in AERMAP.
c --- Subroutine also returns an error if AERMAP crashed and AERMAP.OUT
c --- was incomplete
c --- Added statements so that a log file, ASCREEN.LOG is written
c --- with the outputs from AERMODQA and AERMAPQA. Log file also
c --- tells if ASCREEN was successful and if any errors or warnings
c --- were generated by AERMODQA and AERMAPQA
c --- Converted receptor heights from feet to meters in ASCREEN.OUT
c --- Switched order of output for building height and building width
c --- in ASCREEN.OUT
c --- Update ASCREEN to reflect version 07236 of AERMOD and MAKEMET.
c --- This includes revised order of surface characteristic inputs to
c --- match AERMET, i.e., albedo, Bowen ratio, then surface roughness.
c --- Added direction dependency to AREA source option to account for
c --- worst-case impacts for off-axis flows. Also added optional
c --- initial vertical dispersion parameter for AREA sources.
c --- Added AREACIRC option for circular area sources.
c --- Modified met data "year" from 1990 to 2010 to match MAKEMET file.
c --- Modified MAXIMUM IMPACT SUMMARY to exclude impacts at distances
c --- less than user-specified ambient boundary distance.
c --- Added "YR MO DY JDY HR" for worst-case screening meteorology in
c --- ASCREEN.OUT file.
c --- Corrected code for printing out worst-case meteorology for ambient
c --- boundary impact.
c --- Included more "refined" estimate of final plume using AERMOD code.
c --- Removed references to "DENSITY" in relation to urban population.
c --- Included checks to ensure the required executables are available,
c --- including AERMOD and MAKEMET, and if needed, AERMAP and BPIPPRM.
c --- Included Flare source option, based on SCREEN3 model, with default
c --- heat loss fraction of 0.55, with optional user-defined heat loss.


c --- Version 07040  (Beta release version)
c --- Date - 02/09/07 (Update ASCREEN to reflect newest version of AERMOD
c --- and AERMAP.  Modify MAKEMET to generate version number 'SCREEN' for
c --- screening runs.  AERMOD recognizes this when the SCREEN option is used.


c --- Version 07017  (Beta release version)
c --- Date - 01/17/07 (Add the option to use existing, refined BPIP input files.
c --- Corrected an error existing since version 06111.  Meteorological
c --- parameters surface roughness and albedo were transposed when passed to
c --- MAKEMET.  Also corrected a small error when listing automated distance
c --- results.)


c --- Version 06321  (Beta release version)
c --- Date - 11/17/06 (Add Area Source component)


c --- Version 06227  (Beta release version)
c --- Date - 08/15/06 (Simplify some of the screen input parameters.  Modify
c --- DEM list inputs to allow for either 7.5' or 1-deg DEM files.  Files,
c --- already in DEM format, must be pre-listed in the file DEMlist.txt.  The
c --- first character in line one must be either 7 or 1 depending on the type
c --- of DEM used.  Experimented with AERMAP 04300 but determined that there
c --- are still errors which keep 1-deg DEM files from working.  This version
c --- will use version 03107 until 04300 is fixed.  Also modified scaling
c --- factors to use sliding scale for stacks above 100m rather than 60m)


c --- Version 06114  (Alpha release version to Regional Offices)
c --- Date - 04/24/06 (Implement name change from "AERSCRN" to "ASCREEN";
c ---                  Modified location of 15000m impact radius in
c ---                  subroutine probe to prevent resetting to lower value;
c ---                  Modified order of surface characteristics inputs
c ---                  to match AERMET Stage 3 inputs and new MAKEMET -
c ---                  albedo; Bowen ratio; surface roughness;
c ---                  Minor edits to output formats.  RWB)


c --- Version 06111  (beta release version)
c --- Date - 04/21/06 (Correct minor problem with the restart file)


c --- Version 06110  (beta release version)
c --- Date - 04/20/06 (Correct minor problem with DEM1 file processing
c ---                  Modified 7.5 DEM file format.  Adjusted averaging
c ---                  period ratios)

c --- Version 06105  (beta release version)
c --- Date - 04/15/06 (Increase maximum impact radius for distant rugged
c ---                  terrain. Allow 7.5 minute DEM data from user data.
c ---                  Modify program to run MAKEMET as a stand-alone module)
c ---                  Increase automatic array from 20 to 50 and decrease
c ---                  spacing distance.  Expand search interval in final
c ---                  search for overall maximum as a function of distance.

c --- Version 06065  (beta release version)
c --- Date - 03/06/06 (Simplify averaging period ratios with fixed factors.
c ---                  Annual impacts will have a sliding scale to avoid
c ---                  large overpredictions)

c --- Version 05286  (beta release version)
c --- Date - 10/14/05 (Fixed problem with locating secondary peaks, added
c ---                  option to enter stack base elevation, replaced AERMAP
c ---                  executable with Lahey compiled version for faster runs)

c --- Version 05265  (beta release version)
c --- Date - 9/22/05 (Replace MAKEMET with final MAKEMET version 05250 -
c ---                 Finalize as first public beta release version)

c --- Test Version 1.5k
c --- Date - 9/10/05 (Add VOLUME source)

c --- Test Version 1.5j
c --- Date - 8/29/05 (Updated BPIPPRM version and removed command line option
c ---                 to make code portable)

c --- Test Version 1.5i
c --- Date - 6/23/05 (Added 6m/s wind speed to convective matrix to address
c ---                 low 1-hr ratio for West Palm Beach data.)

c --- Test Version 1.5h
c --- Date - 6/02/05 (Simplified methodology to retreive terrain data)

c --- Test Version 1.5g
c --- Date - 6/02/05 (Revise variable scaling ratio based on final plume
c ---                 height and distance to impact.)

c --- Test Version 1.5f
c --- Date - 5/04/05 (Includes default minimum receptor distance of 10m)

c --- Test Version 1.5e
c --- Date - 4/20/05 (Includes variable scaling ratios based on stack height
c ---                 and Buoy vs. Non-buoy)

c --- Test Version 1.5d
c --- Date - 4/18/05 ((Includes Roger Brode's MyTest13 version of Makemet)

c --- Test Version 1.5c
c --- Date - 4/11/05 (Modifies variable scaling ratios to split Buoy vs. Non-buoy)

c --- Test Version 1.5b
c --- Date - 3/31/05 (Includes Roger Brode's MyTest12 with additional
c ---                 wind speed values for stable and convective conditions)

c --- Test Version 1.5a
c --- Date - 3/28/05 (Includes Roger Brode's MyTest11 version of Makemet)

c --- Test Version 1.5
c --- Date - 3/26/05 (Adds user defined min/max temperatures plus user defined
c ---                 defined anemometer height.  Also includes Roger Brodes
c ---                 new MyTest10 for met derivations)

c --- Test Version 1.4a
c --- Date - 3/09/05 (Adds variable scaling ratios)

c --- Test Version 1.4
c --- Date - 3/07/05 (Adds Roger Brode's MyTest9 version of Makemet)

c --- Test Version 1.3a
c --- Date 2/25/05 (Corrects problem reading met conditions at ambient
c                   boundary when concentration is zero)

c --- Test Version 1.3
c --- Date - 2/16/05 (Adds Roger Brode's MyTest6 version of Makemet)

c --- Test Version 1.2d
c --- Date - 3/1/05 (Adds OINKME version of MAKEMET)
                                                    
c --- Test Version 1.2c
c --- Date - 1/14/05 (Adds met conditions to output for maximum impacts)
c                    (Allows scaling of predicted 1-hour impacts)
c                    (Generates error message for too big impacts)

c --- Test Version 1.2b
c --- Date - 1/10/05 (Corrects minimum ws to also cover unstable winds)

c --- Test Version 1.2a
c --- Date - 1/7/05 (Allows user to set minimum wind speed)

c --- Test Version 1.2
c --- Date - 08/23/04 (Replaces MAKEMET18C with Herman Wong's JOINT_MM.for)
c --------------------------------------------------------------------
      MODULE MAIN1
      
      implicit none
  
c character variables
c title:        title of run
c versn:        AERSCREEN version number (2 digit year + Julian date)
c version:      AERMOD version number read from AERMOD output file
c bpipfile:     BPIP input file name
c units:        Flag denoting what units, metric(units=M) or English(units=E), are to be used
c urban:        Flag denoting urban(U) or rural(R) run
c bpip:         Flag denoting if building downwash to be included (Y=yes, N=no)
c terrain:      Flag denoting if terrain to be used (Y=yes, N=no). 
c stype:        Source type (P=point,V=volume,A=area, C=circle, F=flare, S=capped stack, H=horizontal stack)
c flgswitch:    Flag denoting if flagpole receptors are used (Y=yes, N=no)
c aersurf:      File name of AERSURFACE output file or AERMET stage 3 input file containing surface characteristics
c month:        array of month names
c season2:      Season names used in conjunction with AERSURFACE or AERMET surface characteristics
c adate:        array of dates of area source max concentrations (number of diagonals x number of points +1)
c date:         array of dates of max concentrations (temporal resolution (annual, seasonal, or monthly) x number c               of points +1)
c landuse:      landuse names for AERMET surface characteristics tables
c climate:      Average, dry, or wet climate descriptors for AERMET surface characteristics
c terfiles:     array of terrain input files for AERMAP
c dem3:         3-character identifier of DEM (NED or DEM)
c aermap:       use AERMAP for PROFBASE and stack elevation (Y=yes,N=no)
c sctype:       character variable defining surface characteristics input (user defined, AERMET, or AERSURFACE)
C               used in subroutine metdata when changing surface characteristics.
c eunits:       units of elevation for AERMAP:  feet, deci-feet, decifeet, deca-feet, decafeet
c               meters, deci-meters, decimeters, deca-meters, decameters
c nadpath       directory path of NAD conversion files, without leading and trailing quotations
c nadpath1      directory path of NAD conversion files read from demlist.txt, with leading and trailing quotations
c outfil        output filename, default is aerscreen.out
c o3units       ozone concentration background units used when processing NOX chemistry
c noxchem       character variable used to determine if PVMRM or OLM used for NOx chemistry 
c discflag      character variable used to determine if discrete receptors to be used
c discfile      filename containing up to 10 discrete receptor distances
c discunit      distance units of discrete receptors     
c fumflag       fumigation flag
c shorflag      shoreline fumigation flag
c scrnflag      Run AERSCREEN flag
c debugflg      debug flag
c rundate       Date of AERSCREEN execution
c runtime       Time of AERSCREEN execution
c logfil        AERSCREEN log filename
c maxfil        Maximum concentration by distance filename
c debufil       Debug filename
c inpfile       AERSCREEN input filename
c sfcfil        Surface meteorological filename output by MAKEMET
c pflfil        Profile meteorological filename output by MAKEMET
c infil1        AERMAP.OUT used in maketerrain
c outfil3       AERMAP1.OUT used in maketerrain
c fumfil        Fumigation debug file
c quote1        Double quotation mark
c ustarflg      U* adjustment flag (y=adjust,n=no adjust)
      character title*60,versn*5,version*6,bpipfile*250,units*1,  !changed version from 5 characters to 6 characters JAT 1/11/17
     +   urban*1,bpip*1,terrain*1,stype*1,flgswitch*1,aersurf*250,
     +   month(12)*10,season2(4)*6,adate*8,landuse(8)*20,
     +  climate(3)*20,date*8,terfils(100)*200,dem3*3,aermap*1,
     +  sctype*12,eunits(100)*11,nadpath*201,nadpath1*200,outfil1*250,
     +  outfil*250,o3units*5,noxchem*5,discflag*1,discfile*250,
     +  discunit*11,fumflag*1,shorflag*1,debugflg*1,rundate*8,runtime*8,
     + logfil*250,maxfil*280,debugfil*280,inpfile*250,sfcfil*25,
     + pflfil*25,infil1*15,outfil3*15,fumfil*280,scrnflag*1,quote1,
     +ustarflg*1
      allocatable :: adate(:,:)
      allocatable :: date(:,:,:)
      
      
c meteorology, terrain, and surface characteristics

c isurf:        Variable to indicate what surface characteristics to use (0=user entered, 1-8=use AERMET tables and  is the landuse
c               of the surface around the source, and 9=use AERSURFACE output or AERMET stage 3 input file)
c iclim:        Variable to denote average (1), wet (2) or dry(3) moisture conditions when using AERMET tables
c ntemp:        temporal resolution of surface characteristics (1=annual,4=seasonal,12=monthly)
c nsec:         Number of sectors for surface characteristics (maximum of 12)
c sector:       Array of starting directions for AERSURFACE surface roughness sectors (maximum of 12)
c maxtemp:      Time of the maximum concentration (annual, season, or monthly) 
c maxsector:    Sector (1 through 36) of the maximum concentration.
c iscaer:       Surface characteristics sector to use containing maxsector
c istage:       Stage of AERSCREEN being executed.  0=source elevation for AERMAP
c               1=probe (when no terrain or downwash), 2=flowsector,
c               3 = refined stage
c ierr:         error codes assigned when performing QA on AERMOD.OUT file
c ierr2:        error codes assigned when performing QA on AERMAP.OUT file
c numdiag:      Number of diagonals for area sources
c               =int(diag/5) +2 where diag=tan(yinit/xinit)
c nskip:        Number of receptors skipped due to missing elevations for individual AERMOD runs in flowsector or refine
c nskip2:       Number of total receptors skipped in FLOWSECTOR, not allowing for duplication due to monthly or seasonal runs
c nskip3:       Number of total receptors skipped in REFINE
c fumhours:     Number of meteorological hours used for fumigation calculations
c ambtmin:      Minimum ambient temperature entered by user (default=250 K)
c ambtmax:      Maximum ambient temperature entered by user (default=310 K)
c wsmin:        minimum wind speed (m/s) entered by user (default = 0.5 m/s)
c anemht:       User entered aneomemeter height entered by user (default= 10 m)
c roughlen:     AERMET table derived surface roughness by season and landuse
c bowen:        AERMET table derived Bowen ratio by season and landuse 
c albedo:       AERMET table derived albedo by season and landuse 
c useralbe:     User entered albedo
c userbown:     User entered Bowen ratio
c userlen:      User entered surface roughness
c alb:          Array of albedo. Values are remapped from useralbe (isurf=0), albedo(isurf=1 to 8), or
c               AERSURFACE values (isurf=9).  Array indices are temporal (12) and sectors (12)
c bow:          Array of Bowen ratio. Values are remapped from userbown (isurf=0), bowen(isurf=1 to 8), or
c               AERSURFACE values (isurf=9).  Array indices are temporal (12) and sectors (12)
c rough:        Array of surface roughness. Values are remapped from userlen (isurf=0), roughlen(isurf=1 to 8), or
c               AERSURFACE values (isurf=9). Array indices are temporal (12) and sectors (12)
c fumx:         distance to maximum concentration for fumigation
c shordist:    distance to shoreline (less than 3 km) for coastal fumigation
c shorex:       distance to maximum concentration for coastal fumigation
c invx:        distance to maximum concentration for inversion breakup fumigation
c invvchi:     maximum concentration for inversion breakup
c shorechi:    maximum concentration for shoreline fumigation
c shoredir:    direction from source to shoreline (source as origin)
c govrcp:      gravity over gas constant at constant pressure (0.00977)
c fumdata:     meteorological variables for fumigation calculations
c vonkar:      von-Karman's constant (0.4)
c g:           gravity(9.80616)
c rtof2:       square root of 2
c rtofpi:      square root of pi
c third:       1/3
      integer isurf,iclim,ntemp,nsec,sector(12),
     +  maxtemp,maxsector,isecaer,istage,ierr(3),ierr2(3),numdiag,nskip,
     +  nskip2,nskip3,fumhours
      real ambtmin,ambtmax,anemht,wsmin,roughlen(4,8),bowen(4,8,3),
     +   albedo(4,8),useralbe,userbown,userlen,fumx,shordist,shorex,
     + invx,invchi,shorechi,govrcp,vonkar,g,rtof2,rtofpi,third,shoredir
     
      real, allocatable, dimension(:,:) :: alb
      real, allocatable, dimension(:,:) :: bow
      real, allocatable, dimension(:,:) :: rough
      real, allocatable, dimension(:,:) :: fumdata
      
c source and building information

c bheight:      building height
c blength:      maximum building horizontal dimension
c bwidth:       minimum building horizontal dimension
c bangle:       angle of maximum building horizontal dimension from North
c sangle:       Angle between building center and stack measured from North
c sdistance:    Distance between stack and building center
c bpiphgt:      BPIP output building heights by 36 wind sectors
c bpiplen:      BPIP output building lengths by 36 wind sectors
c bpipwid:      BPIP output building widths by 36 wind sectors
c bpipxad:      BPIP output x-adjustment lengths by 36 wind sectors
c bpipyad:      BPIP output y-adjustment lengths by 36 wind sectors
c emisrate:     emissions rate (g/s)
c height:       stack height
c diameter:     stack diameter
c temperature:  stack exit temperature
c velocity:     stack exit velocity
c flowrate:     stack flowrate
c syinit:       initial lateral dimension of plume for volume sources
c szinit:       initial vertical dimension of plume for volume, rectangular, or circular area sources
c xinit:        long side of area source
c yinit:        short side of area source
c circrad:      radius of circular area source
c sw_X:         southwest x-coordinate of area source
c sw_Y:         southwest y-coordinate of area source
c flare_hgt:    flare stack height
c heat:         Total heat release rate (cal/sec) of flare
c heatloss:     Radiative heat loss fraction of flare (default=0.55)

c diag:         diagonal being processed for area sources
c no2stack:     NO2/NOx instack ratio, keyword NO2STACK in AERMOD
c o3:           ozone background concentration
      real bheight,blength,bwidth,bangle,sangle,sdistance,bpiphgt(36),
     +  bpiplen(36),bpipwid(36),bpipxad(36),bpipyad(36),emisrate,height,
     +  diameter,temperature,velocity,flowrate,syinit,szinit,xinit,
     +  yinit,circrad,sw_X,sw_Y,flare_hgt,heat,heatloss,diag,no2stack,o3

c terrain and receptor data

c izone:        UTM zone of source
c nada:         NAD conversion methodology (1=NAD 27, 4=NAD 83)
c igep:         GEP flag
c ndem:         Number of DEM files to process
c numpt:        Number of points along a radial being processed in AERMOD
c irec:         Number of receptors along a radial for individual AERMOD run
c maxdiag:      direction of maximum line of concentration for rectangular area source
c maxdiag1:     maximum diagonal for each receptor distance by temporal period and sector
c xnear:        Minimum distance of ambient air distance (default=1)
c probedist:    maximum distance of receptors
c gap:          receptor spacing
c populat:      population for urban sources
c flagpole:     flagpole height of receptor (default=0)
c degrad:       Degrees to radians conversion
c utmx:         UTM x-coordinate of source
c utmy:         UTM y-coordinate of source
c xlat:         Latitude of source
c xlong:        Longitude of source
c xutm27:       UTM x-coordinate of source in NAD 27
c yutm27:       UTM y-coordinate of source in NAD 27
c lat27:        Latitude of source in NAD 27
c long27:       Longitude of source in NAD 27
c base:         stack base elevation
c profbase:     elevation for profile
c highconc:     Maximum concentrations for each temporal and sector resolution
c flowmax:     Maximum concentrations for each spatial sector from FLOWSECTOR or PROBE
c flowmaxtemp:  Temporal period associated with flowmax
c distance:     downwind distance of max concentrations for each temporal and sector resolution
c terrhghts:    terrain heights of max concentrations for each temporal and sector resolution
c aconc:        concentrations for the diagonal sectors of rectangular area source concentrations
c adist:        distance for the diagonal sectors of rectangular area sources
c aterr:        terrain heights of rectangular area sources
c aconc1:       concentrations for the diagonal sectors by receptor of rectangular area source concentrations
c adist1:       distance for the diagonal sectors by receptor of rectangular area sources
c aterr1:        terrain heights of rectangular area sources by diagonal sector and receptor
c conc1:        maximum concentration by temporal period, sector, and receptor
c terr1:        terrain heights associated with conc1
c probedist1:   original probe distance entered by user
c recdist:      distances for receptors by radial and temporal period
c recrad:       receptor spacing distances
c ndisc:        number of discrete receptors
c maxdisc:      maximum number of discrete receptors (10)
c invtemp:      temporal period of maximum inversion break-up concentration
c invsec:       spatial sector of maximum inversion break-up concentration
c stemp:        temporal period of maximum shoreline concentration
c ssec:         spatial sector of maximum shoreline concentration
c invdate:      date of maximum inversion break-up concentration
c shordate:     date of maximum shoreline concentration
c diag2:        array of diagonals for area sources
c aconc2:       concentrations for the diagonal sectors by receptor of 
c               rectangular area source concentrations by temporal and spatial sector
c discrete:     array of discrete receptor distances
      integer izone,nada,igep,ndem,numpt,irec,ndisc,maxdisc,refdist,
     +invtemp,invsec,stemp,ssec,invdate,shordate
     
      integer, allocatable, dimension(:,:) :: maxdiag
      integer, allocatable, dimension(:) :: flowmaxtemp
      integer, allocatable, dimension(:,:,:) :: maxdiag1
      integer, allocatable, dimension(:,:,:,:) :: diag2

c 6/14/10 - made gap a 2-element array JAT     
      real xnear,probedist,gap(2),populat,flagpole,degrad,xlat,xlong,
     +  base,profbase,utmx,utmy,xutm27,yutm27,lat27,long27,probedist1

     
      real, allocatable, dimension(:,:) :: highconc
      real, allocatable, dimension(:) :: flowmax
      real, allocatable, dimension(:,:) :: distance
      real, allocatable, dimension(:,:) :: terrhgts
      real, allocatable, dimension(:,:) :: aconc1
      real, allocatable, dimension(:,:,:,:) :: aconc2
      real, allocatable, dimension(:,:) :: aterr1
      real, allocatable, dimension(:,:) :: adist1
      real, allocatable, dimension(:) :: aconc
      real, allocatable, dimension(:) :: adist
      real, allocatable, dimension(:) :: aterr
      real, allocatable, dimension(:,:,:) :: conc1
      real, allocatable, dimension(:,:,:) :: terr1
      real, allocatable, dimension(:,:,:) :: recdist
      real, allocatable, dimension(:) :: recrad
      real, allocatable, dimension(:) :: discrete
c file units

c ilog:         unit for AERSCREEN log file, AERSCREEN.LOG (1)
c bpipin:       unit for BPIP input file, bpipprm.inp (2)
c maininp:      unit for AERSCREEN input file, AERSCREEN.INP (3)
c bpipout:      unit for BPIP output file, bpipprm.out (4)
c iaersurf:     unit for file with AERSURFACE surface characteristics (5)
c iprompt:      unit for prompts.inp for MAKEMET processing (6)
c aermodin:     unit for AERMOD input file, AERMOD.INP (7)
c aermapin:     unit for AERMAP input file, AERMAP.INP (8)
c idemlist:     unit for list of DEM files for AERMAP, demlist.txt (9)
c aermplst:     unit for list of receptors and terrain heights AERMAP.LST (10)
c aermpkil:     unit for AERMAP.KIL (11)
c aermpdat:     unit for AERMAP.DAT (12)
c aermdout:     unit for AERMOD output file, AERMOD.OUT (13)
c aermpout:     unit for AERMAP output file, AERMAP.OUT (14)
c ascrnfil:     unit for AERSCREEN.FIL (15)
c ascrnout:     unit for AERSCREEN output file, AERSCREEN.OUT (16)
c isfcmet:      unit for surface met file, AERSCREEN.SFC (17)
c isfcmet1:      unit for surface met file for fumigation hours (22)
c ipflcmet:      unit for profile met file, AERSCREEN.PFL (23)
c ascrnplt:     unit for AERSCREEN.PLT (18)
c ascrnout3:    file of max conc. by distance, max_conc_distance.txt (19)
c srcloc:       unit for source elevation file, SOURCELOC.KIL (20) 
c discin:       unit for discrete receptor file
c idebug        unit for AERMOD DEBUG file for fumigation
c ascrnout4      unit for concentration debug 
c ascrnout5       unit for fumigation debug

c ipass:        indicator that AERSCREEN.INP data used

c runprobe:     logical variable denoting that subroutine probe was used
c runflow:      logical variable denoting that subroutine flowsector is used
c lterrain:     logical variable denoting whether terrain is used (yes=true, no=false)
c lbpip:        logical variable denoting if downwash sued (yes=true,no=false)
c lpoint:       logical variable denoting if source is point source (yes=true, no=false)
c lflare:       logical variable denoting if source is flare source (yes=true, no=false)
c larea:        logical variable denoting if source is rectangular area source (yes=true, no=false)
c lcirc:        logical variable denoting if source is circular area source (yes=true, no=false)
c lvolume:      logical variable denoting if source is volume source (yes=true, no=false)
c lcap:         logical variable denoting if source is capped stack (yes=true, no=false)
c lhor:         logical variable denoting if source is horizontal stack (yes=true, no=false)
c lmetric:      logical variable denoting if units are metric or English (metric=true, English=false)
c lurban:       logical variable denoting if source is urban/rural (urban=true,rural=false)
c lflagpole:    logical variable denoting if flagpole receptors used (yes=true,no=false)
c laermsrc:     logical variable denoting to use AERMAP to get source elevation and PROFBASE (yes=true,no=false)
c lswitch:      logical variable denoting that units were switched from English to metric
c llat:         logical variable denoting that coordinates are input as lat/lons (true) or UTM (false)
c lnad83:       logical variable denoting that coordinates were switched from NAD27 to NAD83 (true=yes,false=no)
c lngrid:       logical variable denoting if NGRIDS called during NAD 27 to NAD 83 conversion
c               NGRIDS needs to be only called once, so if coordinates were entered incorrectly
c               and user wishes to change them, it does not need to be called again (true=has been called, false=no call)
c lnadgrid:     logical variable denoting if a pathname has been entered for the NADGRIDS file
c lcalc:        logical variable denoting that NAD83 UTM coordinates have been calculated
c lusebpip:     logical variable denoting that BPIP input file being used
c changeprobe:  logical variable denoting if probedistance changed to multiple of 25 m
c lno2:         logical variable denoting if NOx chemistry being used
c lolm:         logical variable denoting that OLM NOx chemistry being used
c lpvmrm:       logical variable denoting that PVMRM NOx chemistry being used
c ldiscrete:    logical variable denoting that discrete receptors are to be used
c ldefault:     logical variable denoting if output file is default AERSCREEN.OUT
c nocopy:       logical variable denoting whether to copy new log file
c               do not copy if user stops AERSCREEN by choosing option 7 in VALIDATE
c lfumigate:    logical variable denoting that inversion break-up fumigation is requested
c lshore:       logical variable denoting that shoreline fumigation requested
c lfum:         logical variable denoting inversion break-up and/or shoreline fumigation is requested
c ldebug:       logical variable denoting debug option is requested
c ltibl:        logical variable denoting that plume height is below TIBL height
c lfumhours:    logical variable denoting if there any hours for fumigation(true=yes,false=no)
c lrunscreen:   logical variable denoting AERMOD will be run(true) or not(false) when fumigation requested
c adjustar:     logical variable denoting to adjust u* (true) or not (false)
      integer ilog,bpipin,maininp,bpipout,iaersurf,iprompt,aermodin,
     +  aermapin,idemlist,aermplst,aermpkil,aermpdat,aermdout,aermpout,
     +  ascrnfil,ascrnout,isfcmet,ascrnplt,ascrnout3,discin,srcloc,
     +  ipass,isfcmet1,ipflmet,idebug,ascrnout4,ascrnout5
     
      logical runprobe,runflow,lterrain,lbpip,larea,lpoint,lflare,lcirc,
     +  lvolume,lcap,lhor,lmetric,lurban,lflagpole,laermsrc,lswitch,
     +  llat,lnad83,lngrid,lnadgrid,lcalc,lusebpip,changeprobe,lno2,
     +  lolm,lpvmrm,ldiscrete,ldefault,nocopy,lfumigate,lshore,lfum,
     +  ldebug,ldebug1,ltibl,lfumhours,runscreen,adjustar
     
c logical variables to denote input parameters are incorrectly formatted or invalid
c fixdim:       Maximum building dimension less than minimum building dimension
c fixht:        Building height is negative or zero
c fixorient:    Building direction angle negative or greater than 179 degrees
c fixsdist:     Stack to building center distance negative
c fixdir:       Stack angle to North negative or greater than 360 degrees
c fixtemp:      Minimum ambient temperature is equal to or greater than maximum
c               ambient temperature
c fixsc:        Surface characteristics are invalid
c fixaer:       AERSURFACE file does not exist (not true if AERSURFACE option not chosen)
c fixspd:       Minimum wind speed negative or zero
c fixaht:       Anemometer height is negative
c fixnad:       NAD not equal to 27 or 83 flag (1=27, 4=83)
c fixzone:      UTM zone negative
c fixprobe:     Probe distance less than or equal to zero 
c fixcoords:    UTM coordinates in AERSCREEN.INP may be incorrectly formatted
c foxprof:      PROFBASE, or source elevation incorrectly formatted, i.e. not a numeric string
c               when reading from AERSCREEN.INP.  There is no check on validity of numeric
c               value
c fixurban:     Urban population less than 100 people (not checked if rural source)
c fixflag:      Flagpole receptor height less than zero
c fixamb:       ambient distance negative or inside volume source
c fixemis:      Emission rate less than or equal to zero
c fixrht:       Stack height or emissions release height less than 0
c fixdiam:      Stack diameter less than zero
c fixrtemp:     Stack exit temperature incorrectly formatted, i.e. not a numeric string
c fixvel:       Stack exit velocity incorrectly formatted, i.e. not a numeric string
c fixflow:      Stack exit flow rate incorrectly formatted, i.e. not a numeric string
c fixsigy:      Initial sigma-y for volume source less than or equal to zero
c fixsigz:      Sigma-z less than zero
c fixxdim:      Long dimension of area source negative or zero
c fixydim:      Short dimension of area source negative or zero
c fixrad:       Circular area radius negative or zero
c fixunits:     Units flag not equal to "M" or "m"
c fixbpip:      Downwash flag not equal to upper or lower case "Y" or "N"
c fixter:       Terrain flag not equal to upper or lower case "Y" or "N"
c fixuflag:     Urban/rural flag not equal to upper or lowercase "U" or "R"  
c fixflag1:     Flagpole receptor indicator not equal to upper or lower case "Y" or "N" 
c fixaermp:     Flag indicating to use AERMAP for source elevation not equal to upper or 
c               lower case "Y" or "N" 
c fixdists:     Flag indicating that probe distance is less than ambient distance
c fixbpipfil:   Flag indicating that the user entered BPIPPRM input file does not exist
c fixnaddir:    Flag indicating no files exist in NADGRIDS directory
c fixdem:       Flag indicating that demlist.txt does not exist or not found
c fixalb:       Flag indicating that albedo may be out of range
c fixbow:       Flag indicating that Bowen ratio may be out of range
c fixzo:        Flag indicating that surface roughness may be out of range
c warnalb:      Nonfatal flag indicating that albedo > 1 and warn user
c warnbow:      Nonfatal flag indicating that Bowen ratio has large magnitude
c warnzo:       Nonfatal flag indicating that zo is small, < 0.001
c warnzo1:      Nonfatal flag indication zo is large, > 4 m
c fixntemp:     Flag indicating that temporal resolution in external surface characteristics
c               file incorrectly formatted
c fixsec:       Flag indicating problem with number of sectors in external surface characteristics
c               file
c nosurf:       Flag indicating no surface file found
c badsurf:      Flag indicating surface characteristics file incorrectly formatted
c fixout:       Flag indicating problem with AERSCREEN output filename
c fixout1:      Flag indicating AERSCREEN output filename contains AERSCREEN.LOG or aerscreen.log
c fixfold:      Flag indicating foldername for AERSCREEN output file is not valid 
c fixbpipfil2   Flag indicating that BPIPPRIME input filename is incorrectly formatted
c badbflag:     Flag indicating that PRIME flag not set in BPIP input file
c badstack:     Flag indicating bad stack information in BPIP input file
c lbademis:     Flag indicating that emissions line in AERSCREEN.INP has incorrectly
c               formatted variables, i.e. not numeric strings
c lbadbuild:    Flag indicating that building data line in AERSCREEN.INP has incorrectly
c               formatted variables, i.e. not numeric strings
c lbadmet:      Flag indicating that meteorological data line in AERSCREEN.INP has incorrectly
c               formatted variables, i.e. not numeric strings
c lbadter:      Flag indicating that terrain data line in AERSCREEN.INP has incorrectly
c               formatted variables, i.e. not numeric strings
c lbadunits:    Flag indicating that miscellaneous data line in AERSCREEN.INP has incorrectly
c               formatted variables, i.e. not numeric strings
c warnvel:      Flag indicating that negative velocity being set to 1e-05
c fixdum:       Flag indicating that AREA source rotation angle is not zero or non-numeric or
c               AREACIRC vertices are not 20 or non-numeric
c fixsrc:       Flag indicating that emissions data has errors and message will be written to user
c fixbuild:     Flag indicating that building data has errors and message will be written to user
c fixmet:       Flag indicating that meteorological data has errors and message will be written to user
c fixterr:      Flag indicating that terrain data has errors and message will be written to user
c fixmisc:      Flag indicating that units line of AERSCREEN.INP has errors and message written to user
c fixsurf:      Flag indicating error with surface characteristics code in AERSCREEN.INP
c fixclim:      Flag indicating error with climate code when surface code is 1 to 8 in AERSCREEN.INP
c fixheat1:     Flag indicating error with flare source heat input
c fixheat2:     Flag indicating error with flare source heat loss
c lbadmisc:     Flag indicating bad units data and error is fatal
c fixno2:       Flag indicating one or more NOx chemistry variables has error
c fixpvmrm:     Flag indicating that both PVMRM and OLM specified in AERSCREEN.INP
c fixolm:       Flag indicating that both PVMRM and OLM specified in AERSCREEN.INP
c fixno2stk:    Flag indicating that NO2/NOx stack ratio exceeds range or non-numeric
c fixo3:        Flag indicating ozone concentration is less than zero or non-numeric
c fixo3uni:     Flag indicating invalid ozone concentration units
c lno2poll:     Flag indicating that POLLUTID is NO2 in AERSCREEN.INP
c lno2stack:    Flag indicating NO2STACK found in AERSCREEN.INP
c lo3val:       Flag indicating OZONEVAL found in AERSCREEN.INP
c warnmint:     Nonfatal flag warning user that minimum ambient temperature may exceed reasonable values
c warnmaxt:     Nonfatal flag warning user that maximum ambient temperature may exceed reasonable values
c badform:      Array of logical variables used in reading AERSCREEN.INP to ensure variables are valid
c badorder:     Flag indicating that order of inputs incorrect in AERSCREEN.INP
c lstop:        Stop AERSCREEN because one of the above variables is true
c fixdisc:      Flag indicating to correct discrete receptor problems
c nodisfil:     Flag indicating that discrete receptor file doesn't exist
c fixdisfl:     Flag indicating to correct discrete receptor use flag
c negdisc:      Flag indicating that discrete receptors have negative distances
c baddisc:      Flag indicating that incorrect discrete receptor units used
c lbadfum:      Flag indicating bad fumigation inputs in AERSCREEN.INP
c fixfum:       Flag indicating that inversion break-up or shoreline fumigation options are bad in AERSCREEN.INP
c fixfum1:      Flag indicating inversion break-up fumigation option bad in AERSCREEN.INP
c fixshore1:    Flag indicating that shoreline fumigation flag is incorrect in AERSCREEN.INP
c fixshore2:    Flag indicating that distance to shoreline is bad or > 3000 m in AERSCREEN.INP
c fixshore3:    Flag indicating that shoreline direction is bad in AERSCREEN.INP
c fixscreen:    Flag indicating that run AERSCREEN option incorrect in AERSCREEN.INP
c fixdebug:     Flag indicating that debug flag incorrect in AERSCREEN.INP
c lbadbug:      Flag indicating that debug flag is invalid in AERSCREEN.INP
c emisdat:      Logical variable denoting that emissions data line found in AERSCREEN.INP
c builddat:     Logical variable denoting that building data line found in AERSCREEN.INP
c metdat:       Logical variable denoting that meteorological data line found in AERSCREEN.INP
c terrdat:      Logical variable denoting that terrain data line found in AERSCREEN.INP
c discdat:      Logical variable denoting that discrete receptor data line found in AERSCREEN.INP
c miscdat:      Logical variable denoting that miscellaneous data line found in AERSCREEN.INP
c fumdat:       Logical variable denoting that fumigation data line found in AERSCREEN.INP
c outdat:       Logical variable denoting that output filename data line found in AERSCREEN.INP
c ustardat:     Logical variable denoting that u* line found in AERSCREEN.INP
c lbadustar:    Logical variable denoting that u* adjustment flag is invalid
      logical fixdim,fixht,fixorient,fixsdist,fixdir,fixtemp,
     +  fixsc,fixaer,fixspd,fixaht,fixnad,fixzone,fixprobe,fixcoords,
     +  fixprof,fixurban,fixflag,fixamb,fixemis,fixrht,fixdiam,fixrtemp,
     +  fixvel,fixflow,fixsigy,fixsigz,fixxdim,fixydim,fixrad,fixunits,
     +  fixbpip,fixter,fixuflag,fixflag1,fixaermp,fixdists,fixbpipfil,
     +  fixnaddir,fixdem,fixalb,fixbow,fixzo,warnalb,warnbow,warnzo,
     +  warnzo1,fixntemp,fixsec,nosurf,badsurf,fixout,fixfold,fixout1,
     +  fixbpipfil2,badstack,badbflag,lstop,lbademis,lbadbuild,lbadmet,
     +  lbadter,lbadunits,warnvel,fixdum,fixsrc,
     +  fixbuild,fixmet,fixterr,fixmisc,fixsurf,fixclim,fixheat1,
     +  fixheat2,lbadmisc,fixno2,fixpvmrm,fixolm,fixno2stk,fixo3,
     +  fixo3uni,lno2poll,lno2stack,lo3val,warnmint,warnmaxt,
     +  fixdisc,nodisfil,negdisc,fixdisfl,emisdat,builddat,metdat,
     +  terrdat,discdat,outdat,miscdat,badorder,baddisc,lbadfum,fixfum,
     +  fixfum1,fixshore1,fixshore2,fumdat,fixdebug,lbadbug,
     +  fixshore3,fixscreen,ustardat,lbadustar
        logical, allocatable, dimension(:) :: badform
c assign values to file units     
      parameter (ilog=1,bpipin=2,maininp=3,bpipout=4,iaersurf=55,
     +  iprompt=66,aermodin=7,aermapin=8,idemlist=9,aermplst=10,
     +  aermpkil=11,aermpdat=12,aermdout=13,aermpout=14,ascrnfil=15,
     +  ascrnout=16,isfcmet=17,ascrnplt=18,ascrnout3=19,srcloc=20,
     +  discin=21,isfcmet1=22,ipflmet=23,
     +  ascrnout4=26,ascrnout5=27)
      parameter(maxdisc=10)
c     quote1
      parameter(quote1='"')
c degrees to radians conversion (pi/180)       
      parameter (degrad=0.017453)
      parameter (govrcp=0.00977,vonkar=0.4,g=9.80616,rtof2=sqrt(2.0),
     +rtofpi=sqrt(4.00*ATAN(1.00)),third=1.0/3.0)
c version number 
c      parameter (versn='BETA1')
!      parameter (versn='11053')
!      parameter (versn='11060')
!      parameter (versn='11076')
!      parameter (versn='11126')
c      parameter (versn='16216')
	parameter (versn='21112')
c AERMET surface roughness table (Table 4-3, pg. 4-51 of AERMET User's Guide)
c order in data statement below is spring, summer, autumn, winter:
c water, deciduous forest, coniferous forest, swamp, cultivated land,
c grassland, urban, desert shrubland

      DATA roughlen /0.001, 0.001, 0.001, 0.001,
     +                1.00, 1.30, 0.80, 0.50,
     +                1.30, 1.30, 1.30, 1.30,
     +                0.20, 0.20, 0.20, 0.05,
     +                0.03, 0.20, 0.05, 0.01,
     +                0.05, 0.10, 0.01, 0.001,
     +                1.00, 1.00, 1.00, 1.00,
     +                0.30, 0.30, 0.30, 0.15/


c --- Bowens Ratios (Average Moisture)
c AERMET average Bowens ratios table (Table 4-2b, pg. 4-50 of AERMET User's Guide)
c order in data statement below is spring, summer, autumn, winter:
c water, deciduous forest, coniferous forest, swamp, cultivated land,
c grassland, urban, desert shrubland
       DATA bowen /0.1, 0.1, 0.1, 1.5,
     +             0.7, 0.3, 1.0, 1.5,
     +             0.7, 0.3, 0.8, 1.5,
     +             0.1, 0.1, 0.1, 1.5,
     +             0.3, 0.5, 0.7, 1.5,
     +             0.4, 0.8, 1.0, 1.5,
     +             1.0, 2.0, 2.0, 1.5,
     +             3.0, 4.0, 6.0, 6.0,

c --- Bowens Ratio (Wet Conditions)
c AERMET wet Bowens ratios table (Table 4-2c, pg. 4-51 of AERMET User's Guide)
c order in data statement below is spring, summer, autumn, winter:
c water, deciduous forest, coniferous forest, swamp, cultivated land,
c grassland, urban, desert shrubland
     +             0.1, 0.1, 0.1, 0.3,
     +             0.3, 0.2, 0.4, 0.5,
     +             0.3, 0.2, 0.3, 0.3,
     +             0.1, 0.1, 0.1, 0.5,
     +             0.2, 0.3, 0.4, 0.5,
     +             0.3, 0.4, 0.5, 0.5,
     +             0.5, 1.0, 1.0, 0.5,
     +             1.0, 5.0, 2.0, 2.0,

c --- Bowens Ratio Dry Condition)
c AERMET dry Bowens ratios table (Table 4-2a, pg. 4-50 of AERMET User's Guide)
c order in data statement below is spring, summer, autumn, winter:
c water, deciduous forest, coniferous forest, swamp, cultivated land,
c grassland, urban, desert shrubland
     +             0.1, 0.1, 0.1, 2.0,
     +             1.5, 0.6, 2.0, 2.0,
     +             1.5, 0.6, 1.5, 2.0,
     +             0.2, 0.2, 0.2, 2.0,
     +             1.0, 1.5, 2.0, 2.0,
     +             1.0, 2.0, 2.0, 2.0,
     +             2.0, 4.0, 4.0, 2.0,
     +             5.0, 6.0, 10.0, 10.0/


c --- Albedo Parameters
c AERMET albedo table (Table 4-1, pg. 4-49 of AERMET User's Guide)
c order in data statement below is spring, summer, autumn, winter:
c water, deciduous forest, coniferous forest, swamp, cultivated land,
c grassland, urban, desert shrubland

       DATA albedo   /0.12, 0.10, 0.14, 0.20,
     +                0.12, 0.12, 0.12, 0.50,
     +                0.12, 0.12, 0.12, 0.35,
     +                0.12, 0.14, 0.16, 0.30,
     +                0.14, 0.20, 0.18, 0.60,
     +                0.18, 0.18, 0.20, 0.60,
     +                0.14, 0.16, 0.18, 0.35,
     +                0.30, 0.28, 0.28, 0.45/
     
c--- Months
      data month /'January','February','March','April','May','June',
     +  'July','August','September','October','November','December'/
c  seasons based on AERSURFACE output
      data season2 /'Winter','Spring','Summer','Autumn'/
c landuse categories for AERMET tables (same order as in tables and data statements)
      data landuse /'Water','Deciduous Forest','Coniferous Forest',
     +  'Swamp','Cultivated Land','Grassland','Urban',
     +  'Desert Shrubland'/
c climate categories
      data climate /'Average Moisture','Wet Conditions',
     + 'Dry Conditions'/
      end module main1
c**************************************************************************************
      PROGRAM AERSCREEN  !version 09271
c main program
      use main1
      implicit none
      
c lexist:   logical variable denoting if AERMOD or MAKEMET executables exist
c rundate:  date of program execution start
c runtime:  time of program execution start

      logical lexist
c      character rundate*8,runtime*8
c      integer ipass

      
c      real diag
c      bexist = .false.
     
c      open log file and get start time/date
      open(unit=ilog,file='aerscreen.log',status='unknown')
      CALL DATIME (RUNDATE, RUNTIME)
      
c     write start time to log file
      write(ilog,20)rundate,runtime
 20   format(/'Start date and time ',2(1x,a8))
 

c --- Check for essential executables: AERMOD and MAKEMET
!      inquire(file='AERMOD.EXE',exist=lexist)
!      if( .not.lexist )then
!        inquire(file='MAKEMET.EXE',exist=lexist)
!        if( .not.lexist )then
!          write(*,40)
!          write(ilog,40)
!          call getexe(1)
!          call getexe(2)
!        else
!          write(*,41)
!          write(ilog,41)
!        endif
!!        stop
!      else
!        inquire(file='MAKEMET.EXE',exist=lexist)
!        if( .not.lexist )then
!          write(*,42)
!          write(ilog,42)
!!          CALL DATIME (RUNDATE, RUNTIME)
!!          write(ilog,21)RUNDATE,RUNTIME
!!          stop
!        endif
!      endif
!      
!! 40   format(1x,'AERMOD.EXE and MAKEMET.EXE Files Not Found!! ',
!!     +  'Aborting!!')
!! 41   format(1x,'AERMOD.EXE File Not Found!! Aborting!!')
!! 42   format(1x,'MAKEMET.EXE File Not Found!! Aborting!!')
! 40   format(1x,'AERMOD.EXE and MAKEMET.EXE Files Not Found!!')
! 41   format(1x,'AERMOD.EXE File Not Found!!')
! 42   format(1x,'MAKEMET.EXE File Not Found!!')
! 21   format(/1x,'End date and time ',2(1x,a8))
 
c --- Set GEP flag to zero ---
      igep = 0

c --- Blank BPIP file ---
      bpipfile = ' '

c --- Delete old BPIPPRM.INP file
      open(bpipin,file='bpipprm.inp',status='unknown')
      close(bpipin,status='delete')

c --- Set initial stack base elevation ---
      base = -9999.


c --- Clear initial dem prompts ---
c      dem = 'n '

c --- Initial screen clear ---
      call system("cls")

c for unix/linux
c     call system("clear")
      write(*,101)versn
      write(ilog,101)versn
     
! 101  format(21x,'AERSCREEN ',a5,' - beta release version'/)
 101  format(29x,'AERSCREEN ',a5/)
      write(*,*)' '
      write(*,*)' '
      write(*,*)' '


c --- Check for input file on command line ---
c      call readinp(ipass)
      call readinp
c     if AERSCREEN.INP data used and no errors go to validate
c     if AERSCREEN.INP data exists but there are errors go to finalwrite and end program
c     if ipass = 0, user will enter data
      if (ipass .ne. 0 .and. .not. lstop) goto 10
      if (ipass .ne. 0 .and. lstop) goto 998

c     ipass =0, user will enter data using prompts     
c     get initial units (English or metric) and source type
      call initprompts       

c     argument of 0 to stacks, downwash, getDEMs and metdata means
c     these are initial prompts of data entry by user

c     get source parameters
      call stacks(0)
c     get building downwash
      call downwash(0)
c     get terrain information
      call getDEMs(0)
      
      if (lstop) then  
        if (fixdem) then
          write(*,1037)
          write(ilog,1037)
        else
          write(*,1038)trim(adjustl(nadpath1))
          write(ilog,1038)trim(adjustl(nadpath1)) !problem with NADGRIDS directory, no files in directory
        endif
        goto 998
      endif
 1037 format(/1x,'demlist.txt does not exist')
 1038 format(/1x,'No grid files exist in the NADGRIDS folder: ',a)      
c     prompt for met data
      call metdata(0)
      if (lstop) then
        goto 998
      endif

c     prompt for fumigation
      call fuminp(0)

c     prompt for debug
      call setdebug(0)
c     prompt user for output filename
      call getoutfil

c --- Verify data entry then run BPIP and MAKEMET ---

   10 call validate
      

c   10 call validate(ipass)   
      if (lstop) then 
        goto 998
      endif
      
c --- Check for GEP status - Avoid wake calculations if true ---
ctmprwb      if(igep .ne. 0)bpip = 'n'   ! this line looks extraneous?

c     allocate arrays

      call allocarray
      if (lstop) goto 998
c versn 08087 add values to matrices of surface characteristics from
c     either user entered values, AERMET tables, or AERSURFACE output
c     and run makemet2
      call surface
       
c     if not running screening model and fumigation only, create a simple AERSCREEN.INP
c     file for later runs
      if (.not. runscreen) then
          call makeinput(1,1,1)
          goto 55
      endif
c     set runprobe logical variable
c     if no terrain and no downwash and source is not rectangular area, runprobe = true
c     otherwise runprobe = false
       if ((.not. lterrain) .and. (.not. lbpip) .and. 
     +  (.not. larea)) then 
        runprobe=.true. 
        runflow=.false.
      else
        runprobe=.false.
        runflow=.true.
      endif
      
      
c     if terrain is being used, run AERMAP for the source location to
c     get the elevation and compare against the user value or substitute the
c     AERMAP value for the user value.
      istage=0
      if (lterrain) call maketerrain
    
c --- Stage 1 - run for flat terrain without downwash and source is not a rectangular area source ---    
      if (runprobe) call probe()
      if (lstop) then 
        goto 998
      endif
      
c --- Stage 2 - If building/terrain is present or rectangular area source, determine worse case sector ---
c      if(lbpip .or. lterrain .or. larea) then
      if (runflow) then
        write(*,15)
        write(ilog,15)
        call flowsector
        if (lstop) then 
          goto 998
        endif
      endif
      
 15   format(/'Buildings and/or terrain present or rectangular area ',
     +  'source, skipping probe')
c --- Stage 3  - Refine impacts for automated & overall maximum  -----
c      istage = 3
      
      call refine()
      
cnew routine for fumigation

 55   if (lfumigate .or. lshore) then
          call subsetmet
          if (lfumhours) then
              if (lfumigate) call fumigate()
              if (lshore) call shoreline()
              if (ldebug) close(ascrnout5)
          endif
      endif
      
      if (lstop) then 
        goto 998
      endif
c --- Create output file
      call output()

c --- Delete temporary & junk files ---
      call delfiles
c     deallocate arrays
      call dealloc
c     write final successful or unsuccessful message to log
998    call finalwrite
      end
c -----------------------------------------------------------------------------
      subroutine getexe(mod1)
c     this subroutine prompts the user for AERMOD, MAKEMET, BPIPPRM, or
c     AERMAP executables.  User will be prompted for location and 
c     the executable will be copied to the current folder
      use main1
      implicit none
      
c mod1:       numeric code identifying which executable to check
c modl:       executable to copy to
c exefil:     location of executable to copy
c copyline:   command denoting to copy file
c i:          loop counter

      character modl*11,exefil*250,copyline*280,exefil1*250
      integer mod1,i,inquote1,inquote2
      logical lexist
      
      inquote1=0
      inquote2=0
      if (mod1 .eq. 1) then
        modl='AERMOD.EXE'
      elseif (mod1 .eq. 2) then
        modl='MAKEMET.EXE'
      elseif (mod1 .eq. 3) then
        modl='BPIPPRM.EXE'
      elseif (mod1 .eq. 4) then
        modl='AERMAP.EXE'
      else
        write(*,*)'invalid number'
        return
      endif
      
      inquire(file=modl,exist=lexist)
      if (lexist) goto 100
      
  5   write(*,10)trim(adjustl(modl))
!      read(*,*)exefil
      read(*,'(a)')exefil1
      inquote1=index(exefil1,quote1)
      if (inquote1 .gt. 0) then
          inquote2=index(exefil1(inquote1+1:250),quote1)
          if (inquote2 .eq. 0) goto 5
          inquote2=inquote1+inquote2-1
          exefil=trim(adjustl(exefil1(inquote1+1:inquote2)))
      else
          exefil=trim(adjustl(exefil1))
      endif
c     check for existence of file
      inquire(file=exefil,exist=lexist)
      if (.not. lexist) then
        write(*,11)
        goto 5
      endif
      
      write(copyline,20)quote1,trim(adjustl(exefil)),quote1,
     +trim(adjustl(modl))
      call system(copyline)
c     double check to make sure executable now in current folder
      inquire(file=modl,exist=lexist)
      if (.not. lexist) then
        write(*,25)trim(adjustl(modl))
        lstop=.true.
      endif
  10  format(/1x,a,' file not found'/1x,'Enter full',
     + ' pathname of executable and it will be copied '/1x,
     + 'to the current folder'/1x,'If location contains spaces',
     + ' enter filename in quotations'/)
  11  format(/1x,a/1x,'does not exist'/)
!  20  format('copy "',a,'"'1x,a)
  20  format('copy ',3a,1x,a)
!  20  format('cp ',3a,1x,a)    !for unix/linux  
  25  format(/1x,'Error occurred in copying of ',a,
     + ' stopping AERSCREEN')
      
100   return
      end
      
c -----------------------------------------------------------------------------
      subroutine setdebug(iskip)
      use main1
      implicit none
      
      integer iskip,n1
      character response*15
      logical lblank,lbad
      
      call header()
      
  5   if (iskip .eq. 0) then
          write(*,10)
          read(*,'(a)')response
          call checkanswer(response,lblank,lbad,1)
          if (lbad) then
              write(*,15)
              goto 5
          endif
          if (lblank) then
              ldebug=.false.
              debugflg='N'
          else
              read(response,*)debugflg
              call upcase(debugflg)
              if (debugflg .eq. 'Y') then
                  ldebug=.true.
              elseif (debugflg .eq. 'N') then
                  ldebug=.false.
              else
                  write(*,15)
                  goto 5
              endif
          endif
      else
          if (ldebug) then
              ldebug=.false.
              debugflg='N'
          else
              ldebug=.true.
              debugflg='Y'
          endif
      endif
      
      if (ldebug) then
          if (outfil .eq. 'AERSCREEN.OUT') then
              debugfil='concentrations.txt'
              if (lfumigate) fumfil='fumigate_debug.txt'
          else
              n1=index(outfil,'.OUT')
              debugfil=outfil(1:n1-1)//'_concentrations.txt'
              if (lfumigate) 
     +        fumfil=outfil(1:n1-1)//'_fumigate_debug.txt'
          endif
      endif
      
 10   format(/'Enter Y or y to turn on the debug option or <Enter> ',
     +'to not use the debug option'/)
  15  format(/'Debug option is invalid')
      return
      end
      
c -----------------------------------------------------------------------------
      subroutine getoutfil
c     prompt user for output filename, default is AERSCREEN.OUT
c     subroutine will check for the existence of the entered filename
c     or that has a valid pathname, if the file doesn't exist
c     if the pathname isn't valid, user will be re-prompted for filename
c     filename must have .OUT extension
c     version 15181, go ahead and create filenames for other output files
      use main1
      implicit none
      
c outfil2:    temporary output filename.  Name entered by user
c goodfile:   logical variable denoting if pathname of output file is okay
c i:          loop counter
c n1:         index value of .OUT from outfil1
c n2:         n1+4, check to make sure extension is just .OUT and not .OUT1 or something
c             similar
c q1:         index of first quotations in outfil2
c q2:         index of second set of quotations in outfil2
      character outfil2*250
      logical goodfile
      integer i,n1,n2,q1,q2

c     clear screen and prompt user for filename if entering data from prompts
c     remove trailing blanks, outfil will be the final output filename
       
        call header()
 11     write(*,2000)
        read(*,'(a)')outfil2
        q1=index(outfil2,quote1)
        if (q1 .gt. 0) then
          q2=index(outfil2(q1+1:250),quote1)
          if (q2 .eq. 0) goto 11
          outfil=trim(adjustl(outfil2(q1+1:q1+q2-1)))
        else
          outfil=trim(adjustl(outfil2))
        endif
      
      if (outfil .eq. '') then
        outfil='AERSCREEN.OUT'
        logfil='AERSCREEN.LOG'
        inpfile='AERSCREEN.INP'
        maxfil='max_conc_distance.txt'
        if (ldebug) then 
            debugfil='concentrations.txt'
            if (lfumigate .or. lshore) fumfil='fumigate_debug.txt'
        endif
        ldefault=.true.
      else
c       convert filename to all uppercase for QA purposes
        outfil1=outfil
        do i=1,250
          call upcase(outfil1(i:i))
        enddo
        if (outfil1 .eq. 'AERSCREEN.OUT') then
          ldefault=.true.
        else
          ldefault=.false.
        endif
        n1=index(outfil1,'.OUT')
        if (n1 .eq. 0) then
c         filename does not have .OUT extension, alert user and re-prompt
          write(*,2002)
          goto 11
        else
c         make sure filename does not have an extension with .out but may be
c         something else like .out1 or .out2
c         if extension is not .out, alert user and re-prompt
          n2=n1+4
          if (n2 .le. 250) then
            if (outfil1(n2:n2) .ne. ' ') then
              write(*,2002)
              goto 11
             endif
          endif
        endif
c       check to see if filename is good
c       if goodfile is false, re-prompt
        call checkfile(goodfile)
        if (.not. goodfile) then
          write(*,2003)
          goto 11
        endif
        maxfil=outfil(1:n1-1)//'_max_conc_distance.txt'
        if (ldebug) then
            debugfil=outfil(1:n1-1)//'_concentrations.txt'
            if (lfumigate .or. lshore) fumfil=outfil(1:n1-1)//
     +        '_fumigate_debug.txt'  
       endif
         
        logfil=outfil(1:n1-1)//'.log'
        inpfile=outfil(1:n1-1)//'.inp'
      endif  
!2000  format(/,1x,'Enter name of AERSCREEN output file'/1x,
!     + 'Enter <Enter> to use default name AERSCREEN.OUT'/1x,
!     + 'Filename should include .out or .OUT extension and'/1x,
!     + 'Filename cannot be AERSCREEN.LOG'/1x,
!     + 'If filename contains spaces, enter entire filename in ',
!     + 'quotations'/)
2000  format(/,1x,'enter name of aerscreen output file'/1x,
     + 'enter <enter> to use default name aerscreen.out'/1x,
     + 'filename should include .out or .out extension'/1x,
     + 'if filename contains spaces, enter entire filename in ',
     + 'quotations'/)
!2001  format(/,1x,'Output file is AERSCREEN.LOG')  
2002  format(/1x,'Output file does not have .out extension')
2003  format(/1x,'Pathname of output file does not exist')

 100  return
      end
c -----------------------------------------------------------------------------
      subroutine initprompts
c     subroutine to get initial data from user
      use main1
      implicit none

c char1:        1-character variable denoting source type
c response:     response to prompts
c lblank:       logical variable denoting if response is all blanks
c lbad:         logical variable denoting if response is bad
      character char1*1,response*15
      logical lblank,lbad
c     clear out any old source data
      emisrate=0.0
      height=0.0
      diameter=0.0
      temperature=0.0
      velocity=0.0
      flowrate=0.0
      flare_hgt=0.0
      heat=0.0
      heatloss=0.0
      syinit=0.0
      szinit=0.0
      xinit=0.0
      yinit=0.0
      circrad=0.0
      populat=0.0
      xnear=0.0
      no2stack=0.0
      o3=0.0
      o3units=''
      urban=''
      populat=0.0
c --- Clear out any old building data and terrain data
      bheight = 0.0
      blength = 0.0
      bwidth = 0.0
      bangle = 0.0
      sangle = 0.0
      sdistance = 0.0
      bpipfile=''
c --- Clear out any old terrain data
      utmx = 0.0
      utmy = 0.0
      izone = 0
      nada = 0
      flagpole=0.0
      probedist=0.0
      base=0.0
      flgswitch=''
c --- Clear out met data
      ambtmin=0.0
      ambtmax=0.0
      wsmin=0.0
      anemht=0.0
      isurf=0
      iclim=0
      aersurf=''
      useralbe=0.0
      userbown=0.0
      userlen=0.0      
c     initialize logical variables to overwrite value from initial reading of 
c     AERSCREEN.INP
      lpoint=.false.
      lvolume=.false.
      lflare=.false.
      larea=.false.
      lcirc=.false.
      lcap=.false.
      lhor=.false.
      ldiscrete=.false.
      discfile=''
c      ldefault=.false.
	ldefault=.true.
c -- Opening program prompts ---

      write(*,105)
      read(*,'(a)')title
      write(ilog,102)title
 105  format(/'         ------------------  INITIAL ',
     +          'INFORMATION  -------------------'///' Enter Title: '\) 
 102  format(a,/)


c     prompt for English or metric units.
c     English can only be used when entering data via the prompts
 
 5    write(*,103)
      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,1)
      if (lbad .or. lblank) then
        write(*,999)trim(adjustl(response))
        goto 5
      endif
      units=trim(adjustl(response))
      call upcase(units)
      if(units .eq. 'M') then 
        lmetric=.true.
      else if (units .eq. 'E') then
        lmetric=.false.
      else
        write(*,999)units
        goto 5
      endif
 103  format(//' English or Metric Units? (E or M): '\)

c     prompt for source type  
  1   write(*,104)

      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,1)
      if (lbad .or. lblank) then
        write(*,999)trim(adjustl(response))
        goto 1
      endif
      char1=trim(adjustl(response))
      call upcase(char1)
      if(char1 .eq. 'P') then
        lpoint=.true.
        stype='P'
      else if(char1 .eq. 'V') then 
         stype = 'V'
         lvolume=.true.
      else if(char1 .eq. 'A') then 
         stype = 'A'
         larea=.true.
      else if(char1 .eq. 'C') then
        stype = 'A'
        lcirc=.true.
      else if(char1 .eq. 'F') then
        stype = 'F'
        lflare=.true.
      else if(char1 .eq. 'H') then
        stype='H'
        lhor=.true.
      else if(char1 .eq. 'S') then
        stype='S'
        lcap=.true.
      else
        write(*,999)char1
        goto 1
      endif
      
 104  format(//' POINT, VOLUME, AREA, AREACIRC, FLARE, POINTCAP,',
     & 'or POINTHOR Source? '/1x,'(P, V, A, C, F, S, or H): '\)
  999 format(1x,a,' is an invalid response')   
      return
      end
                  
c -----------------------------------------------------------------------------
      subroutine readinp
c     subroutine to read AERSCREEN.INP and prompt user to continue with inputs
c     from AERSCREEN.INP or start with new parameters
      use main1
      implicit none

c line:       character string of lines being read from AERSCREEN.INP
c bline:      character string of DOS command to copy BPIP input file to bpipprm.inp
c temp:       character string of 1st 12 characters of line
c answer:     character response
c ano2stack:  character string of NO2STACK ratio
c ao3:        character string of ozone background concentration
c o3units1    character string of ozone concentration units
c response    character string of response to continue with AERCREEN.INP inputs
c outfil2:    temporary output filename read from aerscreen.inp
c inexist:    logical variable indicating existence of AERSCREEN.INP
c bexist:     logical variable indicating existence of BPIP inputfile
c goodfile:   logical variable denoting that output file path is valid
c lbad:       logical variable denoting that response is invalid
c             i.e., when response should be number, response has non-numeric characters
c lblank:     logical variable denoting that response is all blanks    
c xsav:       x-dimension of AREA source and is set when xinit < yinit and yinit is reset
c             to xsav
c idummy:     rotation angle for AREA source or number of vertices for AREACIRC source
c             should be 0.0 for AREA source and 20 for AREACIRC source
c n:          index length for string '** OUTPUT FILE'
c pvmrmind:   index of ' PVMRM ' in MODELOPT keyword string
c olmind:     index of ' OLM ' in MODELOPT keyword string
c stkind:     index of 'NO2STACK' 
c o3ind:      index of 'OZONEVAL' 
c i:          loop counter
c no2poll:    index of 'NO2' in POLLUTID keyword string
c o3len:      length of string representing ozone background concentration
c o3indx:     index of ozone background string
c n1:         index of .OUT from outfil1
      character line*250,bline*100,temp*60,answer*1,ano2stack*15,ao3*15,
     + o3units1*200,response*15,outfil2*250
      logical inexist,bexist,goodfile,lbad,lblank
      
      real xsav,idummy
      integer n,pvmrmind,olmind,stkind,o3ind,i,no2poll,o3len,
     + o3indx,n1,n2
 
c initialize variable ipass 
      ipass = 0

c initialize emission variables to zero
      emisrate=0.0
      height=0.0
      temperature=0.0
      velocity=0.0
      diameter=0.0
      flowrate=0.0
      flare_hgt=0.0
      heat=0.0
      heatloss=0.0
      syinit=0.0
      szinit=0.0
      xinit=0.0
      yinit=0.0
      circrad=0.0
      

c initialize parameter check logical variables to false
c false=parameter is valid, true=parameter is invalid
      lstop=.false.
c      lexist = .false.
      lbad=.false.
c source logical variables
      emisdat = .false.
      fixemis =.false. 
      fixrht =.false. 
      fixdiam =.false. 
      fixsigy =.false. 
      fixsigz =.false.
      fixxdim =.false. 
      fixydim =.false. 
      fixrad =.false.     
      
c building variables
      builddat=.false.
      fixht =.false. 
      fixdim =.false. 
      fixorient =.false.
      fixsdist=.false. 
      fixdir = .false.
      fixbpipfil=.false.     
      fixbpip=.false.   
      lusebpip=.false.
      fixbpipfil2=.false.
      badbflag=.false.
      badstack=.false.   
c meteorological variables
      metdat=.false.
      ustardat=.false.
      fixtemp =.false. 
      fixsc =.false. 
      fixaer =.false. 
      fixspd =.false. 
      fixaht =.false.
      fixalb=.false.
      fixbow=.false.
      fixzo=.false.
      warnalb=.false.
      warnbow=.false.
      warnzo=.false.
      warnzo1=.false.
      nosurf=.false.
      fixsurf=.false.
      fixclim=.false.
      warnmint=.false.
      warnmaxt=.false.
      lbadustar=.false.  !16216
c terrain variables
      terrdat=.false.
      lngrid=.false.
      lnadgrid=.false. 
      lcalc=.false.
      fixprobe =.false. 
      fixzone =.false. 
      fixnad =.false. 
      fixnaddir=.false.     
      fixter=.false. 
      fixcoords=.false.
      fixprof=.false.
c other variables
      miscdat=.false.
      discdat=.false.
      fumdat=.false.
      outdat=.false.
      lswitch = .false.     
      fixunits=.false.
      fixflag=.false.
      fixuflag=.false.
      fixflag1=.false.
      fixaermp=.false.
      fixamb=.false.
      fixdists=.false.
      fixurban=.false.
      inexist = .false.
      bexist=.false.
      fixout=.false.
      fixout1=.false.
      fixfold=.false.
      fixfum1=.false.
!     fixfum2=.false.   !fumigation and urban (not used)
      fixfum=.false.
      fixshore1=.false.
      fixshore2=.false.
      fixshore3=.false.
      fixscreen=.false.
      fixdebug=.false.
     
c initialize source type logical variables
      lpoint=.false.
      lvolume=.false.
      lflare=.false.
      lcirc=.false.
      larea=.false.
      lcap=.false.
      lhor=.false.

c     initialize bad format logical variables
      lbademis=.false.
      lbadbuild=.false.
      lbadmet=.false.
      lbadter=.false.
      lbadunits=.false.
c      warntemp=.false.
      warnvel=.false.
c     initialize master logical variables that denote a problem
c     with one of the data sections
c     these were formerly local variables in the subroutine checkdat
c     which writes error messages for AERSCREEN.INP
      fixsrc=.false.
      fixbuild=.false.
      fixmet=.false.
      fixterr=.false.
      fixmisc=.false.
      fixdisc=.false.
      fixdisfl=.false.
      baddisc=.false.
      badorder=.false.
c     NO2 logical variables
      lno2=.false.
      lpvmrm=.false.
      lolm=.false.
      fixno2=.false.
      fixpvmrm=.false.
      fixolm=.false.
      fixno2stk=.false.
      fixo3=.false.
      fixo3uni=.false.
      lno2poll=.false.
      lno2stack=.false.
      lo3val=.false.
      no2stack=-1.0
      o3=-1.0
      o3len=0
      o3indx=0
      pvmrmind=0
      olmind=0
      stkind=0
      o3ind=0

      
c     check for AERSCREEN.INP existence      
      inquire(file='aerscreen.inp',exist=inexist)
     
c if AERSCREEN.INP does not exist, user must enter data
      if (.not. inexist) then
        write(*,1)
        goto 500
      endif
1     format(' AERSCREEN.INP does not exist'/' User must enter data')   



      open(maininp,file='aerscreen.inp',status='old',err=99)

  10  read(maininp,'(a)',end=98)line
      do i=1,250
        call upcase(line(i:i))
      enddo
      read(line,'(a12)')temp
      

c --- Read Stack data ---
c --- point source, capped stack or horizontal point source
c change order of variables to match order of AERMOD.INP JAT 04/29/09
c leave flowrate at end
      if(temp .eq. '** STACK DAT' .or. temp .eq. '** POINTCAP ' .or.
     + temp .eq. '** POINTHOR ')then
        emisdat=.true.
        if (temp .eq. '** STACK DAT') then
          stype = 'P'
          lpoint=.true.
        else if (temp .eq. '** POINTCAP ') then
          stype = 'S'
          lcap=.true.
        else
          stype = 'H'
          lhor=.true.
        endif
c 11/29/2010 add code to read the emissions data as a character
c string and check to make sure the correct number of fields
c then read the variables from the character string
!       read(maininp,*) temp,emisrate,height,temperature,
!     +           velocity,diameter,flowrate
        read(maininp,'(a)')line
        allocate(badform(6))
        call checkline(line,6,temp,lbademis)
        if (.not. lbademis) then
          backspace(maininp)
          read(maininp,*) temp,emisrate,height,temperature,
     +           velocity,diameter,flowrate
          if(velocity .eq. 0)then
c         velocity = flowrate / diameter**2. * 0.0006009
          elseif (velocity .lt. 0) then
            warnvel=.true.
            velocity=0.000001
          else
            flowrate = velocity * diameter**2. / 0.0006009
          endif
c          if (temperature .lt. 0) warntemp=.true.
c          if (temperature .lt. 0) fixrtemp=.true.
          if (emisrate .le. 0) fixemis=.true.
          if (height .lt. 0) fixrht=.true.
          if (diameter .lt. 0) fixdiam=.true.
          if (fixemis .or. fixrht .or. fixdiam) 
     +    fixsrc=.true.
c        goto 10
        else
          fixsrc=.true.
          if (badform(1)) fixemis=.true.
          if (badform(2))fixrht=.true.
          if (badform(3)) fixrtemp=.true.
          if (badform(4)) fixdiam=.true.
          if (badform(5)) fixvel=.true.
          if (badform(6)) fixflow=.true.
        endif
        deallocate(badform)
        goto 10
      endif
      
c --- Read Flare data ---
      if(temp .eq. '** FLARE DAT')then
        emisdat=.true.
        stype = 'F'
        lflare=.true.
!        read(maininp,*) temp,emisrate,flare_hgt,heat,heatloss 
        read(maininp,'(a)')line
        allocate(badform(4))
        call checkline(line,4,temp,lbademis)
        if (.not. lbademis) then
          backspace(maininp)
          read(maininp,*) temp,emisrate,flare_hgt,heat,heatloss 
c ---     SET EFFECTIVE STACK PARAMETERS
          velocity = 20.0
          temperature = 1273.
          if (heat .le. 0.0) fixheat1=.true.
          if (heatloss .lt. 0.0) heatloss=0.0
c ---     Note default heatloss fraction should be 0.55
          diameter = 9.88E-04*SQRT((1.-heatloss)*heat)
          IF (diameter .LT. 1E-05) diameter=1.0E-05
c ---     Compute effective release height for top of flare
          height = flare_hgt + 4.56E-03 * heat**0.478
          if (emisrate .le. 0) fixemis=.true.
          if (flare_hgt .lt. 0) fixrht=.true.
          if (fixemis .or. fixrht .or. fixheat1)fixsrc=.true.
        else
          fixsrc=.true.
          if (badform(1)) fixemis=.true.
          if (badform(2)) fixrht=.true.
          if (badform(3)) fixheat1=.true.
          if (badform(4)) fixheat2=.true.
        endif
        deallocate(badform)
        goto 10
      endif
       
c --- Read Volume source data ---
      if(temp .eq. '** VOLUME DA')then
        emisdat=.true.
        stype = 'V'
        lvolume=.true.
!       read(maininp,*) temp,emisrate,height,syinit,szinit
        read(maininp,'(a)')line
        allocate(badform(4))
        call checkline(line,4,temp,lbademis)
        if (.not. lbademis) then
          backspace(maininp)
          read(maininp,*) temp,emisrate,height,syinit,szinit
          if (emisrate .le. 0) fixemis=.true.
          if (height .lt. 0) fixrht=.true.
          if (syinit .lt. 0) fixsigy=.true.
          if (szinit .lt. 0) fixsigz=.true.
          if (fixemis .or. fixrht .or. fixsigy .or. fixsigz)
     +    fixsrc=.true.
        else
          fixsrc=.true.
          if (badform(1)) fixemis=.true.
          if (badform(2)) fixrht=.true.
          if (badform(3)) fixsigy=.true.
          if (badform(4)) fixsigz=.true.
        endif
        deallocate(badform)
        goto 10
      endif
       
c --- Read Area source data ---
      if(temp .eq. '** AREA DATA')then
        emisdat=.true.
        stype = 'A'
        larea=.true.
c        read(maininp,*) temp,emisrate,height,xinit,yinit,idummy,szinit
        read(maininp,'(a)')line
        allocate(badform(6))
        call checkline(line,6,temp,lbademis)
        if (.not. lbademis) then
          backspace(maininp)
          read(maininp,*) temp,emisrate,height,xinit,yinit,idummy,szinit
          if (xinit .lt. yinit) then
            xsav = xinit
            xinit = yinit
            yinit = xsav
          endif
          call areaXY()
          if (emisrate .le. 0) fixemis=.true.
          if (height .lt. 0) fixrht=.true.
          if (xinit .lt. 0) fixxdim=.true.
          if (yinit .lt. 0) fixydim=.true.
          if (szinit .lt. 0) fixsigz=.true.
          if (fixemis .or. fixrht .or. fixxdim .or. fixydim .or. 
     +    fixsigz) fixsrc=.true.
        else
          fixsrc=.true.
          if (badform(1)) fixemis=.true.
          if (badform(2)) fixrht=.true.
          if (badform(3)) fixxdim=.true.
          if (badform(4)) fixydim=.true.
          if (badform(5)) fixdum=.true.
          if (badform(6)) fixsigz=.true.
        endif
        deallocate(badform)
        goto 10
      endif
       
c --- Read Circular Area source data ---
      if(temp .eq. '** AREACIRC ')then
        emisdat=.true.
        stype = 'C'
        lcirc=.true.       
!        read(maininp,*) temp,emisrate,height,circrad,idummy,szinit
        read(maininp,'(a)')line
        allocate(badform(5))
        call checkline(line,5,temp,lbademis)
        if (.not. lbademis) then
          backspace(maininp)
          read(maininp,*) temp,emisrate,height,circrad,idummy,szinit
          if (emisrate .le. 0) fixemis=.true.
          if (height .lt. 0) fixrht=.true.
          if (circrad .lt. 0) fixrad=.true.
          if (szinit .lt. 0) fixsigz=.true.
          if (fixemis .or. fixrht .or. fixrad .or. fixsigz)fixsrc=.true.
        else
          fixsrc=.true.
          if (badform(1)) fixemis=.true.
          if (badform(2)) fixrht=.true.
          if (badform(3)) fixrad=.true.
          if (badform(4)) fixdum=.true.
          if (badform(5)) fixsigz=.true.
        endif
        deallocate(badform)
        goto 10
      endif
      
c --- Read Building data ---
c --- 8/12/08 moved BPIP flag from units line to building line JAT
c     reset bpip to N if not a point, capped stack, horizontal stack, or flare source.
c     if emissions data not found yet, set badorder to true
      if(temp .eq. '** BUILDING ')then
        if (.not. emisdat) badorder=.true.
        builddat=.true.
        read(maininp,'(a)')line
        allocate(badform(7))
        call checkline(line,7,temp,lbadbuild)
        if (.not. lbadbuild) then
          backspace(maininp)
          read(maininp,*) temp,bpip,bheight,blength,bwidth,bangle,
     +    sangle,sdistance
          call upcase(bpip)
          if (bpip .eq. 'Y') then
            if (lpoint .or. lflare .or. lcap .or. lhor) then 
              lbpip=.true.
              bpipfile='bpipprm.inp'  !may be overwritten if using BPIP file on TITLETWO line
            else  !reset for area (rectangular or circular) or volume sources
              lbpip=.false.
              bpip='N'
            endif
          else if (bpip .eq. 'N') then
            lbpip=.false.
          else
            fixbpip=.true.
            lbpip=.false.
            fixbuild=.true.
          endif
          if (lbpip) then
            if ((bwidth .gt. blength) .or. (bwidth .le. 0) 
     +        .or. (blength .le. 0)) fixdim=.true.
            if (bheight .le. 0) fixht=.true.
            if (bangle .lt. 0 .or. bangle .gt. 179) fixorient=.true.
            if (sangle .lt. 0 .or. sangle .gt. 360) fixdir=.true.
            if (sdistance .lt. 0) fixsdist=.true.
            if (fixdim .or. fixht .or. fixorient .or. fixdir .or. 
     +      fixsdist) fixbuild=.true.
          endif
        else
          fixbuild=.true.
          read(line,*)temp,bpip
          call upcase(bpip)
          if (bpip .ne. 'Y' .and. bpip .ne. 'N') fixbpip=.true.
          if (badform(2)) fixht=.true.
          if (badform(3) .or. badform(4)) fixdim=.true.
          if (badform(5)) fixorient=.true.
          if (badform(6)) fixdir=.true.
          if (badform(7)) fixsdist=.true.
        endif
        deallocate(badform)
        goto 10
      endif

c --- Read MAKEMET data ---
c variable aersurf denoting AERSURFACE output file or AERMET stage 3 input file
c version 08128, removed iaer, use isurf=9 to denote AERSURFACE output
      if(temp .eq. '** MAKEMET D')then
        metdat=.true.
        read(maininp,'(a)')line
        allocate(badform(10))
        call checkline(line,9,temp,lbadmet)  !actually 10 fields, but only read 1st 9 b/c last field is a file
        if (.not. lbadmet) then
          backspace(maininp)
          read(maininp,*)temp,ambtmin,ambtmax,wsmin,anemht,isurf,iclim,
     +          useralbe,userbown,userlen,aersurf
c ---   Apply minimum roughness length of 0.001m
c         userlen = MAX( userlen, 0.001 )
c         warn user if temperatures exceed world records
          if (ambtmin .lt. 183.0 .or. ambtmin .gt. 331) warnmint=.true.
          if (ambtmax .lt. 183.0 .or. ambtmax .gt. 331) warnmaxt=.true.
          if (isurf .eq. 0) then
            sctype='user defined'
            if (useralbe .lt. 0 .or. useralbe .gt. 1) fixalb=.true.
            if (userbown .lt. -10 .or. userbown .gt. 10) warnbow=.true.
            if (userlen .lt. 0) then
              fixzo=.true.
            else
              if (userlen .lt. 0.001) then
                warnzo=.true.
                userlen = MAX( userlen, 0.001 ) !Apply minimum roughness length of 0.001m  
              else
                if (userlen .ge. 2.0) warnzo1=.true.
              endif
            endif
            if (fixalb .or. fixbow .or. fixzo) fixsc=.true.
          elseif (isurf .ge. 1 .and. isurf .le. 8) then
            sctype='AERMET'
          else
            sctype='AERSURFACE'
          endif
          if (isurf .eq. 9) then
            call readaer(1)
            if (fixaer) fixsc=.true.
c         inquire(file=aersurf,exist=lexist)
c         if (.not. lexist) then
c            fixaer=.true.
c            fixsc=.true.
c         endif
          endif
c     check variables
          if (wsmin .le. 0) fixspd=.true.
          if (anemht .lt. 0) fixaht=.true.
          if (ambtmin .ge. ambtmax) fixtemp=.true.
          if (isurf .lt. 0 .or. isurf .gt. 9) then
            fixsurf=.true.
            fixsc=.true.
          endif
          if ((iclim .lt. 1 .or. iclim .gt. 3) .and. 
     +    (isurf .ge. 1 .and. isurf .le. 8)) then
            fixsc=.true.  
            fixclim=.true.
          endif
          if (fixspd .or. fixaht .or. fixtemp .or. fixsc)fixmet=.true.
        else
          fixmet=.true.
          if (badform(1) .or. badform(2)) fixtemp=.true.
          if (badform(3)) fixspd=.true.
          if (badform(4)) fixaht=.true.
          if (badform(5)) then
            fixsc=.true.
            fixsurf=.true.
          endif
          if (badform(6)) then
            fixsc=.true.
            fixclim=.true.
          endif
          if (badform(7)) fixalb=.true.
          if (badform(8)) fixbow=.true.
          if (badform(9)) fixzo=.true.
          if (fixalb .or. fixbow .or. fixzo) fixsc=.true.
        endif
        deallocate(badform)
        goto 10
      endif

c --- read u* adjustment flag, version 16216
      if (index(temp,'** ADJUST U*') .gt. 0) then
          ustardat=.true.
          n=index(temp,'** ADJUST U*')
          read(line(n+14:250),*)ustarflg
          if (len_trim(ustarflg) .ne. 1) then
              lbadustar=.true.
          else
              call upcase(ustarflg)
              if (ustarflg .eq. 'Y') then
                  adjustar=.true.
              else if (ustarflg .eq. 'N') then
                  adjustar=.false.
              else
                  lbadustar=.true.
              endif
          endif
          if (lbadustar)fixmet=.true.
      endif

c --- Read Terrain data ---
c --- moved terrain flag to terrain line from units line and flagpole flag to units line 
c --- from terrain line JAT
c     if rectangular area source and terrain set to Y, reset to N
c     if area source or no terrain processing, reset probe distance to 5 km if necessary
c     reset use of AERMAP for elevation to N if no terrain or rectangular area source
c     version 09217 - removed probe distance restrictions based on terrain or flat terrain
c     probe distance can be specified for either flat terrain or elevated terrain.
      if(temp .eq. '** TERRAIN D')then
        if (.not. emisdat) badorder=.true.
        terrdat=.true.
        read(maininp,'(a)')line
        allocate(badform(8))
        call checkline(line,8,temp,lbadter)
        if (.not. lbadter) then
          backspace(maininp)
          read(maininp,*) temp,terrain,utmx,utmy,izone,nada,probedist,
     +    profbase,aermap
          base=profbase
          if (probedist .le. 0) fixprobe=.true.
c           check probe distance and if not a multiple of 25 m, reset, warn user in
c           validation page
          call checkprobe
c           read(dem,'(a1)') terrain
          call upcase(terrain)
          if (terrain .eq. 'Y') then
            if (nada .ne. 1 .and. nada .ne. 4) fixnad=.true.
            if (izone .le. 0) fixzone=.true.
            lterrain=.true.
          else if (terrain .eq. 'N') then
            lterrain=.false.
          else
            fixter=.true.
            lterrain=.false.
          endif
          call upcase(aermap)
          if (aermap .eq. 'Y') then 
            laermsrc=.true.
          else if (aermap .eq. 'N') then
            laermsrc=.false.
          else 
            fixaermp=.true.
            laermsrc=.false.
          endif 
          if (larea .and. lterrain) then
            lterrain = .false.
            terrain = 'N'
          endif
          if (.not. lterrain) then 
            laermsrc=.false.
            aermap='N'
          endif
c calculate source coordinates
          llat=.false.
          if (lterrain) call calccoords(-999.0,-999.0,1)
          if (fixter .or. fixzone .or. fixnad .or. fixprobe .or. 
     +    fixaermp .or. fixdem .or. fixnaddir) fixterr=.true.
        else
          fixterr=.true.
          if (badform(1))fixter=.true.
          if (badform(2) .or. badform(3))fixcoords=.true.
          if (badform(4))fixzone=.true.
          if (badform(5))fixnad=.true.
          if (badform(6))fixprobe=.true.
          if (badform(7))fixprof=.true.
          if (badform(8))fixaermp=.true.
        endif
        deallocate(badform)
        goto 10
      endif

c --- version 11038 added discrete receptor distances
c     do not use standard processing because
c     do not have to have both receptors listed for
c     line to be valid
      if (temp .eq. '** DISCRETE ') then
        discdat=.true.
        read(maininp,*)temp,discflag,discfile
        call upcase(discflag)
        if (discflag .eq. 'Y') then
          call getdiscrete(1)
          ldiscrete=.true.
        else if (discflag .eq. 'N') then
          ldiscrete=.false.
          ndisc=0
        else
          fixdisc=.true.
          fixdisfl=.true.
        endif
        goto 10
      endif
c --- Read Prompts data ---
c     if units are set to E change to M and notify user
c     units from input file are metric always.
      if(temp .eq. '** UNITS/POP')then
        if (.not. emisdat) badorder=.true.
        miscdat=.true.
!        read(maininp,*) temp,units,urban,populat,xnear,
!     +    flgswitch,flagpole
        read(maininp,'(a)')line
        allocate(badform(6))
        call checkline(line,6,temp,lbadunits)
        if (.not. lbadunits) then
          backspace(maininp)
          read(maininp,*) temp,units,urban,populat,xnear,
     +    flgswitch,flagpole
          call upcase(units)
          call upcase(urban)
          call upcase(flgswitch)
          if (units .eq. 'M') then 
            lmetric=.true.
          else
            fixunits=.true.
          endif 
          if (urban .eq. 'U') then 
            lurban=.true.
            if (populat .le. 100.0) fixurban=.true.
          else if (urban .eq. 'R') then 
            lurban=.false.
          else
            fixuflag=.true.
          endif
          if (flgswitch .eq. 'Y') then
            lflagpole=.true.
            if (flagpole .lt. 0) fixflag=.true.
          else if (flgswitch .eq. 'N') then
            lflagpole=.false.
          else
            fixflag1=.true.
            lflagpole=.false.
          endif 
          if (lvolume) then
            if (xnear .lt. 2.15*syinit+1.0) then
c           write(*,2005)xnear,2.15*syinit+1.0
c           write(ilog,2005)xnear,2.15*syinit+1.0
              xnear=2.15*syinit+1.0
              fixamb=.true.
            endif
            else
              if (xnear .le. 0) then 
                xnear=1.0
                fixamb=.true.
              endif
          endif
          if (probedist .lt. xnear .and. terrdat) fixdists=.true.
          if (fixunits .or. fixuflag .or. fixurban .or. fixflag 
     +    .or. fixflag1 .or. fixdists) fixmisc=.true.
        else
          fixmisc=.true.
          if (badform(1)) fixunits=.true.
          if (badform(2)) fixuflag=.true.
          if (badform(3)) fixurban=.true.
          if (badform(4)) fixamb=.true.
          if (badform(5)) fixflag1=.true.
          if (badform(6)) fixflag=.true.
        endif
        deallocate(badform)
        goto 10
      endif
 
          
c -- fumigation
      if (index(temp,'** FUMIGATIO') .gt. 0) then
          fumdat=.true.
          lfum=.false.
          read(maininp,'(a)')line
!          allocate(badform(3))
!          call checkline(line,3,temp,lbadfum)
          allocate(badform(5))
          call checkline(line,5,temp,lbadfum)
          if (.not. lbadfum) then
              backspace(maininp)
!              read(maininp,*)temp,fumflag,shorflag,shordist
              read(maininp,*)temp,fumflag,shorflag,shordist,shoredir,
     +        scrnflag
              call upcase(fumflag)
              call upcase(shorflag)
              call upcase(scrnflag)
              if (fumflag .eq. 'Y') then
                  if (larea .or. lcirc .or. lvolume .or. height 
     +            .lt. 10.0) then
                      lfumigate=.false.
                      fumflag='N'
                  else
                      lfumigate=.true.
                  endif
              elseif (fumflag .eq. 'N') then
                  lfumigate=.false.
              else
                  fixfum1=.true.
              endif
              if (shorflag .eq. 'Y') then
                  if (larea .or. lcirc .or. lvolume .or. height 
     +            .lt. 10.0) then
                      lshore=.false.
                      shorflag='N'
                  else
                      lshore=.true.
                  endif
              elseif (shorflag .eq. 'N') then
                  lshore=.false.
              else
                  fixshore1=.true.
              endif
              if (scrnflag .eq. 'Y' .or. scrnflag .eq. ' ') then  !allow blank to be same as yes for older files
                  runscreen=.true.
              elseif (scrnflag .eq. 'N' ) then
                  if (larea .or. lcirc .or. lvolume 
     +            .or. height .lt. 10) then  !no fumigation, reset screen flag
                      runscreen=.true.
                      scrnflag='Y'
                  else
                      runscreen=.false.
                  endif
              else
                  fixscreen=.true.
              endif
              if (lshore .and. shordist .gt. 3000.0 .or. 
     +        shordist .lt. 0.0) then
                  fixfum=.true.
                  fixshore2=.true.
              endif
              if (lshore .and. (shoredir .gt. 360.0 .or. (shoredir .lt. 
     +        0.0 .and. shoredir .ne. -9.0))) fixshore3=.true.
              if (lfumigate .or. lshore)lfum=.true.
              if (.not. runscreen .and. .not. lfum) fixscreen=.true.  !not running AERSCREEN and no fumigation, error
          else
              if (badform(1)) fixfum1=.true.
              if (badform(2)) fixshore1=.true.
              if (badform(3)) fixshore2=.true.
              if (badform(4)) fixshore3=.true.
              if (badform(5)) fixscreen=.true.
          endif
!          if (fixfum1 .or. fixfum2 .or. fixshore1 .or. fixshore2 .or. 
!     +    fixshore3) then
          if (fixfum1 .or. fixshore1 .or. fixshore2 .or. fixshore3 .or. 
     +    fixscreen) then
              fixfum=.true.
          endif
          
          deallocate(badform)
          goto 10
      endif
      
c --- debug option
      if (index(temp,'** DEBUG OPT') .gt. 0) then 
          ldebug1=.true.
          read(maininp,'(a)')line
          allocate(badform(1))
          call checkline(line,1,temp,lbadbug)
          if (.not. lbadbug) then
              backspace(maininp)
              read(maininp,*)temp,debugflg
              call upcase(debugflg)
              if (debugflg .eq. 'Y') then
                  ldebug=.true.
              elseif (debugflg .eq. 'N') then
                  ldebug=.false.
              else
                  fixdebug=.true.
              endif
          else
              fixdebug=.true.
          endif
          deallocate(badform)
          goto 10
      endif
      
c -- check for output filename
c -- check for existence of the file
      
      if (index(temp,'** OUTPUT FI') .gt. 0) then
        outdat=.true.
        n=index(line,'** OUTPUT FILE')
        read(line(n+14:250),*)outfil2
        outfil=trim(adjustl(outfil2))
        outfil1=outfil
        do i=1,250
          call upcase(outfil1(i:i))
        enddo
        if (outfil1 .eq. 'AERSCREEN.OUT') then
          ldefault=.true.
          logfil='AERSCREEN.LOG'
          inpfile='AERSCREEN.INP'
          maxfil='max_conc_distance.txt'
          if (ldebug) then
              debugfil='concentrations.txt'
              fumfil='fumigate_debug.txt'
          endif
        else
          ldefault=.false.
        endif
        if (.not. ldefault) then
            n1=index(outfil1,'.OUT')
            if (n1 .eq. 0) then
              fixout=.true. 
              fixout1=.true.
            else
c           make sure file doesn't have an extension like .out1, etc.
              n2=n1+4
              if (n2 .le. 250) then
                  if (outfil1(n2:n2) .ne. ' ') then
                      fixout=.true.
                      fixout1=.true.
                  endif
              endif
          endif
          if (.not. fixout) then
              maxfil=outfil(1:n1-1)//'_max_conc_distance.txt'
              if (ldebug) then 
                  debugfil=outfil(1:n1-1)//'_concentrations.txt'
                  if (lfumigate .or. lshore) fumfil=outfil(1:n1-1)//
     +            '_fumigate_debug.txt'
              endif
              logfil=outfil(1:n1-1)//'.log'
              inpfile=outfil(1:n1-1)//'.inp'
          endif
        endif
        if (.not. fixout) then
          call checkfile(goodfile)
          if (.not. goodfile) then 
            fixout=.true. 
            fixfold=.true.
          endif          
        endif
        goto 10
      endif
c11   format('Input units are metric..'/'Switching flag to metric')
c --- Read Title line ---
      if(temp .eq. '   TITLEONE ')then
       read(line,1000) title
       goto 10
      endif

c --- read modeloptions to see if NO2 chemistry being used
      if (temp .eq. '   MODELOPT ') then
        pvmrmind=index(line,' PVMRM ')
        olmind=index(line,' OLM ')
        if (pvmrmind .gt. 0 .and. olmind .gt. 0) then
          fixno2=.true.
          fixpvmrm=.true.
          fixolm=.true.
          lno2=.true.
        else
          if (pvmrmind .gt. 0) then
            lolm=.false.
            lpvmrm=.true.
            lno2=.true.
            noxchem='PVMRM'
          endif
          if (olmind .gt. 0) then
            lolm=.true.
            lpvmrm=.false.
            lno2=.true.
            noxchem='OLM'
          endif
        endif
      endif

c2005  format('Source is volume source...'/
c     + 'Changing ambient distance ',f7.2,' to ',f7.2/
c     + 'which is 2.15*sigma y + 1 meter')
     
c --- Read BPIP input file in Title 2 line ---
      if(temp .eq. '   TITLETWO ')then
c       read(line,1000) bpipfile
       read(line(13:120),*)bpipfile
c       if (lbpip) then 
         lusebpip=.true.
         if (fixdim .or. fixht .or. fixorient .or. fixdir .or. 
     +      fixsdist) then
            fixbuild=.false.
            fixdim=.false.
            fixht=.false.
            fixorient=.false.
            fixdir=.false.
            fixsdist=.false.
         endif   
         inquire(file=bpipfile,exist=bexist)
         if (.not. bexist) then 
           fixbpipfil=.true.
           fixbuild=.true.
         endif
         if (.not. fixbpipfil) then
          call checkbpip(fixbpipfil2)
          if (fixbpipfil2)fixbuild=.true.
         endif
c       else
c         lusebpip=.false.
c       endif
c       if(bpip .ne. 'Y' .and. bpip .ne. 'y')then
c       if (.not. lbpip) then
c        bpipfile = ' '
c       else
       if (lusebpip) then
        
        
!       write(bline,100)trim(adjustl(bpipfile))
        inquire(file='bpipprm.inp',exist=bexist)
c     version 15181
        if (bexist) then
            open(bpipin,file='bpipprm.inp',status='unknown')
            close(bpipin,status='delete')
!            call system("del bpipprm.inp > NUL")
        endif
!        call system(bline)

       endif
       goto 10
      endif


c --- Read Base Elevation line ---
c      if(temp .eq. '   LOCATION ' .and.
c     +  lterrain) then
c     +  (terrain .eq. 'Y' .or. terrain .eq. 'y') )then
c       read(line,1001) base
c1001  format(39x,f10.2)
c 1001  format(43x,f10.2)
       
c       goto 10
c       endif

c check pollutant id for NO2
      if (temp .eq. '   POLLUTID ') then
        no2poll=index(line,' NO2 ')
        if (no2poll .gt. 0) lno2poll=.true.
      endif
c check for NO2STACK keyword
      if (temp .eq. '   NO2STACK ') then
        lno2stack=.true.
        stkind=index(line,'NO2STACK')
        read(line(stkind+8:120),'(a)')ano2stack
        call checkanswer(ano2stack,lblank,lbad,2)
        if (lblank .or. lbad) then
          fixno2=.true.
          fixno2stk=.true.
        else
          read(line(stkind+8:250),*)no2stack
          if (no2stack .lt. 0 .or. no2stack .gt. 1.0) then
            fixno2stk=.true.
            fixno2=.true.
          endif
        endif
      endif
      if (temp .eq. '   OZONEVAL ') then
        lo3val=.true.
        o3ind=index(line,'OZONEVAL')
        do i=1,250
          call upcase(line(i:i))
        enddo
!        read(line(o3ind+8:250),'(a,a)')ao3,o3units
        read(line(o3ind+8:250),*)ao3
        call checkanswer(ao3,lblank,lbad,2)
        if (lblank .or. lbad) then
          fixno2=.true.
          fixo3=.true.
        else
          read(ao3,*)o3
          o3len=len(trim(adjustl(ao3)))
          o3indx=index(line,trim(adjustl(ao3)))
          if (o3 .lt. 0) then
            fixo3=.true.
            fixno2=.true.
          endif
        endif
        if (o3len .gt. 0 .and. o3indx .gt. 0) then
          read(line(o3indx+o3len:250),'(a)')o3units1
          o3units=trim(adjustl(o3units1))
          do i=1,5
            call upcase(o3units(i:i))
          enddo
c          write(*,*)o3units,o3indx,o3len
          if (o3units .ne. 'UG/M3' .and. o3units .ne. 'PPM' .and.
     +      o3units .ne. 'PPB') then
            fixo3uni=.true.
            fixno2=.true.
          endif
        endif
      endif

c      write(*,*)fixno2,lno2,fixo3uni,fixo3,fixno2stk,lno2poll
      
      
c --- Exit at End of Source Section ---
c     and prompt user to continue with inputs or start new run
 45   if(temp .eq. 'CO FINISHED ')then
c check NO2 variables
       if (.not. lno2) then
        if (lno2stack .or. lo3val) fixno2=.true.
      else
        if (.not. lno2poll .or. .not. lno2stack .or. .not. lo3val) 
     +  fixno2=.true.
        
      endif
c     check for any data that needs checking or replacing
      
        write(*,2000)title
       read(*,'(a)')response
       answer=trim(adjustl(response))
c       read(*,'(a1)')answer
       call upcase(answer)
c       if(answer .ne. 'Y')then
       if (answer .eq. ' ') then
        bpipfile = ' '
        lusebpip=.false.
        call header()
        goto 99
       else if (answer .ne. 'Y') then
         write(*,*)' Invalid response'
         goto 45
       else
         if (.not. emisdat .or. badorder)fixsrc=.true.
         if (.not. builddat)fixbuild=.true.
         if (.not. metdat) fixmet=.true.
         if (.not. terrdat) fixterr=.true.
         if (.not. miscdat) fixmisc=.true.
!         if (.not. discdat) fixdisc=.true.
!         if (.not. outdat) fixout=.true.
         if (.not. discdat) then
          ldiscrete=.false.
c JAT correct variable assignment from discdat to discflag
!          discdat='N'
          discflag='N'
          discfile='NA'
         endif
         if (.not. fumdat) then
             lfumigate=.false.
             lshore=.false.
             fumflag='N'
             shorflag='N'
             shordist=0.0
             shoredir=0.0
             scrnflag='Y'
             runscreen=.true.
         endif
         if (.not. ldebug1) then
             ldebug=.false.
             debugflg='N'
          endif
         if (.not. outdat) then
          ldefault=.true.
          outfil='AERSCREEN.OUT'
         endif
         if (.not. ustardat) then
             adjustar=.false.
             ustarflg='N'
         endif
         
         call checkdat
         if (lstop) then
c           lstop=.true.
          goto 98
         endif
       endif
c       write(ilog,1000)title
c       write(ilog,*)' '

2000  format(//' RESTART file title: ',a40,///
     +  ' Continue with RESTART File? <press Y>: '//
     + '                 OR '//'    Start a NEW Run? <press Enter>: '///
     +  '           Enter choice: '\)
     
       if(bpipfile .eq. ' ')goto 98

c       inquire(file='bpipprm.inp',exist=bexist)
c       if (.not. bexist) goto 150
c       open(25,file='bpipprm.inp',status='old',err=150)
c       close(25)

c       bheight = 0.0
c       blength = 0.0
c       bwidth = 0.0
c       bangle = 0.0
c       sangle = 0.0
c       sdistance = 0.0

       goto 98

c  150  write(*,'(///'' User defined BPIP input file not found: '',a)')
c     +        bpipfile
c 150   write(*,2001)bpipfile
c       stop 'Program halted!!!'
c      else
      endif

      goto 10
2001  format(///' User defined BPIPPRM input file not found: ',a)
 1000  format(12x,a60)
!100   format('copy "',a,'" bpipprm.inp /y > NUL')
20    format(/'Changing UTM zone from ',i2,' to ',i2)
30    format(/'NAD 27 latitude and longitude',2(1x,f12.7),
     + /'NAD 83 latitude and longitude',2(1x,f12.7))
   98 ipass = 1

   99 close(maininp)
 500  return
      end
c -----------------------------------------------------------------------------
      subroutine checkfile(lgood)
c     check output filename
      use main1
      implicit none
c lgood:    logical variable denoting if filename is valid
c lexist:   logical variable to check to see if file already exists
c           if so, then lgood is true
      logical lgood,lexist
      lgood=.false.
        
      inquire(file=outfil,exist=lexist)
c     if file exists, then it is good
      if (lexist) then
        lgood=.true.
      else   !file doesn't exist, check to see if pathname is valid
        open(ascrnout,file=outfil,status='unknown',err=98)
        lgood=.true.
   98   close(ascrnout,status='delete')  
      endif
      return
      end
c -----------------------------------------------------------------------------
      subroutine checkanswer(a,lblank,lflag,icode)
c     check answers to prompts to determine if response has invalid
c     character, i.e. response is <return> or numeric
c     routine also processes variables that should be character length 1
      use main1
      implicit none

c a:        response entered by user
c b:        left-justified version of a
c lflag:    logical variable denoting if response is bad (true) or acceptable (false)
c lblank:   logical variable denoting if response is all blanks (true) or not (false)
c ldecimal: 
c i:        integer code of character in ASCII table  
c i1:       loop counter for character string a
c idash:    number of dashes read from response
c idecimal: number decimals read from response
c iblank:   number of blanks read from response
c icode:    code indicating what type of final response is
c           icode=1 then final answer is a character, such as a Y or N, or blank
c           icode=2 then final answer is a number
c ie:       number of upper or lowercase E's in string.  E represents exponential format
c iplus:    number of plus signs read from response
c ichar1:   2 element array of number of characters before and after blank
c charstr:  15 element array of integer ASCII codes of response

c lenb:       length of string b without blanks
      character a*15,b*15
      logical lflag,lblank
      integer i,i1,idash,idecimal,iblank,icode,ie,iplus,
     + ichar1(2),charstr(15),lenb
     
  
c initialize variables
      idash=0
      ie=0
      iplus=0
      ichar1=0
      idecimal=0
      iblank=0
      charstr=32
      lflag=.false.
      lblank=.false.
      lenb=0

      b=trim(adjustl(a))
      lenb=len_trim(b)
      if (lenb .eq. 0) then
        lblank=.true.
        goto 100
      else 
        do i1=1,lenb
          call upcase(b(i1:i1))  !convert to upper case
        enddo
      endif
      

      if (icode .eq. 1) then  !final response is a character string, usually blank, y, or n 
        if (lenb .gt. 1) then
          lflag=.true.
          goto 100
        endif
      else  !numeric
        do i1=1,lenb
          i=ichar(b(i1:i1))
          charstr(i1)=i
          if ((i .ge. 48 .and. i .le. 57) .or. i .eq. 45 .or. i .eq. 46 
     +    .or. i .eq. 69 .or. i .eq. 43) then
            if (i .eq. 45) idash=idash+1
            if (i .eq. 46) then 
              idecimal=idecimal+1
              if (ie .gt. 0)lflag=.true.
            endif
            if (i .eq. 69) ie=ie+1
            if (i .eq. 43) iplus=iplus+1
c          lflag=.false.
          else
            lflag=.true.
          endif
          if (idash .gt. 2 .or. idecimal .gt. 1 .or. ie .gt. 1 .or. 
     +    iplus .gt. 2)! .or. (ichar1(1) .ne. 0 .and. ichar1(2) .ne. 0)) 
     +    lflag=.true.
        enddo
      
        if (lflag) goto 100
c     need to look for specific placements of characterics if there were no bad characters
c         if first character is an e or last character is not a blank, number, or e
c         then string is bad
        if ((charstr(1) .eq. 69) .or. 
     +  ((charstr(lenb) .lt. 48 .and. charstr(lenb) .ne. 46)
     +   .or. (charstr(lenb) .gt. 57 .and. charstr(lenb) .ne. 69))) then
          lflag=.true.
          goto 100
        endif
c       check for a blank character between the first and last occurrence of non-blank character
        i=1 
        do while (i .le. lenb .and. .not. lflag)
          if (charstr(i) .eq. 32) lflag=.true.
          i=i+1
        enddo
        if (lflag) goto 100        
c       begin looking at the string beginning with position 2 through position 14
        i=2
        do while (i .le. lenb-1 .and. .not. lflag)
c           if character is an E, make sure that character before that is
c           a number or . sign and character afterwards is a number
c           or + or - sign or blank
          if (charstr(i) .eq. 69) then  !character is an e
            if (((charstr(i-1) .lt. 48 .and. charstr(i-1) .ne. 46) 
     +      .or. charstr(i-1) .gt. 57) .or. (charstr(i+1) .lt. 48 
     +      .and. charstr(i+1) .ne. 43 .and. charstr(i+1) .ne. 45)
     +      .or. charstr(i+1) .gt. 57) 
     +      lflag=.true. 
          endif     
c         if character is a - sign, preceding character should be a
c         number or blank or lower/uppercase e and proceeding character
c         should be a number
          if (charstr(i) .eq. 45 .and. (charstr(i-1) .ne. 69 .or. 
     +    (charstr(i+1) .lt. 48 .or. charstr(i+1) .gt. 57)))lflag=.true.      
c         if character is a + sign, preceding character should be a
c         number or blank or lower/uppercase e and proceeding character
c         should be a number
          if (charstr(i) .eq. 43 .and. (charstr(i-1) .ne. 69 .or. 
     +    (charstr(i+1) .lt. 48 .or. charstr(i+1) .gt. 57)))lflag=.true. 
          i=i+1
        enddo
      endif

100   return
c     return
      end
c -----------------------------------------------------------------------------
      subroutine probeamb
c probe distance is less than ambient distance
c have user re-enter both values
      use main1
      implicit none

c units1:       English or metric units text
c units2:       English or metric units abbreviated
c response:     response from user, number or <Enter>
c answer:       first character of response
c dfault:       default probe distance for flat (5 km) or terrain (10 km)
c conv:         Conversion factor for feet to meters
c lbad:         logical variable denoting if response is invalid (true) or okay (false)
c               invalid means character where there should be a space or number
c lblank:       logical variable that response is all blanks
      character units1*15,units2*15,response*15,answer*1
      integer dfault
      real conv
      logical lbad,lblank

      call system("cls")
c     call system("clear")   !unix/linux
      istage=1
      write(*,*)' Probe distance is less than ambient distance'
c --- Prompt for Distance to Ambient Air  ---
 40   if (lmetric) then
        units1='(meters)'
        units2='(1 m)'
        if (lvolume) then
         if (2.15*syinit+1.0 .gt. 1.0) then
          write(units2,'(f8.3)')2.15*syinit+1.0
         else
          units2='(1 m)'
         endif
        else
          units2='(1 m)'
        endif
      else
        units1='(feet)'
        if (lvolume) then   !minimum distance cannot be inside volume
         if ((2.15*syinit/0.3048)+(1.0/0.3048) .gt. (1.0/0.3048)) then
          write(units2,'(f8.3)')2.15*syinit/0.3048+3.3
          units2='('//trim(adjustl(units2))//' ft)'
         else
          units2='(3.3 ft)'
         endif
        else
          units2='(3.3 ft)'
        endif
      endif
      write(*,1017)trim(adjustl(units1)),trim(adjustl(units2))
      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,2)
c      read(response,'(a1)')answer
c      if (ichar(answer) .eq. 32) then
      if (lblank) then
         if (lvolume) then
           xnear=max(2.15*syinit+1.0,1.0)
         else
           xnear=1.0
         endif
      else
c         call checkanswer(answer,lbad)
         if (lbad) then
           write(*,*)' Invalid response'
           goto 40
         endif
         read(response,'(f8.0)')xnear
         if (lmetric) then 
           units1='meters'
           conv=1.00
         else
           units1='feet'
           conv=0.3048
         endif
         if (lvolume .and. xnear/conv .lt. (2.15*syinit/conv)+1.0) then   !reset to outside volume
           write(*,1023)xnear,trim(adjustl(units1)),
     +        2.15*syinit/conv+(1.0/conv),trim(adjustl(units1))
           goto 40
         else
           if (.not. lmetric) xnear = xnear * 0.3048
           if (xnear .le. 0) then   !if negative set to 1 m
             write(*,*)' Changing ambient distance to 1 m'
             xnear=1.0
           endif
         endif
      endif
c --- Prompt for probe distance (optional) ---
c --- if flat terrain, default is 5 km
c --- if terrain used, default is 10 km
c --- now probe distances are in meters JAT 11/29/2010
55    if (lterrain) then
!       dfault=10
       dfault=10000
      else
!        dfault=5
        dfault=5000
      endif
      write(*,1001)dfault
      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,2)
c      read(response,'(a1)')answer
c      if(ichar(answer) .eq. 32)then
      if (lblank) then
!         probedist = real(dfault)*1000.0
         probedist = real(dfault)
         changeprobe=.false.
      else
c         call checkanswer(answer,lbad)
         if (lbad) goto 55
         read(response,'(f8.0)')probedist
         if (probedist .le. 0) then
           write(*,*)' Invalid probe distance'
           goto 55
         endif
         call checkprobe
         if (changeprobe) write(*,1012)probedist1,probedist
c         probedist=probedist*1000.0
      endif
      
      if (probedist .lt. xnear) goto 40
      
!1001  format(///' Enter Maximum Distance (km) to probe '/
!     +  ' <Enter> for default (',i2,' km): '\)           
1001  format(///' Enter Maximum Distance (m) to probe '/
     +  ' <Enter> for default (',i5,' m): '\)    
1012  format(//1x,'******* WARNING *************'/1x,
     +  'Probe distance changed from ',f9.2,' m to ',/1x,f9.2,' m')     
1017  format(///' Enter Minimum Distance ',a,' to Ambient Air'/
     +  '<Enter> for default 'a,': '\)
1023  format(/' Ambient distance ',f8.3,1x,a,
     + ' is less than 2.15*sigma-y plus 1 m ',f8.3,1x,a)
      return
      end
c -----------------------------------------------------------------------------
      subroutine checkdat
c     routine to check if any parameters from AERSCREEN.INP are invalid,
c     if so, list and stop AERSCREEN
c     flags for BPIP input file and NAD directory added
c     flags for fumigation and debug file added
      use main1
      implicit none
c sstring:    character string describing point source type  
c baddat:     character string describing which data line not found   
      character sstring*20,baddat*20

      
      if (lpoint) then
        sstring='POINT'
      else if (lvolume) then
        sstring='VOLUME'
      else if (lflare) then
        sstring='FLARE'
      else if (lcap) then
        sstring='POINTCAP'
      else if (lhor) then
        sstring='POINTHOR'
      else if (larea) then
        sstring='AREA'
      else if (lcirc) then
        sstring='AREACIRC'
      else
        sstring='UNKNOWN SOURCE TYPE'
      endif
 
c version 15181, added fumigation and debug
      if (fixsrc .or. fixbuild .or. fixterr .or. fixmet .or. fixmisc
     +  .or. fixamb .or. fixno2 .or. fixdisc .or. fixfum .or. 
     +  fixdebug) then
        write(*,996)trim(adjustl(sstring))
        write(ilog,996)trim(adjustl(sstring))

        if (fixsrc .or. fixbuild .or. fixterr .or. fixmet .or. 
     +  fixmisc .or. fixno2 .or. fixdisc .or. fixfum .or. fixdebug) then
          write(*,998)
          write(ilog,998)
          lstop=.true.
        endif 
      else
        lstop=.false.
        goto 30
      endif
      
      write(ilog,997)
c group flag based on data type, source, building, terrain, etc.
      if (fixsrc) then
        write(ilog,1028)
        if (.not. emisdat) then
          baddat='Emissions'
          write(ilog,1075)trim(adjustl(baddat))   !emissions data not found
        endif
        if (badorder) write(ilog,1076)  !emissions data not before other data
        if (fixemis) write(ilog,1014) !bad emission rate
        if (fixrht) write(ilog,1015) !bad release height
        if (fixdiam) write(ilog,1016) !bad stack diameter
        if (fixrtemp) write(ilog,1052) !bad release temperature
        if (fixvel) write(ilog,1053) !bad velocity
        if (fixflow) write(ilog,1054) !bad flow rate
        if (fixheat1) write(ilog,1055) !bad heat input
        if (fixheat2) write(ilog,1056) !bad heatloss
        if (fixsigy) write(ilog,1017) !bad sigmay
        if (fixsigz) write(ilog,1018) !bad sigmaz
        if (fixxdim)  write(ilog,1019) !bad xinit
        if (fixydim) write(ilog,1020) !bad yinit
        if (fixrad) write(ilog,1021) !bad circular radius
        if (larea .and. fixdum) write(ilog,1057) !bad orientation angle
        if (lcirc .and. fixdum) write(ilog,1058) !bad # of vertices   
      endif
      if (fixbuild) then
        write(ilog,1029)
        if (.not. builddat) then 
          baddat='Building'
          write(ilog,1075)trim(adjustl(baddat)) !no building data
        endif
        if (fixbpip) write(ilog,1023)  !bad BPIP flag
        if (fixht) write(ilog,1000) !bad building height
        if (fixdim) write(ilog,1001)  !bad dimensions
        if (fixorient) write(ilog,1002)  !bad building orientation angle
        if (fixdir) write(ilog,1003)  !bad stack to building center angle
        if (fixsdist) write(ilog,1039) !bad stack to building center distance
        if (fixbpipfil) write(ilog,1037)trim(adjustl(bpipfile))
        if (fixbpipfil2) then   !BPIP file is incorrectly formatted
          if (badbflag) write(ilog,1050)trim(adjustl(bpipfile)),
     +    trim(adjustl(bpipfile))   !PRIME flag not set
          if (badstack) write(ilog,1051)trim(adjustl(bpipfile))  !bad stack information
        endif
      endif
      if (fixmet) then
        write(ilog,1030)
        if (.not. metdat) then
          baddat='Meteorological'
          write(ilog,1075)trim(adjustl(baddat))   !meteorological data not found
        endif
        if (fixsurf) write(ilog,1005)  !bad surface code
        if (isurf .eq. 0) then
          if (fixalb) write(ilog,1044) !bad albedo
          if (fixbow) write(ilog,1045) !bad Bowen ratio
          if (fixzo) write(ilog,1046)  !bad surface roughness
        endif
        if (fixclim .and. ((isurf .ge. 1 .and. 
     +  isurf .le. 8) .or. lbadmet)) write(ilog,1006)  !bad moisture code
        if (fixaer) then
          if (nosurf) then 
            write(ilog,1007)trim(adjustl(aersurf))
           else if (badsurf) then
             write(ilog,1047)trim(adjustl(aersurf))
           else
             write(ilog,1041)trim(adjustl(aersurf))
             if (fixntemp) write(ilog,1042)
             if (fixsec) write(ilog,1043)
             if (fixalb) write(ilog,1044)
             if (fixbow) write(ilog,1045)
             if (fixzo) write(ilog,1046)  
           endif
        endif
        if (fixspd) write(ilog,1008) !bad wind speed
        if (fixaht) write(ilog,1009) !bad anemometer height
        if (lbadustar) write(ilog,1085) !bad ustar flag version 16216
      endif
      if (fixterr) then
        write(ilog,1031)
        if (.not. terrdat) then
          baddat='Terrain'
          write(ilog,1075)trim(adjustl(baddat))   !terrain data not found
        endif
        if (fixter) write(ilog,1024) !bad terrain flag
        if (fixdem) write(ilog,1040) !demlist.txt does not exist
        if (fixaermp) write(ilog,1027) !bad AERMAP terrain elevation flag
        if (fixprobe) write(ilog,1010) !bad probe distance
        if (fixnad) write(ilog,1011) !NAD zone is badly formatted
        if (fixzone) write(ilog,1012) !UTM zone badly formatted
        if (fixnaddir) write(ilog,1038)quote1,trim(adjustl(nadpath)),
     +    quote1 !bad NAD grids path in demlist.txt
        if (fixcoords) write(ilog,1059) !bad UTM coordinates
        if (fixprof) write(ilog,1060) !bad PROFBASE
      endif
      if (fixdisc) then
        write(ilog,1070)
!        if (.not. discdat) then  !this will no longer be the case, if .not. discdat assume no receptors
!          baddat='Discrete receptor'
!          write(ilog,1075)trim(adjustl(baddat))   !discrete receptor data not found
!        endif
        if (fixdisfl) write(ilog,1071)  !bad flag
        if (nodisfil) write(ilog,1072) trim(adjustl(discfile))  !no receptor file
        if (negdisc) write(ilog,1073) !negative receptors
        if (ndisc .gt. maxdisc) write(ilog,1074)ndisc
        if (baddisc)  write(ilog,1077)   !bad input units in discrete file
      endif
      if (fixmisc .or. fixamb) then
        write(ilog,1032)
        if (.not. miscdat) then
          baddat='Miscellaneous'
          write(ilog,1075)trim(adjustl(baddat))   !miscellaneous data not found
        endif
        if (fixunits) write(ilog,1022) !bad units flag
        if (fixuflag) write(ilog,1025) !bad urban/rural flag
        if (fixurban) write(ilog,1013) !bad population
        if (fixamb) then  !bad ambient distance
          if (.not. lbadmisc) then
            if (lvolume) then
              write(ilog,1034)xnear  !distance inside volume source, reset
            else
              write(ilog,1035) !negative, reset
            endif
          else
            write(ilog,1061)  !bad format, stop
          endif
        endif
        if (fixflag1) write(ilog,1026) !bad flagpole use flag
        if (fixflag) write(ilog,1033) !bad flagpole height
        if (fixdists) write(ilog,1036) !probe distance < ambient distance
      endif
      if (fixfum) then
          if (fixfum1) write(ilog,1078)  !bad inversion break-up fumigation flag
!          if (fixfum2) write(ilog,1079)   !urban and fumigation 
          if (fixshore1) write(ilog,1080) !bad coastal fumigation flag
          if (fixshore2) write(ilog,1081) !bad coastal shoreline distance 
          if (fixshore3) write(ilog,1083) !bad coastal shoreline direction
          if (fixscreen) write(ilog,1084)  !invalid screening flag
      endif
      if (fixdebug) write(ilog,1082)   !bad debug flag
      if (fixout) then
!        if (.not. outdat) then  !no longer an error, if .not. outdat, assume default output filename
!          baddat='Output filename'
!          write(ilog,1075)trim(adjustl(baddat))   !output file data not found
!        endif
        if (fixout1) write(ilog,1048)
        if (fixfold) write(ilog,1049)
      endif   
      if (fixno2) then
        write(ilog,1062)
        
        if (.not. lno2) then
          if (lno2stack)write(ilog,1063)
          if (lo3val) write(ilog,1064)
        else
          
          if (fixpvmrm .and. fixolm) write(ilog,1065)
          if (.not. lno2poll) write(ilog,1066)trim(adjustl(noxchem))
          if (.not. lno2stack .or. fixno2stk)
     +    write(ilog,1067)trim(adjustl(noxchem))
          if (.not. lo3val .or. fixo3)
     +    write(ilog,1068)trim(adjustl(noxchem))
          if (fixo3uni)write(ilog,1069)
        endif
      endif   

 996  format(/1x,'One or more input parameters are invalid or will be ',
     +  'changed for source type',/1x,a) 
  997 format(/1x,'The following parameters are ',
     +  'invalid:')
  998 format(/1x,'AERSCREEN will be stopped')  
c 1000 format(/1x,'Building height is negative or zero') 
 1000 format(/1x,'Building height is <= zero or non-numeric')      
 1001 format(/1x,'Minimum building width',
     +  ' is greater than maximum building dimension or',
     +  ' dimensions are negative or non-numeric')
 1002 format(/1x,'Angle of maximum horizontal building dimension',
     +  ' is less than zero or greater than 179 degrees or non-numeric')
 1003 format(/1x,'Stack angle from North is less than zero ',
     +  'degrees or greater than 360 degrees or non-numeric')
 1004 format(/1x,'Minimum ambient temperature'
     +  ' is greater than maximum ambient temperature or ',
     +  'temperatures are negative or non-numeric')
 1005 format(/1x,'Surface characteristics code',
     +  ' is less than 0 or greater than 9 or non-numeric')
 1006 format(/1x,'Surface climate code',
     +  ' is less than 1 or greater than 3 or non-numeric')
 1007 format(/1x,'Surface characteristics file ',a,' does not exist')
 1008 format(/1x,'Minimum wind speed is negative or zero or ',
     + 'non-numeric')
 1009 format(/1x,'Aneomemeter height is negative or non-numeric')
 1010 format(/1x,'Probe distance is zero or negative or non-numeric')
 1011 format(/1x,'NAD zone code is not 1 (for NAD 27 ) ',
     +  'or 4( for NAD 83) or is non-numeric')
 1012 format(/1x,'UTM zone is less than or equal to zero or ',
     + 'non-numeric')
 1013 format(/1x,'Urban population is less than 100 people or ',
     + 'non-numeric')
 1014 format(/1x,'Emission rate is negative or zero or non-numeric')
 1015 format(/1x,'Release height is negative or non-numeric')
 1016 format(/1x,'Stack diameter is negative or non-numeric')
 1017 format(/1x,'Initial lateral dimension is negative or non-numeric')
 1018 format(/1x,'Initial vertical dimension is negative or non-',
     + 'numeric')
 1019 format(/1x,'Maximum horizontal area source dimension',
     +  ' is negative or non-numeric')
 1020 format(/1x,'Minimum horizontal area source dimension',
     +  ' is negative or non-numeric')
 1021 format(/1x,'Circular area radius is negative or non-numeric')
 
 1022 format(/1x,'Input units are indicated not to be metric')
 1023 format(/1x,'Building downwash flag is not valid')
 1024 format(/1x,'Terrain flag is not valid')
 1025 format(/1x,'Urban/rural flag is not valid')
 1026 format(/1x,'Flagpole switch is not valid')
 1027 format(/1x,'AERMAP elevation flag is not valid')
 1028 format(//1x,'SOURCE PARAMETERS')
 1029 format(//1x,'BUILDING PARAMETERS')
 1030 format(//1x,'METEOROLOGICAL PARAMETERS')
 1031 format(//1x,'TERRAIN PARAMETERS')
 1032 format(//1x,'OTHER PARAMETERS')
 1033 format(/1x,'Flagpole height is negative or non-numeric')
 1034 format(/1x,'Ambient distance inside volume source, ',
     +    're-setting to',1x,f8.1,' m')
 1035 format(/1x,'Ambient distance less than 1 m, resetting to 1 m')
 1036 format(/1x,'Probe distance is less than ambient distance')
 1037 format(/1x,'BPIPPRIME input file ',a,' does not exist')
c 1038 format(/1x,'No grid files exist in the NADGRIDS folder: ',a)
 1038 format(/1x,'No grid files exist in the NADGRIDS folder: ',3a,/1x,
     +'or the NADGRIDS keyword is not listed in demlist.txt')
 1039 format(/1x,'Stack to building center distance is negative or ',
     + 'incorrectly formatted')
 1040 format(/1x,'demlist.txt does not exist')
 1041 format(/1x,'Errors have been found in surface characteristics ',
     +  'file ',a/1x,'Check for incorrect formatting'/1x,
     +  'Errors include:')
 1042 format(/1x,'Temporal resolution is not MONTHLY, SEASONAL, or ',
     +  'ANNUAL')
 1043 format(/1x,'The number of spatial sectors is incorrectly ',
     + 'formatted or sectors overlap')
 1044 format(/1x,'Albedo is missing, negative or greater than 1.0 or ',
     + 'incorrectly formatted')
 1045 format(/1x,'Bowen ratio is missing or exceeds reasonable values ',
     + 'or incorrectly formatted')
 1046 format(/1x,'Surface roughness is missing or negative')
 1047 format(/1x,'Surface characteristics file ',a,' is incorrectly ',
     + 'formatted')
 1048 format(/1x,'AERSCREEN output file does not have .OUT extension')
 1049 format(/1x,'pathname of AERSCREEN output file does not exist')
 1050 format(/1x,'BPIPPRIME input file ',a,' does not have correct ',
     + 'process flag',/1x,'(line 2 of ',a,')')
 1051 format(/1x,'BPIPPRIME input file ',a,' has more than 1 stack')
c 1052 format(/1x,'Exit temperature is negative or non-numeric')
 1052 format(/1x,'Exit temperature is non-numeric')
 1053 format(/1x,'Exit velocity is non-numeric')
 1054 format(/1x,'Exit flow rate is non-numeric')
 1055 format(/1x,'Heat rate is non-numeric or negative')
 1056 format(/1x,'Heat loss is non-numeric')
 1057 format(/1x,'AREA source orientation angle is non-numeric'/1x,
     + 'Angle should be zero')
 1058 format(/1x,'AREACIRC vertices number is non-numeric'/1x,
     + 'Number of vertices should be 20')
 1059 format(/1x,'One or more UTM coordinates are non-numeric')
 1060 format(/1x,'Source elevation, PROFBASE, is non-numeric')
 1061 format(/1x,'Ambient distance is non-numeric')
 1062 format(/1x,'NOx CHEMISTRY PARAMETERS')
 1063 format(/1x,'PVMRM or OLM not specified but NO2/NOx ratio listed')
 1064 format(/1x,'PVMRM or OLM not specified but ozone concentration ',
     + 'listed')
 1065 format(/1x,'Both PVMRM and OLM specified')
 1066 format(/1x,a,1x,'specified but NO2 not listed as POLLUTID')
 1067 format(/1x,a,1x,'specified but NO2STACK ratio is missing or ',
     + 'outside acceptable range (0 - 1.0)')
 1068 format(/1x,a,1x,'specified but ozone concentration is negative',
     + ' or non-numeric')
 1069 format(/1x,'Ozone concentration units are invalid')
 1070 format(//1x,'DISCRETE RECEPTORS PARAMETERS')
 1071 format(/1x,'Discrete receptor flag invalid')
 1072 format(/1x,'Discrete receptor file ',a,' does not exist')
 1073 format(/1x,'One or more discrete receptors are negative')
 1074 format(/1x,'The number of discrete receptors ',i5,
     + /1x,'exceeds the maximum of 10')
 1075 format(/1x,a,' data line not found')
 1076 format(/1x,'Data inputs in AERSCREEN.INP are not in correct order'
     + /1x,'Emissions data must come before building, terrain, and ',
     + 'miscellaneous data')
 1077 format(/1x,'Discrete receptor distance units are not meters, ',
     + 'feet, kilometers, or miles')

 1078 format(/1x,'Inversion break-up fumigation flag invalid')
! 1079 format(/1x,'Fumigation requested for urban source')    
 1080 format(/1x,'Coastal fumigation flag invalid')
 1081 format(1x,'Minimum distance to shoreline greater than 3 km ', 
     +'or invalid') 
 1083 format(1x,'Direction to shoreline greater than 360 degrees', 
     +'or invalid') 
 1082 format(/1x,'Debug flag invalid')
 1084 format(/1x,'Run AERSCREEN flag invalid for selected fumigation ',
     +'options')
 1085 format(/1x,'Adjust u* flag invalid')
  30  return
      end
c -----------------------------------------------------------------------------
      subroutine stacks(iskip)
c     input source parameter information
      use main1
      implicit none

c iskip:    integer denoting if this is original pass through stacks or
c           changing of data
c iopt:     option denoting which variable to change
c ians:     integer answer from response
c conv:     units conversion from English to metric
c xsav:     set to xinit for area sources in case xinit and yinit must be switched
c           xinit is always the greater between xinit and yinit
c units1:   English or metric units in words
c units2:   abbreviated English or metric units
c response: response entered by user
c src:      source type text string for point, capped, and horizontal stack sources
c lall:     logical variable denoting to change all parameters (last option in lists)
c lbad:     logical variable denoting if a response is invalid (true) or okay (false)
c lreturn:  logical variable denoting whether to exit out of subroutine, i.e. return to validation page
c           or continue to next data section
c lblank:   logical variable denoting if response is all blanks

      integer iskip,iopt,ians
      real conv,xsav
      character units1*15,units2*15,response*15,src*20
      logical lall,lbad,lreturn,lblank

      iopt=0
      lreturn=.false.
      lall=.false.
      
      call header()
      write(*,99)
  
 99    format(/'         -------------------  SOURCE ',
     +  'INFORMATION  --------------------')
     
      
c --- Write list of variables to change based on source type and if routine is being
c called from validate
 10   if (iskip .eq. 2) then
        write(*,6)
c       point, horizontal, or capped stack options
        if (lpoint .or. lhor .or. lcap) then
           if (lpoint) then
             src=' Point source'
           else if (lcap) then
             src=' Capped stack'
           else
             src=' Horizontal stack'
           endif
           write(*,1)trim(adjustl(src))
c       flare options
        else if (lflare) then
           write(*,2)
c       volume options
        else if (lvolume) then
           write(*,3)
c       rectangular area options
        else if (larea) then
           write(*,4)
c       circular area options
        else
           write(*,5)
        endif
        write(*,7)
        read(*,'(a)')response
c        read(response,'(a1)')answer
        call checkanswer(response,lblank,lbad,2)
c       if (ichar(answer) .eq. 32) then 
        if (lblank) then
          if (larea) then 
             lreturn=.true.
             goto 70
           else
             goto 100
           endif
        else
c         check answer to make sure numeric
c         if not numeric, prompt again for options
c          call checkanswer(response(1:1),lbad)
          if (lbad .or. index(response,'.') .gt. 0) goto 10
          read(response,*)iopt
        endif
c       option 1 is emission rate for all source types
        if (iopt .eq. 1) then 
           goto 15
        elseif (iopt .lt. 1) then
          write(*,999)
          goto 10
        else
          if (lpoint .or. lcap .or. lhor) then   !point, capped, or horizontal stacks
!            if (iopt .eq. 9) then
            if (iopt .eq. 12) then    ! change all parameters
              lall=.true.
              goto 15
!            else if (iopt .lt. 9) then  
            else if (iopt .lt. 12) then
              lall=.false.
              if (iopt .ge. 2 .and. iopt .le. 5) then  !stack height, diameter, temperature, or velocity
                 goto 20
              else if (iopt .eq. 6) then !urban/rural classification
                 goto 30
              else if (iopt .eq. 7) then !urban population if urban source
                goto 35
              else if (iopt .eq. 8) then !distance to ambient air
                goto 40
              else if (iopt .eq. 9) then   !change NO2 chemistry
                goto 205
              else if (iopt .eq. 10) then  !change NO2/NOx ratio
                goto 210
              else                         !change ozone concentration
                goto 215
              endif
            else   !invalid option #
              write(*,999)
              goto 10
            endif
          elseif (lflare) then   ! flare source
!            if (iopt .eq. 8) then   !change all parameters
            if (iopt .eq. 11) then   !change all parameters
              lall=.true. 
              goto 15
!            else if (iopt .lt. 8) then
            else if (iopt .lt. 11) then
              lall=.false.
              if (iopt .ge. 2 .and. iopt .le. 4) then ! stack height, total heat release, heat loss fraction
                goto 55
              else if (iopt .eq. 5) then !urban/rural classification
                goto 30 
              else if (iopt .eq. 6) then !urban population if urban source
                goto 35
              else if (iopt .eq. 7) then  !distance to ambient air
                goto 40
              else if (iopt .eq. 8) then  !change NO2 chemistry
                goto 205
              else if (iopt .eq. 9) then !change NO2/NOx ratio
                goto 210
              else                       !change ozone concentration
                goto 215
              endif
            else  !invalid option #
              write(*,999)
              goto 10
            endif
          else if (lvolume) then    ! volume source
!            if (iopt .eq. 8) then   ! change all parameters
            if (iopt .eq. 11) then   ! change all parameters 
              lall=.true.
              goto 15
!            else if (iopt .lt. 8) then
            else if (iopt .lt. 11) then
              lall=.false.
              if (iopt .ge. 2 .and. iopt .le. 4) then ! volume height, lateral and vertical dimensions
                 goto 65
              else if (iopt .eq. 5) then  !urban/rural classification
                 goto 30 
              else if (iopt .eq. 6) then  !urban population if urban source
                 goto 35
              else if (iopt .eq. 7) then ! distance to ambient air
                 goto 40
              else if (iopt .eq. 8) then  !change NO2 chemistry
                goto 205
              else if (iopt .eq. 9) then !change NO2/NOx ratio
                goto 210
              else                       !change ozone concentration
                goto 215
              endif
            else  !invalid option #
              write(*,999)
              goto 10
            endif
          elseif (larea) then   !rectangular area source
!            if (iopt .eq. 9) then ! change all parameters
            if (iopt .eq. 12) then ! change all parameters
              lall=.true.
              goto 15
!            else if (iopt .lt. 9) then
            else if (iopt .lt. 12) then
              lall=.false.
              if (iopt .ge. 2 .and. iopt .le. 5) then  !release height, dimensions, and vertical dispersion parameter
                 goto 70
              else if (iopt .eq. 6) then !urban/rural classification
                 goto 30 
              else if (iopt .eq. 7) then !urban population if urban source
                 goto 35
              else if (iopt .eq. 8) then  ! distance to ambient air
                 goto 40
              else if (iopt .eq. 9) then !change NO2 chemistry
                goto 205
              else if (iopt .eq. 10) then !change NO2/NOx ratio
                goto 210
              else                        !change ozone concentration
                goto 215            
              endif 
            else  !invalid option #
              write(*,999)
              goto 10
            endif
          else  !circular area source
!            if (iopt .eq. 8) then !change all parameters
            if (iopt .eq. 11) then !change all parameters
              lall=.true.
              goto 15
!            else if (iopt .lt. 8) then
            else if (iopt .lt. 11) then
              lall=.false.
              if (iopt .ge. 2 .and. iopt .le. 4) then !release height, radius, vertical dispersion parameter
                 goto 75
              else if (iopt .eq. 5) then !urban/rural classification
                 goto 30 
              else if (iopt .eq. 6) then !urban population if urban source
                 goto 35
              else if (iopt .eq. 7) then  !distance to ambient air
                 goto 40
              else if (iopt .eq. 8) then  !change NO2 chemistry
                goto 205
              else if (iopt .eq. 9) then !change NO2/NOx ratio
                goto 210
              else        !change ozone concentration
                goto 215
              endif
            else   !invalid option #
              write(*,999)
              goto 10
            endif
        endif
       endif
      endif
      
  1   format(/a/' 1)  Emission rate'/' 2)  Stack height'/
     + ' 3)  Stack diameter'/' 4)  Stack temperature'/
     + ' 5)  Exit velocity'/' 6)  Urban/Rural'/' 7)  Urban population'/
     +  ' 8)  Distance to ambient air'/' 9)  NO2 chemistry'/
     +  ' 10)  NO2/NOx in stack ratio'/' 11) Ozone concentration'/
     +  ' 12)  Update all parameters')     

  2   format(/' Flare Source'/' 1)  Emission rate'/' 2)  Stack height'/
     +  ' 3)  Total heat release rate'/' 4)  Heat loss fraction'/
     +  ' 5)  Urban/Rural'/' 6)  Urban population'/
     +  ' 7)  Distance to ambient air'/' 8)  NO2 chemistry'/
     +  ' 9)  NO2/NOx in stack ratio'/' 10) Ozone concentration'/
     +  ' 11)  Update all parameters') 

  3   format(/' Volume Source'/' 1)  Emission rate'/
     + ' 2)  Center of volume height'/' 3)  Initial lateral dimension'/
     + ' 4)  Initial vertical dimension'/' 5)  Urban/Rural'/
     + ' 6)  Urban population'/' 7)  Distance to ambient air'/ 
     + ' 8)  NO2 chemistry'/' 9)  NO2/NOx in stack ratio'/
     +  ' 10) Ozone concentration'/' 11)  Update all parameters')
       
  4   format(/' Rectangular area source'/' 1)  Emission rate'/
     +  ' 2)  Release height'/' 3)  Long side dimension'/
     +  ' 4)  Short side dimension'/
     +  ' 5)  Initial vertical dimension'/
     +  ' 6)  Urban/Rural'/' 7)  Urban population'/
     +  ' 8)  Distance to ambient air'/' 9)  NO2 chemistry'/
     +  ' 10)  NO2/NOx in stack ratio'/' 11) Ozone concentration'/
     +  ' 12)  Update all parameters')
          

  5   format(/' Circular area source'/' 1)  Emission rate'/
     +  ' 2)  Release height'/' 3)  Radius'/' 4)  Initial vertical ',
     +  'dimension'/' 5)  Urban/Rural'/
     +  ' 6)  Urban population'/' 7)  Distance to ambient air'/
     +  ' 8)  NO2 chemistry'/' 9)  NO2/NOx in stack ratio'/
     +  ' 10) Ozone concentration'/' 11)  Update all parameters') 
          
  6   format(/1x,'----------------------------------------------------'
     +  /,1x,'Enter number of parameter to change or '/1x,
     +  '<Enter> to return to validation page')
     
  7   format(1x,'----------------------------------------------------'/)
  
c --- Enter Emission rates ---

 15   if (lmetric) then  
       units1='(g/s)'
      else
       units1='(lb/hr)'
      endif
      write(*,1030)trim(adjustl(units1))
      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,2)
      
      if (lblank .or. lbad) then
        write(*,999)
        goto 15
      endif
      read(response,*)emisrate
      if (.not. lmetric) emisrate = emisrate * 0.126
      if (emisrate .le. 0) then
        write(*,999)
        goto 15
      endif
c     if changing emission rate only, go back to option list
      if (iopt .eq. 1) goto 10

1030  format(///' Enter Emission Rate ',a,': '\)

c --- Enter Stack Height ---
 20   if (lpoint .or. lcap .or. lhor) then
       if (lmetric) then   !choose appropriate units
         units1='(meters)'
       else
         units1='(feet)'
       endif
       if (iopt .eq. 2) goto 101
       if (iopt .eq. 3) goto 102
       if (iopt .eq. 4) goto 103
       if (iopt .eq. 5) goto 105
       
c     stack height
 101   write(*,1000)trim(adjustl(units1))
       read(*,'(a)')response
       call checkanswer(response,lblank,lbad,2)
       if (lbad .or. lblank) then
        write(*,999)
        goto 101
       endif
       read(response,*)height
       if (height .lt. 0) then
         write(*,999)
         goto 101
        endif
       if (.not. lmetric) height = height * 0.3048
       if (iopt .eq. 2) goto 10  !go back to options list
       
c      stack diameter
       if (.not. lmetric) units1='(inches)'
 102   write(*,1001)trim(adjustl(units1))
       read(*,'(a)')response
       call checkanswer(response,lblank,lbad,2)
       if (lbad .or. lblank) then
        write(*,999)
        goto 102
       endif
       read(response,*)diameter
       if (.not. lmetric) diameter = diameter / 12.0 * 0.3048
       if (diameter .lt. 0) then
         write(*,999)
         goto 102
       endif
       if (iopt .eq. 3) goto 10  !go back to options list
 
c      stack temperature
c      if user enters 0, stack temperature will be ambient
c      if user enters negative number, it is a delta T
 103   if (lmetric) then
          units1='(K)'
       else
          units1='(F)'
       endif
       write(*,1002)trim(adjustl(units1)),trim(adjustl(units1))
       read(*,'(a)')response
       call checkanswer(response,lblank,lbad,2)
       if (lbad .or. lblank) then
        write(*,999)
        goto 103
       endif
       read(response,*)temperature
       if (.not. lmetric) then
          if (temperature .gt. 0.0) then 
            temperature = ((temperature - 32.0) * 5.0 / 9.0) + 273.15
          else
            temperature=temperature*0.55556  !convert delta F to delta K
          endif
       endif
       if (iopt .eq. 4) goto 10  !go back to options list

c      stack exit velocity
 105   write(*,1022)
       read(*,'(a)')response
       call checkanswer(response,lblank,lbad,2)
       if (lblank .or. lbad .or. index(response,'.') .gt. 0) then
        write(*,999)
        goto 105
       endif
c       read(response,'(i4)')ians
        read(response,*)ians
        if(ians .eq. 1) then  
 106      write(*,1003)
          read(*,'(a)')response
          call checkanswer(response,lblank,lbad,2)
          if (lbad .or. lblank) then
            write(*,999)
            goto 106
          endif
          read(response,*)velocity
          if (velocity .lt. 0) then
            write(*,*)' Exit velocity is negative, resetting to 1E-05'
            velocity=0.000001
            warnvel=.true.
          else
            warnvel=.false.
          endif
          flowrate = velocity * diameter**2. / 0.0006009

c     velocity in ft/s
       else if(ians .eq. 2) then
107       write(*,1004)
          read(*,'(a)')response
          call checkanswer(response,lblank,lbad,2)
          if (lbad .or. lblank) then
            write(*,999)
            goto 107
          endif
          read(response,*)velocity
          velocity = velocity * 0.3048
          if (velocity .lt. 0) then
            write(*,*)' Exit velocity is negative, resetting to 1E-05'
            velocity=0.000001
          endif
          flowrate = velocity * diameter**2. / 0.0006009
          
c      flowrate in cubic ft/minute
       else if(ians .eq. 3) then
108       write(*,1005)
          read(*,'(a)')response
          call checkanswer(response,lblank,lbad,2)
          if (lbad .or. lblank) then
            write(*,999)
            goto 108
          endif
          read(response,*)flowrate
          velocity = flowrate / diameter**2. * 0.0006009
          if (velocity .lt. 0) then
            write(*,*)' Exit velocity is negative, resetting to 1E-05'
            velocity=0.000001
          endif
       else
          write(*,999)
          goto 105
       endif
       if (iopt .eq. 5) goto 10  !go back to options
      endif
      
1000  format(//' Enter Stack Height ',a,': '\)
1001  format(//' Enter Stack Diameter ',a,': '\)
1002  format(//' Enter Stack Temperature 'a,/
     +   ' Enter 0 for ambient temperature '/
     +   ' or a negative number for temperature difference (',a,')'
     +   / ' between stack temperature and ambient temperature: '\)
1003  format(/' Enter Exit Velocity (m/s): '\)
1004  format(/' Enter Exit Velocity (ft/s): '\)
1005  format(/' Enter Flow Rate (ACFM): '\)
1022  format(//'----------------------------------------------'/
     + ' Option (1) - Exit Velocity (m/s)'/
     + ' Option (2) - Exit Velocity (ft/s)'/
     + ' Option (3) - Flow Rate (ACFM)'/
     + '----------------------------------------------'//
     + ' Enter Option for Flow Rate or Exit Velocity: '\)
     
c --- Enter Flare Stack Height ---
55    if (lflare) then
       if (iopt .eq. 2) goto 56
       if (iopt .eq. 3) goto 60
       if (iopt .eq. 4) goto 61

c      flare height
56     if (lmetric) then
        units1='(meters)'
       else
         units1='(feet)'
       endif
       write(*,1006)trim(adjustl(units1))
       read(*,'(a)')response
       call checkanswer(response,lblank,lbad,2)
       if (lbad .or. lblank) then
        write(*,999)
        goto 56
       endif
       read(response,*)flare_hgt
       if (.not. lmetric) flare_hgt = flare_hgt * 0.3048
       if (flare_hgt .lt. 0) then
          write(*,999)
          goto 56
        endif
       if (iopt .eq. 2) goto 201  ! calculate other stack parameters

c      heat release rate
60     write(*,'(//'' Enter Total Heat Release Rate (cal/sec): ''\)')
       read(*,'(a)')response 
       call checkanswer(response,lblank,lbad,2)
       if (lbad .or. lblank) then
        write(*,999)
        goto 60
       endif
       read(response,*)heat
       if (heat .lt. 0) then
        write(*,999)
        goto 60
       endif
       if (iopt .eq. 3) goto 201 ! calculate other stack parameters

c      heatloss fraction
61     write(*,1020)
       read(*,'(a)')response
c       read(response,'(a1)')answer
       call checkanswer(response,lblank,lbad,2)
c       if(ichar(answer) .eq. 32)then
       if (lblank) then
        heatloss = 0.55
       else
c        call checkanswer(answer,lbad)
        if (lbad) then
          write(*,999)
          goto 61
        endif
        read(response,'(f10.0)')heatloss
        if(heatloss .lt. 0.0)then
          heatloss=0.0
          write(*,1021)heatloss

        elseif(heatloss .gt. 1.0)then
          heatloss=1.0
          write(*,1021)heatloss

        endif
       endif
       if (iopt .eq. 4) goto 201 ! calculate other stack parameters
      endif
 1006 format(//' Enter Flare Stack Height ',a,': '\)    
 1020 format(//' Enter Radiative Heat Loss Fraction - '/
     + ' <Enter> for default value of 0.55: '\)
 1021 format(/' Heat Loss Fraction adjusted to ',f4.2,'! ')  
c ---  SET EFFECTIVE STACK PARAMETERS
c
 201  if (lflare) then
       velocity = 20.0
       temperature = 1273.
      
c ---  Note default heatloss fraction should be 0.55
       diameter = 9.88E-04*SQRT((1.-heatloss)*heat)
       IF (diameter .LT. 1E-05) diameter=1.0E-05

c ---  Compute effective release height for top of flare
       height = flare_hgt + 4.56E-03 * heat**0.478
       if (iskip .eq. 2 .and. iopt .lt. 5) goto 10  !go back to options list

      endif

c --- Enter Volume Source data ---
 65   if(lvolume) then

c      release height
       if (lmetric) then
        units1='(meters)'
       else
        units1='(feet)'
       endif 
       if (iopt .eq. 2) goto 301
       if (iopt .eq. 3) goto 302
       if (iopt .eq. 4) goto 303
 301   write(*,1007)trim(adjustl(units1))
       read(*,'(a)')response
       call checkanswer(response,lblank,lbad,2)
       if (lbad .or. lblank) then
        write(*,999)
        goto 301
       endif
       read(response,*)height
       if (.not. lmetric) height = height * 0.3048
       if (height .lt. 0) then
         write(*,999)
         goto 301
       endif
       if (iopt .eq. 2) goto 10  !go back to options list
       
c      initial lateral dimension
 302   write(*,1008)trim(adjustl(units1))
       read(*,'(a)')response
       call checkanswer(response,lblank,lbad,2)
       if (lbad .or. lblank) then
        write(*,999)
        goto 302
       endif
       read(response,*)syinit
       if (.not. lmetric) syinit = syinit * 0.3048
       if (syinit .lt. 0) then
         write(*,999)
         goto 302
       endif
       if (iopt .eq. 3) goto 10  !go back to options list

c      initial vertical dimension
 303   write(*,1009)trim(adjustl(units1))
       read(*,'(a)')response
       call checkanswer(response,lblank,lbad,2)
       if (lbad .or. lblank) then
        write(*,999)
        goto 303
       endif
       read(response,*)szinit
       if (.not. lmetric)szinit = szinit * 0.3048
       if (szinit .lt. 0) then
         write(*,999)
         goto 303
       endif
       if (iopt .eq. 4) goto 10  !go back to options list
      endif 

 1007 format(//' Enter Center of Volume Height ',a,': '\) 
 1008 format(//' Enter Initial Lateral Dimension ',a,': '\) 
 1009 format(//' Enter Initial Vertical Dimension ',a,': '\) 
 
c --- Enter AREA Source data ---
 70   if (larea) then
       if (lreturn) goto 409
       if (lmetric) then
        units1='(meters)'
       else
        units1='(feet)'
       endif 
       if (iopt .eq. 2) goto 401
       if (iopt .eq. 3) goto 402
       if (iopt .eq. 4) goto 403
       if (iopt .eq. 5) goto 404
       
c      release height
 401   write(*,1010)trim(adjustl(units1))
       read(*,'(a)')response
       call checkanswer(response,lblank,lbad,2)
       if (lbad .or. lblank) then
        write(*,999)
        goto 401
       endif
       read(response,*)height
       if (.not. lmetric) height = height * 0.3048
       if (height .lt. 0) then
         write(*,999)
         goto 401
       endif
       if (iopt .eq. 2) goto 10 !go back to options list
 
c      maximum horizontal dimension
 402   write(*,1011)trim(adjustl(units1))
       read(*,'(a)')response
       call checkanswer(response,lblank,lbad,2)
       if (lbad .or. lblank) then
        write(*,999)
        goto 402
       endif
       read(response,*)xinit
       if (.not. lmetric) xinit = xinit * 0.3048
       if (xinit .lt. 0) then
         write(*,999)
         goto 402
       endif
       if (iopt .eq. 3) goto 10  !go back to options list
c      minimum horizontal dimension
 403   write(*,1012)trim(adjustl(units1))
       read(*,'(a)')response
       call checkanswer(response,lblank,lbad,2)
       if (lbad .or. lblank) then
        write(*,999)
        goto 403
       endif
       read(response,*)yinit
       if (.not. lmetric) yinit = yinit * 0.3048
       if (yinit .lt. 0) then
         write(*,999)
         goto 403
       endif
       if (iopt .eq. 4) goto 10  !go back to options list
 
c      vertical dimension
 404   write(*,1013)trim(adjustl(units1))
       read(*,'(a)')response
       call checkanswer(response,lblank,lbad,2)
       if (lbad .or. lblank) then
        write(*,999)
        goto 404
       endif
       read(response,*)szinit
       if (.not. lmetric) szinit = szinit * 0.3048
       if (szinit .lt. 0) then
         write(*,999)
         goto 404
       endif
       if (iopt .eq. 5) goto 10 !go back to options list

c     check that the max and min dimensions are correct
c     this is done during initial prompts processing or after 
c     hitting return when choosing options
409     if (xinit .lt. yinit) then
         xsav = xinit
         xinit = yinit
         yinit = xsav
         write(*,98)
         write(ilog,98)
       endif
       call areaXY()
       if (iskip .eq. 2 .and. .not. lall .and. .not. lreturn) goto 10
       if (lreturn) goto 100
      endif

 98   format(/1x,'Long dimension and short dimension switched')


c --- Enter AREACIRC Source data ---
 75   if (lcirc) then
       if (lmetric) then
        units1='(meters)'
       else
        units1='(feet)'
       endif
       if (iopt .eq. 2) goto 501
       if (iopt .eq. 3) goto 502
       if (iopt .eq. 4) goto 503

c      release height
 501   write(*,1010)trim(adjustl(units1))
       read(*,'(a)')response
       call checkanswer(response,lblank,lbad,2)
       if (lbad .or. lblank) then
        write(*,999)
        goto 501
       endif
       read(response,*)height
       if (.not. lmetric) height = height * 0.3048
       if (height .lt. 0) then
         write(*,999)
         goto 501
       endif
       if (iopt .eq. 2) goto 10  !go back to options list

c      circular radius
 502   write(*,1014)trim(adjustl(units1))
       read(*,'(a)')response
       call checkanswer(response,lblank,lbad,2)
       if (lbad .or. lblank) then
        write(*,999)
        goto 502
       endif
       read(response,*)circrad
       if (.not. lmetric) circrad = circrad * 0.3048
       if (circrad .le. 0) then
         write(*,999)
         goto 502
       endif
       if (iopt .eq. 3) goto 10 !go back to options list
       
c      initial vertical dimension
 503   write(*,1013)trim(adjustl(units1))
       read(*,'(a)')response
       call checkanswer(response,lblank,lbad,2)
       if (lbad .or. lblank) then
        write(*,999)
        goto 503
       endif
       read(response,*)szinit
       if (.not. lmetric) szinit = szinit * 0.3048
       if (szinit .lt. 0) then
         write(*,999)
         goto 503
       endif
       if (iopt .eq. 4) goto 10  !go back to options list
      endif
 
c formats for area sources (rectangular and circular)
1010  format(//' Enter Release Height Above Ground ',a,': '\)
1011  format(//' Enter Maximum horizontal dimension of Area Source ',
     +  a,': '\)
1012  format(//' Enter Minimum horizontal dimension of Area Source ',
     +  a,': '\)
1013  format(//' Enter Initial Vertical Dimension ',a,': '\)
 1014 format(//' Enter Radius of AREACIRC Source ',a,': '\)
 
c --- Prompt for Rural vs. Urban ---
 30   write(*,1015)
c      read(*,'(a)')urban
      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,1)
      if (lbad .or. lblank) then
        write(*,999)
        goto 30
      endif
      urban=trim(adjustl(response))
      call upcase(urban)
 1015 format(//' Rural or Urban? (R or U): '\)
 
  35  if(urban .eq. 'U') then
       lurban=.true.
       write(*,1016)
       read(*,'(a)')response
       call checkanswer(response,lblank,lbad,2)
       if (lbad .or. lblank) then
        write(*,999)
        goto 35
       endif
       read(response,*)populat
       if (populat .le. 100) then
         write(*,999)
         goto 35
       endif
       if (iopt .gt. 0 .and. .not. lall) goto 10  !back to options list
      else if (urban .eq. 'R') then
       lurban=.false.
       if (iskip .ne. 2) populat = 0.0
       if (iskip .eq. 2 .and. iopt .eq. 7) then 
         write(*,996)
       endif
       if (iopt .gt. 0 .and. .not. lall) goto 10
      else
        write(*,999)
        goto 30
      endif
 1016 format(//' Enter Population of Urban Area: '\)
 996  format(/1x,'Source is not urban, cannot change population'/)
c --- Prompt for Distance to Ambient Air (optional) ---
 40   if (lmetric) then
        units1='(meters)'
        units2='(1 m)'
        if (lvolume) then
         if (2.15*syinit+1.0 .gt. 1.0) then
          write(units2,'(f8.3)')(2.15*syinit+1.0)
         else
          units2='(1 m)'
         endif
        else
          units2='(1 m)'
        endif
      else
        units1='(feet)'
        if (lvolume) then   !minimum distance cannot be inside volume
         if ((2.15*syinit/0.3048)+(1.0/0.3048) .gt. (1.0/0.3048)) then
          write(units2,'(f8.3)')(2.15*syinit/0.3048)+(1.0/0.3048)
          units2='('//trim(adjustl(units2))//' ft)'
         else
          units2='(3.3 ft)'
         endif
        else
          units2='(3.3 ft)'
        endif
      endif
      write(*,1017)trim(adjustl(units1)),trim(adjustl(units2))
      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,2)
       if (lblank) then
         if (lvolume) then
           xnear=max((2.15*syinit+1.0),1.0)
         else
           xnear=1.0
         endif
      else
         if (lbad) then
           write(*,999)
           goto 40
         endif
         read(response,'(f8.0)')xnear
         if (lmetric) then 
           units1='meters'
           conv=1.00
         else
           units1='feet'
           conv=0.3048
         endif
         if (lvolume .and. xnear/conv .lt. 2.15*syinit+1.0) 
     +      then   !reset to outside volume
           write(*,1023)xnear/conv,trim(adjustl(units1)),
     +        2.15*syinit/conv+(1.0/conv),trim(adjustl(units1))
           goto 40
         else
           if (.not. lmetric) xnear = xnear * 0.3048
           if (xnear .le. 0) then   !if negative set to 1 m
             write(*,*)' Changing ambient distance to 1 m'
             xnear=1.0
           endif
         endif
      endif
      if (iopt .gt. 0 .and. .not. lall) goto 10
1017  format(///' Enter Minimum Distance ',a,' to Ambient Air'/
     +  '<Enter> for default 'a,': '\)
1023  format(/' Ambient distance ',f8.4,1x,a,
     + ' is less than 2.15*sigma-y + 1 meter ',f8.4,1x,a)

c new 10350
c     prompt user for NO2 chemistry and parameters
 205  write(*,1025)
      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,2)
      if (lblank .or. lbad .or. index(response,'.') .gt. 0) then
        write(*,999)
        goto 205
      else
        read(response,'(i4)')ians
        if (ians .eq. 1) then
          lno2=.false.
          lpvmrm=.false.
          lolm=.false.
          no2stack=0.0
          o3=0.0
        else if (ians .eq. 2) then
          lno2=.true.
          lolm=.true.
          lpvmrm=.false.
          noxchem='OLM'
        else if (ians .eq. 3) then
          lno2=.true.
          lolm=.false.
          lpvmrm=.true.
          noxchem='PVMRM'
        else
          write(*,999)
          goto 205
        endif
      endif
      if (iskip .eq. 2 .and. .not. lall) goto 10
 210  if (lolm .or. lpvmrm) then
        write(*,1026)
        read(*,'(a)')response
        call checkanswer(response,lblank,lbad,2)
        if (lblank .or. lbad) then
          write(*,999)
          goto 210
        else
          read(response,'(f8.0)')no2stack
          if (no2stack .lt. 0 .or. no2stack .gt. 1.0) then
            write(*,999)
            goto 210
          endif
        endif
        if (iskip .eq. 2 .and. .not. lall) goto 10
!        if ((iopt .eq. 10 .and. (lpoint .or. lcap .or. lhor .or. larea))
!     + .or. (iopt .eq. 9 .and. (lflare .or. lcirc .or. lvolume))) 
!     + goto 10
      else
        if (iskip .eq. 2) then
          write(*,1029)
          goto 10
        endif
      endif
      
c     keep no2stack ratio and ozone separate, because they can be changed separately
c     that is why two different if statements, easier to handle.
 215  if (lolm .or. lpvmrm) then
        write(*,1027)
        read(*,'(a)')response
        call checkanswer(response,lblank,lbad,2)
        if (lblank .or. lbad .or. index(response,'.') .gt. 0) then
          write(*,999)
          goto 215
        else
          read(response,'(i4)')ians
          if (ians .eq. 1) then
            o3units='UG/M3'
          else if (ians .eq. 2) then
            o3units='PPM'
          else if (ians .eq. 3) then
            o3units='PPB'
          else
            write(*,999)
            goto 215
          endif
        endif
        write(*,1028)
        read(*,'(a)')response
        call checkanswer(response,lblank,lbad,2)
        if (lblank .or. lbad) then
          write(*,999)
          goto 215
        else
          read(response,'(f10.0)')o3
          if (o3 .lt. 0) then
            write(*,999)
            goto 215
          endif
        endif
        if (iskip .eq. 2) goto 10
      else
        if (iskip .eq. 2) then
          write(*,1029)
          goto 10
        endif
      endif
      
 1025 format(//1x,'Enter an option for modeling NO2 chemistry'/
     + 1x,'1)  No chemistry or pollutant is not NO2'/
     + 1x,'2)  Use Ozone Limiting Method (OLM)'/
     + 1x,'3)  Use Plume Volume Molar Ratio Method (PVMRM)')
     
 1026 format(//1x,'Enter in-stack NO2/NOx ratio ( 0 to 1.0): '\)
 
 1027 format(//1x,'Enter concentration units for representative ',
     + 'ozone concentration'/
     + 1x,'1)  Micrograms per cubic meter (ugm/m^3)'/
     + 1x,'2)  Parts per million (ppm)'/
     + 1x,'3)  Parts per billion (ppb)')
 1028 format(//1x,'Enter ozone concentration: '\)
 1029 format(/1x,'NO2 chemistry is not being used')
 999  format(1x,'Invalid response')
100   return
      end


c -----------------------------------------------------------------------------
      subroutine downwash(iskip)

c --- Prompt user for building wake data ---
      use main1
      implicit none
      
c iskip:    integer denoting if this is original pass through stacks or
c           changing of data
c iopt:     option denoting which variable to change 
c ic:       integer number of corner of building (ic=1,2,3, or 4)
c bx:       building center x-coordinate
c by:       building center y-coordinate
c x:        bulding corner x-coordinate
c y:        building corner y=coordinate
c radius:   distance between a particular corner and building center
c angle:    arctangent of (y-by)/(x-bx)
c ang:      angle between corner and building center with correction due to building orientation angle
c bline:    character string copy of building input file to bpipprm.inp
c char:     character of Y or N to use pre-existing building input file
c units1:   English or metric units in words
c response: response entered by user
c answer:   first character of response
c bexist:   logical flag denoting if bpipprm.inp exists (after renaming)
c bpipfile1:BPIP input filename
c lall:     logical variable denoting to change all parameters (last option in lists)
c lbad:     logical variable denoting if a response is invalid (true) or okay (false)
c lswitch1: logical variable denoting that minimum building dimension is greater than maximum building dimension
c lreturn:  logical variable denoting whether to exit out of subroutine, i.e. return to validation page
c           or continue to next data section     
c lblank:   logical variable denoting response is all blanks
c badht:    logical variable denoting buiding height is bad
c badang:   logical variable denoting that building angle is bad
c badsang:  logical variable denoting that stack angle relative to north is bad
c baddist:  logical variable denoting that stack-building distance is bad
c badlen:   logical variable denoting that building length is bad
c badwid:   logical variable denoting that building width is bad
c badfile:  logical variable denoting if BPIP input file is correctly formatted
      integer iskip,iopt,ic
      real bx,by,x,y,radius,angle,ang
      character bline*100,char*1,response*15,answer*1,units1*10,
     + bpipfile1*60
      logical bexist,lall,lswitch1,lbad,lblank,badht,badang,badsang,
     + baddist,badlen,badwid,badfile
      bexist=.false.
      lswitch1=.false.
      badht=.false.
      badlen=.false.
      badwid=.false.
      badang=.false.
      badsang=.false.
      baddist=.false.
      badfile=.false.
      badstack=.false.
      badbflag=.false.

c --- Return if Area source, AreaCirc, or volume source ---
      if(larea .or. lcirc .or. lvolume)then
        if (iskip .eq. 2) then
          write(*,6)
        else
         bpip = 'N'
         lbpip=.false.
        endif
       return
      endif

6     format(/' Source is area or volume source, no building ',
     +  'parameters to change')
c --- Skip data entry process if pre-existing BPIP file was chosen ---
c      if(bpipfile .ne. ' ')return      ! rwb - this should never happen!

      if (iskip .eq. 1) then
         if (lusebpip) then
            return
         else
            goto 10
         endif
      endif
      
      call header()
      write(*,*)' '
      write(*,*)'         -------------  BUILDING DOWNWASH ',
     +          'INFORMATION  --------------'
      
c options for changing individual parameters
      iopt=0
      lall=.false.
      
 3    if (iskip .eq. 2) then
        write(*,995) 
        if (lbpip) then
          if (.not. lusebpip) then
            if (bheight .le. 0) badht=.true.
            if (blength .le. 0) badlen=.true.
            if (bwidth .le. 0) badwid=.true.
            
            if (bangle .lt. 0 .or. bangle .gt. 179) badang=.true.
            if (sangle .lt. 0 .or. sangle .gt. 360) badsang=.true.
            if (sdistance .lt. 0) baddist=.true.
          else
            badht=.false.
            badlen=.false.
            badwid=.false.
            badang=.false.
            badsang=.false.
            baddist=.false.  
          endif
          write(*,1)
        else
          
          write(*,2)
        endif
        write(*,996)
        read(*,'(a)')response
        call checkanswer(response,lblank,lbad,2)
        if (lblank) then
            if (.not. lusebpip) then
              if (.not. badht .and. .not. badlen .and. .not. badwid 
     +         .and. .not. badang .and. .not. badsang .and. .not. 
     +          baddist) then 
                goto 55  !check building maximum and minimum horizontal dimensions
              else
                if (badht) then
                  write(*,3001)
                  goto 301
                endif
                if (badlen) then
                  write(*,3002)
                  goto 302
                 endif
                 if (badwid) then
                  write(*,3003)
                  goto 303
                 endif
                 if (badang) then
                  write(*,3004)
                  goto 40
                 endif
                 if (badsang) then
                  write(*,3005)
                  goto 45
                 endif
                 if (baddist) then
                  write(*,3006)
                  goto 50
                 endif
              endif
            else
              goto 58
            endif
        else
          if (lbad .or. index(response,'.') .gt. 0) goto 3
          read(response,*)iopt
        endif
        if (iopt .eq. 1) then   !include or not include downwash
          goto 20
        else if (iopt .le. 9) then
          if (.not. lbpip .and. iopt .lt. 9) then
            write(*,997)
            goto 3
          else
            if (iopt .gt. 2 .and. iopt .lt. 9 .and. lusebpip) then
              write(*,994)
              goto 3
c             goto 35
            else if (iopt .eq. 2) then  !BPIP input filename
              goto 30
            else if (iopt .le. 5) then  !buildingt height, or horizontal dimensions
              goto 35
            else if (iopt .eq. 6) then !angle of building relative to north 
              goto 40
            else if (iopt .eq. 7) then  !angle of stack to building center
              goto 45
            else if (iopt .eq. 8) then  !distance between stack and building center
              goto 50
            else            !updated all parameters
              lall=.true.
              goto 22
            endif
          endif
        else
          write(*,999)
          goto 3
        endif
      endif
      
  995 format(/'------------------------------------------------------'
     +  /'Enter number of parameter to change or'/
     +  '<Enter> to return to validation page')
  996 format(/'------------------------------------------------------'/)
  997 format(/' Downwash is not included, cannot change parameter'/) 
!  994 format(/' WARNING!!!'/1x,'BPIP input file being used, ',
!     +  'AERSCREEN will now use user-entered inputs'/)  
  994 format(//1x,'BPIPPRM input file being used, '/1x,
     +  'Cannot change building parameters'/1x,
     +  'Select option 2 and choose no for using a pre-existing ',
     +  'BPIPPRM input file'/)      
 1    format(/'Pre-existing BPIPPRM input filename must be'/
     +  're-entered if',
     +  ' it is to be used (Option 2)'/
     +  ' 1)  Do not include building downwash'/
     +  ' 2)  BIPPPRM input filename'/' 3)  ',
     +  'Building height'/' 4)  Maximum horizontal dimension'/
     +  ' 5)  Minimum horizontal dimension'/
     +   ' 6)  Maximum building dimension angle to North'/
     +  ' 7)  Angle of stack from building center'/
     +  ' 8)  Distance between stack and building center'/
     +  ' 9)  Update all parameters')
     
 2    format(/'Pre-existing BPIPPRM input filename must be'/
     +  're-entered ','if it is to be used (Option 2)'/
     +  ' 1)  Include building downwash'/
     +  ' 2)  BIPPPRM input filename'/' 3)  Building height'/
     +  ' 4)  Maximum horizontal dimension'/' 5)  Minimum horizontal ',
     +  'dimension'/' 6)  Maximum building dimension angle to North'/
     +  ' 7)  Angle of stack from building center'/
     +  ' 8)  Distance between stack and building center'/
     +  ' 9)  Include building downwash and update all parameters')
 
3001  format(/1x,'Negative or zero building height')
3002  format(/1x,'Negative or zero maximum building dimension')
3003  format(/1x,'Negative or zero minimum building dimension')
3004  format(/1x,'Maximum building dimension angle relative to North is'
     + ,/1x,'negative or greater than 179 degrees')
3005  format(/1x,'Angle between stack and building center is negative ',
     + /1x,'or greater than 360 degrees')
3006  format(/1x,'Distance between stack and building center is ',
     + 'negative')


 20   if (iskip .eq. 2 .and. iopt .eq. 1) then
        if (lbpip) then   !reset flags for writing to AERSCREEN.INP
          bpip = 'N'
        else
          bpip = 'Y'
        endif
        goto 21
      endif
      
c     prompt to include downwash
 22   write(*,2000)
      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,1)
      if (lblank .or. lbad) then
        write(*,999)
        goto 22
      endif
      bpip=trim(adjustl(response))
      call upcase(bpip)
 2000 format(//' Include Building Downwash? (y/n): '\)    
 21   if(bpip .eq. 'N') then 
        lbpip=.false.
        if (iskip .eq. 2 .and. .not. lall) then
          return
        endif
      else if (bpip .eq. 'Y') then
        lbpip=.true.
      else
        goto 22
      endif

      if (iskip .eq. 0) then
        bheight    = 0.0
        blength    = 0.0
        bwidth     = 0.0
        bangle     = 0.0
        sangle     = 0.0
        sdistance  = 0.0
      endif

      if(.not. lbpip) return
      if (iskip .eq. 2 .and. .not. lall) goto 3
      
c --- Allow user choice of a pre-existing BPIP input file ---
c --- User can keep current version of BPIP file or use a different one ---
 30   write(*,2001)
      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,1)
      if (lblank .or. lbad) then
        write(*,999)
        goto 30
      endif
      char=trim(adjustl(response))
      call upcase(char)
 2001 format(//' Use pre-existing BPIPPRM input file? (y/n): '\)
      if(char .eq. 'Y') then
       write(*,2002)
       read(*,*)bpipfile
!       if (bpipfile .ne. '' ) then
!        write(*,3014)trim(adjustl(bpipfile))
!       else
!        write(*,2002)
!       endif
!       read(*,'(a)')bpipfile1
!       if (bpipfile1 .ne. ' ')bpipfile=bpipfile1
       inquire(file=bpipfile,exist=bexist)
       if (.not. bexist) then
         write(*,2003)trim(adjustl(bpipfile))
         goto 30
       endif
       badstack=.false.
       badbflag=.false.
       call checkbpip(badfile)   !check that file is formatted correctly for AERMOD
       if (badfile) then
          write(*,3010)trim(adjustl(bpipfile))
          if (badbflag) write(*,3011)
          if (badstack) write(*,3012)
          goto 30
       endif     
       lusebpip=.true.
!       write(bline,100)trim(adjustl(bpipfile))
!  100  format('copy "',a,'" bpipprm.inp /y > NUL')
!       call system(bline)    
       if (iskip .eq. 2 .and. .not. lall) then
         goto 3
       else
        return
       endif     
      else if (char .eq. 'N') then
        bpipfile=' '
        lusebpip=.false.
        if (iskip .eq. 2 .and. .not. lall)goto 3
      else
        write(*,999)
        goto 30
      endif
2002  format(//' Enter user created BPIPPRM input file:  '\)
2003  format(///' User defined BPIPPRM input file not found: ',a)
3010  format(//1x,'BPIPPRM input file ',a,' is incorrectly formatted ',
     + 'for AERSCREEN')
3011  format(/1x,'Process flag is not set to P for PRIME ',
     +  'downwash')
3012  format(/1x,'Number of stacks is greater than 1')
!3014  format(/1x,'<Enter> to use current BPIP file ',a,/1x,
!     + 'or enter user created BPIP input file: '\)
     
    5 call header()
      write(*,*)' '
      write(*,*)'         -------------  BUILDING DOWNWASH ',
     +          'INFORMATION  --------------'

c --- Enter Building Height, length, and width ---
 35   if(lmetric) then
        units1='(meters)'
      else
        units1='(feet)'
      endif
      if (iopt .eq. 3) goto 301
      if (iopt .eq. 4) goto 302
      if (iopt .eq. 5) goto 303
      
c     building height
 301  write(*,2004)trim(adjustl(units1))
      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,2)
      if (lblank .or. lbad) then
        write(*,999)
        goto 301
      endif
      read(response,*)bheight
      if (.not. lmetric) bheight = bheight * 0.3048
      if (bheight .le. 0) then
        write(*,999)
        goto 301
      endif
      if (badht) badht=.false.
      if (badlen) then
        write(*,3002)
        goto 302
      endif
      if (badwid) then
        write(*,3003)
        goto 303
      endif
      if (badang) then
        write(*,3004)
        goto 40
      endif
      if (badsang) then
        write(*,3005)
        goto 45
      endif
      if (baddist) then
        write(*,3006)
        goto 50
      endif
      if (iopt .eq. 3) goto 3  !go back to options
      
       
c     maximum horizontal dimension
 302  write(*,2005)trim(adjustl(units1))
      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,2)
      if (lblank .or. lbad) then
        write(*,999)
        goto 302
      endif
      read(response,*)blength
      if (blength .le. 0) then
        write(*,999)
        goto 302
      endif
      if (.not. lmetric) blength = blength * 0.3048
      if (badlen) badlen=.false.
      if (badwid) then
        write(*,3003)
        goto 303
      endif
      if (badang) then
        write(*,3004)
        goto 40
      endif
      if (badsang) then
        write(*,3005)
        goto 45
      endif
      if (baddist) then
        write(*,3006)
        goto 50
      endif
      

      if (iopt .eq. 4 .and. .not. lswitch1) goto 3 !go back to options
      
      
c    minimum horizontal dimension
 303  write(*,2006)trim(adjustl(units1))
      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,2)
      if (lblank .or. lbad) then
        write(*,999)
        goto 303
      endif
      read(response,*)bwidth
      if (bwidth .le. 0) then
        write(*,999)
        goto 303
      endif
      if (.not. lmetric) bwidth = bwidth * 0.3048
      if (badwid) badwid=.false.
      if (badang) then
        write(*,3004)
        goto 40
      endif
      if (badsang) then
        write(*,3005)
        goto 45
      endif
      if (baddist) then
        write(*,3006)
        goto 50
      endif
      
      
      if (lswitch1) goto 55  !dimensions were switched, check again

      if (iopt .eq. 5) goto 3  !go back to options
      
      
 2004 format(//' Enter Building Height ',a,': '\)
 2005 format(//' Enter Maximum Horizontal Building Dimension ',a,': '\)
 2006 format(//' Minimum Horizontal Building Dimension ',a,': '\)
 1011 format(//' Minimum horizontal building dimension'
     +  /' is greater than maximum horizontal building dimension ') 
      
c --- Enter Building Direction Orientation ---

 40   write(*,2007)
      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,2)
      if (lblank .or. lbad) then
        write(*,999)
        goto 40
      endif
      read(response,*)bangle
      if (bangle .lt. 0 .or. bangle .gt. 179) then
        write(*,999)
        goto 40
      endif
      if (badang) badang=.false.
      if (badsang) then
        write(*,3005)
        goto 45
      endif
      if (baddist) then
        write(*,3006)
        goto 50
      endif
      if (iopt .eq. 6) goto 3  !go back to options
      
      
 2007 format(//' Enter Maximum Building Dimension Angle to True ',
     +  'North (0 - 179 degees): '\)
     
c --- Enter Stack Direction from Building Center ---
 45   write(*,2008)
      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,2)
      if (lblank .or. lbad) then
        write(*,999)
        goto 45
      endif
      read(response,*)sangle
      
      if (sangle .lt. 0 .or. sangle .gt. 360) then
        write(*,999)
        goto 45
      endif
      if (badsang) badsang=.false.
      if (baddist) then
        write(*,3006)
        goto 50
      endif
      if (iopt .eq. 7) goto 3  !go back to options
2008  format(//' Enter Direction of Stack from Building Center ',
     + '(0 - 360 degrees): '\)
     
c --- Enter Stack Distance from Building Center ---
 50   if(lmetric) then
       units1='(meters)'
      else
       units1='(feet)'
      endif
      write(*,2009)trim(adjustl(units1))
      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,2)
      if (lblank .or. lbad) then
        write(*,999)
        goto 50
      endif
      read(response,*)sdistance
      if (sdistance .lt. 0) then
        write(*,999)
        goto 50
      endif
      if (.not. lmetric) sdistance = sdistance * 0.3048
      if (baddist) baddist=.false.
      if (iopt .eq. 8) goto 3  !go back to options
     
 2009 format(//'  Enter Distance Between Stack and Building Center ',a,
     +  ': '\)     

c     check to make sure blength is larger than bwidth  and
c     other parameters are within valid ranges
c     this is in case the use of downwash was no in the
c     input file and parameters were negative or out of range
c     and were not checked.
 
 55   if (bwidth .gt. blength) then
         write(*,1011)
         lswitch1=.true.
         goto 302
      else
         goto 56
      endif  
 58   if (lusebpip) then
        badbflag=.false.
        badstack=.false.
        call checkbpip(badfile)
        if (badfile) then
          write(*,3010)trim(adjustl(bpipfile))
          if (badbflag) write(*,3011)
          if (badstack) write(*,3012)
          goto 30
        else
          goto 56
        endif
      endif
          
 56   if(iskip .eq. 2) return  !exit if done

c --- Create BPIPPRM.INP file ---
      write(*,'(////'' Setting up BPIP Prime.... '')')

!   10 open(bpipin,file='bpipprm.inp',status='unknown')
  10  bpipfile='bpipprm.inp'
      open(bpipin,file=bpipfile,status='unknown')  
c --- Write header information ---
      write(bpipin,1000)title
      write(bpipin,1001)
      write(bpipin,1002)
      write(bpipin,1003)
      write(bpipin,1004)
      write(bpipin,1005)
      write(bpipin,1006)bheight

c --- Determine building x/y center coordinate ---
      bx = cos ( (270.-sangle)*3.14159/180.0 )
      by = sin ( (270.-sangle)*3.14159/180.0 )

      bx = bx * sdistance
      by = by * sdistance
      
c create building coordinates
      do ic=1,4
        if (ic .eq. 1) then   !1st coordinate
          x = bx - bwidth/2.0
          y = by + blength/2.0
        elseif (ic .eq. 2) then  !2nd coordinate
          x = bx + bwidth/2.
          y = by + blength/2.
        elseif (ic .eq. 3) then  !3rd coordinate
          x = bx + bwidth/2.
          y = by - blength/2.
        else                   !4th coordinate
          x = bx - bwidth/2.
          y = by - blength/2.
        endif
        radius = ( (x-bx)**2. + (y-by)**2. )**.5
        angle = (y-by)/(x-bx)
        angle = atan(angle)/(3.14159/180)
        if((x-bx) .gt. 0.0)ang = (90-angle)+bangle
        if((x-bx) .le. 0.0)ang = (270-angle)+bangle
        
        call xycalc(ang,x,y,radius,bx,by)
        write(bpipin,1007)x,y
      enddo
c --- Create 1st building coordinate ---
c      x = bx - blength/2.0
c      y = by + bwidth/2.0
      
c      radius = ( (x-bx)**2. + (y-by)**2. )**.5

c      angle = (y-by)/(x-bx)
c      angle = atan(angle)/(3.14159/180)

c      if((x-bx) .gt. 0.0)ang = (90-angle)+bangle

c      if((x-bx) .le. 0.0)ang = (270-angle)+bangle

c      call xycalc(ang,x,y,radius,bx,by)

c      write(bpipin,1007)x,y


c --- Create 2nd building coordinate --- */
c      x = bx + blength/2.
c      y = by + bwidth/2.

c      radius = ( (x-bx)**2. + (y-by)**2. )**.5

c      angle = (y-by)/(x-bx)
c      angle = atan(angle)/(3.14159/180)

c      if((x-bx) .gt. 0.0)ang = (90.-angle)+bangle

c      if((x-bx) .le. 0.0)ang = (270.-angle)+bangle

c      call xycalc(ang,x,y,radius,bx,by)

c      write(bpipin,1007)x,y


c --- Create 3rd building coordinate --- */
c      x = bx + blength/2
c      y = by - bwidth/2

c      radius = ( (x-bx)**2. + (y-by)**2. )**.5

c      angle = (y-by)/(x-bx)
c      angle = atan(angle)/(3.14159/180.)

c      if((x-bx) .gt. 0.0)ang = (90.-angle)+bangle

c      if((x-bx) .le. 0.0)ang = (270.-angle)+bangle

c      call xycalc(ang,x,y,radius,bx,by)

c      write(bpipin,1007)x,y


c --- Create 4th building coordinate --- */
c      x = bx - blength/2
c      y = by - bwidth/2

c      radius = ( (x-bx)**2. + (y-by)**2. )**.5

c      angle = (y-by)/(x-bx)
c      angle = atan(angle)/(3.14159/180.)

c      if((x-bx) .gt. 0.0)ang = (90.-angle)+bangle

c      if((x-bx) .le. 0.0)ang = (270.-angle)+bangle

c      call xycalc(ang,x,y,radius,bx,by)

c      write(bpipin,1007)x,y


c --- Write remainder of input file --- */
      write(bpipin,1004)
      write(bpipin,1008)height
      write(bpipin,1009)

      close(bpipin)


 
 1000 format('''',a,'''')
 1001 format('''','P','''')
 1002 format('''','METERS','''',' 1.0')
 1003 format('''','UTMN','''','   0')
 1004 format('1')
 1005 format('''','Building','''','  1  0')
 1006 format('4',f10.2)
 1007 format(2f10.2)
 1008 format('''','stack','''','     0.0',f8.2,'     0.0     0.0')
 1009 format('0')
  999 format(1x,'Invalid response')
 
      end


c -----------------------------------------------------------------------------
      subroutine getDEMs(iskip)
 
c --- Prompt user for terrain height data ---
      use main1
      implicit none

c response:       character response to answers, may be character or numeric
c answer:         substring of response when one-character response needed, 
c                 such as y or n for yes or no  
c acoord:         coordinate type, LATLON or latitude and longitude, or UTM
c                 for UTM coordinates
c units1:         Units, feet or meters, for flagpole heights
c iskip:          integer variable determining how getDEMs should proceed
c                 if iskip=0 then proceed through all prompts
c                 if iskip=1 then exit subroutine
c                 if iskip=2 then list options for parameter changes
c iopt:           option number of parameter to change
c dfault:         integer default probe distance, 5,000 m for flat terrain
c                 10,000 m for complex terrain
c i:              integer loop counter
c lat:            input latitude
c long            input longitude
c lall:           logical variable denoting if all parameters to be changed
c lbad:           logical variable denoting if response is invalid
c lblank:         logical variable denoting if response is all blanks
c badnad:         logical variable indicating invalid NAD datum choice
c badzone:        logical variable denoting invalid UTM zone
c badcoords:      logical variable denoting one or both UTM coordinates are zero 
      
      character response*15,answer*1,acoord*6,units1*10

      integer iskip,iopt,dfault,i
      real lat,long

      logical lall,lbad,lblank,badnad,badzone,badcoords
      
      badnad=.false.
      badzone=.false.
      badcoords=.false.
      lall=.false.


      if(iskip .eq. 1)goto 10  !continue
  
      call header()
      write(*,995)
 995  format(/'          -------------  TERRAIN HEIGHT ',
     + 'INFORMATION  --------------')
     
      iopt=0
 45   if (iskip .eq. 2)then 
        if (lterrain) then
          if (utmx .eq. 0 .or. utmy .eq. 0) badcoords=.true.
          if (nada .ne. 1 .and. nada .ne. 4)badnad=.true.
          if (izone .le. 0 .and. .not. llat) then 
            badzone=.true.
          else
            badzone=.false.
          endif
          write(*,1)
        elseif (.not. lterrain .and. .not. larea) then
          write(*,2)
        else
          write(*,3)
        endif
        read(*,'(a)')response
        call checkanswer(response,lblank,lbad,2)
        if (lblank) then
           if (.not. badzone .and. 
     +      .not. badnad .and. .not. badcoords) then
            return
           else
            if (badzone) then 
              write(*,3000)
              goto 70
            endif
            if (badnad) then
              write(*,3001)
              goto 75
            endif
            if (badcoords) then
              write(*,3002)
              return
            endif
           endif
        else
          if (lbad .or. index(response,'.') .gt. 0) goto 45
          read(response,*)iopt
!          if (iopt .gt. 7 .or. iopt .lt. 1) then
          if (iopt .gt. 9 .or. iopt .lt. 1) then
            write(*,999)
            goto 45
          endif
          if (larea) then
!            if (iopt .ne. 5) then 
            if (iopt .ne. 7) then 
               lall=.false.
               if (iopt .eq. 1) then
                 goto 55
               elseif (iopt .eq. 2) then
                 goto 105
               elseif (iopt .eq. 3) then
                 goto 110
               elseif (iopt .eq. 4) then
                 goto 60
               elseif (iopt .eq. 5) then
                 goto 305
               elseif (iopt .eq. 6) then
                goto 310
               endif
            else
              lall=.true.
              goto 50
            endif
          else
!            if (iopt .eq. 7) then
            if (iopt .eq. 9) then
              lall=.true.
            else
              lall=.false.
            endif
!            if (.not. lterrain .and. iopt .gt. 5 
!     +       .and. iopt .ne. 7) then
            if (.not. lterrain .and. iopt .eq. 6) then 
              write(*,4)
              goto 45
            else
              if (iopt .eq. 1) goto 50
              if (iopt .eq. 2) goto 55
              if (iopt .eq. 3) goto 105
              if (iopt .eq. 4) goto 110
              if (iopt .eq. 5) goto 60
              if (iopt .eq. 6) goto 65
              if (iopt .eq. 7) goto 305
              if (iopt .eq. 8) then
                if (.not. ldiscrete) then
                  write(*,5)
                  goto 45
                else
                  goto 310
                endif
              endif
              if (iopt .eq. 9) goto 50
            endif
          endif
        endif
      else
        discfile=''
      endif

3000  format(/1x,'UTM zone is invalid')
3001  format(1x,'NAD conversion is invalid')
3002  format(/1x,'UTM coordinates are zero',/1x,'Re-enter if necessary')
!1     format(/'---------------------------------------------------'/
!     + ' 1) Do not include terrain heights'/' 2) Probe ',
!     +  'distance'/' 3) Use flagpole receptors'/
!     +  ' 4) Flagpole heights'/' 5) Source elevation input ',
!     +  '(user entered or AERMAP)'/' 6) Input coordinate type and ',
!     +  'coordinates (LATLON or '/'    UTM), UTM zone, and NAD'/
!     +  ' 7) Update all parameters'/
!     +'---------------------------------------------------'/)
1     format(/'---------------------------------------------------'/
     + ' 1) Do not include terrain heights'/' 2) Probe ',
     +  'distance'/' 3) Use flagpole receptors'/
     +  ' 4) Flagpole heights'/' 5) Source elevation input ',
     +  '(user entered or AERMAP)'/' 6) Input coordinate type and ',
     +  'coordinates (LATLON or '/'    UTM), UTM zone, and NAD'/
     +  ' 7) Include discrete receptors'/
     +  ' 8) Filename of discrete receptor list'/
     +  ' 9) Update all parameters'/
     +'---------------------------------------------------'/)     
!2     format(/'---------------------------------------------------'/
!     + ' 1) Include terrain heights'/' 2) Probe ',
!     +  'distance'/' 3) Use flagpole receptors'/
!     +  ' 4) Flagpole heights'/' 5) Source elevation input ',
!     +  '(user entered or AERMAP)'/' 6) Input coordinate type and ',
!     +  'coordinates (LATLON or '/'    UTM), UTM zone, and NAD'/
!     +  ' 7) Include terrain heights and update all parameters'/
!     +'---------------------------------------------------'/)
2     format(/'---------------------------------------------------'/
     + ' 1) Include terrain heights'/' 2) Probe ',
     +  'distance'/' 3) Use flagpole receptors'/
     +  ' 4) Flagpole heights'/' 5) Source elevation input ',
     +  '(user entered or zero)'/' 6) Input coordinate type and ',
     +  'coordinates (LATLON or '/'    UTM), UTM zone, and NAD'/
     +  ' 7) Include discrete receptors'/
     +  ' 8) Filename of discrete receptor list'/     
     +  ' 9) Include terrain heights and update all parameters'/
     +'---------------------------------------------------'/)
     
!3     format(/'---------------------------------------------------'/
!     +  ' 1) Probe distance'/
!     +  ' 2) Use flagpole receptors'/
!     +  ' 3) Flagpole heights'/
!     +  ' 4) Source elevation input'/
!     +  ' 5) Update all parameters'/
!     +'---------------------------------------------------'/)     
3     format(/'---------------------------------------------------'/
     +  ' 1) Probe distance'/
     +  ' 2) Use flagpole receptors'/
     +  ' 3) Flagpole heights'/
     +  ' 4) Source elevation input (user entered or zero)'/
     +  ' 5) Include discrete receptors'/
     +  ' 6) Filename of discrete receptor list'/
     +  ' 7) Update all parameters'/
     +'---------------------------------------------------'/)     
     
4     format(/'Terrain not chosen, must turn on terrain first')
5     format(/'Discrete receptors not being used ',/
     + 'Must select use of discrete receptors first')
c if running rectangular area source, do not use terrain 
 50   if (.not. larea) then
        if (iskip .eq. 2 .and. .not. lall) then
          if (lterrain) then
            terrain='N'
          else
            terrain='Y'
          endif
          goto 51
        endif

c       prompt for terrain processing
        write(*,1000)
        read(*,'(a)')response
        call checkanswer(response,lblank,lbad,1)
        if (lblank .or. lbad) then
          goto 50
        endif
        terrain=trim(adjustl(response))
        call upcase(terrain)
51      if(terrain .eq. 'N') then 
          lterrain=.false.
        else if (terrain .eq. 'Y') then 
           lterrain=.true.
        else
           goto 50
        endif
      else
          write(*,*)'Rectangular area source, do not use terrain'
          terrain='N'
          lterrain=.false.
      endif
      
1000  format(//' Include Terrain Heights? (y/n): '\)

      if (iskip .eq. 2 .and. iopt .eq. 1) then
        if (lterrain .and. .not. lcalc .and. nada .ne. 0) then 
          goto 95
        else
          goto 45
        endif
      endif
         
      
      if (iskip .eq. 0) then
        utmx = 0.0
        utmy = 0.0
        izone = 0
        nada  = 0
      endif
      

c --- Prompt for probe distance (optional) ---
c --- if flat terrain, default is 5 km
c --- if terrain used, default is 10 km
c --- distances now in meters, not kilometers JAT 11/29/2010
55    if (lterrain) then
       dfault=10000
      else
        dfault=5000
      endif
      write(*,1001)dfault
      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,2)
      if (lblank) then
         probedist = real(dfault)
         changeprobe=.false.
      else
         if (lbad) goto 55
         read(response,'(f8.0)')probedist
         if (probedist .le. 0) then
           write(*,999)
           goto 55
         endif
c     JAT 11/29/2010, now make probe distance a multiple of 25 m
c     this makes receptor spacing easier
         call checkprobe
         if (changeprobe) write(*,1012)probedist1,probedist
      endif
      if (iskip .eq. 2 .and. .not. lall) goto 45
      
1001  format(///' Enter Maximum Distance (m) to probe '/
     +  ' <Enter> for default (',i5,' m): '\)  
1012  format(//1x,'******* WARNING *************'/1x,
     +  'Probe distance changed from ',f9.2,' m to ',/1x,f9.2,' m')
     
     
c discrete receptors
 305  write(*,400)
      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,1)
      if (lblank .or. lbad) then
        write(*,999)
        goto 305
      endif
      discflag=trim(adjustl(response))
      call upcase(discflag)
 310  if (discflag .eq. 'Y') then
        ldiscrete=.true.
        write(*,401)
        read(*,*)discfile
        call getdiscrete(1)
        if (nodisfil) then
          write(*,402)trim(adjustl(discfile))
          goto 310
        else
          if (fixdisc) then
            if (ndisc .gt. maxdisc) then
              write(*,403)ndisc
              write(ilog,403)ndisc
            endif
            if (negdisc) then
              write(*,404)
              write(ilog,404)
            endif
            if (baddisc) then
              write(*,405)
              write(ilog,405)
            endif
            goto 310
c            lstop=.true.
          endif
        endif
      else if (discflag .eq. 'N') then
        ldiscrete=.false.
        if (discfile .eq. '')discfile='NA'
        ndisc=0
      else
        ldiscrete=.false.
        write(*,999)
        goto 305
      endif
 
      if (iskip .eq. 2 .and. .not. lall) goto 45
 
 
 
 400  format(/1x,'Include up to 10 discrete receptors (y/n)? '\)
 401  format(/1x,'Enter name of file with discrete receptors.',
     + /1x,'Enclose filename with quotes if path or filename ',
     + 'includes spaces... '/)
 402  format(/1x,'Discrete receptor file ',a,' does not exist')
 403  format(/1x,'The number of discrete receptors ',i5,
     + /1x,'exceeds the maximum of 10')
 404  format(/1x,'One or more discrete receptors are negative')
 405  format(/1x,'Bad distance units in discrete receptor file')
      
c --- Prompt for flagpole heights (optional) ---

  105 write(*,1018)
1018  format(//' Use Flagpole receptors? (y or n): '\)
      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,1)
      if (lblank .or. lbad) then
        goto 105
      endif
      flgswitch=trim(adjustl(response))
      call upcase(flgswitch)
 110  if (flgswitch .eq. 'Y') then
        lflagpole=.true.
        if (lmetric) then
          units1='(meters)'
        else
          units1='(feet)'
        endif
        write(*,1019)trim(adjustl(units1))
        read(*,'(a)')response
        call checkanswer(response,lblank,lbad,2)
        if (lblank .or. lbad) then  !invalid response
          write(*,999)
          goto 110
        endif
        read(response,'(f8.0)')flagpole
        if (.not. lmetric) flagpole = flagpole * 0.3048
        if (flagpole .lt. 0) then  !negative height
          write(*,999)
          goto 110
        endif
        if (iopt .gt. 0 .and. .not. lall) goto 45
      else if (flgswitch .eq. 'N') then
        if (iskip .ne. 2) flagpole=0.0
        lflagpole=.false.
        if (iskip .eq. 2) then
          if ((larea .and. iopt .eq. 3) .or. (.not. larea .and. iopt 
     +    .eq. 4))write(*,997)
          if (iopt .gt. 0 .and. .not. lall) goto 45
        endif
      else
        write(*,999)
        goto 105
      endif
 1019 format(///' Enter Flagpole receptor height ',a)!/
 997  format(/1x,'Flagpole option off, cannot change flagpole height'/)

c prompt user for stack elevation to be used for PROFBASE and base elevation or
c allow user to let AERMAP determine elevations when using terrain
c for flat terrain, default is 0 m or 0 ft
 60   if(lmetric) then
        units1='(m)'
      else
        units1='(ft)'
      endif
      if (lterrain) then
           write(*,1002)trim(adjustl(units1))
      else
           write(*,1003)trim(adjustl(units1))
      endif
      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,2)
      if (lblank) then
         if (lterrain) then 
             laermsrc=.true.
             aermap='Y'
         else
             laermsrc=.false.
             profbase=0.0
             aermap='N'
         endif
      else
         if (lbad) goto 60
         read(response,'(f8.0)')profbase
         if (.not. lmetric) profbase=profbase*0.3048
         aermap='N'
         laermsrc=.false.
      endif
      if ((.not. larea .and. iopt .eq. 5) .or. 
     +    (larea .and. iopt .eq. 1)) then 
           base=profbase
          goto 45
      endif
      base=profbase
 1002 format(///'Enter source elevation ',a,' or'/
     +  ' <Enter>  for AERMAP derived elevation: '\) 
 1003 format(///'Enter source elevation ',a,' or'/
     +  ' <Enter>  for default 0 m: '\) 
c      if (.not. lall .and. iopt .ne. 0) goto 45
c --- Prompt for lat/lons or UTM coordinates
 65   if (lterrain) then
        write(*,1004)
      else
        write(*,1005)
        if (iskip .eq. 2 .and. .not. lall) goto 45
        if (iopt .eq. 0 .or. (iskip .eq. 2 .and. lall)) return
      endif
      read(*,'(a)')response
      acoord=trim(adjustl(response))
      do i=1,6
        call upcase(acoord(i:i))
      enddo
!      if (acoord .ne. 'LATLON' .and. acoord .ne. 'UTM') then
!        write(*,999)
!        goto 65
!      endif
 
 1004 format(//' Enter coordinate type: '/
     +' LATLON for latitude & longitude or'/
     +' UTM for UTM coordinates')

 1005 format('Bypassing source coordinates')
c -- prompt for lat/lon data
      
!      read(acoord(1:1),'(a1)')acoord1
!      call upcase(acoord1)
 
      if (acoord .eq. 'LATLON') then
        llat=.true.
 88     write(*,1006)
        read(*,'(a)')response
        call checkanswer(response,lblank,lbad,2)
        if (lblank .or. lbad) then
          write(*,999)
          goto 88
        endif
        read(response,*)lat
        if (abs(lat).gt. 90.0) then
          write(*,999)
          goto 88
        endif
 89     write(*,1007)
        read(*,'(a)')response
        call checkanswer(response,lblank,lbad,2)
        if (lblank .or. lbad) then
          write(*,999)
          goto 89
        endif
        read(response,*)long  
        if (abs(long) .gt. 180.0) then
          write(*,999)
          goto 89
        endif
      elseif (acoord .eq. 'UTM') then
c --- Prompt for UTM data ---
        llat=.false.
90      write(*,1008)
        read(*,'(a)')response
        call checkanswer(response,lblank,lbad,2)
        if (lblank .or. lbad) then
          write(*,999)
          goto 90
        endif
        read(response,*)utmx
 91     write(*,1009)
        read(*,'(a)')response
        call checkanswer(response,lblank,lbad,2)
        if (lblank .or. lbad) then
          write(*,999)
          goto 91
        endif
        read(response,*)utmy  
!      elseif (acoord1 .eq. ' ') then
!        write(*,*)'Bypassing source coordinates'
!        utmx=0.0
!        utmy=0.0
!        izone=0
!        nada=0
!        llat=.false.
!        return
      else
        write(*,999)
        goto 65
      endif
      
 1006 format(//' Enter Source Latitude (North positive) (xx.xxxx): '\)
 1007 format(//' Enter Source Longitude (West negative) (xx.xxxx): '\)
 1008 format(//' Enter Source UTM Easting (xxxxxx.x): '\)
 1009 format(//' Enter Source UTM Northing (xxxxxxx.x): '\)
 
 70   if (llat) then
        izone=0
      else
        if (iskip .eq. 2 .and. .not. lterrain) then
          goto 45
        else
          write(*,1010)
          read(*,'(a)')response
          call checkanswer(response,lblank,lbad,2)
          if (lblank .or. lbad .or. index(response,'.') .gt. 0) then
            write(*,999)
            goto 70
          endif
          read(response,*)izone
          if (izone .le. 0) then
            write(*,999)
            goto 70
          endif
          if (badzone) badzone=.false.
          if (badnad) then
            write(*,3001)
            goto 75
          endif
        endif
      endif
1010  format(/' Enter Source UTM Zone (xx): '\)
75    if (iskip .eq. 2 .and. .not. lterrain) then
        goto 45
      else
        write(*,1011)
        read(*,'(a)')response
        call checkanswer(response,lblank,lbad,2)
        if (lblank .or. lbad .or. index(response,'.') .gt. 0) then
          nada=0
        else
          read(response,'(i2)')nada
          if (badnad) badnad=.false.
        endif
      endif
1011  format(//'----------------------------------------------'/
     + ' Option (1) - North American Datum of 1927'/
     + ' Option (4) - North American Datum of 1983'/
     + '----------------------------------------------'//
     + ' Enter Option for Applicable UTM Nada: '\)
     


c new logic dated 10/09/09
c is and lnad83 assignments now take place in subroutine calccoords  
c check that nada is 1 or 4
 95   if (nada .ne. 1 .and. nada .ne. 4) then
        write(*,999)
        goto 75
      endif
c new logic dated 10/09/09
c calculate coordinates
      if (lterrain) call calccoords(lat,long,2)

      if(iopt .ne. 0 .and. .not. lall) then
        goto 45
      else 
        return
      endif

   10 continue
  999 format(1x,'Invalid response')
      return
      end
c -----------------------------------------------------------------------------
      subroutine checkline(astr,nfield,dattype,lbad1)
c     this subroutine reads the line of data from AERSCREEN.INP and checks
c     the variables to ensure they are correctly formatted
c     the routine checks that fields that are supposed to be numeric are indeed
c     numeric by calling checkanswer
c     routine will also detect if not all variables are on the line

      use main1
      implicit none
c astr:     input character string read from subroutine readinp
c           this is the data line from AERSCREEN.INP
c nfield:   number of fields to be read from astr
c dattype:  input data type, this is equal to temp variable read subroutine readinp
c fields:   allocatable array of fields read from AERSCREEN.INP
c           number of fields determined by nfield
c str:      character strings read from astr, separated by blanks
c           this becomes values for fields array
c ftype:    allocatable array to denote which fields are character
c           or numeric.  array size determined by nfield
c l1:       logical variable denoting non-blank character found
c lbad:     logical variable denoting if field(j) is invalid (lbad=true)
c lblank:   logical variable denoting if field(j) is blank
c           if lblank is true then lbad is true
c lbad1:    logical variable denoting that one or more fields are invalid
c ifield:   field loop counter
c i:        location identifier within character string
c i1:       code corresponding to a character's number in ASCII table
c j:        field loop counter
c ii:       character counter
c k:        character counter
      character astr*250,dattype*12,fields*15,str*15,ftype*1
     
      logical l1,lbad,lblank,lbad1
      integer ifield,i,i1,nfield,j,ii,k

      allocatable :: fields(:)
      allocatable :: ftype(:)
      allocate(fields(nfield))
      allocate(ftype(nfield))
      ifield=0
      l1=.false.

      lbad1=.false.
      badform=.false.

c     version 15181, set all of ftype to 'N'
      ftype='N'
c     define which variables are character and numeric
      if (dattype .eq. '** BUILDING ' .or. dattype.eq. '** TERRAIN D' 
     + .or. dattype .eq. '** MAKEMET D') then
          ftype(1)='C'
          ftype(nfield)='C'
c        do ifield=1,nfield
c          if (ifield .eq. 1 .or. ifield .eq. nfield) then
c            ftype(ifield)='C'
c          else
c            ftype(ifield)='N'
c          endif
c        enddo
      endif
c      elseif (dattype .eq. '** UNITS/POP') then
      if (dattype .eq. '** UNITS/POP') then
          ftype(1)='C'
          ftype(2)='C'
          ftype(5)='C'
C        do ifield=1,nfield
C          if (ifield .le. 2 .or. ifield .eq. 5) then
C            ftype(ifield)='C'
C          else
C            ftype(ifield)='N'
C          endif
C        enddo
      endif
c      elseif (dattype .eq. '** FUMIGATIO') then
      if (dattype .eq. '** FUMIGATIO') then
          do ifield=1,2
              ftype(ifield)='C'
          enddo
          ftype(5)='C'
      endif
      if (dattype .eq. '** DEBUG OPT') ftype='C'
c      else
c        do ifield=1,nfield
c          ftype(ifield)='N'
c        enddo
c      endif
c     break up character string into fields, specific to line being read
      do ii=1,15
        str(ii:ii)=' '
      enddo
      k=0
      ifield=1
      
c      do i=3,250
      i=3
      do while(ifield .le. nfield .and. i .le. 250)
        i1=ichar(astr(i:i))
        if (i1 .ne. 32) then
          l1=.true.
          k=k+1
          str(k:k)=astr(i:i)
        else
          if (l1) then
            fields(ifield)=str
            ifield=ifield+1
            l1=.false.
            k=0
            do ii=1,15
              str(ii:ii)=' '
            enddo
          endif
        endif
       i=i+1

      enddo
c       check numeric fields to make sure they are valid
c     use subroutine checkanswer
      do j=1,nfield
        str=fields(j)
        lbad=.false.
        if (ftype(j) .eq. 'N') then
          call checkanswer(str,lblank,lbad,2)

          if (lblank) lbad=.true.
          if (lbad) then
            lbad1=.true.
            badform(j)=.true.
          endif
        endif
      enddo


      deallocate(fields)
      deallocate(ftype)
c
999    return
      end
c -----------------------------------------------------------------------------
      subroutine getdiscrete(iflag)
c     this subroutine reads the discrete receptor line and
c     determines how many discrete receptors to process
      use main1
      implicit none
      
      
c eof:        end of file indicator
c idisc:      loop counter
c iflag:      flag denoting whether to QA file or get receptors
c i:          loop counter
c n:          index of 'units:' in unitline
c d1:         discrete receptor distance
c conv:       conversion between input units and meters
c unitline:   line containing distance units
c             if not found, then assume units are in meters
c dunits:     temporary units variable
c str:        character string to check for numeric value
c lexist:     logical variable denoting if discfile exists
      integer eof,idisc,iflag,i,n
      real d1,conv
      character unitline*250,dunits*11,str*15
      logical lexist
      
      eof=0
      
      if (iflag .eq. 1) then
        ndisc=0
        nodisfil=.false.
        negdisc=.false.
        fixdisc=.false.
        inquire(file=discfile,exist=lexist)
        if (.not. lexist) then
          fixdisc=.true.
          nodisfil=.true.
          goto 100
        endif
        open(unit=discin,file=discfile,status='old')
c       get units
        read(discin,3,iostat=eof)unitline
  3     format(a250)
  5     if (eof .eq. 0) then
          do i=1,250
            call upcase(unitline(i:i))
          enddo
          if (index(unitline,'UNITS:') .ne. 0) then
            n=index(unitline,'UNITS:')
c           read(unitline(n+6:250),*)discunit
            discunit=trim(adjustl(unitline(n+6:250)))
            if (discunit .ne. 'FEET' .and. discunit .ne. 'FT' .and.
     +      discunit .ne. 'METERS' .and. discunit .ne. 'KILO-METERS' 
     +      .and. discunit .ne. 'KILOMETERS' .and. discunit .ne. 
     +      'KM' .and. discunit .ne. 'MILES' .and. discunit .ne. '') 
     +      then
              fixdisc=.true.
              baddisc=.true.
            endif
            if (discunit .eq. '') discunit='METERS'
            if (discunit .eq. 'FT') discunit='FEET'
            if (discunit .eq. 'KM' .or. discunit .eq. 'KILOMETERS') 
     +      discunit='KILOMETERS'
          else
            fixdisc=.true.
            baddisc=.true.
          endif
        endif
        if (fixdisc) goto 100
        read(discin,*,iostat=eof)d1
  10    if (eof .eq. 0) then
          ndisc=ndisc+1
          if (d1 .le. 0.0) then
            fixdisc=.true.
            negdisc=.true.
          endif
          read(discin,*,iostat=eof)d1
          goto 10
        endif
        if (fixdisc)goto 100
        if (ndisc .gt. maxdisc) then
          fixdisc=.true.
          goto 100
        endif
      else
        open(unit=discin,file=discfile,status='old')
        idisc=0
c       see if any receptors are less than xnear or greater
c       than the probe distance
c       if so, reset ndisc
        
        if (discunit .eq. 'FEET') then
          conv=0.3048
        elseif (discunit .eq. 'MILES') then
          conv=1609.34
        elseif (discunit .eq. 'KILOMETERS') then
          conv=1000.0
        else
          conv=1.0
        endif
        read(discin,*,iostat=eof)dunits
        read(discin,*,iostat=eof)d1
 15     if (eof .eq. 0) then
          d1=d1*conv
          if (d1 .le. xnear .or. d1 .ge. probedist)ndisc=ndisc-1
          read(discin,*,iostat=eof)d1
          goto 15
        endif
        rewind(discin)
     
        allocate(discrete(ndisc))

        read(discin,*,iostat=eof)dunits
        read(discin,*,iostat=eof)d1
 20     if (eof .eq. 0) then
          d1=d1*conv
          if (d1 .gt. xnear .and. d1 .lt. probedist) then
            idisc=idisc+1
            discrete(idisc)=d1
          endif
          read(discin,*,iostat=eof)d1
          goto 20
        endif
      endif
 100  close(discin)
      return
      end
c -----------------------------------------------------------------------------
      subroutine checkprobe
c     Version 11/29/2010
c     this subroutine checks the probe distance and if it is not a multiple of 25 m
c     then the probe distance is reset to the next multiple of 25 m.
c     example:  probe distance is initially 5035 m, the probe distance will be
c     reset to 5050 m.  This is to ensure even receptor spacing outside of 5 km
c     i.e., spacing should be whole numbers or multiples of 0.25
      use main1
      implicit none
c b1:   value of mod(probedist,25.0)
c b2:   probe distance/25 m
c b3:   real value of the integer of b2
      real b1,b2,b3
      changeprobe=.false.
      probedist1=probedist
      b1=mod(probedist,25.0)
      if (b1 .ne. 0) then
        b2=probedist/25.0   !recalculate # of receptors based on 25 m
        b3=real(int(b2))    !integer value of b2
        probedist=(b3+1.0)*25.0 !reset probe distance to next multiple of 25 past probe distance
        changeprobe=.true.
      endif
      return
      end
c -----------------------------------------------------------------------------
      subroutine calccoords(lat,long,iflag)
c     Version dated 10/09/2009 -JAT
c     subroutine to calculate source coordinates for terrain processing
c     called from readinp and getdems
c     originally code was in both subroutines
c     created separate subroutine in case changes have to be made
c     Using a separate routine allows changes in one place instead
c     of changing code in two separate subroutines
      use main1
      implicit none
      
c icode:    integer code to determine whether to convert from lat/lon to UTM or
c           vice-versa
c izone1:   UTM zone calculated when converting from UTM to lat/lon
c nadlen:   length of NADGRIDS directory
c iflag:    flag indicating to check for existence of demlist.txt
c izdum:    argument to UTMGEO
c is:       code corresponding to NAD datum choice
c key:      argument to UTMGEO
c dlos:     argument to NADCON
c dlas:     argument to NADCON
c dlom:     argument to NADCON
c dlam:     argument to NADCON
c lat:      latitude
c long:     longitude
c xarg:     UTM x-coordinate
c yarg:     UTM y-coordinate
c arge:     longitude
c argn:     latitude
c xpt27:    NAD 27 longitude
c ypt27:    NAD 27 latitude
c xpt83:    NAD 83 longitude
c ypt83:    NAD 83 latitude
c nodata:   logical argument to NGRIDS
c dexist:   logical variable denoting that demlist.txt exists
      integer icode,izone1,nadlen,iflag,izdum,is,key
      double precision dlos,dlas,dlom,dlam
      real lat,long
      double precision xarg, yarg, arge, argn,xpt27,ypt27,xpt83,ypt83
      logical nodata,dexist


      
c initialize variables needed for NAD conversions      
      dlos=0.0D0
      dlas=0.0D0
      dlom=0.0D0
      dlam=0.0D0
      if (iflag .eq. 2) then
        write(*,*)' Checking for the existence of demlist.txt'
      endif
c check that demlist.txt exists, if not return
      inquire(file='DEMlist.txt',exist=dexist)
      if (dexist) then
        fixdem=.false.
      else
        fixdem=.true.
        if (iflag .eq. 2) lstop=.true.
        return
      endif
        
      if (llat) then  !lat/lon coordinates
        icode=555
        argn=lat*3600.0
        arge=long*3600.0
      else            !UTM coordinates
        icode=333
        xarg=dble(utmx)
        yarg=dble(utmy)
      endif
      
      if (nada .eq. 1) then
        is=0
        lnad83=.true.
      else
        is=4
        lnad83=.false.
      endif
      
c convert from lat/lon to UTM (icode=555) or UTM to lat/lon (icode=333)
c lat/lon to UTM should only be if calccoords is called from getDEMs      
      call utmgeo(icode,izone,izdum,xarg,yarg,arge,argn,is) 

c assign values to latitude and longitude (still in original NAD datum)
      xlat=real(argn)/3600.
      xlong=real(arge)/3600.  

c assign NAD27 coordinates if original NAD datum is NAD 27 
      if (lnad83) then
          xutm27=real(xarg)
          yutm27=real(yarg)
          lat27=xlat
          long27=xlong
      endif    
c if converting from UTM to lat/lon go back to UTM to check for zone change
      if (.not. llat) then
        call utmgeo(555,0,izone1,xarg,yarg,arge,argn,is)
        if (izone1 .ne. izone) then  !reset coordinates and UTM zone
            xlat=real(argn)/3600.
            xlong=real(arge)/3600.
            utmx=xarg
            utmy=yarg
            izone=izone1
        endif
        if (lnad83) then  !assign NAD27 coordinate in case there was a change
            lat27=real(argn)/3600.
            long27=real(arge)/3600.
            xutm27=utmx
            yutm27=utmy  
        endif
      endif

c get NADGRID directory information
c if calccoords is called from readinp and there are no files in the
c NADGRIDS directory, assign logical value to fixnnaddir and
c AERSCREEN will stop and warn user as part of the check data subroutine
c that is called from readinp when using AERSCREEN.INP data 
cif calccoords is called from getdem and there are no files in the
c NADGRIDS directory, assign logical value to lstop and
c AERSCREEN will stop and warn user     
      if (iflag .eq. 1) then
        call getnadgrid(fixnaddir)
        if (fixnaddir) return
      else
        call getnadgrid(lstop)
        if (lstop) return
      endif

c set the nadpath
c this will always be non-blank

      if (lnadgrid) then
        nadlen=len_trim(nadpath)
      else
        nadlen=0
        nadpath=''
      endif
      
      if (nada .eq. 1) then    !NAD 27
        key=1
        if (.not. lngrid) then
          call ngrids(nodata,.true.,nadlen,nadpath)
          lngrid=.true.  
        endif
c       calculate x (longitude) and y (latitude) coordinates for NAD 27
        ypt27=argn/3600.D0
        xpt27=arge/3600.D0
c       calculate NAD83 lat/lon from NAD27 lat/lon
        call nadcon(xpt27,ypt27,xpt83,ypt83,dlos,dlas,dlom,dlam,key)
        argn=ypt83*3600.D0
        arge=xpt83*3600.D0
        xlat=real(argn)/3600.
        xlong=real(arge)/3600.
c       calculate NAD83 UTM from NAD83 lat/lon
c       and reassign nada variable to 4
        call utmgeo(555,izone,izdum,xarg,yarg,arge,argn,4)
        utmx=xarg  !new UTM x-coordinate
        utmy=yarg  !new UTM y-coordinate
        nada=4
      endif 
c      write(*,*)utmx,utmy,nada
c      pause
      if (llat) then
        utmx=xarg
        utmy=yarg
        izone=izdum
      endif
      lcalc=.true.
      return
      end
c -----------------------------------------------------------------------------
      subroutine metdata(iskip)

c --- Prompt user for meteorology data parameters ---
      use main1
      implicit none

c response:   response to prompts
c answer:     1-character substring to response
c response2:  response to prompt for AERSURFACE filename (added 15181)
c ustr:       text string to adjust or not adjust u*
c units1:     input units of temperature
c i:          landuse or climate loop counter
c iskip:      variable indicating how metdata should proceed
c             if iskip=0 then answer all prompts
c             if iskip=2 then list options of parameters to change
c imin:       minimum default temperature
c imax:       maximum default temperature
c ians:       integer answer to choice of surface characteristics input
c lswitch1:   logical variable denoting that min temperature > max temperature
c             and user should re-enter data
c lexist:     logical variable denoting if external surface characteristics
c             file exists
c lreturn:    logical variable denoting to exit subroutine based on option choice
c lbad:       logical variable denoting if response is invalid
c lblank:     logical variable denoting if response is blank
      character response*15,answer*1,units1*3,response2*250,ustr*25
      integer i,iskip,iopt,imin,imax,ians,inquote1,inquote2
      logical lswitch1,lexist,lreturn,lbad,lblank
      
  
      lswitch1=.false.
      lreturn=.false.
      
      call header()
      if (lmetric) then
        units1='(K)'
        imin=250
        imax=310
      else
        units1='(F)'
        imin=-10
        imax=100
      endif
      
      write(*,995)
  995 format(/'         -------------------  MAKEMET ',
     +  'METEOROLOGY  ------------------')
    
      iopt=0
  30  if (iskip .eq. 2)then
c     version 16216, add text string for u*
          if (adjustar) then
              ustr='Do not adjust u*'
          else
              ustr='Adjust u*'
          endif
        write(*,1)trim(adjustl(ustr))
        read(*,'(a)')response
        call checkanswer(response,lblank,lbad,2)
        if (lblank) then
           lreturn=.true.
           goto 120
        else
          if (lbad .or. index(response,'.') .gt. 0) then 
            write(*,999)
            goto 30
          endif
          read(response,*)iopt
          if (iopt .ge. 1 .and. iopt .le. 3) then ! change temperatures
             goto 100
          else if (iopt .eq. 4) then !change wind speed
             goto 105
          else if (iopt .eq. 5) then !change anemometer height
             goto 110
          else if (iopt .eq. 6) then  !change surface characteristics input type
             goto 5
          else if (iopt .eq. 13) then !version 16251, ustar adjustment
             goto 135 
          else if (iopt .eq. 14) then !change all parameters, changed to option 14 16216
             goto 100
          else if (iopt .ge. 7 .and. iopt .le. 12) then  !change surface characteristics 
             if (iopt .ge. 7 .and. iopt .le. 9)then   !change user specified characteristics
               if( isurf .eq. 0) then  
                 goto 115
               else
                 write(*,2)iopt,trim(adjustl(sctype))  !if user-specified SC not specified, warn user
                 goto 30
               endif
             endif
             if (iopt .eq. 10 .or. iopt .eq. 11) then  !AERMET tables' values
              if (isurf .ge. 1 .and. isurf .le. 8) then
                 goto 115
               else
                 write(*,3)iopt,trim(adjustl(sctype))   ! AERMET tables not chosen, warn user
                 goto 30
               endif
             endif
             if (iopt .eq. 12) then   !AERSURFACE output
               if (isurf .eq. 9) then
                 goto 115
               else
                 write(*,4)iopt,trim(adjustl(sctype))  !AERSURFACE not chosen, warn user
                 goto 30
               endif
             endif
          else
            write(*,999)
            goto 30
          endif
        endif
      endif  
  1   format(/'-----------------------------------------------------'/
     +  'Enter number of parameter to change or'/
     +  '<Enter> to return to validation page'/
     +  '----------------------------------------------------'/
     +  ' 1) Use default min and max temperatures'/' 2) Minimum ',
     +  'temperature'/' 3) Maximum temperature'/' 4) Minimum wind speed'
     +  /' 5) Anemometer height'/' 6) Input surface characteristics'/
     +  ' 7) User albedo'/' 8) User Bowen ratio'/' 9) User surface ',
     +  'roughness length'/' 10) landuse'/' 11) Moisture'/
     +  ' 12) AERSURFACE output/AERMET input file'/
     +  ' 13) ',a/
     +  ' 14) Update all parameters'/
     +  '----------------------------------------------------'/)
     
 2    format(/'Option ',i1,' is an invalid option'/'Surface ',
     +  'characteristics are based on ',a,' inputs'/'User ',
     +  'specified characteristics cannot be changed'/'Choose option 6',
     +  ' first if user specified characteristics are desired')
     
 3    format(/'Option ',i2,' is an invalid option'/'Surface ',
     +  'characteristics are based on 'a,' inputs'/'Landuse',
     +  ' or moisture cannot be changed'/'Choose option 6',
     +  ' first if AERMET derived characteristics are desired')
     
 4    format(/'Option ',i2,' is an invalid option'/'Surface ',
     +  'characteristics are based on 'a,' inputs'/'Surface',
     +  ' characteristics file cannot be specified'/'Choose option 6',
     +' first if externally listed surface characteristics are desired')
c
c
c --- Allow user to set minimum & maximum ambient temperatures -----
c --- Defaults to 250K <> 310K if no data is provided ---

100   if (iopt .eq. 1) then   !default values
!         write(*,1000)imin,imax,trim(adjustl(units1(2:2)))
!         read(*,'(a)')response
!         call checkanswer(response,lblank,lbad,2)
!         if (lblank) then
!          if (lmetric) then
!           ambtmin = 250.0
!           ambtmax = 310.0
!           warnmint=.false.
!           warnmaxt=.false.
!          else
!           if (lbad) then 
!              write(*,999)
!              goto 100
!           endif
!           ambtmin = ((-10.0-32)*5.0/9.0)+273.15
!           ambtmax = ((100.0-32)*5.0/9.0)+273.15
!          endif
!         endif
         ambtmin = 250.0
         ambtmax = 310.0
         warnmint=.false.
         warnmaxt=.false.
         if (lswitch1) goto 120  !check temperatures to make sure min temp < max temp if already found to be error
         if (ambtmin .lt. 183.0 .or. ambtmin .gt. 331) then
          write(*,3006)
          warnmint=.true.
         else
          warnmint=.false.
         endif
         if (ambtmax .lt. 183.0 .or. ambtmax .gt. 331) then
          write(*,3007)
          warnmaxt=.true.
         else
          warnmaxt=.false.
         endif
         goto 30  !back to options
      endif
      if (iopt .eq. 2 ) then   !change minimum temperature
         write(*,1001)trim(adjustl(units1))
         read(*,'(a)')response
         call checkanswer(response,lblank,lbad,2)
         if (lbad) then
          write(*,999)
          goto 100
         endif
         read(response,'(f8.0)')ambtmin
         if (.not. lmetric) ambtmin = ((ambtmin-32)*5.0/9.0)+273.15
         if (lswitch1) goto 120  !check temperatures to make sure min temp < max temp if already found to be in error
         if (lmetric .and. ambtmin .lt. 0) then
          write(*,999)
          goto 100
         endif
         if (ambtmin .lt. 183.0 .or. ambtmin .gt. 331) then
          write(*,3006)
          warnmint=.true.
         else
          warnmint=.false.
         endif
         goto 30  !back to options
      endif
      if (iopt .eq. 3) then   !change maximum temperature
         write(*,1002)trim(adjustl(units1))
         read(*,'(a)')response
         call checkanswer(response,lblank,lbad,2)
         if (lbad) then
           write(*,999)
           goto 100
         endif
         read(response,'(f8.0)')ambtmax
         if (.not. lmetric) ambtmax = ((ambtmax-32)*5.0/9.0)+273.15
         if (lswitch1) goto 120  !check temperatures to make sure min temp < max temp if already found to be in error
         if (lmetric .and. ambtmax .lt. 0) then
          write(*,999)
          goto 100
         endif
         if (ambtmax .lt. 183.0 .or. ambtmax .gt. 331) then
          write(*,3007)
          warnmaxt=.true.
         else
          warnmaxt=.false.
         endif
         goto 30  !back to options
      endif

c     prompt for temperatures outside of options 1, 2, or 3
101   write(*,1003)imin,imax,trim(adjustl(units1(2:2))),
     +  trim(adjustl(units1))

      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,2)
      if (lblank) then
        if (lmetric) then
          ambtmin = 250.0
          ambtmax = 310.0
        else
          ambtmin = ((-10.0-32)*5.0/9.0)+273.15
          ambtmax = ((100.0-32)*5.0/9.0)+273.15
        endif
        warnmint=.false.
        warnmaxt=.false.
        if (iskip .eq. 2 .and. iopt .ne. 14) goto 30  !back to options, changed 13 to 14 version 15256
      else
         if (lbad) then
            write(*,999)
            goto 100
         endif
        read(response,'(f8.0)')ambtmin
        if (lmetric .and. ambtmin .lt. 0) then
          write(*,*)' Invalid temperature'
          write(*,*)' Re-enter minimum temperature'
          goto 101
        endif
 555    write(*,1002)trim(adjustl(units1))
        read(*,'(a)')response
        call checkanswer(response,lblank,lbad,2)
        if (lblank .or. lbad) then
          write(*,999)
          goto 555
        endif
        read(response,'(f8.0)')ambtmax
        if (lmetric .and. ambtmax .lt. 0) then
          write(*,*)' Invalid temperature'
          write(*,*)' Re-enter maximum temperature'
          goto 555
        endif
        if (.not. lmetric) then
          ambtmin = ((ambtmin-32)*5.0/9.0)+273.15
          ambtmax = ((ambtmax-32)*5.0/9.0)+273.15
        endif
        if (ambtmin .lt. 183.0 .or. ambtmin .gt. 331) then
          write(*,3006)
          warnmint=.true.
         else
          warnmint=.false.
         endif
         if (ambtmax .lt. 183.0 .or. ambtmax .gt. 331) then
          write(*,3007)
          warnmaxt=.true.
         else
          warnmaxt=.false.
         endif
      endif
c check to make sure ambient minimum temperature is less than maximum ambient temperature
  120 if (ambtmin .ge. ambtmax) then
        write(*,2002)
          lswitch1=.true.    
         goto 101
      else
        if (iskip .eq. 2) then
          if (.not. lreturn) then
             if (iopt .ne. 14) goto 30 !back to options, changed option 13 to 14, version 16216
          else 
            return
          endif
        endif
      endif      

 1000 format(//'<Enter> to default to ',i3,1x,i3,1x,a2,'... ')
 1001 format(//' Enter Minimum Temperature ',a,': '\)
 1002 format(//' Enter Maximum Temperature ',a,': '\)
 1003 format(//' Enter Min & Max Ambient Temperatures (K)'/
     +      'or <Enter> to default to ',i3,1x,i3,1x,a,'... '//
     +      ' Enter Minimum Temperature ',a,': '\)

c --- Allow user to set minimum MAKEMET wind speed -----
c --- Defaults to 0.5 m/s if no data is provided ---


 105  write(*,1004)
      read(*,'(a)')response
 1004 format(//' Enter Minimum Wind Speed or <Enter> to default to ',
     + '0.5 m/s... '\)
     
      call checkanswer(response,lblank,lbad,2)
      if (lblank) then
       wsmin = 0.5
      else
       if (lbad) then
          write(*,999)
          goto 105
       endif
       read(response,'(f8.0)')wsmin
       if (wsmin .le. 0) then
         write(*,999)
         goto 105
       endif
      endif
      if (iskip .eq. 2 .and. iopt .ne. 14) goto 30  !back to options, changed iopt to 14 version 15256


c --- Allow user to set MAKEMET default anememeter height to 10.0 meters -----
c --- Defaults to 10 meter if no data is provided ---


110   write(*,1005)
1005  format(//' Enter Anemometer Height or <Enter> to default to ',
     +  '10.0 meters... '\)
      read(*,'(a)')response

      call checkanswer(response,lblank,lbad,2)
      if (lblank) then
       anemht = 10.0
      else
       if (lbad) then
         write(*,999)
         goto 110
       endif
       read(response,'(f8.0)')anemht
       if (anemht .lt. 0) then
        write(*,999)
        goto 110
       endif 
      endif
      if (iskip .eq. 2 .and. iopt .ne. 14) goto 30  !back to options, changed option 13 to 14 version 16216


c  --- Determine if surface parameters will be user specific ,generic (AERMET tables) or AERSURFACE ---
c --- version 10264, add checks on reasonability of surface characteristics 
c --- if user has previously entered data, and changing surface characterstics, user
c --- now has option of retaining those SC without re-entering them
5     write(*,1006)
      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,2)
      if (lblank .or. lbad .or. index(response,'.') .gt. 0) then
        write(*,999)
        goto 5
      endif
      read(response,'(i4)')ians
      call upcase(answer)
      
1006  format(//1x,'--------------------------------'/
     + 1x,'1) Single user specified values'/1x
     + '2) AERMET seasonal tables'/1x
     + '3) External file'/1x
     + '--------------------------------'/1x,'
     + Enter surface characteristics option: '\)
     
      if (ians .eq. 1) then
       isurf = 0
       iclim = 0 
       sctype='user defined'
      else if (ians .eq. 2) then
       isurf=1
       sctype='AERMET'
      else if (ians .eq. 3) then
       isurf = 9
       sctype='AERSURFACE'
       else
        write(*,999)
        goto 5
      endif

c --- Prompt for user defined Roughness, Bowen, and Albedo

115    if(isurf .eq. 0)then
        if (iopt .eq. 7) goto 201
        if (iopt .eq. 8) goto 202
        if (iopt .eq. 9) goto 203
201     write(*,1007)
        read(*,'(a)')response
        call checkanswer(response,lblank,lbad,2)
        if (lblank .or. lbad) then
          write(*,999)
          goto 201
        endif
        read(response,*)useralbe
        if (useralbe .lt. 0.0 .or. useralbe .gt. 1.0) then
          write(*,2005)
          goto 201
        endif
        if (iskip .eq. 2 .and. iopt .eq. 7) goto 30
        
 202    write(*,1008)
        read(*,'(a)')response
        call checkanswer(response,lblank,lbad,2)
        if (lblank .or. lbad) then
          write(*,999)
          goto 202
        endif
        read(response,*)userbown
 205    if (userbown .lt. -10.0 .or. userbown .gt. 10.0) then
          warnbow=.true.
           write(*,2006)
        else
         warnbow=.false.
        endif  
        if (iskip .eq. 2 .and. iopt .eq. 8) goto 30
        
 203    write(*,1009)
        read(*,'(a)')response
        call checkanswer(response,lblank,lbad,2)
        if (lblank .or. lbad) then
          write(*,999)
          goto 203
        endif
        read(response,*)userlen
        
c ---  Apply minimum roughness length of 0.001m
       if (userlen .lt. 0) then
        write(*,2007)
        goto 203
       endif
       if (userlen .lt. 0.001) then
        userlen = MAX( userlen, 0.001 )
        warnzo=.true.
        write(*,2008)
       else
 206    if (userlen .ge. 2.0) then
          warnzo1=.true.
          write(*,2009)
        else
          warnzo=.false.
          warnzo1=.false.
        endif
       endif
        if (iopt .eq. 6 .or. iopt .eq. 9) goto 30 !back to options
c --- Prompt for generic Surface Profile by Climate---
      else if (isurf .gt. 0 .and. isurf .le. 8) then
        if (iopt .eq. 11) goto 40
        do i=1,8
          if (i .eq. 1) then
            write(*,2000)i,landuse(i)
          else
            write(*,2001)i,landuse(i)
          endif
        end do
   10   write(*,1010)
        read(*,'(a)')response
        call checkanswer(response,lblank,lbad,2)
        if (lblank .or. lbad .or. index(response,'.') .gt. 0) then
          write(*,999)
          goto 10
        endif
        read(response,*)isurf
        if(isurf .lt. 1 .or. isurf .gt. 8) then
           write(*,999)
           goto 10
        endif
        if (iopt .eq. 10) goto 30  !back to options
        
c --- Prompt for generic moisture profile ---
  40    do i=1,3
          if (i .eq. 1) then
            write(*,2000)i,climate(i)
          else
            write(*,2001)i,climate(i)
          endif
        end do   
   20   write(*,1011)
        read(*,'(a)')response
        call checkanswer(response,lblank,lbad,2)
        if (lblank .or. lbad .or. index(response,'.') .gt. 0) then
          write(*,999)
          goto 20
        endif
        read(response,*)iclim
        if(iclim .lt. 1 .or. iclim .gt. 3) then
           write(*,999)
           goto 20
        endif
        if (iopt .eq. 11 .or. iopt .eq. 6) goto 30
      else ! AERSURFACE or AERMET
  98    write(*,1012)
        read(*,'(a)')response2
c        read(*,*)response2
        if (trim(adjustl(response2)) .eq. ' ') goto 5
!        read(*,*)aersurf
c     check to see if response2 has quotes, take out
        inquote1=0
        inquote2=0
        inquote1=index(response2,quote1)
        if (inquote1 .gt. 0) then
            inquote2=index(response2(inquote1+1:250),quote1)
            if (inquote2 .eq. 0) goto 115
            inquote2=inquote1+inquote2-1
            aersurf=trim(adjustl(response2(inquote1+1:inquote2)))
        else
          aersurf=trim(adjustl(response2))
        endif
        inquire(file=aersurf,exist=lexist)
        if (.not. lexist) then
          write(*,*)' File does not exist'
          goto 115
        endif
        fixaer=.false.
        badsurf=.false.
        fixntemp=.false.
        fixsec=.false.
        fixalb=.false.
        fixbow=.false.
        fixzo=.false.
        lstop=.false.
        call readaer(1)
        if (fixaer) then
          if (badsurf) then
            write(*,1013)trim(adjustl(aersurf))
          else
            write(*,1014)trim(adjustl(aersurf))
            if (fixntemp) then
              write(*,1015)
            endif
            if (fixsec) then
              write(*,1016)
            endif
            if (fixalb) then
              write(*,1017)
            endif
            if (fixbow) then
              write(*,1018)
            endif
            if (fixzo) then
              write(*,1019)
            endif
          endif
!          lstop=.true.
            goto 5
        endif
        if (iopt .eq. 12 .or. iopt .eq. 6) goto 30 !back to options
      endif
   
c     version 16216
 135  if (iskip .eq. 2 .and. iopt .eq. 13) then
          if (adjustar) then
              adjustar=.false.
              ustarflg='N'
          else
              adjustar=.true.
              ustarflg='Y'
          endif
          if (iopt .ne. 14) goto 30 !back to options
      else
          write(*,1025)
          read(*,'(a)')response
          call checkanswer(response,lblank,lbad,1)
          if (lblank .or. lbad) then
              write(*,999)
              goto 135
          else
              call upcase(response)
              if (response .ne. 'Y' .and. response .ne. 'N') then
                  write(*,999)
                  goto 135
              else
                  ustarflg=response
                  if (response .eq. 'Y') then
                      adjustar=.true.
                  else
                      adjustar=.false.
                  endif
              endif
          endif
      endif
      

 1007 format(//' Enter Albedo: '\)
 1008 format(/' Enter Bowen Ratio: '\)
 1009 format(/' Enter Surface Roughness Length (m): '\)
 1010 format(//' Enter Dominant Surface Profile: '\)
 1011 format(//' Enter Dominant Climate Profile: '\)
 1012 format(//' Enter filename containing surface characteristics'/
     + 'Enclose filename with quotes if path or filename ',
     + 'includes spaces... '/
     +  'or <Enter> to return to the surface characteristics option ',
     +  'selection'/)
 
 1025 format(//' Enter Y or y to adjust u* or'/
     + ' N or n to not adjust u*'/)
 2000 format(//,1x,i1,') ',a20)
 2001 format(1x,i1,') ',a20)     
 2002 format(/' Ambient minimum temperature '/
     +  ' is greater than or equal to the ambient maximum temperature')
 2005 format(/1x,'Albedo is less than 0 or greater than 1')
 2006 format(/1x,'WARNING:  Bowen ratio may exceed reasonable values')
 3006 format(/1x,'WARNING:  Ambient minimum temperature  may exceed ',
     +  'reasonable values')
 3007 format(/1x,'WARNING:  Ambient maximum temperature  may exceed ',
     +  'reasonable values')
 2007 format(/1x,'Surface roughness is negative')
 2008 format(/1x,'WARNING:  Surface roughness is less than 0.001 m',/1x,
     +'Resetting to 0.001')
 2009 format(/1x,'WARNING:  Surface roughness may exceed reasonable ',
     + 'values')
 1014 format(/1x,'Errors have been found in surface characteristics ',
     +  'file ',a/1x,'Check for incorrect formatting'/1x,
     +  'Errors include:')
 1015 format(/1x,'Temporal resolution is not MONTHLY, SEASONAL, or ',
     +  'ANNUAL')
 1016 format(/1x,'The number of spatial sectors is incorrectly ',
     + 'formatted or sectors overlap')
 1017 format(/1x,'Albedo is missing, negative or greater than 1.0')
 1018 format(/1x,'Bowen ratio is missing or exceeds reasonable values')
 1019 format(/1x,'Surface roughness is missing or negative')
 1013 format(/1x,'Surface characteristics file ',a,' is incorrectly ',
     + 'formatted')
  999 format(1x,'Invalid response')
      return
      end


c -----------------------------------------------------------------------------
      subroutine fuminp(iskip)
      use main1
      implicit none

c iopt        option chosen by user
c iskip       integer denoting if original data input or user modifications
c n1          index of .OUT in output file
c response    response from user at prompts
c answer      first character of response
c lbad:       logical variable denoting if a response is invalid (true) or okay (false)
c lreturn:    logical variable denoting whether to exit out of subroutine, i.e. return to validation page
c             or continue to next data section
c lblank:     logical variable denoting if response is all blanks
c lall:       logical variable denoting to change all parameters (last option in lists)
c ldist:      logical variable denoting that source to shoreline distance will be entered
c ldir:       logical variable denoting that source to shoreline direction will be entered
c lfumgate:   logical variable denoting status of inversion breakup fumigation
c lshore1:    logical variable denoting status of shoreline fumigation
c lscreen:    logical variable denoting status of running AERSCREEN
      integer iopt,iskip,icase,n1
      character response*15,answer*1
      logical lreturn,lbad,lblank,lall,ldist,ldir,lfumgate1,lshore1,
     +lscreen
      
    
      lreturn=.false.

c     initialize logical variables to false
      ldist=.false.
      ldir=.false.
      lfumgate1=.false.
      lshore1=.false.
      lscreen=.false.
         
      
!      if (lurban) then
!          if (iskip .eq. 2) then
!              write(*,50)
!          else
!              lfum=.false.
!              lfumigate=.false.
!              lshore=.false.
!              shordist=0.0
!              shoredir=0.0
!          endif
!          return
!      endif
      
      call header()
      
      write(*,995)
  995 format(/'         -------------------  FUMIGATION ---------',
     +'---------')
      if (larea .or. lcirc .or. lvolume .or. height .lt. 10.0) then
          if (iskip .eq. 2) then
              write(*,15)
          else
              lfum=.false.
              lfumigate=.false.
              lshore=.false.
              runscreen=.true.
              fumflag='N'
              shorflag='N'
              shordist=0.0
              shoredir=-9.0
              scrnflag='Y'
          endif
          return
      endif
      
 15   format(/1x,'Source is not a point type source or ',
     +'release height is less than 10 m')
      if (lurban) write(*,60)
      iopt=0
  5   if (iskip .eq. 2) then
          lall=.false.
          ldist=.false.
          ldir=.false.
          lfumgate1=.false.
          lshore1=.false.
          lscreen=.false.
          write(*,1)
          if (.not. lfumigate) then
              if (lshore) then
                  if (runscreen) then
                      write(*,3)
                  else
                      write(*,4)
                  endif
                  icase=2
              else
                  write(*,2)
                  icase=1
              endif
          else
              if (lshore) then
                  if (runscreen) then
                      write(*,8)
                  else
                      write(*,9)
                  endif
                  icase=4
              else
                  if (runscreen) then 
                      write(*,6)
                  else
                      write(*,7)
                  endif
                  icase=3
              endif
          endif
          
          read(*,'(a)')response
          call checkanswer(response,lblank,lbad,2)
          if (lblank) then
              lreturn=.true.
              goto 120
          else
              if (lbad .or. index(response,'.') .gt. 0) then
                  write(*,999)
                  goto 5
              endif
              read(response,*)iopt
              if (iopt .lt. 1 .or. iopt .gt. 6) then
                  write(*,999)
                  goto 5
              endif
              if (iopt .eq. 1) lfumgate1=.true.
              if (iopt .eq. 2) lshore1=.true.
              if (iopt .eq. 6) lall=.true.
              if (icase .eq. 1) then
                  if (iopt .eq. 2) then
                      ldir=.true.
                      ldist=.true.
                  endif
                  if (iopt .eq. 3) lall=.true.
                  if (iopt .gt. 3) then
                      write(*,999)
                      goto 5
                  endif
              elseif (icase .eq. 2) then
                  if (iopt .eq. 3) ldist=.true.
                  if (iopt .eq. 4) ldir=.true.
                  if (iopt .eq. 5) lscreen=.true.
              elseif (icase .eq. 3) then
                  if (iopt .eq. 2) then
                      ldir=.true.
                      ldist=.true.
                  endif
                  if (iopt .eq. 3) lscreen=.true.
                  if (iopt .eq. 4) lall=.true.
                  if (iopt .gt. 4) then
                      write(*,999)
                      goto 5
                  endif
              else
                  if (iopt .eq. 3) ldist=.true.
                  if (iopt .eq. 4) ldir=.true.
                  if (iopt .eq. 5) lscreen=.true.
              endif
              if (lall) goto 10
              if (lfumgate1) goto 10
              if (lshore1) goto 20
              if (ldist) goto 30
              if (ldir) goto 40
              if (lscreen) goto 50
          endif
      else
          lall=.true.
      endif
      
c     prompt for inversion break-up fumigation
      
 10   if (iskip .eq. 2) then
          if (lfumigate) then
              lfumigate=.false.
              fumflag='N'
          else
              lfumigate=.true.
              fumflag='Y'
          endif
      else
          write(*,100)
          read(*,'(a)')response
          call checkanswer(response,lblank,lbad,1)
          if (lblank .or. lbad) then
              write(*,999)
              goto 10
          endif
          fumflag=trim(adjustl(response))
          call upcase(fumflag)
          if (fumflag .eq. 'Y') then
              lfumigate=.true.
          elseif (fumflag .eq. 'N') then
              lfumigate=.false.
          else
              write(*,999)
              goto 10
          endif
      endif

      if (iskip .eq. 2 .and. .not. lall) goto 5
      
      
c     prompt for shoreline fumigation
 20   if (iskip .eq. 2) then
          if (lshore) then
              lshore=.false.
              shorflag='N'
          else
              lshore=.true.
              shorflag='Y'
              ldist=.true.
              ldir=.true.
              goto 30
          endif
      else
          write(*,105)
          read(*,'(a)')response
          call checkanswer(response,lblank,lbad,1)
          if (lblank .or. lbad) then
              write(*,999)
              goto 20
          endif
          shorflag=trim(adjustl(response))
          call upcase(shorflag)
          if (shorflag .eq. 'Y') then
              lshore=.true.
          elseif (shorflag .eq. 'N') then
              lshore=.false.
          else
              write(*,999)
              goto 20
          endif
      endif
      if (iskip .eq. 2 .and. lshore1 .and. .not. ldir .and. 
     +.not. ldist) goto 5
      
c     prompt for minimum distance to shoreline
! 30   if (lshore .and. iopt .ge. 2) then
 30   if (lshore .and. (lall .or. ldist)) then
          write(*,110)
          read(*,'(a)')response
          call checkanswer(response,lblank,lbad,2)
          if (lblank .or. lbad) then
              write(*,999)
              goto 30
          endif  
          read(response,*)shordist
          if (shordist .gt. 3000 .or. shordist .lt. 0.0) then
              write(*,998)
              goto 30
          endif
      endif

40    if (lshore .and. (lall .or. ldir)) then
          write(*,130)
          read(*,'(a)')response
          call checkanswer(response,lblank,lbad,2)
          if (lblank) then
              shoredir=-9.0
          elseif (lbad) then
              write(*,999)
              goto 40
          else
              read(response,*)shoredir
              if ((shoredir .lt. 0.0 .and. shoredir .ne. -9.0) .or. 
     +        shoredir .gt. 360) then
                  write(*,999)
                  goto 40
              endif
          endif
      endif
      if (.not. lscreen .and. .not. lall) goto 5
   
 50   if (lscreen .or. lall) then
          if (runscreen) then
              scrnflag='N'
              runscreen=.false.
          else
              scrnflag='Y'
              runscreen=.true.
          endif
      else
          if (lfumigate .or. lshore) then
              write(*,140)
              read(*,'(a)')response
              call checkanswer(response,lblank,lbad,1)
              if (lblank .or. lbad) then
                  write(*,999)
                  goto 50
              else
                  scrnflag=trim(adjustl(response))
                  call upcase(scrnflag)
                  if (scrnflag .eq. 'Y') then
                      runscreen=.true.
                  elseif (scrnflag .eq. 'N') then
                      runscreen=.false.
                  else
                      write(*,999)
                      goto 50
                  endif
              endif
          endif
      endif
      
      
      if (iskip .eq. 2 .and. .not. lall) goto 5
      
 120  if (lfumigate .or. lshore) then
          lfum=.true.
          if (ldebug) then
              if (outfil .eq. 'AERSCREEN.OUT') then
                  fumfil='fumigate_debug.txt'
              else
                  n1=index(outfil,'.OUT')
                  fumfil=outfil(1:n1-1)//'_fumigate_debug.txt'
              endif
          endif
      else
          lfum=.false.
      endif

      
          
  1   format(/'-----------------------------------------------------'/
     +  'Enter number of parameter to change or'/
     +  '<Enter> to return to validation page'/)
      
  2   format(' 1) Apply inversion break-up fumigation'/' 2) Apply ',
     +  'shoreline fumigation, enter minimum distance to shoreline, '/
     +  '    and optional direction to shoreline'/
     +  ' 3) Update all parameters'/
     +  '----------------------------------------------------'/)     
     
  3   format(' 1) Apply inversion break-up fumigation'/' 2) Do not ',
     +  'apply shoreline fumigation'/' 3) Minimum distance to shoreline'
     +  /' 4) Optional direction to shoreline'/
     +  ' 5) Do not run AERSCREEN'/
     +  ' 6) Update all parameters'/
     +  '----------------------------------------------------'/)    
     
 4    format(' 1) Apply inversion break-up fumigation'/' 2) Do not ',
     +  'apply shoreline fumigation'/' 3) Minimum distance to shoreline'
     +  /' 4) Optional direction to shoreline'/
     +  ' 5) Run AERSCREEN'/
     +  ' 6) Update all parameters'/
     +  '----------------------------------------------------'/)  

  6   format(' 1) Do not apply inversion break-up fumigation'/
     +  ' 2) Apply ',
     +  'shoreline fumigation, enter minimum distance to shoreline, '/
     +  '    and optional direction to shoreline'/
     +  ' 3) Do not run AERSCREEN'/
     +  ' 4) Update all parameters'/
     +  '----------------------------------------------------'/)
  7   format(' 1) Do not apply inversion break-up fumigation'/
     +  ' 2) Apply ',
     +  'shoreline fumigation, enter minimum distance to shoreline, '/
     +  '    and optional direction to shoreline'/
     +  ' 3) Run AERSCREEN'/
     +  ' 4) Update all parameters'/
     +  '----------------------------------------------------'/)
     
 8    format(' 1) Do not apply inversion break-up fumigation'/
     +  ' 2) Do not apply shoreline fumigation'/
     +  ' 3) Minimum distance to shoreline'/
     +  ' 4) Optional direction to shoreline'/
     +  ' 5) Do not run AERSCREEN'/
     +  ' 6) Update all parameters'/
     +  '----------------------------------------------------'/)
 9    format(' 1) Do not apply inversion break-up fumigation'/
     +  ' 2) Do not apply shoreline fumigation'/
     +  ' 3) Minimum distance to shoreline'/
     +  ' 4) Optional direction to shoreline'/
     +  ' 5) Run AERSCREEN'/
     +  ' 6) Update all parameters'/
     +  '----------------------------------------------------'/)

   60 format(//' Source is an urban source, will assume rural for',
     +' fumigation calculations')     
  100 format(//' Apply inversion break-up fumigation (y/n): '\)
  105 format(//' Apply shoreline fumigation (y/n): '\)
  110 format(//' Enter minimum distance to shoreline (m): '\)
  130 format(//' Enter optional direction to shoreline ',
     +'(0 - 360 degrees) or enter -9 or <Enter> for no specific ',
     +'direction: '\)
  140 format(//' Run AERSCREEN (y/n): '\)
998   format(1x,'Minimum distance to shoreline is greater than 3 km',
     +' or invalid')
  999 format(1x,'Invalid response')
      return
      end
c -----------------------------------------------------------------------------
      subroutine validate
c      subroutine validate(ipass)
c --- Provide validation screen for user to review and change data ---


      use main1
      implicit none

c stag:         character string of source type
c response:     response to processing prompt   
c ustr:         u* text string
c lexist:       logical variable denoting if bpipprime executable exists
c lbad:         logical variable denoting if response is invalid
c lblank:       logical variable denoting if response is blank
c goodfile:     logical variable denoting if filename is valid for AERSCREEN output file
c iacfm:        integer stack flowrate
c ipop:         integer urban population
c ianswer:      integer answer to processing prompts read from response variable
      logical lexist,lbad,lblank,goodfile
      
      character stag*20,response*15,ustr*20
      integer*4 iacfm,ipop,ianswer
      
      lexist = .false.
      lstop = .false.
      nocopy=.false.
c     check probe distance and ambient distance
  10  if (probedist .lt. xnear) call probeamb    

      call header()

C --- Review Stack/Volume Data ---

      write(*,1001)
 1001 format(/'         -----------------  DATA ENTRY ',
     + 'VALIDATION  -----------------'/20x,'    METRIC',
     _ 5x,'         ENGLISH')


      if(lpoint)then
       stag='STACK'
      else if(lflare)then
       stag='FLARE'
      else if(larea)then
       stag='AREA'
      else if(lcirc)then
       stag='AREACIRC'
      else if(lvolume)then
       stag='VOLUME'
      else if (lhor) then
        stag='POINTHOR'
      else
        stag='POINTCAP'
      endif
      
      write(*,1002)trim(adjustl(stag))

1002  format(' ** ',a,'DATA **  ---------------',5x,'----------------')

      if(emisrate .lt. 0.0100)then
       write(*,1003)emisrate,emisrate/0.126
      else
       write(*,1004)emisrate,emisrate/0.126
      endif
 1003 format(/' Emission Rate:   ',e10.3,' g/s ',7x,e10.3,' lb/hr')
 1004 format(/' Emission Rate:   ',f10.4,' g/s ',7x,f10.3,' lb/hr')


c --- Validate POINT source
      if(lpoint .or. lcap .or. lhor)then
       write(*,1005)height,height/0.3048
 1005  format( ' Stack Height:      ',f8.2,' meters  ',5x,f8.2,' feet')
      endif

      if(lflare)then
       write(*,1029)flare_hgt,flare_hgt/0.3048
 1029  format( ' Flare Height:      ',f8.2,' meters  ',5x,f8.2,' feet')
      endif

      if(lcirc .or. larea) then
       write(*,1015)height,height/0.3048
 1015  format( ' Area Height:       ',f8.2,' meters  ',5x,f8.2,' feet')
      endif

      if(lvolume)then
       write(*,1025)height,height/0.3048
 1025  format( ' Volume Height:     ',f8.2,' meters  ',5x,f8.2,' feet')
      endif


c --- Validate FLARE source
      if(lflare)then
       write(*,1045)heat
 1045  format( ' Flare Heat Rate:  ', g9.4,' cal/sec')
       write(*,1046)heatloss
 1046  format( ' Heat Loss Fraction:',f8.3)
       write(*,11006)diameter,diameter/.3048*12
11006  format( ' Eff Stack Diameter:',f8.3,' meters',5x,f8.2,' inches')

       write(*,11007)temperature,(temperature-273.15)*9/5+32

11007  format( ' Eff Exit Temperature:',f8.1, ' K ',5x,f7.1,' Deg F')

       write(*,11008)velocity,velocity/0.3048
11008  format( ' Eff Exit Velocity: ',f8.3, ' m/s  ',5x,f8.2,' ft/s')

       goto 100

      endif


c --- Validate AREA source
      if(larea)then
       write(*,1016)xinit,xinit/0.3048
 1016  format( ' Area Source Length:',f8.2,' meters  ',5x,f8.2,' feet')
       write(*,1017)yinit,yinit/0.3048
 1017  format( ' Area Source Width: ',f8.2,' meters  ',5x,f8.2,' feet')
       write(*,1027)szinit,szinit/0.3048

       goto 100
      endif


c --- Validate AREACIRC source
      if(lcirc)then
       write(*,1018)circrad,circrad/0.3048
 1018  format( ' AREACIRC Source Radius:',f8.2,' meters  ',5x,f8.2,
     &         ' feet')
       write(*,1027)szinit,szinit/0.3048

       goto 100
      endif



c --- Validate VOLUME source
      if(lvolume)then
       write(*,1026)syinit,syinit/0.3048
 1026  format( ' Lateral Dimension: ',f8.2,' meters  ',5x,f8.2,' feet')
       write(*,1027)szinit,szinit/0.3048
 1027  format( ' Vertical Dimension:',f8.2,' meters  ',5x,f8.2,' feet')

       goto 100
      endif


      write(*,1006)diameter,diameter/.3048*12.
 1006 format( ' Stack Diameter:    ',f8.3,' meters',7x,f8.2,' inches')

      if (temperature .gt. 0) then
        write(*,1007)temperature,(temperature-273.15)*9./5.+32.
      else if (temperature .lt. 0) then
        write(*,10072)-1.0*temperature,(-1.0*temperature)/0.55556
      else
        write(*,10071)
      endif
 1007 format( ' Stack Temperature: ',f8.1, ' K ',11x,f8.1,' Deg F')
10071 format( ' Stack Temperature:    Ambient')
10072 format( 'Stack Temperature: ',f8.1, ' K above ambient ',1x,f8.1, 
     + ' Deg F above ambient')

      write(*,1008)velocity,velocity/0.3048
 1008 format( ' Exit Velocity:     ',f8.3, ' m/s  ',8x,f8.2,' ft/s')

      iacfm = flowrate
      write(*,1009)iacfm
 1009 format( ' Stack Flow Rate:   ',i8,' ACFM')



  100 if(lurban) then
       write(*,1010)
 1010  format( ' Model Mode:           URBAN')
       ipop = NINT(populat)
       write(*,1011)ipop
 1011  format( ' Population:        ',i8)
      else
       write(*,1012)
 1012  format( ' Model Mode:           RURAL')
      endif

      if(xnear .gt. 0) then
       write(*,1013)xnear,xnear/0.3048
 1013  format(' Dist to Ambient Air:      ',f8.1,' meters  ',
     +  7x,f6.0,' feet')
      else
       write(*,1014)
 1014  format(' Dist to Ambient Air:  Default')
      endif
      if (fixamb)then
        if (lvolume) then 
          write(*,2077)xnear
        else
          write(*,2078)
        endif
      endif
      if (warnvel) write(*,2079)
 2077  format(/1x,'Changing ambient distance to ',f7.2/
     + 'which is 2.15*sigma y + 1 meter'/) 
 2078 format(/1x,'Ambient distance changed to 1 m'/)
 2079 format(/1x,'WARNING: EXIT VELOCITY HAS BEEN RESET TO 1E-05')


c --- Review NOx chemistry ----
      if (lno2) then
        write(*,7000)trim(adjustl(noxchem))
        write(*,7001)no2stack
        write(*,7002)o3,trim(adjustl(o3units))  
      endif
 7000 format(//1x,'NOx to NO2 CHEMISTRY            ',a)
 7001 format(1x,'NO2/NOx in-stack ratio:',9x,f7.5)
 7002 format(1x,'Ozone background concentration:',e12.5,1x,a)
c --- Review Building Wake Data ---

      write(*,2009)
 2009 format(//' ** BUILDING DATA **')
      
c      if(lbpip .and. bpipfile .eq. ' ')then
      if (lbpip) then
       if (.not. lusebpip) then
       write(*,2001)bheight,bheight/0.3048
 2001  format(/' Building Height:          ',f8.1,' meters  ',5x,
     + f8.1,' feet')

       write(*,2002)blength,blength/0.3048
 2002  format( ' Max Building Dimension:   ',f8.1,' meters  ',5x,f8.1,
     +   ' feet')

       write(*,2003)bwidth,bwidth/0.3048
 2003  format( ' Min Building Dimension:   ',f8.1,' meters  ',5x,f8.1,
     +  ' feet')

       write(*,2004)bangle
 2004  format( ' Building Orientation:',f6.1,' degrees')

       write(*,2005)sangle
 2005  format( ' Stack Direction: ',f10.1,' degrees')

       write(*,2006)sdistance,sdistance/0.3048
 2006  format( ' Stack Distance:    ',f8.1,' meters  ',5x,f8.1,' feet')
       else
        write(*,2008)bpipfile
 2008  format(/' User defined BPIPPRM input file: '/1x,a)
       endif
      else


        write(*,2007)
 2007  format(/' No Building Downwash Parameters')


      endif


c --- Review Terrain Data ---
c version 204 add NAD27 to NAD83 conversion information if necessary

      write(*,3011)
 3011 format(//' ** TERRAIN DATA **')
      if(lterrain)then
       if (llat) then 
          write(*,3008)
       else
          write(*,3009)
       endif
      
       if (lnad83) write(*,3010)long27,xutm27,lat27,yutm27
       write(*,3001)xlong,utmx
       write(*,3002)xlat,utmy
       write(*,13002)izone,nada
       if (xlong .eq. 0.0 .or. xlat .eq. 0.0 .or. utmx .eq. 0.0 .or. 
     +  utmy .eq. 0) write(*,3012)
       if (laermsrc) then 
         write(*,*)' Source elevation will be determined by AERMAP'
       else
         write(*,3003)base,base/0.3048
       endif
      else
       write(*,3004)
       write(*,3003)base,base/0.3048
      endif
      write(*,3005)probedist,probedist/0.3048
      if (changeprobe .and. ipass .eq. 1) then 
        write(*,3006)probedist1,probedist
      endif
      if (lflagpole) then
        if(flagpole .gt. 0) then
         write(*,5015)flagpole,flagpole/0.3048
 5015    format(' Flagpole Receptor Height: ',f8.1,' meters  ',
     +     5x,f8.0,' feet')
        else
         write(*,5016)
 5016    format(' Flagpole Receptor Height:  Default')
        endif
      else
        write(*,5017)
 5017   format(/,' No flagpole receptors')
      endif
      
      if (ldiscrete) then
        write(*,5020)trim(adjustl(discfile)),trim(adjustl(discunit))
      else
        write(*,5021)
      endif
 5020 format(/1x,'Using discrete receptors in '/1x,a//1x,
     + 'Only receptors between the ambient and probe distances will ',
     +  'be included'/1x,'Input distance units are: ',a)
 5021 format(/1x,'No discrete receptors used')
              
 3001  format(/' Source Longitude: ',f10.5,' deg ',5x,f10.0,' Easting')
 3002  format( ' Source Latitude:  ',f10.5,' deg ',5x,f10.0,' Northing')
13002  format( ' UTM Zone:        ',i4,10x,'Reference Datum:',i2,
     +  ' (NAD 83)')
 3003  format( ' Source Base Elevation:',f6.1,' meters',5x,
     +  f6.1,'  feet')
 3004  format(/' No Terrain Elevations')   
 3005 format(/' Probe distance:',f8.0,' meters',5x,f8.0,' feet')
 3006  format(//1x,'******* WARNING *************'/1x,
     +  'Probe distance changed from ',f9.2,' m to ',/1x,f9.2,' m')
 3008  format(/1x,'Input coordinates switched from geographic to UTM')
3009  format(/1x,'Input coordinates are UTM')
3010  format(/1x,'Input coordinates converted from NAD 27 to NAD 83'
     +  /1x,'NAD 27 longitude and UTM Easting: ',f10.5,1x,f10.0,
     +  /1x,'NAD 27 latitude and UTM Northing: ',f10.5,1x,f10.0) 
3012  format(/1x,'******* WARNING *************'/1x,
     + 'One or more location coordinates are zero')

c --- Review Fumigation Data --- version 15181
      write(*,6010)
      if (.not. lfum) then
          write(*,6011)
      else
          if (lurban .and. (lfumigate .or. lshore)) write(*,6017)
          if (lfumigate) write(*,6012)
          if (lshore) then
              write(*,6013)
              write(*,6014)shordist
              if (shoredir .ge. 0.0) then
                  write(*,6015)shoredir
              else
                  write(*,6016)
              endif
          endif
          if (.not. runscreen) write(*,6018)
      endif
      
 6010 format(//' ** FUMIGATION DATA **')
 6011 format(/1x,'No fumigation requested')
 6012 format(/1x,'Inversion break-up fumigation requested')
 6013 format(/1x,'Coastal shoreline fumigation requested')
 6014 format(/1x,'Minimum distance to shoreline (m): ',f7.2)
 6015 format(/1x,'Direction to shoreline: ',f5.1)
 6016 format(/1x,'No specified direction to shoreline') 
 6017 format(/1x,'Urban source, assume rural for fumigation')
 6018 format(/1x,'AERMOD WILL NOT BE RUN')
c --- Review Meteorology Data ---
c versn 08087: add code for AERSURFACE information

      write(*,4011)
 4011 format(//' ** METEOROLOGY DATA **')
 
      if (warnmint) write(*,4015)
      if (warnmaxt) write(*,4016)
      write(*,4001)ambtmin,ambtmax,(ambtmin-273.15)*9./5.+32.,
     +              (ambtmax-273.15)*9./5.+32.
 4001 format(/' Min/Max Temperature:',f7.1,' /',f6.1,' K ',
     +                                f7.1,' / ',f7.1,' Deg F')

 4015 format(/' #######  WARNING ######'//
     +  ' Ambient minimum temperature may exceed reasonable values')
 4016 format(/' #######  WARNING ######'//
     +  ' Ambient maximum temperature may exceed reasonable values')
      write(*,4002)wsmin
 4002 format(/' Minimum Wind Speed:',f8.1,' m/s')

      write(*,4003)anemht
 4003 format(/' Anemometer Height:',f9.3,' meters')



      if(isurf .eq. 0)then

       write(*,4004)useralbe
 4004  format(/' Albedo:            ',f8.2,'       ')
       
       if (warnbow) write(*,4012)
       write(*,4005)userbown
 4005  format( ' Bowen Ratio:       ',f8.2,'       ')

       if (warnzo)write(*,4013)
       if (warnzo1)write(*,4014)
        
       if(userlen .ge. 0.001)then
        write(*,4006)userlen
 4006   format( ' Roughness Length:  ',f8.3,' (meters)')
       else
        write(*,4007)userlen
 4007   format( ' Roughness Length:  ',f8.4,' (meters)')
       endif

      else if (isurf .ge. 1 .and. isurf .le. 8) then

       write(*,4008)landuse(isurf)
 4008  format(/' Dominant Surface Profile: ',a20)

       write(*,4009)climate(iclim)

 4009  format( ' Dominant Climate Type:    ',a20)
      else
       write(*,4010)trim(adjustl(aersurf))
       if (warnbow) write(*,4012)
       if (warnzo) write(*,4013)
      endif
      if (adjustar) then
          ustr='adjusted'
      else
          ustr='not adjusted'
      endif
      write(*,4017)trim(adjustl(ustr))
 4010 format(/' Using surface characteristics in file: '/1x,a)
 4012 format(/' #######  WARNING ######'//
     +  ' Bowen ratio may exceed reasonable values') 
 4013 format(/' #######  WARNING ######'//
     +  ' Surface roughness values below 0.001 m and reset to 0.001 m')    
 4014 format(/' #######  WARNING ######'//
     +  ' Surface roughness values exceed 2.0 m')  
 4017 format(/' Surface friction velocity (u*): ',a)          
      if (ldebug) then
          write(*,5011)'ON'
      else
          write(*,5011)'OFF'
      endif

5011  format(/'DEBUG OPTION 'a,/)
      write(*,5010)trim(adjustl(outfil))
 5010 format(//1x,'AERSCREEN output file: '/1x,a)
c --- Provide opportunity for user to accept or change data ---
c --- July 1, 2009 added option to stop processing if using input file
c --- version 10039, Feb. 8, 2010, added option to change title of run
6001  if (ipass .ne. 1) then
        write(*,5000)
      else
        write(*,5001)
      endif
      
      
c 5000 format(//' *** AERSCREEN Run is Ready to Begin - Choose Option ',
c     +         'to Proceed *** ',
c     +        //22x,'1 - Change Source Data;',
c     +         /22x,'2 - Change Building Data;',
c     +         /22x,'3 - Change Terrain Data;',
c     +         /22x,'4 - Change Meteorology Data; ',
c     +         /22x,'5 - Change Title; ',
c     +         /22x,'6 - Change Output Filename; ',
c     +         /22x,'          - or -       ',
c     +         /22x,' Hit <Enter> to Start Run  '\)
     
c 5001 format(//' *** AERSCREEN Run is Ready to Begin - Choose Option ',
c     +         'to Proceed *** ',
c     +        //22x,'1 - Change Source Data;',
c     +         /22x,'2 - Change Building Data;',
c     +         /22x,'3 - Change Terrain Data;',
c     +         /22x,'4 - Change Meteorology Data; ',
c     +         /22x,'5 - Change Title; ',
c     +         /22x,'6 - Change Output Filename; ',
c     +         /22x,'7 - Stop AERSCREEN; ',
c     +         /22x,'          - or -       ',
c     +         /22x,' Hit <Enter> to Start Run  '\)

 5000 format(//' *** AERSCREEN Run is Ready to Begin - Choose Option ',
     +         'to Proceed *** ',
     +        //22x,'1 - Change Source Data;',
     +         /22x,'2 - Change Building Data;',
     +         /22x,'3 - Change Terrain Data;',
     +         /22x,'4 - Change Meteorology Data; ',
     +         /22x,'5 - Change Fumigation Data; ',
     +         /22x,'6 - Change Title; ',
     +         /22x,'7 - Change Debug Option; '
     +         /22x,'8 - Change Output Filename; ',
     +         /22x,'          - or -       ',
     +         /22x,' Hit <Enter> to Start Run  '\)
     
 5001 format(//' *** AERSCREEN Run is Ready to Begin - Choose Option ',
     +         'to Proceed *** ',
     +        //22x,'1 - Change Source Data;',
     +         /22x,'2 - Change Building Data;',
     +         /22x,'3 - Change Terrain Data;',
     +         /22x,'4 - Change Meteorology Data; ',
     +         /22x,'5 - Change Fumigation Data; ',
     +         /22x,'6 - Change Title; ',
     +         /22x,'7 - Change Debug Option;',
     +         /22x,'8 - Change Output Filename; ',
     +         /22x,'9 - Stop AERSCREEN; ',
     +         /22x,'          - or -       ',
     +         /22x,' Hit <Enter> to Start Run  '\)
      read(*,'(a)')response
      call checkanswer(response,lblank,lbad,2)
      if (lblank) then
          goto 6000
      else
         if (lbad .or. index(response,'.') .gt. 0) goto 6001
         read(response,*)ianswer
         if(ianswer .eq. 1)then
           call stacks(2)
c         reset fumigation to false if point source type and height less than 10 m after validation
          if ((lpoint .or. lflare .or. lhor .or. lcap) .and. 
     +        height .lt. 10.0) then
              lfum=.false.
              lfumigate=.false.
              lshore=.false.
              runscreen=.true.
              fumflag='N'
              shorflag='N'
              scrnflag='Y'
          endif
           goto 10
         elseif (ianswer .eq. 2) then
           call downwash(2)
           goto 10
         elseif(ianswer .eq. 3)then
           call getDEMs(2)
           if (lstop) then
            if (fixdem) then
              write(*,1037)
              write(ilog,1037)
            else
              write(*,1038)trim(adjustl(nadpath1))
              write(ilog,1038)trim(adjustl(nadpath1))
            endif
            return
           endif
           goto 10
         elseif(ianswer .eq. 4)then
           call metdata(2)
           goto 10
         elseif (ianswer .eq. 5) then
          call fuminp(2)
          goto 10
c         elseif ianswer .eq. 5) then
         elseif(ianswer .eq. 6) then
           call header()
           write(*,5003)
           read(*,5004)title
           goto 10
         elseif (ianswer .eq. 7) then
             call header()
             call setdebug(2)
             goto 10
c         elseif(ianswer .eq. 6) then
         elseif(ianswer .eq. 8) then
          call getoutfil
! 5014     write(*,5011)
!          read(*,'(a)')outfil
!          if (outfil .eq. '') then
!            outfil='AERSCREEN.OUT'
!          else
!            if (index(outfil,'AERSCREEN.LOG') .gt. 0 
!     +      .or. index(outfil,'aerscreen.log') .gt. 0) then
!              write(*,5012)
!              goto 5014
!            else
!              call checkfile(goodfile)
!              if (.not. goodfile) then
!                write(*,5013)
!                goto 5014
!              endif
!            endif
!          endif
          goto 10
c          elseif (ianswer .eq. 7 .and. ipass .eq. 1)then
         elseif (ianswer .eq. 9 .and. ipass .eq. 1)then
           call system("cls")
c          call system("clear")   !unix/linux
           write(*,5002)
           write(ilog,5002)
           if (.not. ldefault) nocopy=.true.
           lstop=.true.
           return
         else
           write(*,999)
           goto 6001
         endif
      endif
5002  format(/1x,'Stopping AERSCREEN by user action...')
5003  format(/1x,'Enter title of AERSCREEN run...'/)
5004  format(a)
 999  format(1x,'Invalid response')
 1037 format(/1x,'demlist.txt does not exist')
 1038 format(/1x,'No grid files exist in the NADGRIDS folder: ',a)
! 5011 format(/,1x,'Enter name of AERSCREEN output file'/1x,
!     + 'Enter <Enter> to use default name AERSCREEN.OUT'/1x,
!     + 'Filename cannot be AERSCREEN.LOG')
!5012  format(/,1x,'Output file is AERSCREEN.LOG')
!5013  format(/1x,'Pathname of output file does not exist')
c     write data to logfile
6000   call writetolog()

c --- change units flag from English to metric because new input file will have 
c --- metric units
      if (.not. lmetric) then
        write(*,*)' '
        write(*,*)'Changing units flag from English to metric'
        write(*,*)' '
        write(ilog,*)' '
        write(ilog,*)'Changing units flag from English to metric'
        write(ilog,*)' '
        lmetric=.true.
        lswitch=.true.
        units='M'
      endif
      
c     check for AERMOD, MAKEMET, BPIPPRM, and AERMAP executables
c     AERMOD executable
      if (runscreen) call getexe(1)      
c     MAKEMET
      call getexe(2)
      if(lbpip .and. runscreen)then
       call getexe(3)
       if(bheight .eq. 0.0 .and. bpipfile .eq. ' ')then
        bpip = 'N'
        return
       endif

       write(*,'(//'' Running BPIP Prime...'')')
       
       if (runscreen) call downwash(1)
!       inquire(file='bpipprm.exe',exist=lexist)
!       if( .not.lexist )then
!!         write(*,*) 'BPIPPRM.EXE File Not Found!! Aborting!!'
!!         write(ilog,*)'BPIPPRM.EXE File Not Found!! Aborting!!'
!!         write(ilog,*)' '
!         call getexe(3)
!!         stop
!       endif

c     version 15181, call from readbpip
!       call system("bpipprm bpipprm.inp bpipprm.out bpipprm.txt > NUL")

       if (runscreen) call readbpip()

      endif



      if(lterrain .and. runscreen)then
       call getexe(4)
       write(*,'(//'' Running AERMAP...'')')
       call getDEMs(1)
      endif



      end


c -----------------------------------------------------------------------------
      subroutine writetolog()
c     write to log file same information from validate after all changes made
      use main1
      implicit none
      
c stag:         character string of source type
c ustr:         u* adjustment text string
c iacfm:        integer stack flowrate
c ipop:         integer urban population      
      character stag*20,ustr*20
     
      integer*4 iacfm,ipop



  10  call header()
c      write(ilog,*)' '
c      write(ilog,*)'         -----------------  DATA ENTRY ',
c     +          'VALIDATION  -----------------'


C --- Review Stack/Volume Data ---
      write(ilog,1000)title
       write(ilog,*)' '
 1000  format(12x,a60)
      write(ilog,1001)
 1001 format(/'         -----------------  DATA ENTRY ',
     + 'VALIDATION  -----------------'/20x,'    METRIC',
     _ 5x,'         ENGLISH')


      if(lpoint)then
       stag='STACK'
      else if(lflare)then
       stag='FLARE'
      else if(larea)then
       stag='AREA'
      else if(lcirc)then
       stag='AREACIRC'
      else if(lvolume)then
       stag='VOLUME'
      else if (lhor) then
        stag='POINTHOR'
      else
        stag='POINTCAP'
      endif
      
      write(ilog,1002)trim(adjustl(stag))

1002  format(' ** ',a,'DATA **  ---------------',5x,'----------------')



      if(emisrate .lt. 0.0100)then
       write(ilog,1003)emisrate,emisrate/0.126
      else
       write(ilog,1004)emisrate,emisrate/0.126
      endif
 1003 format(/' Emission Rate:   ',e10.3,' g/s ',7x,e10.3,' lb/hr')
 1004 format(/' Emission Rate:   ',f10.4,' g/s ',7x,f10.3,' lb/hr')

c --- Validate POINT source
      if(lpoint .or. lcap .or. lhor)then
       write(ilog,1005)height,height/0.3048
 1005  format( ' Stack Height:      ',f8.2,' meters  ',5x,f8.2,' feet')
      endif

      if(lflare)then
       write(ilog,1029)flare_hgt,flare_hgt/0.3048
 1029  format( ' Flare Height:      ',f8.2,' meters  ',5x,f8.2,' feet')
      endif

      if(larea .or. lcirc)then
       write(ilog,1015)height,height/0.3048
 1015  format( ' Area Height:       ',f8.2,' meters  ',5x,f8.2,' feet')
      endif

      if(lvolume)then
       write(ilog,1025)height,height/0.3048
 1025  format( ' Volume Height:     ',f8.2,' meters  ',5x,f8.2,' feet')
      endif


c --- Validate FLARE source
      if(lflare)then
       write(ilog,1045)heat
 1045  format( ' Flare Heat Rate:  ', g9.4,' cal/sec')
       write(ilog,1046)heatloss
 1046  format( ' Heat Loss Fraction:',f8.3)
       write(ilog,11006)diameter,diameter/.3048*12
11006  format( ' Eff Stack Diameter:',f8.3,' meters',5x,f8.2,' inches')

       write(ilog,11007)temperature,(temperature-273.15)*9/5+32
11007  format( ' Eff Exit Temperature:',f8.1, ' K ',5x,f7.1,' Deg F')

       write(ilog,11008)velocity,velocity/0.3048
11008  format( ' Eff Exit Velocity: ',f8.3, ' m/s  ',5x,f8.2,' ft/s')

       goto 100

      endif


c --- Validate AREA source
      if(larea)then
       write(ilog,1016)xinit,xinit/0.3048
 1016  format( ' Area Source Length:',f8.2,' meters  ',5x,f8.2,' feet')
       write(ilog,1017)yinit,yinit/0.3048
 1017  format( ' Area Source Width: ',f8.2,' meters  ',5x,f8.2,' feet')
       write(ilog,1027)szinit,szinit/0.3048

       goto 100
      endif


c --- Validate AREACIRC source
      if(lcirc)then
       write(ilog,1018)circrad,circrad/0.3048
 1018  format( ' AREACIRC Source Radius:',f8.2,' meters  ',5x,f8.2,
     &         ' feet')
       write(ilog,1027)szinit,szinit/0.3048

       goto 100
      endif



c --- Validate VOLUME source
      if(lvolume)then
       write(ilog,1026)syinit,syinit/0.3048
 1026  format( ' Lateral Dimension: ',f8.2,' meters  ',5x,f8.2,' feet')
       write(ilog,1027)szinit,szinit/0.3048
 1027  format( ' Vertical Dimension:',f8.2,' meters  ',5x,f8.2,' feet')

       goto 100
      endif


      write(ilog,1006)diameter,diameter/.3048*12.
 1006 format( ' Stack Diameter:    ',f8.3,' meters',7x,f8.2,' inches')

      if (temperature .gt. 0) then
        write(ilog,1007)temperature,(temperature-273.15)*9./5.+32.
      else if (temperature .lt. 0) then
        write(ilog,10072)-1.0*temperature,(-1.0*temperature)/0.55556
      else
        write(ilog,10071)
      endif
 1007 format( ' Stack Temperature: ',f8.1, ' K ',11x,f8.1,' Deg F')
10071 format( ' Stack Temperature:    Ambient')
10072 format( 'Stack Temperature: ',f8.1, ' K above ambient ',1x,f8.1, 
     + ' Deg F above ambient')

      write(ilog,1008)velocity,velocity/0.3048
 1008 format( ' Exit Velocity:     ',f8.3, ' m/s  ',8x,f8.2,' ft/s')

      iacfm = flowrate
      write(ilog,1009)iacfm
 1009 format( ' Stack Flow Rate:   ',i8,' ACFM')



  100 if(lurban) then
       write(ilog,1010)
 1010  format( ' Model Mode:           URBAN')
       ipop = NINT(populat)
       write(ilog,1011)ipop
 1011  format( ' Population:        ',i8)
      else
       write(ilog,1012)
 1012  format( ' Model Mode:           RURAL')
      endif

      if(xnear .gt. 0) then
       write(ilog,1013)xnear,xnear/0.3048
 1013  format(' Dist to Ambient Air:      ',f8.1,' meters  ',
     +  7x,f6.0,' feet')
      else
       write(ilog,1014)
 1014  format(' Dist to Ambient Air:  Default')
      endif
      
      if (fixamb)then
        if (lvolume) then 
          write(*,2077)xnear
        else
          write(*,2078)
        endif
      endif
      
      if (warnvel) write(*,2079)
      
 2077  format(/1x,'Changing ambient distance to ',f7.2/
     + 'which is 2.15*sigma y + 1 meter'/) 
 2078 format(/1x,'Ambient distance changed to 1 m'/)
 2079 format(/1x,'WARNING: EXIT VELOCITY HAS BEEN RESET TO 1E-05')
!      if (lflagpole) then
!        if(flagpole .gt. 0) then
!         write(ilog,5015)flagpole,flagpole/0.3048
! 5015    format(' Flagpole Receptor Height: ',f8.1,' meters  ',
!     +     5x,f8.0,' feet')
!        else
!         write(ilog,5016)
! 5016    format(' Flagpole Receptor Height:  Default')
!        endif
!      else
!        write(ilog,5017)
! 5017   format(/,' No flagpole receptors')
!      endif

c --- Review NOx chemistry ----
      if (lno2) then
        write(ilog,7000)trim(adjustl(noxchem))
        write(ilog,7001)no2stack
        write(ilog,7002)o3,trim(adjustl(o3units))  
      endif
 7000 format(//1x,'NOx to NO2 CHEMISTRY            ',a)
 7001 format(1x,'NO2/NOx in-stack ratio:',9x,f7.5)
 7002 format(1x,'Ozone background concentration:',e12.5,1x,a)
c --- Review Building Wake Data ---

      write(ilog,2009)
 2009 format(//' ** BUILDING DATA **')
      
c      if(lbpip .and. bpipfile .eq. ' ')then
      if (lbpip) then
       if (.not. lusebpip) then
       write(ilog,2001)bheight,bheight/0.3048
 2001  format(/' Building Height:          ',f8.1,' meters  ',5x,
     + f8.1,' feet')

       write(ilog,2002)blength,blength/0.3048
 2002  format( ' Max Building Dimension:   ',f8.1,' meters  ',5x,f8.1,
     +   ' feet')

       write(ilog,2003)bwidth,bwidth/0.3048
 2003  format( ' Min Building Dimension:   ',f8.1,' meters  ',5x,f8.1,
     +  ' feet')

       write(ilog,2004)bangle
 2004  format( ' Building Orientation:',f6.1,' degrees')

       write(ilog,2005)sangle
 2005  format( ' Stack Direction: ',f10.1,' degrees')

       write(ilog,2006)sdistance,sdistance/0.3048
 2006  format( ' Stack Distance:    ',f8.1,' meters  ',5x,f8.1,' feet')
       else
        write(ilog,2008)bpipfile
 2008  format(/' User defined BPIPPRM input file: '/1x,a)
       endif
      else

c       if(bpipfile .eq. ' ')then
c        if (.not. lusebpip) then
        write(ilog,2007)
 2007  format(/' No Building Downwash Parameters')
c        else
 
c        endif

      endif


c --- Review Terrain Data ---


      write(ilog,3011)
 3011 format(//' ** TERRAIN DATA **')
      if(lterrain)then
      
       if (llat) then 
          write(ilog,3008)
       else
          write(ilog,3009)
       endif
       if (lnad83) write(ilog,3010)long27,xutm27,lat27,
     +  yutm27
       
       write(ilog,3001)xlong,utmx

       write(ilog,3002)xlat,utmy
 
       write(ilog,13002)izone,nada

       if (laermsrc) then 
         write(ilog,*)' Source elevation will be determined by AERMAP'
       else
         write(ilog,3003)base,base/0.3048
       endif
      else
       write(ilog,3004)
       write(ilog,3003)base,base/0.3048
      endif
      write(ilog,3005)probedist,probedist/0.3048
      if (changeprobe .and. ipass .eq. 1) then 
        write(*,3006)probedist1,probedist
      endif
      if (lflagpole) then
        if(flagpole .gt. 0) then
         write(ilog,5015)flagpole,flagpole/0.3048
 5015    format(' Flagpole Receptor Height: ',f8.1,' meters  ',
     +     5x,f8.0,' feet')
        else
         write(ilog,5016)
 5016    format(' Flagpole Receptor Height:  Default')
        endif
      else
        write(ilog,5017)
 5017   format(/,' No flagpole receptors')
      endif  
      
      if (ldiscrete) then
        write(ilog,5020)trim(adjustl(discfile)),trim(adjustl(discunit))
      else
        write(ilog,5021)
      endif
 5020 format(/1x,'Using discrete receptors in '/1x,a//1x,
     + 'Only receptors between the ambient and probe distances will ',
     +  'be included'/1x,'Input distance units are: ',a)
 5021 format(/1x,'No discrete receptors used')      
          
 3001  format(/' Source Longitude: ',f10.5,' deg ',5x,f10.0,' Easting')
 3002  format( ' Source Latitude:  ',f10.5,' deg ',5x,f10.0,' Northing')     
13002  format( ' UTM Zone:        ',i4,10x,'Reference Datum:',i2,
     +  ' (NAD 83)')      
 3003  format( ' Source Base Elevation:',f6.1,' meters',5x,
     +  f6.1,'  feet')     
 3004  format(/' No Terrain Elevations')
 3005 format(/' Probe distance:',f8.0,' meters',5x,f8.0,' feet')
 3006  format(//1x,'******* WARNING *************'/1x,
     +  'Probe distance changed from ',f9.2,' m to ',/1x,f9.2,' m') 
3008  format(/1x,'Input coordinates switched from geographic to UTM')
3009  format(/1x,'Input coordinates are UTM')
3010  format(/1x,'Input coordinates converted from NAD 27 to NAD 83'
     +  /1x,'NAD 27 longitude and UTM Easting: ',f10.5,1x,f10.0,
     +  /1x,'NAD 27 latitude and UTM Northing: ',f10.5,1x,f10.0)

c --- Review Fumigation Data ---
      write(ilog,6010)
      if (.not. lfum) then
          write(ilog,6011)
      else
          if (lurban .and. (lfumigate .or. lshore)) write(ilog,6017)
          if (lfumigate) write(ilog,6012)
          if (lshore) then
              write(ilog,6013)
              write(ilog,6014)shordist
              if (shoredir .ge. 0.0) then
                  write(ilog,6015)
              else
                  write(ilog,6016)
              endif
          endif
          if (.not. runscreen) write(ilog,6018)
      endif
      
 6010 format(//' ** FUMIGATION DATA **')
 6011 format(/1x,'No fumigation requested')
 6012 format(/1x,'Inversion break-up fumigation requested')
 6013 format(/1x,'Coastal shoreline fumigation requested')
 6014 format(/1x,'Minimum distance to shoreline (m): ',f7.2)
 6015 format(/1x,'Direction to shoreline: ',f5.1)
 6016 format(/1x,'No specified direction to shoreline')
 6017 format(/1x,'Urban source, assume rural for fumigation')
 6018 format(/1x,'AERMOD WILL NOT BE RUN')
c --- Review Meteorology Data ---


      write(ilog,4011)
 4011 format(//' ** METEOROLOGY DATA **')
 
      if (warnmint) write(ilog,4015)
      if (warnmaxt) write(ilog,4016)
      
      write(ilog,4001)ambtmin,ambtmax,(ambtmin-273.15)*9./5.+32.,
     +              (ambtmax-273.15)*9./5.+32.
 4001 format(/' Min/Max Temperature:',f7.1,' /',f6.1,' K ',
     +                                f6.1,' / ',f5.1,' Deg F')
 4015 format(/' #######  WARNING ######'//
     +  ' Ambient minimum temperature may exceed reasonable values')
 4016 format(/' #######  WARNING ######'//
     +  ' Ambient maximum temperature may exceed reasonable values')
     
      write(ilog,4002)wsmin
 4002 format(/' Minimum Wind Speed:',f8.1,' m/s')

      write(ilog,4003)anemht
 4003 format(/' Anemometer Height:',f9.3,' meters')



      if(isurf .eq. 0)then

       write(ilog,4004)useralbe
 4004  format(/' Albedo:            ',f8.2,'       ')

       if (warnbow) write(ilog,4012)
       write(ilog,4005)userbown
 4005  format( ' Bowen Ratio:       ',f8.2,'       ')

       if (warnzo) write(ilog,4013)
       if (warnzo1) write(ilog,4014)
       if(userlen .ge. 0.001)then
        write(ilog,4006)userlen
 4006   format( ' Roughness Length:  ',f8.3,' (meters)')
       else
        write(ilog,4007)userlen
 4007   format( ' Roughness Length:  ',f8.4,' (meters)')
       endif

      else if (isurf .ge. 1 .and. isurf .le. 8)then

      write(ilog,4008)landuse(isurf)
 4008  format(/' Dominant Surface Profile: ',a20)



       write(ilog,4009)climate(iclim)

 4009  format( ' Dominant Climate Type:    ',a20)
      else
        write(ilog,4010)trim(adjustl(aersurf))
        if (warnbow) write(ilog,4012)
        if (warnzo) write(ilog,4013)
      endif
      if (adjustar) then
          ustr='adjusted'
      else
          ustr='not adjusted'
      endif
      write(ilog,4017)trim(adjustl(ustr))
 4010 format(/' Using surface characteristics in file: '/1x,a)
 4012 format(/' #######  WARNING ######'//
     +  ' Bowen ratio may exceed reasonable values') 
 4013 format(/' #######  WARNING ######'//
     +  ' Surface roughness values below 0.001 m and reset to 0.001 m')
 4014 format(/' #######  WARNING ######'//
     +  ' Surface roughness values exceed 2.0 m')
 4017 format(/' Surface friction velocity (u*): ',a)            
      if (ldebug) then
          write(ilog,5011)'ON'
      else
          write(ilog,5011)'OFF'
      endif

5011  format(/'DEBUG OPTION 'a,/)
      
      write(ilog,5010)trim(adjustl(outfil))
 5010 format(//1x,'AERSCREEN output file: '/1x,a)
c --- Provide opportunity for user to accept or change data ---

      write(ilog,5000)
 5000 format(//' *** AERSCREEN Run is Ready to Begin  ',/)
     



      if(lterrain)then
       write(ilog,5001)
      else
       write(ilog,5002)
      endif
     
5001  format(//' Terrain to be used,AERMAP will be run '/
     + '**************************************************')
5002  format(//' No terrain used, AERMAP will not be run '/
     + '**************************************************')

      end
c------------------------------------------------------------------------------
      subroutine readbpip()

c --- version 15181 call BPIPPRIME
c --- Read data from BPIPPRIME output file - Delete output file when done  ---
      use main1
      implicit none

c line:   line read from BPIPPRIME output file
c temp:   substring of line, determining what data to read in
c n:      loop counter
c i:      loop counter

      character line*100,temp*20,aline*300
      integer n,i
      
c     execute bpipprm
      write(aline,'(3a)')'bpipprm ',trim(adjustl(bpipfile)),
     + ' bpipprm.out bpipprm.txt > NUL'
      call system(aline)
      open(bpipout,file='bpipprm.out',status ='old')

   10 read(bpipout,'(a)',end=99)line
      read(line,'(5x,a3)')temp
     
      if(temp .ne. 'SO ')goto 10


c --- Read 36 Building Heights ---
      read(line,1001,end=99)temp,(bpiphgt(i),i=1,6)
      if(temp .ne. 'BUILDHGT')goto 100

      do n=1,5
       read(bpipout,1001,end=99)temp,(bpiphgt(n*6+i),i=1,6)
       if(temp .ne. 'BUILDHGT')goto 100
      enddo

c --- Read 36 Building Widths ---
      do n=0,5
       read(bpipout,1001,end=99)temp,(bpipwid(n*6+i),i=1,6)
       if(temp .ne. 'BUILDWID')goto 110
      enddo

c --- Read 36 Building Lengths ---
      do n=0,5
       read(bpipout,1001,end=99)temp,(bpiplen(n*6+i),i=1,6)
       if(temp .ne. 'BUILDLEN')goto 120
      enddo

c --- Read 36 Building X Adjacents ---
      do n=0,5
       read(bpipout,1001,end=99)temp,(bpipxad(n*6+i),i=1,6)
       if(temp .ne. 'XBADJ   ')goto 130
      enddo

c --- Read 36 Building Y Adjacents ---
      do n=0,5
       read(bpipout,1001,end=99)temp,(bpipyad(n*6+i),i=1,6)
       if(temp .ne. 'YBADJ   ')goto 140
      enddo


c --- Check to see if stack is GEP ---
      igep = 1
ctmprwb      do n=1,36
        if(MAXVAL(bpiphgt) .le. 0.0)then
c ---      No buildings present, reset igep to 0
           igep = 0
        endif

ctmprwb        if(bpiphgt(n) .gt. height/2.5)igep = 0
ctmprwb      enddo


c      close(2,status='delete')
      close(bpipout)
      return

   99 write(*,'(/'' BPIPPRM.OUT is incomplete!!'')')
      write(ilog,'(/'' BPIPPRM.OUT is incomplete!!'')')
      goto 200

  100 write(*,'(/'' Insuffient number of Building Heights values'',
     +           '' found in BPIPPRM.OUT'')')
      write(ilog,'(/'' Insuffient number of Building Heights values'',
     +           '' found in BPIPPRM.OUT'')')
      goto 200

  110 write(*,'(/'' Insuffient number of Building Widths values'',
     +          '' found in BPIPPRM.OUT'')')
      write(ilog,'(/'' Insuffient number of Building Widths values'',
     +          '' found in BPIPPRM.OUT'')')
      goto 200

  120 write(*,'(/'' Insuffient number of Building Lengths values'',
     +           '' found in BPIPPRM.OUT'')')
      write(ilog,'(/'' Insuffient number of Building Lengths values'',
     +           '' found in BPIPPRM.OUT'')')
      goto 200

  130 write(*,'(/'' Insuffient number of XBADJ values'',
     +           '' found in BPIPPRM.OUT'')')
      write(ilog,'(/'' Insuffient number of XBADJ values'',
     +           '' found in BPIPPRM.OUT'')')
      goto 200

  140 write(*,'(/'' Insuffient number of YBADJ values'',
     +           '' found in BPIPPRM.OUT'')')
      write(ilog,'(/'' Insuffient number of YBADJ values'',
     +           '' found in BPIPPRM.OUT'')')
      goto 200



  200 write(*,'(/'' Check PRIME flag in input file...'')')
      write(ilog,'(/'' Check PRIME flag in input file...'')')
c      stop
      lstop=.true.


      
 1000 format(25x,6f8.2)
 1001 format(8x,a8,9x,6f8.2)

      end


c -----------------------------------------------------------------------------
      subroutine makeinput(isector,itemp,isecuse)

c --- Create AERMOD.INP file based on user provided data ---

      use main1
      implicit none

c format1:        character string of source type or format of line
c metline:        character string of command to copy appropriate meteorological files for
c                 run
c t1:             character string of temporal period itemp being processed
c s1:             character string of spatial sector isecuse being processed
c sfcfil:         appropriate surface meteorological file to use based on itemp and isecuse
c pflfil:         appropriate profile meteorological file to use based on itemp and isecuse
c atemp:          temporal period being processed, annual, month name, or season
c modnam:         subroutine calling makeinput, PROBE, FLOWSECTOR, or REFINE
c aersurf1:       External surface characteristics file, if one not being used set to 'NA'
c optstr1:        base MODELOPT string: MODELOPT CONC SCREEN
c optstr:         MODELOPT string based on source type, NOx chemistry, terrain use
c areaopt:        FASTAREA model option to add to optstr1
c teropt:         FLAT or ELEV option to add to optstr1
c betaopt:        BETA option to add to optstr1 if processing POINTCAP or POINTHOR
c no2opt:         NOx chemistry option to add to optstr1
c pollutid:       POLLUTID keyword to add, if modeling NO2, then set to NO2, otherwise set
c                 to OTHER
c nverts:         number of vertices for circular source, set to 20
c isector:        radial sector to process
c length:         length for format statement
c isecuse:        spatial sector to use
c itemp:          temporal period to use
c aangle:         orientation angle for area source, set to 0.0    

c version 14147:  remove initial blank line in AERMOD.INP to be compatible
c with AERMOD 14134

      character format1*60,metline*60,t1*2,s1*2,
     +  atemp*10,modnam*12,aersurf1*250,optstr*100,optstring1*50,
     + areaopt*8,teropt*4,betaopt*4,no2opt*5,pollutid*5
      integer nverts,isector,length,isecuse,itemp
      real aangle
   
c set value for aersurf1      
      if (aersurf .eq. '') then
        aersurf1='NA'
      else
        aersurf1=aersurf
      endif
      
      !if (istage .eq. 1) then
      !   modnam='PROBE'
      !elseif (istage .eq. 2) then
      !   modnam='FLOWSECTOR'
      !else
      !   modnam='REFINE'
      !endif
 
 
      if (istage .eq. 1) then
          modnam='PROBE'
      elseif (istage .eq. 2) then
          modnam='FLOWSECTOR'
      else
          modnam='REFINE'
      endif
      
      open(aermodin,file='aermod.inp',status='unknown')
      

c --- write a message that coordinates were switched from NAD27 to NAD83
      if (lnad83 .and. lterrain) then
       write(aermodin,1997)
      endif
 1997 format('** Coordinates switched from NAD27 to NAD83')
c --- write a message that coordinates have been switched to UTM if originally lat/lon
      if (llat .and. lterrain) then
       write(aermodin,1998)
      endif
 1998 format('** Coordinates switched from geographic to UTM')
 
c --- write a message that units have been switched if English units used initially
      if (lswitch) then
       write(aermodin,1999)
      endif
 1999  format('** Input units switched from English to metric')

c --- Write all input data, as comments, to input file for duplicate run ---
c change order of point source variables to match AERMOD.INP JAT 04/29/09
      
      if(lpoint)then
       write(aermodin,2000) emisrate,height,temperature,
     +              velocity,diameter,flowrate
 2000  format('** STACK DATA         Rate    Height    ',
     +         ' Temp.  Velocity     Diam.     Flow'/
     +'**            ',e12.4,4f10.4,f10.0)
      endif

      if (lhor) then
        write(aermodin,2010)emisrate,height,temperature,
     +              velocity,diameter,flowrate
      endif
 2010  format('** POINTHOR DATA      Rate    Height    ',
     +         ' Temp.  Velocity     Diam.     Flow'/
     +'**            ',e12.4,4f10.4,f10.0)
     
      if (lcap) then
        write(aermodin,2011)emisrate,height,temperature,
     +              velocity,diameter,flowrate
      endif
      
 2011  format('** POINTCAP DATA      Rate    Height    ',
     +         ' Temp.  Velocity     Diam.     Flow'/
     +'**            ',e12.4,4f10.4,f10.0)
     
      if(lflare)then
       write(aermodin,2009)emisrate,flare_hgt,heat,heatloss
 2009  format('** FLARE DATA         Rate    Height        Heat  ',
     +         'HeatLoss'/
     +  '**            ',e12.4,f10.4,e12.4,f10.3)
      endif

      if(larea)then
       write(aermodin,2003)emisrate,height,xinit,yinit,szinit
 2003  format('** AREA DATA          Rate    Height    Length  ',
     +         '   Width   Angle     Szinit'/
     +  '**            ',e12.4,3f10.4,'     0.0 ',f10.2)
      endif

      if(lcirc)then
       write(aermodin,2013)emisrate,height,circrad,szinit
 2013  format('** AREACIRC DATA      Rate    Height    Radius  ',
     +         'NVerts      Szinit'/
     + '**            ',e12.4,2f10.4,'      20  ',f10.2)
      endif


      if(lvolume)then
       write(aermodin,2005)emisrate,height,syinit,szinit
 2005  format('** VOLUME DATA        Rate    Height    Syinit   ',
     +         ' Szinit'/
     + '**            ',e12.4,3f10.4)
      endif

      if(igep .ne. 0) then
        bpip = 'Y'
        lbpip=.true.
      endif
      
c write building information
      write(aermodin,2020)bpip,bheight,blength,bwidth,bangle,sangle,
     +  sdistance
 2020 format(/'** BUILDING DATA   BPIP    Height  Max dim.  Min ',
     +        'dim.   Orient.   Direct.    Offset'/
     +   '**                  ',a1,2x,6F10.4)

c write meteorological data information
c version 16216, add line for u* adjustment
      write(aermodin,2040)ambtmin,ambtmax,wsmin,anemht,isurf,iclim,
     +              alb(itemp,isecuse),bow(itemp,isecuse),
     +    rough(itemp,isecuse),quote1,trim(adjustl(aersurf1)),quote1,
     +    ustarflg
     
 2040 format(/'** MAKEMET DATA    MinT    MaxT Speed   AnemHt ',
     +        'Surf Clim  Albedo   Bowen  Length  SC FILE  '/
     +  '**             ',2f8.2,f6.1,f9.3,2i5,3f9.4,2x,3a//
     +    '** ADJUST U*',6x,a1)
! 2040 format(/'** MAKEMET DATA    MinT    MaxT Speed   AnemHt ',
!     +        'Surf Clim  Albedo   Bowen  Length  SC FILE  '/
 !    +  '**             ',2f8.2,f6.1,f9.3,2i5,3f9.4,2x,3a)


c write terrain information
      write(aermodin,2060)terrain,utmx,utmy,izone,nada,
     + probedist,profbase,aermap

 2060 format(/'** TERRAIN DATA   Terrain    UTM East   UTM North',
     +      '  Zone  Nada     Probe     PROFBASE  ',
     +      'Use AERMAP elev'/'**                   ',
     + a1,3x,2f12.1,2i6,5x,f8.1,6x,f9.2,9x,a1)

c write discrete receptor information
      write(aermodin,2070)discflag,quote1,trim(adjustl(discfile)),quote1
 2070 format(/'** DISCRETE RECEPTORS  Discflag   Receptor file'/
     +'**                      ',a,8x,3a)          
c write other information
      write(aermodin,2080)units,urban,populat,xnear,flgswitch,
     +  flagpole
 2080 format(/'** UNITS/POPULATION   Units   R/U  Population   ',
     +        '   Amb. dist.   Flagpole    Flagpole height'/
     + '**                 ', 2(5x,a1),2x,f12.0,6x,f10.3,7x,a1,4x,f9.2)
 
c write fumigation data
!      write(aermodin,2082)fumflag,shorflag,shordist
! 2082 format(/'** FUMIGATION        Inversion Break-up        ',
!     +'Shoreline     Min distance to shore'/
!     +'**                         ',a1,22x,a1,13x,f7.2)
      write(aermodin,2082)fumflag,shorflag,shordist,shoredir,scrnflag
 2082 format(/'** FUMIGATION        Inversion Break-up  Shoreline  ',
     +'Distance    Direct  Run AERSCREEN'/
     +'**                         ',a1,18x,a1,6x,f7.2,2x,f7.1,5x,a1)
c write debug data
      write(aermodin,2083)debugflg
 2083 format(/'** DEBUG OPTION      Debug'/'**                     ',a1)
 
c      if (outfil .ne. 'AERSCREEN.OUT' .and. 
c     + outfil .ne. 'aerscreen.out') then
        write(aermodin,2081)quote1,trim(adjustl(outfil)),quote1
c     endif
 2081 format(/'** OUTPUT FILE ',3a)
 
c --- write which temporal and spatial sector being used
      if (ntemp .eq. 1) then
         atemp='Annual'
      else if (ntemp .eq. 12) then
         atemp=month(itemp)
      else
         atemp=season2(itemp)
      endif
      
      if (istage .eq. 1 .or. (istage .eq. 3 .and. runprobe)) then 
        write(aermodin,2091)trim(adjustl(atemp)),isecuse
      elseif (larea) then
        write(aermodin,2092)trim(adjustl(atemp)),(isector-1)*5,isecuse
      else
        write(aermodin,2092)trim(adjustl(atemp)),isector*10,isecuse
      endif
 2091 format(/'** Temporal sector: ',a,', spatial sector: ',i2)
 2092 format(/'** Temporal sector: ',a,', flow vector: ',i3,
     + ' degrees, spatial sector: ',i2)  
c --- Write working portion of AERMOD.INP input file ----

      write(aermodin,3000)title
 3000 format(/'CO STARTING'/'   TITLEONE ',a)

c if using a pre-existing BPIP file
      if (lusebpip) then
       write(aermodin,3015)quote1,trim(adjustl(bpipfile)),quote1
 3015  format('   TITLETWO ',3a)
      endif
      
c write modnam and stage
      write(aermodin,3016)trim(adjustl(modnam)),istage     
 3016 format('**',12x,a,1x,'STAGE ',i1)
 
c set initial MODELOPT string
      optstring1='MODELOPT CONC SCREEN'
      if (larea .or. lcirc) then
        areaopt='FASTAREA'
      else
        areaopt=''
      endif
      if (lterrain) then
        teropt=''
      else
        teropt='FLAT'
      endif
!      if (lcap .or. lhor .or. adjustar) then  !remove for final 16216 version
!        betaopt='BETA'
!      else
        betaopt=''
!      endif
      if (lno2) then
        if (lolm) then
          no2opt='OLM'
        else
          no2opt='PVMRM'
        endif
      else
        no2opt=''
      endif
      optstr=trim(adjustl(optstring1))//' '//trim(adjustl(betaopt))//' '
     + //trim(adjustl(teropt))//' '//trim(adjustl(areaopt))//' '//
     + trim(adjustl(no2opt))
      write(aermodin,3020)trim(adjustl(optstr))


c TOXICS option now obsolete, use FASTAREA for area sources
 3020 format(3x,a)

c write averaging time 
      write(aermodin,3030)
 3030 format('   AVERTIME 1')

c write urban population if urban source
      if(lurban) write(aermodin,3040)populat
 3040 format('   URBANOPT',f10.0)

c set POLLUTID    
      if (lno2) then
        pollutid='NO2'
      else
        pollutid='OTHER'
      endif
      
      write(aermodin,3050)trim(adjustl(pollutid))

 3050 format('   POLLUTID',1x,a)

c write NOx chemistry parameters, NO2STACK and OZONEVAL with appropriate units
      if (lno2) then
        write(aermodin,3052)no2stack
        write(aermodin,3053)o3,trim(adjustl(o3units))
      endif
 3052 format('   NO2STACK',1x,f6.4)
 3053 format('   OZONEVAL',1x,f11.4,1x,a)
      if (lflagpole) then
        write(aermodin,3051)flagpole
 3051   format('   FLAGPOLE',f9.2)
      endif
 
      write(aermodin,3060)
 3060 format('   RUNORNOT RUN'/'CO FINISHED')
      if (.not. runscreen) goto 80  !return
      write(aermodin,4000)
 4000 format(/'SO STARTING')


      if(lpoint)format1 = 'POINT   '
      if(lflare)format1 = 'POINT   '
      if(larea)format1 = 'AREA    '
      if(lcirc)format1 = 'AREACIRC'
      if(lvolume)format1 = 'VOLUME  '
      if(lcap) format1='POINTCAP'
      if(lhor) format1='POINTHOR'
  
c write SO PATHWAY information    
      if(lterrain .and. istage .gt. 1)then
c     location
        if(larea)then
          write(aermodin,4010)format1,sw_X,sw_Y,base
        else
          write(aermodin,4011)format1,base
        endif
      else
        if(larea)then
          write(aermodin,4015)format1,sw_X,sw_Y
        else
          write(aermodin,4016)format1
        endif
      endif

 4010 format('   LOCATION SOURCE ',a8,1x,3f10.2)
 4011 format('   LOCATION SOURCE ',a8,'     0.0     0.0',f10.2)

 4015 format('   LOCATION SOURCE ',a8,1x,2f10.2)
 4016 format('   LOCATION SOURCE ',a8,'     0.0     0.0')


c source parameters
      if(lpoint .or. lflare .or. lcap .or. lhor)
     + write(aermodin,4020)emisrate,height,temperature,velocity,diameter

      if(larea)then
         aangle = 0.0
         write(aermodin,4020)emisrate/(xinit*yinit),height,xinit,yinit,
     &                aangle,szinit
      endif

      if(lcirc)then
         nverts = 20
         write(aermodin,4021)emisrate/(3.14259*circrad*circrad),height,
     &                circrad,nverts,szinit
 4021 format('   SRCPARAM SOURCE ',e12.4,2f9.3,I4,f9.3)
      endif

      if(lvolume)
     + write(aermodin,4020)emisrate,height,syinit,szinit

 4020 format('   SRCPARAM SOURCE ',e12.4,5f9.3)


c building information
      if(lbpip) then
      if(istage .gt. 1)then

       call makeformat(bpiphgt(isector),length)
       write(format1,400)length
  400  format('(/''   BUILDHGT SOURCE  36*'',f',i1,'.2)')
       write(aermodin,format1)bpiphgt(isector)

       call makeformat(bpipwid(isector),length)
       write(format1,410)length
  410  format('(''   BUILDWID SOURCE  36*'',f',i1,'.2)')
       write(aermodin,format1)bpipwid(isector)


       call makeformat(bpiplen(isector),length)
       write(format1,420)length
  420  format('(''   BUILDLEN SOURCE  36*'',f',i1,'.2)')
       write(aermodin,format1)bpiplen(isector)

       call makeformat(bpipxad(isector),length)
       write(format1,430)length
  430  format('(''   XBADJ    SOURCE  36*'',f',i1,'.2)')
       write(aermodin,format1)bpipxad(isector)

       call makeformat(bpipyad(isector),length)
       write(format1,440)length
  440  format('(''   YBADJ    SOURCE  36*'',f',i1,'.2)')
       write(aermodin,format1)bpipyad(isector)

      endif
      endif

c identify as urban source if necessary
      if(lurban)then
       write(aermodin,4030)
 4030  format(/'   URBANSRC  SOURCE')
      endif

      write(aermodin,4040)
 4040 format(/'   SRCGROUP  ALL'//'SO FINISHED')

      write(aermodin,5000)
 5000 format(/'RE STARTING')

      call makegrid(isector)                             ! rwb 07214
      if (lstop) return

      write(aermodin,5010)
 5010 format(/'RE FINISHED')



c     call the subroutine findsector to find the appropriate sector met file to use
c      call findsector(isector,isecuse)
c     copy apppropriate sector met files to aerscreen.sfc and aerscreen.pfl
      
      write(t1,'(i2.2)')itemp
      write(s1,'(i2.2)')isecuse
    
      sfcfil='aerscreen_'//t1//'_'//s1//'.sfc'
      pflfil='aerscreen_'//t1//'_'//s1//'.pfl'
      
 
c version 15181, eliminate copy to AERSCREEN.SFC and AERSCREEN.PFL, use
c actual filenames in AERMOD.INP
c      write(metline,100)sfcfil
c 100  format('copy ',a,' AERSCREEN.SFC /y > NUL')
c      call system(metline)
c      write(metline,101)pflfil
c 101  format('copy ',a,' AERSCREEN.PFL /y > NUL')
c      call system(metline)
      
c write meteorological pathway information
c      write(aermodin,6000)profbase
      write(aermodin,6000)trim(adjustl(sfcfil)),trim(adjustl(pflfil)),
     +profbase
 6000 format(/'ME STARTING'/'   SURFFILE  ',a,'  FREE'/
     + '   PROFFILE  ',a,'  FREE'/
     + '   SURFDATA  11111   2010  SCREEN'/
     + '   UAIRDATA  22222   2010  SCREEN'/'   PROFBASE ',
     + f6.1,' METERS')
! 6000 format(/'ME STARTING'/'   SURFFILE  AERSCREEN.SFC  FREE'/
!     + '   PROFFILE  AERSCREEN.PFL  FREE'/
!     + '   SURFDATA  11111   2010  SCREEN'/
!     + '   UAIRDATA  22222   2010  SCREEN'/'   PROFBASE ',
!     + f6.1,' METERS')

c  if area source, write WDROTATE information
      if(larea)then
         write(aermodin,6056) FLOAT(isector-1)*5.
      endif

      write(aermodin,6060)
 6060 format('ME FINISHED')
 6056 format('ME WDROTATE ',f6.1)


c write output pathway information
      write(aermodin,7000)
 7000 format(/'OU STARTING'/'   RECTABLE 1  FIRST'/
     + '   MAXTABLE  ALLAVE  50'/
     + /'   FILEFORM  EXP'/'   RANKFILE  1 10 AERSCREEN.FIL'/
     + '   PLOTFILE  1 ALL  FIRST  AERSCREEN.PLT'/
     +  'OU FINISHED')

  80  close(aermodin)

      return
      end


c -----------------------------------------------------------------------------
      subroutine makeformat(value1,len)
c     calculate a format length for a number based on its value
      implicit none

c value1:   number being checked
c len:      integer length of number 
      real value1
      integer len

      if(value1 .ge. 0.00 .and. value1 .lt. 1.00)len = 3
      if(value1 .ge. 1.00 .and. value1 .lt. 10.00)len = 4
      if(value1 .ge. 10.00 .and. value1 .lt. 100.00)len = 5
      if(value1 .ge. 100.00)len = 6

      if(value1 .lt.  0.00 .and. value1 .gt. -1.00)len = 4
      if(value1 .le. -1.00 .and. value1 .gt. -10.00)len = 5
      if(value1 .le. -10.00 .and. value1 .gt. -100.00)len = 6
      if(value1 .le. -100.00)len = 7

      end


c -----------------------------------------------------------------------------
      subroutine makegrid(isector)                          ! rwb 07214
c --- take out flagpole heights, use FLAGPOLE keyword  JAT 04/29/09
c --- Determine distance and spacing of receptor grid ---
c --- do not process receptors with missing elevation (-9999) JAT 09/03/09
c --- check radius and direction for stage 2 and 3 if terrain to ensure correct JAT 10/06/09
      use main1
      implicit none

c x:        x-coordinate of receptors
c y:        y-coordinate of receptors
c radius:   distance of receptor(i)
c radius1:  distance of receptor(i-1)
c           when i=1 then radius1=xnear
c ter1:     recpetor elevation from AERMAP
c ter2:     receptor hill height from AERMAP
c x1:       receptor x-coordinate read from AERMAP
c y1:       receptor y-coordinate read from AERMAP
c dir1:     direction of receptor based on x1 and y1
c dist1:    distance of receptor from source based on x1 and y1
c ispace:   initial spacing for REFINE receptors
c idist:    distance to model for REFINE receptors
c i:        receptor counter
c idisc:    discrete receptor counter
c isector:  sector being processed
c stagenam: Stage name being processed, PROBE, FLOWSECTOR, or REFINE
c lbad:     logical variable denoting that AERMAP output does not match 
c           receptors being processed.
      real x,y,tgap,radius,ter1,ter2,x1,y1,dir1,dist1,radius1
      integer ispace,idist,i,isector,idisc
      character stagenam*10
      logical lbad
      
      y = 0.0
      nskip=0

c --- Set initial probe receptors ---
c --- add shoreline fumigation ----
      if (istage .eq. 1) then
       stagenam='PROBE'
       write(aermodin,'(a)')'** Fence line receptor'    
       write(aermodin,1001)xnear,y
       write(aermodin,'(a)')'** Automatic receptors'
       do i = 1,numpt
        radius=recrad(i)
!        if(radius .gt. xnear) write(aermodin,1001)radius,y
        if(radius .gt. xnear) then
          write(aermodin,1001)radius,y
        endif
       enddo
       return

      endif   !end probe

c --- istage .eq. 2 -- Runs 36 flow sectors ---
      if (istage .eq. 2) then
       stagenam='FLOWSECTOR'
       write(aermodin,'(a)')'** Fence line receptor'
       if (.not. lterrain) then
         if (larea) then
            x = xnear * cos(FLOAT(isector-1)*5.*0.017453293)
            y = xnear * sin(FLOAT(isector-1)*5.*0.017453293)
         else
          x=xnear
         endif
         write(aermodin,1001)x,y
        else
c        read x and y coordinates to check fence line distance and direction
         read(aermpdat,'(12x,2f13.2,2f11.2)')x1,y1,ter1,ter2
         call checkcoords(x1,y1,xnear,real(isector),dist1,dir1,lbad)
c this shouldn't happen as AERSCREEN checks the ambient distance in oldmap subroutine and if
c different, reruns automatically
         if (lbad) then
            write(*,2000)x1,y1,dist1,xnear,dir1,real(isector*10),
     +      trim(adjustl(stagenam))
            write(ilog,2000)x1,y1,dist1,xnear,dir1,real(isector*10),
     +      trim(adjustl(stagenam))
            lstop=.true.
            return
        endif
         if (ter1 .ne. -9999.0) then
            write(aermodin,1003)xnear,y,ter1,ter2
         else
            nskip=nskip+1
         endif
       endif
       write(aermodin,'(a)')'** Automatic receptors'
       do i = 1,numpt
        radius=recrad(i)
        if(radius .gt. xnear)then                           ! rwb 07214
         if(larea)then
          x = radius * cos(FLOAT(isector-1)*5.*0.017453293)
          y = radius * sin(FLOAT(isector-1)*5.*0.017453293)
          write(aermodin,1001)x,y
         elseif(lterrain)then
cJAT     only read terrain heights from aermap.dat in case stage 2 was previously run
cJAT     without flagpole receptors.  get flagpole heights from user
           read(aermpdat,'(12x,2f13.2,2f11.2)')x1,y1,ter1,ter2
            call checkcoords(x1,y1,radius,real(isector),dist1,dir1,lbad)
c     there should be no problems unless an old AERMAP.LST file used
            if (lbad) then
                write(*,2001)x1,y1,dist1,radius,dir1,real(isector*10),
     +          trim(adjustl(stagenam))
               write(ilog,2001)x1,y1,dist1,radius,dir1,real(isector*10),
     +          trim(adjustl(stagenam))
               lstop=.true.
                return
            endif
           if (ter1 .ne. -9999.0) then
              write(aermodin,1003)radius,y,ter1,ter2
           else
              nskip=nskip+1
           endif
         else
          write(aermodin,1001)radius,y
         endif
        endif                                               ! rwb 07214
       enddo 
       return
       endif

c --- Find maximum as function of distance ---
      if (istage .eq. 3) then
        stagenam='REFINE'
        write(aermodin,'(a)')'** Fence line receptor'
        if (.not. lterrain) then
         if (larea) then
            x = xnear * cos(FLOAT(isector-1)*5.*0.017453293)
            y = xnear * sin(FLOAT(isector-1)*5.*0.017453293)
         else
          x=xnear
         endif
         write(aermodin,1001)x,y
        endif
       ispace = 5
       if(distance(maxtemp,maxsector) .le. 1000.0)ispace = 2
       if(distance(maxtemp,maxsector) .le. 500.0) ispace = 1

       if(gap(2) .lt. 50.0)then
        tgap = 50.0
       else
        tgap = gap(2)
       endif

       refdist = int(distance(maxtemp,maxsector) + tgap*ispace)
     
       idist = int(distance(maxtemp,maxsector) - tgap*ispace)

       if(idist .lt. 1)idist = 1

       
       if(lterrain)then
        call maketerrain()
        open(aermpdat,file='aermap.dat',status='unknown')
        read(aermpdat,'(12x,2f13.2,2f11.2)')x1,y1,ter1,ter2
         call checkcoords(x1,y1,xnear,real(isector),dist1,dir1,lbad)
c     there should be no problems as aermap.dat is generated during processing
         if (lbad) then
            write(*,2000)x1,y1,dist1,xnear,dir1,real(isector*10),
     +      trim(adjustl(stagenam))
            write(ilog,2000)x1,y1,dist1,xnear,dir1,real(isector*10),
     +      trim(adjustl(stagenam))
            lstop=.true.
            return
        endif
        if (ter1 .ne. -9999.0) then
           write(aermodin,1003)xnear,y,ter1,ter2
        else
           nskip=nskip+1
        endif
       endif

       write(aermodin,'(a)')'** Refined receptors'
       do i = idist,refdist,ispace

        radius = real(i)
        if(radius .gt. xnear)then                           ! rwb 07214
         if(larea)then
          x = radius * cos(FLOAT(isector-1)*5.*0.017453293)
          y = radius * sin(FLOAT(isector-1)*5.*0.017453293)
          write(aermodin,1001)x,y
         elseif(lterrain)then
         read(aermpdat,'(12x,2f13.2,2f11.2)')x1,y1,ter1,ter2
         call checkcoords(x1,y1,radius,real(isector),dist1,dir1,lbad)
c     there should be no problems as aermap.dat is generated during processing
         if (lbad) then
            write(*,2001)x1,y1,dist1,radius,dir1,isector*10,
     +      trim(adjustl(stagenam))
            write(ilog,2001)x1,y1,dist1,radius,dir1,isector*10,
     +      trim(adjustl(stagenam))
            lstop=.true.
            return
        endif
          if (ter1 .ne. -9999.0) then
             write(aermodin,1003)radius,y,ter1,ter2
          else
             nskip=nskip+1
          endif
         else
          write(aermodin,1001)radius,y
         endif
        endif                                               ! rwb 07214

       enddo

       if(lterrain)then
        close(aermpdat)
       endif



       return
      endif
  
      
1001  format('   DISCCART ',2f13.2)
1003  format('   DISCCART ',2f13.2,2f11.2)
2000  format(/1x,'Receptor coordinates (x,y): ',2f13.2,/1x,
     + 'distance ',f8.2,/1x,'does not match fence line distance ',f8.2,
     + /1x,'or receptor direction ',f4.0,' degrees'/1x,
     + 'does not match processing direction ',f4.0,' degrees'/1x,
     + 'for stage ',a/1x,'Stopping AERSCREEN')
2001  format(/1x,'Receptor coordinates (x,y): ',2f13.2,/1x,
     + 'distance ',f8.2,/1x,'does not match radius distance ',f8.2,
     + /1x,'or receptor direction ',f4.0,' degrees'/1x,
     + 'does not match processing direction ',f4.0,' degrees'/1x,
     + 'for stage ',a/1x,'Stopping AERSCREEN')

      end

c -----------------------------------------------------------------------------
      subroutine checkbpip(badbpip)
c     subroutine to make sure BPIP input file is correctly formatted
c     use PRIME downwash flag
c     and only one stack
      use main1
      implicit none
      
c titl:       BPIPPRIME input file title
c flag:       process flag
c unts:       units (feet or meters)
c utmp:       UTM coordinates processing flag
c btnv:       building name
c stack:      stack name
c conv:       units conversion
c pnorth:     angle of plant north
c belev:      building elevation
c telev:      tier elevation
c x:          corner x-coordinate
c y:          corner y-coordinate
c selev:      stack elevation
c stackht:    stack height
c xs:         stack x-coordinate
c ys:         stack y-coordinate
c nbuild:     number of buildings
c nb:         building loop counter
c ntier:      number of tiers for a building
c nt:         tier loop counter
c ncorn:      number of corners for a tier
c nc:         corner loop counter
c nstacks:    number of stacks
c ns:         stack loop counter
c badpip:     logical variable denoting if file is badly formatted
      character titl*78,flag*2,unts*10,utmp*4,btnv*8,stack*8
      real conv,pnorth,belev,telev,x,y,selev,stackht,xs,ys
      integer nbuild,nb,ntier,nt,ncorn,nc,nstack,ns
      logical badbpip
      
      badbpip=.false.
      
      open(unit=25,file=bpipfile,status='old')
      
      read(25,*)titl
      read(25,*)flag
      call upcase(flag)
      if (flag .ne. 'P') then
        badbpip=.true.
        badbflag=.true.
      endif
      read(25,*)unts,conv
      read(25,*)utmp,pnorth
      read(25,*)nbuild
     
c     read through buildings, tiers, and corners
      do nb=1,nbuild
        read(25,*)btnv,ntier,belev
        do nt=1,ntier
          read(25,*)ncorn,telev
          do nc=1,ncorn
            read(25,*)x,y
          enddo  
        enddo
      enddo
      read(25,*)nstack
      if (nstack .gt. 1) then
        badbpip=.true.
        badstack=.true.
      endif

      close(25)
      return
      end
c -----------------------------------------------------------------------------
      subroutine checkcoords(x1,y1,xdist,recdir,xdist1,recdir1,lbad)
c     checks distance and direction of AERMAP output against anticipated
c     radius
      use main1
      implicit none
      
c x1:       x-coordinate read from AERMAP
c y1:       y-coordinate read from AERMAP
c xdist:    distance to be checked
c recdir:   direction to be checked
c redir1:   calculated direction based on x1 and y1
c xdist1:   calculated distance based on x1 and y1
c distdiff: percent difference between xdist and xdist1
c recdiff:  percent difference between recdir and recdir1
c corr:     correction factor to apply to direction calculated from x1 and y1
c           accounts for difference between Cartesian grid and geographic grid
c lbad:     logical variable denoting that distdiff or recdiff exceeds 1%
      real x1,y1,xdist,recdir,corr,recdir1,xdist1,distdiff,recdiff
      logical lbad
      lbad=.false.
      
      recdir=recdir*10.0
      corr=0.0
c calculate direction correction factors      
      if (x1 .gt. 0.0 .and. y1 .gt. 0.0) then
        corr=0.0
      else if (x1 .lt. 0.0 .and. y1 .gt. 0.0) then
        corr=360.0
      else
        corr=180.0
      endif

c calculate directions      
      if (x1 .eq. 0.0 .or. y1 .eq. 0.0) then
        if (x1 .eq. 0.0) then
          if (y1 .gt. 0.0) then
            recdir1=360.0   !north
          else
            recdir1=180.0   !south
          endif
        endif
        if (y1 .eq. 0.0) then
            if (x1 .gt. 0.0) then
                recdir1=90.0 !east
            else
                recdir1=270.0   !west
            endif
        endif
      else
        recdir1=real(nint((atan(x1/y1)/degrad)))+corr    !other direction
      endif
      
c calculate distance
      xdist1=sqrt((x1*x1)+(y1*y1)) 
c calculate % differences
      recdiff=abs((recdir1-recdir)/recdir)
      distdiff=abs((xdist1-xdist)/xdist)  
      
      if (recdiff .gt. 0.01 .or. distdiff .gt. 0.01) then
        lbad=.true.
        write(*,*)x1,y1,recdir1,recdir,xdist1,xdist,recdiff,distdiff
      endif
      return
      end
c -----------------------------------------------------------------------------
      subroutine probe()

c --- Locate maximum impact receptor ---

      use main1
      implicit none

c modnam:       name of subroutine 
c atemp:        temporal period being processed, either annual, month name, or season name
c i:            temporal loop counter
c j:            spatial sector loop counter
c isecuse:      spatial roughness sector to use
      character modnam*12,atemp*10
!      character t1*2,s1*2,tempfile*90,templine*150
      
      integer i,j,isecuse

      modnam='PROBE'
      call startstop(modnam,1)
      
      call header()
      write(*,*)' '
      write(*,*)'         ------------  PROBING FOR MAXIMUM ',
     +          'IMPACT ZONE  -------------'


      

c      maxseas = 1
      maxsector = 1
      maxtemp = 1
      
      istage=1
  
c for probe make the direction the sector's first direction  
      do i=1,ntemp
        do j=1,nsec
          if (ntemp .eq. 1) then
            atemp='Annual'
          else if (ntemp .eq. 12) then
            atemp=month(i)
          else
            atemp=season2(i)
          endif
          write(*,10)trim(adjustl(atemp)),j
          write(ilog,10)trim(adjustl(atemp)),j
          call findsector(j,isecuse)
          call makeinput(j,i,isecuse)
          call system("aermod > kil")
          call aermodqa(modnam,isecuse,i)
          call findmax(i,j)
c           write(t1,'(i2.2)')i
c           write(s1,'(i2.2)')j
c           tempfile='AERSCREEN_'//t1//'_'//s1//'.PLT'
c         write(templine,100)tempfile
c  100  format('copy AERSCREEN.PLT ',a)
c       call system(templine)
        end do
      end do
 10   format(/,'Running probe for ',a,' sector ',i2)

      call startstop(modnam,2)
      end


c -----------------------------------------------------------------------------
c      subroutine flowsector(diag)
      subroutine flowsector

c --- Process 36 sectors if terrain or wake is used ---

      use main1
      implicit none
      
c modnam:       name of subroutine 
c atemp:        temporal period being processed, either annual, month name, or season name
c itemp:        temporal loop counter
c isector:      36 radial loop counter or diagonal counter
c is:           spatial roughness sector loop counter for area sources
c isecuse:      spatial roughness sector to use

      character modnam*12,atemp*12
      integer isector,itemp,is,isecuse
!      character t1*2,s1*2,tempfile*90,templine*150,s2*2
      modnam='FLOWSECTOR'
      istage=2
      call startstop(modnam,1)
      

      
      if(lterrain)then
       call maketerrain()
       open(aermpdat,file='aermap.dat',status='unknown')
      endif
      
      call header()
      write(*,*)' '
      write(*,*)'         ------------  DERIVING WORST CASE FLOW ',
     +          'SECTOR  -------------'
      write(*,*)' '
      write(*,*)' '
      
      do itemp=1,ntemp
        write(ilog,*)'********************************************'
        write(ilog,*)' '
        if (isurf .ge. 1 .and. isurf .le. 8) then
            atemp=season2(itemp)
        endif
        if (isurf .eq. 9 .and. ntemp .eq. 12) then
          atemp=month(itemp)
        endif
        if (isurf .eq. 9 .and. ntemp .eq. 4) then
          atemp=season2(itemp)
        endif       
        if (isurf .eq. 0 .or. (isurf .eq. 9 .and. ntemp .eq. 1)) then
          atemp='Annual'
        endif
        write(ilog,*)' Running AERMOD'
        write(ilog,*)'Processing ',trim(adjustl(atemp))
        write(*,*)'Processing ',trim(adjustl(atemp))
        if(larea)then
         do is=1,nsec
            write(*,1001)is
            write(ilog,1001)is
           do isector = 1,numdiag
             write(*,1000) (isector-1)*5
             call findsector(is,isecuse)
             call makeinput(isector,itemp,isecuse)
             write(ilog,1002)isector
             call system("aermod > kil")
             call aermodqa(modnam,isector,itemp)
             call findmax(1,isector)
         
!                write(t1,'(i2.2)')itemp
!               write(s1,'(i2.2)')isector
!               write(s2,'(i2.2)')is
!              tempfile='aerscreen_'//t1//'_'//s1//'_'//s2//'.plt'
!              write(templine,100)tempfile
!               call system(templine)
           enddo
             call maxarea(itemp,is)
         enddo
        else
         do isector = 1,36
          write(*,1000)isector*10
          write(ilog,1002)isector*10
          call findsector(isector,isecuse)
          call makeinput(isector,itemp,isecuse)
          if (lstop) return
          call system("aermod > kil")
          call aermodqa(modnam,isector,itemp)
          call findmax(itemp,isector)
         
c            write(t1,'(i2.2)')itemp
c            write(s1,'(i2.2)')isector
c            tempfile='AERSCREEN_'//t1//'_'//s1//'.PLT'
c            write(templine,100)tempfile
c  100  format('copy AERSCREEN.PLT ',a)
c         call system(templine)
         enddo
        endif
        
        rewind(aermpdat)
      end do  !end itemp loop
      if(lterrain)then
       close(aermpdat)
      endif
 1001 format(/'Processing surface roughness sector ',i2)
 1000 format('+',23x,'Processing wind flow sector ',i3)
 1002 format(/,'*****************************************************'
     +  /'Processing wind flow sector ',i3)
     
      call startstop(modnam,2)
      
      return
      end


c -----------------------------------------------------------------------------
      subroutine findsector(isec,isecuse)
c --- find the appropriate AERSURFACE sector met file to use based on the wind direction
c --- 15181 modified for shoreline direction
      use main1
      implicit none
      
c isec:     sector (1-36) of sector being processed
c isecuse:  spatial roughness sector to use
c i:        spatial roughess sector index
c k:        spatial roughess sector index
c dir:      direction being processed
      integer isec,isecuse,i,k,dir
      
c if only one sector just set to use that sector, otherwise find appopriate sector
      if (nsec .eq. 1) then 
         isecuse=1
         go to 50
      else
        if (lshore .and. isec .eq. 40) then 
            dir=int(shoredir)
            if (dir .ge. 190) then  !get upwind direction
              dir=dir-180
            else
              dir=dir+180
            endif
            if (lshore) write(*,*)'findsector ',shoredir,dir
        else if (istage .eq. 1 .or. larea 
     +    .or. (istage .ge. 3 .and. runprobe)) then
          dir=sector(isec)
        else
          dir=isec*10
!          if (istage .le. 3) dir=isec*10
          if (dir .ge. 190) then  !get upwind direction
             dir=dir-180
          else
             dir=dir+180
          endif
          
        endif
        i=0
 30     i=i+1
        if (i .eq. nsec) then
          k=1
        else
          k=i+1
        endif
        if(sector(i).LT. sector(k)) then
           if(dir .GE. sector(i)  .AND.
     &        dir .LT. sector(k)) then
              isecuse=i
              go to 50
           endif

           if(sector(k).EQ.360.)then
              if(dir .GE. sector(i)  .AND.
     &           dir .LE. sector(k)) then
                 isecuse=i
                 go to 50
              endif
           endif

        else
           if(dir.LT.sector(i).AND.dir.LT.sector(k)  .OR.
     &        dir.GE.sector(i).AND.dir.GT.sector(k)) then
              isecuse=i
              go to 50
           endif

        endif
        
        if (i .lt. nsec) go to 30
      endif
c should not execute this step
      write(*,*)'cannot determine wind direction sector'
      stop
c*****************      
 50   return
      end
c -----------------------------------------------------------------------------
      subroutine maketerrain()

c --- Create AERMAP.INP to derive terrain heights at each receptor ---
c --- version 08128, user is now prompted for the choice to use the same AERMAP receptors for stage 2
c --- if previous run exists
      use main1
      implicit none

c src:        source type string
c line:       read from AERMAP.KIL to get elevations
c string:     character string of elevations read from variable line
c response:   character response to keep or re-run AERMAP
c answer:     1-character substring of response
c modnam:     Subroutine calling maketerrain or if source elevations set to "source"
c j1:         12-character string source id from SOURCELOC.KIL
c j2:         8-character source type from SOURCELOC.KIL
c lexist:     logical variable denoting if aermap.exe exists in folder
c lblank:     logical variable denoting that response is blank
c lbad:       logical variable denoting if response is bad
c bx:         x-coordinate of source, set to 0.0
c by:         y-coordinate of source, set to 0.0
c radius:     distance to model from xnear to probe distance, based on receptor spacing
c x:          receptor x-coordinate
c y:          receptor y-coordinate
c ang:        flow direction angle
c tgap:       spacing used in REFINE spacing calculations
c tbase:      source elevation read from receptor network for x=0,y=0, not used
c srcelev:    source elevation calculated from AERMAP
c diff:       difference between srcelev and user-entered source elevation
c             when AERMAP not used to calculate source elevation
c xdist:      distance to set for DOMAINXY
c xjunk:      x coordinate from SOURCELOC.KIL
C yjunk:      y coordinate from SOURCELOC.KIL
c iang:       integer value of ang
c i:          receptor number loop counter
c ispace:     spacing used in REFINE receptor spacing calculations
c idist:      distance used in REFINE receptor spacing calculations
c iexist:     integer variable to denote if old AERMAP output exists.
c             if old output exists, set to 1, otherwise set to 0
c eof:        end-of-file indicator
      character src*8,line*80,string*15,response*15,answer*1,modnam*12,
     +  j1*12,j2*8
      logical lexist,lblank,lbad
      real bx,by,radius,x,y,ang,tgap,tbase,diff,srcelev,xdist,
     + xjunk,yjunk
      integer iang,i,ispace,idist,iexist,eof
      
      lexist = .false.

      open(aermapin,file='aermap.inp',status='unknown')


c --- Write to AERMAP.INP input file ----

      write(aermapin,1001)
 1001 format(/'CO STARTING')

      write(aermapin,1002)title
! 1002 format('   TITLEONE ',a)
 1002 format('CO TITLEONE ',a)

      write(aermapin,1022)utmx,utmy,probedist,gap(1),gap(2),izone,nada
!1022  format('   TITLETWO ',5f10.1,2i10)
1022  format('CO TITLETWO ',5f10.1,2i10)
      write(aermapin,1023)istage
 1023 format('**',12x,'STAGE ',i1)



c ---  Read and write user provided DEM files ---
       call readDEM()

c calculate distance for DOMAINXY  
c Version 11076 fix bug in xdist
c use probe distance for reference
      xdist=probedist*1.1
!      if (istage .le. 2) then
!        xdist=probedist*1.1
!      else
!        xdist=real(numpt)*1.1
!      endif

       write(aermapin,1003)(utmx-xdist),(utmy-xdist),izone,
     +      (utmx+xdist),(utmy+xdist),izone
     
! 1003 format('   DOMAINXY  ',2(2f12.1,i4))
 1003 format('CO DOMAINXY  ',2(2f12.1,i4))
      write(aermapin,1006)(utmx-utmx),(utmy-utmy),utmx,utmy,izone,nada
! 1006 format('   ANCHORXY  ',2f12.1,4x,2f12.1,2i4)
 1006 format('CO ANCHORXY  ',2f12.1,4x,2f12.1,2i4)     
      write(aermapin,1007)
! 1007 format('   RUNORNOT  RUN')
 1007 format('CO RUNORNOT  RUN')

      write(aermapin,1008)
 1008 format('CO FINISHED')

c     write source input 
      if (istage .eq. 0) then
        modnam='source'
        if(lpoint) then 
           src = 'POINT   '
        else if(lflare) then 
           src = 'POINT   '
        else if(larea) then 
           src = 'AREA    '
        else if(lcirc) then 
           src = 'AREACIRC'
        else if(lvolume) then 
           src = 'VOLUME  '
        else if(lhor) then 
           src = 'POINTHOR'
        else
           src='POINTCAP'
        endif
        write(aermapin,1005)src
        
      endif
 1005 format(/'SO STARTING'/'   LOCATION SOURCE ',a8,' 0.0 0.0',
     +  /'SO FINISHED')    
     
      write(aermapin,1009)
      
 1009 format(/'RE STARTING')

c     center of domain
      bx = 0.0
      by = 0.0
      write(aermapin,'(/''   DISCCART '',2f13.5)')bx,by

c --- Create polar grid for 36 sectors ---
      if(istage .eq. 2)then
        modnam='FLOWSECTOR'
        do iang = 10,360,10
          ang = iang
          call xycalc(ang,x,y,xnear,bx,by)
          write(aermapin,'(''   DISCCART '',2f13.5)')x,y
          do i = 1,numpt
            radius=recrad(i)      
            if(radius .gt. xnear)then
              call xycalc(ang,x,y,radius,bx,by)
              write(aermapin,'(''   DISCCART '',2f13.5)')x,y
            endif
          enddo
        enddo
      endif

c --- Create straight line grid for refining run ---
      if(istage .eq. 3)then
        modnam='REFINE'
        ang = maxsector * 10.
        ispace = 5
        if(distance(maxtemp,maxsector) .le. 1000.0)ispace = 2
        if(distance(maxtemp,maxsector) .le. 500.0) ispace = 1
        if(gap(2) .lt. 50.0)then
          tgap = 50.0
        else
          tgap = gap(2)
        endif
        idist = distance(maxtemp,maxsector) - tgap*ispace
        if(idist .lt. 1)idist = 1
        call xycalc(ang,x,y,xnear,bx,by)
        write(aermapin,'(''   DISCCART '',2f13.5)')x,y
        do i = idist,refdist,ispace
          radius = real(i)
          if(radius .gt. xnear)then
            call xycalc(ang,x,y,radius,bx,by)
            write(aermapin,'(''   DISCCART '',2f13.5)')x,y
          endif
        enddo
      endif

      write(aermapin,1010)
 1010 format(/'RE FINISHED')

      write(aermapin,1011)
 1011 format(/'OU STARTING')

      if (istage .gt. 0) then
        write(aermapin,1012)
      else
        write(aermapin,1015)
        write(aermapin,1016)
      endif
 1012 format( '   RECEPTOR AERMAP.KIL')
 1015 format( '   RECEPTOR DUMMY.KIL')
 1016 format( '   SOURCLOC SOURCELOC.KIL')
 
      write(aermapin,1013)
 1013 format( 'OU FINISHED')


      close(aermapin)

      if (istage .eq. 0)then
       call header()
        write(*,*)' '
        write(*,*)'         -----------  RUNNING AERMAP FOR SOURCE ',
     +          'ELEVATION  ------------'
        write(*,*)' '
        write(*,*)' '
      endif
      
      if(istage .eq. 2)then
       call header()
       write(*,*)' '
       write(*,*)'         -----------  RUNNING AERMAP FOR TERRAIN ',
     +          'HEIGHTS  ------------'
       write(*,*)' '
       write(*,*)' '

c ---  Check for existing aermap.dat file with same inputs ---
c ---  Skip AERMAP run if previous run identical ---
       iexist = 0
       call oldmap(iexist)
       if(iexist .ne. 0) then 
  1      write(*,*)'AERMAP input pararameters match those of previous ',
     &     'AERMAP run'
         write(*,*)'Do you wish to use those parameters or ',
     &     're-run AERMAP? (K/k=keep, R/r=re-run AERMAP)'
         read(*,'(a)')response
         call checkanswer(response,lblank,lbad,1)
         if (lblank .or. lbad) then
          goto 1
         else
          read(response,'(a)')answer
         endif
         call upcase(answer)
         if (answer .eq. 'K') then
          write(ilog,4)'Skipping AERMAP for FLOWSECTOR, ',
     +     'use previous run'
           goto 15
         else if (answer .eq. 'R') then
          write(ilog,4)'Re-running AERMAP for FLOWSECTOR'
         else
           goto 1
         endif
       endif
      endif
 3    format(a1)
 4    format(/,a,/)
!      inquire(file='aermap.exe',exist=lexist)
!      if( .not.lexist )then
!!        write(*,*) 'AERMAP.EXE File Not Found!! Aborting!!'
!        call getexe(4)
!!        stop
!      endif
      write(ilog,*)'***************************************************'
      write(ilog,2)trim(adjustl(modnam))
      call system("aermap ")

!      if (istage .eq. 2) call system("copy AERMAP.OUT AERMAP1.OUT") 
      
      if (istage .eq. 2) then
          infil1='aermap.out'
          outfil3='aermap1.out'
          call aermapout
      endif
      call aermapqa
 2    format(/'Running AERMAP for ',a)
c --- Save Stage2 aermap.kil file for possible re-use in next run ---
!      if(istage .eq. 2)call system("copy aermap.kil aermap.lst > kil")
      if(istage .eq. 2) then
          infil1='aermap.kil'
          outfil3='aermap.lst'
          call aermapout
      endif
  15    if (istage .ne. 0) then
c  -- Find stack base elevation and clean up data file ---
        open(aermpkil,file='aermap.kil',status='unknown')
        open(aermpdat,file='aermap.dat')

c --- Find stack base elevation ---
   20   read(aermpkil,'(a)',end=99)line
        read(line,'(a11)')string

        if(string .ne. '   DISCCART')goto 20

        read(line,'(38x,f11.2)')tbase


c --- Read and write remaining elevations ---
   30   read(aermpkil,'(a)',end=99)line
        read(line,'(a11)')string

        if(string .ne. '   DISCCART')goto 30
        write(aermpdat,'(a)')line
        goto 30

   99   close(aermpkil,status='delete')
        close(aermpdat)
      else
       eof=0
       open(unit=srcloc,file='SOURCELOC.KIL',status='old')
       read(srcloc,200,iostat=eof)line
 
 201   if(eof .eq. 0)then
         if (index(line,'SO LOCATION') .gt. 0) then
!           read(line(60:73),'(f14.2)')srcelev
          read(line(12:80),*)j1,j2,xjunk,yjunk,srcelev
         endif
         read(srcloc,200,iostat=eof)line
         goto 201
       endif
       close(srcloc)
       if (laermsrc) then
          profbase=srcelev
          base=srcelev
          write(ilog,202)profbase
       else
          if (srcelev .eq. 0 .and. profbase .eq. 0) then
            diff=0.0
            write(ilog,203)srcelev,profbase,diff
          elseif (srcelev .ne. 0 .and. profbase .ne. 0) then
             diff=abs(((srcelev-profbase)/profbase)*100.0)
             write(ilog,203)srcelev,profbase,diff
          else
             diff=-999.0
             write(ilog,204)srcelev,profbase
          endif
       endif
      endif
200   format(a80)
202   format(/'Using AERMAP elevation of ',f8.2,' for stack elevation')
203   format(/'AERMAP elevation, ',f8.2,' differs from user entered',
     +  ' elevation, ',f8.2,' by ',f8.2,'%')
204   format(/'AERMAP elevation, ',f8.2,' and user entered elevation',
     +  ' elevation, ',f8.2,' difference cannot be calculated because ',
     + 'value is 0 m')
      end


c -----------------------------------------------------------------------------
      subroutine getnadgrid(lnofiles)
c get path of NAD grid conversion files
c 10/08/09 - now check directory for grid files
      use main1
      implicit none
      
c eof:      end-of-file indicator
c n:        index of 'NADGRIDS' in demlist.txt
c n1:       index of first quotation in nadgrids directory name
c n2:       index of 2nd quotation in nadgrids directory name
c n3:       length of nadpath, eliminating leading and trailing blanks
c l:        length of nadpath1, eliminating leading and trailing blanks
c i:        gfile loop counter
c line:     line read from demlist.txt
c gfile:    list of grid files for NAD conversion
c gfile1:   .las file with nadpath and gfile(i) as prefix
c gfile2:   .los file with nadpath and gfile(i) as prefix
c exist1:   logical variable denoting existence of gfile1
c exist2:   logical variable denoting existence of gfile2
c lnofiles: logical variable denoting that none of the gfiles exist in NADGRIDS folder

      integer eof,n,n1,n2,l,i,n3
      character line*250,gfile(7)*15,gfile1*250,gfile2*250
      logical exist1,exist2,lnofiles
      
      data gfile /'conus', 'hawaii', 'prvi',
     +             'stlrnc', 'stgeorge', 'stpaul', 'alaska'/
     
      open(idemlist,file='DEMlist.txt',status='old')
      nadpath=char(32)
      nadpath1=char(32)
      read(idemlist,10,iostat=eof)line
   5  if (eof .eq. 0) then
         if (index(line,'NADGRIDS') .gt. 0) then
          n=index(line,'NADGRIDS')
          nadpath1=trim(adjustl(line(n+9:n+9+199)))
          l=len_trim(nadpath1)
          if (l .eq. 0) then
            nadpath1='.\'
            nadpath=nadpath1
          else
            n1=index(nadpath1,quote1)
            n2=index(nadpath1(n1+1:200),quote1)
            if (n1 .gt. 0) then
              nadpath=nadpath1(n1+1:n2)
!              nadpath=trim(adjustl(nadpath1(n1+1:n2)))//'\'
            else
              nadpath=trim(adjustl(nadpath1))
!              nadpath=trim(adjustl(nadpath1))//'\'
            endif
            n3=len_trim(nadpath)
            if (nadpath(n3:n3) .ne. '\') 
     +      nadpath=trim(adjustl(nadpath))//'\'         
          endif
!          l=len_trim(nadpath1)
!          if (l .eq. 0) then
!            nadpath1='.\'  
!            nadpath=nadpath1   
!          endif
           lnadgrid=.true.
          goto 20
         endif
         read(idemlist,10,iostat=eof)line
         goto 5
       endif
   10 format(a250)
   20 close(idemlist)
   
c now check for the existence of any of the grid files in the NAD path   
c lnofiles = true means none of the files have been found
c lnofiles = false, at least one set of files exists
      i=1
      lnofiles=.true.
     
     
      
      do while (i .le. 7 .and. lnofiles .and. nadpath .ne. char(32))
        gfile1=' '
        gfile2=' '
!        if (n1 .gt. 0) then !nadpath1 contains quotes
!          gfile1=char(34)//trim(adjustl(nadpath))//'\'//
!     +    trim(adjustl(gfile(i)))//'.las'//char(34)
!          gfile2=char(34)//trim(adjustl(nadpath))//'\'//
!     +    trim(adjustl(gfile(i)))//'.los'//char(34)
!        else
          gfile1=trim(adjustl(nadpath))//'\'//
     +    trim(adjustl(gfile(i)))//'.las'
          gfile2=trim(adjustl(nadpath))//'\'//
     +    trim(adjustl(gfile(i)))//'.los'
!        endif
        inquire(file=gfile1,exist=exist1)
        inquire(file=gfile2,exist=exist2)
        if (exist1 .and. exist2) then 
           lnofiles=.false.
        else
           i=i+1
        endif
      enddo
      
      return
      end
c -----------------------------------------------------------------------------

      subroutine readDEM()

c --- Read and write user provided 7.5 minute data or NED data---
c     allow user to have spaces in filenames if directory path included
c     include elevation units beside filename options are:
c     feet, deci-feet,decifeet,deca-feet,decafeet,meters,deci-meters,
c     decimeters,deca-meters,decameters
c     these are not case sensitive
c     if blank, assummed to be meters.

      use main1
      implicit none

c line:       line read from demlist.txt
c tdem1:      character variable to denote what kind of files to process, D=DEM, N=NED
c atemp:      character string for elevation units
c eof:        integer end-of-file indicator
c icnt:       file count variable
c istart:     integer position in line to start reading terrain file
c istop:      last position in line to read for terrain file
c x:          elevation units character string counter
c iprobe:     integer probe distance (m)
c dexist:     logical variable denoting that demlist.txt exists
c fexist:     logical variable denoting that individual terrain file exists
c fexist1:    logical variable denoting that at least one individual file doesn't exist

      character  line*250,tdem*1,atemp*20
      integer eof,icnt,istart,istop,x,iprobe
      logical dexist,fexist,fexist1

      dexist=.false.
      fexist=.false.
      fexist1=.true.
      if(istage .lt. 3)then
        call header()
        iprobe = probedist
        write(*,1)iprobe
      endif

1     format(/'         ------------------  TERRAIN ',
     +   'INFORMATION  -------------------'/////
     +   ' ***  File "DEMlist.txt" MUST list ALL '/
     +   'DEM files in a ',i5,' m radius!! ***'////
     +   1x,'CURRENT "DEMlist.txt" FILE CONTAINS: ')
     
      inquire(file='DEMlist.txt',exist=dexist)
      if (.not. dexist) then
        write(*,2)
        write(ilog,2)
        stop
      endif
      
 2    format(///' ** The file DEMlist.txt not found in directory...')
 
      open(idemlist,file='DEMlist.txt',status='old')

      icnt = 0
      read(idemlist,*)tdem
!   5  format(a)
      
      call upcase(tdem)
      
      if(tdem .ne. 'D' .and. tdem .ne. 'N')then
        write(*,3)
        stop
      endif
      
3     format(//' ** The first character in the header must be ',
     +          'D or N for DEM or NED file...')

      if (tdem .eq. 'N') then
        write(aermapin,1002)
        dem3='NED'
      else
        write(aermapin,1003)
        dem3='DEM'
      endif
! 1002 format('   DATATYPE  NED')
! 1003 format('   DATATYPE  DEM')
 1002 format('CO DATATYPE  NED')
 1003 format('CO DATATYPE  DEM')
      
    
!       if (lnadgrid) write(aermapin,1005)trim(adjustl(nadpath1))
       if (lnadgrid) write(aermapin,1005)quote1,trim(adjustl(nadpath)),
     + quote1
      
      read(idemlist,10,iostat=eof)line
 25   if (eof .eq. 0) then
        if (index(line,'NADGRIDS') .eq. 0) then
         read(line,'(a1)',err=99)tdem
         if(tdem .ne. ' ' .and. tdem .ne. CHAR(26))then      ! rwb 07214
          icnt = icnt + 1
          istart=1
          if (line(1:1) .eq. quote1) then
            istop=index(line(2:250),quote1)
          else
            istop=index(line(2:250),' ')
          endif
          read(line(istart:istop+1),*)terfils(icnt)
          inquire(file=terfils(icnt),exist=fexist)
          if (.not. fexist) then
            write(ilog,1006)trim(adjustl(terfils(icnt)))
            fexist1=.false.
          endif
          read(line(istop+2:250),'(a)')atemp
          eunits(icnt)=trim(adjustl(atemp))
          do x=1,11
            call upcase(eunits(icnt)(x:x))
          end do
          if(istage .lt. 3)write(*,'(i4,'': '',a70)')icnt,terfils(icnt)
           if (dem3 .eq. 'DEM' )then
            write(aermapin,1001)quote1,trim(adjustl(terfils(icnt))),
     +        quote1
          else
            write(aermapin,1004)quote1,trim(adjustl(terfils(icnt))),
     +        quote1,eunits(icnt)
          endif
         endif
        endif
        read(idemlist,10,iostat=eof)line
        goto 25
      endif
      
  10  format(a250)    
! 1001 format('   DATAFILE  ',a)  
! 1004 format('   DATAFILE  ','"',a,'"',' TIFFDEBUG ',a)     
! 1005 format('   NADGRIDS  ','"',a,'"')
 1001 format('CO DATAFILE  ',3a)  
 1004 format('CO DATAFILE  ',3a,' TIFFDEBUG ',a)     
 1005 format('CO NADGRIDS  ',3a)
 1006 format(/1x,' Terrain file ',a,' does not exist')
      goto 999

   98 write(*,*)' '
      write(*,*)' '
      write(*,*)' '
      write(*,*)' ** The file DEMlist.txt not found in directory...'
      stop

   99 write(*,*)' '
      write(*,*)' '
      if(icnt .eq. 0)then
       write(*,*)' ** No DEM files identified!!! '
       write(*,*)' '
      endif
      stop

  999 close(idemlist)

      ndem=icnt
      
      if(istage .lt. 3)then

       if (.not. fexist1) then
         write(*,*)' One or more terrain files does not exist..'
         write(*,*)' Exiting AERSCREEN'
         write(ilog,*)' One or more terrain files does not exist..'
         write(ilog,*)' Exiting AERSCREEN'
         stop
       endif
       write(*,'(/////'' NOTE: An incomplete list of DEM files will'',
     +               '' cause AERMAP to CRASH ...'')')

       write(*,'(//'' Press <Enter> to continue processing'',
     +            '' or <Ctrl-C> to abort... ''\)')

      endif
      return

      end

c -----------------------------------------------------------------------------
      subroutine oldmap(iexist)
c     version 08128, add checks for number of DEM files and number of receptors
c     10/06/09 check all receptors for distance and directions
      use main1
      
      implicit none
      
c x:        source UTM x-coordinate read from aermap.lst
c y:        source UTM y-coordinate read from aermap.lst
c tprobe:   probe distance (m) read from aermap.lst
c tgap:     receptor spacing array read from aermap.lst
c xnear1:   x-coordinate of ambient distance from aermap.lst
c ynear1:   y-coordinate of ambient distance from aermap.lst
c fence:    ambient distance calculated from xnear1 and ynear1
c i1:       radius for receptor i
c x1:       receptor x-coordinate read from aermap.lst
c y1:       receptor y-coordinate read from aermap.lst
c dist1:    receptor distance based on x1 and y1
c dir1:     receptor direction based on x1 and y1
c radius:   receptor distances array
c jzone:    UTM zone read from aermap.lst
c jnada:    NAD datum read from aermap.lst
c idem:     number of terrain files processed, read from aermap.lst
c nrec:     number of receptors processed in AERMAP, read from aermap.lst
c eof:      end of file indicator
c ifound:   indicator that current terrain file matches a file from aermap1.out
c k:        file loop counter
c in:       index of DATATYPE in AERMAP1.OUT
c numpt2:   number of points to process per radial
c i:        counter
c ind:      index of TIFFDEBUG in AERMAP1.OUT
c ii:       equal to numpt2 or numpt2+1
c i2:       array counter
c idir:     radial direction
c inquote1: index of first quotation on datafile
c inquote1: index of second quotation on datafile
c line:     line read from aermap1.out
c tfile:    terrain file read from aermap1.out
c dem3a:    terrain file type read from line with DATAYTPE from AERMAP1.OUT
c eun:      elevation units corresponding to file tfile
c lnear:    logical variable denoting that the ambient distance is part of the
c           regular receptor network, i.e. 25 m or 50 m
c lrun:     logical variable denoting if a rerun of AERMAP is needed
c ldiff:    logical variable denoting that files are different
c lexist:   logical variable denoting that AERMAP1.OUT exists
c lbad:     logical variable denoting that coordinates don't match 

      real x,y,tprobe,tgap(2),fence,diff,xnear1,ynear1,i1,x1,y1,dist1,
     +  dir1
      
      real, allocatable, dimension(:) :: radius
      
      integer jzone,iexist,jnada,idem,numpt1,nrec,eof,ifound,k,in,
     + numpt2,i,ind,ii,i2,idir,inquote1,inquote2
     
      character line*250,tfile*200,dem3a*3,eun*11
      logical lnear,lrun,ldiff,lexist,lbad
 
      lrun=.false.
      ldiff=.false.
      lbad=.false.
      ifound=0
c     subtract the number of receptors that are less than the fence line distance
c     i.e. if ambient distance is 50 m, subtract 1 for each receptor distance less than
c     the ambient.  If 200 points at 25 m spacing with 50 m ambient, subtract 1
c     from numpt because 25 m not included
c     if the ambient distance is one of the regular distances, set lnear to true
      numpt2=numpt
      lnear=.false.
      do i=1,numpt
        i1=recrad(i)
        if (i1 .lt. xnear) numpt2=numpt2-1
        if (xnear .eq. i1) lnear=.true.
      enddo
      
c write values to radius array for further analysis of receptor elevations in aermap.lst
      if (lnear) then
       allocate(radius(numpt2))
       ii=numpt2
      else
       allocate(radius(numpt2+1))
       ii=numpt2+1
      endif
      
      radius(1)=xnear
      i2=2
     

      do i=1,numpt
        i1=recrad(i)
        if (i1 .gt. xnear) then
          radius(i2)=i1
          i2=i2+1
        endif
      enddo
      
c     add 1 for x=0,y=0     
      numpt1=(numpt2*36)+1
c     add 1 receptor to each direction if the ambient receptor is not part of the regular network
      if (.not. lnear) numpt1=numpt1+36
      
      open(aermplst,file="aermap.lst",status="old",err=99)

c     read the x and y coordinates of the source, probe distance (m), receptor spacing,
c     UTM zone, NAD, number of elevation files, and total number of receptors (all 36 radials)
      read(aermplst,101)x,y,tprobe,tgap(1),tgap(2),jzone,jnada,idem,nrec
c 101  format(///,3x,4f10.1,2i10/14x,i7,/14x,i7)
 101  format(///,3x,5f10.1,2i10/14x,i7,/14x,i7)
c read the x and y coordinates of the ambient distance and get difference
c between it and the user defined ambient distance
c because the use of user-defined elevation units can change the position of lines,
c search for the ELEVUNIT line

200   read(aermplst,'(a)')line
      if (index(line,'RE ELEVUNIT') .gt. 0) then
        read(aermplst,'(/12x,2f13.2)')xnear1,ynear1
        fence=sqrt((xnear1*xnear1)+(ynear1*ynear1))
        diff=abs((fence-xnear)/xnear)
        goto 201
      else
        goto 200
      endif

c     compare various parameters
c     if any differ, set lrun to true, meaning AERMAP will be run for FLOWSECTOR 
c     compare old x and y coordinates (x and y) to x and y coordinates from current run (utmx,utmy)  
 201  if(x .ne. utmx) then 
         write(*,10)utmx,x
         write(ilog,10)utmx,x
         lrun=.true.
      endif
      if(y .ne. utmy) then 
         write(*,15)utmy,y
         write(ilog,15)utmy,y
         lrun=.true.
      endif

c     compare old probe distance to current probe distance
      if(tprobe .ne. probedist) then
         write(*,20)probedist,tprobe
         write(ilog,20)probedist,tprobe
         lrun=.true.
      endif

c     compare old receptor spacing to current receptor spacing
      if(tgap(1) .ne. gap(1) .or. tgap(2) .ne. gap(2)) then 
         write(*,25)gap,tgap
         write(ilog,25)gap,tgap
         lrun=.true.
      endif

c     compare old UTM zone to current UTM zone
      if(jzone .ne. izone) then
         write(*,30)izone,jzone
         write(ilog,30)izone,jzone
         lrun=.true.
      endif

c     compare old NAD to current NAD
      if(jnada .ne. nada) then 
         write(*,35)nada,jnada
         write(ilog,35)nada,jnada
         lrun=.true.
      endif

c     compare old number of elevation files to new number of elevation files      
      if(ndem .ne. idem) then 
         write(*,40)ndem,idem
         write(ilog,40)ndem,idem
         lrun=.true.
      endif

c     compare old number of receptors to new number of receptors
      if(nrec .ne. numpt1) then
         write(*,45)numpt1,nrec
         write(ilog,45)numpt1,nrec
         lrun=.true.
      endif
 
c     if difference between old fence line distance and new ambient distance is more than 1%
c     rerun
      if (diff .gt. 0.01) then 
         write(*,50)xnear,fence,diff*100
         write(ilog,50)xnear,fence,diff*100
         lrun=.true.
      endif
      
c     check terrain input filenames type and names from older AERMAP.OUT file
c     if file doesn't exist, set lrun to true and rerun AERMAP
      eof=0
      inquire(file='AERMAP1.OUT',exist=lexist)
      if (.not. lexist) then
        write(*,46)
        write(ilog,46)
        lrun=.true.
      else
        open(unit=aermpout,file='AERMAP1.OUT',status='old')
        read(aermpout,70,iostat=eof)line
 75     if (eof .eq. 0) then
          if (index(line,'CO DATATYPE') .gt. 0) then  !get datatype, NED or DEM
            in=index(line,'CO DATATYPE')
!            dem3a=line(in+10:in+12)
            dem3a=line(in+13:in+15)
            if (dem3 .ne. dem3a) then
              write(*,52)dem3,dem3a
              write(ilog,52)dem3,dem3a
              ldiff=.true.
            endif
          endif 
          if (index(line,'CO DATAFILE') .gt. 0) then
           ind=index(line,'TIFFDEBUG')  !if a NED file, check elevation units
           if (ind .gt. 0) then
!            tfile=line(14:ind-2)  !get filename
            tfile=line(15:ind-3)  !get filename without quotes
            eun=line(ind+9:ind+20) !get elevation units
           else
            inquote1=index(line,quote1)
            inquote2=index(line(inquote1+1:250),quote1)
            tfile=line(inquote1+1:inquote1+inquote2-1)
c            tfile=line(14:214) !get filename           
            eun=char(32) !blank
           endif
           k=1
           do while ((tfile .ne. terfils(k) .or. eun .ne. eunits(k)) 
     +      .and. k .le. ndem) 
             k=k+1
           end do
      
           if (trim(adjustl(tfile)) .eq. trim(adjustl(terfils(k))) .and.
     +      trim(adjustl(eun)) .eq. trim(adjustl(eunits(k)))) then
             ifound=1
           else
             ifound=0
           endif
           if (ifound .eq. 0)then  !different filenames or elevation units
             write(*,53)trim(adjustl(tfile)),trim(adjustl(terfils(k))),
     +       trim(adjustl(eun)),trim(adjustl(eunits(k)))
             write(ilog,53)trim(adjustl(tfile)),
     +       trim(adjustl(terfils(k))),trim(adjustl(eun)),
     +       trim(adjustl(eunits(k)))
             ldiff=.true.
           endif
          endif
          read(aermpout,70,iostat=eof)line
          go to 75
        endif
        close(aermpout)
      endif
      
c     check the receptors in AERMAP.lst only if lrun is false
c     make sure that receptor coordinates match the anticipated spacing for each 10 degree radial
      if (.not. lrun) then
c     go back one record to first ambient receptor
      backspace(aermplst)
      eof=0
      idir=1
      i2=0
      read(aermplst,95,iostat=eof)x1,y1
  96  if(eof .eq. 0) then
        if (i2 .eq. ii) then
          idir=idir+1
          i2=1
        else
          i2=i2+1
        endif
c     check coordinates
        call checkcoords(x1,y1,radius(i2),real(idir),dist1,dir1,lbad)
c     if distance or direction do not match
c     stop reading file and set lrun to true
        if (lbad) then
           lrun=.true.
          write(*,51)x1,y1,dist1,radius(i2),dir1,real(idir*10)
          eof=1
        else
          read(aermplst,95,iostat=eof)x1,y1
          goto 96
        endif
      endif
      endif
95    format(12x,2f13.2)

98     if (lrun .or. ldiff) goto 99 !will need to rerun AERMAP
           
 10   format(/1x,'Source x-coordinate ',f10.2,' does not match ',
     +  'x-coordinate ',f10.2,' from previous AERMAP run'/)
 15   format(1x,'Source y-coordinate ',f10.2,' does not match ',
     +  'y-coordinate ',f10.2,' from previous AERMAP run'/)
 20   format(1x,'Probe distance ',f9.2,
     +  ' does not match probe distance ',f9.2,
     +  ' from previous AERMAP run'/)
 25   format(1x,'Receptor gaps ',f5.2,1x,f5.2,
     +  ' do not match receptor gaps ',f5.2,1x,f5.2,
     +  ' from previous AERMAP run'/)
 30   format(1x,'UTM zone ',i3,' does not match UTM zone ',i3,
     +  ' from previous AERMAP run'/)
 35   format(1x,'NAD ',i2,' does not match NAD ',i2,' from AERMAP'/)
 40   format(1x,'Number of input files ',i3,
     +  ' does not match number of ','input files ',i3,
     +  'from previous AERMAP run'/)
 45   format(1x,'Number of receptors, ',i5,
     +   ' does not match number of ','receptors, ',i5,
     +   ' from previous AERMAP run'/)
 46   format(1x,'List of terrain files from previous AERMAP run ',
     +  'not found'/)
 50   format(1x,'Ambient distance ',f6.2,
     +  ' is more than 1% different ','than Ambient distance ',f6.2,
     +  ' from previous AERMAP run ','with a diff. of ',g11.4/)
 51     format(1x,'Receptor coordinates (x,y): ',2f13.2,/1x,
     + 'distance ',f8.2,/1x,'does not match radius distance ',f8.2,
     + /1x,'or receptor direction ',f4.0,' degrees'/1x,
     + 'does not match processing direction ',f4.0,' degrees'/)   
 52   format(1x,'Data type for current run: ',a,
     +  ' does not match data type from previous AERMAP run: ',a/)
 53   format(1x,'At least one filename or units differs from ',
     +        'last AERMAP run'/4(1x,a)/)
     
 70   format(a120)
     
      close(aermplst)

!      call system("copy aermap.lst aermap.kil > nul")
      infil1='aermap.lst'
      outfil3='aermap.kil'
      call aermapout
      iexist = 1

      return
   99 close(aermplst,status="delete")
      
      end
c -----------------------------------------------------------------------------
      subroutine findmax(itemp,isector)

c --- Find maximum inpact from the AERSCREEN.FIL post-processing file ---
c JAT 072308 read concentration field as character and if contains an asterisk
c read AERMOD.OUT for overall H1H or AERSCREEN.BIN binary file for all receptors
      use main1
      implicit none
      
c line:     header lines read from AERSCREEN.FIL
c temp:     first 2 characters of line, should be '**'
c agrp:     source group read from AERCREEN.FIL
c form:     format of data records in AERSCREEN.FIL
c netid:    receptor network identifier
c ave:      averaging period
c hival:    rank read from AERSCREEN.PLT
c v1:       AERMOD version #
c xrec:     receptor x-coordinate
c yrec:     receptor y-coordinate
c r:        distance of receptor from source
c c:        concentration
c zh:       hill height
c zflag:    flagpole height
c ze:       receptor elevation
c isector:  direction sector being processed
c itemp:    temporal period being processed
c ir:       receptor number
c irank:    rank read from AERSCREEN.FIL
c idate:    date read from AERSCREEN.PLT
c eof:      end-of-file indicator
c iform:    index of "FORMAT" in header line
c ip1:     index of left parenthesis on 1st line of AERSCREEN.FIL
c ip2:     index of right parenthesis on 1st line of AERSCREEN.FIL
      character line*200,temp*2,agrp*8,form*100,netid*8,ave*5,hival*4,
     + v1*6 !changed to 6 characters for AERMOD 16216r
      real xrec,yrec,r,c,zh,zflag,ze
      integer isector,itemp,ir,irank,idate,eof,iform,ip1,ip2
      version = '     '
      eof=0
      
      open(ascrnfil,file='aerscreen.fil',status='old')

c     get AERMOD version number
      read(ascrnfil,'(a)',end=99)line
      ip1=index(line,'(')
      ip2=index(line,')')
      read(line(ip1+1:ip2-1),*)v1
      version=trim(adjustl(v1))

!      read(ascrnfil,'(10x,a5)',end=99)version

   10 read(ascrnfil,'(a)',end=99)line
      read(line,'(a2)')temp
      if(temp .ne. '  ') then
          if (index(line,'FORMAT') .gt. 0) then  !get format of data
            iform=index(line,'FORMAT:')
            form=trim(adjustl(line(iform+7:120)))
          endif
          goto 10
      endif
      if (larea) then
          read(line,form)irank,c,idate,xrec,yrec,ze,zh,zflag,agrp
          if (irank .eq. 1) then 
             aconc(isector)=c
             adist(isector) = SQRT(xrec*xrec + yrec*yrec)
             aterr(isector)=ze
          endif
      else
        read(line,form)irank,c,idate,xrec,yrec,ze,zh,zflag,agrp
        if (irank .eq. 1) then
           highconc(itemp,isector)=c
           terrhgts(itemp,isector)=ze
           distance(itemp,isector) = SQRT(xrec*xrec + yrec*yrec)
        endif       
      endif
      
   99 continue

      close(ascrnfil)
c read H1H for all receptors
      ir=1
      open(ascrnplt,file='aerscreen.plt',status='old')
      read(ascrnplt,'(a)',iostat=eof)line
 12   if (eof .eq. 0) then
        read(line,'(a1)')temp
        if (temp(1:1) .eq. '*') then
          if (index(line,'FORMAT') .gt. 0) then
            iform=index(line,'FORMAT:')
            form=trim(adjustl(line(iform+7:120))) 
          endif 
        else
          if (larea) then
            read(line,form)xrec,yrec,aconc1(isector,ir),
     +      aterr1(isector,ir),zh,zflag,ave,agrp,hival,netid,idate
            write(adate(isector,ir),'(i8)')idate
            adist1(isector,ir)=SQRT(xrec*xrec + yrec*yrec)
          else
            read(line,form)xrec,yrec,conc1(itemp,isector,ir),
     +      terr1(itemp,isector,ir),zh,zflag,ave,agrp,hival,netid,idate
            r=SQRT(xrec*xrec + yrec*yrec)
            recdist(itemp,isector,ir)=r
            write(date(itemp,isector,ir),'(i8)')idate
          endif
        ir=ir+1
        endif
        read(ascrnplt,'(a)',iostat=eof)line
        go to 12
        
      endif
      
      irec=ir-1
      
      close(ascrnplt)
  
      end


c -----------------------------------------------------------------------------
      subroutine maxarea(itemp,is)
c     find maximum concentration for a temporal period and surface roughness sector
      use main1
 
c high:     highest concentration to compare against
c isector:  diagonal loop counter
c itemp:    temporal period being processed
c maxd:     diagonal associated with maximum concentration
c is:       surface roughness sector being processed
c ir:       receptor loop counter
      real high
      integer isector,itemp,maxd,is,ir
      
      high = 0.0
      
c      get max concentration across diagonals for temporal period itemp
c      and surface roughness sector is

       do isector=1,numdiag
          if(aconc(isector) .gt. high)then
           high = aconc(isector)
           maxd=isector
          endif
       enddo
      
c     assign values to arrays
      highconc(itemp,is)=high
      distance(itemp,is)=adist(maxd)
      terrhgts(itemp,is)=aterr(maxd)
      maxdiag(itemp,is)=maxd
      
      aconc=0.0
      adist=0.0
      aterr=0.0
      
c     get maximum by receptor
      do ir=1,irec
        high=0.0
        do isector=1,numdiag
          aconc2(itemp,is,isector,ir)=aconc1(isector,ir)
          diag2(itemp,is,isector,ir)=(isector-1)*5
          if (aconc1(isector,ir) .gt. high) then
             high=aconc1(isector,ir)
             maxd=isector
          endif
        end do
        conc1(itemp,is,ir)=high
        recdist(itemp,is,ir)=adist1(maxd,ir)
        terr1(itemp,is,ir)=aterr1(maxd,ir)
        date(itemp,is,ir)=adate(maxd,ir)
        maxdiag1(itemp,is,ir)=maxd
      end do
      aconc1=0
      adist1=0
      aterr1=0
      adate=' '
      return
      end
c ------------------------------------------------------
      subroutine refine()

c --- Find maximum impact as a function of distance ---
      use main1
      implicit none

c modnam:   subroutine name
c high:     highest concentration found
c high1:    highest concentration by sector
c isector:  sector being processed.  This can be a surface roughness sector
c           or one of 36 radials
c itemp:    temporal period being processed
c isec1:    number of sectors to process.  If based on surface roughness sectors
c           isec1=nsec or if based on 36 radials when processing terrain and/or 
c           downwash isec1=36

      character modnam*12
      real high,high1
      integer isector,itemp,isec1

      modnam='REFINE'
      istage=3
      call startstop(modnam,1)
     
      call header()
      write(*,*)' '
      write(*,*)'        --------------------  REFINING IMPACTS  ',
     +          '--------------------'

      write(*,*)' '
      write(*,*)' '

      
c --- Run automated receptor points ---
      
      high = 0.0
      if (lbpip .or. lterrain) then
        isec1=36
      else
         isec1=nsec
      endif

c get overall worst case

      do itemp=1,ntemp
        do isector=1,isec1
         if(highconc(itemp,isector) .gt. high)then
          high = highconc(itemp,isector)
          maxtemp=itemp
          maxsector = isector
         endif
        enddo
      enddo

c     get worst case by sector
      do isector=1,isec1
        high1=0.0
        do itemp=1,ntemp
            if (highconc(itemp,isector) .gt. high1) then
                high1=highconc(itemp,isector)
                flowmax(isector)=highconc(itemp,isector)
                flowmaxtemp(isector)=itemp
            endif
        enddo
      enddo    
     
      
c -- find the max sector's aersurface sector if using multiple aersurface sectors 
c -- this will be needed for the output file generated in subroutine output
      if (isurf .eq. 9 .and. nsec .gt. 1) then
         call findsector(maxsector,isecaer)
      else
         isecaer=1
      endif

c --- Find Maximum as a function of distance  ---

      istage = 3
      if (larea) then
        call makeinput(maxdiag(maxtemp,maxsector),maxtemp,isecaer)
        if (lstop) return
      else
        call makeinput(maxsector,maxtemp,isecaer)
        if (lstop) return
      endif
      call system("aermod > kil")
      
      call aermodqa(modnam,maxsector,maxtemp)
      call startstop(modnam,2)
      end

c -----------------------------------------------------------------------------
      subroutine fumigate()
c     calculate concentration and distance due to inversion break-up fumigation for
c     each hour

      use main1
      implicit none
c     ihour       hour of fumigation hours being processed
c     modnam      subroutine name
      integer ihour
      character modnam*12
     
      modnam='FUMIGATE'
      call startstop(modnam,1)
      
      call header()
      write(*,*)' '
      write(*,*)'        --------------------  BREAK-UP FUMIGATION  ',
     +          '--------------------'

      write(*,*)' '
      write(*,*)' '
      
      write(*,10)
      write(ilog,10)
      invchi=0.0
      invx=0.0
      do ihour=1,fumhours
          call invmax(ihour)
      enddo

 10   format(/1x,'Calculating maximum distance of fumigation ',
     +'concentration')
      
      return
      end
c -----------------------------------------------------------------------------
      subroutine invmax(h)
c     calculate inversion break-up fumigation concentration and calculate overall max
c     based on SCREEN3 fumigation calculations
      use main1
      implicit none
c i               iteration loop counter
c h               hour (passed from fumigate routine)
c i1              met array counter
c he              effective stack height (equal to fumdata(h,16)
c sy1             ambient sigma-y
c sz1             ambient sigma-z
c sy              sy1 + buoyancy sigma-y
c sz              sz1 + buoyancy sigma-z
c sigmay          ambient sigma-y function
c sigmaz          ambient sigma-z function
c x1              max concentration for the inversion break-up concentration for iteration i
c chi             inversion break-up concentration
c fumx1           old fumx value
c u               stack top wind speed, 2.5 m/s
      integer i,h,i1
      real he,sy1,sy,sz1,sz,u,sigmay,sigmaz,x1,chi,fumx1
      u=2.5
      he=fumdata(h,16)
      fumx=5000.0  !set initial distance to 5 km
      if (ldebug) then 
          write(ascrnout5,100)int(fumdata(h,28)),height,fumdata(h,29),
     +    he,fumx/1000.,int(fumdata(h,26)),int(fumdata(h,27)),
     +    (fumdata(h,i1),i1=1,11),(fumdata(h,i1),i1=12,14),
     +     fumdata(h,17),fumdata(h,25),(fumdata(h,i1),i1=18,24)
      endif
      
      do i=1,20
          sy1=sigmay(h)  !calculate ambient sigma-y
          sz1=sigmaz(h)  !calculate ambient sigma-z
          sy=sqrt(sy1*sy1+fumdata(h,23)*fumdata(h,23)) !add buoyancy 
          sz=sqrt(sz1*sz1+fumdata(h,24)*fumdata(h,24)) !add buoancy
          X1 = U*0.1511*(he+2.*SZ-height)*0.5*(height+HE+2.*SZ) !calculate distance
          if (ldebug) write(ascrnout5,101)i,sy,sz,X1/1000.
          if (abs(x1-fumx) .lt. 10.) then
              fumx=x1
              if (ldebug) write(ascrnout5,102)i
              goto 5
          else
              fumx=x1
          endif
          IF (X1 .LT. 100.) THEN
              if (ldebug) write(ascrnout5,103)
              fumx=100.
              goto 5
         END IF
      enddo
      fumx1=fumx
      fumx=(x1+fumx)*0.5
      if (ldebug) write(ascrnout5,104)x1,fumx1/1000.,fumx/1000.
  5   sy1=sigmay(h)
      sz1=sigmaz(h)
      sy=sqrt(sy1*sy1+fumdata(h,23)*fumdata(h,23))
      sz=sqrt(sz1*sz1+fumdata(h,24)*fumdata(h,24))
      CHI = emisrate/(2.50663*U*(SY+HE/8.)*(HE+2.*SZ))*1.0E06

      if (ldebug) write(ascrnout5,105)sy,sz,chi
      if (chi .gt. invchi) then  !reset max values
          invchi=chi
          invx=fumx
          invtemp=int(fumdata(h,26))
          invsec=int(fumdata(h,27))
          invdate=int(fumdata(h,28))
c         version 21112, if concentration distance < 2 km, reset to 0
          if (fumx .lt. 2000) invchi=0.0
          if (ldebug) then
              if (fumx .lt. 2000) write(ascrnout5,'(a,f5.3,a)')
     +        ' DISTANCE ',fumx/1000.,' < 2 KM, RESET CHI  TO 0'
              write(ascrnout5,106)invchi,invx/1000.,    
     +        int(fumdata(h,28)),invtemp,invsec
          endif
      endif
      if (ldebug .and. h .eq. fumhours) write(ascrnout5,107) invchi,
     +        invx/1000.,invdate,invtemp,invsec
 100  format(1x,'#################################################',
     +'#####################################'/1x,
     +'INVERSION BREAK-UP FUMIGATION CALCULATIONS FOR ',
     +I8.8,//,1x,'Stack height:',f8.2,' m',/1x,
     +'Stack height wind speed 2.5 m'/1x,
     +'Stack-tip downwash adjusted stack height:',f8.2,' m',/1x,
     + 'Effective stack height:',f8.2,' m',/1x,
     + 'Initial distance:',f11.3,' km'/1x,
     + 'temporal period:',i3/1x,'spatial sector:',i3,//1x,
     + 'BASE METEOROLOGICAL VARIABLES'
     + /5x,'H0     U*     W*  DT/DZ ZICNV ZIMCH  M-O LEN    ',
     +           'Z0  BOWEN ALBEDO  REF WS'/
     + '  - - - - - - - - - - - - - - - - - - - - - - - - -',
     +       ' - - - - - - - - - - - - -'/f7.2,3f7.3,2f6.0,f9.1,f6.3,
     +    2f7.2,f8.2//
     + '     HT  REF TA     HT'/
     + ' - - - - - - - - - - -',/f7.1,f8.1,f7.1//1x,'OTHER VARIABLES'//
     +'   UMIX       UEFF  SIG-V  SIG-W   THETA  DT/DZ_2    BV    ',
     +'SIG-YB  SIGZ-B'/
     +' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - ',
     +'- - - - - -'/1x,2(f8.1),2(f8.2),f8.1,2(f8.4)2(f8.1))  !,9(f8.1))
 
 101  format(/1x,'Iteration ',i2//,1x,'Sigma-y: ',e9.3,' m'/1x,
     +'Sigma-z: ',e9.3,' m'/1x,'Distance: ',f11.3,' km')
 102  format(/1x,'Convergence found at iteration ',i2)
 103  format(/1x,'Resetting distance to 100 m')
 104  format(/1x,'No convergence...distance',f11.3,/1x,
     +'is average of last two distances',2(1x,f11.3))
 105  format(/1x,'Sigma-y: ',e9.3,' m'/1x,'Sigma-z: ',e9.3,' m'/1x,
     +'Concentration: ',e9.3/)
 106  format(1x,'NEW MAX CONCENTRATION OF ',e9.3,' AT ',f11.3,
     + ' KM FOR DATE ',i8.8/1x,'temporal period:',i3/1x,
     +'spatial sector:',i3/)
 107  format(1x,'FINAL MAX CONCENTRATION OF ',e9.3,' AT ',f11.3,
     + ' KM FOR DATE ',i8.8/1x,'temporal period:',i3/1x,
     +'spatial sector:',i3/)
      return
      end
c -----------------------------------------------------------------------------
      subroutine shoreline()
c     calculate shoreline fumigation concentrations for each hour

      use main1
      implicit none
c ihour       hour of fumigation hours being processed
c isecuse     spatial sector to use for optional specific direction to shoreline
c ltibl1      logical variable denoting if specific hour's plume is below the TIBL
c runshore    logical variable denoting that shoremax will be run
c lsector     logical variable denoting that a specific spatial sector is run
c maxhe       maximum effective stack height across fumigation hours
c x0          difference between (maxhe/6.)**2 and shoreline
c tiblht      TIBL height based on shoreline distance
c hedist      (maxhe/6.)**2      
      integer ihour,isecuse
      logical ltibl1,runshore,lsector
      real maxhe,x0,tiblht,hedist
      

      isecuse=0
      shorex=0.0
      shorechi=0.0
      ltibl=.false.
  
      if (ldebug) write(ascrnout5,100)height
c     runshore determines if shoreline fumigation is to be run
c     initially set to false
      runshore=.false.
c     determine spatial sector to use
      if (shoredir .ge. 0) then
          call findsector(40,isecuse)  !look for spatial sector to use
          lsector=.true.
      else
          runshore=.true.  !shoreline fumigation will proceeed since no specific direction specified
          lsector=.false.
      endif
c     determine if all of the hours will be below the TIBL by checking the maximum
c     effective plume height against TIBL
      maxhe=0.0
      do ihour=1,fumhours
          if (.not. lsector) then
              if (fumdata(ihour,16) .gt. maxhe) maxhe=fumdata(ihour,16)
          else
              if (isecuse .eq. int(fumdata(ihour,27))) then
                  runshore=.true.  !at least one sector is in fumigation meteorological data
                  if (fumdata(ihour,16) .gt. maxhe) maxhe=
     +            fumdata(ihour,16)
              endif
          endif
      enddo
      if (runshore) then   !check for TIBL
          x0=(maxhe/6.)**2.-shordist
          if (ldebug) then
              tiblht=sqrt(shordist)*6.
              hedist=(maxhe/6.)**2.
              write(ascrnout5,30)maxhe,x0,tiblht,shordist
          endif 
          if (x0 .le. 0.0) then
              write(*,10)shordist
              write(ilog,10)shordist
              if (ldebug) write(ascrnout5,25)
              ltibl=.true.
          endif
          if (.not. ltibl) then
              do ihour=1,fumhours
                  ltibl1=.false.
                  if (.not. lsector .or. (lsector .and. isecuse .eq. 
     +            int(fumdata(ihour,27)))) then
c                 determine if the plume is below TIBL at shoreline distance
                  call tibl(ihour,x0,ltibl1)
                      if (.not. ltibl1) then
                          call shoremax(ihour,x0)
                      else
                          if (ldebug) write(ascrnout5,20)
     +                    int(fumdata(ihour,28)),fumdata(ihour,16),
     +                    int(fumdata(ihour,26)),int(fumdata(ihour,27))
                      endif
                  endif
              enddo
              if (ldebug .and. ihour .eq. fumhours) write(ascrnout5,107)
     +        shorechi,shorex/1000.,shordate,stemp,ssec
          endif
      else
          write(*,15)int(shoredir)
          write(ilog,15)int(shoredir)
          write(ascrnout5,15)int(shoredir)
      endif
 10   FORMAT(/,1X,'***',/,1X,' PLUME HEIGHT IS BELOW TIBL HEIGHT',
     &          /,1X,' FOR DISTANCE TO SHORELINE OF ',F8.2,' M.',
     &          /,1X,' NO SHORELINE FUMIGATION CALCULATION MADE.',
     &          /,1X,'***',/)  
 25   format(/1x,'TIBL HEIGHT EQUAL TO PLUME HEIGHT ',f8.2, 
     +' M'/1x,'CORRESPONDS TO DISTANCE OF ',F8.2,' M'/1x,
     + 'PLUME IS BELOW TIBL FOR DISTANCE TO SHORELINE OF ',F8.2,' M',
     + /1X,'NO SHORELINE FUMIGATION CALCULATION MADE')
  
 30   format(/1x,'Maximum Effective plume height: ',f8.2,
     + ' m equals TIBL height'
     +,/1x,'at distance of ',f8.2,' m'/1x,'TIBL height is ',f8.2,' m',
     +/1x,'at shoreline distance of ',f8.2,' m')
     
 15   format(/1x,'No meteorological conditions for direction of ',i3,
     + ' toward the shoreline')
 20   format(/1x,'Plume height is below TIBL height for date of ',i8.8,
     + /1x,'Effective plume height: ',f8.2,' m'/1x,
     + 'Temporal period:',i3,/1x,'Spatial sector:',i3)
 100  format(1x,'#################################################',
     +'#####################################'/1x,
     +'SHORELINE FUMIGATION CALCULATIONS'//,1x,
     +'Stack height:',f8.2,' m')   
 107  format(1x,'FINAL MAX CONCENTRATION OF ',e9.3,' AT ',f11.3,
     + ' KM FOR DATE ',i8.8/1x,'temporal period:',i3/1x,
     +'spatial sector:',i3/)
      return
      end
c -----------------------------------------------------------------------------
      subroutine tibl(h,x0,ltib)
c     subroutine to check that a specific hour's plume is below TIBL
      use main1
      implicit none
c h       hour being processed
c ltib    logical variable denoting hour is below TIBL
c x0      distance being processed
c he      effective stack height for hour
c tiblht  height of TIBL
      integer h
      logical ltib
      real x0,he,hedist,tiblht
      
      he=fumdata(h,16)
      
c     determine if plume is below TIBL at distance x0 (distance from shoreline)
      x0=(HE/6.)**2.-shordist
      if (ldebug) then
          tiblht=sqrt(shordist)*6.
          hedist=(he/6.)**2.
          write(ascrnout5,30)int(fumdata(h,28)),he,x0,tiblht,shordist
      endif
     
      if (x0 .le. 0.0) ltib=.true.
      
 30   format(/1x,'For date: ',i8.8,/1x,'Effective plume height: ',f8.2,
     + ' m equals TIBL height'
     +,/1x,'at distance of ',f8.2,' m'/1x,'TIBL height is ',f8.2,' m',
     +/1x,'at shoreline distance of ',f8.2,' m')
!10   FORMAT(/,1X,'***',/,1X,' PLUME HEIGHT IS BELOW TIBL HEIGHT',
!    &          /,1X,' FOR DISTANCE TO SHORELINE OF ',F8.2,' M.',
!    &          /,1X,' NO SHORELINE FUMIGATION CALCULATION MADE.',
!    &          /,1X,'***',/)
      return
      end
c -----------------------------------------------------------------------------              
      subroutine shoremax(h,x0)
c     calculate shoreline break-up fumigation concentration and calculate overall max
c     based on SCREEN3 fumigation calculations
      use main1
      implicit none
c i               iteration loop counter
c h               hour (passed from fumigate routine)
c i1              met array counter
c he              effective stack height (equal to fumdata(h,16)
c x0              distance being processed
c sy1             ambient sigma-y
c sz1             ambient sigma-z
c sy              sy1 + buoyancy sigma-y
c sz              sz1 + buoyancy sigma-z
c sigmay          ambient sigma-y function
c sigmaz          ambient sigma-z function
c x1              max concentration for the inversion break-up concentration for iteration i
c chi             inversion break-up concentration
c fumx1           old fumx value
c u               stack top wind speed, 2.5 m/s
      integer i,h,i1
      real he,sy,sy1,sz,sz1,x1,u,x0,sigmay,sigmaz,chi,fumx1
      fumx=x0
      he=fumdata(h,16)
      u=2.5
      if (ldebug) then 
          write(ascrnout5,100)int(fumdata(h,28)),shordist,height,
     +    fumdata(h,29),he,fumx/1000.,int(fumdata(h,26)),
     +    int(fumdata(h,27)),(fumdata(h,i1),i1=1,11),
     +     (fumdata(h,i1),i1=12,14),fumdata(h,17),fumdata(h,25),
     +    (fumdata(h,i1),i1=18,24)
      endif
      do i=1,20
          sy1=sigmay(h)  !calculate ambient sigma-y
          sz1=sigmaz(h)  !calculate ambient sigma-z
          sy=sqrt(sy1*sy1+fumdata(h,23)*fumdata(h,23)) !add buoyancy 
          sz=sqrt(sz1*sz1+fumdata(h,24)*fumdata(h,24)) !add buoancy
          X1 = ((HE+2.*SZ)/6.)**2.-shordist
          if (ldebug) write(ascrnout5,101)i,sy,sz,X1/1000.
          if (abs(x1-fumx) .lt. 10.) then
              fumx=x1
              if (ldebug) write(ascrnout5,102)i
              goto 5
          else
              fumx=x1
          endif
      enddo
      fumx1=fumx
      fumx=(x1+fumx)*0.5
      if (ldebug) write(ascrnout5,104)x1,fumx1/1000.,fumx/1000.
  5   sy1=sigmay(h)
      sz1=sigmaz(h)
      sy=sqrt(sy1*sy1+fumdata(h,23)*fumdata(h,23))
      sz=sqrt(sz1*sz1+fumdata(h,24)*fumdata(h,24))
      CHI = emisrate/(2.50663*U*(SY+HE/8.)*(HE+2.*SZ))*1.0E06    
      !if (fumx .lt. 200) chi=0.0
      if (ldebug)write(ascrnout5,105)sy,sz,chi

      if (chi .gt. shorechi) then
          shorechi=chi
          shorex=fumx
          stemp=int(fumdata(h,26))
          ssec=int(fumdata(h,27))
          shordate=int(fumdata(h,28))
		if (fumx .lt. 200) shorechi=0.0
          if (ldebug) then
			if (fumx .lt. 200.)write(ascrnout5,'(a,f7.3,a)')' DISTANCE ',
     +		fumx,' < 200 M, RESET CHI  TO 0'
			write(ascrnout5,106)shorechi,shorex/1000.,
     +        int(fumdata(h,28)),stemp,ssec
          endif
      endif
      
 100  format(1x,'#################################################',
     +'#####################################'/1x,
     +'SHORELINE FUMIGATION CALCULATIONS FOR ',
     +I8.8,//,1x,'Shoreline distance: ',f8.2,' m'
     + /1x,'Stack height:',f8.2,' m',/1x,
     +'Stack height wind speed 2.5 m'/1x,
     +'Stack-tip downwash adjusted stack height:',f8.2,' m',/1x,
     + 'Effective stack height:',f8.2,' m',/1x,
     + 'Initial distance:',f11.3,' km'/1x,
     + 'temporal period:',i3/1x,'spatial sector:',i3,//1x,
     + 'BASE METEOROLOGICAL VARIABLES'
     + /5x,'H0     U*     W*  DT/DZ ZICNV ZIMCH  M-O LEN    ',
     +           'Z0  BOWEN ALBEDO  REF WS'/
     + '  - - - - - - - - - - - - - - - - - - - - - - - - -',
     +       ' - - - - - - - - - - - - -'/f7.2,3f7.3,2f6.0,f9.1,f6.3,
     +    2f7.2,f8.2//
     + '     HT  REF TA     HT'/
     + ' - - - - - - - - - - -',/f7.1,f8.1,f7.1//1x,'OTHER VARIABLES'//
     +'   UMIX       UEFF  SIG-V  SIG-W   THETA  DT/DZ_2    BV    ',
     +'SIG-YB  SIGZ-B'/
     +' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - ',
     +'- - - - - -'/1x,2(f8.1),2(f8.2),f8.1,2(f8.4)2(f8.1))  !,9(f8.1))
 
 101  format(/1x,'Iteration ',i2//,1x,'Sigma-y: ',e9.3,' m'/1x,
     +'Sigma-z: ',e9.3,' m'/1x,'Distance: ',f11.3,' km')
 102  format(/1x,'Convergence found at iteration ',i2)
 103  format(/1x,'Resetting distance to 100 m')
 104  format(/1x,'No convergence...distance',f11.3,/1x,
     +'is average of last two distances',2(1x,f11.3))
 105  format(/1x,'Sigma-y: ',e9.3,' m'/1x,'Sigma-z: ',e9.3,' m'/1x,
     +'Concentration: ',e9.3/)
 106  format(1x,'NEW MAX CONCENTRATION OF ',e9.3,' AT ',f11.3,
     + ' KM FOR DATE ',i8.8/1x,'temporal period:',i3/1x,
     +'spatial sector:',i3/)

      return
      end
c -----------------------------------------------------------------------------
c     based on refvs from AERMOD and metini
      function sigmav(h)
c     calculate sigma-v
      use main1
      implicit none
c sigmav      sigma-v
c sv02        sigma-v at surface
c sv2zi       sigma-v at zi
c sv2         interpolated sigma-v between surface and zi or
c             sv2zi if effective stack height above zi
c zi          mixing height. max of convective and mechanical heights
c h           hour being processed
      
      real sigmav,sv02,sv2zi,sv2,zi
      integer h
C     Compute SV2 at the surface
      SV02 = 3.60 * fumdata(h,2)**2
      zi=max(fumdata(h,5),fumdata(h,6))
C     Compute SV2 at ZI;
C     Do not let SV2 at ZI exceed the surface value.
      
      SV2ZI = MIN( SV02, 0.250 )
c     effective stack height
      if (fumdata(h,16) .le. zi) then
c     use equation from GINTRP in AERMOD
          sv2 = sv02 + ( (height - 0.0) / (zi - 0.0) ) *
     &                   (sv2zi - sv02)
      else
          sv2=sv2zi
      endif

      sigmav = MAX(sqrt(sv2),0.2,0.05*fumdata(h,25))
      return
      end
c -----------------------------------------------------------------------------
      function sigmaw(h)
c     calculate sigma-w
      use main1
      implicit none
c sigmav      sigma-w
c swrmax      max residual sigma-w 
c swr         residual sigma-w
c swbl        sigma-w for boundary layer
c zi          mixing height. max of convective and mechanical heights
c h           hour being processed
      real sigmaw,swrmax,swr,swbl,zi
      integer h
      
      zi=max(fumdata(h,5),fumdata(h,6))
      SWRMAX = 0.02 * fumdata(h,17)
      SWR  = SWRMAX * MIN( 1.0, fumdata(h,16)/zi)
      IF (fumdata(h,16) .LT. ZI) THEN
         SWBL = 1.3 * fumdata(h,2) * SQRT( 1.0 - fumdata(h,16)/ZI)
      ELSE
         SWBL = 0.0
      END IF

      sigmaw = SQRT( SWR*SWR + SWBL*SWBL )
      return
      end
c -----------------------------------------------------------------------------
      function theta(ht,zi,ambt,ustar,monin,tref,dtdz)
c     calculate theta and potential temperature gradient at height, ht

      use main1
      implicit none
c h           hour being processed
c theta       potential temperature at height denoted by ht
c ptref       theta at temperature reference height
c thstar      theta star
c tg4pfl      dtheta/dz at reference height
c tg4xtr      dtheta/dz at 100 m
c tgmaxht     max height 100 m
c ht          height at which theta is being calculated
c dtdz        temperature gradient at height ht
c zi          mixing height
c exparg      exponential term from eq. 31 of AERMOD MFD
c tg1         temperature 1 for averaging
c tg2         temperature 2 for averaging
c delh        height difference used for temperature interpolation
c theta1      reference theta used for interpolation
c theta100    theta at 100 m
c tgminht     min height 2 m
c ambt        ambient 2-m temperature
c ustar       surface friction velocity
c monin       Monin-Obukhov length
c tref        temperature reference ht, 2 m
      integer h
      real theta,ptref,thstar,tg4pfl,tg4xtr,tgmaxht,ht,
     +dtdz,zi,exparg,tg1,tg2,delh,theta1,theta100,tgminht,
     +ambt,ustar,monin,tref
      
      tgmaxht=100.0
      tgminht=2.0
c     calculate theta at reference temperature height
      PTREF = ambt+GOVRCP*(tref + profbase)
c     calculate theta-star
      THSTAR =ustar**2/( G*VONKAR*monin/ambt)
c     calculate dtheta/dz at reference height
      TG4PFL=(THSTAR/(VONKAR*TGMINHT))*
     +( 1.0+5.0*tgminht/monin)
      
      if (ht .le. 2.0) then
          dtdz=tg4pfl
      elseif (ht .le. 100.0) then
          dtdz=(THSTAR/(VONKAR*ht))*
     +    (1.0+5.0*ht/monin)
      else
c     calculate dtheta/dz at 100 m
          TG4XTR=(THSTAR/(VONKAR*TGMAXHT))*
     +    (1.0+5.0*TGMAXHT/monin)
          EXPARG=-1.0*(ht-100.0)/(0.44*MAX(100.0,ZI))
          IF (EXPARG .GT. -50) THEN
              dtdz=TG4XTR*EXP(EXPARG)
          ELSE
              dtdz = 0.0
          ENDIF
c         calculate theta @ 100 m
          theta100=ptref+0.5*(tg4xtr+tg4pfl)*(tgmaxht-tref)
      endif
      dtdz = MAX(dtdz,0.002)

c     calculate theta at height

      if (ht .le. tgminht) then
         theta1=ptref
         delh=tgminht-ht
         tg1=tg4pfl
         tg2=dtdz
      elseif (ht .le. 100.0) then
          theta1=ptref
          delh=ht-tgminht
          tg1=tg4pfl
          tg2=dtdz
      else
          theta1=theta100
          delh=ht-tgmaxht
          tg1=tg4xtr
          tg2=dtdz
      endif
      theta=theta1+0.5*(tg1+tg2)*delh
      return
      end
c -----------------------------------------------------------------------------
      function brunt(thta,dthtadz)
c     calculate Brunt-Vaisala frequency
      use main1
      implicit none
c h       hour being processed
c brunt   Brunt-Vaisala frequency at height specified by theta and dthtadz
c thta    potential temperature
c dthtadz potential temperature gradient
      integer h
      real brunt,thta,dthtadz

      IF (dthtadz .GT. 0.0) THEN
          brunt = SQRT( G * dthtadz / thta)
      ELSE
          brunt = 1.0e-10
      END IF
      IF(brunt .LT. 1.0e-10) brunt = 1.0e-10
      return
      end
c -----------------------------------------------------------------------------
      subroutine bid(h,syb,szb)
c     calculate buoyancy induced dispersion parameters
      use main1
      implicit none
c h       hour being processed
c dhp     difference between stack top and effective stack height
c beta2   constant of 0.4
c szb     buoyancy induced vertical dispersion
c syb     buoyancy induced horizontal dispersion
      integer h

      real dhp,beta2,szb,syb

      beta2=0.4

      dhp=fumdata(h,16)-fumdata(h,29)
      SZB = BETA2 * DHP / RTOF2
      SYB = SZB
      return
      end
      
c -----------------------------------------------------------------------------
      function sigmay(h)
c     calculate horizontal dispersion
      use main1
      implicit none
c h       hour being processed
c svovru  sigma-v divided by effective wind speed
c tyeff   Lagrangian integral time
c sigmay  sigma-y
      integer h
      real SVOVRU,tyeff,sigmay

c     ambient sigma-y

      SVOVRU = MAX (0.05, fumdata(h,18)/fumdata(h,25))
      TYEFF  = (fumdata(h,6)/(156.0*fumdata(h,18)))*
     + (MAX(fumdata(h,16),0.460)/0.460)
      sigmay=(SVOVRU *fumx)/(1.00+fumx/(2.0*fumdata(h,25)*TYEFF))**0.3

      return
      end
c -----------------------------------------------------------------------------
      function sigmaz(h)
c     calcualte sigma-z
      use main1
      implicit none
c h       hour being processed
c ttravl  distance/effective wind speed
c ztmp    plume height
c szamb   ambient sigma-z
c zi      mixing height
c sigmaz  sigma-z
c szsurf  sigma-z at surface
c sigf    effective stack height divided by mixing height  
      integer h
      real ttravl,ztmp,szamb,zi,sigmaz,szsurf,sigf
      zi=max(fumdata(h,5),fumdata(h,6))

c     calculate travel time

      TTRAVL = fumx / fumdata(h,25)
C     Set height for calculating sigma-z, ZTMP
      ZTMP = MAX(height,fumdata(h,16),1.0e-4)
      SZAMB = fumdata(h,19)*TTRAVL/SQRT(1.0+fumdata(h,19)*TTRAVL *
     &    (1.0/(0.72*ZTMP)+fumdata(h,22)/(0.540*fumdata(h,19))))
      IF (fumdata(h,16) .LT. ZI) THEN

          SZSURF=(RTOF2/RTOFPI)*fumdata(h,2)*(fumx/fumdata(h,25))*
     &    (1.0 + 0.7*fumx/fumdata(h,7))**(-THIRD)
          SIGF = MIN (fumdata(h,16)/ZI,1.00)

          sigmaz = (1.0 - SIGF) * SZSURF + SIGF * SZAMB
      ELSE
          sigmaz = SZAMB
      END IF

      return
      end

c -----------------------------------------------------------------------------
      subroutine subsetmet
c     subset met and get ustack, effective stack height, and u at effective height for fumigation calculations.
      use main1
      implicit none
c it      temporal loop counter
c is      spatial sector counter
c eof     end of file indicator
c i       met data loop counter
c jy      year from surface file
c jm      month from surface file
c jd      day from surface file
c jh      hour from surface file
c istab   stability index corresponding to PG stability
c stable  function to calculate istab
c idate   integer date based on jy,jm,jd,jh
c sfcfil1 subsetted surface met file containing fumigation hours
c sfcfil2 met file being read, added version 15236
c t1      character version of it
c s1      character version if is
c line    line of data from surface met file
c adate   character string version of idate
c data2   meteorological data read from surface met file
c ustack  wind speed at stack top
c hsp     stack height with stack downwash adjustment
c deltah1 plume rise
c zi      mixing height
c sigmav  sigma-v function
c sigmaw  sigma-w function
c theta   function to calculate theta
c dtdz    potential temperature gradient output by theta
c brunt   function to calculate Brunt-Vaisala frequency
c syb     buoyancy induced sigma-y
c szb     buoyancy induced sigma-z
c thtas   theta at stack top
c dtdzs   potential temperature gradient at stack top
c fb      plume buoyancy flux
c fm      plume momentum flux
      
      integer it,is,eof,i,jy,jm,jd,jh,istab,ihour,stable,idate
      character sfcfil1*25,t1*2,s1*2,line*154,adate1*8,sfcfil2*25
      real data2(14),ustack,hsp,deltaH1,zi,sigmav,sigmaw,theta,dtdz,
     + brunt,syb,szb,thtas,dtdzs,fb,fm


      
      lfumhours=.false.
      fumhours=0
      sfcfil1='aerscreen_sub.sfc'
      open(unit=isfcmet1,file=sfcfil1,status='replace')

      do it=1,ntemp
          write(t1,'(i2.2)')it
          do is=1,nsec
              write(s1,'(i2.2)')is    
c             changed variable from sfcfil to sfcfil2 to avoid potential
c             reading of wrong file in subroutine output
              sfcfil2='aerscreen_'//t1//'_'//s1//'.sfc'      
              open(unit=isfcmet,file=sfcfil2,status='old')
     
c             read the surface file and write to a new temporary file 
c             that will contain all surface data
c             add the temporal and sector counter to end of line
              eof=0
              read(isfcmet,5,iostat=eof)line
 15           if (eof .eq. 0) then
                  if (index(line,'SCREEN') .eq. 0) then
                      write(isfcmet1,6)line,it,is
                  endif
                  read(isfcmet,5,iostat=eof)line
                  goto 15
              endif
              close(isfcmet)
          enddo
      enddo

c     now read the new file and get only F class stable hours and winds of 2.5 m/s
      rewind(isfcmet1)
      eof=0
      read(isfcmet1,5,iostat=eof)line
 25   if (eof .eq. 0) then
          read(line,10)jy,jm,jd,jh,(data2(i),i=1,14)
          if (jh .ge. 1 .and. jh .le. 11) then  !stable hour
              istab=stable(data2(8),data2(7))
              if (istab .eq. 6) then
                  zi=MAX(data2(5),data2(6))
                  call refws(MAX(height,2.0),data2(7),
     &            data2(8),zi,data2(2),
     &            data2(11),data2(12),ustack)
                  if (ustack .ge. 2.45 .and. ustack 
     +            .le. 2.54) then
                      fumhours=fumhours+1
                  endif
              endif
          endif
          read(isfcmet1,5,iostat=eof)line
          goto 25
      endif
c     check to see if any hours fit criteria
c     if not exit
      if (fumhours .gt. 0) then
          lfumhours=.true.
      else
          write(*,50)
          write(ilog,50)
          goto 60
      endif

      if (lfumhours .and. ldebug) open(unit=ascrnout5,file=fumfil,
     +        status='unknown')
c     re-read new surface file to write to an array for later use in the fugimation
c     calculations
      allocate(fumdata(fumhours,31))   
      fumdata=0.0     
      rewind(isfcmet1)
      eof=0
      ihour=0     
      read(isfcmet1,6,iostat=eof)line,it,is
 20   if (eof .eq. 0) then
          read(line,10)jy,jm,jd,jh,(data2(i),i=1,14)
          if (jh .ge. 1 .and. jh .le. 11) then  !stable hour
              istab=stable(data2(8),data2(7))
              if (istab .eq. 6) then
                  zi=MAX(data2(5),data2(6))
                  call refws(MAX(height,2.0),data2(7),
     &            data2(8),zi,data2(2),
     &            data2(11),data2(12),ustack)
                  if (ustack .ge. 2.45 .and. ustack 
     +            .le. 2.54) then
                      ihour=ihour+1
                      do i=1,14
                          fumdata(ihour,i)=data2(i)
                      enddo
                      fumdata(ihour,15)=2.5
c                     calculate u at top of mixed layer
                      call refws(zi,data2(7),
     &                data2(8),zi,data2(2),
     &                data2(11),data2(12),fumdata(ihour,17))
                      call plumehgt(data2(13),zi,data2(2),data2(7),
     +                data2(14),deltaH1,fumdata(ihour,15),hsp,thtas,
     +                dtdzs,fb,fm)
                      fumdata(ihour,29)=hsp   !stack tip downwash height  
c                     get effective stack height based on iterative process from PCALC in AERMOD
                      if (ldebug) write(ascrnout5,70)jy,jm,jd,jh
                      call recalcplume(data2(13),thtas,dtdzs,fb,fm,zi,
     +                data2(2),data2(7),data2(14),deltah1,hsp,data2(8),
     +                data2(11),data2(12))
                      fumdata(ihour,16)=hsp+deltaH1
c                     get wind speed at effective plume height
                      call refws(fumdata(ihour,16),data2(7),data2(8),zi,
     &                data2(2),data2(11),data2(12),fumdata(ihour,25))
                      fumdata(ihour,18)=sigmav(ihour)  !sigma-v 
                      fumdata(ihour,19)=sigmaw(ihour)  !sigma w
                      fumdata(ihour,20)=theta(fumdata(ihour,16),zi,
     +                fumdata(ihour,13),fumdata(ihour,2),
     +                fumdata(ihour,7),fumdata(ihour,14),dtdz) !potential temperature at effective height
                      fumdata(ihour,21)=dtdz   !potential temperature gradient
                      fumdata(ihour,22)=brunt(fumdata(ihour,20),
     +                fumdata(ihour,21))
                      call bid(ihour,syb,szb)!buoyancy induced sy and sz terms
                      fumdata(ihour,23)=syb
                      fumdata(ihour,24)=szb
                      fumdata(ihour,26)=real(it)   !temporal sector
                      fumdata(ihour,27)=real(is)   !spatial sector
                      write(adate1,'(4i2.2)')jy,jm,jd,jh
                      read(adate1,'(i8.8)')idate
                      fumdata(ihour,28)=real(idate)
                  endif
              endif
          endif
          read(isfcmet1,6,iostat=eof)line,it,is
          goto 20
      endif
c     close and delete temporary file
      close(isfcmet1,status='delete')

      
 5    format(a154)
 6    format(a154,2(1x,i2))
  10   format(i2,2i3,4x,i3,4x,4f7.0,2f11.0,f9.0,3f7.0,f8.0,6x,3f7.0)
! 20    format(4(I2,1X),F6.1,1X,I1,1X,F5.0,1X,F7.2,1X,F7.1,1X,F6.1,1X,
!     & F7.2)
 30   format(a154,2(1x,i2),3(1x,f8.1))
 40   format(a190)
 45   format(i2,2i3,4x,i3,4x,4f7.0,2f11.0,f9.0,3f7.0,f8.0,6x,3f7.0,21x,
     +2(1x,i2),3(1x,f8.1))
 50   format(/'No hours fitting fumigation criteria found...'/
     + 'No fumigation calculations will be made')
 70   format(/1x,'Calculating effective plume height for: ',4i2.2)    
 60   return
      end
      
c -----------------------------------------------------------------------------
      subroutine recalcplume(ambtemp,thtas,dtdzs,fb,fm,zi,ustar,monin,
     +tref,deltah,hsp,zo,ws,wht)
c     calculate the effective plume height based on iterative process in PCALC in AERMOD
      use main1
      implicit none
c kit     iteration counter
c fb      plume buoyancy flux
c fm      plume momentum flux
c zi      mixing height
c ustar   surface friction velocity
c monin   Monin-Obukhov length
c tref    ambient temperature reference height
c deltah  plume rise
c up      average of stack top velocity and plume height velocity
c hsp     stack height with stack downwash adjustment
c deltah  saved plume rise   
c bvf     Brunt-Vaisala frequency
c brunt   function to calculate Brunt-Vaisala frequency
c thtas   theta at stack top
c dtdzs   potential temperature gradient at stack top
c zplm    plume height, hsp+0.5*deltah for each iteration
c thta1   theta at zplm
c dtdz1   potential temperature gradient at zplm
c thta2   average of thtas and thta1
c dtdz2   average of dtdzs and dtdz1
c uplm    wind speed at zplm
c beta1   constant (0.6)
c hs      stack height
c ts      stack temperature
c ds      stack diameter
c vs      stack exit velocity
c us      stack top wind speed, 2.5 m/s
c zo      surface roughness
c ws      reference wind speed
c wht     reference wind speed height
c theta   function to calculate theta
c dhfaer  plume rise from eq. 97 of AERMOD MFD
c xln     neutral length scale
c delhnn  plume rise for near neutral conditions
c deltah2 plume rise from eq. 99 of AERMOD MFD
c ambtemp ambient 2-m temperature
      
      integer kit
      real fb,fm,zi,ustar,monin,tref,deltah,up,hsp,delhold,bvf,thtas,
     +dtdzs,thta1,thta2,dtdz1,dtdz2,uplm,beta1,hs,ts,ds,vs,zplm,us,
     +zo,ws,wht,theta,brunt,dhfaer,xln,delhnn,deltah2,ambtemp
      
      BETA1 = 0.6
      HS = height
      TS = temperature
      DS = diameter
      VS = velocity

      kit=0
      if (ldebug) write(ascrnout5,65)hsp,deltah
      
 50   zplm=hsp+0.5*deltah
      delhold=deltah
c     wind speed at zplm
      call refws(zplm,monin,zo,zi,ustar,ws,wht,uplm)
      uplm=max(uplm,0.2828)
      up=0.5*(2.5+uplm)  !average of stack top velocity, 2.5 m/s and uplm
      
      thta1=theta(zplm,zi,ambtemp,ustar,monin,tref,dtdz1)
      thta2=0.5*(thtas+thta1)
      dtdz2=0.5*(dtdzs+dtdz1)
      
      
      bvf=brunt(thta2,dtdz2)
      
      
      if (monin .gt. 0.0 .OR. (monin .lt. 0.0 .AND. (HS .GE. ZI))) then
          DHFAER = 2.66 * (FB/(BVF*BVF*UP))**(1.0/3.0)  !eq. 97 of AERMOD MFD
          XLN = FB/(UP*USTAR*USTAR) !see eq. 98 of AERMOD MFD
          DELHNN = 1.2*XLN**0.6 * (HSP + 1.2*XLN)**0.4   !Eq 98 of AERMOD MFD
          deltah2=4.0 * FB**0.25 / (BVF*BVF)**0.375  !eq 99 of AERMOD MFD
          deltaH = MIN( DHFAER,DELHNN,deltah2)  !limit deltah with unstable
          
      endif     
 
      kit=kit+1
      if (ldebug) write(ascrnout5,70)kit,zplm,deltah
C     Check for convergence
      if ((abs(delhold-deltah)/deltah) .lt. 0.01) goto 60
      
      if (kit .ge. 5) then
          deltah=0.5*(deltah+delhold)
          if (ldebug) write(ascrnout5,75)
          goto 60
      else
          goto 50
      endif
            
 60   if (ldebug) write(ascrnout5,80)kit,hsp+deltah,deltah
      
 65   format(/1x,'Stack height (adjusted): ',f8.2,' m'
     +/1x,'Initial plume rise: ',f8.2,' m')
      
 70   format(/1x,'Iteration: ',i1,/1x,'Plume height: ',f8.2,' m'/1x,
     +'Plume rise: ',f8.2,' m')
 75   format(/1x,'No convergence after 5 iterations',/1x,
     + 'Average last two values of plume rise')
 80   format(/1x,'Final plume rise',/1x,'Iteration: ',i1,/1x,
     + 'Effective Plume height: ',f8.2,' m'/1x,
     +'Plume rise: ',f8.2,' m')
      return
      end

      
c -----------------------------------------------------------------------------
      function stable(zo,mol)
c     function to calculate stability PG stability class
      use main1 
      implicit none
c stable      integer of stability class 1-6
c zo          surface roughness
c mol         Monin-Obukhov length
c zo1         adjusted zo
c xld         D-class length
c xle         E-class length
      integer stable
      real zo1,zo,mol,xld,xle
      if (zo .lt. 0.01) then
          zo1=0.01
      elseif (zo .gt. 0.5) then
          zo1=0.5
      else
          zo1=zo
      endif
      xld=-327.0/(log(zo1)-0.627)
      xle=-70.0/(log(zo1)-0.295)
      if (mol .ge. xld) then
          stable=4
      elseif (mol .ge. xle) then
          stable=5
      else
          stable=6
      endif
      return
      end
c -----------------------------------------------------------------------------
      subroutine delfiles
c     delete files
      use main1
      implicit none
      
c inpfile:    new aerscreen.inp file with same naming convention
c             as aerscreen.out file
c aline:      system call to copy aermod.inp to inpfile
c n1:         index of .out from outfil1
      character aline*100
      integer n1,scratchunit
      
      scratchunit=88
      open(scratchunit,file='kil',status='unknown')
      close(scratchunit,status='delete')
      
!      call system("del kil  > NUL")

!      call system("copy aermod.inp aerscreen.inp > NUL")
c     copy the aermod.inp file to an aerscreen.inp file that 
c     has similar naming convention as the aerscreen output file
!      if (.not. ldefault) then
!        n1=index(outfil1,'.OUT')
!        inpfile=outfil(1:n1-1)//'.inp'
        call writeinp
        !write(aline,100)trim(adjustl(inpfile))
        !call system(aline)
!      endif
!     call system("del aermod.inp > NUL")
      if(lterrain .and. runscreen) then
       open(aermapin,file='aermap.inp',status='unknown')
       close(aermapin,status='delete')
       open(aermpout,file='AERMAP.OUT',status='old')
       close(aermpout,status='delete')
!       call system("del aermap.inp > NUL")
!       call system("del aermap.out > NUL")
      endif
! 100  format('copy aermod.inp "',a,'" /y > NUL')
      if((lbpip .or. igep .ne. 0) .and. runscreen) then
       if(bpipfile .eq. ' ') then
           open(scratchunit,file='bpipprm.txt',status='unknown')
           close(scratchunit,status='delete')
!           call system("del bpipprm.txt  > NUL")
       endif
      endif
      return
      end
c -----------------------------------------------------------------------------
      subroutine writeinp
c     write AERMOD.INP file to new AERSCREEN.INP file and new AERSCREEN.INP file with
c     non-default filename
      use main1
      implicit none
      integer eof,inunit1,inunit2
      character line*250
      
      eof=0
      inunit1=77
      inunit2=78
      open(aermodin,file='aermod.inp',status='unknown')
      open(inunit1,file='aerscreen.inp',status='unknown')
      if (.not. ldefault) open(inunit2,file=inpfile,status='unknown')
      read(aermodin,5,iostat=eof)line
 10   if (eof .eq. 0) then
          write(inunit1,5)line
          if (.not. ldefault) write(inunit2,5)line
          read(aermodin,5,iostat=eof)line
          goto 10
      endif
      close(aermodin,status='delete')
      close(inunit1)
      if (.not. ldefault) close(inunit2)

 5    format(a250)
      return
      end
      
c -----------------------------------------------------------------------------
      subroutine aermapout
      use main1
      implicit none
      integer eof,inunit1,outunit1
      character line*100
      
      eof=0
      inunit1=77
      outunit1=78
      open(inunit1,file=infil1,status='unknown')
      open(outunit1,file=outfil3,status='unknown')
      
      read(inunit1,5,iostat=eof)line
 10   if (eof .eq. 0) then
          write(outunit1,5)line
          read(inunit1,5,iostat=eof)line
          goto 10
      endif
      
      close(inunit1)
      close(outunit1)
 5    format(a100)
      return
      end
c -----------------------------------------------------------------------------
       subroutine output()

c --- Create AERSCREEN.OUT output file and results screen display ---
c --- New changes:  building length and width print order switched from previous AERSCREEN - JAT
c --- receptor heights in m instead of feet -JAT

      use main1
      implicit none
   
c line:         character string read from various files
c temp:         character string to check for commented lines in AERMOD output
c flag:         flag indicating direction of maximum conc from PROBE or FLOWSECTOR
c tdem:         character representing data type of files in demlist.txt
c rundat:       run date of current AERSCREEN run
c runtim:       run time of current AERSCREEN run
c atemp:        3-character character string indicating temporal period of 
c               maximum concentration from PROBE or FLOWSECTOR
c atemp1:       month name or season name for maximum concentration
c               from PROBE or FLOWSECTOR. atemp set to first 3 characters of atemp1
c adists:       array of distance cut-offs for different receptor spacings
c ustr:         text string about u* adjustment
c maxfil:       name of maximum concentrations by distance, default name is
c               max_conc_distance.txt
c debugfil:     debug filename, default name is concentrations.txt
c outfil1:      name of outfile when AERSCREEN.OUT is not the name of the output file
c               used to construct maxfil name when not default
c iacfm:        integer value of flow rate
c ipop:         integer urban population
c mt:           integer indicator of temporal period associated with maximum concentration
c               output from PROBE or FLOWSECTOR
c jj:           loop counter
c icnt:         terrain file counter
c i:            loop counter
c iy:           year of maximum concentration
c im:           month of maximum concentration
c id:           day of maximum concentration
c ih:           hour of maximum concentration
c jy:           year read from aerscreen.sfc
c jm:           month read from aerscreen.sfc
c jh:           month read from aerscreen.sfc
c is:           sector loop counter
c j:            temporal period loop counter
c maxtem:       temporal period index of maximum concentration
c maxsec:       sector of maximum concentration
c n:            number of receptors divided by 2. used for formatting purposes
c ir:           receptor loop counter
c nsec1:        number of sectors to process.  If processing terrain and/or downwash
c               set to 36, otherwise it is the number of surface roughness sectors
c ambdir:       direction of maximum concentration for ambient receptors
c n1:           index of ".OUT" from outfil
c i2:           loop counter for outfil1 characters when converting to uppercase
c btemp:        variable used to as temporary maximum for building parameters
c deltaH1:      plume height of maximum concentration
c deltaH2:      plume height of maximum ambient concentration
c ustack:       wind speed at stack height
c hsp:          adjusted stack-tip downwash height
c xrec:         x-coordinate of maximum concentration
c yrec:         y-coordinate of maximum concentration
c frac:         mod of irec and 2.0, used for formatting PROBE or FLOWSECTOR output
c maxconc:      maximum concentration by distance from PROBE or FLOWSECTOR
c maxdist:      distance of maximum concentration by distance from PROBE or FLOWSECTOR     
c maxterr:      elevation of maximum concentration by distance from PROBE or FLOWSECTOR 
c high:         temporary maximum concentration
c p1:           first receptor distance outside of 5 km, used for output purposes
c conc:         overall maximum and ambient maximum concentrations
c dist:         distances of overall maximum and ambient maximum concentrations
c terr:         elevations of overall maximum and ambient maximum concentrations
c data1:        surface meteorological data
c ratio:        scaling ratios to go from 1-hour to 3, 8, 24-hr, and annual concentrations
      character line*135,temp*2,flag*1,tdem*1,atemp*3,
     +  atemp1*20,adists(4)*20,ustr*20
      integer*4 iacfm,ipop,mt,jj
      integer icnt,i,igap(2),iy,im,id,ih,jy,jm,jd,jh,is,j,maxtem,maxsec,
     +  n,ir,nsec1,ambdir,n1,i2
      real btemp,deltaH1,deltaH2,ustack,hsp,xrec,yrec,frac,
     + maxconc(irec),maxdist(irec),maxterr(irec),high,p1,conc,
     + dist,terr,data1,ratio,thtas,dtdzs,fb,fm
    
      dimension conc(50),dist(50),terr(50)
      dimension data1(14)
      dimension ratio(5)
c      real conc,dist,terr,data1,ratio
      
      


      call header()

c      open(ascrnout,file='aerscreen.out',status='unknown')
c      if (outfil .eq. 'AERSCREEN.OUT' .or. 
c     + outfil .eq. 'aerscreen.out') then
c        maxfil='max_conc_distance.txt'
c        debugfil='concentrations.txt'
c      else
c        outfil1=outfil
c        do i2=1,250
c          call upcase(outfil1(i2:i2))
c        enddo
c        n1=index(outfil1,'.OUT')
c        maxfil=outfil(1:n1-1)//'_max_conc_distance.txt'
c        debugfil=outfil(1:n1-1)//'_concentrations.txt'
c      endif
      open(ascrnout,file=outfil,status='unknown')
c     updated averaging values, upper bound of SCREEN3 ratios JAT 3/18/08
c     moved to top of subroutine to account for AERSCREEN may not be run with
c     fumigation calculations
      
      if (larea .or. lcirc) then
        ratio(1)=1.00  ! 1-hour
        ratio(2)=1.00  ! 3-hour
        ratio(3)=1.00  ! 8-hour
        ratio(4)=1.00  ! 24-hour
      else
        ratio(1) = 1.00   ! 1-hour
        ratio(2) = 1.00   ! 3-hour
        ratio(3) = 0.9   ! 8-hour
        ratio(4) = 0.6    ! 24-hour
      endif
      ratio(5) = 0.1    ! annual
c --- Get Date and Time for output header
      RUNDATE = ' '
      RUNTIME = ' '
      CALL DATIME (RUNDATE, RUNTIME)

      write(ascrnout,1000)versn,trim(adjustl(version)),rundate,runtime
! 1000 format(/' AERSCREEN ',a5,' / AERMOD ',a5,' - beta release version'
!     +        ,t70,a8,/t70,a8/)
! 1000 format(/' AERSCREEN ',a5,' / AERMOD ',a5,t70,a8,/t70,a8/)
!      write(ascrnout,1001)title
 1000 format(/' AERSCREEN ',a5,' / AERMOD ',a,t70,a8,/t70,a8/)
      write(ascrnout,1001)title
 1001 format(' TITLE: ',a//)


c --- Write Stack Information ---

      write(ascrnout,1002)
 1002 format(' ----------------------------------------------------',
     +       '-------------------------')


      if(lpoint)write(ascrnout,1003)
      if(lflare)write(ascrnout,1023)
      if(larea)write(ascrnout,1033)
      if(lcirc)write(ascrnout,1043)
      if(lvolume)write(ascrnout,1053)
      if(lcap)write(ascrnout,1063)
      if(lhor)write(ascrnout,1073)

 1003 format(' *****************************  STACK PARAMETERS  ***',
     +       '*************************')
 1023 format(' *****************************  FLARE PARAMETERS  ***',
     +       '*************************')
 1033 format(' ******************************  AREA PARAMETERS  ***',
     +       '*************************')
 1043 format(' **************************  AREACIRC PARAMETERS  ***',
     +       '*************************')
 1053 format(' ****************************  VOLUME PARAMETERS  ***',
     +       '*************************')
 1063 format(' **************************  POINTCAP PARAMETERS  ***',
     +       '*************************')
 1073 format(' **************************  POINTHOR PARAMETERS  ***',
     +       '*************************')
      write(ascrnout,1002)



      if(emisrate .lt. 0.0100)then
       write(ascrnout,1004)emisrate,emisrate/0.126
      else
       write(ascrnout,1005)emisrate,emisrate/0.126
      endif
 1004 format(/' SOURCE EMISSION RATE: '7x,e10.3,' g/s ',4x,e17.3,
     + ' lb/hr')
 1005 format(/' SOURCE EMISSION RATE: ',7x,f10.4,' g/s ',4x,f17.3,
     + ' lb/hr')

      if(larea)then
       write(ascrnout,1044)emisrate/(xinit*yinit),
     +               (emisrate/0.126)/(xinit*yinit)
      endif
      if(lcirc)then
       write(ascrnout,1044)emisrate/(3.14159*circrad*circrad),
     +          (emisrate/0.126)/(3.14159*circrad*circrad)     
      endif
 1044 format(/' AREA EMISSION RATE:          ',e10.3,' g/(s-m2)',
     +                                  e17.3,' lb/(hr-m2)')


      if(lpoint .or. lcap .or. lhor)then
       write(ascrnout,1006)height,height/0.3048
       write(ascrnout,1007)diameter,diameter/.3048*12
       if (temperature .gt. 0.0) then
        write(ascrnout,1008)temperature,(temperature-273.15)*9./5.+32.
       else if (temperature .lt. 0.0) then
        write(ascrnout,10009)-1.0*temperature,(-1.0*temperature)/0.55556
       else
        write(ascrnout,10008)
       endif
       write(ascrnout,1009)velocity,velocity/0.3048
       iacfm = flowrate + .5
       write(ascrnout,1010)iacfm
       goto 100
      endif
      
 1006  format( ' STACK HEIGHT:      ',12x,f8.2,' meters  ',
     +  5x,f12.2,' feet')
 1007  format( ' STACK INNER DIAMETER:   ',7x,f8.3,' meters',4x,
     +           f15.2,' inches')
 1008  format( ' PLUME EXIT TEMPERATURE: ',7x,f8.1, ' K ',8x,
     +           f15.1,' Deg F')
10008  format( ' PLUME EXIT TEMPERATURE:           Ambient')
 1009  format( ' PLUME EXIT VELOCITY:    ',7x,f8.3, ' m/s  ',2x,
     +           f18.2,' ft/s')
1010  format(' STACK AIR FLOW RATE:',i19,' ACFM')
10009  format( ' PLUME EXIT TEMPERATURE: ',7x,f8.1, ' K above ambient',
     +           2x,f8.1,' Deg F above ambient')      
      
      if(lflare)then
       write(ascrnout,1029)flare_hgt,flare_hgt/0.3048
       write(ascrnout,11029)height,height/0.3048
       write(ascrnout,21029)heat
       write(ascrnout,31029)heatloss
       write(ascrnout,41029)diameter,diameter/.3048*12
       write(ascrnout,41030)temperature,(temperature-273.15)*9/5+32
       write(ascrnout,41031)velocity,velocity/0.3048
       goto 100
      endif
      
1029  format( ' FLARE HEIGHT:      ',12x,f8.3,' meters',
     +  f19.2,' feet')
11029  format( ' EFF RELEASE HEIGHT:',12x,f8.3,' meters',
     +  f19.2,' feet')
21029  format( ' HEAT RELEASE RATE: ',10x,g10.4,' cal/sec')
31029  format( ' HEAT LOSS FRACTION:',12x,f8.3)
41029  format( ' EFF STACK DIAMETER:     ',7x,f8.3,' meters',4x,
     +           f15.2,' inches')
41030  format( ' EFF EXIT TEMPERATURE:   ',7x,f8.1, ' K ',8x,
     +           f15.1,' Deg F')
41031  format( ' EFF EXIT VELOCITY:   ',10x,f8.3, ' m/s  ',2x,
     +           f18.2,' ft/s')

      if(larea)then
       write(ascrnout,1045)height,height/0.3048
       write(ascrnout,1046)xinit,xinit/0.3048
       write(ascrnout,1047)yinit,yinit/0.3048
c ---  Output Initial Vertical Dimension for AREA source
       write(ascrnout,1058)szinit,szinit/0.3048
       goto 100
      endif
1045  format( ' AREA HEIGHT:                   ',f8.2,' meters',
     +   f19.2,' feet')
1046  format( ' AREA SOURCE LONG SIDE:         ',f8.2,' meters  ',
     +        5x,f12.2,' feet')
1047  format( ' AREA SOURCE SHORT SIDE:        ',f8.2,' meters  ',
     +         5x,f12.2,' feet')

      if(lcirc)then
       write(ascrnout,1048)height,height/0.3048
       write(ascrnout,1049)circrad,circrad/0.3048
c ---  Output Initial Vertical Dimension for AREACIRC source
       write(ascrnout,1058)szinit,szinit/0.3048
       goto 100
      endif
      
 1048  format( ' AREACIRC HEIGHT:   ',12x,f8.2,' meters',
     +  f19.2,' feet')
 1049  format( ' AREACIRC RADIUS:   ',12x,f8.2,' meters',f19.2,
     +         ' feet')

      if(lvolume)then
       write(ascrnout,1056)height,height/0.3048
       write(ascrnout,1057)syinit,syinit/0.3048
       write(ascrnout,1058)szinit,szinit/0.3048
       goto 100
      endif
      
1056  format( ' VOLUME HEIGHT:     ',12x,f8.2,' meters',
     +  f19.2,' feet')
1057  format( ' INITIAL LATERAL DIMENSION: ',4x,f8.2,' meters  ',5x,
     +         f12.2,' feet')
1058  format( ' INITIAL VERTICAL DIMENSION:',f12.2,' meters  ',9x,f8.2,
     +         ' feet')
     
  100 if(lterrain)then
       write(ascrnout,1011)xlong,utmx
       write(ascrnout,1012)xlat,utmy
       write(ascrnout,1013)izone
       write(ascrnout,11013)nada
       write(ascrnout,1014)base,base/0.3048
      endif

 1011  format( ' STACK BASE LONGITUDE:',7x,f11.4,' deg',10x,f12.0,
     +         ' Easting')
 1012  format( ' STACK BASE LATITUDE: ',7x,f11.4,' deg',10x,f12.0,
     +         ' Northing')
1013   format( ' STACK BASE UTM ZONE:',39x,i5)
11013  format( ' REFERENCE DATUM (NADA):',36x,i5)
 1014  format( ' STACK BASE ELEVATION: ',7x,f10.2,' meters',1x,f18.2,
     +         ' feet')
     
      if(lurban) then
       write(ascrnout,1015)
       ipop = NINT(populat)
       write(ascrnout,1016)ipop
      else
       write(ascrnout,1017)
      endif
      
 1015  format(' RURAL OR URBAN:                   URBAN')
 1016  format(' POPULATION:        ',i20)
 1017  format(' RURAL OR URBAN:                   RURAL')
       
      if (lflagpole)then
        write(ascrnout,1021)flagpole,flagpole/0.3048
      endif
 

 1021   format(/,' FLAGPOLE RECEPTOR HEIGHT: ',4x,f9.2,' meters',
     +  10x,f9.2,' feet')
     
      if(lterrain)then
        icnt = 0
        open(idemlist,file='DEMlist.txt',status='old')
        read(idemlist,'(a1)',end=15)tdem
        do i = 1,99
         read(idemlist,'(a)',end=15)line
         read(line,'(a1)')tdem
         if(tdem .ne. ' ' .and. tdem .ne. CHAR(26) .and.
     +    index(line(1:8),'NADGRIDS') .eq. 0)then      ! rwb 07214
          if(icnt .eq. 0)then
           write(ascrnout,1018)line
           icnt = icnt + 1
          else
           write(ascrnout,1019)line
          endif
         endif
        enddo
   15   close(idemlist)

      endif
 1018 format(/' DIGITAL ELEVATION MAP(S)          ',a90)
 1019 format( '                                   ',a90)


      write(ascrnout,1020)probedist,probedist/0.3048
 1020 format(/' INITIAL PROBE DISTANCE = ',f14.0,' meters',5x,
     +  f14.0,' feet')

c --- Write NOx chemistry ----
      if (lno2) then
        write(ascrnout,7000)trim(adjustl(noxchem))
        write(ascrnout,7001)no2stack
        write(ascrnout,7002)o3,trim(adjustl(o3units))  
      endif
 7000 format(//1x,'NOx TO NO2 CHEMISTRY',t61,a)
 7001 format(1x,'NO2/NOx IN-STACK RATIO:',35x,f7.5)
 7002 format(1x,'OZONE BACKGROUND CONCENTRATION:',15x,e12.5,1x,a)


c --- Write Building Information ---

      write(ascrnout,'(//)')
      write(ascrnout,1002)
      write(ascrnout,2000)
 2000 format(' ***********************  BUILDING DOWNWASH PARAMETERS  ',
     +       '**********************')
      write(ascrnout,1002)


      if(igep .ne. 0) then
        bpip = 'Y'
        lbpip=.true.
      endif

c modified 15181 because bpipfile is always non-blank if using downwash
c change to lbpip and lusebpip
!      if (lbpip .and. bpipfile .eq. ' ') then
      if (lbpip .and. .not. lusebpip) then
       write(ascrnout,2001)bheight,bheight/0.3048
       write(ascrnout,2002)blength,blength/0.3048
       write(ascrnout,2003)bwidth,bwidth/0.3048
       write(ascrnout,2004)bangle
       write(ascrnout,2005)sangle
       write(ascrnout,2006)sdistance,sdistance/0.3048

      endif

 2001  format(/' BUILDING HEIGHT:',15x,f8.1,' meters ',f18.1,' feet')
 2002  format( ' MAX BUILDING DIMENSION:',8x,f8.1,' meters  ',4x,f13.1,
     +  ' feet')
 2003  format( ' MIN BUILDING DIMENSION:    ',4x,f8.1,' meters  ',5x,
     +  f12.1,' feet')
 2004  format(' BUILDING ORIENTATION TO NORTH: ',f8.0,' degrees')
 2005  format(' STACK DIRECTION FROM CENTER:   ',f8.0,' degrees')
 2006  format(' STACK DISTANCE FROM CENTER:    ',f8.1,' meters  ',9x,
     + f8.1,' feet')

c modified 15181 because bpipfile is always non-blank if using downwash
c change to lbpip and lusebpip
!      if (lbpip .and. bpipfile .ne. ' ') then
      if (lbpip .and. lusebpip) then
       write(ascrnout,2008)bpipfile
       btemp = 0.0
       do i=1,36
        if(bpiphgt(i) .gt. btemp)btemp = bpiphgt(i)
       enddo
       write(ascrnout,2009)btemp,btemp/0.3048
       btemp = 0.0
       do i=1,36
        if(bpiplen(i) .gt. btemp)btemp = bpiplen(i)
       enddo
       write(ascrnout,2010)btemp,btemp/0.3048
       btemp = 9999.9
       do i=1,36
        if(bpipwid(i) .lt. btemp .and. bpipwid(i) .gt. 0)  !version 16216, only allow non-zero widths
     +    btemp = bpipwid(i)
       enddo
       write(ascrnout,2011)btemp,btemp/0.3048
      endif

 2008  format(/' USER DEFINED BPIPPRM INPUT FILE:      ',a)
 2009  format(/' MAXIMUM BUILDING HEIGHT:   ',f8.1,' meters  ',
     +                                      5x,f12.1,' feet')
 2010  format(/' MAXIMUM BUILDING LENGTH:   ',f8.1,' meters  ',
     +                                      5x,f12.1,' feet')
 2011  format(/' MINIMUM BUILDING WIDTH:    ',f8.1,' meters  ',
     +                                      5x,f12.1,' feet')    
     
      if (.not. lbpip) then
       if(lpoint .or. lflare)then
        write(ascrnout,2012)
       else
        write(ascrnout,2013)
       endif
      endif
 2012  format(/ 9x,' NO BUILDING DOWNWASH HAS BEEN REQUESTED ',
     +            'FOR THIS ANALYSIS')
 2013  format(/15x,' BUILDING DOWNWASH NOT USED FOR NON-',
     +            'POINT SOURCES')

c skip the following if not running AERSCREEN and doing fumigation
      if (.not. runscreen) then
          write(ascrnout,2014)
          goto 500
      endif
 2014 format(/1x,'AERSCREEN not run, no AERSCREEN output')
c JAT probe output summary
      p1=5000.0+gap(2)
      igap = gap
      write(adists(1),'(f14.0)')xnear
      if (igap(1) .eq. igap(2)) then
        write(adists(2),'(f14.0)')probedist
      else
        adists(2)='5000.'
        write(adists(3),'(f14.0)')p1
        write(adists(4),'(f14.0)')probedist
      endif
      if (runprobe) then
        write(ascrnout,3003)
        if (igap(1) .eq. igap(2)) then
          write(ascrnout,3001)igap(1),trim(adjustl(adists(1))),
     +    trim(adjustl(adists(2)))
        else
          write(ascrnout,2999)igap(1),trim(adjustl(adists(1))),
     +    trim(adjustl(adists(2))),igap(2),trim(adjustl(adists(3))),
     +   trim(adjustl(adists(4)))
        endif
        write(ascrnout,3004)
        do i=1,nsec
            if(i .eq. maxsector)then
                flag = '*'
            else
                flag = ' '
            endif
            mt=flowmaxtemp(i)
            if (ntemp .eq. 1) then
                atemp='ANN'
            else if (ntemp .eq. 4) then
                atemp1=season2(mt)  
            else
                atemp1=month(mt)
            endif
            if (ntemp .gt. 1) atemp=atemp1(1:3)
            do jj=1,3
               call upcase(atemp(jj:jj))
            enddo
            write(ascrnout,3006)i,flag,rough(mt,i),flowmax(i),
     +      distance(mt,i),atemp
        enddo
        write(ascrnout,*)'* = worst case flow sector'
       endif
3003  format(//' **************************  PROBE ANALYSIS  ',
     +        '*************************** ')
3004  format(//6x,'Zo       ROUGHNESS       1-HR CONC   DIST      ',
     +  'TEMPORAL'/6x,'SECTOR     LENGTH         (ug/m3)     (m)    ',
     +  '   PERIOD'/6x,'--------------------------------------',
     +  '--------------------------------')
3006  format(6x,i2,a1,6x,f8.3,6x,g12.4,1x,f7.1,6x,a3)

c --- Write Flow Sector Information if available ---

      if(lbpip .or. larea. or. lterrain) then            ! rwb 07214

       write(ascrnout,'(//)')
       write(ascrnout,1002)
       write(ascrnout,3000)

 3000  format(' **************************  FLOW SECTOR ANALYSIS  ',
     +        '*************************** ')
       
       if (igap(1) .eq. igap(2)) then
        write(ascrnout,3001)igap(1),trim(adjustl(adists(1))),
     +    trim(adjustl(adists(2)))
       else
        write(ascrnout,2999)igap(1),trim(adjustl(adists(1))),
     +    trim(adjustl(adists(2))),igap(2),trim(adjustl(adists(3))),
     +   trim(adjustl(adists(4)))
       endif

 3001  format(16x,i4,' meter receptor spacing:',1x,a,
     +  ' meters - ',a,' meters')
 2999  format(16x,i4,' meter receptor spacing:',1x,a,
     +  ' meters - ',a,' meters'
     +  /16x,i4,' meter receptor spacing:',1x,a,' meters - ',a,
     +  ' meters')
       write(ascrnout,1002)

      endif

c --- Print if downwash but not terrain ---

      if(lbpip .and. .not. lterrain) then
       write(ascrnout,3002)
       
 3002  format(//6x,'    FLOW      BUILD   BUILD                    ',
     +             ' MAX 1-HR    DIST  TEMPORAL'/
     + 6x,'   SECTOR     WIDTH  LENGTH    XBADJ    YBADJ  ',
     +  '   CONC       (m)   PERIOD'/
     +  6x,'--------------------------------------------------------',
     +  '---------------------')
       do i=1,36
       if(i .eq. maxsector)then
        flag = '*'
       else
        flag = ' '
       endif
       mt=flowmaxtemp(i)
       if (ntemp .eq. 1) then
         atemp='ANN'
       else if (ntemp .eq. 4) then
         atemp1=season2(mt)  
       else
         atemp1=month(mt)
       endif
       if (ntemp .gt. 1) atemp=atemp1(1:3)
       do jj=1,3
            call upcase(atemp(jj:jj))
       enddo
       write(ascrnout,3005)i*10,flag,bpipwid(i),bpiplen(i),bpipxad(i),
     +                   bpipyad(i),flowmax(i),
     +                   distance(mt,i),atemp
           
       enddo
 3005  format(6x,i8,a1,f8.2,f10.2,2f9.2,g12.4,1x,f7.1,4x,a3)
       write(ascrnout,*)'* = worst case flow sector'
      endif

c --- Print if downwash and terrain ---
      if(lbpip .and. lterrain) then
       write(ascrnout,3012)
 3012  format(//51x,'MAXIMUM  IMPACT RECEPTOR')

       write(ascrnout,3013)
 3013  format(  2x,'    FLOW      BUILD   BUILD      ',
     +      '               1-HR CONC   DIST   HEIGHT  TEMPORAL'/
     +   2x,'   SECTOR     WIDTH   LENGTH   XBADJ    YBADJ  ',
     +             '  (ug/m3)     (m)    (m)     PERIOD'/
     +   2x,'   ------------------------------------------------',
     +   '----------------------------------')

       do i=1,36
       if(i .eq. maxsector)then
        flag = '*'
       else
        flag = ' '
       endif
       mt=flowmaxtemp(i)
       if (ntemp .eq. 1) then
         atemp='ANN'
       else if (ntemp .eq. 4) then
         atemp1=season2(mt)  
       else
         atemp1=month(mt)
       endif
       if (ntemp .gt. 1) atemp=atemp1(1:3)
       do jj=1,3
            call upcase(atemp(jj:jj))
       enddo
c--- change receptor height from ft to m. JAT ---    
      write(ascrnout,3016)i*10,flag,bpipwid(i),bpiplen(i),bpipxad(i),
     +              bpipyad(i),flowmax(i),distance(mt,i),
     +              (terrhgts(mt,i)-base),atemp

       enddo
 3016  format(2x,i8,a1,f8.2,f10.2,2f9.2,g12.4,1x,f7.1,f8.2,5x,a3)
       write(ascrnout,*)'* = worst case flow sector'
      endif
      

c --- Print if terrain but not downwash ---
c JAT 10/27/09 change output format so that all 36 sectors are in 1 column with temporal period added
c JAT do not separate into 2 columns
      if(.not. lbpip .and. lterrain) then
       write(ascrnout,3022)
3022   format(//'             MAXIMUM    IMPACT RECEPTOR   '/
     +          '    FLOW    1-HR CONC    DIST   HEIGHT    TEMPORAL'/
     +   '   SECTOR    (ug/m3)      (m)    (m)       PERIOD'/
     +   '   -----------------------------------------------')

       do i=1,36
       if(i .eq. maxsector)then
        flag = '*'
       else
        flag = ' '
       endif
       mt=flowmaxtemp(i)
       if (ntemp .eq. 1) then
         atemp='ANN'
       else if (ntemp .eq. 4) then
         atemp1=season2(mt)  
       else
         atemp1=month(mt)
       endif
       if (ntemp .gt. 1) atemp=atemp1(1:3)
       do jj=1,3
            call upcase(atemp(jj:jj))
       enddo
        write(ascrnout,3026)i*10,flag,flowmax(i),distance(mt,i),
     +  (terrhgts(mt,i)-base),atemp
       enddo
 3026 format(i8,a1,g12.4,1x,f7.1,f8.2,7x,a3)
       write(ascrnout,*)'* = worst case flow sector'
      endif
      

c --- Print AREA source direction analysis ---
      if(larea)then             ! rwb 07214

       write(ascrnout,3027)
 3027  format(//'    MAXIMUM  IMPACT  RECEPTOR  ',
     &        //'    Zo        SURFACE   1-HR CONC  RADIAL  DIST   ',
     &      'TEMPORAL',
     &         /'    SECTOR    ROUGHNESS  (ug/m3)    (deg)   (m)    ',
     &      'PERIOD',
     &         /'   -------------------------------------------------',
     &    '----')

       do i=1,nsec
         if(i .eq. maxsector)then
          flag = '*'
         else
          flag = ' '
         endif
          mt=flowmaxtemp(i)
          if (ntemp .eq. 1) then
           atemp='ANN'
          else if (ntemp .eq. 4) then
           atemp1=season2(mt)  
          else
           atemp1=month(mt)
          endif
          if (ntemp .gt. 1) atemp=atemp1(1:3)
          do jj=1,3
            call upcase(atemp(jj:jj))
          enddo
          write(ascrnout,3028)i,flag,rough(mt,i),flowmax(i),
     +     (maxdiag(mt,i)-1)*5,distance(mt,i),atemp

      
      enddo
      write(ascrnout,*)'* = worst case diagonal'
 3028  format(i8,a1,4x,f8.3,2x,g12.4,1x,i3,f8.1,5x,a3)


      endif

c --- Write MakeMet Information ---

      write(ascrnout,'(//)')
      write(ascrnout,1002)
      write(ascrnout,4000)
 4000 format(' **********************  MAKEMET METEOROLOGY ',
     +       'PARAMETERS  *********************')
      write(ascrnout,1002)


      write(ascrnout,4001)ambtmin,ambtmax
 4001 format(/' MIN/MAX TEMPERATURE: ',f8.1,' /',f6.1,' (K)')

      write(ascrnout,4002)wsmin
 4002 format(/' MINIMUM WIND SPEED:  ',f8.1,' m/s')

      write(ascrnout,4003)anemht
 4003 format(/' ANEMOMETER HEIGHT:  ',f9.3,' meters')

c write surface characteristics input type
      if (isurf .eq. 0) then
        write(ascrnout,4026)'USER ENTERED'
      elseif (isurf .eq. 9) then
        write(ascrnout,4026)trim(adjustl(aersurf))
      else
        write(ascrnout,4026)'AERMET SEASONAL TABLES'
      endif
 4026 format(/' SURFACE CHARACTERISTICS INPUT:',1x,a)
 
c new output statements for albedo, bowen ratio, and surface roughness 
      if (isurf .ge. 1 .and. isurf .lt. 9) then
          write(ascrnout,4008)landuse(isurf)
          write(ascrnout,4009)climate(iclim)
          write(ascrnout,4010)season2(maxtemp)
      endif
      if (isurf .eq. 9) then
        if (nsec .gt. 1) then
          if (isecaer .eq. nsec) then
            write(ascrnout,4011)isecaer,sector(isecaer),sector(1)
          else
            write(ascrnout,4011)isecaer,sector(isecaer),
     +      sector(isecaer+1)
          endif
        endif
        if (ntemp .eq. 4) then
            write(ascrnout,4010)season2(maxtemp)
        endif
        if (ntemp .eq. 12) then
            write(ascrnout,4012)month(maxtemp)
        endif
      endif
      write(ascrnout,4004)alb(maxtemp,isecaer)
      write(ascrnout,4005)bow(maxtemp,isecaer)
      if (rough(maxtemp,isecaer) .ge. 0.001) then
          write(ascrnout,4006)rough(maxtemp,isecaer)
      else
          write(ascrnout,4007)rough(maxtemp,isecaer)
      endif
      if (adjustar) then
          ustr='ADJUSTED'
      else
          ustr='NOT ADUSTED'
      endif
      write(ascrnout,4032)trim(adjustl(ustr))
    
 4004 format(/' ALBEDO:              ',f8.2)     
 4005 format( ' BOWEN RATIO:         ',f8.2)     
 4006 format( ' ROUGHNESS LENGTH:    ',f8.3,' (meters)')    
 4007 format( ' ROUGHNESS LENGTH:    ',f8.4,' (meters)')   
 4008 format(/' DOMINANT SURFACE PROFILE: ',a20)   
 4009 format( ' DOMINANT CLIMATE TYPE:    ',a20)         
 4010 format( ' DOMINANT SEASON:          ',a6)
 4011 format(/' DOMINANT SECTOR:          ',i2,' ('i3,1x,i3,')')
 4012 format(/' DOMINANT MONTH:           ',a10)     
 4030 format(1x,a20,2(f8.2),f8.3)
 4031 format(1x,a20,2(f8.2),f8.4)
 4032 format(/' SURFACE FRICTION VELOCITY (U*) ',a)
      open(ascrnfil,file='aerscreen.fil',status='old')
!      open(isfcmet,file='aerscreen.sfc',status='old')
      open(isfcmet,file=sfcfil,status='old')
 

   40 read(ascrnfil,'(a)',end=42)line
  
      read(line,'(a2)')temp
      if(temp .ne. '  ')goto 40
      read(line,4015,err=61)conc(2),iy,im,id,ih,xrec,yrec,terr(2) ! JAT 10172
      
 4015 format(8x,e13.6,1x,4i2,2(1X,F13.5),1X,F7.2)  
c      dist(2) = nint(SQRT(xrec*xrec + yrec*yrec))
      dist(2) = SQRT(xrec*xrec + yrec*yrec)
      goto 42

   61 write(*,*)' ** Predicted Maximum Impact Too Large For Allowed ',
     +          'Write Space **'
      write(*,*)' '
      write(*,*)' Reduce Emission Rate By 10%, Then Multiply Predicted',
     +          ' Impact by 10%.'
      write(*,*)' '
      write(*,*)' Repeat as Necessary Until Model Run Succeeds.'
      write(*,*)' '
      write(ilog,*)' ** Predicted Maximum Impact Too Large For ',
     +          'Allowed Write Space **'
      write(ilog,*)' '
      write(ilog,*)' Reduce Emission Rate By 10%, Then Multiply ',
     +          'Predicted Impact by 10%.'
      write(ilog,*)' '
      write(ilog,*)' Repeat as Necessary Until Model Run Succeeds.'
      write(ilog,*)' '
      stop
 42   close(ascrnfil)    
      read(isfcmet,'(a)')line
   44 read(isfcmet,'(a)')line

      read(line,4016)jy,jm,jd,jh                             ! rwb 07214
 4016 format(i2,2i3,4x,i3)                                   ! rwb 07214
    
      if( (iy .ne. jy) .or. (im .ne. jm) .or. (id .ne. jd) .or.    ! rwb 07214
     &    (ih .ne. jh) )goto 44                                   ! rwb 07214

      read(line,4017)(data1(i),i=1,14)
 4017 format(19x,4f7.0,2f11.0,f9.0,3f7.0,f8.0,6x,3f7.0)




      write(ascrnout,4018)
 4018 format(//8x,'METEOROLOGY CONDITIONS USED TO PREDICT OVERALL ',
     +           'MAXIMUM IMPACT')

      write(ascrnout,4019)
 4019 format(8x,'-----------------------------------------------',
     +           '--------------')

      write(ascrnout,94020) iy, im, id, jd, ih               ! rwb 07214
94020 format(/2x,'YR MO DY JDY HR',                          ! rwb 07214
     &       /2x,'-- -- -- --- --',                          ! rwb 07214
     &       /1x,3(1x,i2.2),1x,i3,1x,i2.2)                   ! rwb 07214
      write(ascrnout,4020)
 4020 format(/5x,'H0     U*     W*  DT/DZ ZICNV ZIMCH  M-O LEN    ',
     +           'Z0  BOWEN ALBEDO  REF WS')

      write(ascrnout,4021)
 4021 format('  - - - - - - - - - - - - - - - - - - - - - - - - -',
     +       ' - - - - - - - - - - - - -')

      write(ascrnout,4022)(data1(i),i=1,11)
 4022 format(f7.2,3f7.3,2f6.0,f9.1,f6.3,2f7.2,f8.2)


      write(ascrnout,4023)
 4023 format(/'     HT  REF TA     HT')

      write(ascrnout,4024)
 4024 format(' - - - - - - - - - - -')


      write(ascrnout,4025)(data1(i),i=12,14)
 4025 format(f7.1,f8.1,f7.1)


c     Get delta-H for maximum impact final plume height ---
      deltaH1 = 0.0

       call refws(MAX(height,2.0),data1(7),data1(8),
     &      MAX(data1(5),data1(6)),data1(2),data1(11),data1(12),ustack)
       call plumehgt(data1(13),MAX(data1(5),data1(6)),data1(2),data1(7),
     +data1(14),deltaH1,ustack,hsp,thtas,dtdzs,fb,fm)

c     version 15181, add ustack, hsp, and deltah1 to output
      if(lpoint .or. lflare) write(ascrnout,7026)ustack,hsp,deltaH1,
     + hsp+deltaH1
       
 7026 format(/' WIND SPEED AT STACK HEIGHT (non-downwash):   ',f8.1,
     + ' m/s'/' STACK-TIP DOWNWASH ADJUSTED STACK HEIGHT:    ',f8.1,
     + ' meters'
     + /' ESTIMATED FINAL PLUME RISE (non-downwash):   ',f8.1,
     +' meters'/' ESTIMATED FINAL PLUME HEIGHT (non-downwash): ',
     &   f8.1,' meters')
! 7026 format(/' ESTIMATED FINAL PLUME HEIGHT (non-downwash): ',
!     &   f8.1,' meters')
c get worst case concentrations by distance - moved 6/21/10 -JAT
      write(*,*)'Calculating max concentrations by distance'
     
      if (ldebug) write(*,*)'Writing debug file...'
      open(ascrnout3,file=maxfil,status='unknown')
      if (ldebug) open(ascrnout4,file=debugfil,status='unknown')
      if (.not. lbpip .and. .not. lterrain) then
        nsec1=nsec
      else
        nsec1=36
      endif
      if (runprobe) then
       write(ascrnout3,5014)
       if (ldebug) write(ascrnout4,5014)
      elseif (larea) then
          write(ascrnout3,5018)
          if (ldebug) write(ascrnout4,5018)
      else
       write(ascrnout3,5015)
       if (ldebug) write(ascrnout4,5015)
      endif


 5014 format(' Concentration     Distance Elevation  Season/Month   ',
     +  'Zo sector       Date      H0     U*     W*  DT/DZ ZICNV ',
     +   'ZIMCH  M-O LEN    Z0  BOWEN ALBEDO  REF WS     HT  REF TA',
     +  '     HT')
 5015 format(' Concentration     Distance Elevation  Flow  ',
     +   'Season/Month  Zo sector        Date      H0     U*     W*  ',
     +   'DT/DZ ZICNV ZIMCH  M-O LEN    Z0  BOWEN ALBEDO  REF WS     ',
     +   'HT  REF TA     HT')   
      
 5018 format(' Concentration     Distance Elevation  Diag  ',
     +'Season/Month   Zo sector       Date      H0     U*     W*  ',
     + 'DT/DZ ZICNV ZIMCH  M-O LEN    Z0  BOWEN ALBEDO  REF WS     HT',
     + '  REF TA     HT')     
      do ir=1,irec
        high=0.0
        maxtem=1
        maxsec=1
        do j=1,ntemp
          do is=1,nsec1
            if (conc1(j,is,ir) .gt. high) then
               high=conc1(j,is,ir)
               maxtem=j
               maxsec=is
            endif
            if (ldebug) call writeout(j,is,ir,ascrnout4)
          end do
        end do
          maxconc(ir)=conc1(maxtem,maxsec,ir)
          maxdist(ir)=recdist(maxtem,maxsec,ir)
          maxterr(ir)=terr1(maxtem,maxsec,ir)
          if (ir .eq. 1) then   !this is ambient distance
             conc(1)=maxconc(ir)
             dist(1)=maxdist(ir)
             terr(1)=maxterr(ir)
             ambdir=maxsec
          endif
          if (dist(2) .eq. maxdist(ir)) then
            call writemax(maxtemp,conc(2),dist(2),terr(2),
     +      maxsector,iy,im,id,ih,data1)
          else
!            call writeout(maxtem,maxsec,ir)
            call writeout(maxtem,maxsec,ir,ascrnout3)
            if (ir .lt. irec) then
              if (recdist(maxtem,maxsec,ir) .lt. 
     +        dist(2) .and. dist(2) .lt. 
     +        recdist(maxtem,maxsec,ir+1)) then
                call writemax(maxtemp,conc(2),dist(2),terr(2),
     +          maxsector,iy,im,id,ih,data1)  
              endif    
            endif     
          endif
      end do
      close(ascrnout3)
      if (ldebug) close(ascrnout4)
c  get meteorology of worst case ambient concentration
      if(xnear .ne. 0)then

      open(ascrnout3,file=maxfil,status='old')
      if (runprobe .or. larea) then
        read(ascrnout3,46)iy,im,id,ih,(data1(i),i=1,14)
        
      else
        read(ascrnout3,47)iy,im,id,ih,(data1(i),i=1,14)
      endif
  46  format(/t67,i2,i2,i2,i2,1x,f7.2,
     +   3f7.3,2f6.0,f9.1,f6.3,2f7.2,f8.2,f7.1,f8.1,f7.1)
  47  format(/t73,i2,i2,i2,i2,1x,f7.2,
     +   3f7.3,2f6.0,f9.1,f6.3,2f7.2,f8.2,f7.1,f8.1,f7.1)         


c ---  Abort if zero concentration at ambient boundary ---
       if(im .eq. 0 .and. id .eq. 0)goto 49


       write(ascrnout,4028)
 4028  format(//8x,'METEOROLOGY CONDITIONS USED TO PREDICT AMBIENT ',
     +            'BOUNDARY IMPACT')

       write(ascrnout,4029)
 4029  format(8x,'-----------------------------------------------',
     +            '---------------')

       write(ascrnout,94020) iy, im, id, jd, ih              ! rwb 07214

       write(ascrnout,4020)

       write(ascrnout,4021)

       write(ascrnout,4022)(data1(i),i=1,11)

       write(ascrnout,4023)

       write(ascrnout,4024)

       write(ascrnout,4025)(data1(i),i=12,14)


c     Get delta-H for ambient boundary impact final plume height ---
      deltaH2 = 0.0

       call refws(MAX(height,2.0),data1(7),data1(8),
     &     MAX(data1(5),data1(6)),data1(2),data1(11),data1(12),ustack)
       call plumehgt(data1(13),MAX(data1(5),data1(6)),data1(2),data1(7),
     +data1(14),deltaH2,ustack,hsp,thtas,dtdzs,fb,fm)

      if(lpoint .or. lflare ) write(ascrnout,7026)ustack,hsp,deltaH2,
     + hsp+deltaH2
       

   49 close(ascrnout3)
       
      endif


      close(isfcmet)

c --- write probe maximum concentration
c --- Write automated impact summary ---

      write(ascrnout,'(//)')
      write(ascrnout,1002)
      write(ascrnout,5000)
 5000 format(' ************************ AERSCREEN AUTOMATED DISTANCES ',
     +       '**********************',/,
     +       '                   OVERALL MAXIMUM CONCENTRATIONS BY ',
     +       'DISTANCE')

      write(ascrnout,1002)
c -START HERE 06/03/08

      
c--- change receptor height from ft to m. JAT ---
      if(lterrain)then

       write(ascrnout,5001)
 5001  format(//'                MAXIMUM   RECEPTOR    ',
     +          '                MAXIMUM    RECEPTOR')
       write(ascrnout,5002)
 5002  format(  '        DIST   1-HR CONC   HEIGHT     ',
     +          '        DIST   1-HR CONC    HEIGHT')
       write(ascrnout,5003)
 5003  format(  '         (m)    (ug/m3)     (m)      ',
     +          '         (m)    (ug/m3)       (m)')
       write(ascrnout,5004)
 5004  format(  '     ----------------------------          ',
     +          '-----------------------------')

      else

       write(ascrnout,5005)
 5005  format(//'                       MAXIMUM      ',
     +          '                       MAXIMUM')
       write(ascrnout,5006)
 5006  format(  '             DIST     1-HR CONC     ',
     +          '             DIST     1-HR CONC')
       write(ascrnout,5007)
 5007  format(  '              (m)      (ug/m3)      ',
     +          '              (m)      (ug/m3)')
       write(ascrnout,5008)
 5008  format(  '          ---------------------            ',
     +          '   ---------------------')

      endif

      n=nint(real(irec)/2.0)
      frac=mod(real(irec),2.0)
     
      
      do ir=1,n
         if (lterrain) then
          if (ir .eq. n .and. frac .ne. 0.0) then
            write(ascrnout,5012)maxdist(ir),maxconc(ir),
     +         (maxterr(ir)-base)
          else
           write(ascrnout,5010)maxdist(ir),maxconc(ir),
     +      (maxterr(ir)-base),maxdist(ir+n),maxconc(ir+n),
     +     (maxterr(ir+n)-base)
          endif
        else
          if (ir. eq. n .and. frac .ne. 0.0) then
            write(ascrnout,5013)maxdist(ir),maxconc(ir)
          else
            write(ascrnout,5011)maxdist(ir),maxconc(ir),
     +      maxdist(ir+n),maxconc(ir+n)
          endif
        endif
        
      end do

 5010 format(f13.2,1x,g11.4,f9.2,6x,f13.2,1x,g11.4,f9.2)
 5011 format(4x,f13.2,3x,g11.4,9x,f13.2,3x,g11.4)
 5012 format(f13.2,1x,g11.4,f9.2)
 5013 format(4x,f13.2,3x,g11.4)

c --- Write maximum impact summary ---
      write(ascrnout,'(//)')
      write(ascrnout,1002)
      write(ascrnout,6000)
 6000 format(' **********************  AERSCREEN MAXIMUM IMPACT ',
     +       'SUMMARY  *********************')
      write(ascrnout,1002)
      if (larea .or. lcirc) then 
        write(ascrnout,6020)
        write(*,6020)
      endif
 6020 format(/1x,'3-hour, 8-hour, and 24-hour scaled'/1x,
     +  'concentrations are equal to the 1-hour concentration ',
     +  'as referenced in'/1x,
     +  'SCREENING PROCEDURES FOR ESTIMATING THE AIR QUALITY'/1x,
     +  'IMPACT OF STATIONARY SOURCES, REVISED (Section 4.5.4)'/1x,
     +  'Report number EPA-454/R-92-019'/1x,
     +  'http://www.epa.gov/scram001/guidance_permit.htm'/1x,
     +  'under Screening Guidance')


      open(ascrnfil,file='aerscreen.fil',status='old')



      write(ascrnout,6002)
      write(*,6002)
 6002 format(/22x,'MAXIMUM      SCALED      SCALED      ',
     +                         'SCALED      SCALED')

      write(ascrnout,6003)
      write(*,6003)
 6003 format( 22x,' 1-HOUR      3-HOUR      8-HOUR     ',
     +                        '24-HOUR      ANNUAL')


      write(ascrnout,6004)
      write(*,6004)
 6004 format(3x,'CALCULATION          CONC        CONC',
     +           '        CONC        CONC        CONC')


      write(ascrnout,6005)
      write(*,6005)
 6005 format(4x,'PROCEDURE         (ug/m3)     (ug/m3)',
     +           '     (ug/m3)     (ug/m3)     (ug/m3)')

      write(ascrnout,6006)
      write(*,6006)
 6006 format(1x,'---------------    ----------  ----------  ',
     +          '----------  ----------  ----------')


      if(lterrain)then
        if (lcirc) then
          write(ascrnout,6017)conc(2)*ratio(1),conc(2)*ratio(2),
     +         conc(2)*ratio(3),conc(2)*ratio(4)
          write(*,6017)conc(2)*ratio(1),conc(2)*ratio(2),
     +          conc(2)*ratio(3),conc(2)*ratio(4)
        else
          write(ascrnout,6007)conc(2)*ratio(1),conc(2)*ratio(2),
     +         conc(2)*ratio(3),conc(2)*ratio(4),conc(2)*ratio(5)
          write(*,6007)conc(2)*ratio(1),conc(2)*ratio(2),
     +         conc(2)*ratio(3),conc(2)*ratio(4),conc(2)*ratio(5)
        endif


       write(ascrnout,6009)dist(2),maxsector*10
       write(*,6009)dist(2),maxsector*10
   

c--- change receptor height from ft to m. JAT ---
       write(ascrnout,6010)(terr(2)-base)
       write(*,6010)(terr(2)-base)

      else
        if (lcirc .or. larea) then
          write(ascrnout,6018)conc(2)*ratio(1),conc(2)*ratio(2),
     +         conc(2)*ratio(3),conc(2)*ratio(4)
          write(*,6018)conc(2)*ratio(1),conc(2)*ratio(2),
     +         conc(2)*ratio(3),conc(2)*ratio(4)
        else
          write(ascrnout,6008)conc(2)*ratio(1),conc(2)*ratio(2),
     +         conc(2)*ratio(3),conc(2)*ratio(4),conc(2)*ratio(5)
          write(*,6008)conc(2)*ratio(1),conc(2)*ratio(2),
     +          conc(2)*ratio(3),conc(2)*ratio(4),conc(2)*ratio(5)
       endif
        if (lbpip) then
          write(ascrnout,6009)dist(2),maxsector*10
          write(*,6009)dist(2),maxsector*10
        else
           write(ascrnout,6015)dist(2)
           write(*,6015)dist(2)
        endif
      endif



 6007 format( 1x,'ELEVATED TERRAIN ',5g12.4)
 6017 format( 1x,'ELEVATED TERRAIN ',4g12.4,5x,'N/A')
 6008 format( 1x,'FLAT TERRAIN     ',5g12.4)
 6018 format( 1x,'FLAT TERRAIN     ',4g12.4,5x,'N/A')
 6009 format(/1X,'DISTANCE FROM SOURCE ',F13.2,
     +   ' meters directed toward ',i3,' degrees')
 6015 format(/1X,'DISTANCE FROM SOURCE ',F13.2,' meters')
 6010 format( 1X,'RECEPTOR HEIGHT  ',F8.2,' meters')


      if(xnear .gt. 0)then


        if (larea .or. lcirc) then
        write(ascrnout,6012)conc(1)*ratio(1),conc(1)*ratio(2),
     +               conc(1)*ratio(3),conc(1)*ratio(4)
        write(*,6012)conc(1)*ratio(1),conc(1)*ratio(2),conc(1)*ratio(3),
     +                       conc(1)*ratio(4)
       else        
        write(ascrnout,6011)conc(1)*ratio(1),conc(1)*ratio(2),
     +               conc(1)*ratio(3),conc(1)*ratio(4),conc(1)*ratio(5)
        write(*,6011)conc(1)*ratio(1),conc(1)*ratio(2),conc(1)*ratio(3),
     +                       conc(1)*ratio(4),conc(1)*ratio(5)
       endif

       if (lterrain .or. lbpip) then
         write(ascrnout,6009)dist(1),ambdir*10
         write(*,6009)dist(1),ambdir*10
       else
         write(ascrnout,6015)dist(1)
         write(*,6015)dist(1)
       endif
c--- change receptor height from ft to m. JAT ---
       if(lterrain)then
        write(ascrnout,6010)(terr(1)-base)
        write(*,6010)(terr(1)-base)
       endif

      endif


 6011 format(///1x,'IMPACT AT THE',/,1X'AMBIENT BOUNDARY ',5g12.4)

 6012 format(///1x,'IMPACT AT THE',/,1X'AMBIENT BOUNDARY ',4g12.4,
     +  5x,'N/A')

c fumigation results
c     inversion break-up
 500  if (lfumigate .or. lshore) then
          write(ascrnout,*)' '
          write(ascrnout,1002)
          write(ascrnout,8000)
          write(ascrnout,1002)
          write(*,*)' '
          write(*,1002)
          write(*,8000)
          write(*,1002)
          if (.not. lfumhours) then
              write(ascrnout,8006)
              write(*,8006)
          endif
      endif
      if (lfumigate .and. lfumhours) then
          write(ascrnout,6002)
          write(ascrnout,6003)
          write(ascrnout,8002)
          write(ascrnout,6005)
          write(ascrnout,6006)
          write(ascrnout,8003)invchi*ratio(1),invchi*ratio(2),
     +    invchi*ratio(3),invchi*ratio(4),invchi*ratio(5)
          write(ascrnout,6015)invx
          write(*,6002)
          write(*,6003)
          write(*,8002)
          write(*,6005)
          write(*,6006)
          write(*,8003)invchi*ratio(1),invchi*ratio(2),
     +    invchi*ratio(3),invchi*ratio(4),invchi*ratio(5)
          write(*,6015)invx
      endif
c     shoreline fumigation
      if (lshore .and. lfumhours) then
          if (ltibl) then
              write(ascrnout,8005)shordist
              write(*,8005)shordist
          else
              write(ascrnout,6002)
              write(ascrnout,6003)
              write(ascrnout,8002)
              write(ascrnout,6005)
              write(ascrnout,6006)
              write(ascrnout,8004)shorechi*ratio(1),shorechi*ratio(2),
     +        shorechi*ratio(3),shorechi*ratio(4),shorechi*ratio(5)
              write(ascrnout,6015)shorex
              write(*,6002)
              write(*,6003)
              write(*,8002)
              write(*,6005)
              write(*,6006)
              write(*,8004)shorechi*ratio(1),shorechi*ratio(2),
     +        shorechi*ratio(3),shorechi*ratio(4),shorechi*ratio(5)
              write(*,6015)shorex
          endif
      endif
      
      write(*,6013)
          
 8000 format(1x,'**********************   AERSCREEN FUMIGATION ',
     +    'SUMMARY   *********************')
 8002 format(3x,'FUMIGATION           CONC        CONC        CONC',
     +    '        CONC        CONC')
 8003 format(1x,'INVERSION BREAK-UP',5g12.4/)
 8004 format(1x,'SHORELINE  ',5g12.4/)
 8005 format(/1x,'SHORELINE          PLUME HEIGHT IS BELOW TIBL ',
     +'HEIGHT FOR DISTANCE'/20x,'TO SHORELINE OF ',f8.2,' m.'/20x,
     +'NO SHORELINE FUMIGATION CALCULATION MADE.')
 8006 format(/1x,'NO METEOROLOGICAL HOURS FITTING FUMIGATION CRITERIA',
     + '...'/,1x,'NO FUMIGATION CALCULATIONS MADE')

      
 6013 format(//' ** Restart file is written to "AERSCREEN.INP" **'  )
!      if (.not. ldefault) then
!        write(*,6016)trim(adjustl(outfil(1:n1-1))),
!     +  trim(adjustl(outfil(1:n1-1)))
!      endif
      
! 6016 format(//' ** Restart and log files also written to:',/1x,
!     + a,'.inp'/1x,a,'.log')
      
      if (runscreen) write(*,6014)trim(adjustl(outfil))
 6014 format( /' ** Output is written to '/1x,a//)

      close(ascrnout)
      return
      end

c ----------------------------------------------------------------------
      subroutine writemax(maxt,c,d,t,maxs,iy,im,id,ih,data1)
c write overall maximum concentration to max_conc_distance.txt file
      use main1
      implicit none
 
c maxt:       temporal period of maximum concentration
c iy:         "year" of maximum concentration
c im:         "month" of maximum concentration
c id:         "day" of maximum concentration
c ih:         "hour" of maximum concentration
c k:          data loop counter
c maxs:       sector maximum concentration
c s:          beginning direction of spatial zo sector
c s2:         ending direction of spatial zo sector
c data:       array of meteorological data for .sfc file
c c:          overall maximum concentration
c d:          distance of maximum concentration
c t:          elevation of maximum concentration
c ter:        difference between receptor elevation and source elevation
c atemp:      name of temporal period
c sec:        surface roughness sector range
c junk1:      character string of variable "s"
c junk2:      character string of variable "s2"
c flag:       1-character variable indicating that this is maximum concentration
c date1:      character string of date (iy,im,id,ih)
      integer maxt,iy,im,id,ih,k,maxs,s,s2
      real data1(14),c,d,t,ter
      character atemp*10,sec*7,junk1*3,junk2*3,flag*1,date1*8
      
      flag='*'
      
      write(date1(1:2),'(i2.2)')iy
      write(date1(3:4),'(i2.2)')im
      write(date1(5:6),'(i2.2)')id
      write(date1(7:8),'(i2.2)')ih
c get temporal name
      if (ntemp .eq. 1) then
        atemp='Annual'
      else
        if (isurf .ge. 1 .and. isurf .lt. 9) then
           atemp=season2(maxt)
        else
           if (ntemp .eq. 4) then
             atemp=season2(maxt)
           else
             atemp=month(maxt)
           endif
        endif
      endif
c get spatial sectors
      if (nsec .gt. 1) then
        s=sector(isecaer)
        if (isecaer .eq. nsec) then
          s2=sector(1)
        else
          s2=sector(isecaer+1)
        endif
      else
        s=0
        s2=360
      endif
      write(junk1,'(i3)')s
      write(junk2,'(i3)')s2
      sec=trim(adjustr(junk1))//'-'//trim(adjustl(junk2))
      sec=trim(adjustr(sec)) 
      
c get terrain - base
      if (lterrain) then
        ter=t-base
      else
        ter=0
      endif
      if (runprobe) then
        write(ascrnout3,25)flag,c,d,ter,atemp,
     +  sec,date1,(data1(k),k=1,14)  
      elseif (larea) then
          write(ascrnout3,27)flag,c,d,ter,
     +    real((maxdiag(maxt,maxs)-1)*5),atemp,sec,date1,
     +    (data1(k),k=1,14)  
      else
        write(ascrnout3,26)flag,c,d,ter,maxs*10,
     +  atemp,sec,date1,(data1(k),k=1,14)       
      endif     

  25   format(a1,e13.5,f13.2,f10.2,8x,a10,1x,a7,3x,a8,1x,f7.2,3f7.3,
     +   2f6.0,f9.1,f6.3,2f7.2,f8.2,f7.1,f8.1,f7.1)
 26   format(a1,e13.5,f13.2,f10.2,2x,i4,7x,a10,1x,a7,4x,a8,1x,f7.2,
     +   3f7.3,2f6.0,f9.1,f6.3,2f7.2,f8.2,f7.1,f8.1,f7.1)
 27   format(a1,e13.5,f13.2,f10.2,f6.1,8x,a10,1x,a7,3x,a8,1x,f7.2,3f7.3,
     +   2f6.0,f9.1,f6.3,2f7.2,f8.2,f7.1,f8.1,f7.1)
      return
      end   
    
c ----------------------------------------------------------------------
      subroutine writeout(t,i,r,funit)
c     write out maximum concentrations by distance
      use main1
      
c t:      temporal period of maximum concentration for distance
c i:      sector of maximum concentration
c r:      distance index counter
c eof:    end of file indicator
c im:         "month" of maximum concentration
c id:         "day" of maximum concentration
c ih:         "hour" of maximum concentration
c s:          beginning direction of spatial zo sector
c s2:         ending direction of spatial zo sector
c iuse:       index of surface roughness sector to use
c k:          data loop counter
c funit:      file unit to write data to
c data:       array of meteorological data for .sfc file
c ter:        difference between receptor elevation and source elevation
c sffile:     surface meteorological file to read
c t1:         character string of temporal period index to use
c s1:         character string of iuse or i
c atemp:      name of temporal period
c sec:        surface roughness sector range
c junk1:      character string of variable "s"
c junk2:      character string of variable "s2"
c date1:      character string of date (iy,im,id,ih)

      integer t,i,r,eof,iy,im,id,ih,s,s2,iuse,k,funit
      real data1(14),ter
      character sffile*90,t1*2,s1*2,date1*8,atemp*10,sec*7,
     + junk1*3,junk2*3
      eof=0
      date1=date(t,i,r)
      
      
c get temporal name
      if (ntemp .eq. 1) then
        atemp='Annual'
      else
        if (isurf .ge. 1 .and. isurf .lt. 9) then
           atemp=season2(t)
        else
           if (ntemp .eq. 4) then
             atemp=season2(t)
           else
             atemp=month(t)
           endif
        endif
      endif
      
c get spatial sectors
      if (istage .eq. 1 .or. larea) then
        if (nsec .eq. 1) then
          s=0
          s2=360
        else
          if (i .eq. nsec) then
            s=sector(i)
            s2=sector(1)
          else
            s=sector(i)
            s2=sector(i+1)
          endif
        endif
        write(s1,'(i2.2)')i
      else
        if (nsec .eq. 1) then
          s=0
          s2=360
          iuse=1
        else
          call findsector(i,iuse)
          if (iuse .eq. nsec) then
           s=sector(iuse)
           s2=sector(1)
          else
           s=sector(iuse)
           s2=sector(iuse+1)
          endif
          
        endif
        write(s1,'(i2.2)')iuse
      endif
c get terrain - base
      if (lterrain) then
        ter=terr1(t,i,r)-base
      else
        ter=0
      endif
      
      write(t1,'(i2.2)')t
      write(junk1,'(i3)')s
      write(junk2,'(i3)')s2
      sec=trim(adjustr(junk1))//'-'//trim(adjustl(junk2))
      sec=trim(adjustr(sec))
      
     
      
c     get appropriate surface file of max temporal and spatial sectors
      sffile='aerscreen_'//t1//'_'//s1//'.sfc'
      
      eof=0
      open(unit=45,file=sffile,status='old')
      read(45,15,iostat=eof)iy,im,id,ih,(data1(k),k=1,14)
     
      
 10   if (eof .eq. 0) then
         write(date1(1:2),'(i2.2)')iy
         write(date1(3:4),'(i2.2)')im
         write(date1(5:6),'(i2.2)')id
         write(date1(7:8),'(i2.2)')ih
         if (date1 .eq. date(t,i,r)) then
           if (runprobe) then
!            write(ascrnout3,25)conc1(t,i,r),recdist(t,i,r),ter,atemp,
            write(funit,25)conc1(t,i,r),recdist(t,i,r),ter,atemp,
     +      sec,date1,(data1(k),k=1,14)       
c     +      s,'-',s2,date1,(data1(k),k=1,14)
            elseif (larea) then
              if (funit .eq. ascrnout3) then
                  write(funit,27)conc1(t,i,r),recdist(t,i,r),ter,
     +            real((maxdiag1(t,i,r)-1)*5),atemp,sec,date1,
     +            (data1(k),k=1,14)
              else
                  do d=1,numdiag
                      write(funit,27)aconc2(t,i,d,r),recdist(t,i,r),ter,
     +                real(diag2(t,i,d,r)),atemp,sec,date1,
     +                (data1(k),k=1,14)
                  enddo
              endif
           else
!            write(ascrnout3,26)conc1(t,i,r),recdist(t,i,r),ter,i*10,
            write(funit,26)conc1(t,i,r),recdist(t,i,r),ter,i*10,
     +      atemp,sec,date1,(data1(k),k=1,14)       
c     +      atemp,s,'-',s2,date1,(data1(k),k=1,14)
           endif
         endif
         read(45,20,iostat=eof)iy,im,id,ih,(data1(k),k=1,14)
         go to 10
      endif  
      close(45)
 15   format(/,i2,2i3,4x,i3,4x,4f7.0,2f11.0,f9.0,3f7.0,f8.0,6x,3f7.0)
 20   format(i2,2i3,4x,i3,4x,4f7.0,2f11.0,f9.0,3f7.0,f8.0,6x,3f7.0)
 25   format(e14.5,f13.2,f10.2,8x,a10,1x,a7,3x,a8,1x,f7.2,3f7.3,
     +   2f6.0,f9.1,f6.3,2f7.2,f8.2,f7.1,f8.1,f7.1)
 26   format(e14.5,f13.2,f10.2,2x,i4,7x,a10,1x,a7,4x,a8,1x,f7.2,
     +   3f7.3,2f6.0,f9.1,f6.3,2f7.2,f8.2,f7.1,f8.1,f7.1)
 27   format(e14.5,f13.2,f10.2,f6.1,8x,a10,1x,a7,3x,a8,1x,f7.2,3f7.3,
     +   2f6.0,f9.1,f6.3,2f7.2,f8.2,f7.1,f8.1,f7.1)
      return
      end
            
c ----------------------------------------------------------------------
!      subroutine plumehgt(ambtemp,deltaH,stckws,hsp)
      subroutine plumehgt(ambtemp,zi,ustar,monin,tref,deltaH,
     +stckws,hsp,thta,dtdz,fb,fm)
      
c --- Calculate final plume height based on buoyance and exit velocity ---

      use main1
      implicit none
c beta1   constant (0.6)
c hs      stack height
c ts      stack temperature
c ds      stack diameter
c vs      stack exit velocity
c ta      ambient 2-m temperature
c up      stack top wind speed, 2.5 m/s
c hsp     stack height with stack downwash adjustment
c ambtemp ambient 2-m temperature
c stckws  stack top wind speed, 2.5 m/s
c fb      plume buoyancy flux
c fm      plume momentum flux
c xf      distance to final plume rise (unstable)
c monin   Monin-Obukhov length
c bvf     Brunt-Vaisala frequency
c brunt   function to calculate Brunt-Vaisala frequency 
c ustar   surface friction velocity
c theta   function to calculate theta
c dtdz    potential temperature gradient at stack top
c tref    ambient temperature reference height
c deltah  plume rise
c zi      mixing height


c dhfaer  plume rise from eq. 97 of AERMOD MFD
c xln     neutral length scale
c delhnn  plume rise for near neutral conditions
c deltah2 plume rise from eq. 99 of AERMOD MFD
c ambtemp ambient 2-m temperature
c dhfaer  plume rise from eq. 97 of AERMOD MFD
c xln     neutral length scale
c delhnn  plume rise for near neutral conditions
c deltah2 plume rise from eq. 99 of AERMOD MFD     
      real beta1,hs,ts,ds,vs,ta,up,hsp,ambtemp,deltah,stckws,fb,fm,xf,
     + monin,bvf,theta,dtdz,thta,ustar,tref,brunt,zi,
     +xln,delhnn,dhfaer,deltah2
      

      BETA1 = 0.6
      HS = height
      TS = temperature
      DS = diameter
      VS = velocity
      TA = ambtemp
      UP = stckws

c     calculate variables at stack top
      thta=theta(hs,zi,ambtemp,ustar,monin,tref,dtdz)
      bvf=brunt(thta,dtdz)
c     recalculate ambient temp, TA to be at stack top as in AERMOD (subroutine metini)
      TA = thta - GOVRCP * ( HS + base )
      
      if(temperature .eq. 0.0 .or. temperature .lt. TA)then
c         TS = ambtemp
         TS = TA
      else
         TS = temperature
      endif
    

C     Calculate Stack-tip Downwash Adjusted Stack Height (Eqn. 1-7)

      IF (VS .LT. 1.5*UP) THEN
         HSP = HS - 2.0*DS*(1.5-VS/UP)
      ELSE
         HSP = HS
      END IF

      IF (HSP .LT. 0.0)  HSP = 0.0

!    if(temperature .lt. ambtemp) TS = TA


      FB = (0.25 / TS) * (VS * DS * DS) * 9.816 * (TS - TA)
      FM = (0.25 / TS) * (VS * DS * DS) * VS * TA

c new 15181
c     go ahead and calculate unstable regardless of stability
      if(FB .le. 0.0)then
         Xf = 4.*DS*(VS+3.*UP)*(VS+3.*UP)/(VS*UP)
         deltaH = 3.0 * DS * VS / UP
      else
         if(Fb .gt. 55)then
            Xf = 119. * Fb**0.4
         else
            Xf = 49. * Fb**0.625
         endif
      
         deltaH = (3.0 * FM * Xf / (BETA1*BETA1 * UP*UP) +
     &        3.0 * FB * Xf*Xf /
     &       (2.0 * BETA1*BETA1 * UP*UP*UP) )**0.333333
      endif
      
      
      if (monin .gt. 0.0 .OR. (monin .lt. 0.0 .AND. (HS .GE. ZI))) then
          DHFAER = 2.66 * (FB/(BVF*BVF*UP))**(1.0/3.0)  !eq. 97 of AERMOD MFD
          XLN = FB/(UP*USTAR*USTAR) !see eq. 98 of AERMOD MFD
          DELHNN = 1.2*XLN**0.6 * (HSP + 1.2*XLN)**0.4   !Eq 98 of AERMOD MFD
          deltah2=4.0 * FB**0.25 / (BVF*BVF)**0.375  !eq 99 of AERMOD MFD
          deltaH = MIN( DHFAER,DELHNN,deltah,deltah2)  !limit deltah with unstable
      endif


      return
      end


c -----------------------------------------------------------------------------
      subroutine xycalc(ang,x,y,radius,bx,by)
      implicit none
c --- Convert from degrees to radians ---
      real ang,x,y,radius,bx,by
      x=cos( (270+ang) * 3.14159/180)
      y=tan( (270+ang) * 3.14159/180) * x

      x=(bx + x * radius)
      y=(by - y * radius)

      end



c -----------------------------------------------------------------------------
      subroutine areaXY()
      use main1
      implicit none
      real bx,by,x,y,radius,angle,ang
c      integer ic
      


c --- Longwise length of source is oriented east-west for worse case
c --- because default screen wind direction is from the west

c --- Set center of area to 0,0
      bx = 0
      by = 0
      x = bx - xinit/2
      y = by - yinit/2
      radius = ( (x-bx)**2 + (y-by)**2 )**.5
      angle = (y-by)/(x-bx)
      angle = atan(angle)/(3.14159/180)
      if((x-bx) .gt. 0.0)ang = (90-angle)
      if((x-bx) .le. 0.0)ang = (270-angle)
      call xycalc(ang,x,y,radius,bx,by)
      sw_Y = y
      sw_X = x  
      return

      end


c -----------------------------------------------------------------------------
      subroutine header()
      use main1
      implicit none


c --- Provide header to screen and output ---

      call system("cls")
c     call system("clear")   !for unix/linux
      write(*,1000)versn
c 1000 format(/21x,'AERSCREEN ',a5,' - beta release version')
 1000 format(/29x,'AERSCREEN ',a5)

      end
c ------------------------------------------------------------------------

      subroutine upcase(flag)
c     convert lowercase variable to upper case variable

c flag:       variable to checked
c lower:      string of lowercase letters
c upper:      string of uppercase letters
c i:          index of flag in lower
      integer i
      character flag*1
      character lower*26,upper*26
      i=0
      lower='abcdefghijklmnopqrstuvwxyz'
      upper='ABCDEFGHIJKLMNOPQRSTUVWXYZ'
      
      i=index(lower,flag)

      if (i .gt. 0) flag=upper(i:i)
      return
      end
c ------------------------------------------------------------------------
      subroutine allocarray
      use main1
      implicit none
      integer i2,i,numpt1,id
      real tgap,b1
      
c     inititalize error codes
      ierr=0
      ierr2=0
c-error codes
c    0=no warnings or errors or bad stage 
c    1=Fatal errors
c    2=Fatal errors and bad stage
c    3=Warnings
c    4=Warnings and bad stage
c    5=No warnings but bad stage      
c     surface characteristics
      if (isurf .le. 8) then
        if (isurf .eq. 0) then
          ntemp=1
        else
          ntemp=4
        endif
        nsec=1
       else
         call readaer(2)
      endif
     
      if(larea)then
         diag = atan2(yinit/2., xinit/2.)/0.017453
         numdiag = INT(diag/5.) + 2
      else
         diag = 0.0
         numdiag=0
      end if 

      
c     calculate receptor grid
      call calcrec
      
      if (runprobe .or. larea) then
        i2=nsec
      else
        i2=36
      endif
     
      allocate(alb(ntemp,nsec))
      allocate(bow(ntemp,nsec))
      allocate(rough(ntemp,nsec))
      allocate(highconc(ntemp,i2))
      allocate(flowmax(i2))
      allocate(flowmaxtemp(i2))
      allocate(distance(ntemp,i2))
      allocate(terrhgts(ntemp,i2))
 
      
      alb=0.0
      bow=0.0
      rough=0.0
      
      highconc=0.0
      flowmax=0.0
      flowmaxtemp=0
      distance=0.0
      terrhgts=0.0
      
      if (larea) then
        allocate(maxdiag(ntemp,i2))
        allocate(maxdiag1(ntemp,i2,numpt+1))
        allocate(diag2(ntemp,i2,numdiag,numpt+1))
        allocate(aconc1(numdiag,numpt+1))
        allocate(aconc2(ntemp,i2,numdiag,numpt+1))
        allocate(aterr1(numdiag,numpt+1))
        allocate(adist1(numdiag,numpt+1))
        allocate(aconc(numdiag))
        allocate(adist(numdiag))
        allocate(aterr(numdiag))
        allocate(adate(numdiag,numpt+1))
        aconc1=0.0
        aterr1=0.0
        adist1=0.0
        aconc=0.0
        aconc2=0.0
        adist=0.0
        aterr=0.0
        maxdiag=0
        maxdiag1=0
        diag2=0
      endif
      
      allocate(conc1(ntemp,i2,numpt+1))
      allocate(terr1(ntemp,i2,numpt+1))
      allocate(recdist(ntemp,i2,numpt+1))
      allocate(date(ntemp,i2,numpt+1))
    
      
      conc1=0.0
      terr1=0.0
      recdist=0.0
     


      
100   return
      end
c ------------------------------------------------------------------------
      subroutine calcrec
c     create receptor locations
c     including discrete receptors
      use main1
      implicit none
      
c i:        receptor loop counter
c idisc:    discrete receptor loop counter
c numpt1:   number of gridded receptors + discrete (including duplicates)
c irec1:    receptor loop counter
c ir:       receptor loop counter
c ldup:     logical variable denoting a duplicate distance found
c tgap:     receptor gap used in calculating regular network
c b1:       difference between probe distance and 5000 m
c temprad:  temporary array of regular network receptors
c temprad1: temporary array of regular network + discrete receptors
c           including duplicates
c temprad2: temporary array of regular network + discrete receptors
c           without duplicates 

      integer i,idisc,numpt1,irec1,n,ir
      logical ldup
      real tgap,b1,min1
      real, allocatable, dimension(:) :: temprad
      real, allocatable, dimension(:) :: temprad1
      real, allocatable, dimension(:) :: temprad2
       
      
c get initial number of receptors
      numpt = 200
      gap(1)=25.0
      tgap=probedist/numpt
      if (tgap .lt. 25.0) then
        tgap=25.0
        numpt=probedist/tgap
      else
        tgap=real(nint(tgap))
      endif
c     JAT 11/29/2010, new receptor spacing code outside 5 km
c     get difference between probe distance and 5 km
c     if probe distance is greater than 5 km, or b1 > 0,
c     number of points is now 300, 200 inside 5 km , 100 outside
c    5 km, and calculate gap(2)
      b1=probedist-5000.0
      if (b1 .gt. 0) then

        tgap=b1/100.0
        if (tgap .lt. 25.0) then
          tgap=25.0
          numpt=(b1/25.0)+200
        endif
c        numpt=(b1/25.0)+200
        gap(2)=tgap
      else
        gap(2)=gap(1)
      endif

      
      if (probedist .gt. 5000.0) then
        numpt=(5000.0/gap(1))+(probedist-5000.0)/gap(2)
      endif

c     create regular receptor grid
c     if no discrete receptors are to be used go ahead
c     and create final network
c     otherwise create a temporal regular network
c     and add discrete receptors, sort, and create
c     final network
      if (ldiscrete) then
        allocate(temprad(numpt))
        temprad(1)=gap(1)
        do i=2,numpt
          if (i .le. 200) then
            temprad(i)=temprad(i-1)+gap(1)
          else
            temprad(i)=temprad(i-1)+gap(2)
          endif
        enddo
        call getdiscrete(2)
        numpt1=numpt+ndisc
        allocate(temprad1(numpt1))
        do i=1,numpt1
          if (i .le. numpt) then
            temprad1(i)=temprad(i)
          else
            temprad1(i)=discrete(i-numpt)
          endif
        enddo
c       check for duplicates
        irec1=1  
        do i=2,numpt1
          ldup=.false.
           n=1
           do while (n .lt. i .and. .not. ldup)
              if (temprad1(i) .eq. temprad1(n)) ldup=.true.
              n=n+1
           enddo 
           if (.not. ldup) irec1=irec1+1
        enddo
c     create a temporay network that is non-duplicative and then will be sorted
        numpt=irec1
        allocate(temprad2(numpt))
        temprad2(1)=temprad1(1)
        irec1=1
        do i=2,numpt1
          ldup=.false.
          n=1
          do while (n .lt. i .and. .not. ldup)
            if (temprad1(i) .eq. temprad1(n)) ldup=.true.
            n=n+1
          enddo 
          if (.not. ldup) then
            irec1=irec1+1
            temprad2(irec1)=temprad1(i)
          endif
        enddo
        allocate(recrad(numpt))
c       sort and write
        recrad=temprad2
        do i=1,numpt-1
          min1=recrad(i)
          n=i
          do ir=i+1,numpt
            if (recrad(ir) .lt. min1) then
              min1=recrad(ir)
              n=ir
            endif
          enddo
          recrad(n)=recrad(i)
          recrad(i)=min1
        enddo
        deallocate(temprad1)
        deallocate(temprad2)
        deallocate(temprad)
      else  !no discrete receptors
        allocate(recrad(numpt))
        recrad(1)=gap(1)
        do i=2,numpt
          if (i .le. 200) then
            recrad(i)=recrad(i-1)+gap(1)
          else
            recrad(i)=recrad(i-1)+gap(2)
          endif
        enddo
      endif
      
      return
      end
c ------------------------------------------------------------------------
      subroutine surface
c     add surface characteristics to arrays and run makemet2
      use main1
      implicit none
      
c it:     temporal period loop
c is:     spatial sector loop
c k:      crosswalk between AERMET seaonal assignment and AERSURFACE
c         seasonal assignment
c atemp:  temporal period name
c atemp1: name of season or month.  if annual then = annual
      integer it,is,k
      character atemp*8,atemp1*10
      
      write(*,9)
      write(ilog,9)
      
      
      
      if (isurf .eq. 0) then  !annual, one sector, user defined
        
        alb(1,1)=useralbe
        bow(1,1)=userbown
        rough(1,1)=userlen
        ntemp=1
        nsec=1
        write(*,10)
        write(ilog,10)
      else if (isurf .le. 8) then  !remap AERMET to AERSURFACE order
         
         do it=1,4  !4 seasons, one sector; use AERSURFACE order: winter,spring,summer,fall
           if (it .eq. 1) then  !winter
              k=4
           elseif (it .eq. 2) then !spring
              k=1
           elseif (it .eq. 3) then !summer
              k=2
           else  !fall
              k=3
           endif
           alb(it,1)=albedo(k,isurf)
           bow(it,1)=bowen(k,isurf,iclim)
           rough(it,1)=roughlen(k,isurf)
         end do
         ntemp=4
         nsec=1
         write(*,11)trim(adjustl(landuse(isurf))),
     +    trim(adjustl(climate(iclim)))
         write(ilog,11)trim(adjustl(landuse(isurf))),
     +    trim(adjustl(climate(iclim)))
      else
         call readaer(3)
         if (ntemp .eq. 1) atemp='annual'
         if (ntemp .eq. 4) atemp='seasonal'
         if (ntemp .eq. 12) atemp='monthly'
         write(*,12)atemp,nsec
         write(ilog,12)trim(adjustl(atemp)),nsec
         do is=1,nsec
           if (is .eq. nsec) then
             write(*,13)is,sector(is),sector(1)
             write(ilog,13)is,sector(is),sector(1)
           else
             write(*,13)is,sector(is),sector(is+1)
             write(ilog,13)is,sector(is),sector(is+1)
           endif
         end do
      endif
c     write surface characteristics
      if (isurf .eq. 0) then
        write(*,14)
        write(ilog,14)
        write(*,15)alb(1,1),bow(1,1),rough(1,1)
        write(ilog,15)alb(1,1),bow(1,1),rough(1,1)
      else if (isurf .le. 8) then
        write(*,16)
        write(ilog,16)
        do it=1,ntemp
          write(*,17)season2(it),alb(it,1),bow(it,1),rough(it,1)
          write(ilog,17)season2(it),alb(it,1),bow(it,1),rough(it,1)
        end do
      else
          if (ntemp .eq. 1) atemp=' '
          if (ntemp .eq. 4) atemp='Season'
          if (ntemp .eq. 12) atemp='Month'
          write(*,18)atemp
          write(ilog,18)atemp
        do it=1,ntemp
          if (ntemp .eq. 1) atemp1='Annual'
          if (ntemp .eq. 4) atemp1=season2(it)
          if (ntemp .eq. 12) atemp1=month(it)
          do is=1,nsec
            write(*,19)atemp1,is,alb(it,is),bow(it,is),rough(it,is)
            write(ilog,19)atemp1,is,alb(it,is),bow(it,is),rough(it,is)
          end do
        end do
      endif   
      
!15181 no longer done, files deleted in MAKEMET2 using close command
c     delete any met files before creating new ones

!      call system('del aerscreen*sfc /Q > NUL')
!     call system('del aerscreen*pfl /Q > NUL')
      
 9    format(/'SURFACE CHARACTERISTICS & MAKEMET'/
     +  'Obtaining surface characteristics...')
 10   format(/,'Using user defined surface characteristics')
 11   format(/,'Using AERMET seasonal surface characteristics for ',
     +  a,' with ',a)
 12   format(/'Using ',a,' surface characteristics for ',
     + i2,' spatial sector(s)'/'Sector   Start  End')
 13   format(2x,i2,6x,i3,3x,i3)
 14   format('Annual             Albedo     Bo       zo')
 15   format(t16,2(1x,f8.2),1x,f9.3)
 16   format('Season             Albedo     Bo       zo')
 17   format(a6,t16,2(1x,f8.2),1x,f9.3)
 18   format(a7,t12,'Sector  Albedo     Bo       zo')
 19   format(a10,3x,i2,2(1x,f8.2),1x,f9.3)        
c     now run makemet for each temporal and sector combination
      call makemet2

      return
      end
         
                
c ------------------------------------------------------------------------
      subroutine readaer(iflag)
c     read AERSURFACE output or surface characteristics from AERMET stage 3 input file
c     version 10039, changed input formats to be more generic
c     no specific format now, will work for AERSURFACE output format
c     or other input format, as long as fits conventions of AERMET stage 3 inputs.
c     version 10172, check to make sure number of sectors and temporal sectors (seasons, months, etc.)
c     are correct in body of data when iflag=1
c     version 10201, in anticipation of new AERMET which allows 2 sets of SC, make sure the
c     primary ones are the characteristics used if reading an AERMET file.  Make sure that
c     AERSCREEN does not use the data associated with FREQ_SECT2, SECTOR2, SITE_CHAR2
      use main1
      implicit none
      
c indx:       index value of various text in external file
c eof:        integer end of file indicator
c ns:         sector number read from file
c istart:     sector start direction
c istop:      sector stop direction
c nt:         temporal period number
c iflag:      flag indicating whether to QA file or read file for data
c i:          loop counter
c sector1:    start and stop directions of sectors by temporal period
c it:         temporal loop counter
c is:         sector loop counter
c ntemp1:     number of temporal periods
c nsec1:      number of spatial sectors
c a:          albedo read from file
c b:          bowen ratio read from file
c z:          surface roughness sector read from file
c a1:         array of albedos by temporal period and spatial sector
c b1:         array of bowen ratios by temporal period and spatial sector
c z1:         array of surface roughnesses by temporal period and spatial sector
c minsec:     minimum sector start direction
c line:       line read from surface characteristics file
c atemp:      temporal period resolution read from file
c lexist:     logical variable denoting that file exists
c lfreq:      logical variable denoting that string "FREQ_SECT " found
c lsec:       logical variable denoting that string "SECTOR " found
c lsitechar:  logical variable denoting that string "SITE_CHAR " found          
      integer indx,eof,ns,istart,nt,iflag,i,sector1(2,12),it,is,
     + istop,ntemp1,nsec1
      real a,b,z,a1(12,12),b1(12,12),z1(12,12),minsec
      character line*100,atemp*8
      logical lexist,lfreq,lsec,lsitechar
      
      ntemp1=0
      nsec1=0
      eof=0
      sector1=-999
      a1=-999.0
      b1=-999.0
      z1=-999.0
      badsurf=.false.
      lfreq=.false.
      lsec=.false.
      lsitechar=.false.
      inquire(file=aersurf,exist=lexist)
      if (.not. lexist) then
         fixaer=.true.
         nosurf=.true.
         goto 100
      endif
    
      open(iaersurf,file=aersurf,status='old')
      
      
      if (iflag .eq. 1) then
        read(iaersurf,10,iostat=eof)line
c     first check that the correct keywords FREQ_SECT, SECTOR, and SITE_CHAR are in the file
c     and in the correct order
 20     if (eof .eq. 0) then
          if (line(1:2) .ne. '**') then  !not a comment 
c           convert line to upper case    
            do i=1,100
              call upcase(line(i:i))
            enddo  
            if (index(line,'FREQ_SECT ') .gt. 0 .and. 
     +      index(line,'FREQ_SECT2') .eq. 0) then  
              lfreq=.true. 
              if (lfreq) then
                indx=index(line,'FREQ_SECT') 
                read(line(indx+9:100),*)atemp,nsec1
                atemp=trim(adjustl(atemp))
                if (atemp .eq. 'ANNUAL') ntemp1=1
                if (atemp .eq. 'SEASONAL') ntemp1=4   
                if (atemp .eq. 'MONTHLY')  ntemp1=12
                if (ntemp1 .eq. 0) fixntemp=.true. 
                if (nsec1 .le. 0 .or. nsec1 .gt. 12) fixsec=.true.
              endif
            endif
            if (index(line,'SECTOR ') .gt. 0 .and. 
     +      index(line,'SECTOR2') .eq. 0 .and. lfreq) then ! get sector divisions
              lsec=.true.
              if (lsec) then  !get sector number and sector boundaries
                indx=index(line,'SECTOR')
                read(line(indx+6:100),*)ns,istart,istop
                if (ns .gt. nsec1) then
                  fixsec=.true.
                else
                  sector1(1,ns)=istart
                  sector1(2,ns)=istop
                endif
              endif
            endif
            if (index(line,'SITE_CHAR ') .gt. 0 .and. 
     +      index(line,'SITE_CHAR2') .eq. 0 .and. lfreq .and. lsec) then
              lsitechar=.true.
              if (lsitechar) then
                read(line(indx+9:100),*)nt,ns,a,b,z
                if (nt .gt. ntemp1 .or. ns .gt. nsec1) then
                  if (nt .gt. ntemp1) fixntemp=.true.
                  if (ns .gt. nsec1) fixsec=.true.
                else
                  a1(nt,ns)=a
                  b1(nt,ns)=b
                  z1(nt,ns)=z  
                endif
              endif
             endif
           endif
           read(iaersurf,10,iostat=eof)line
           goto 20
        endif
        if (.not. lfreq .or. .not. lsec .or. .not. lsitechar) then  !file not formattec correctly
          fixaer=.true.
          badsurf=.true.
          goto 100
        endif
        if (fixntemp .or. fixsec) then  !problem with number of sectors or temporal resolution
          fixaer=.true.
          goto 100
        endif
c       check that no sector boundaries are missing
c        minsec=minval(sector1)
        minsec=1.0
        
        do is=1,nsec1
          if (sector1(1,is) .lt. 0.0) minsec=sector1(1,is)
        enddo
        
        if (minsec .lt. 0) then
          fixaer=.true.
          fixsec=.true.
          goto 100
        endif
c       now check that the sectors do not overlap or there are gaps
        do is=2,nsec1
          if (is .lt. nsec1) then
            if (sector1(1,is) .lt. sector1(2,is-1)) fixsec=.true.
          else
            if (sector1(2,is) .ne. sector1(1,1) .and. (sector1(2,is) 
     +      .ne. 360 .and. sector1(1,1) .ne. 0)) fixsec=.true.
          endif
        enddo
        if (fixsec) then
          fixaer=.true.
          goto 100
        endif
c       now check that the surface characteristics are reasonable
        do it=1,ntemp1
          do is=1,nsec1
            if (a1(it,is) .lt. 0.0 .or. a1(it,is) .gt. 1.0)fixalb=.true.
            if (b1(it,is) .eq. -999.0) then
              fixbow=.true.
            else
              if (b1(it,is) .lt. -10.0 .or. b1(it,is) .gt. 10.0) then 
                warnbow=.true.
              endif
            endif
            if (z1(it,is) .lt. 0.0) then
              fixzo=.true.
            else
              if (z1(it,is) .lt. 0.001) warnzo=.true. 
              if (z1(it,is) .ge. 2.0) warnzo1=.true.
            endif
          enddo
        enddo
        if (fixalb .or. fixbow .or. fixzo) then
          fixaer=.true.
          goto 100
        endif
      else
        read(iaersurf,10,iostat=eof)line
 21     if (eof .eq. 0) then
          if (line(1:2) .ne. '**') then  !not a comment 
c           convert line to upper case    
            do i=1,100
              call upcase(line(i:i))
            enddo  
            
            if (index(line,'FREQ_SECT ') .gt. 0 .and. 
     +      index(line,'FREQ_SECT2') .eq. 0 .and. iflag .eq. 2) then 
              indx=index(line,'FREQ_SECT')
              read(line(indx+9:100),*)atemp,nsec
              atemp=trim(adjustl(atemp))
              if (atemp .eq. 'ANNUAL') ntemp=1
              if (atemp .eq. 'SEASONAL') ntemp=4   
              if (atemp .eq. 'MONTHLY')  ntemp=12
             
            endif
            if (index(line,'SECTOR ') .gt. 0 .and. 
     +      index(line,'SECTOR2') .eq. 0 .and. iflag .eq. 3) then ! get sector divisions
              indx=index(line,'SECTOR')
              read(line(indx+6:100),*)ns,istart,istop
              sector(ns)=istart
            endif
            if (index(line,'SITE_CHAR ') .gt. 0 .and. 
     +      index(line,'SITE_CHAR2') .eq. 0 .and. iflag .eq. 3) then ! get sector divisions
              indx=index(line,'SITE_CHAR')
              read(line(indx+9:100),*)nt,ns,a,b,z
              alb(nt,ns)=a
              bow(nt,ns)=b
              z=max(z,0.001)
              rough(nt,ns)=z
            endif
          endif
          read(iaersurf,10,iostat=eof)line
          goto 21
        endif
      endif
 10   format(a100)
 30   close(iaersurf)
      
  
 100  return
      end
c     -----------------------------------------------------------------------------------------
      subroutine makemet2
c     create meteorological files using MAKEMET
c      version 16216, allow u* to be adjusted
      use main1
      implicit none
      
c itemp:    temporal loop counter
c isec:     spatial roughness sector loop counter
c sfcfil:   surface meteorological filename
c pflfil:   upper air profile meteorological filename
c t1:       character string of itemp
c s1:       character string isec

      integer itemp,isec
      character t1*2,s1*2
      logical lexist
      
      
c     delete old files
      write(*,*)' Deleting old meteorological files'
      do itemp=1,12
          write(t1,'(i2.2)')itemp
          do isec=1,12
              write(s1,'(i2.2)')isec
              sfcfil='aerscreen_'//t1//'_'//s1//'.sfc'
              pflfil='aerscreen_'//t1//'_'//s1//'.pfl'
              inquire(file=sfcfil,exist=lexist)
              if (lexist) then
                  open(isfcmet,file=sfcfil,status='unknown')
                  close( isfcmet,status='delete')
              endif
              inquire(file=pflfil,exist=lexist)
              if (lexist) then
                  open(ipflmet,file=pflfil,status='unknown')
                  close( ipflmet,status='delete')
              endif
          enddo
      enddo
      
      do itemp=1,ntemp
        write(t1,'(i2.2)')itemp
        do isec=1,nsec
          open(iprompt,file='prompts.inp',status='unknown')

          write(s1,'(i2.2)')isec
       
          sfcfil='aerscreen_'//t1//'_'//s1//'.sfc'
          pflfil='aerscreen_'//t1//'_'//s1//'.pfl'
      
          write(*,100)'Creating met files ',sfcfil,' & ',pflfil
          write(ilog,100)'Creating met files ',sfcfil,' & ',pflfil

c         write inputs to MAKEMET
          write(iprompt,'(a19)')sfcfil
          write(iprompt,'(a19)')pflfil
          write(iprompt,'(f10.4)')wsmin
          write(iprompt,'(f10.4)')anemht 
          write(iprompt,'(a)')ustarflg !version 16216, allow u* to be adjusted
!          write(iprompt,*)'N'   !15181 ustar adjustment flag for MAKEMET
          write(iprompt,*)'1'
          write(iprompt,*)'270'
          write(iprompt,'(2f10.4)')ambtmin,ambtmax
          write(iprompt,'(f10.4)')alb(itemp,isec)
          write(iprompt,'(f10.4)')bow(itemp,isec)
          write(iprompt,'(f10.4)')rough(itemp,isec)

          write(iprompt,*)'n'

          close(iprompt)

          call system("makemet < prompts.inp > NUL")
!          call system("del prompts.inp > NUL")
          call system("copy prompts.inp prompts1.inp")
          open(iprompt,file='prompts.inp',status='old')
          close(iprompt,status='delete')
        end do
      end do
 100  format(/,2(a,a19))
      return
      end  
c------------------------------------------------------------------
      subroutine startstop(modnam,istart1)
c     short subroutine to write the start/stop times of PROBE, FLOWSECTOR, or REFINE
c     version 15181 also called for FUMIGATE and SHORELINE
      use main1
      
c modnam:   subroutine being checked
c rundate:  date of run
c runtime:  time of run
c istart1:  integer indicating whether it is start time or stop time
      character modnam*12 !,rundate*8,runtime*8
      integer istart1
      call datime(rundate,runtime)
      if (istart1 .eq. 1) then
         write(ilog,5)modnam,' started ',rundate,runtime
      else
         write(ilog,5)modnam,' ended ',rundate,runtime
      endif
   5  format(/a12,a,a8,1x,a8)
      return
      end
      
c-------------------------------------------------------------------      
      subroutine aermodqa(modnam,is,it)
c     subroutine to QA AERMOD output to check for WARNINGS and/or ERRORS
      use main1
      implicit none
      
c found1:     logical variable denoting if bad AERMOD run detected
c found2:     logical variable denoting if AERMOD run successful
c badstage:   logical variable denoting that stage in AERMOD file
c             does not match stage being processed
c line:       line read from AERMOD.OUT file
c rundate:    date of run
c runtime:    time of run
c modnam:     stage (PROBE, FLOWSECTOR, or REFINE) of AERMOD run
c blnkln:     variable string of blanks
c atemp:      temporal period of run
c i:          loop counter
c indx:       index value of 'STAGE' in line
c istage1:    stage read from AERMOD.OUT
c is:         flow direction counter of run
c it:         temporal period index of run
c is1:        flow direction of run

      logical found1,found2,badstage
      character line*100,blnkln*100, modnam*12,atemp*10
!     +  !rundate*8,runtime*8,
      integer i,indx,istage1,is,it,is1
      found1=.false.
      found2=.false.
      badstage=.false.
      
      if (ntemp .eq. 1) then
        atemp='Annual'
      else if (ntemp .eq. 4) then
        atemp=season2(it)
      else
        atemp=month(it)
      endif
      
      if (istage .eq. 1 .or. runprobe) then
        is1=is
      else if (larea) then
        is1=(is-1)*5
      else
        is1=is*10
      endif
      call datime(rundate,runtime)
c-error codes
c    0=no warnings or errors or bad stage 
c    1=Fatal errors
c    2=Fatal errors and bad stage
c    3=Warnings
c    4=Warnings and bad stage
c    5=No warnings but bad stage

c-create a variable of blanks for comparison when looking for warning messages
      do i=1,100
        blnkln(i:i)=' '
      end do
c      ierr1=0
c      i1=1
c     write(ilog,*)'***************************************************'
      open(aermdout,file='AERMOD.OUT',status='old')
 5    read(aermdout,'(a)')line
      if(index(line,'STAGE') .gt. 0 .and. .not. badstage)then 
         indx=index(line,'STAGE')
         read(line(indx+6:indx+6),'(i1)') istage1
         if (istage1 .ne. istage) then
           badstage=.true.   
         endif
           goto 5
      elseif(index(line,'AERMOD Finishes UN-successfully') .gt. 0)then
           found1 =.true.
           write(ilog,8)line(8:39),trim(adjustl(modnam)),istage,
     +      trim(adjustl(atemp)),is1
           if (lterrain) then 
               write(ilog,107)nskip
               if (is .eq. 1 .and. istage .eq. 2)nskip2=nskip2+nskip
               if (is .eq. 1 .and. istage .eq. 3)nskip3=nskip3+nskip
           endif
           goto 20
      elseif (index(line,'AERMOD Finishes Successfully') .gt. 0)then
           write(ilog,8)line(8:36),trim(adjustl(modnam)),istage,
     +     trim(adjustl(atemp)),is1
           if (lterrain) then 
               write(ilog,107)nskip
               if (it .eq. 1 .and. istage .eq. 2)nskip2=nskip2+nskip
               if (it .eq. 1 .and. istage .eq. 3)nskip3=nskip3+nskip
           endif
           found2=.true.
           goto 30
      else
           goto 5
      endif
       
 8    format(/a,' for ',a,' stage ',i1,1x,a,' sector ',i3,/)
 20   if (found1) then
        rewind(aermdout)
 25     read(aermdout,'(a)')line
        if(index(line,'FATAL ERROR MESSAGES') .gt. 0)then
           write(ilog,'(a)')line
           do while (index(line,'WARNING MESSAGES') .eq. 0)  
              read(aermdout,'(a)')line
              if (index(line,'WARNING MESSAGES') .eq. 0) then
                  write(ilog,'(a)')line
              endif
           end do          
        else
           goto 25
        endif
        if (badstage)then
         ierr(istage)=2
         write(ilog,*)'Process stage does not match stage in AERMOD.OUT'
         write(ilog,100)trim(adjustl(modnam)),istage,istage1
        else
         ierr(istage)=1
        endif
        
        
          write(*,105)
         write(*,*)' See AERSCREEN.LOG for details'
         write(ilog,105)
         write(*,51)'Ending date and time:',rundate,runtime
         write(ilog,51)'Ending date and time:',rundate,runtime
         stop
         close(aermdout)
        
      endif
c -check for warning messages
30    if(found2) then
        rewind(aermdout)
40        read(aermdout,'(a)')line
        if(index(line,'WARNING MESSAGES') .gt. 0)then
           write(ilog,'(a)')line
           do while (index(line,'*****************************') .eq. 0)
              read(aermdout,'(a)')line
              if (line .ne. blnkln .and.
     .         index(line,'*****************************') .eq. 0) then
                write(ilog,'(a)')line
                if (index(line,'NONE') .gt. 0) then
                  ierr(istage)=0
                else
                  ierr(istage)=3
                endif
              endif
           end do
        else
           goto 40
        endif
        if (badstage)then
         if (ierr(istage) .eq. 0) then 
           ierr(istage)=5
         endif
         if (ierr(istage) .eq. 3) then
           ierr(istage)=4
         endif
         write(ilog,*)'Process stage does not match stage in AERMOD.OUT'
         write(ilog,100)istage,istage1
         write(*,100)istage,istage1
         write(ilog,*)'Stop AERSCREEN'
         write(*,*)'Stopping AERSCREEN'
         write(ilog,106)
         write(*,106)
         write(ilog,51)'Ending date and time:',rundate,runtime
         write(*,51)'Ending date and time:',rundate,runtime
         stop         
        endif
        close(aermdout)
      endif 
 100  format('Processing stage for ',a,': ',i1,' Stage in AERMOD.OUT: ',
     +   i1)
 105  format(/1x,'Stopping AERSCREEN'/
     +  1x,'************************************************'/
     +  1x,'             AERSCREEN Finishes UN-Successfully '/
     +  1x,'************************************************')
 106  format(/1x,'Stopping AERSCREEN'/
     +  1x,'             AERSCREEN Finishes Successfully    '
     +  1x,'                    but with stage errors       '
     +  1x,'************************************************')
     
 107  format(1x,i8,' receptors skipped due to missing elevations')
 51   format(/,a,2(1x,a8))
      return
      end
c---------------------------------------------------------------------------- 
      subroutine aermapqa
      use main1
      implicit none
      
c line:       line read from AERMAP.OUT file
c rundate:    date of run
c runtime:    time of run
c blnkln:     variable string of blanks
c indx:       index value of 'STAGE' in line
c istage1:    stage read from AERMAP.OUT
c ierror:     error during file read
c i:          loop counter
c misscount:  counter of receptors skipped during AERMAP processing
c istage2:    set to 1 for istage=0 (source elevation run) and istage otherwise
c found1:     logical variable denoting if bad AERMAP run detected
c found2:     logical variable denoting if AERMAP run successful 
c badstage:   logical variable denoting that stage in AERMAP file
c             does not match stage being processed
c lmiss:      logical variable denoting that receptors skipped
      character line*100,blnkln*100 !,rundate*8,runtime*8
      integer indx,istage1,ierror,i,misscount,istage2
      logical found1,found2,badstage,lmiss

      found1=.false.
      found2=.false.
      badstage=.false.
      lmiss=.false.
      misscount=0
      if (istage .eq. 0) then
        istage2=1
      else
        istage2=istage
      endif
      call datime(rundate,runtime)
c-error codes
c    0=no warnings or errors or bad stage 
c    1=Fatal errors
c    2=Fatal errors and bad stage
c    3=Warnings
c    4=Warnings and bad stage
c    5=No warnings but bad stage
      
      do i=1,100
        blnkln(i:i)=' '
      end do
      
      open(aermpout,file='AERMAP.OUT',status='old')
      
 5    read(aermpout,'(a)',iostat=ierror)line
      if(index(line,'STAGE') .gt. 0 .and. .not. badstage)then 
         indx=index(line,'STAGE')
         read(line(indx+6:indx+6),'(i1)') istage1
         if (istage1 .ne. istage) then
           badstage=.true.   
         endif
           goto 5
      elseif(index(line,'AERMAP Finishes UN-successfully') .gt. 0)then
           found1 =.true.
           write(ilog,8)line(1:42),istage
           goto 20
      elseif (index(line,'AERMAP Finishes Successfully') .gt. 0)then
           write(ilog,8)line(1:42),istage
           found2=.true.
           goto 30
      else
         if (ierror .eq. 0) then
           goto 5     
         else 
           goto 101
         endif
      endif
      
 8    format(1x,a,' for stage ',i1)
        
 20   if (found1) then
        rewind(aermpout)
 25     read(aermpout,'(a)')line
        if(index(line,'FATAL ERROR MESSAGES') .gt. 0)then
           write(ilog,'(a)')line
           do while (index(line,'WARNING MESSAGES') .eq. 0)  
              read(aermpout,'(a)')line
              if (index(line,'WARNING MESSAGES') .eq. 0) then
                  write(ilog,'(a)')line
              endif
           end do          
        else
           goto 25
        endif
        if (badstage)then
         write(ilog,*)istage,istage1
         write(ilog,100)istage,istage1
         ierr2(istage2)=2
        else
         ierr2(istage2)=1
        endif
         write(*,11)rundate,runtime
         write(ilog,11)rundate,runtime
         close(aermpout)
        stop
      endif
      
30    if(found2) then
        rewind(aermpout)
40        read(aermpout,'(a)')line
        if(index(line,'WARNING MESSAGES') .gt. 0)then
           write(ilog,'(a)')line
           do while (index(line,'*****************************') .eq. 0)
              read(aermpout,'(a)')line
              if (line .ne. blnkln .and.
     .         index(line,'*****************************') .eq. 0) then
                if (index(line,'OU W410') .gt. 0) then
                   lmiss=.true.
                   misscount=misscount+1
                endif
                write(ilog,'(a)')line
                if (index(line,'NONE') .gt. 0) then
                  ierr2(istage2)=0
                else
                  ierr2(istage2)=3
                endif
              endif
           end do
        else
           goto 40
        endif
        if (badstage)then
         if (ierr2(istage) .eq. 0) then 
           ierr2(istage2)=5
         endif
         if (ierr2(istage) .eq. 3) then
           ierr2(istage2)=4
         endif
crwbtmp  Need to check this condition:  successful with error?
         write(*,100)istage,istage1
         write(ilog,100)istage,istage1
         write(*,12)rundate,runtime
         write(ilog,12)rundate,runtime
         stop         
        endif
        close(aermpout)
      endif
      
      if (lmiss) then
        write(*,13)misscount
        write(ilog,13)misscount
      endif
       
 
 101  if (.not. found1 .and. .not. found2) then
        write(ilog,15)
        write(ilog,14)'Ending date and time:',rundate,runtime
        stop
      endif
 100  format(/1x,'Process stage does not match stage in AERMAP.OUT'/1x,
     +  'Processing stage: ',i1,' Stage in AERMAP.OUT: ',i1)
 11   format(/1x,'Stopping AERSCREEN'/1x,
     +  '************************************************'/1x,
     +  '             AERSCREEN Finishes UN-Successfully '/1x,
     +  '************************************************'/1x,
     +  'Ending date and time:',2(1x,a8))
     
 12   format(/1x,'Stopping AERSCREEN'/1x,
     +  '************************************************'/1x,
     +  '             AERSCREEN Finishes Successfully '/1x,
     +  '                    but with errors             '
     +  '************************************************'/1x,
     +  'Ending date and time:',2(1x,a8))
     
 13   format(/1x,i8,1x,'receptors have missing elevations'/1x,
     +  'and will be skipped in AERMOD processing')
     
 14   format(/,a,2(1x,a8))  
 15   format(/1x,'AERMAP crash:  Error not in AERMAP.OUT'/1x,
     +  'Check source coordinates to ensure they are inside',/1x,
     +  'the terrain files')
      return
      end
c--------------------------------------------------------------------------- 
      subroutine dealloc
c     deallocate arrays
      use main1
      implicit none
    
      deallocate(alb)
      deallocate(bow)
      deallocate(rough)
      deallocate(highconc)
      deallocate(flowmax)
      deallocate(flowmaxtemp)
      deallocate(distance)
      deallocate(terrhgts)
      if (larea) then
        deallocate(maxdiag)
        deallocate(maxdiag1)
        deallocate(aconc1)
        deallocate(aterr1)
        deallocate(adist1)
        deallocate(aconc)
        deallocate(adist)
        deallocate(aterr)
        deallocate(adate)
      endif
      
      deallocate(conc1)
      deallocate(terr1)
      deallocate(recdist)
      deallocate(date)
      deallocate(recrad)
      return
      end
c---------------------------------------------------------------------------     
c write final messages to logfile
      subroutine finalwrite
      use main1
      implicit none
c rundate:    date of run
c runtime:    time of run
c newlog:     new log file that follows naming convention of output file
c aline:      system call to copy aerscreen.log to logfile1
c logfile1:   new log file based on AERSCREEN output filename
c n1:         index of .out from outfil1
c      character rundate*8,runtime*8,newlog*250,aline*100,logfile1*250
      character line*100
      integer n1,ilog1,eof
      
      
      write(ilog,11)
      write(*,11)
      if (lstop) then
        write(ilog,12)
        write(*,12)
        goto 55
      endif
      if (ierr(1) .eq. 0 .and. ierr(2) .eq. 0 .and. ierr(3) .eq. 0 .and.
     +  ierr2(1) .eq. 0 .and. ierr2(2) .eq. 0 .and.
     +  ierr2(3) .eq. 0) then
        write(ilog,13)
        write(*,13)
        write(ilog,14)
        write(*,14)
      elseif (ierr(1) .eq. 3 .or. ierr(2) .eq. 3 .or. ierr(3) .eq. 3 
     + .or. ierr2(1) .eq. 3 .or. ierr2(2) .eq. 3
     + .or. ierr2(3) .eq. 3) then
        write(*,13)
        write(ilog,13)
        write(*,15)
        write(ilog,15)
       else
        write(*,16)
        write(ilog,16)
        write(*,*)ierr,ierr2
       endif
       if (lswitch) then
         write(ilog,17)
         write(*,17)
       endif
       if (llat .and. lterrain) then
         write(ilog,18)
         write(*,18)
       endif
       if (lnad83) then
         write(ilog,19)
         write(*,19)
       endif
       if (lterrain) then
         write(*,20)nskip2,nskip3
         write(ilog,20)nskip2,nskip3
       endif
       write(ilog,21)
       write(*,21)
       
c     write ending time to log file
 55    call datime(rundate,runtime)
       write(ilog,22)rundate,runtime
       close(ilog)
       if (.not. ldefault) then
           ilog1=75
           eof=0
           open(ilog,file='aerscreen.log',status='old')
           open(ilog1,file=logfil,status='unknown')
           read(ilog,60,iostat=eof)line
  65       if (eof .eq. 0) then
               write(ilog1,60)line
               read(ilog,60,iostat=eof)line
               goto 65
           endif
           close(ilog1)
           close(ilog,status='delete')
        endif
c       if (.not. ldefault .and. .not. nocopy) then
c        n1=index(outfil1,'.OUT')
c        logfile1=outfil(1:n1-1)//'.log'
c        write(aline,100)trim(adjustl(logfile1))
c        call system(aline)
c      endif
        
 11   format(/,1x,'**********************************************')
 12   format(/,1x,'Stopping AERSCREEN')
 
 13   format(1x,'AERSCREEN Finished Successfully')
 14   format(1x,'With no errors or warnings')
 15   format(1x,'But with Warnings') 
 16   format(1x,'AERSCREEN Finished Unsuccessfully')    
 17   format(1x,'Units switched from English to metric')
 18   format(1x,'Source coordinates switched from lat/lon to UTM')
 19   format(1x,'Source coordinates switched from NAD 27 to 83')
 20   format(1x,i8,' receptors skipped for FLOWSECTOR'/1x,
     +          i8,' receptors skipped for REFINE')
 21   format(1x,'Check log file for details'/1x,
     +  '***********************************************')
 22   format(/,1x,'Ending date and time ',2(1x,a8)) 
 60   format(a100)
c 100  format('copy aerscreen.log "',a,'" /y > NUL')
      return
      end
c------------------------------------------------------------------------------         
      SUBROUTINE REFWS( PRFLHT, obulen, sfcz0, zi, ustar, uref, urefht,
     &                  UTHEOR )
C=======================================================================
C                REFWS  Module of the AERMOD Dispersion Model
C
C   Purpose:     To estimate the theoretical wind speed at the
C                specified height from a single observation of wind
C                speed (first nonmissing value above 7*Z0M)
C                and the log-profile function with corrections
C                for stability.
C
C   Input:       Observed wind speed at the reference height (UREF)
C                Observed reference height (UREFHT)
C                Height at which data are needed (PRFLHT)
C                Monin-Obukhov length (OBULEN) as a stability parameter
C                Surface roughness length (SFCZ0)
C
C   Output:      Wind speed at the required level (UTHEOR)
C
C   Assumptions: All the input data exist (i.e., are nonmissing)
C
C   Subprograms:
C                UNSTU  -  algorithm to compute the wind speed at PRFLHT
C                           for an unstable atmosphere (OBULEN < 0.0)
C                STBLU  -  algorithm to compute the wind speed at PRFLHT
C                           for a stable atmosphere
C
C
C   Programmer:  Jim Paumier                        30 September 1993
C                Pacific Environmental Services
C
C   Revision history:
C                Jim Paumier, PES                    5 July 1995
C                  - pass the value of pi as an argument for the 
C                    unstable case
C
C   Reference(s): Addendum (dated 6/2/93) to the 8/6/92 Interface Model
C                 Coding Abstract
C
C-----------------------------------------------------------------------
C
C---- Variable declarations
C
      REAL    :: UNSTU, STBLU, PRFLHT, UTHEOR, VLDLB, PIVALU, KVALU,
     &           UFACT, UFACT2
      REAL    :: obulen, sfcz0, zi, ustar, uref, urefht

      SAVE
C
C
C---- Data dictionary
C
C     UNSTU    Wind speed returned from the theoretical profile for
C              unstable atmosphere
C     STBLU    Wind speed returned from the theoretical profile for
C              stable atmosphere
C     VLDLB    Lower bound height for which the computations are valid
C
C---- Data initializations
C
      PIVALU = 3.14159
      KVALU  = 0.4
C
C
C     Compute the minimum valid height (VLDLB) for these computations.
C     ----------------------------------------------------------------
C
      VLDLB =  7.0 * SFCZ0
C
C     -------------------------------------------------------------
C     Check the location of the reference height and the height at
C     which data are required and profile accordingly.
C
C     The computation is stability dependent: check the stability
C     (the sign of the Monin-Obukhov length: negative for an
C     unstable amosphere, positive for a stable atmosphere).
C     -------------------------------------------------------------
C
      IF( (UREFHT .GT. VLDLB)  .AND.  (UREFHT .LE. ZI) )THEN
C
C        ----------------------------------------------------------
C        The reference height is above the valid lower bound height
C        and below the mixing height
C        ----------------------------------------------------------
C
         IF( (PRFLHT .GT. VLDLB)  .AND.  (PRFLHT .LE. ZI) )THEN
C
C           ---------------------------------------------------------
C           The required height is above the valid lower bound height
C           and below the mixing height - profile directly to the
C           required height
C           ---------------------------------------------------------
C
            IF( OBULEN .LT. 0.0 )THEN
               UTHEOR = UNSTU( UREF,USTAR,PRFLHT,OBULEN,SFCZ0,
     &                  PIVALU, KVALU )
            ELSE
               UTHEOR = STBLU( UREF,USTAR,PRFLHT,OBULEN,SFCZ0,KVALU )
            ENDIF
C
         ELSEIF( PRFLHT .LE. VLDLB )THEN
C
C           ----------------------------------------------------------
C           The required height is below the displacement height -
CRJP        profile only to the valid lower bound height and persist
CRJP        down to the required height
C           profile only to the valid lower bound height and linearly
C           interpolate down to the required height (assuming about a 
CRJP        zero wind speed at Z=0.
C           ----------------------------------------------------------
C
CRJP        Add UFACT

            UFACT = PRFLHT / VLDLB

            IF( OBULEN .LT. 0.0 )THEN
               UTHEOR = UNSTU( UREF,USTAR,VLDLB,OBULEN,SFCZ0,
     &                         PIVALU, KVALU ) * UFACT
            ELSE
               UTHEOR = STBLU( UREF,USTAR,VLDLB,OBULEN,SFCZ0,KVALU ) *
     &           UFACT
            ENDIF
C
         ELSEIF( PRFLHT .GT. ZI )THEN
C
C           --------------------------------------------------------
C           The required height is above the mixing height - profile
C           only to the mixing height and persist to the required ht
C           --------------------------------------------------------
C
            IF( OBULEN .LT. 0.0 )THEN
               UTHEOR = UNSTU( UREF, USTAR, ZI, OBULEN, SFCZ0,
     &                         PIVALU, KVALU )
            ELSE
               UTHEOR = STBLU( UREF, USTAR, ZI, OBULEN, SFCZ0, KVALU )
            ENDIF
C
         ENDIF   ! required ht
C
      ELSEIF( UREFHT .GT. ZI )THEN
C
C        -----------------------------------------------
C        The reference height is above the mixing height
C        -----------------------------------------------
C

         IF( (PRFLHT .GT. VLDLB)  .AND.  (PRFLHT .LE. ZI) )THEN
C
C           ---------------------------------------------------------
C           The required height is above the valid lower bound height
C           and below the mixing height.
C           ---------------------------------------------------------
C
            IF( OBULEN .LT. 0.0 )THEN
               UTHEOR = UNSTU( UREF, USTAR, PRFLHT, OBULEN, SFCZ0,
     &                         PIVALU, KVALU )
            ELSE
               UTHEOR = STBLU( UREF,USTAR,PRFLHT,OBULEN,SFCZ0,KVALU )
            ENDIF
C
C
         ELSEIF( PRFLHT .LT. VLDLB )THEN
C
C           ---------------------------------------------------------
C           The required height is below the valid lower bound height
C           ---------------------------------------------------------
C
            IF( OBULEN .LT. 0.0 )THEN
               UTHEOR = UNSTU( UREF, USTAR, VLDLB, OBULEN, SFCZ0,
     &                         PIVALU, KVALU )
            ELSE
               UTHEOR = STBLU( UREF,USTAR,VLDLB,OBULEN,SFCZ0,KVALU )
            ENDIF
C
         ELSEIF( PRFLHT .GT. ZI )THEN
C
C           --------------------------------------------------------
C           The required height is above the mixing height - use the
C           value from the reference height
C           --------------------------------------------------------
C
            IF( OBULEN .LT. 0.0 )THEN
               UTHEOR = UREF
            ELSE
               UTHEOR = UREF
            ENDIF
C
         ENDIF   ! required ht
      
      ELSEIF (UREFHT .LE. VLDLB) THEN
C        
         UFACT2 = UREFHT/VLDLB

         IF( (PRFLHT .GT. VLDLB)  .AND.  (PRFLHT .LE. ZI) )THEN
C
C           ---------------------------------------------------------
C           The required height is above the valid lower bound height
C           and below the mixing height - profile directly to the
C           required height
C           ---------------------------------------------------------
C
            IF( OBULEN .LT. 0.0 )THEN
               UTHEOR = UNSTU( UREF/UFACT2,USTAR,PRFLHT,OBULEN,SFCZ0,
     &                         PIVALU, KVALU )
            ELSE
               UTHEOR = STBLU( UREF/UFACT2,USTAR,PRFLHT,OBULEN,SFCZ0,
     &                         KVALU )
            ENDIF
C
         ELSEIF( PRFLHT .LE. VLDLB )THEN
C
C           ----------------------------------------------------------
C           The required height is below the displacement height -
CRJP        profile only to the valid lower bound height and persist
CRJP        down to the required height
C           profile only to the valid lower bound height and linearly
C           interpolate down to the required height (assuming about a 
CRJP        zero wind speed at Z=0.
C           ----------------------------------------------------------
C
CRJP        Add UFACT

            UFACT = PRFLHT / VLDLB

            UTHEOR = UREF * UFACT / UFACT2

C
         ELSEIF( PRFLHT .GT. ZI )THEN
C
C           --------------------------------------------------------
C           The required height is above the mixing height - profile
C           only to the mixing height and persist to the required ht
C           --------------------------------------------------------
C
            IF( OBULEN .LT. 0.0 )THEN
               UTHEOR = UNSTU( UREF/UFACT2, USTAR, ZI, OBULEN, SFCZ0,
     &                         PIVALU, KVALU )
            ELSE
               UTHEOR = STBLU( UREF/UFACT2,USTAR,ZI,OBULEN,SFCZ0,KVALU )
            ENDIF
C
         ENDIF   ! required ht
C
      ENDIF   ! reference ht
C
C
      RETURN
      END
C
C
      REAL FUNCTION UNSTU( U, USTR, Z, OBLEN, Z0, VALPI, VALK )
C=======================================================================
C                UNSTU  Module of the AERMOD Dispersion Model
C
C   Purpose:     To compute the wind speed at the specified height
C                for an unstable atmosphere
C
C   Input:       Wind speed at the reference height (U)
C                Reference height (REFHT)
C                Height at which data are needed (Z)
C                Monin-Obukhov length (OBLEN) as a stability parameter
C                Surface roughness length (Z0)
C                Value of pi (3.14159) (VALPI)
C
C   Output:      Wind speed at the required level (UNSTU)
C
C   Assumptions: All the input data exist (i.e., are nonmissing)
C
C
C   Programmer:  Jim Paumier                        30 September 1993
C                Pacific Environmental Services
C
C   Revision history:
C     12/07/94 -  Added the PSI(Z0/L) term to the theoretical wind speed
C     07/05/95 -  removed inclusion of MAIN1.INC; passing in value of pi
C     09/18/95 -  Corrected PSIM terms to include 2 rather than z in the
C                 denominator of the ALOG term.
C
C   Reference(s):  August 6, 1992 Model Coding Abstract and addenda from
C                  the AERMIC workgroup
C
C-----------------------------------------------------------------------
C
CC  X values in this subroutine changed to X0 to avoid conflict
CC   with the global variable--rfl 5/13/94
C
C---- Variable declarations
C
      IMPLICIT NONE

      REAL ::  U, USTR, Z, OBLEN, Z0, X0, X1, XZ0, PSIM, PSIM1,
     &         PSIMZ0, VALPI, VALK
C
C
C---- Data dictionary
C
C     VALPI   = 3.14159...
C     VALK    = 0.4 (von Karman constant)
C     PSIM    Correction for stability at Z
C     PSIM1   Correction for stability at REFHT
C     X0      Interim calculation
C
C---- Data initializations
C
C.......................................................................
C
      
      X0  = ( 1.0 - 16.0 * Z / OBLEN ) ** 0.25

Cjop  Compute term for computation of PSI(Z0/L)
      XZ0 = ( 1.0 - 16.0 * Z0/ OBLEN ) ** 0.25
C
      PSIM   =  2.0 * ALOG( (1.0 + X0) / 2.0 )    +
     &                ALOG( (1.0 + X0*X0) / 2.0 ) -
     &          2.0 * ATAN( X0 ) + VALPI / 2.0

Cjop  Compute PSI(Z0/L)
      PSIMZ0 =  2.0 * ALOG( (1.0 + XZ0) / 2.0 )     +
     &                ALOG( (1.0 + XZ0*XZ0) / 2.0 ) -
     &          2.0 * ATAN( XZ0 ) + VALPI / 2.0
C
      UNSTU = (USTR/VALK) * ( ALOG( Z / Z0 ) - PSIM + PSIMZ0 )
C
      RETURN
      END
C
C
      REAL FUNCTION STBLU( U, USTR, Z, OBLEN, Z0, VALK )
C=======================================================================
C                STBLU  Module of the AERMOD Dispersion Model
C
C   Purpose:     To compute the wind speed at the specified height
C                for the stable atmosphere
C
C   Input:       Wind speed at the reference height (U)
C                Reference height (REFHT)
C                Height at which data are needed (Z)
C                Monin-Obukhov length (OBLEN) as a stability parameter
C                Surface roughness length (Z0)
C
C   Output:      Wind speed at the required level (STBLU)
C
C   Assumptions: All the input data exist (i.e., are nonmissing)
C
C
C   Programmer:  Jim Paumier                        30 September 1993
C                Pacific Environmental Services
C
C   Revision history:
C     12/7/94 -  Added the PSI(Z0/L) term to the theoretical wind speed
C
C   Reference(s):  August 6, 1992 Model Coding Abstract and addenda from
C                  the AERMIC workgroup
C
C-----------------------------------------------------------------------
C
C---- Variable declarations
C
      IMPLICIT NONE

      REAL :: U, USTR, Z, OBLEN, Z0, PSIM, PSIM1, VALK, PSIMZ0
C
C
C---- Data dictionary
C
C     VALK    = 0.4 (von Karman constant)
C     PSIM    Correction for stability at Z
C     PSIM1   Correction for stability at REFHT
C
C---- Data initializations
C
C.......................................................................
C
      PSIM   = -17.0 * ( 1.0 - EXP( -0.29 * Z / OBLEN ) )
      
Cjop  Compute PSI(Z0/L)
      PSIMZ0 = -17.0 * ( 1.0 - EXP( -0.29 * Z0 / OBLEN ) )

      STBLU = (USTR/VALK) * ( ALOG( Z / Z0 ) - PSIM + PSIMZ0 )
C
      RETURN
      END

      SUBROUTINE DATIME ( DCALL, TCALL )
C***********************************************************************
C                 DATIME Module
C
C        PURPOSE: Obtain the system date and time
C
C        PROGRAMMER: Jim Paumier, PES, Inc.
C
C        DATE:    April 15, 1994
C
C        MODIFIED:   Uses Fortran 90 DATE_AND_TIME routine.
C                    R.W. Brode, PES, 8/14/98
C
C        INPUTS:  none
C
C        OUTPUTS: Date and time in character format
C
C        CALLED FROM:  RUNTIME
C***********************************************************************
C
C     Variable Declarations
      IMPLICIT NONE

      CHARACTER DCALL*8, TCALL*8
      CHARACTER CDATE*8, CTIME*10, CZONE*5
      INTEGER  :: IDATETIME(8)
      INTEGER  :: IPTYR, IPTMON, IPTDAY, IPTHR, IPTMIN, IPTSEC

      DCALL = ' '
      TCALL = ' '

C     Call Fortran 90 date and time routine
      CALL DATE_AND_TIME (CDATE, CTIME, CZONE, IDATETIME)

C     Convert year to two digits and store array variables
      IPTYR  = IDATETIME(1) - 100 * INT(IDATETIME(1)/100)
      IPTMON = IDATETIME(2)
      IPTDAY = IDATETIME(3)
      IPTHR  = IDATETIME(5)
      IPTMIN = IDATETIME(6)
      IPTSEC = IDATETIME(7)

C     Write Date and Time to Character Variables, DCALL & TCALL
      WRITE(DCALL, '(2(I2.2,"/"),I2.2)' ) IPTMON, IPTDAY, IPTYR
      WRITE(TCALL, '(2(I2.2,":"),I2.2)' ) IPTHR, IPTMIN, IPTSEC

      RETURN
      END

      SUBROUTINE UTMGEO (KOD,IZONIN,IZONOUT,EAST,NORTH,SLON,SLAT,
     &                   ISPHER)
C***********************************************************************
C     SUBROUTINE UTMGEO (KOD,IZONE,EAST,NORTH,SLON,SLAT,IS)
C
C     The latitude and longitude are returned seconds, not decimal 
C     degrees or other variation
C
C     The exact origins of this routine are unknown, but it is
C     believed to be based on some USGS conversion programs.  RWB
C
C     THIS PROGRAM PERFORMS THE FOLLOWING COMPUTATIONS--
C
C     1.  GEOGRAPHIC TO UTM COORDINATES
C         (ANY ZONE MAY BE EXTENDED THE FULL ZONE WIDTH OF EITHER
C         Adjacent ZONE--9 DEGREES FROM THE CENTRAL MERIDIAN--BY
C         PUNCHING THE ZONE NUMBER WITH THE GEOGRAPHIC COORDINATES.
C         IF NO ZONE NUMBER IS INPUT, THE NORMAL 6-DEGREE BAND IS USED)
C
C     2.  UTM TO GEOGRAPHIC COORDINATES
C         (WHEN CONVERTING PTS IN THE SOUTHERN HEMISPHERE, THE ZONE
C         NUMBER IS PRECEDED BY A MINUS SIGN.  EXTENDED ZONE BOUNDARIES
C         MAY BE USED, AS ABOVE)
C
C     FOR ANY OF THE ABOVE, ONE OF FIVE SHEROIDS MAY BE SELECTED BY
C     AND CONVERGENCE ANGLE MAY BE REQUESTED BY A 1 IN COL 80.
C     AN INTEGER IN COL 60 (CLARKE 1866 IS DEFAULT).  SCALE FACTOR
C
C
C     NB:
C     WITHIN UTMGEO, SOUTHERN HEMISPHERE LATITUDES AND EASTERN HEMISPHERE 
C     LONGITUDES ARE CONSIDERED NEGATIVE.  CALLING ROUTINES IN AERMOD
C     MODEL COMPONENTS ASSUME NEGATIVE FOR WEST LONGITUDE. THE ADJUSTMENT
C     TO POSITIVE FOR WEST LONGITUDE IS MADE UPON ENTERING UTMGEO, AND 
C     RESULTS ARE ADJUSTED BACK TO NEGATIVE FOR WEST BEFORE LEAVING UTMGEO.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      DOUBLE PRECISION :: SLAT,SLON,NORTH,EAST,A(16),B(4),UTZ,SK,THET
      INTEGER :: ISPHER, KOD, IZONE, IZON2, IERR, IDLON
      INTEGER :: IZONIN, IZONOUT

C     DETERMINE SPHEROID PARAMETERS FROM ISPHER INPUT
C                            0=CLARK 1866(DEFAULT) / NAD 27
C                            1=CLARK1880
C                            2=BESSEL
C                            3=MODIFIED MURCURY 1968
C                            4=GRS 80 / NAD 83

C     If a spheroid is required that is not defined here, it is rec-
C     ommended that the appropriate semi-major and semi-minor axes
C     values be substituted for one of the unused parameter sets.
C
C

      IF (KOD .EQ. 555) THEN
C----    CONVERSION IS FROM LAT/LON TO UTM
         IZONE  = IZONIN
         IZON2  = IZONE

C----    Adjust for longitudes that cross the 180E/180W meridian.
C        Include tolerance of about 1m (0.00001 deg) to avoid 
C        reversing sign due to precision.
         if (slon .lt. -180.00001D0*3600.0D0) then
            slon = 360.0D0*3600.0D0 + slon
         else if (slon .gt. 180.00001D0*3600.0D0) then
            slon = -1.0D0*(360.0D0*3600.0D0 - slon)
         end if
         
C----    Reverse sign of input longitude;
C        UTMGEO uses positive for west longitude; calling 
C        routine uses standard convention of negative for west longitude
         SLON   = -1.0D0*SLON
         IDLON  = ABS(IDINT(SLON / 3600.0D0))
         
      ELSE IF (KOD .EQ. 333) THEN
C----    CONVERSION IS FROM UTM TO LAT/LON; ASSIGN ZONE
         IZONE  = IZONIN
         IZON2  = IZONE
      END IF

      A(5)=5.0D5
      A(6)=0.0D0

C---- Adjust A(6) value for South Latitude (SLAT<0 or IZONE<0)
      IF(KOD.EQ.555 .AND. SLAT.LT.0.0D0) A(6)=10.0D6
      IF(IZONE.LT.0) A(6)=10.0D6

      A(7) = 0.0D0
      A(8) = 0.9996D0

C---- Define axes for the datum
      SELECT CASE (ISPHER)

         CASE (0)
            A(15) = 6378206.4D0
            B(1)  = 6356583.8D0

         CASE (1)
            A(15) = 6378249.1450D0
            B(1)  = 6356514.86955D0

         CASE (2)
            A(15) = 6377397.155D0
            B(1)  = 6356078.96284D0

         CASE (3)
            A(15) = 6378150.0D0
            B(1)  = 6356768.337D0

         CASE (4)
            A(15) = 6378137.0D0
            B(1)  = 6356752.31414D0

      END SELECT

      A(16) = ((A(15)-B(1))/A(15))*((A(15)+B(1))/A(15))

C---- Compute coefficients for conversions
      CALL TMCOF(A)

C---- Test for type of conversion, geodetic to UTM or UTM to geodetic
      IF (KOD .EQ. 555) THEN
C----    Convert geodetic to UTM coordinates

C----    Test for zone input on geodetic to UTM indicating over ride of
C        normal 6 degree longitude band.

         IF(IZONE.EQ.0)GO TO 35
         IZONOUT = IZONE
         GO TO 22

C----    Compute central meridiam in seconds for enforced zone.
         IZONE=IZON2
  
  22     CONTINUE

         IF(ABS(IZONE) .LE. 30) THEN
            UTZ=30.0D0-DBLE(ABS(IZONE))
            A(9)=((UTZ*6.0D0)+3.0D0)*3600.0D0

         ELSE
            UTZ=DBLE(ABS(IZONE))-30.0D0
            A(9)=((UTZ*6.0D0)-3.0D0)*(-3600.0D0)
         END IF

         IF(IZON2.NE.0)GO TO 50
         GO TO 40

C----    Compute UTM zone (IZONE) and central meridian in seconds (A9)
C        for geodetic to UTM conversion where zone is not input.

  35     IZONE=30-(IDLON/6)
         IF(SLON.LT.0.0D0)IZONE=IDLON/6+31
         UTZ=30.0D0-DBLE(IZONE)
         A(9)=((UTZ*6.0D0)+3.0D0)*3600.0D0
         IF( SLAT.LT.0.0D0 )THEN
C----       Assign negative zone for south latitudes         
            IZONE = IZONE*(-1)
         END IF

  40     CONTINUE

  50     CALL TMFWD(SLAT,SLON,NORTH,EAST,A,IERR,SK,THET)
  
         IF( SLAT.LT.0.0D0 .AND. IZONE.GT.0 )THEN
C----       Assign negative zone for south latitudes         
            IZONOUT = IZONE*(-1)
         ELSE
            IZONOUT = IZONE
         END IF
         
C----    Reverse sign of longitude back to match input (negative for W)
         SLON = -1.0D0*SLON
                  
         GO TO 150

      ELSE IF( KOD .EQ. 333) THEN
C----    Convert UTM coordinates to geodetic

C----    Compute central meridian in seconds from IZONE input
         UTZ=30.0D0-DBLE(ABS(IZONE))
         A(9)=((UTZ*6.0D0)+3.0D0)*3600.0D0

         CALL TMINV(NORTH,EAST,SLAT,SLON,A,IERR,SK,THET)
         
C----    Adjust for longitudes that cross the 180E/180W meridian         
         if (slon .lt. -180.0D0*3600.0D0) then
            slon = 360.0D0*3600.0D0 + slon
         else if (slon .gt. 180.0D0*3600.0D0) then
            slon = -1.0D0*(360.0D0*3600.0D0 - slon)
         end if

C----    Reverse sign of longitude before returning (output negative for W)         
         SLON = -1.0D0*SLON
         
      END IF

  150 CONTINUE
  
      RETURN
      END SUBROUTINE


C***********************************************************************
C     SUBROUTINE TMCOF(A)
C
C     Purpose: To set up the coefficients to convert geodetic to
C              rectifying latitude and conversely
C
C     Called By:  UTMGEO
C
C     Calls To: <none>
C-----------------------------------------------------------------------
      SUBROUTINE TMCOF(A)

      IMPLICIT NONE

      DOUBLE PRECISION A(16),FAC
      A(10) = (((A(16)*(7.0D0/3.2D1)+(5.0D0/1.6D1))*A(16)+0.5D0)*A(16)+
     &         1.0D0)*A(16)*0.25D0

      A(1)= -(((A(10)*(1.95D2/6.4D1)+3.25D0)*A(10)+3.75D0)*A(10)+3.0D0)*
     &     A(10)

      A(2)=(((1.455D3/3.2D1)*A(10)+(7.0D1/3.0D0))*A(10)+7.5D0)*A(10)**2

      A(3)=-((7.0D1/3.0D0)+A(10)*(9.45D2/8.0D0))*A(10)**3

      A(4)=(3.15D2/4.0D0)*A(10)**4

      A(11)=(((7.75D0-(6.57D2/6.4D1)*A(10))*A(10)-5.25D0)*A(10)+3.0D0)*
     &      A(10)

      A(12)=(((5.045D3/3.2D1)*A(10)-(1.51D2/3.0D0))*A(10)+10.5D0)*
     &      A(10)**2

      A(13)=((1.51D2/3.0D0)-(3.291D3/8.0D0)*A(10))*A(10)**3

      A(14)=(1.097D3/4.0D0)*A(10)**4
C     A(1) to A(4) are for geodetic to rectifying latitude
C        conversion while A(11) to A(14) are coefficients for
C        rectifying to geodetic conversion.

      FAC=A(10)*A(10)

      A(10)=(((2.25D2/6.4D1)*FAC+2.25D0)*FAC+1.0D0)*(1.0D0-FAC)*
     &      (1.0D0-A(10))*A(15)

C     A(10) is now set to radius of sphere with great circle length
C        equal to spheroid meridian length.

      RETURN
      END


C***********************************************************************
C     SUBROUTINE TMINV(NORTH,EAST,SLAT,SLON,A,IERR,SK,THET)
C
C     PURPOSE: To computes latitude and longitude IN SECONDS (slat and
C              slon) from given rectangular coordinates x and y for
C              transverse mercator projection.
C
C     A = array of parameters used in computation, described by comments
C          for SUBR.TMFWD
C     IERR is set to 1 if grid distance from central meridian exceeds
C          0.2 of spheroid semimajor axis numerically or if absolute
C          value of rectifying latitude exceeds 1.47 radians.
C
C     ASSUMPTIONS
C          South latitudes and east longitude are negative.
C
C     MODIFICATIONS:
C          Moved calculation of B(10) to precede the IF test on values
C          out of range.   R.W. Brode, USEPA/OAQPS/AQMG, 01/12/09
C
C     Called By:  UTMGEO
C
C     Calls to:  <none>
C-----------------------------------------------------------------------
      SUBROUTINE TMINV(NORTH,EAST,SLAT,SLON,A,IERR,SK,THET)

      IMPLICIT NONE

      DOUBLE PRECISION SLAT,SLON,A(16),B(12),SINW,COSW,RN,T,TS,ETAS,
     & NORTH,EAST,X,Y,SK,BN,BNS,THET
      INTEGER IERR

      Y=NORTH
      X=EAST

      IERR=0
      B(9)=((A(5)-X)*1.0D-6)/A(8)
      B(10)=((Y-A(6))/A(8)+A(7))/A(10)

      IF ((DABS(B(9))-1.0D-7*A(15)*2.0D0 .GT. 0.0D0) .OR.
     &    (DABS(B(10))-1.47D0 .GT. 0.0D0)) THEN
         IERR=1
         SLAT=0.0D0
         SLON=0.0D0

      ELSE
         SINW=DSIN(B(10))
         COSW=DCOS(B(10))

         B(12)=COSW*COSW

         B(11)=(((A(14)*B(12)+A(13))*B(12)+A(12))*B(12)+A(11))
     &         *SINW*COSW+B(10)

         SINW=DSIN(B(11))
         COSW=DCOS(B(11))

         RN=DSQRT(1.0D0-A(16)*SINW*SINW)*1.0D6/A(15)

         T=SINW/COSW
         TS=T*T

         B(12)=COSW*COSW

         ETAS=A(16)*B(12)/(1.0D0-A(16))

         B(1)=RN/COSW

         B(2)=-T*(1.0D0+ETAS)*RN*RN/2.0D0

         B(3)=-(1.0D0+2.0D0*TS+ETAS)*B(1)*RN*RN/6.0D0

         B(4)=(((-6.0D0-ETAS*9.0D0)*ETAS+3.0D0)*TS+(6.0D0-ETAS*3.0D0)
     &         *ETAS+5.0D0)*T*RN**4/24.0D0

         B(5)=((TS*24.0D0+ETAS*8.0D0+28.0D0)*TS+ETAS*6.0D0+5.0D0)*
     &       B(1)*RN**4/120.0D0

         B(6)=(((ETAS*45.0D0-45.0D0)*TS+ETAS*162.0D0-90.0D0)*TS
     &        -ETAS*107.0D0-61.0D0)*T*RN**6/720.0D0

         B(7)=-(((TS*720.0D0+1320.0D0)*TS+662.0D0)*TS+61.0D0)*B(1)
     &         *RN**6/5040.0D0

         B(8)=(((TS*1575.0D0+4095.0D0)*TS+3633.0D0)*TS+1385.0D0)*T
     &         *RN**8/40320.0D0

         B(10)=B(9)*B(9)

C----    The values of SLAT and SLON are in seconds, not decimal degrees
         SLAT=((((B(8)*B(10)+B(6))*B(10)+B(4))*B(10)+B(2))*B(10)
     &         +B(11))*206264.8062470964D0
         SLON= (((B(7)*B(10)+B(5))*B(10)+B(3))*B(10)+B(1))*B(9)*
     &          206264.8062470964D0 + A(9)

crwb---  The following variables are not needed for AERMOD components:
crwb     Assign dummy values and return
         
         BN   = 0.0D0
         BNS  = 0.0D0 
         SK   = 0.0D0
         THET = 0.0D0
         
crwb         BN=B(9)*RN
crwb         BNS=BN**2

crwb         SK=1.0D0+((1.0D0+ETAS)/2.0D0)*BNS+(1.0D0+6.0D0*ETAS+9.0D0
crwb     &     *ETAS*ETAS+4.0D0*ETAS*ETAS*ETAS-24.0D0*ETAS*ETAS*TS-24.0D0
crwb     &     *ETAS*ETAS*ETAS*TS)*BNS*BNS/24.0D0+(BNS*BNS*BNS)/720.0D0

crwb         SK=SK*A(8)

C---- Compute convergence angle: THET

crwb        THET = (((((((-24.0D0*ETAS-27.0D0)*ETAS-7.0D0)*ETAS+1.0D0)*
crwb     &    ETAS)*TS)+(5.0D0*TS+3.0D0*TS**2)+((((11.0D0*ETAS+20.0D0)*
crwb     &    ETAS+9.0D0)*ETAS+2.0D0)*ETAS)+2.0D0)*(BN**5)*T/15.0D0)+
crwb     &    (T*BN) - (((45.0D0*TS+105.0D0)*TS+77.0D0)*TS+17.0D0)*
crwb     &    ((BN**7)*T/315.0D0)-(((1.0D0+TS-ETAS-2.0D0*ETAS**2)*BN**3)*
crwb     &    T/3.0D0)

crwb        THET=-THET*206264.8062470964D0

      END IF

      RETURN
      END

C***********************************************************************
C     SUBROUTINE TMFWD(SLAT,SLON,NORTH,EAST,A,IERR,SK,THET)

C     PURPOSE: To convert latitude and longitude in seconds (slat and
C              slon) to X and Y on transverse mercator projection.
C
C     A(1) to A(4) are coefficients used to convert geodetic latitude
C          to rectifying latitude,
C     A(5) is false easting,
C     A(6) is false northing,
C     A(8) is scale factor at central meridian
C     A(9) is central meridian in seconds
C     A(10) is radius of sphere having a great circle length equal to
C           spheroid meridian length
C     A(11) to A(14) are coefficients to convert rectifying latitude to
C           geodetic latitude
C     A(15) is semimajor axis of spheroid
C     A(16) is eccentricity squared.

C     IERR is set to 1 if lat exceeds 84 degrees, or
C          long exceeds 0.16 radians
C
C     MODIFICATIONS:
C          Moved calculation of B(10) to precede the IF test on values
C          out of range.   R.W. Brode, USEPA/OAQPS/AQMG, 01/12/09
C
C     Called By: UTMGEO
C
C     Calls To: <none>
C-----------------------------------------------------------------------
      SUBROUTINE TMFWD(SLAT,SLON,NORTH,EAST,A,IERR,SK,THET)

      IMPLICIT NONE

      DOUBLE PRECISION SLAT,SLON,A(16),B(12),SINP,COSP,RN,T,TS,ETAS,
     &                 NORTH,EAST,SK,THET
      INTEGER IERR

      IERR=0

      B(10)=(A(9)-SLON) *4.84813681109536D-6
      
      IF((DABS(SLAT)-302400.0D0 .GT. 0.0D0) .OR.
     &   (DABS(B(10))-0.16D0).GT. 0.0D0) THEN
         IERR=1
         EAST=0.0D0
         NORTH=0.0D0

      ELSE
        B(9)=SLAT*4.84813681109536D-6

        SINP=DSIN(B(9))
        COSP=DCOS(B(9))

        RN=A(15)/DSQRT(1.0D0-A(16)*SINP*SINP)

        T=SINP/COSP
        TS=T*T

        B(11)=COSP*COSP

        ETAS=A(16)*B(11)/(1.0D0-A(16))

        B(1)=RN*COSP

        B(3)=(1.0D0-TS+ETAS)*B(1)*B(11)/6.0D0

        B(5)=((TS-18.0D0)*TS+5.0D0+(14.0D0-58.0D0*TS)*ETAS)*B(1)*
     &       B(11)*B(11)/120.0D0

        B(7)=(((179.0D0-TS)*TS-479.0D0)*TS+61.0D0)*B(1)*B(11)**3
     &       /5040.0D0

        B(12)=B(10)*B(10)

        EAST=(((B(7)*B(12)+B(5))*B(12)+B(3))*B(12)+B(1))*B(10)*A(8)
     &       +A(5)

        B(2)=RN*B(11)*T/2.0D0

        B(4)=(ETAS*(9.0D0+4.0D0*ETAS)+5.0D0-TS)*B(2)*B(11)/12.0D0

        B(6)=((TS-58.0D0)*TS+61.0D0+(270.0D0-330.0D0*TS)*ETAS)*B(2)*
     &       B(11)*B(11)/360.0D0

        B(8)=(((543.0D0-TS)*TS-3111.0D0)*TS+1385.0D0)*B(2)*B(11)**3/
     &        20160.0D0

        NORTH=(((B(8)*B(12)+B(6))*B(12)+B(4))*B(12)+B(2))*B(12)+
     &      ((((A(4)*B(11)+A(3))*B(11)+A(2))*B(11)+A(1))
     &      *SINP*COSP+B(9))*A(10)

        NORTH=(NORTH-A(7))*A(8)+A(6)

crwb--- The following variables are not needed for AERMOD components:
crwb    Assign dummy values and return 

crwb        SK   = 0.0D0
crwb        THET = 0.0D0
        
C---- Compute scale factor: SK

crwb        SK=(((((-24.0D0*ETAS-48.0D0)*ETAS-28.0D0)*ETAS-4.0D0)*TS)+
crwb     &   (((4.0D0*ETAS+13.0D0)*ETAS+14.0D0)*ETAS+5.0D0))*((B(10)**4)/
crwb     &   24.0D0)*B(11)*B(11)+(1.0D0+ETAS)*B(11)*(B(10)*B(10))/
crwb     &   2.0D0+1.0D0

crwb        SK=SK*A(8)

C---- Compute convergence angle: THET

crwb        THET=(B(10)*SINP*(1.0D0+((B(10)**2)*B(11)/3.0D0)*(1.0D0+3.0D0
crwb     &     *ETAS+2.0D0*ETAS**2)+(B(10)**4)*((B(11)**2)/15.0D0)
crwb     &     *(2.0D0-TS)))*206264.8062470964D0

      END IF

      RETURN
      END

C**   PROGRAM NADCON
C**
C**   THE NATIONAL GEODETIC SURVEY NADCON PROGRAM (version 2.10)
C**   HAS BEEN ADAPTED FOR THE AERMAP TERRAIN PROCESSOR.

      SUBROUTINE NADCON(XPT,YPT,XPT2,YPT2,DLOS,DLAS,DLOM,DLAM,KEY)

***********************************************************************
*                                                                     *
* PROGRAM :   NADCON                                                  *
*                                                                     *
* PURPOSE:    COMPUTATION PROGRAM TO CONVERT (OR TRANSFORM)           *
*             POSITIONAL DATA (E.G., LATITUDES AND LONGITUDES) FROM   *
*             THE NORTH AMERICAN DATUM OF 1927 (NAD 27) TO THE        *
*             NORTH AMERICAN DATUM OF 1983 (NAD 83).  THIS PROGRAM    *
*             CAN COMPUTE FROM FROM EITHER DATUM TO THE OTHER.        *
*                                                                     *
*             THE ACTUAL COMPUTATION IS PERFORMED AS AN INTERPOLATION *
*             FROM A REGULARLY-SPACED GRID OF POINTS OBTAINED FROM THE*
*             FITTING OF A MINIMUM-CURVATURE SURFACE TO THE ACTUAL    *
*             SHIFT DATA RESULTING FROM THE NAD 83 ADJUSTMENT.        *
*                                                                     *
*             THE INTERPOLATION IS ACCOMPLISHED BY LOCALLY FITTING    *
*             A CURVED POLYNOMIAL SURFACE TO THE FOUR DATA POINTS     *
*             DEFINING THE SQUARE WHICH SURROUND THE (X,Y) PAIR       *
*             WHERE THE INTERPOLATION IS TO TAKE PLACE.               *
*                                                                     *
*             THE POLYNOMIAL SURFACE IS DEFINED BY:                   *
*                                                                     *
*                         A+BX+CY+DXY=Z                               *
*                                                                     *
*             THE PROGRAM REQUIRES THAT THE USER SPECIFY:             *
*                                                                     *
*             1)  THE NAME OF AN OUTPUT FILE                          *
*                                                                     *
*             2)  THE NAME OF AN INPUT FILE (IF AVAILABLE).           *
*                                                                     *
*                                                                     *
*                                                                     *
*             ESTIMATES OF DATUM SHIFTS IN TERMS OF METERS ARE        *
*             COMPUTED FROM THE SHIFT ESTIMATES USING ELLIPSOIDAL     *
*             SCALING.                                                *
*                                                                     *
*             THIS PROGRAM ALLOWS FOR EITHER NGS STANDARD HORIZONTAL  *
*             DATA FORMATS AS SPECIFIED IN THE FGCC PUBLICATION,      *
*             COMMONLY KNOWN AS THE 'HORIZONTAL BLUE BOOK' (SEE       *
*             SUBROUTINE TYPE3), OR IN A GENERIC FILE FORMAT (SEE     *
*             SUBROUTINE TYPE1 OR SUBROUTINE TYPE2).                  *
*                                                                     *
*             THE CODE CAN BE EASILY MODIFIED TO ACCOMMODATE CUSTOM   *
*             FILE SPECIFICATIONS BY MODIFYING SUBROUTINES: ENDREP,   *
*             GETPT, IPARMS, WRTPT, AND (OPTIONALLY) FHELP.           *
*                                                                     *
*                                                                     *
* VERSION CODE:  1.03                                                 *
*                                                                     *
* VERSION DATE:  APRIL 1, 1991                                        *
*                                                                     *
*        AUTHOR:   WARREN T. DEWHURST, PH.D.                          *
*                    LIEUTENANT COMMANDER, NOAA                       *
*                  ALICE R. DREW                                      *
*                    SENIOR GEODESIST, HORIZONTAL NETWORK BRANCH      *
*                  NATIONAL GEODETIC SURVEY, NOS, NOAA                *
*                  ROCKVILLE, MD   20852                              *

c version 2.10 - 1/20/92
c      added option to select HPGN grids and compute NAD 83 - HPGN
c      conversions - jmb
***********************************************************************

***********************************************************************
*                                                                     *
*                  DISCLAIMER                                         *
*                                                                     *
*   THIS PROGRAM AND SUPPORTING INFORMATION IS FURNISHED BY THE       *
* GOVERNMENT OF THE UNITED STATES OF AMERICA, AND IS ACCEPTED AND     *
* USED BY THE RECIPIENT WITH THE UNDERSTANDING THAT THE UNITED STATES *
* GOVERNMENT MAKES NO WARRANTIES, EXPRESS OR IMPLIED, CONCERNING THE  *
* ACCURACY, COMPLETENESS, RELIABILITY, OR SUITABILITY OF THIS         *
* PROGRAM, OF ITS CONSTITUENT PARTS, OR OF ANY SUPPORTING DATA.       *
*                                                                     *
*   THE GOVERNMENT OF THE UNITED STATES OF AMERICA SHALL BE UNDER NO  *
* LIABILITY WHATSOEVER RESULTING FROM ANY USE OF THIS PROGRAM.  THIS  *
* PROGRAM SHOULD NOT BE RELIED UPON AS THE SOLE BASIS FOR SOLVING A   *
* PROBLEM WHOSE INCORRECT SOLUTION COULD RESULT IN INJURY TO PERSON   *
* OR PROPERTY.                                                        *
*                                                                     *
*   THIS PROGRAM IS PROPERTY OF THE GOVERNMENT OF THE UNITED STATES   *
* OF AMERICA.  THEREFORE, THE RECIPIENT FURTHER AGREES NOT TO ASSERT  *
* PROPRIETARY RIGHTS THEREIN AND NOT TO REPRESENT THIS PROGRAM TO     *
* ANYONE AS BEING OTHER THAN A GOVERNMENT PROGRAM.                    *
*                                                                     *
***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      IMPLICIT INTEGER (I-N)
*     IMPLICIT UNDEFINED (A-Z)

      DOUBLE PRECISION VRSION
      INTEGER MXAREA
c     PARAMETER (VRSION = 1.03D0, MXAREA = 8)
      PARAMETER (VRSION = 2.10D0, MXAREA = 8)

      DOUBLE PRECISION ADLAM, VDLAM, ADLOM, VDLOM
      DOUBLE PRECISION ADLAS, VDLAS, ADLOS, VDLOS
      DOUBLE PRECISION SDLAM, SDLAM2, SDLOM, SDLOM2
      DOUBLE PRECISION SDLAS, SDLAS2, SDLOS, SDLOS2
      DOUBLE PRECISION XSMALL, XBIG, YSMALL, YBIG
      DOUBLE PRECISION DLAM, DLOM, DLAS, DLOS
      DOUBLE PRECISION SMDLAM, BGDLAM, SMDLOM, BGDLOM
      DOUBLE PRECISION SMDLAS, BGDLAS, SMDLOS, BGDLOS
      DOUBLE PRECISION XPT, YPT, XPT2, YPT2
      INTEGER KEY, IPAGE, ITYPE, IFILE
      LOGICAL PAGE, NODATA, SCREEN,dsel

      DOUBLE PRECISION DX, DY, XMAX, XMIN, YMAX, YMIN
      INTEGER NC, NAREA
      COMMON /GDINFO/ DX(MXAREA), DY(MXAREA), XMAX(MXAREA),
     +                XMIN(MXAREA), YMAX(MXAREA), YMIN(MXAREA),
     +                NC(MXAREA), NAREA

      INTEGER LUIN, LUOUT, NOUT, NIN, NAPAR, LUAREA
      COMMON /INOUT/ LUIN, LUOUT, NOUT, NIN, NAPAR, LUAREA(2*MXAREA)

**********************
* INITIALIZE VARIABLES
**********************
      CALL INITL (SCREEN, PAGE, IPAGE, ITYPE,
     +            SMDLAM, BGDLAM, SMDLOM, BGDLOM,
     +            SMDLAS, BGDLAS, SMDLOS, BGDLOS,
     +            ADLAM, VDLAM, SDLAM, SDLAM2,
     +            ADLOM, VDLOM, SDLOM, SDLOM2,
     +            ADLAS, VDLAS, SDLAS, SDLAS2,
     +            ADLOS, VDLOS, SDLOS, SDLOS2,
     +            XSMALL, XBIG, YSMALL, YBIG,dsel)


******************************************************** 
* OPEN NADCON DATA FILES (LATITUDE AND LONGITUDE GRIDS)
*******************************************************

      LUOUT = 7 ! Information is written to AERMAP.OUT  ! crwb

       dsel = .TRUE.

      ITYPE = 3      ! rwb

*********************************
* LOOP (ONCE FOR EACH CONVERSION)
*********************************

      CALL MLOOP (IPAGE, ITYPE, KEY, VRSION,
crwb     +            DLAM, DLOM, DLAS, DLOS,
     +            XPT, YPT, XPT2, YPT2, DLAM, DLOM, DLAS, DLOS,
     +            SDLAM, SDLAM2, SDLOM, SDLOM2,
     +            SDLAS, SDLAS2, SDLOS, SDLOS2,
     +            SMDLAM, BGDLAM, SMDLOM, BGDLOM,
     +            SMDLAS, BGDLAS, SMDLOS, BGDLOS,
     +            XSMALL, XBIG, YSMALL, YBIG,
     +            SCREEN,dsel)

      CLOSE (NIN, STATUS='KEEP')
      CLOSE (NOUT, STATUS='KEEP')
      CLOSE (NAPAR, STATUS='KEEP')
      
crwb  check for values of DLOS and DLAS out-of-range;
crwb  very large values have been seen with corrupted 
crwb  grid files.  write message to main output file
      IF (DABS(DLOS).GT.100.0D0 .OR. DABS(DLAS).GT.100.0D0) THEN
         WRITE(LUOUT,*) ' '
         WRITE(LUOUT,*) 'POTENTIAL NADCON ERROR!!'
         WRITE(LUOUT,*) 'NAD shift values are out-of-range.'
         WRITE(LUOUT,*) 'NAD Grid files may be corrupted.'
         WRITE(LUOUT,*) 'NAD Shifts in arc-seconds:'
         WRITE(LUOUT,*) '    DLOS = ', DLOS
         WRITE(LUOUT,*) '    DLAS = ', DLAS
         WRITE(LUOUT,*) ' '
      END IF

 9999 RETURN

      END


      SUBROUTINE INITL (SCREEN, PAGE, IPAGE, ITYPE,
     +                  SMDLAM, BGDLAM, SMDLOM, BGDLOM,
     +                  SMDLAS, BGDLAS, SMDLOS, BGDLOS,
     +                  ADLAM, VDLAM, SDLAM, SDLAM2,
     +                  ADLOM, VDLOM, SDLOM, SDLOM2,
     +                  ADLAS, VDLAS, SDLAS, SDLAS2,
     +                  ADLOS, VDLOS, SDLOS, SDLOS2,
     +                  XSMALL, XBIG, YSMALL, YBIG,dsel)

*** This subroutine initializes all the variables needed in NADCON

      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      IMPLICIT INTEGER (I-N)
*     IMPLICIT UNDEFINED (A-Z)

      INTEGER MXAREA
      PARAMETER (MXAREA = 8)
      CHARACTER*20 B20
      CHARACTER*80 B80
      PARAMETER (B20 = '                   ', B80 = B20//B20//B20//B20)

      DOUBLE PRECISION ADLAM, VDLAM, ADLOM, VDLOM
      DOUBLE PRECISION ADLAS, VDLAS, ADLOS, VDLOS
      DOUBLE PRECISION SDLAM, SDLAM2, SDLOM, SDLOM2
      DOUBLE PRECISION SDLAS, SDLAS2, SDLOS, SDLOS2
      DOUBLE PRECISION XSMALL, XBIG, YSMALL, YBIG
      DOUBLE PRECISION SMDLAM, BGDLAM, SMDLOM, BGDLOM
      DOUBLE PRECISION SMDLAS, BGDLAS, SMDLOS, BGDLOS
      INTEGER IPAGE, ITYPE
      LOGICAL PAGE, SCREEN, dsel

      CHARACTER*80 CARD
      COMMON /CURNT/ CARD

      INTEGER LUIN, LUOUT, NOUT, NIN, NAPAR, LUAREA
      COMMON /INOUT/ LUIN, LUOUT, NOUT, NIN, NAPAR, LUAREA(2*MXAREA)

* Initialize card variable in common CURNT to blank

      CARD = B80


******************************************************************
*                             INITIALIZE
******************************************************************

* Defaults: SCREEN = .TRUE. => send results to screen
*           PAGE = .FALSE.  => don't start a new page in the output file
*           IPAGE = 0       => current output file page number is 0
*           ITYPE = 0       => interactive input of points
*           dsel  = .FALSE. => select NAD 83, HPGN datum conversion

      SCREEN = .TRUE.
      PAGE = .FALSE.
      IPAGE = 0
      ITYPE = 0
      dsel = .FALSE.

      SMDLAM =  1.0D10
      BGDLAM = -1.0D10
      SMDLOM =  1.0D10
      BGDLOM = -1.0D10
      SMDLAS =  1.0D10
      BGDLAS = -1.0D10
      SMDLOS =  1.0D10
      BGDLOS = -1.0D10

      ADLAM = 0.0D0
      VDLAM = 0.0D0
      SDLAM = 0.0D0
      SDLAM2 = 0.0D0
      ADLOM = 0.0D0
      VDLOM = 0.0D0
      SDLOM = 0.0D0
      SDLOM2 = 0.0D0

      ADLAS = 0.0D0
      VDLAS = 0.0D0
      SDLAS = 0.0D0
      SDLAS2 = 0.0D0
      ADLOS = 0.0D0
      VDLOS = 0.0D0
      SDLOS = 0.0D0
      SDLOS2 = 0.0D0

      XSMALL =  1.0D10
      XBIG   = -1.0D10
      YSMALL =  1.0D10
      YBIG   = -1.0D10

      RETURN
      END
      
      SUBROUTINE COEFF (TEE1, TEE2, TEE3, TEE4, AY, BEE, CEE, DEE)

**********************************************************************
** SUBROUTINE COEFF: GENERATES COEFFICIENTS FOR SURFACE FUNCTION     *
**********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      IMPLICIT INTEGER (I-N)
*     IMPLICIT UNDEFINED (A-Z)

      DOUBLE PRECISION AY, BEE, CEE, DEE
      DOUBLE PRECISION TEE1, TEE2, TEE3, TEE4

      AY = TEE1
      BEE = TEE3 - TEE1
      CEE = TEE2 - TEE1
      DEE = TEE4 - TEE3 - TEE2 + TEE1

      RETURN
      END
      

      SUBROUTINE DGRIDS(ILEN_FLD,NGPATH)

* This subroutine opens the NADCON grids using the default grid
* names and locations.  The default names of the grid areas are
* given in DAREAS and the default base file locations are in DFILES

      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      IMPLICIT INTEGER (I-N)
*     IMPLICIT UNDEFINED (A-Z)

      INTEGER ILEN_FLD
      INTEGER MXAREA, MXDEF
      PARAMETER (MXAREA = 8, MXDEF = MXAREA)

      CHARACTER*80 B80
      CHARACTER*65 B65
      CHARACTER*20 B20
      PARAMETER (B20 = '                   ', B80 = B20//B20//B20//B20)
      PARAMETER (B65 = B20//B20//B20//'     ')

      DOUBLE PRECISION XMAX1, XMIN1, YMAX1, YMIN1
      DOUBLE PRECISION DX1, DY1
      INTEGER IDEF, ITEMP, NC1
      CHARACTER*80 DUM
      CHARACTER*15 DFILES(MXAREA)
      CHARACTER (LEN=ILEN_FLD+15) :: AFILE
      CHARACTER (LEN=ILEN_FLD) :: NGPATH
      CHARACTER*15 DAREAS(MXDEF)
      LOGICAL NOGO, GFLAG

      CHARACTER*15 AREAS
      COMMON /AREAS/ AREAS(MXAREA)

      DOUBLE PRECISION DX, DY, XMAX, XMIN, YMAX, YMIN
      INTEGER NC, NAREA
      COMMON /GDINFO/ DX(MXAREA), DY(MXAREA), XMAX(MXAREA),
     +                XMIN(MXAREA), YMAX(MXAREA), YMIN(MXAREA),
     +                NC(MXAREA), NAREA

      INTEGER LUIN, LUOUT, NOUT, NIN, NAPAR, LUAREA
      COMMON /INOUT/ LUIN, LUOUT, NOUT, NIN, NAPAR, LUAREA(2*MXAREA)

      DATA DUM / B80 /

* DFILES contains the default locations (pathname) of the grid files
* without the .las and .los extensions. (For example 'conus' would
* indicate that the conus.las and conus.los grid files are in the
* current working directory.)  The length of each entry in DFILES may
* be up to 65 characters.  DAREAS contains the default names of these
* areas.  The names are used internally in the program and in the
* program output.  They may be no longer than 15 characters.  They
* must correspond on a one-to-one basis with the file locations in
* the DFILES array.  That is, the first area name in DAREAS must
* be the name that you wish for the first data file set in the
* DFILES array.  You may, of course, have the arrays the same if
* the location of the data file is no longer than 15 characters.
* The locations of the grid files may be differ for each
* installation.  If the pathnames are not correct DFILES (and, possibly,
* DAREAS) may be changed and the program recompiled.

      DATA DFILES /'conus', 'hawaii', 'prvi',
     +             'stlrnc', 'stgeorge', 'stpaul', 'alaska', ' '/
      DATA DAREAS /'Conus', 'Hawaii', 'P.R. and V.I.',
     +             'St. Laurence I.', 'St. George I.', 'St. Paul I.',
     +             'Alaska', ' '/

      GFLAG = .FALSE.
      WRITE (LUOUT, 80) NGPATH
   80 FORMAT (/, '      Default Data Grids', /,
     +           '      NADGRIDS Pathname: ', A,/,
     +           '   #  AREA NAME', /, 1X, 79('=') )

      DO 140 IDEF = 1, MXDEF
        AFILE = NGPATH//DFILES(IDEF)
        IF (AFILE .EQ. B65) GOTO 999

* Try to open a set of default files.
* Do not print error messages for non-existing files.

        ITEMP = NAREA + 1
        CALL OPENFL (AFILE, ITEMP, GFLAG, NOGO, DX1, DY1,
     +               XMAX1, XMIN1, YMAX1, YMIN1, NC1, DUM,
     +               ILEN_FLD+15)

        IF (.NOT. NOGO) THEN

* Set of files opened OK and variables read

          NAREA = ITEMP
          AREAS(NAREA) = DAREAS(IDEF)
          DX(NAREA) = DX1
          DY(NAREA) = DY1
          XMAX(NAREA) = XMAX1
          XMIN(NAREA) = XMIN1
          YMAX(NAREA) = YMAX1
          YMIN(NAREA) = YMIN1
          NC(NAREA) = NC1

          WRITE (LUOUT,120) NAREA, AREAS(NAREA)
  120     FORMAT (2X, I2, 2X, A15/)

        ENDIF

  140 CONTINUE

  999 RETURN
      END
      

      SUBROUTINE FGRID (XPT, YPT, DX, DY, XMAX, XMIN,
     +                  YMAX, YMIN, XGRID, YGRID, IROW, JCOL, NOGO)

**********************************************************************
** SUBROUTINE FGRID: IDENTIFIES THE LOCAL GRID SQUARE FOR INTRP.     *
**********************************************************************

* This subroutine is designed to identify the grid square in which a
* particular point is located and get the corner coordinates
* converted into the index coordinate system.

      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      IMPLICIT INTEGER (I-N)
*     IMPLICIT UNDEFINED (A-Z)

      DOUBLE PRECISION XPT, YPT, XGRID, YGRID
      DOUBLE PRECISION XMAX, XMIN, YMAX, YMIN
      DOUBLE PRECISION DX, DY
      INTEGER IROW, JCOL
      LOGICAL NOGO

      NOGO = .FALSE.

* Check to see it the point is outside the area of the gridded data

      IF (XPT .GE. XMAX  .OR.  XPT .LE. XMIN   .OR.
     +    YPT .GE. YMAX  .OR.  YPT .LE. YMIN ) THEN
        NOGO = .TRUE.
*       WRITE (*,*) '***THE POINT IS OUT OF BOUNDS***'
        GOTO 200
      ENDIF

* Calculate the coordinate values for the point to be interpolated
* in terms of grid indices

      XGRID = ( XPT - XMIN )/DX + 1.D0
      YGRID = ( YPT - YMIN )/DY + 1.D0

* Find the I,J values for the SW corner of the local square

      IROW = IDNINT(YGRID)
      JCOL = IDNINT(XGRID)

  200 RETURN
      END
      

      SUBROUTINE HMS (DD, ID, IM, S)

* Use this to change from decimal degrees (double precision)
* to integer degrees, integer minutes, and decimal seconds (double prec)
* Seconds are assumed to have no more than 5 decimal places

      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      IMPLICIT INTEGER (I-N)
*     IMPLICIT UNDEFINED (A-Z)

      DOUBLE PRECISION SMALL
      PARAMETER (SMALL = 1.D-5)

      DOUBLE PRECISION DD, TEMP
      DOUBLE PRECISION S
      INTEGER ID, IM

      ID = IDINT(DD)
      TEMP = ( DD - DBLE(ID) )*60.0D0
      IM = IDINT(TEMP)
      S = ( TEMP - DBLE(IM) )*60.0D0

      IF (IM .EQ. 60) THEN
        IM = 0
        ID = ID + 1
      ENDIF

      IF (S .LT. SMALL) S = 0.0D0

      IF (S .GT. (60.0D0-SMALL)  ) THEN
        S = 0.0D0
        IM = IM + 1
      ENDIF

      RETURN
      END


      SUBROUTINE INTRP (IAREA, IROW, NC, JCOL, XGRID, YGRID,
     +                  XPT, YPT, XPT2, YPT2, DLOS, DLAS, DLAM, DLOM)

**********************************************************************
** DETERMINE SURFACE FUNCTION FOR THIS GRID SQUARE                   *
** AND INTERPOLATE A VALUE, ZEE, FOR XPT, YPT                        *
**********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      IMPLICIT INTEGER (I-N)
*     IMPLICIT UNDEFINED (A-Z)

      INTEGER MXAREA, MAXCOL
      PARAMETER (MAXCOL = 600, MXAREA = 8)

      DOUBLE PRECISION XPT, YPT, XPT2, YPT2, XGRID, YGRID
      DOUBLE PRECISION DLOS, DLAS, DLAM, DLOM
      DOUBLE PRECISION TEE1, TEE2, TEE3, TEE4, ZEE
      INTEGER IROW, JCOL, NC, IAREA, IFILE, IDUM, J
      REAL BUF(MAXCOL)
      
      CHARACTER*8 DUMMY

      INTEGER LUIN, LUOUT, NOUT, NIN, NAPAR, LUAREA
      COMMON /INOUT/ LUIN, LUOUT, NOUT, NIN, NAPAR, LUAREA(2*MXAREA)

      DOUBLE PRECISION AY1, BEE1, CEE1, DEE1, AY2, BEE2, CEE2, DEE2
      SAVE AY1, BEE1, CEE1, DEE1, AY2, BEE2, CEE2, DEE2
      INTEGER IROWL, JCOLL, IAREAL
      SAVE IROWL, JCOLL, IAREAL

      DATA IROWL / 0 /, JCOLL / 0 /, IAREAL / 0 /

**********
* LATITUDE
**********

      IF ( IROW .NE. IROWL  .OR.  JCOL .NE. JCOLL  .OR.
     +    IAREA .NE. IAREAL ) THEN

* Lower boundary

        IFILE = LUAREA( 2*IAREA - 1 )
        READ (IFILE,REC=IROW+1, ERR=99) IDUM, (BUF(J), J=1,NC)
        TEE1 = DBLE( BUF(JCOL) )
*       TEE4 = DBLE( BUF(JCOL+1) )
        TEE3 = DBLE( BUF(JCOL+1) )

* Upper boundary

        READ (IFILE,REC=IROW+2, ERR=99) IDUM, (BUF(J), J=1,NC)
        TEE2 = DBLE( BUF(JCOL) )
*       TEE3 = DBLE( BUF(JCOL+1) )
        TEE4 = DBLE( BUF(JCOL+1) )

        CALL COEFF (TEE1, TEE2, TEE3, TEE4, AY1, BEE1, CEE1, DEE1)

      ENDIF


      CALL SURF (XGRID, YGRID, ZEE, AY1, BEE1, CEE1, DEE1, IROW, JCOL)
      DLAS = ZEE

***********
* LONGITUDE
***********

      IF ( IROW .NE. IROWL  .OR.  JCOL .NE. JCOLL  .OR.
     +    IAREA .NE. IAREAL ) THEN


* Lower boundary

        IFILE = LUAREA( 2*IAREA )
        READ (IFILE,REC=IROW+1, ERR=99) IDUM, (BUF(J), J=1,NC)
        TEE1 = DBLE( BUF(JCOL) )
*       TEE4 = DBLE( BUF(JCOL+1) )
        TEE3 = DBLE( BUF(JCOL+1) )

* Upper boundary

        READ (IFILE,REC=IROW+2, ERR=99) IDUM, (BUF(J), J=1,NC)
        TEE2 = DBLE( BUF(JCOL) )
*       TEE3 = DBLE( BUF(JCOL+1) )
        TEE4 = DBLE( BUF(JCOL+1) )

        CALL COEFF (TEE1, TEE2, TEE3, TEE4, AY2, BEE2, CEE2, DEE2)

      ENDIF

      CALL SURF (XGRID, YGRID, ZEE, AY2, BEE2, CEE2, DEE2, IROW, JCOL)
C*    Since we are using negative for West longitude, reverse sign of DLOS, rwb
      DLOS = -1.0D0*ZEE

**************************
* COMPUTE THE NAD 83 VALUES
**************************

      YPT2 = YPT + DLAS/3600.0D0

* Longitude is negative West in this subroutine, rwb

      XPT2 = XPT + DLOS/3600.0D0

*********************************************************************
* USE THE NEW ELLIPSOIDAL VARIABLES TO COMPUTE THE SHIFTS IN METERS
*********************************************************************

      CALL METERS (YPT, XPT, YPT2, XPT2, DLAM, DLOM)

* Update the last-value variables

      IROWL = IROW
      JCOLL = JCOL
      IAREAL = IAREA

      GO TO 90

 99   CONTINUE
c      WRITE(DUMMY,'("NGRID",I3.3)') IFILE
c      CALL ERRHDL('NC','INTRP','E','510',DUMMY)

 90   CONTINUE

      RETURN
      END
      

      SUBROUTINE METERS (LAT1, LONG1, LAT2, LONG2, LATMTR, LONMTR)

* This subroutine computes the difference in two positions in meters.
*
* This method utilizes ellipsoidal rather than spherical
* parameters.  I believe that the original approach and code
* for this came from Ed McKay.
* The reference used by Ed McKay for this was:
*       'A Course in Higher Geodesy' by P.W. Zakatov, Israel Program
*       for Scientific Translations, Jerusalem, 1962
*
*       Warren T. Dewhurst
*       11/1/89
* Note that this subroutine is set up for +west longitude

      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      IMPLICIT INTEGER (I-N)
*     IMPLICIT UNDEFINED (A-Z)

* I think that these are GRS80 parameters

      DOUBLE PRECISION AXIS, E2, RHOSEC
      PARAMETER (AXIS = 6378137.0D0)
      PARAMETER (E2 = 0.0066943800229D0)
      PARAMETER (RHOSEC = 206264.806247D0)

      DOUBLE PRECISION W, LM, LP, AVLAT
      DOUBLE PRECISION LAT1S, LAT2S, LONG1S, LONG2S, LAT1, LAT2
      DOUBLE PRECISION LONG1, LONG2, DLAT, DLONG
      DOUBLE PRECISION LATMTR, LONMTR


*     LAT1  = (LATSEC + 60.D0*( LATMIN + 60.D0*LATDEG) )/RHOSEC
*     LONG1 = (LONSEC + 60.D0*( LONMIN + 60.D0*LONDEG) )/RHOSEC
*     LAT2  = (LATSEC + 60.D0*( LATMIN + 60.D0*LATDEG) )/RHOSEC
*     LONG2 = (LONSEC + 60.D0*( LONMIN + 60.D0*LONDEG) )/RHOSEC

* Change into sec.ddd and convert to +west longitude

      LAT1S =    LAT1*60.D0*60.D0/RHOSEC
      LONG1S =  LONG1*60.D0*60.D0/RHOSEC       ! adjusted for negative West, rwb
      LAT2S =    LAT2*60.D0*60.D0/RHOSEC
      LONG2S =  LONG2*60.D0*60.D0/RHOSEC       ! adjusted for negative West, rwb

      DLAT  = ( LAT2S -  LAT1S)*RHOSEC
      DLONG = (LONG2S - LONG1S)*RHOSEC

      AVLAT = (LAT1S + LAT2S)/2.0D0

      W  = DSQRT(1.0D0 - E2*DSIN(AVLAT)**2)
      LM = AXIS*(1.0D0 - E2)/(W**3*RHOSEC)
      LP = AXIS*DCOS(AVLAT)/(W*RHOSEC)

      LATMTR = LM*DLAT
      LONMTR = LP*DLONG

      RETURN
      END
      
      SUBROUTINE MLOOP (IPAGE, ITYPE, KEY, VRSION,
crwb     +                  DLAM, DLOM, DLAS, DLOS,
     +                  XPT, YPT, XPT2, YPT2, DLAM, DLOM, DLAS, DLOS,
     +                  SDLAM, SDLAM2, SDLOM, SDLOM2,
     +                  SDLAS, SDLAS2, SDLOS, SDLOS2,
     +                  SMDLAM, BGDLAM, SMDLOM, BGDLOM,
     +                  SMDLAS, BGDLAS, SMDLOS, BGDLOS,
     +                  XSMALL, XBIG, YSMALL, YBIG,
     +                  SCREEN,dsel)

**********************************************************************
* THIS SUBROUTINE LOOPS THROUGH THE INPUT DATA (EITHER AN INPUT DATA *
* FILE OR INTERACTIVELY), CALCULATES THE TRANSFORMATION VALUES,      *
* UPDATES THE MINIMUM, MAXIMUM, AND STATISTICAL SUMMATIONS, AND THEN *
* PRINTS THE RESULTS TO THE OUTPUT FILE AND/OR THE SCREEN.           *
**********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      IMPLICIT INTEGER (I-N)
*     IMPLICIT UNDEFINED (A-Z)

      INTEGER MXAREA
      PARAMETER (MXAREA = 8)

      DOUBLE PRECISION DLAM2, DLOM2, DLAS2, DLOS2
      DOUBLE PRECISION SDLAM, SDLAM2, SDLOM, SDLOM2
      DOUBLE PRECISION SDLAS, SDLAS2, SDLOS, SDLOS2
      DOUBLE PRECISION XSMALL, XBIG, YSMALL, YBIG, XPT, XPT2, YPT, YPT2
      DOUBLE PRECISION VRSION
      DOUBLE PRECISION SLA, SLO, SLA2, SLO2
      DOUBLE PRECISION DLAM, DLOM, DLAS, DLOS
      DOUBLE PRECISION SMDLAM, BGDLAM, SMDLOM, BGDLOM
      DOUBLE PRECISION SMDLAS, BGDLAS, SMDLOS, BGDLOS
      INTEGER IPAGE, ITYPE, KEY, IFMT, IPREC
      INTEGER IDLA, IMLA, IDLO, IMLO
      INTEGER IDLA2, IMLA2, IDLO2, IMLO2
      CHARACTER*80 NAME
      CHARACTER*44 FIRST
      CHARACTER*30 LAST
      CHARACTER*15 RESP
      LOGICAL NOGO, SCREEN, NOPT, EOF,dsel

      DOUBLE PRECISION DX, DY, XMAX, XMIN, YMAX, YMIN
      INTEGER NC, NAREA
      COMMON /GDINFO/ DX(MXAREA), DY(MXAREA), XMAX(MXAREA),
     +                XMIN(MXAREA), YMAX(MXAREA), YMIN(MXAREA),
     +                NC(MXAREA), NAREA

      INTEGER LUIN, LUOUT, NOUT, NIN, NAPAR, LUAREA
      COMMON /INOUT/ LUIN, LUOUT, NOUT, NIN, NAPAR, LUAREA(2*MXAREA)

* set defaults for those variables not used by every format type

      DATA NAME /' '/, FIRST /' '/, LAST /' '/, IFMT /0/

*******************************************************************
* BEGIN THE COMPUTATION LOOP FOR EACH CONVERSION
* DO UNTIL END OF FILE OR NO MORE CONVERSIONS REQUESTED
*******************************************************************

C*        Longitude is negative West, rwb

          CALL HMS (YPT, IDLA, IMLA, SLA)    ! rwb
          CALL HMS (XPT, IDLO, IMLO, SLO)    ! rwb


************************
* DO THE TRANSFORMATION
************************
        NOGO = .FALSE.
        CALL TRANSF (NOGO, RESP, XPT, YPT, XPT2, YPT2,
     +               DLAM, DLOM, DLAS, DLOS, KEY, ITYPE)

****************************************************
* CHECK TO SEE IF THIS POINT CAN BE TRANSFORMED
* IF NOGO IS TRUE THEN GET ANOTHER POINT AND DON'T
* DO THE COMPUTATION - POINT IS OUT OF BOUNDS
* IF NOGO IS NOT TRUE THEN PROCEED - ESTIMATE MADE
****************************************************

        IF (NOGO) GOTO 9999

        IF (KEY .EQ. 1) THEN

**********************
* FOR NAD 27 TO NAD 83
**********************

          CALL HMS (YPT2, IDLA2, IMLA2, SLA2)
          CALL HMS (XPT2, IDLO2, IMLO2, SLO2)

        ELSEIF (KEY .EQ. -1) THEN

**********************
* FOR NAD 83 TO NAD 27
**********************

          IDLA2 = IDLA
          IMLA2 = IMLA
          SLA2 = SLA
          IDLO2 = IDLO
          IMLO2 = IMLO
          SLO2 = SLO
          CALL HMS (YPT, IDLA, IMLA, SLA)
          CALL HMS (XPT, IDLO, IMLO, SLO)
        ENDIF

 9999 RETURN
      END
      


crwb      SUBROUTINE NGRIDS (NODATA,dsel,VRSION)
      SUBROUTINE NGRIDS (NODATA,dsel,ILEN_FLD,NGPATH)

* This subroutine opens the NADCON grids which contain datum shifts.
* A total of two files are necessary for each area; 1 for each latitude
* and longitude shift table (gridded data set) expressed in arc seconds.

* If a file named AREA.PAR exists it will be read for the names and
* locations of the gridded data.  The format of the data in
* the AREA.PAR file is given in the GRIDS subroutine.

* If the AREA.PAR file does not exist, or there is still room in the
* arrays in the GDINFO common then the default area names used.

      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      IMPLICIT INTEGER (I-N)
*     IMPLICIT UNDEFINED (A-Z)

      INTEGER ILEN_FLD
      INTEGER MXAREA
      PARAMETER (MXAREA = 8)
      
      CHARACTER*1 ANS
      LOGICAL NODATA,dsel
      
      CHARACTER (LEN=ILEN_FLD) :: NGPATH

      DOUBLE PRECISION DX, DY, XMAX, XMIN, YMAX, YMIN
      DOUBLE PRECISION VRSION
      INTEGER NC, NAREA
      COMMON /GDINFO/ DX(MXAREA), DY(MXAREA), XMAX(MXAREA),
     +                XMIN(MXAREA), YMAX(MXAREA), YMIN(MXAREA),
     +                NC(MXAREA), NAREA

      INTEGER LUIN, LUOUT, NOUT, NIN, NAPAR, LUAREA
      COMMON /INOUT/ LUIN, LUOUT, NOUT, NIN, NAPAR, LUAREA(2*MXAREA)

* Initialize

      NODATA = .FALSE.
      NAREA = 0
      LUOUT = 7

* If NAREA>=MXAREA, then skip the section that opens the default files.
* If NAREA<MXAREA or no 'AREA.PAR' file exists, then open default names
* in the subroutine DGRIDS.

c if state hpgn chosen(dsel=false) then only 1 file can be open at 
c a time.  If an hpgn file is not in area.par, then the user can 
c choose a state in SGRIDS.
       if(dsel) then
c default grids chosen
          IF (NAREA .LT. MXAREA) THEN

              CALL DGRIDS(ILEN_FLD,NGPATH)

          ENDIF
       end if


      IF (NAREA .EQ. 0) THEN
        NODATA = .TRUE.
        WRITE (LUOUT, 970)
  970   FORMAT (/, ' ******* ERROR *********', /,
     +          ' No grid files were opened -- program ending!')
      ENDIF

      RETURN
      END
      
      SUBROUTINE OPENFL (AFILE, ITEMP, GFLAG, NOGO, DX, DY,
     +                   XMAX1, XMIN1, YMAX1, YMIN1, NC1, CARD,
     +                   ILEN_FLD)

*** Given base name of gridded data files, open the two data files

      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      IMPLICIT INTEGER (I-N)
*     IMPLICIT UNDEFINED (A-Z)

      INTEGER MXAREA
      PARAMETER (MXAREA = 8)
      CHARACTER*23 B23
      PARAMETER (B23 = '                       ')
      CHARACTER*69 B69
      PARAMETER (B69 = B23//B23//B23)

      DOUBLE PRECISION XMAX1, XMIN1, YMAX1, YMIN1, DX, DY
      REAL DX1, DY1, DX2, DY2
      REAL X01, Y01, ANGLE1, X02, Y02, ANGLE2
      INTEGER IFLAG1, IFLAG2, N1, N2, N3, N4
      INTEGER ITEMP, LRECL, ILA, ILO, IFILE, IOS
      INTEGER NC1, NR1, NZ1, NC2, NR2, NZ2
      CHARACTER*80 CARD
      CHARACTER (LEN=ILEN_FLD+4) :: ALAS, ALOS
      CHARACTER (LEN=ILEN_FLD) :: AFILE
      CHARACTER*56 RIDENT
      CHARACTER*8 PGM
      LOGICAL GFLAG, NOGO, OFLAG, EFLAG1, EFLAG2

      INTEGER LUIN, LUOUT, NOUT, NIN, NAPAR, LUAREA
      COMMON /INOUT/ LUIN, LUOUT, NOUT, NIN, NAPAR, LUAREA(2*MXAREA)

      DATA IFLAG1 /1/, IFLAG2 /2/
      DATA OFLAG /.FALSE./, EFLAG1 /.FALSE./, EFLAG2 /.FALSE./


* Initialize

      NOGO = .FALSE.

* Form complete names of grid files

      N2 = LEN_TRIM(AFILE)
      IF (N2 .EQ. 0) STOP 'Logical Coding Error in OPENF'

      ALAS = B69
      ALAS(1:N2) = AFILE

      ALAS(N2+1:N2+4) = '.las'
      ALOS = B69
      ALOS(1:N2) = AFILE
      ALOS(N2+1:N2+4) = '.los'

*******************************************************
* DIRECT ACCESS GRID FILES
* Each file is opened once to get the grid variables.
* The file is then closed and reopened to ensure that
* the record length is correct
*******************************************************

* Seconds of latitude grid file

      LRECL = 256
      ILA = 2*ITEMP - 1
      IFILE = ILA + 10
      LUAREA(ILA) = IFILE
      INQUIRE (FILE=ALAS, EXIST=EFLAG1, OPENED=OFLAG)
      IF (.NOT. EFLAG1) GOTO 100
      IF (OFLAG) GOTO 980
      OPEN (IFILE,FILE=ALAS,FORM='UNFORMATTED',STATUS='OLD',
     +       ACCESS='DIRECT',RECL=LRECL,ERR=940,IOSTAT=IOS,
     +       ACTION='READ')
      READ (IFILE,REC=1) RIDENT, PGM, NC1, NR1, NZ1, X01, DX1,
     +                   Y01, DY1, ANGLE1
      CLOSE (IFILE)

      LRECL = 4*(NC1+1)
      OPEN (IFILE,FILE=ALAS,FORM='UNFORMATTED',STATUS='OLD',
     +       ACCESS='DIRECT',RECL=LRECL,ERR=940,IOSTAT=IOS,
     +       ACTION='READ')

* Seconds of longitude grid file

  100 LRECL = 256
      ILO = 2*ITEMP
      IFILE = ILO + 10
      LUAREA(ILO) = IFILE
      INQUIRE (FILE=ALOS, EXIST=EFLAG2, OPENED=OFLAG)
      IF (.NOT. EFLAG1) GOTO 910
      IF (.NOT. EFLAG2) GOTO 920
      IF (OFLAG) GOTO 980
      OPEN (IFILE,FILE=ALOS,FORM='UNFORMATTED',STATUS='OLD',
     +       ACCESS='DIRECT',RECL=LRECL,ERR=940,IOSTAT=IOS,
     +       ACTION='READ')
      READ (IFILE,REC=1) RIDENT, PGM, NC2, NR2, NZ2, X02, DX2,
     +                   Y02, DY2, ANGLE2
      CLOSE (IFILE)

      LRECL = 4*(NC2+1)
      OPEN (IFILE,FILE=ALOS,FORM='UNFORMATTED',STATUS='OLD',
     +       ACCESS='DIRECT',RECL=LRECL,ERR=940,IOSTAT=IOS,
     +       ACTION='READ')

* Check to see if the two files have the same variables

      IF ( (NC2 .NE. NC1)  .OR.  (NR2 .NE. NR1)  .OR.
     +     (NZ2 .NE. NZ1)  .OR.
     +     (X02 .NE. X01)  .OR.  (DX2 .NE. DX1)  .OR.
     +     (Y02 .NE. Y01)  .OR.  (DY2 .NE. DY1)  .OR.
     +     (ANGLE2 .NE. ANGLE1) ) GOTO 960

* Calculate values used in this program

      XMIN1 = DBLE(X01)
      YMIN1 = DBLE(Y01)
      XMAX1 = DBLE(X01) + DBLE(NC1-1)*DBLE(DX1)
      YMAX1 = DBLE(Y01) + DBLE(NR1-1)*DBLE(DY1)
      DX = DBLE( ABS(DX1) )
      DY = DBLE( ABS(DY1) )

*****************************************
* REPORT SOMETHING ABOUT THE GRIDDED DATA
*****************************************
      WRITE (LUOUT,4050) RIDENT, PGM, NC1, NR1
 4050 FORMAT (1X, A56, /, 1X, A8, /, I5, I5)
      WRITE (LUOUT,*) 'DX,DY,NR,NC', DX1, DY1, NR1, NC1
      WRITE (LUOUT,4055) -XMAX1, -XMIN1, YMIN1, YMAX1
 4055 FORMAT (' MIN Longitude = ', F10.4, ' MAX Longitude = ', F10.4, /,
     +        ' MIN Latitude  = ', F10.4, ' MAX Latitude  = ', F10.4, /)
*****************************************

 9999 RETURN

****************************
* WARNING AND ERROR MESSAGES
****************************

* Grid files do not exist

  910 CONTINUE
      NOGO = .TRUE.
      CLOSE ( LUAREA(ILA) )
      CLOSE ( LUAREA(ILO) )
      GOTO 9999

  920 CONTINUE
      NOGO = .TRUE.
      CLOSE ( LUAREA(ILA) )
      CLOSE ( LUAREA(ILO) )
      GOTO 9999

* Grid file(s) already open

  940 CONTINUE
      NOGO = .TRUE.
      CLOSE ( LUAREA(ILA) )
      CLOSE ( LUAREA(ILO) )
      GOTO 9999

* Grid files do not agree

  960 CONTINUE
      NOGO = .TRUE.
      CLOSE ( LUAREA(ILA) )
      CLOSE ( LUAREA(ILO) )
      GOTO 9999

* Grid files already open

  980 CONTINUE
      NOGO = .TRUE.
      GOTO 9999
      
      END
      
      SUBROUTINE SURF (XGRID, YGRID, ZEE, AY, BEE, CEE, DEE, IROW, JCOL)

**********************************************************************
** SUBROUTINE SURF: INTERPOLATES THE Z VALUE                         *
**********************************************************************

* Calculated the value of the grid at the point XPT, YPT.  The
* interpolation is done in the index coordinate system for convenience.

      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      IMPLICIT INTEGER (I-N)
*     IMPLICIT UNDEFINED (A-Z)

      DOUBLE PRECISION XGRID, YGRID
      DOUBLE PRECISION AY, BEE, CEE, DEE
      DOUBLE PRECISION ZEE, ZEE1, ZEE2, ZEE3, ZEE4
      INTEGER IROW, JCOL

      ZEE1 = AY
      ZEE2 = BEE*(XGRID - DBLE(JCOL) )
      ZEE3 = CEE*(YGRID - DBLE(IROW) )
      ZEE4 = DEE*(XGRID - DBLE(JCOL) )*(YGRID - DBLE(IROW) )
      ZEE  = ZEE1 + ZEE2 + ZEE3 + ZEE4

      RETURN
      END
      
      SUBROUTINE TO83 (NOGO, RESP, XPT, YPT, XPT2, YPT2,
     +                 DLAM, DLOM, DLAS, DLOS, ITYPE)

* This subroutine predicts the NAD 83 latitude and longitude values
* given the NAD 27 latitude and longitude values in degree decimal
* format.  In addition, the program returns the shift values between
* The datums in both arc secs and meters.

* All of the predictions are based upon a straight-forward interpolation
* of a gridded data set of datum shifts.  The datum shifts are assumed
* to be provided in the files opened in the NGRIDS subroutine.  The
* common AREAS contains the names of the valid areas while the common
* GDINFO contains the grid variables.  NAREA is the number of areas
* which had data files opened.  A total of two files are necessary for
* each area: one latitude and one longitude shift table (gridded data
* set) expressed in arc seconds.

*       Author:     Warren T. Dewhurst, PH. D.
*                   National Geodetic Survey
*                   November 1, 1989

      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      IMPLICIT INTEGER (I-N)
*     IMPLICIT UNDEFINED (A-Z)

      INTEGER MXAREA
      PARAMETER (MXAREA = 8)

      DOUBLE PRECISION XPT, YPT, XPT2, YPT2
      DOUBLE PRECISION XGRID, YGRID
      DOUBLE PRECISION DLAM, DLOM, DLAS, DLOS
      DOUBLE PRECISION DX0, DY0, XMAX0, XMIN0, YMAX0, YMIN0
      INTEGER IROW, JCOL, IAREA, I, NC0, ITYPE
      INTEGER IFLAG1, IFLAG2, N1, N2
      CHARACTER*15 RESP
      LOGICAL NOGO, FLAG

      CHARACTER*15 AREAS
      COMMON /AREAS/ AREAS(MXAREA)

      DOUBLE PRECISION DX, DY, XMAX, XMIN, YMAX, YMIN
      INTEGER NC, NAREA
      COMMON /GDINFO/ DX(MXAREA), DY(MXAREA), XMAX(MXAREA),
     +                XMIN(MXAREA), YMAX(MXAREA), YMIN(MXAREA),
     +                NC(MXAREA), NAREA

      INTEGER LUIN, LUOUT, NOUT, NIN, NAPAR, LUAREA
      COMMON /INOUT/ LUIN, LUOUT, NOUT, NIN, NAPAR, LUAREA(2*MXAREA)

      CHARACTER*80 CARD
      COMMON /CURNT/ CARD

      SAVE FLAG

      DATA IFLAG1 /1/, IFLAG2 /2/, FLAG /.FALSE./

******************************************************************
*                             INITIALIZE
******************************************************************

      NOGO  =  .FALSE.

****************************************************
* READ WHERE TO GET THE DATA AND HOW IT IS ORGANIZED
****************************************************

* Check to see which set of gridded files XPT,YPT is in.

      DO IAREA = 1, NAREA

        DX0 = DX(IAREA)
        DY0 = DY(IAREA)
        XMAX0 = XMAX(IAREA)
        XMIN0 = XMIN(IAREA)
        YMAX0 = YMAX(IAREA)
        YMIN0 = YMIN(IAREA)
        NC0 = NC(IAREA)

        CALL FGRID (XPT, YPT, DX0, DY0, XMAX0, XMIN0,
     +              YMAX0, YMIN0, XGRID, YGRID, IROW, JCOL, NOGO)

        IF (.NOT. NOGO) EXIT
        
      END DO

      IF (NOGO) GO TO 9999
      
* Point in area number IAREA and named AREAS(IAREA)

        RESP = AREAS(IAREA)
        CALL INTRP (IAREA, IROW, NC0, JCOL, XGRID, YGRID,
     +              XPT, YPT, XPT2, YPT2, DLOS, DLAS, DLAM, DLOM)

* Error Messages

9999  RETURN
      END

      SUBROUTINE TRANSF (NOGO, RESP, XPT, YPT, XPT2, YPT2,
     +                   DLAM, DLOM, DLAS, DLOS, KEY, ITYPE)

* This subroutine computes either the forward or inverse coordinate
* transformation depending upon the value of the integer variable 'key'
c 1/20/92 - IF the HPGN option is chosen, statements in this subroutine
c which refer to NAD 27 apply to NAD 83; 
c statements which refer to NAD 83 apply to HPGN -jmb

      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      IMPLICIT INTEGER (I-N)
*     IMPLICIT UNDEFINED (A-Z)

      INTEGER MXAREA, ITMAX
      DOUBLE PRECISION SMALL
      PARAMETER (MXAREA = 8, ITMAX = 10, SMALL = 1.0D-9 )

      DOUBLE PRECISION XPT, YPT, XPT2, YPT2
      DOUBLE PRECISION XTEMP, YTEMP, XDIF, YDIF
      DOUBLE PRECISION DLAM, DLOM, DLAS, DLOS
      DOUBLE PRECISION DXLAST, DYLAST
      INTEGER KEY, NUM, ITYPE
      CHARACTER*15 RESP
      LOGICAL NOGO

      INTEGER LUIN, LUOUT, NOUT, NIN, NAPAR, LUAREA
      COMMON /INOUT/ LUIN, LUOUT, NOUT, NIN, NAPAR, LUAREA(2*MXAREA)

      IF (KEY .EQ. 1) THEN

**********************
* FOR NAD 27 TO NAD 83
**********************

        CALL TO83 (NOGO, RESP, XPT, YPT, XPT2, YPT2,
     +             DLAM, DLOM, DLAS, DLOS, ITYPE)

      ELSEIF (KEY .EQ. -1) THEN

***************************
* FOR NAD 83 TO NAD 27)
* THIS IS DONE BY ITERATION
***************************

        NUM = 0

**************************************************
* SET THE XPT,YPT TO TEMPORARY VALUES
* (REMEMBER, XPT AND YPT ARE REALLY NAD 83 VALUES)
**************************************************

        XTEMP = XPT
        YTEMP = YPT

**************************************************************
* PRETEND THAT THESE TEMPORARY VALUES ARE REALLY NAD 27 VALUES
* FOR A FIRST GUESS AND COMPUTE PSEUDO-NAD 83 COORDINATES
**************************************************************

  200   CONTINUE
          NUM = NUM + 1

          CALL TO83 (NOGO, RESP, XTEMP, YTEMP, XPT2, YPT2,
     +               DLAM, DLOM, DLAS, DLOS, ITYPE)
          DXLAST = DLOS
          DYLAST = DLAS

**************************************
* COMPARE TO ACTUAL NAD 83 COORDINATES
**************************************

          XDIF = XPT - XPT2
          YDIF = YPT - YPT2

****************************************************************
* COMPUTE A NEW GUESS UNLESS THE DIFFERENCES ARE LESS THAN SMALL
* WHERE SMALL IS DEFINED (ABOVE) TO BE;  SMALL = 1.0D-9
****************************************************************

          IF (NUM .EQ. 1) THEN
            IF (DABS(XDIF) .GT. SMALL) THEN
              XTEMP = XPT - DLOS/3600.0D0
            ENDIF
            IF (DABS(YDIF) .GT. SMALL) THEN
              YTEMP = YPT - DLAS/3600.0D0
            ENDIF
          ELSE
            IF (DABS(XDIF) .GT. SMALL) THEN
              XTEMP = XTEMP - (XPT2 - XPT)
            ENDIF
            IF (DABS(YDIF) .GT. SMALL) THEN
              YTEMP = YTEMP - (YPT2 - YPT)
            ENDIF

          ENDIF

          IF (NUM.GE.ITMAX .OR. (DABS(YDIF).LE.SMALL .AND.
     &                           DABS(XDIF).LE.SMALL)) THEN

******************************
* IF CONVERGED THEN LEAVE LOOP
******************************

            XPT = XTEMP
            YPT = YTEMP
            GOTO 1000
          ENDIF

*******************************
* IF NOT CONVERGED THEN ITERATE
*******************************

        GOTO 200

      ENDIF
 1000 RETURN
      END




