        REAL FUNCTION BULKFR( HTOP, HC)
C-----------------------------------------------------------------------
C PURPOSE:  THIS ROUTINE COMPUTES THE BULK FROUDE NUMBER IN THE
C           HEIGHT INTERVAL BETWEEN HC AND 1.5 TIMES THE CUT-OFF
C           HILL HEIGHT.
C
C ARGUMENTS
C  PASSED:
C       HTOP    REAL    HEIGHT OF HILL TOP ABOVE TOWER BASE (M)
C       HC      REAL    DIVIDING STREAMLINE HEIGHT ABOVE TOWER
C                       BASE (M)
C
C  RETURNED AS A FUNCTION VALUE:
C       BULKFR  REAL    BULK FROUDE NUMBER IN THE HEIGHT INTERVAL
C                       BETWEEN HC AND 1.5 TIMES THE CUT-OFF HILL HEIGHT
C
C CALLING ROUTINES: SEQMOD
C
C EXTERNAL ROUTINES: GETTA      GETWS
C
C COMMON BLOCKS: NONE
C
C-----------------------------------------------------------------------
C
C       NUMBER OF EQUAL LAYERS THE HC-TOP LAYER IS DIVIDED INTO
        PARAMETER(      NLAYER  =       10)
C
C       DEFINE ARGUMENTS
        REAL    HTOP,   HC
C
C       DEFINE LOCAL VARIABLES
        REAL    BVF, DELT, DELZ, DEPTH, DTHETA, HCUTOF, TAMID, TOP,
     *          WSAVG, WSSUM, ZMID
        INTEGER I
C
        HCUTOF = HTOP - HC
        TOP = HC + 1.5 * HCUTOF
C
C       OBTAIN AN AVERAGE WIND SPEED FROM HC TO TOP BY DIVIDING THAT
C       LAYER INTO NLAYER EQUAL HEIGHTS.  THE INTERPOLATED WIND SPEEDS
C       AT THE MIDPOINTS OF THE HEIGHT SEGMENTS ARE AVERAGED TO OBTAINED
C       THE AVERAGE WIND SPEED.
C
        WSSUM = 0.
        DEPTH = TOP - HC
        DELZ = DEPTH * 0.1
C
        DO 100 I = 1, NLAYER
            ZMID = HC + (I-0.5) * DELZ
            WSSUM = WSSUM + GETWS(ZMID)
100     CONTINUE
C
        WSAVG = WSSUM * (1.0/FLOAT(NLAYER))
C
C       OBTAIN THE TEMPERATURE DIFFERENCE THROUGH THE LAYER AND THE
C       TEMPERATURE AT THE MIDPOINT OF THE LAYER.
C
        DELT = GETTA(TOP) - GETTA(HC)
        ZMID = (HC + TOP) * 0.5
        DTHETA = DELT/DEPTH + 0.0098
        TAMID = GETTA(ZMID)
C
C       BRUNT-VAISALA FREQUENCY AND FROUDE NUMBER:
C
        IF(DTHETA .LE. 0.00) THEN
            BULKFR = 999.
            RETURN
          ELSE
            BVF = SQRT(9.8/TAMID * DTHETA)
            BULKFR =  WSAVG/(BVF * HCUTOF)
        ENDIF
        RETURN
        END
