C*****************************************************************************
C                                                                            *
C                          CTSCREEN (Dated 93228)                            *
C                                                                            *
C             *** SEE CTSCREEN MODEL CHANGE BULLETIN MCB#4 ***               *
C                                                                            *
C     ON THE SUPPORT CENTER FOR REGULATORY AIR MODELS BULLETIN BOARD         *
C                                                                            *
C                               919-541-5742                                 *
C                                                                            *
C*****************************************************************************
C
        PROGRAM CTSCREEN
C
C********************************************************************
C
C       SCREENING MODE OF CTDMPLUS
C
C********************************************************************
C
C   PURPOSE:
C      THIS IS THE MAIN PROGRAM OF CTSCREEN.
C      THIS ROUTINE OPENS INPUT AND OUTPUT FILES AND CALLS SUBROUTINES
C      THAT HANDLE PROGRAM OPTIONS, SOURCE, RECEPTOR, AND TERRAIN
C      DESCRIPTIONS; A MAP OF SOURCES, RECEPTORS, AND TERRAIN;
C      AND INITIATION OF SEQUENTIAL MODELING.
C
C   LIMITATIONS:
C      TITLE FOR THIS RUN IS LIMITED TO 80 CHARACTERS.
C      PROGRAM OPTIONS INPUT FILE IS OPENED TO UNIT 5.
C      OUTPUT LISTING FILE IS OPENED TO UNIT 6.
C      NOTE: DEFAULT I/O UNIT NUMBERS ARE ASSIGNED IN THE MAIN
C      PROGRAM AND CAN BE CHANGED HERE.
C
C   COMMON BLOCKS USED: HEAD,IO,PARAMS
C
C   INPUT FROM UNIT 5: (CTDM.IN)
C       TITLE FOR THIS RUN
C
C   OUTPUT: NONE
C
C   EXTERNAL ROUTINES CALLED:
C       PAGE - STARTS A NEW PRINTED PAGE
C       INPAR - READS AND PRINTS PROGRAM PARAMETERS AND SWITCHES
C       INPSOR - READS AND PRINTS STACK INFORMATION
C       INPREC - READS AND PRINTS RECEPTOR INFORMATION
C       INPTOW - READS METEOROLOGICAL TOWER COORDINATES
C       INPTER - READS TERRAIN DATA
C       MAP - PRINTS A MAP LOCATING STACKS, RECEPTORS, AND TERRAIN
C       SEQMOD - INITIATES SEQENTIAL MODELING CALCULATIONS
C
C********************************************************************
C
      INCLUDE   'PARAMS.INC'
      INCLUDE   'IO.CMN'
      INCLUDE   'HEAD.CMN'
      INCLUDE   'PARAMS.CMN'
C      INCLUDE   'RECEPT.CMN'
C
C       DEFINE LOCAL VARIABLES
        INTEGER  YES
        DATA    YES/1/
C
C       DEFAULT UNIT NUMBERS (IO.CMN)
C
        INTERR = 2
        INEMIS = 3
        INREC = 4
        IN = 10
        IOUT = 6
        INSFC = 7
        IOCONC = 9
        INPROF = 11
        INRAW = 14
        ISTOUT = 12
        IUNOUT = 13
        ISUMRE = 15
        IMET = 8
        ISCRTCH = 16
        IOSRC = 17
C
        NPAGE = 0
C
        OPEN(IN, FILE='CTDM.IN',STATUS='OLD')
        OPEN(IOUT, FILE='CTDM.OUT')
C-*-*1    CARRIAGECONTROL='FORTRAN')
C       READ LINE 1 OF "CTDM.IN"
        READ( IN, 5010) TITLE
C
        CALL PAGE(YES)
C       READ LINES 2, 3 OF "CTDM.IN"
        CALL INPAR
C       READ LINE 4 OF "CTDM.IN"
        CALL INPTOW
C       READ LINE 5 OF "CTDM.IN"
        CALL INPSOR


        IF(IEMIS .EQ. YES) OPEN(INEMIS, FILE='EMISSION',STATUS='OLD') 

        OPEN(INREC, FILE='RECEPTOR', STATUS='OLD')
        CALL INPREC
        CLOSE(INREC)

        OPEN(INTERR, FILE='TERRAIN', STATUS='OLD')
        CALL INPTER
        CLOSE(INTERR)

        OPEN(INSFC, FILE='SURFACE', STATUS='OLD')

        OPEN(INPROF, FILE='PROFILE', STATUS='OLD')
        IF (ISOR .EQ. 1) THEN
          OPEN (IOSRC, FILE='SOURCES')
          WRITE (IOSRC,5010) TITLE
        ELSE IF (ISOR .EQ. 2) THEN
          OPEN (IOSRC, FILE='SOURCES', FORM = 'UNFORMATTED')
        ENDIF

        IF (ISCRN .GT. 0 ) THEN
          OPEN(ISUMRE, FILE='SUMRE')
          OPEN(IMET,FILE='METDAT')
          
          IF (ICONC .EQ. 2) THEN
            IF (ISCRN .EQ. 1 .OR. ISCRN .EQ. 3) 
     &              OPEN(ISTOUT, FILE='STCONC')
            IF (ISCRN .GT. 1) OPEN(IUNOUT, FILE='UNCONC') 
          
          ELSE IF (ICONC .EQ. 1) THEN
            IF (ISCRN .EQ. 1 .OR. ISCRN .EQ. 3) 
     &              OPEN(ISTOUT, FILE='STCONC', 
     &                           FORM='UNFORMATTED')
            IF (ISCRN .GT. 1) OPEN(IUNOUT, FILE='UNCONC', 
     &                           FORM='UNFORMATTED')
          ENDIF
        ELSE 
          IF (ICONC .EQ. 1) THEN
            OPEN(IOCONC, FILE='CONC',FORM='UNFORMATTED')
          ELSE IF (IABS(ICONC) .GT. 1 ) THEN
            OPEN(IOCONC, FILE='CONC')
          ENDIF
        ENDIF

        IF (IUNSTA .GT. 0 .AND. ISCRN .EQ. 0)
     &           OPEN(INRAW, FILE='RAWIN',STATUS='OLD')
C
        CALL MAP
C
        CALL SEQMOD
C
        STOP
C
 5010   FORMAT(20A4)
C
        END

