        REAL FUNCTION GETDTH(Z2,XMH)
C-----------------------------------------------------------------------
C PURPOSE: THIS ROUTINE COMPUTES THE VERTICAL POTENTIAL TEMPERATURE
C          GRADIENT AT HEIGHT Z2
C
C ARGUMENTS
C  PASSED:
C       Z2      REAL    HEIGHT (M)
C  RETURNED FUNCTION VALUE:
C       GETDTH  REAL    VPTG (DEG/M)
C
C I/O: NONE
C
C CALLING ROUTINES: GETTA  HCRIT  PLAVG  SEQMOD  SRISE
C
C EXTERNAL FUNCTIONS: KLOSE
C
C INTRINSIC FUNCTIONS: AMAX1
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: SFCMET  PROFIL  PARAMS  VARS
C
C-----------------------------------------------------------------------
C
      INCLUDE   'PARAMS.INC'
C      INCLUDE   'SFCMET.CMN'
      INCLUDE   'PROFIL.CMN'
C      INCLUDE   'PARAMS.CMN'
      INCLUDE        'VARS.CMN'
C
C       DEFINE ARGUMENTS
        REAL            XMH, Z2
C
C       DEFINE LOCAL VARIABLES
        REAL    DELTA, DELZ, DTHDEF, DTH1, DTH3, DX, DZ, 
     1          TANEW(MAXLEV), HTTA(MAXLEV), DTHNEW(MAXLEV),
     2          HTNEW(MAXLEV), Z1, Z3
        REAL DEFAUL(2)
        INTEGER LEV, N, NNEW
        DATA    DEFAUL/0.02, 0.035/
C
C
C       CHECK IVPTG SWITCH:   = 0 IF ONSITE VPTG DATA IS IGNORED
C                             = 1 IF ONSITE VPTG DATA IS USED (SCALED)
C
C
C       EXAMINE DATA AND SELECT ONLY NONMISSING VALUES
C
        IF(KST .LT. 5) THEN
            DTHDEF = 0.0
          ELSE
            DTHDEF = DEFAUL(KST-4)
        ENDIF
C-*-    IF(IVPTG .EQ. NO) GO TO 200
        NNEW = 0
C
C       IF ONLY ONE MEASUREMENT LEVEL EXISTS, CANNOT COMPUTE DTHDZ
C       FROM OBSERVATIONS
C
        IF(NHT.EQ.1) GO TO 200
C
        DO 100 N = 1,NHT
          IF(TAHR(N).LT.0.0) GO TO 100
          NNEW = NNEW + 1
          TANEW(NNEW) = TAHR(N)
          HTTA(NNEW) = HT(N)
100     CONTINUE
        NNEW = NNEW - 1
        IF(NNEW.GE.1) THEN
            DO 150 N = 1,NNEW
              DELTA = TANEW(N+1) - TANEW(N)
              DELZ = HTTA(N+1) - HTTA(N)
              DTHNEW(N) = 0.0098 + DELTA/DELZ
              HTNEW(N) = HTTA(N) + 0.5*DELZ
150         CONTINUE
        ENDIF
C
C       END OF DATA REDUCTION
C
C       CHOOSE INTERPOLATION OR ASSIGNMENT OF DTHDZ FROM STABILITY CLASS
C
        IF( NNEW .EQ. 0 ) GO TO 200
C
C       LEV IS INDEX OF HT LEVEL CLOSEST TO (BUT LESS THAN) Z2
C
        LEV = KLOSE(HTNEW,NNEW,Z2)
C
C       INTERPOLATION SECTION
C
        IF( LEV .GE. 1  .AND.  LEV .LT. NNEW ) THEN
            Z1 = HTNEW(LEV)
            DTH1 = DTHNEW(LEV)
            Z3 = HTNEW(LEV+1)
            DTH3 = DTHNEW(LEV+1)
            DX = DTH3 - DTH1
            DZ = Z3 - Z1
            GETDTH = DTH1 + (Z2-Z1)*(DX/DZ)
            IF(GETDTH .LT. 0.0) GETDTH = 0.0
            RETURN
          ELSE IF(LEV.EQ.NNEW) THEN
            DTH1 = DTHNEW(NNEW)
            Z1 = HTNEW(NNEW)
          ELSE
            DTH1 = DTHNEW(1)
            Z1 = HTNEW(1)
        ENDIF
C
C       IF HAVE ONLY 1 OBS (OR CANNOT INTERPOLATE), PERSIST THE SINGLE
C       OBSERVATION TO THE DESIRED HEIGHT IF POSITIVE.  IF NEGATIVE, USE
C       ZERO IF BELOW XMH, AND USE STABLE DEFAULT IF DESIRED HEIGHT IS
C       ABOVE XMH AND MEASUREMENT IS BELOW XMH.
C
        IF(DTH1.LE.0.0) THEN
            IF(Z2 .LT. XMH .OR. (Z1.GT.XMH .AND. Z2.GT.XMH)) THEN
                GETDTH = 0.0
              ELSE
                GETDTH = AMAX1(DEFAUL(1),DTHDEF)
            ENDIF
          ELSE
            GETDTH = DTH1
        ENDIF
        RETURN
C
C       IN THIS SECTION, COMPUTE VPTG FOR THE CASE OF NO OBSERVATIONS.
C       USE DEFAULT VALUES BASED UPON STABILITY CLASS:
C       0.02 DEG/M FOR STABILITY CLASS 5; 0.035 DEG/M FOR CLASS 6
C
200     IF(Z2 .LE. XMH) THEN
            GETDTH = DTHDEF
          ELSE
            GETDTH = AMAX1(DEFAUL(1),DTHDEF)
        ENDIF
        RETURN
        END
