      SUBROUTINE GETFR(VDTHDZ,PTZI,DZI,IBLOCK)
C*****************************************************************
C  THIS SUBROUTINE FINDS THE MODEL FROUDE NUMBER (MFR) THAT CAUSES 
C  DEFLECTION (ETA) OF THE Zi STREAMLINE FOUND BY FLOW TO MATCH
C  THE DEFLECTION (DELZI) FROM THE FLUID MODELING STUDY.
C  THE FROUDE NUMBER IS SET FOR THE WPDF CALL BECAUSE IT IS IN
C  VARS.CMN 
C*****************************************************************

      INCLUDE  'PARAMS.INC'
      INCLUDE  'FLVAR.CMN'
C      INCLUDE  'HILL.CMN'
C      INCLUDE  'IO.CMN'
      INCLUDE  'PASL.CMN'
      INCLUDE  'SFCMET.CMN' 
C      INCLUDE  'TIME.CMN'
      INCLUDE  'VARS.CMN'
                                                 
      REAL     B0N, BVFZI, DEL, DZI, DZIH, ETA, ETA3, HFR, HSMAX, 
     &         MFR(8), PIBY2, PTZI, THI, TLI, TU,
     &         VDTHDZ, WSZI, ZIH, ZFL
      INTEGER  I, IBLOCK

      DATA MFR/1.0,1.5,2.0,3.0,4.0,6.0,50.0,9999.0/
      DATA B0N/1.25/

      PIBY2 = 0.5 * 3.1415926

C  ZERO BLOCKAGE FLAG
      IBLOCK = 0

C  CALCULATE INITIAL Zi/h (ZIH) FROM SURFACE AND HILL HEIGHT
      ZIH = XMH/HH

                                                 
C  CALCULATE THE BRUNT-VAISALA FREQUENCY (BVFZI) USING VPTG ABOVE Zi
C  AND POTENTIAL TEMP AT Zi
      BVFZI = (9.8 * VDTHDZ/PTZI)**0.5

C  FIND WIND SPEED AT ZI FOR THE HILL FROUDE NUMBER (HFR) CALCULATION
      WSZI = GETWS(XMH)      

C  CALCULATE THE HILL FROUDE NUMBER (HFR)
      IF (BVFZI .EQ. 0.0) THEN
        HFR = 99.0
      ELSE
        HFR = WSZI/(BVFZI * HH) 
      ENDIF

C  CALL DEFLECT TO FIND DEFLECTION (DZIH) FROM FMF THAT CORRESPONDS TO 
C  THE INITIAL Zi/h AND HILL FROUDE NUMBER
      CALL DEFLECT(ZIH,HFR,DZIH)
        DZI = DZIH*HH
        ZFL = XMH + DZI - HH

C  CALL THE FLOW MODEL AT THE POINT (0,0,ZFL) WHERE ZFL IS HEIGHT ABOVE
C  HILL SURFACE.  KEEP CHANGING THE FROUDE NUMBER UNTIL WE GET A CLOSE
C  TO A MATCH, THEN INTERPOLATE TO GET FINAL FROUDE NUMBER.

       IF (ZFL .LT. 0.0) THEN
         IBLOCK = 1
         RETURN
       ELSE
         DO 100 I = 1,8
           FR = MFR(I)
           HSMAX = HH * (1.0 + PIBY2*FR/HASYM) - HH
           ZFL = AMIN1(ZFL,HSMAX)
           CALL FLOW(0.0,0.0,ZFL,ETA,DEL,THI,TLI,TU,ALF,FR)
           IF (ETA .GE. DZI) THEN
             IF (I .EQ. 1) GOTO 200 
             FR = XINTRP(ETA3,ETA,DZI,MFR(I-1),MFR(I))
             GOTO 200
           ENDIF 
           ETA3 = ETA
100      CONTINUE      
       ENDIF

C *** COMPUTE CORRECTED STRATIFICATION, S.
200     BVUI = 1.0/(FR*HH)
        IF(FR .GT. 50.) BVUI=0.0
        BVUI2 = BVUI * BVUI
        S = BVUI * HASYM
        S2 = S*S
        B0N2 = B0N * B0N
        B0 = S * LZ * RTPII * B0N
        B02 = B0 * B0

       RETURN
       END
