      SUBROUTINE GETHILL(NHL,XHILLL,YHILLL,SINFLO,COSFLO,XS,YS)
C   *****************************************************************
C     DESCRIPTION: SUBROUTINE TO CALCULATE HILL DIMENSIONS AND 
C                  COORDINATES TO BE USED IN WPDF SUBROUTINE
C
C     ARGUMENTS: 
C     PASSED:    NHL      CURRENT HILL NUMBER
C                SINFLO   SINE OF WIND DIRECTION TO USER COORDINATE
C                COSFLO   COSINE OF SAME
C     RETURNED:  XHILLL   X-COORDINATE OF CENTER OF CUTOFF HILL
C                YHILLL   Y-COORDINATE OF CENTER OF CUTOFF HILL
C
C     CALLING ROUTINES: DAYCALC
C
C     INCLUDE FILES: PARAMS.INC
C 
C     COMMON BLOCKS:  HILL CONST PASL PASVAL PASW 
C                     PROFIL VARS FLVAR
C  ******************************************************************
                       
      INCLUDE  'PARAMS.INC'
      INCLUDE  'HILL.CMN'
      INCLUDE  'FLVAR.CMN'
      INCLUDE  'CONST.CMN'
      INCLUDE  'PASL.CMN'
C     INCLUDE  'PASVAL.CMN'
C     INCLUDE  'PASW.CMN'
C     INCLUDE  'PROFIL.CMN'
      INCLUDE  'VARS.CMN'

C    DEFINE ARGUMENTS

      REAL    COSFLO, SINFLO, XS, YS
      INTEGER NHL

C    LOCAL VARIABLES

      REAL   AH, BASEHL, BASEHW, BH, DX, DY, FRACT, HALF, 
     &       HTOPS, ONE, PSI, RNLZ, RSHL, THTAH, WHC, 
     &       XHILLL, XSEL, YHILLL, YSEL

      INTEGER KLOW
        DATA HALF/0.5/,RNLZ/0.69315/,ONE/1.0/

c  Set variables contained in common VARS
      WHC = 0.0
      HTOPS = THS(NHL)

C   DEFINE BASEHW
      BASEHW = ZHS(1,NHL)

C  CALCULATE WIND SPEED AT WHAT EVER LEVEL OR LEVELS
C
C  SECTION FOR DEFINING THE GEOMETRY FOR LIFT COMPUTATIONS-------------
C         GET ARRAY INDEX TO CONTOUR BELOW CUT-OFF HILL
C
          KLOW = 1
C
C         OBTAIN X, Y, ORIENTATION OF CUT-OFF HILL FROM LOOK-UP TABLES
C         FOR LIFT
C
          XHILLL = XHL(KLOW,NHL)
          YHILLL = YHL(KLOW,NHL)
          THTAH = MAJORL(KLOW,NHL)
          DX = XS - XHILLL
          DY = YS - YHILLL
          RSHL = SQRT( DX*DX + DY*DY )
C         CUT-OFF HILL BASE AND HEIGHT FOR LIFT
          BASEHL = ZHS(KLOW,NHL)
          HH = HTOPS - WHC
          IF(KLOW .EQ. NZH(NHL)) THEN
C
C             COMPUTE MAJOR & MINOR AXIS LENGTHS: INTERPOLATE BETWEEN
C             MAJAXW, MINAXW AND 0.0 IF ABOVE THE LAST CONTOUR
C
              FRACT =  1.0 - (WHC+0.5*HH - BASEHW)/(HTOPS - BASEHW)
              AAXL = MAJAXW(KLOW,NHL) * FRACT
              BAXL = MINAXW(KLOW,NHL) * FRACT
            ELSE
              CALL TERAX( SCALMA(KLOW,NHL), SCALMI(KLOW,NHL),
     *                    EXPOMA(KLOW,NHL), EXPOMI(KLOW,NHL),
     *                    (HTOPS-BASEHL), (WHC+0.5*HH), BASEHL, RSHL,
     *                    AAXL, BAXL )
          ENDIF
C
C         CONVERT THTAH TO RADIANS CCW FROM N
          PHIHL=-THTAH*DTOR+TWOPI
C         SHIFT ORIGIN TO CENTER OF LIFT HILL (E DENOTES ELLIPSE)
          XSEL = XS - XHILLL
          YSEL = YS - YHILLL
C
C         ROTATE COORD SYS TO ALIGN ORIGINAL X-AXIS W/ MEAN FLOW DIR
C         XSEPL AND YSEPL ARE SOURCE COORDINATES IN FLOWDIRECTION/
C         HILL CREST COORDINATES
          XSEPL =  XSEL*COSFLO + YSEL*SINFLO
          YSEPL = -XSEL*SINFLO + YSEL*COSFLO
              ALF = 0.0
C
C  SUBSTITUTING A CALL FOR LIFTIN, HAVE TRANSPLANTED PERTINENT CODE FROM
C  SEQMOD AND LIFTIN 
C 
C  PSI IS ANGLE IN RADIANS (CCW) FROM THE X-AXIS (ALONG FLOW) TO THE MINOR AXIS
C  OF THE HILL

        PSI = PIBY2-PHIM+PHIHL
C  SET UP LENGTH SCALES OF THE CUT-OFF HILL
        AH = AAXL*ALPHA
        BH = BAXL*ALPHA
c  Set variables contained in common PASL
c  Find parameters for rotated hill
      call HILROT(ah,bh,psi)

c  Set variables contained in common FLVARS
      PII = ONE / PI
      RTPII = ONE / SQRPI
C *** COMPUTE NEEDED LENGTH SCALE FACTORS.
      LXI = ONE / LX
      LXI2 = LXI * LXI
      LYI = ONE / LY
      LYI2 = LYI * LYI
      LYI3 = LYI2 * LYI
      LZI = SQRT(HALF * (LXI2 + LYI2) ) / RNLZ
      LZ  = ONE / LZI
      LN  = HALF * SQRPI * LZ
      LNI = ONE / LN
C
C     COMPUTE THE HILL ASYMMETRY FACTOR HASYM. ....EQN. A-19B
      HASYM = SQRT(ONE+LX*LX*LYI2)
      IF(HASYM .GT. SQR2) HASYM = SQR2

      RETURN
      END 

