        REAL FUNCTION GETTA(Z2)
C-----------------------------------------------------------------------
C PURPOSE: THIS ROUTINE COMPUTES THE TEMPERATURE AT HEIGHT Z2.
C
C ARGUMENTS
C  PASSED:
C       Z2      REAL    HEIGHT (M)
C  RETURNED FUNCTION VALUE:
C       GETTA   REAL    TEMPERATURE (DEG-K)
C
C I/O: NONE
C
C CALLING ROUTINES: HCRIT BULKFR
C
C EXTERNAL ROUTINES: KLOSE  GETDTH
C
C INTRINSIC FUNCTIONS:  ABS  AINT  AMAX1
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: SFCMET PROFIL
C
C-----------------------------------------------------------------------
C
      INCLUDE   'PARAMS.INC'
      INCLUDE   'PROFIL.CMN'
      INCLUDE   'SFCMET.CMN'
C
C       DEFINE ARGUMENTS
        REAL    Z2
C
C       DEFINE LOCAL VARIABLES
        INTEGER LEV, N, NNEW, IEND
        REAL    TANEW(MAXLEV), HTNEW(MAXLEV), Z1, Z3, T1, T3,
     &          DX, DZ, DTHDZ, DTDZ, DELZ, DELTAZ, Z, TAMISS,
     &          SIGN, X, TAZ, DTHZ
        DATA    TAMISS/ 0.0/
C
C       EXAMINE DATA AND SELECT ONLY NONMISSING VALUES
C
        NNEW = 0
        DO 100 N = 1,NHT
           IF(TAHR(N) .LT. TAMISS ) GO TO 100
           NNEW = NNEW + 1
           TANEW(NNEW) = TAHR(N)
           HTNEW(NNEW) = HT(N)
100     CONTINUE
        IF(NNEW .EQ. 0) GO TO 200
        LEV=KLOSE(HTNEW,NNEW,Z2)
        IF(LEV .EQ. 0) THEN
            Z1 = HTNEW(1)
            T1 = TANEW(1)
          ELSE
            Z1=HTNEW(LEV)
            T1=TANEW(LEV)
        ENDIF
C
C       Z1 IS MEASUREMENT HEIGHT CLOSEST TO BUT LESS THAN Z2.
C       USE INTERPOLATION IF POSSIBLE; OTHERWISE, USE PROFILING.
C
        IF(LEV.GE.1 .AND. LEV.LT.NNEW) THEN
            T3 = TANEW(LEV+1)
            Z3 = HTNEW(LEV+1)
            DX = T3 - T1
            DZ = Z3 - Z1
            GETTA = T1 + (Z2-Z1)*(DX/DZ)
            RETURN
        ENDIF
C
C       IF BOTH Z1 AND Z2 ARE ABOVE XMH, USE THE (CONSTANT) VERTICAL
C       POTENTIAL TEMPERATURE GRADIENT TO EXTRAPOLATE
C
        IF(Z1 .GT. XMH .AND. Z2 .GT. XMH) THEN
            DTHDZ = GETDTH(Z1,XMH)
            DTDZ = DTHDZ - 0.0098
            GETTA = T1 + (Z2 - Z1) * DTDZ
            RETURN
        ENDIF
C
C       IF Z1 OR Z2 IS BELOW XMH, VPTG MAY NOT BE CONSTANT WITH HEIGHT.
C       DIVIDE THE LAYER INTO SEVERAL LEVELS AND EXTRAPOLATE USING
C       DTHDZ: USE ONLY ONE LAYER FOR UNSTABLE CONDITIONS (DTHDZ=0);
C       MAKE LAYERS LESS THAN OR EQUAL TO 100 METERS OTHERWISE.
C
200     DELTAZ = ABS(Z2 - Z1)
        IF(EL .LT. 0.0) THEN
            DELZ = Z2 - Z1
          ELSE
            SIGN = (Z2 - Z1)/DELTAZ
            X = AMAX1(1.0, AINT(DELTAZ/100.))
            DELZ = DELTAZ * SIGN/X
        ENDIF
C
        Z = Z1
        TAZ = T1
500     IF( ABS(Z2-Z) .LT. ABS(DELZ) ) THEN
            DZ = Z2 - Z
            IEND = 1
          ELSE
            DZ = DELZ
            IEND = 0
        ENDIF
        DTHZ = Z + 0.5 * DELZ
        IF( DTHZ .LT. 0.0 ) DTHZ = 0.0
        DTHDZ = GETDTH( DTHZ , XMH)
        DTDZ = DTHDZ - 0.0098
        TAZ = TAZ + DTDZ * DZ
        IF(IEND.EQ.1) THEN
            GETTA = TAZ
            RETURN
          ELSE
            Z = Z + DELZ
            GO TO 500
        ENDIF
        END
