        REAL FUNCTION GETWD(Z2)
C-----------------------------------------------------------------------
C PURPOSE: THIS ROUTINE COMPUTES THE WIND DIRECTION AT HEIGHT Z2.
C
C ARGUMENTS
C  PASSED:
C       Z2      REAL    HEIGHT (M)
C
C  RETURNED FUNCTION VALUE:
C       GETWD   REAL    WIND DIRECTION (DEG)
C
C I/O: NONE
C
C CALLING ROUTINES:  PLAVG
C
C EXTERNAL ROUTINES: KLOSE  DELWD
C
C INTRINSIC FUNCTIONS: ABS  ALOG  AMAX1  AMIN1 ATAN  SQRT
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: SFCMET  PROFIL
C
C-----------------------------------------------------------------------
C
      INCLUDE   'PARAMS.INC'
      INCLUDE   'SFCMET.CMN'
      INCLUDE   'PROFIL.CMN'
      INCLUDE   'PARAMS.CMN'
C
C       DEFINE ARGUMENTS
        REAL    Z2
C
C       DEFINE LOCAL VARIABLES
        REAL    R,      SQR,    A,      B,      UGDUS,
     1          ANG,    DEL1,   DEL2,   DELANG, WD1,    Z1,
     2          WDNEW(MAXLEV),  HTNEW(MAXLEV), WDMISS, SFCLH,
     3          WD3, Z3, DX, DZ
        INTEGER         LEV,    N,      NNEW,   NO
        DATA    WDMISS/ 0.0/,   NO/0/
C
C       IF UNSTABLE HOUR (-100<EL<0), DON'T PROFILE ABOVE THE SURFACE
C       LAYER.  DEFINE THE SURFACE LAYER AS THE LARGER OF 0.1 * Zi AND
C       2*ABS(L), BUT DON'T EXCEED 200 M

        IF (EL .LT. 0 .AND. EL .GT. -100) THEN
          SFCLH = AMIN1(AMAX1(2*ABS(EL),(0.1*XMH)),200.0)
        ELSE
          SFCLH = XMH
        ENDIF

C       EXAMINE DATA AND SELECT ONLY NONMISSING VALUES
C
        NNEW = 0
        DO 100 N = 1,NHT
           IF( WDHR(N) .LT. WDMISS ) GO TO 100
           NNEW = NNEW + 1
           WDNEW(NNEW) = WDHR(N)
           HTNEW(NNEW) = HT(N)
100     CONTINUE
        IF(NNEW.EQ.0) THEN
            GETWD = 0.
            RETURN
        ENDIF
C
C       GET NEAREST LEVEL OF DATA LESS THAN HEIGHT Z2
C
        LEV = KLOSE(HTNEW,NNEW,Z2)
        IF(LEV .EQ. 0) THEN
            Z1 = HTNEW(1)
            WD1 = WDNEW(1)
          ELSE
            Z1 = HTNEW(LEV)
            WD1 = WDNEW(LEV)
        ENDIF
C
C       USE INTERPOLATION IF POSSIBLE; OTHERWISE, USE PROFILING
C
        IF(LEV.GE.1 .AND. LEV.LT.NNEW) THEN
            WD3 = WDNEW(LEV+1)
            Z3 = HTNEW(LEV+1)
            DX = DELWD(WD1,WD3)
            DZ = Z3-Z1
            GETWD = WD1 + (Z2-Z1)*(DX/DZ)
            IF(GETWD .LE. 0.0) THEN
                GETWD = 360.0+GETWD
              ELSE IF(GETWD .GT. 360.0) THEN
                GETWD = GETWD-360.0
            ENDIF
            RETURN
        ENDIF

C
C       IF BOTH Z1 AND Z2 ARE ABOVE SFCLH, USE OBSERVATION AT Z1 WITHOUT
C       SCALING.
C
        IF(Z1 .GT. SFCLH .AND. Z2 .GT. SFCLH) THEN
            GETWD = WD1
            IF(GETWD .LE. 0.0) THEN
                GETWD = 360.0+GETWD
              ELSE IF(GETWD .GT. 360.0) THEN
                GETWD = GETWD-360.0
            ENDIF
            RETURN
        ENDIF
C
C       NO SCALING OF WIND DIRECTION WITH HEIGHT
C
        IF(IWD .EQ. NO) THEN
            GETWD = WD1
            IF(GETWD .LE. 0.0) THEN
                GETWD = 360.0+GETWD
              ELSE IF(GETWD .GT. 360.0) THEN
                GETWD = GETWD-360.0
            ENDIF
            RETURN
        ENDIF
C
C       DO SCALING IF EITHER Z1 OR Z2 IS BELOW SFCLH -- NO CHANGE IN WIND
C       DIRECTION IS ASSUMED FOR HEIGHTS ABOVE SURFACE LAYER.
C       DETERMINE SURFACE BACKING ANGLE (FROM TENNEKES, 1981).
C       SEE EQN 7 OF CTDMPLUS USER'S GUIDE.
C
        R = SFCLH/EL
        SQR = SQRT(ABS(R))
C
C       DETERMINE THE RESISTANCE STABILITY FUNCTION, A
C
        IF(R .LT. -25.0) THEN
                A = 3.9
           ELSE IF(R .LE. 0.0) THEN
                A = 0.78 * SQR
           ELSE
                A = -4.17 * SQR
        ENDIF
C
C       DETERMINE THE ANGLE STABILITY FUNCTION, B
C
        IF(R .LT. -50.0) THEN
                B =  1.2
           ELSE IF(R .LE. 10.0) THEN
                B = 1.2 + SQRT(R+50.0) * 0.491
           ELSE IF(R .LE. 50.0) THEN
                B = 5.0 + SQRT(R-10.0) * 3.175
           ELSE
                B = 25.0
        ENDIF
        UGDUS = (ALOG(USTAR0/(CORIOL*Z0)) - A)/0.4
        ANG = ATAN(B/(0.4*UGDUS)) * 57.29578
C
C       SIMULATE BACKING WITH HEIGHT USING A LINEAR RELATION
C
        DEL1  = AMAX1(0.0,1.0 - Z1/SFCLH)
        DEL2  = AMAX1(0.0,1.0 - Z2/SFCLH)
        DELANG  = ANG * (DEL1 - DEL2)
        GETWD = WD1 + DELANG
        IF(GETWD .GT. 360.0) THEN
            GETWD = GETWD - 360.0
          ELSE IF(GETWD .LT. 0.0) THEN
            GETWD = GETWD + 360.0
        ENDIF
C
        RETURN
        END
