        INTEGER FUNCTION KLOSE( XA,     NA,     X)
C-----------------------------------------------------------------------
C PURPOSE: THIS FUNCTION RETURNS THE POSITION OF THE DATA VALUE IN ARRAY
C               XA WHICH IS NEAREST TO THE VALUE X BUT LESS THAN X
C
C ASSUMPTIONS:
C       ARRAY XA IS SORTED IN ASCENDING ORDER
C
C LIMITATIONS:  IF XA ARE ALL > X, SET KLOSE = 0
C
C ARGUMENTS
C  PASSED:
C       XA      REAL    ARRAY OF VALUES TO BE SEARCHED
C       NA      INT     DIMENSION OF XA
C       X       REAL    VALUE TO BE SEARCHED FOR
C  RETURNED FUNCTION VALUE:
C       KLOSE   INT     ARRAY SUBSCRIPT OF NEAREST VALUE TO X
C
C I/O: NONE
C
C CALLING ROUTINES: GETDTH  GETSV  GETSW  GETTA  GETWD  GETWS
C                   GETUV   HCRIT  SEQMOD
C
C EXTERNAL ROUTINES: NONE
C
C INTRINSIC FUNCTIONS: ABS
C
C COMMON BLOCKS: NONE
C
C-----------------------------------------------------------------------
C
C       DEFINE ARGUMENTS
        INTEGER NA
        REAL    XA(NA), X
C
C       IF NO XA VALUES ARE LESS THAN X, SET KLOSE = 0
C
        IF( XA(1) .GT. X ) THEN
                KLOSE = 0
        ELSE IF( XA(1) .EQ. X ) THEN
                KLOSE = 1
        ELSE
                DO  10  KLOSE = NA, 1, -1
                        IF( XA(KLOSE) .LT. X ) RETURN
10              CONTINUE
        ENDIF
        RETURN
        END
