      SUBROUTINE LIFTIN(IFLOW)
C-----------------------------------------------------------------------
C PURPOSE: SET UP DATA NEEDED BY LIFT FOR ALL RECEPTORS
C
C ARGUMENTS:
C   PASSED: NONE
C
C   RETURNED:
C       IFLOW   INT     FLAG    IF 0 MODEL THIS HOUR
C                               IF 1 DO NOT MODEL THIS HOUR
C I/O: NONE
C
C CALLING ROUTINES: SEQMOD
C
C EXTERNAL ROUTINES: ERF  HILROT  PATH
C
C INTRINSIC FUNCTIONS: ABS  AMIN1  EXP  SQRT
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: CONST  PARAMS  PASL  PASVAL  VARS
C
C-----------------------------------------------------------------------
C
      INCLUDE   'PARAMS.INC'
      INCLUDE   'CONST.CMN'
C      INCLUDE   'PARAMS.CMN'
      INCLUDE   'PASL.CMN'
      INCLUDE   'PASVAL.CMN'
      INCLUDE   'VARS.CMN'
C       DEFINE ARGUMENTS
      INTEGER IFLOW

C     DEFINE LOCAL VARIABLES
      REAL      ADD, ADDSQ, AH, B2SQ, B3SQ, BH, BOT, BOTY, BOTZ,
     *          DELANG, DELTAT, ERFM, ERFP, EXPADD, EXPSUB, FZK, FZO,
     *          HASYM, HS, HSMAX, R2SZOI, SUB, SUBSQ, THM, TKM1YP, 
     *          TKM1Z, TKM1ZP,
     *          TKY, TKYP, TKZ, TKZP, TLM, TO, TOP, TOPY, TOPZ, TOY,
     *          TOZ, TSV, TSW, TSWBYH, TTLZI, TTLZKI, TUM, XM, XO
      INTEGER   K
C
C  INITIALIZE IFLOW--DJB 2/11/91
      IFLOW = 0

C  ANGLE (CCW) FROM THE X-AXIS (ALONG FLOW) TO THE MINOR AXIS OF THE
C  HILL IS DELANG
      DELANG=PIBY2-PHIM+PHIHL
      IF(DELANG .GT. PIBY2) DELANG=DELANG-PI
      IF(DELANG .LT. -PIBY2) DELANG=DELANG+PI
C  CALCULATE THE CENTER-OF-MASS OF PLUME MATERIAL ABOVE HC (ZMASS)
      R2SZOI=1./(SQR2*SZTEST)
      ADD=(HPL+HC)*R2SZOI
      SUB=(HPL-HC)*R2SZOI
      ERFP=ERF(ADD)
      ERFM=ERF(SUB)
      ADDSQ=ADD*ADD
      SUBSQ=SUB*SUB
      EXPADD=0.
      EXPSUB=0.
      IF(ADDSQ .LT. 30.) EXPADD=EXP(-ADDSQ)
      IF(SUBSQ .LT. 30.) EXPSUB=EXP(-SUBSQ)
      TOP=SZTEST/SQR2PI*(EXPADD+EXPSUB)+HPL*.5*(ERFP+ERFM)
      BOT=1.+.5*(ERFM-ERFP)
      IF(TOP .LT. SMALL) THEN
          ZMASS=HPL-HC
        ELSE IF(BOT .LT. SMALL) THEN
          ZMASS=0.0
        ELSE
          ZMASS=TOP/BOT-HC
      ENDIF
C  DEFINE STREAMLINE HEIGHT (HS) FOR COMPUTING TERRAIN FACTORS
      HS=ZMASS*.5
      IF(HS .LT. SMALL*HH .OR. HPL .LE. HC) HS=0.
C  SET UP LENGTH SCALES OF THE CUT-OFF HILL
      AH=AAXL*ALPHA
      BH=BAXL*ALPHA
C  DO NOT ALLOW HEIGHT OF STREAMLINE TO EXCEED UPPER LIMIT COMPATIBLE
C  WITH THE FLOW ROUTINE
      CALL HILROT(AH,BH,DELANG)
      HASYM = SQRT(1.0 + LX*LX/(LY*LY))
      IF(HASYM .GT. SQR2) HASYM = SQR2
      HSMAX = HH * (1.0 + PIBY2*FR/HASYM)
      HS = AMIN1(HS,HSMAX)
C  SET UP TZ AND TY GRID OF VALUES
C  NOTE THAT S DENOTES DISTANCE FROM THE SOURCE ALONG THE FLOW, X
C  DENOTES DISTANCE FROM THE CENTER OF THE HILL ALONG THE FLOW, AND
C  XMOD DENOTES DISTANCE FROM THE (CROSSWIND) CREST-LINE ALONG THE FLOW
      IF(SO .LT. 0.0) SO = 0.0
      XO=SO+XSEPL
C  SET DISTANCE INCREMENT FOR GRID OF (25) POINTS ALONG THE FLOW EQUAL
C  TO 1/10 THE LENGTH SCALE OF THE HILL IN THE FLOW DIRECTION.
C  NOTE THAT THIS CHOICE IS RELATED TO THE USE OF MXDPTS=25, SO THAT
C  THE CODE SHOULD BE CHANGED IF MXDPTS IS OTHER THAN 25.
      IF(XO .LT. -LX) THEN
         DELTAX = -0.1 * XO
        ELSE
         DELTAX = 0.1 * LX
      ENDIF
      DELTAT=DELTAX/UV
      TTLZI=1./TTLZ
      TO=SO/UV
      TOZ=TO+ZTV
      TOY=TO+YTV
C  FZO IS (SIGMA-Z/(SIGMA-W * TO))**2 AT THE UPWIND BASE OF CUT-OFF HILL
      FZO=1./(1.+.5*TOZ*TTLZI)
C  INITIALIZE OUTPUT ARRAYS OF Tz**2 AND Ty**2
      DO 101 K=1,MXDPTS
         ATZSQ(K) = 1.0
         ATYSQ(K) = 1.0
         SG(K)=SO+K*DELTAX
101   CONTINUE
C
C     SKIP FLOW CALC IF THE PLUME CENTERLINE MISSES THE HILL
      IF(ABS(YSEPL) .LT. 2.0*LY) THEN
C  OBTAIN TZ AND TY FACTORS
         BOTZ=0.
         BOTY=0.
C
C  LOOP OVER THE DOWNWIND GRID POINTS (MXDPTS)
         DO 10 K=1,MXDPTS
            IF(K .EQ. 1) THEN
C  NOTE-- TIME AT THE Kth POINT FOR COMPUTING TZ IS DENOTED AS TKZ
C         TIME AT THE (K-1) POINT FOR TZ IS DENOTED AS TKM1Z
C         WHEN SCALED BY THE TIME TO THE BASE OF THE HILL (TOZ),ADD 'P'
               TKM1Z=TOZ
               TKM1ZP=1.
               TKM1YP=1.
            ENDIF
            TKZ=TOZ+K*DELTAT
            TKY=TOY+K*DELTAT
C (SCALE TIMES BY TOZ OR TOY TO AVOID DIFFERENCING SQUARES OF LARGE #S)
            TKZP=TKZ/TOZ
            TKYP=TKY/TOY
C  FZK IS (SIGMA-Z/(SIGMA-W * TO))**2 AT THE Kth POINT
            FZK=TKZP*TKZP/(1.+.5*TKZ*TTLZI)
C  OBTAIN THE STRAIN FACTORS AT THE MID-POINT OF THE INTERVAL
            XM=SG(K)-.5*DELTAX+XSEPL
            CALL PATH(THM,TLM,TUM,XM,YSEPL,HS,ALF,FR,ILOOP)

C           IF ENDLESS LOOP IN PATH, DO NOT MODEL THIS HOUR
            IF (ILOOP .EQ. 1) THEN
              IFLOW = 2
              RETURN
            ENDIF
C
C           IF NEGATIVE OR ZERO T FACTORS, DO NOT MODEL THIS HOUR
C
C            IFLOW = 0  -- INITIALIZED AT BEGINNING 2/1/91
            IF(THM .LE. 0.0 .OR. TLM .LE. 0.0 .OR. TUM .LE. 0.0) THEN
                IFLOW = 1
                RETURN
            ENDIF
C  COMPUTE SQUARE OF THE STRAIN FUNCTION : VERTICAL=B3SQ ; LATERAL=B2SQ
C                                         ....EQN. A-5
            IF(THM .GT. 16.) THM = 16.
            B3SQ=EXP(-2.*(THM-1.))
            IF(TLM .GT. 16.) TLM = 16.
            B2SQ=EXP(-2.*(TLM-1.))
            TSW=TUM
            TSV=1.
            TSWBYH=TSW/THM
C  COMPUTE 1/LAGRANGIAN TIMESCALE FOR THIS POINT ....EQN. A-9
            TTLZKI=TSTRAT/SQRT(THM)+TSWBYH*TNEUT*HPL/(ZMASS+HC)
C  COMPUTE THE FACTORS TZ**2 AND TY**2
C  USE EQNS. A-6, A-7, A-10, AND A-11;  TURN EXPRESSIONS FOR 1/TZ AND
C  1/TY 'OVER', AND DIVIDE TOP AND BOTTOM BY SIGMA-W * TOZ (OR
C  SIGMA-V * TOY).
            TOPZ=FZK-FZO
            TOPY=TKYP*TKYP-1.
            BOTZ=BOTZ+B3SQ*TSW*TSW*(TKZP*TKZP/(1.+.5*TKZ*TTLZKI)-
     *                TKM1ZP*TKM1ZP/(1.+.5*TKM1Z*TTLZKI))
            BOTY=BOTY+B2SQ*TSV*TSV*(TKYP*TKYP-TKM1YP*TKM1YP)
            ATZSQ(K)=TOPZ/BOTZ
            ATYSQ(K)=TOPY/BOTY
C  RESET THE LOWER TIME VALUES FOR THE NEXT INTERVAL IN K
            TKM1Z=TKZ
            TKM1ZP=TKZP
            TKM1YP=TKYP
10       CONTINUE
      ENDIF
      RETURN
      END
