        SUBROUTINE MAP
C-----------------------------------------------------------------------
C PURPOSE: THIS ROUTINE CREATES A MAP OF THE SOURCES AND RECEPTORS
C               RELATIVE TO EACH OTHER. DISTANCES IN THE X AND Y
C               DIRECTIONS ARE SET EQUAL USING PARAMETER XYFACT.
C               XYFACT IS SET TO 1.2 FOR STANDARD PRINTER OUTPUT,
C               WHICH HAS 6 LINES AND 10 COLUMNS PER INCH.  MAP
C               PLOTS EVERY OTHER COLUMN, OR 5 SEPARATED COLUMNS PER
C               INCH.  THEREFORE, A 60 X 60 MAP REQUIRES 10 INCHES IN
C               THE VERTICAL AND 12 INCHES IN THE HORIZONTAL, GIVING
C               AN XYFACT OF 1.2.
C
C ASSUMPTIONS:
C       SOURCE AND RECEPTOR HORIZ. COORDINATES ARE IN THE SAME UNITS
C
C LIMITATIONS:
C       A MAXIMUM OF 60 COLUMNS AND 60 ROWS ARE USED TO PRODUCE THE
C               MAP (SEE PARAMETERS MAXX AND MAXY).  FOR 80 COLUMN
C               PRINTING, THE MAP CONSISTS OF 40 COLUMNS AND 40 ROWS.
C               THE VARIABLE IWIDTH IS CURRENTLY SET TO 0 TO FORCE
C               80 COLUMN PRINTING.
C
C ARGUMENTS: NONE
C
C I/O:
C  INPUT: NONE
C  OUTPUT: UNIT=IOUT
C       PRINTOUT OF SOURCE, RECEPTOR, AND HILL LOCATIONS
C
C CALLING ROUTINES: CTDMPLUS (MAIN)
C
C EXTERNAL ROUTINES: PAGE
C
C INTRINSIC FUNCTIONS: AMAX1  AMIN1  FLOAT  INT
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: IO PARAMS RECEPT STACKS
C
C-----------------------------------------------------------------------
C
        PARAMETER(      MAXX    =       60)
        PARAMETER(      MAXY    =       60)
        PARAMETER(      MAXXY   =       3600)
        PARAMETER(      XYFACT  =       1.2)
C
      INCLUDE   'PARAMS.INC'
      INCLUDE   'IO.CMN'
C      INCLUDE   'PARAMS.CMN'
      INCLUDE   'RECEPT.CMN'
      INCLUDE   'STACKS.CMN'
C
C       DEFINE LOCAL VARIABLES
        REAL    RXMIN,  RYMIN,  RXMAX,  RYMAX,  SXMIN,  SYMIN,
     1          SXMAX,  SYMAX,  XMIN,   YMIN,   XMAX,   YMAX,
     2          DX,     DXMAX,  DY,     DYMAX,  XFACT,  YFACT,
     3          XMID,   YMID
        INTEGER NR, NS, NO, I, IWIDTH, J,   MAXY1,  MAXX1
        CHARACTER*1 BUFF(MAXX,MAXY),S,PLUS,H,V,HILSYM(0:MAXHIL)
C
C       XYFACT IS THE RATIO FOR THE MAPPED AREA ON PAPER OF THE
C       HORIZONTAL SIDE TO THE VERTICAL SIDE.
C
        DATA    BUFF/MAXXY*' '/
        DATA    S/'*'/, PLUS/'+'/, H/'-'/, V/'|'/
        DATA    HILSYM/ '0','1','2','3','4','5','6','7','8','9','A',
     1          'B','C','D','E','F','G','H','I','J','K','L','M',
     2          'N','O','P'/
        DATA    NO/0/
C
C       DETERMINE REQUIRED MAP COVERAGE (MIN, MAX VALUES OF X,Y)
C
        RXMIN=RECPT(1,1)
        RYMIN=RECPT(2,1)
        RXMAX=RECPT(1,1)
        RYMAX=RECPT(2,1)
        DO  10  NR=1,NRECPT
        IF(RXMIN .GT. RECPT(1,NR))  RXMIN=RECPT(1,NR)
        IF(RYMIN .GT. RECPT(2,NR))  RYMIN=RECPT(2,NR)
        IF(RXMAX .LT. RECPT(1,NR))  RXMAX=RECPT(1,NR)
        IF(RYMAX .LT. RECPT(2,NR))  RYMAX=RECPT(2,NR)
10      CONTINUE
C
        SXMIN=SOURCE(1,1)
        SYMIN=SOURCE(2,1)
        SXMAX=SOURCE(1,1)
        SYMAX=SOURCE(2,1)
        DO  20  NS=1,NSTACK
        IF(SXMIN .GT. SOURCE(1,NS))  SXMIN=SOURCE(1,NS)
        IF(SYMIN .GT. SOURCE(2,NS))  SYMIN=SOURCE(2,NS)
        IF(SXMAX .LT. SOURCE(1,NS))  SXMAX=SOURCE(1,NS)
        IF(SYMAX .LT. SOURCE(2,NS))  SYMAX=SOURCE(2,NS)
20      CONTINUE
C
        XMIN=AMIN1(RXMIN,SXMIN) - 0.001
        YMIN=AMIN1(RYMIN,SYMIN) - 0.001
        XMAX=AMAX1(RXMAX,SXMAX) + 0.001
        YMAX=AMAX1(RYMAX,SYMAX) + 0.001
        DX=XMAX-XMIN
        DY=YMAX-YMIN
C
C       ADJUST TOTAL RANGE IN X OR Y SO THAT MAP WILL FIT ON A PAGE
C
        IF(DX .GT. XYFACT*DY) THEN
            DXMAX = DX
            DYMAX = DX/XYFACT
          ELSE
            DXMAX = XYFACT*DY
            DYMAX = DY
        ENDIF
        IF(DXMAX.EQ.0.0) RETURN
        XMID = (XMAX + XMIN)/2.0
        YMID = (YMAX + YMIN)/2.0
        XMIN = XMID - DXMAX/2.0
        XMAX = XMID + DXMAX/2.0
        YMIN = YMID - DYMAX/2.0
        YMAX = YMID + DYMAX/2.0
C
C       ASSIGN NUMBER OF ROWS AND COLUMNS
C
        IWIDTH = 0
C
C       IWIDTH IS A VARIABLE NOT CURRENTLY USED; IT WAS DESIGNATED AS 0
C       FOR 80-COLUMN MAP OUTPUT AND 1 FOR 132-COLUMN OUTPUT.  HERE,
C       WIDTH IS SET TO 0, BUT CODE FOR IWIDTH = 1 IS RETAINED FOR
C       POTENTIAL FUTURE APPLICATIONS.
C
        IF(IWIDTH .EQ. 0) THEN
            MAXY1 = 40
            MAXX1 = 40
          ELSE
            MAXY1 = MAXY
            MAXX1 = MAXX
        ENDIF
C
C       PUT "+" AT MAP CORNERS IN ARRAY BUFFER
C
        BUFF(1,1) = PLUS
        BUFF(1,MAXY1) = PLUS
        BUFF(MAXX1,1) = PLUS
        BUFF(MAXX1,MAXY1) = PLUS
C
C      PUT '-' AT BOTTOM AND TOIP MAP EDGES
C
       IF(MAXX1 .GT. 2) THEN
            DO 22 I = 2,MAXX1-1
            BUFF(I,1) = H
            BUFF(I,MAXY1) = H
22          CONTINUE
        ENDIF
C
C       PUT '|' AT MAP SIDES
C
       IF(MAXY1 .GT. 2) THEN
            DO 25 I = 2,MAXY1-1
            BUFF(1,I) = V
            BUFF(MAXX1,I) = V
25          CONTINUE
        ENDIF
C
C       XFACT, YFACT ARE GRID DX,DY
C
        XFACT = FLOAT(MAXX1)/DXMAX
        YFACT = FLOAT(MAXY1)/DYMAX
C
C      PLOT RECEPTOR LOCATIONS.  NOT THAT MAP ROWS (J) START AT TOP OF
C      PAGE, BUT MINIMUM Y VALUES ARE AT MAP BOTTOM.
C
       DO  30  NR=1,NRECPT
        I=IFIX((RECPT(1,NR)-XMIN)*XFACT+1.0)
        IF(I .GT. MAXX1) I=MAXX1
        J=MAXY1-(IFIX((RECPT(2,NR)-YMIN))*YFACT)
        IF(J .LT. 1) J=1
C
C      PLOT HILL NUMBER AT EACH RECEPTOR POINT (USE LETTERS A-Z FOR
C      10-35)
C
       BUFF(I,J)=HILSYM(NRHILL(NR))
30      CONTINUE
C
C       PLOT SOURCE LOCATIONS ('*')
C
        DO  40  NS=1,NSTACK
        I=IFIX((SOURCE(1,NS)-XMIN)*XFACT+1.0)
        IF(I .GT. MAXX1) I=MAXX1
        J=MAXY1-(IFIX((SOURCE(2,NS)-YMIN))*YFACT)
        IF(J .LT. 1) J=1
        BUFF(I,J)=S
40      CONTINUE
C
        CALL PAGE(NO)
C
C       WRITE OUT ENTIRE MAP
C       6000, 6010 FORMATS COULD BE USED FOR 132-COLUMN OUTPUT
C
        IF(IWIDTH.EQ.1) THEN
            WRITE(IOUT,6000) XMIN,XMAX,YMIN,YMAX
            WRITE(IOUT, 6010) BUFF
          ELSE
            WRITE(IOUT,6005) XMIN,XMAX,YMIN,YMAX
            WRITE(IOUT,6015) ((BUFF(I,J),I=1,40),J=1,40)
        ENDIF
        RETURN
C
6000    FORMAT(1X,'MAP EDGES: XMIN = ',F8.0,', XMAX = ',F8.0,
     1  ', YMIN = ',F8.0,', YMAX = ',F8.0,';  * = SOURCE, ',
     2  'RECEPTORS SHOWN BY HILL # (0-9,A-Z)')
6005    FORMAT(3X,'MAP EDGES: XMIN = ',F8.0,', XMAX = ',F8.0,
     1  ', YMIN = ',F8.0,', YMAX = ',F8.0,//,15X,'  * = SOURCE, ',
     2  'RECEPTORS SHOWN BY HILL # (0-9,A-Z)',//)
6010    FORMAT(6X,60(1X,A1))
6015    FORMAT(40(1X,A1))
        END
