      SUBROUTINE NITCALC(NS,DELH,QS,IFLOW)
C ****************************************************************
C  THIS SUBROUTINE CALCULATES THE CONCENTRATIONS FOR STABLE/NEUTRAL
C  CONDITIONS.
C *****************************************************************


      INCLUDE 'PARAMS.INC'
      INCLUDE 'CONST.CMN'
      INCLUDE 'HEAD.CMN'
      INCLUDE 'HILL.CMN'
      INCLUDE 'IO.CMN'
      INCLUDE 'PARAMS.CMN'
      INCLUDE 'PASL.CMN'
      INCLUDE 'PASW.CMN'
      INCLUDE 'PASVAL.CMN'
C      INCLUDE 'PROFIL.CMN'
      INCLUDE 'RECEPT.CMN'
      INCLUDE 'SCREN.CMN'
      INCLUDE 'SFCMET.CMN'
      INCLUDE 'STACK.CMN'
      INCLUDE 'STACKS.CMN'
      INCLUDE 'TIME.CMN'
      INCLUDE 'TOWER.CMN'
      INCLUDE 'VARS.CMN'

       REAL  ANGINT, BASEHL, BASEHW, BETEST, COSELW, COSFLO, CSD, 
     2       DELH, DELU, DELZ, DIA, DUMMY, DUMY, DUMZ, DX, 
     3       DY, FRACT, GETSW, GETSV, GETWS, GETUV, 
     4       HTOPS, HTWRAP, PHIR, QS, RMU, RNU, 
     5       ROTELW, ROTFLO, RSHL, RSHW, S, SINELW, 
     7       SINFLO, SMUW, SND, SNUW, SPREAD, SQGAMA, SYS, TLIFT, 
     8       TMUW, TNUW, TSZS, TWRAP, U1, U2, UCGAMA, USRAT,
     9       X, XHILLL, XHILLW, XINTRP, XRMAJ, XSEL, XSEW, XSMAJW, 
     A       XTEW, XTMAJW, YHILLL, YHILLW, Y, YRMAJ, YSEL, YSEW, 
     B       YSMAJW, YTEW, YTMAJW, YTSTK, Z1, Z2, ZG, ZTSTK

       INTEGER  I, IFLOW, INDEX, IUPW(MAXREC), 
     1          KHILL(MAXHIL), KLOW, KLOSE, NH, NS, NHL

        CHARACTER*1 GSGS(2)

        DATA GSGS/'G','S'/

        UCGAMA = 0.36
        SQGAMA = 0.27

C       CALCULATE INITIAL SIGMAS DUE TO BUOYANCY

        CALL SIGB(DELH, SYS, SZS)                     

C       GET WIND SPEED (US), WIND DIRECTION (THTA), AND VERTICAL POT.
C       TEMPERATURE LAPSE RATE (DTH) AT PLUME HEIGHT.  DIFFERENT CALL
C       FOR SCREEN VERSION BECAUSE WE DON'T WANT TO RESET THTA

        IF (ISCRN .GT. 0) THEN
          CALL PLAVG(HPL,US,DUMMY,DTH,XMH)
        ELSE
          CALL PLAVG(HPL, US, THTA, DTH,XMH)
        ENDIF

C       CHECK IF WIND SPEED LESS THAN 1.0 M/S AT PLUME HEIGHT

        USRAT = 1.0
        IF( US .LT. 1.0 ) THEN
                IF( IWS1 .EQ. NO ) GO TO 370
C             SET RATIO TO INCREASE UV, SIGW AND SIGV
                USRAT = 1.0 / US
                US = 1.0
        ENDIF
        IF(EL .LT. 0.0) DTH = 0.0
        SIGW = GETSW(HPL)*USRAT
        SIGV = GETSV(HPL)*USRAT
        UV = GETUV(HPL,US,SIGV,XMH)*USRAT
        IF(UV .LT. USTAR0) UV = USTAR0
        IF(UV .GT. US) UV = US

C       SET MINIMA FOR SIGW, SIGV: 1% OF US

        SIGW = AMAX1(SIGW,0.01*US)
        SIGV = AMAX1(SIGV,0.01*US)
        BRUNT = SQRT(9.8/TA * DTH)
        SND = SIN(THTA*DTOR)
        CSD = COS(THTA*DTOR)

C  CONVERT MEAN WIND DIRECTION FROM DEG CW FROM N TO DEG CCW FROM N
C          AND CHANGE TO FLOW DIR IN RADIANS

      PHIM = (180.-THTA)*DTOR
      IF(PHIM .LT. 0.0) PHIM = TWOPI + PHIM

C  ROTATE COORD. SYS. TO ALIGN ORIGINAL X-AXIS WITH THE MEAN FLOW DIR.

      ROTFLO = PIBY2 + PHIM
      SINFLO = SIN(ROTFLO)
      COSFLO = COS(ROTFLO)

C  CALCULATE VIRTUAL SOURCE TIME INCREMENT
C  TNEUT, TSTRAT, TTLZ ARE GIVEN BY EQNS 22, 23, AND 24 IN USER'S GUIDE

      TNEUT = SIGW/(UCGAMA*HPL)
      TSTRAT = BRUNT/SQGAMA
      TTLZ = 1./(TNEUT+TSTRAT)

C     COMPUTE MINIMUM VIRTUAL SOURCE TIME INCREMENT: PLUME GROWTH TO
C     STACK DIAMETER (OR SIGMA-Y,Z GROWTH TO STACK RADIUS).  IF NO
C     "STACK" IS USED (ZERO EXIT VELOCITY, AS WITH A TRACER), ASSUME
C     A DEFAULT DIAMETER OF 1 METER.

      DIA = DS
      IF(VS .LT. SMALL) DIA = 1.0

C     SEE EQN 29 OF USER'S GUIDE
C     ZTSTK IS VIRTUAL TIME FOR SIGMA-Z GROWTH DUE TO SOURCE EFFECTS

      DUMZ = (2.0 * SIGW/DIA)**2
      ZTSTK = (1.+SQRT(1.+16.*DUMZ*TTLZ**2))/(4.*DUMZ*TTLZ)

C     COMPUTE VIRTUAL SOURCE TIME INCREMENT, ZTV: PLUME GROWTH DUE TO
C     BUOYANCY (EQN 29)
      IF(SZS .LE. 0.0) THEN
          ZTV = 0.0
        ELSE
          DUMZ = (SIGW/SZS)**2
          ZTV = (1.+SQRT(1.+16.*DUMZ*TTLZ**2))/(4.*DUMZ*TTLZ)
      ENDIF

C     ASSUME THAT TTLY IS 10000 / VECTOR WIND SPEED (AT PLUME HT).
C     APPLY EQN 29 FOR SIGMA-Y GROWTH SIMILAR TO THAT DONE FOR SIGMA-Z.

      TTLY = 10000.0 / UV
      DUMY = (2.0 * SIGV/DIA)**2
      YTSTK = (1.+SQRT(1.+16.*DUMY*TTLY**2))/(4.*DUMY*TTLY)
      IF(SZS .LE. 0.0) THEN
          YTV = 0.0
        ELSE
          DUMY = (SIGV/SZS)**2
          YTV = (1.+SQRT(1.+16.*DUMY*TTLY**2))/(4.*DUMY*TTLY)
      ENDIF

C     FINAL CALCULATION FOR VIRTUAL TIME OF TRAVEL:
C     A) AT A MINIMUM, IT IS THE TIME FOR PLUME GROWTH TO THE STACK
C        DIAMETER SIZE;
C     B) THE TIME FOR PLUME GROWTH DUE TO AMBIENT TURBULENCE TO THE
C       SIZE RESULTING FROM PLUME BUOYANCY, MINUS THE TIME FOR
C       TURBULENT GROWTH TO EXCEED SOURCE-INDUCE EFFECTS, IS USED IF
C       GREATER THAN A).

      TSZS = XSZS/UV

C     SEE EQN 30 IN USER'S GUIDE

      ZTV = AMAX1(ZTSTK,ZTV-TSZS)
      YTV = AMAX1(YTSTK,YTV-TSZS)

C       CHECK TO SEE WHICH HILLS ARE DOWNWIND

        DO 220 NH=1,NHILLS
220         KHILL(NH) = NO

C       IF ANY RECEPTOR ON A HILL IS DOWNWIND OF THE SOURCE, THEN THE
C       ENTIRE HILL IS CONSIDERED TO BE DOWNWIND OF THE SOURCE.

        DO 230 NR = 1,NRECPT
            INDEX = NRHILL(NR)
            IF(INDEX .GT. 0) THEN
                IF(KHILL(INDEX) .EQ. YES) GO TO 230
            ENDIF
            XR = RECPT(1,NR)
            YR = RECPT(2,NR)
            CALL PSRCE(SND,CSD,IUPW(NR),Y,X,XS,YS,XR,YR)
            IF(IUPW(NR) .EQ. NO .AND. INDEX .GT. 0) KHILL(INDEX) = YES
230     CONTINUE


C****************************************************


C       CASE STUDY SOURCE PRINTOUT

        IF(ICASE .EQ. 1 .OR. ICASE .EQ. 3) THEN
            WRITE(IOUT,6130)
            WRITE(IOUT,6135) NS,QS,TS,VS,FB,FM,DELH
            WRITE(IOUT,6140) HPL,THTA,US,UV,SIGV,SIGW,DTH
        ENDIF

C       START LOOP OVER HILLS AND RECEPTORS

C  ------------ START LOOP ON HILLS -----------------------------------

      DO  270  NHL = 0, NHILLS


C         IF NO RECEPTORS IN FLAT TERRAIN SKIP TERRAIN SECTION
          IF(NHL .EQ. 0) THEN
C              CHECK FOR NO FLAT TERRAIN (HILL 0) RECEPTORS
                IF( NRFLAT .EQ. NO ) GO TO 270
                GO TO 240
          ENDIF

C         IF ALL RECEPTORS ON HILL ARE UPWIND THEN SKIP ENTIRE LOOP

          IF( KHILL(NHL) .EQ. NO ) THEN
              IF(ICASE .EQ. 1 .OR. ICASE .EQ. 3) 
     $                WRITE(IOUT,6265) NHL, NS, THTA
              GO TO 270
          ENDIF

          HC = HCHILL(NHL)
          FR = FRHILL(NHL)
          HTOPS = THS(NHL)
          Z0HILL = Z0H(NHL)

C  SECTION FOR DEFINING GEOMETRY FOR WRAP COMPUTATIONS ----------------
C         CRITICAL HEIGHT FOR WRAP (HPL - PLUME HT ABOVE STACK BASE)

          HTWRAP = AMIN1( HPL, HC )

C         GET HILL COORDS, ANGLE AND MAJOR, MINOR AXIS FOR THE WRAP HILL
C         W AT END OF VARIABLE INDICATE WRAP HILL
C         KLOW IS THE ARRAY INDEX TO THE HEIGHT CLOSEST TO (BUT LESS
C         THAN) HTWRAP
          KLOW = KLOSE( ZHS(1,NHL), NZH(NHL), HTWRAP )
          IF( KLOW .EQ. 0 ) KLOW = 1
          BASEHW = ZHS(KLOW,NHL)
          IF( KLOW .EQ. NZH(NHL) ) THEN
C             THE CRITICAL HT IS ABOVE LAST CONTOUR VALUE
C             DO NOT INTERPOLATE, BUT USE INVERSE POLYNOMIAL FORMULA

C             GET X, Y, ORIENTATION OF THE ELLIPSE FOR WRAP FROM THE
C             LOOK-UP TABLE.

              XHILLW = XHW(KLOW,NHL)
              YHILLW = YHW(KLOW,NHL)
              THTAH = MAJORW(KLOW,NHL)
C            DISTANCE SOURCE TO  HILL CENTER
              DX = XS - XHILLW
              DY = YS - YHILLW
              RSHW = SQRT( DX*DX + DY*DY )

C             COMPUTE MAJOR & MINOR AXIS LENGTHS: INTERPOLATE BETWEEN
C             MAJAXW, MINAXW AND 0.0 IF ABOVE THE LAST CONTOUR

              FRACT =  1.0 - (HTWRAP - BASEHW)/(HTOPS - BASEHW)
              AAXW = MAJAXW(KLOW,NHL) * FRACT
              BAXW = MINAXW(KLOW,NHL) * FRACT
           ELSE
C             LINEARLY INTERPOLATE BETWEEN TWO VALUES
              XHILLW = XINTRP( ZHS(KLOW,NHL), ZHS(KLOW+1,NHL), HTWRAP,
     *                         XHW(KLOW,NHL), XHW(KLOW+1,NHL))
              YHILLW = XINTRP( ZHS(KLOW,NHL), ZHS(KLOW+1,NHL), HTWRAP,
     *                         YHW(KLOW,NHL), YHW(KLOW+1,NHL))
              AAXW = XINTRP( ZHS(KLOW,NHL), ZHS(KLOW+1,NHL),  HTWRAP,
     *                       MAJAXW(KLOW,NHL), MAJAXW(KLOW+1,NHL))
              BAXW = XINTRP( ZHS(KLOW,NHL), ZHS(KLOW+1,NHL),  HTWRAP,
     *                       MINAXW(KLOW,NHL), MINAXW(KLOW+1,NHL))
              THTAH = ANGINT( MAJAXW(KLOW,NHL),MINAXW(KLOW,NHL),
     *                        MAJORW(KLOW,NHL), ZHS(KLOW,NHL),
     *                        MAJAXW(KLOW+1,NHL),MINAXW(KLOW+1,NHL),
     *                        MAJORW(KLOW+1,NHL), ZHS(KLOW+1,NHL),
     *                        HTWRAP )

C               CHECK THAT ELLIPSE AXES ARE LESS THAN DIST FROM SOURCE
C               TO HILL CENTER   AAX <= BAX < DIST SOURCE/HILL CENTER
                DX = XS - XHILLW
                DY = YS - YHILLW
                RSHW = SQRT( DX*DX + DY*DY )
C                IF( AAXW .GT. RSHW ) AAXW = 0.99 * RSHW
C                IF( BAXW .GT. AAXW ) BAXW = AAXW
          ENDIF

C         SHIFT ORIGIN TO CENTER OF WRAP HILL (E DENOTES ELLIPSE)
          XSEW = XS - XHILLW
          YSEW = YS - YHILLW
          XTEW = XT - XHILLW
          YTEW = YT - YHILLW

C         FIND TOWER AND SOURCE LOCATIONS RELATIVE TO MAJOR AXIS OF
C         WRAP HILL ELLIPSE. NOTE: X-AXIS LIES ALONG MAJOR AXIS
          ROTELW = (90.0 - THTAH) * DTOR
          COSELW = COS(ROTELW)
          SINELW = SIN(ROTELW)
          XTMAJW =  XTEW*COSELW + YTEW*SINELW
          YTMAJW = -XTEW*SINELW + YTEW*COSELW
          XSMAJW =  XSEW*COSELW + YSEW*SINELW
          YSMAJW = -XSEW*SINELW + YSEW*COSELW

C         COMPUTE ELLIPTICAL COORDS OF SOURCE AND TOWER
          CALL MUNU( XSMAJW, YSMAJW, AAXW, BAXW, SMUW, SNUW )
          CALL MUNU( XTMAJW, YTMAJW, AAXW, BAXW, TMUW, TNUW )

C         SET UP DATA FOR FLOW BELOW HC (WRAP)
          CALL WRAPIN( TMUW, TNUW, SMUW, SNUW, XSMAJW, 
     *                 YSMAJW )

C         CHECK THE WRAP/LIFT TIME RATIO (TFAC). NOTE THAT THE
C         TIME TO LIFT USES 'SO' WHICH IS COMPUTED BY WRAPIN USING
C         THE WRAP HILL ELLIPSE VARIABLES

          TFAC = 0.0
          TWRAP = SOBETA / UVBETA + ZTV
          TLIFT = SO / UV + ZTV
          IF(TLIFT .LT. 0.0) THEN
              IF(ICASE .EQ. 1 .OR. ICASE .EQ. 3) 
     $            WRITE(IOUT,6270) NHL, NS, THTA
              GO TO 270
          ENDIF
          IF( TLIFT .NE. 0.0 ) TFAC = TWRAP/TLIFT
C         COMPUTE SIGMA-Z AT THE IMPINGEMENT POINT FOR LIFT TIME
          SZTEST = SIGW * TLIFT/SQRT( 1.0 + 0.5*TLIFT/TTLZ )

C         WRITE OUT HILL INFO AND WRAP VARIABLES

          IF( ICASE .EQ. 1 .OR. ICASE .EQ. 3) THEN
                CALL PAGE(YES)
                WRITE(IOUT,6150) NHL, (HILNAM(I,NHL),I=1,10), HC, FR
                WRITE(IOUT,6155) RSHW, HTWRAP, AAXW, BAXW, THTAH,
     1            ABS(SOBETA)
          ENDIF
C
C  SECTION FOR DEFINING THE GEOMETRY FOR LIFT COMPUTATIONS-------------
C         GET ARRAY INDEX TO CONTOUR BELOW CUT-OFF HILL
C
          KLOW = KLOSE( ZHS(1,NHL), NZH(NHL), HC )
          IF( KLOW .EQ. 0 ) KLOW = 1

C         OBTAIN X, Y, ORIENTATION OF CUT-OFF HILL FROM LOOK-UP TABLES
C         FOR LIFT

          XHILLL = XHL(KLOW,NHL)
          YHILLL = YHL(KLOW,NHL)
          THTAH = MAJORL(KLOW,NHL)
          DX = XS - XHILLL
          DY = YS - YHILLL
          RSHL = SQRT( DX*DX + DY*DY )
C         CUT-OFF HILL BASE AND HEIGHT FOR LIFT
          BASEHL = ZHS(KLOW,NHL)
          HH = HTOPS - HC
          IF(KLOW .EQ. NZH(NHL)) THEN
C
C             COMPUTE MAJOR & MINOR AXIS LENGTHS: INTERPOLATE BETWEEN
C             MAJAXW, MINAXW AND 0.0 IF ABOVE THE LAST CONTOUR
C
              FRACT =  1.0 - (HC+0.5*HH - BASEHW)/(HTOPS - BASEHW)
              AAXL = MAJAXW(KLOW,NHL) * FRACT
              BAXL = MINAXW(KLOW,NHL) * FRACT
            ELSE
              CALL TERAX( SCALMA(KLOW,NHL), SCALMI(KLOW,NHL),
     *                    EXPOMA(KLOW,NHL), EXPOMI(KLOW,NHL),
     *                    (HTOPS-BASEHL), (HC+0.5*HH), BASEHL, RSHL,
     *                    AAXL, BAXL )
          ENDIF

C         CONVERT THTAH TO RADIANS CCW FROM N
          PHIHL=-THTAH*DTOR+TWOPI
C         SHIFT ORIGIN TO CENTER OF LIFT HILL (E DENOTES ELLIPSE)
          XSEL = XS - XHILLL
          YSEL = YS - YHILLL

C         ROTATE COORD SYS TO ALIGN ORIGINAL X-AXIS W/ MEAN FLOW DIR
          XSEPL =  XSEL*COSFLO + YSEL*SINFLO
          YSEPL = -XSEL*SINFLO + YSEL*COSFLO

C         DETERMINE SPEED SHEAR FOR FLOW; SET UP LIFT VARIABLES

          Z1 = HPL
          U1 = US
          Z2 = HC
          IF(ABS(Z2-Z1) .LT. 0.1 * HH) Z2 = HTOPS
          U2 = GETWS(Z2)
          DELU = U2 - U1
          IF(ABS(DELU) .LT. 0.001) DELU = 0.0
          DELZ = Z2 - Z1
          IF(DELZ .EQ. 0.0) THEN
              ALF = 0.0
            ELSE
              ALF = AMAX1(0.0,DELU/DELZ)
          ENDIF

          CALL LIFTIN(IFLOW)
          IF(IFLOW .GT. 0) GO TO 360
          IF(FR .LT. 0.8 .AND. (ICASE .EQ. 1 .OR. ICASE .EQ. 3))
     $        WRITE(IOUT, 6158)

C         WRITE LIFT INFORMATION

          IF(ICASE .EQ. 1 .OR. ICASE .EQ. 3) THEN
              WRITE(IOUT,6160) RSHL, HC + 0.5*HH, AAXL, BAXL, THTAH,
     1          ABS(XSEPL), YSEPL, SO
          ENDIF

C  SET UP COLUMN TITLES FOR RECEPTOR CASE-STUDY OUTPUT

240   IF( ICASE .EQ. 1 .OR. ICASE .EQ. 3 ) THEN
        WRITE(IOUT,6170) GSGS(ICHIQ+1)
        NLINES = NLINES + 5
        IF(NHL .GT. 0) NLINES = NLINES + 22
      ENDIF


C  --------------- START LOOP ON RECEPTORS -----------------------------

          DO  260  NR = 1, NRECPT

C             CHECK IF THIS RECEPTOR IS ON CURRENT HILL
              IF( NRHILL(NR) .NE. NHL ) GO TO 260

C             SET UP RECEPTOR VARIABLES
C             ZELEV IS RECEPTOR HEIGHT ABOVE GROUND SURFACE

              XR = RECPT(1,NR)
              YR = RECPT(2,NR)
              ZELEV = RECPT(3,NR)
              ZG = RECPT(4,NR)
              Z = ZELEV + ZG
C            DO NOT ALLOW RECEPTOR TO BE BELOW THE MODEL ZERO PLANE
              IF( Z .LT. 0.0 ) Z = 0.0

C             INITIALIZE CONCENTRATION
              C = 0.0

C            IF OPTION SELECTED, SET CONC TO 0 FOR RECEPTORS BELOW 
C            STACK TOP
             IF (ISTKTP .EQ. 1 .AND. ZG .LT. HS) GO TO 260

C             IF ESSENTIALLY FLAT TERRAIN (HILL = 0), CALL FLAT AND EXIT

              IF(NHL .EQ. 0) THEN
                  IF(IUPW(NR) .EQ. YES) GO TO 260
                  CALL FLAT(QS,Z)
                  NLINES = NLINES + 2
                  GO TO 250
              ENDIF

C             START RECEPTOR COORD SETUP FOR CALL TO LIFT
C             SHIFT ORIGIN TO CENTER OF HILL
              XEL= XR - XHILLL
              YEL= YR - YHILLL

C             ALIGN X-AXIS WITH MEAN FLOW
              XEPL =  XEL* COSFLO + YEL* SINFLO
              YEPL = -XEL* SINFLO + YEL* COSFLO

C             CALC DIRECTION FROM SOURCE TO RECEPTOR (CCW FROM N)
              PHIR = ATAN2( (XSEL-XEL),(YEL-YSEL) )
              IF( PHIR .LT. 0.0 ) PHIR = PHIR + TWOPI

C             CHECK IF TRAJECTORY IS TOWARDS RECEPTOR FOR LIFT CALC.
              SPREAD = ABS( PHIR - PHIM )
              IF( SPREAD .GT. PI ) SPREAD = -SPREAD + TWOPI

              IF( SPREAD .GT. PIBY2) THEN
C                 RECEPTOR IS NOT DOWNWIND
                  IF( ICASE .EQ. 1 .OR. ICASE .EQ. 3 ) 
     $               WRITE(IOUT,8010) NR
               ELSE
                  S = XEPL - XSEPL
C                 USE LIFT FOR ALL RECEPTORS AT OR ABOVE HC
                  IF( Z .GE. HC ) THEN
                      CALL LIFT(QS)
                    ELSE
                      IF( ICASE .EQ. 1 .OR. ICASE .EQ. 3 ) 
     $                   WRITE(IOUT,6175) NR
                  ENDIF
              ENDIF

C             COMPUTE RECEPTOR COORDS RELATIVE TO WRAP HILL

C             FIND RECEPTOR LOCATION RELATIVE TO MAJOR AXIS OF ELLIPSE
C             SHIFT ORIGIN TO CENTER OF WRAP HILL
              XEW= XR - XHILLW
              YEW= YR - YHILLW
C
              XRMAJ =  XEW* COSELW + YEW* SINELW
              YRMAJ = -XEW* SINELW + YEW* COSELW

C             IS RECEPTOR ON SOURCE SIDE OF STAGNATION STREAMLINE
              CALL MUNU( XRMAJ, YRMAJ, AAXW, BAXW, RMU, RNU )
              IF( ABS(PSIHAT) .LE. SMALL ) THEN
                  SIGNYE = 1.0
               ELSE
                  SIGNYE = SIGN(1.0, -SIN(RNU+ALPHAW)/PSIHAT)
              ENDIF

C             CALCULATE POSITION ALONG BETA
              XRBETA = XRMAJ*COS(BETA) + YRMAJ*SIN(BETA)

C             CHECK IF TRAJECTORY IS TOWARDS RECEPTOR FOR WRAP CALC.
C             USE THE UNMODIFIED SOURCE AND RECEPTOR POSITIONS
C              BETEST = XRBETA / XSBETA
              BETEST = XRBETA/XSBSAV
              IF( BETEST .GT. 1.0 ) THEN
C                 RECEPTOR IS NOT DOWNWIND
                  IF( ICASE .EQ. 1 .OR. ICASE .EQ. 3 ) 
     $                      WRITE(IOUT,8020) NR
                ELSE IF( (HC/HH) .GT. SMALL ) THEN

C             FOR TRAVEL TIME OF FLOW AROUND THE ELLIPSE, IF THE RECEPTOR
C             IS OUTSIDE OF THE ELLIPSE (RMU > 0), FORCE IT TO BE ON THE
C             ELLIPSE BY RESETTING RMU AND COMPUTING A NEW X,Y

                  IF (RMU .GT. 0) THEN
                    AR = AAXW/BAXW
                    ARSQ = AR * AR
                    IF (ARSQ .LT. 1.0) ARSQ = 1.0
                    DUM1 = SQRT(ARSQ - 1.)

C             TEST FOR A CIRCLE (DUM1 = 0)                    
                    IF (DUM1 .NE. 0.0) THEN
                      RMU0 = ALOG((AR+1.)/DUM1)
                      SINNU = SIN(RNU)
                      COSNU = COS(RNU)
                      SINHMU = SINH(RMU0)
                      COSHMU = COSH(RMU0)
                      XRELL = (DUM1 * COSHMU * COSNU) * BAXW
                      YRELL = (DUM1 * SINHMU * SINNU) * BAXW

C             FOR A CIRCLE CENTERED AT (0,0), DECREASE XRMAJ,YRMAJ BY
C             THE RATIO OF THE RADICAL DISTANCE TO THE ELLIPSE DIVIDED
C             BY THE RADICAL DISTANCE TO (XRMAJ,YRMAJ)
                    ELSE
                      RAD = SQRT(XRMAJ*XRMAJ + YRMAJ*YRMAJ)
                      FRAC = AAXW/RAD
                      XRELL = XRMAJ * FRAC
                      YRELL = YRMAJ * FRAC
                    ENDIF

C             CALCULATE POSITION ALONG BETA
                    XRBETA = XRELL*COS(BETA) + YRELL*SIN(BETA)
                  ENDIF

C          COMPUTE AND ADD CONCENTRATION DUE TO PLUME MATERIAL BELOW HC
                  CALL WRAP(QS)
                ELSE IF( ICASE .EQ. 1 .OR. ICASE .EQ. 3) THEN
                  WRITE(IOUT,6178) NR
              ENDIF

                NLINES = NLINES + 4

C           STORE CONCENTRATION IN APPROPRIATE ARRAYS DEPENDING
C           ON IF THE SCREEN IS BEING USED AND ISIGZ

250           IF (ISCRN .GT. 0) THEN
                IF (ISIGZ .EQ. YES .AND. THTA .EQ. WDBL) THEN
                  CONC1(NR) = CONC1(NR) + C
                  SCONC1(NR,NS) = SCONC1(NR,NS) + C
                ELSE
                  CONC(NR) = CONC(NR) + C
                  SCONC(NR,NS) = SCONC(NR,NS) + C
                ENDIF
              ELSE
                CONC(NR) = CONC(NR) + C
                SCONC(NR,NS) = SCONC(NR,NS) + C
              ENDIF

C               CHECK IF PAGE IS FULL
                IF((ICASE.EQ.1 .OR. ICASE .EQ. 3) .AND. 
     $                        (NLINES .GE. MAXLIN-3)) THEN
                        CALL PAGE(YES)
                        WRITE(IOUT,6170) GSGS(ICHIQ+1)
                        NLINES = NLINES + 5
                ENDIF

C         END RECEPTOR LOOP -------------------------------------------
260       CONTINUE

C       END HILL LOOP -------------------------------------------------
270     CONTINUE

        GO TO 999

C       FLOW ALGORITHM BEYOND DESIGN CRITERIA

360     IF (IFLOW .EQ. 1) THEN
          IF (ISCRN .EQ. 0) THEN
            WRITE(IOUT,9365) KYR, KMO, KDY, KJCD, KHR
          ELSE
            WRITE(IOUT,9364) ISIM+1
          ENDIF
        ENDIF
        IF (IFLOW .EQ. 2) THEN
          IF (ISCRN .EQ. 0) THEN
            WRITE(IOUT,9366) NS,NHL,KYR,KMO,KDY,KJCD,KHR
            WRITE(0,9366) NS,NHL,KYR,KMO,KDY,KJCD,KHR
          ELSE
            WRITE(IOUT,9367)NS,NHL,ISIM+1
            WRITE(0,9367)NS,NHL,ISIM+1
          ENDIF
        ENDIF
        GO TO 390

C       WIND SPEED AT PLUME HEIGHT LESS THAN 1.0 M/S
370     IF(ICASE .EQ. 1 .OR. ICASE .EQ. 3) 
     $      WRITE(IOUT,9375) KYR, KMO, KDY, KJCD, KHR
        IPROB = 1

C       SET CONCENTRATIONS TO MISSING FOR THIS HOUR
390     DO 395 NR=1,NRECPT
          CONC(NR) = -999.
          DO 396 NS=1,NSTACK
            SCONC(NR,NS) = -999.
396       CONTINUE
395     CONTINUE

999     CONTINUE

        RETURN


6130    FORMAT(/,'          <------- SOURCE INFORMATION ------->      ',
     1    'FINAL PLUME',/,
     2    ' SOURCE   QS    TS    VS   BUOY FLUX  MOM FLUX         RISE',
     3    /,'   #    (G/S)   (K)  (M/S)  (M4/S3)    (M4/S2)         ',
     4    '(M)',/)
6135    FORMAT(I4,F9.1,F7.1,F6.2,F9.1,F10.1,5X,F10.2,
     1    //,2X,'VARIABLES AT ',T21,'HEIGHT   WDIR   ',
     2    'USCAL  UVECT  SIGV   SIGW   DTHDZ',/,2X,'PLUME HEIGHT:',
     3    T21,'  (M)    (DEG)  (M/S)  (M/S)  (M/S)  (M/S) (DEG/M)',/)
6140    FORMAT('                   ',F7.1,F7.0,F7.2,2F7.2,2F8.4,/)
6150    FORMAT(//,2X,'INFORMATION FOR HILL ',I2,': ',10A4,//,
     1  7X,'HCRIT = ',F7.1,' M;  FROUDE # ABOVE HCRIT = ',F5.2)
6155    FORMAT(//,5X,'WRAP INFORMATION:',/,7X,'DISTANCE FROM SOURCE TO',
     1  ' HILL CENTER = ',F6.1,' M;  WRAP HT = ',F6.1,' M',/,7X,
     2  'ELLIPSE AXIS LENGTHS: MAJOR = ',F7.1,' M;  MINOR = ',F7.1,
     3  ' M',/,7X,'MAJOR AXIS AZIMUTH FROM NORTH = ',F5.1,' DEG',/,
     4  7X,'DISTANCE TO PRIMARY IMPINGEMENT POINT = ',F7.1,' M',/)
6158    FORMAT(/,5X,'WARNING: FROUDE NUMBER USED IN LIFT MODEL IS ',
     1  'SIGNIFICANTLY BELOW',/,5X,'THE INTENDED RANGE OF ',
     2  'APPLICABILITY.  USE CONCENTRATIONS WITH CAUTION.',/)
6160    FORMAT(/,5X,'LIFT INFORMATION:',/,7X,'DISTANCE FROM SOURCE TO',
     1  ' HILL CENTER = ',F7.1,' M; LIFT MIDPOINT HT = ',F6.1,/,7X,
     2  'ELLIPSE AXIS LENGTHS:  MAJOR = ',F7.1,' M;MINOR = ',F7.1,' M',
     3  /,7X,'MAJOR AXIS AZIMUTH FROM NORTH = ',F5.1,' DEG',/,7X,
     4  'DISTANCE ALONG FLOW FROM SOURCE TO HILL CENTER = ',F7.1,' M',/,
     5  7X,'CROSSFLOW DISTANCE FROM SOURCE TO HILL CENTER = ',F7.1,' M',
     6  /,7X,'DISTANCE TO PRIMARY IMPINGEMENT POINT = ',F7.1,' M',/)
6170    FORMAT(/,T9,'SRC-RECP   SRC-RECP  RECEPTOR   EFF.      FLAT  ',
     1  '    HILL-INDUCED',/,
     2  '     L  DISTANCE   DISTANCE  HT ABOVE SRC-RECP   TERRAIN    ',
     3  ' EFFECTIVE     TOTAL',/,' REC / ALONG FLOW CROSS FLOW STK ',
     4  'BASE HT DIFF  SIG-Y SIG-Z  SIG-Y SIG-Z    CONC',/,
     5  '  #  W     (M)        (M)       (M)      (M)    (M)   (M)',
     6  '    (M)   (M)  (U',A1,'/M**3)')
6175    FORMAT(/,1X,I3,' LIFT N/A (RECEPTOR BELOW HC)')
6178    FORMAT(1X,I3,' WRAP N/A (PLUME ABOVE HC OR UPWIND OF HILL)')
6265    FORMAT(/' ALL RECEPTORS ON HILL ',I2,' ARE UPWIND OF SOURCE ',
     *          I2,' THIS HOUR. WIND DIR. IS ',F5.1,/)
6270    FORMAT(/' POSITION OF HILL ',I2,' IS UPWIND OR FAR TO THE SIDE',
     *          ' OF THE PLUME FROM SOURCE ',I2,/,' THIS HOUR. ',
     *          ' WIND DIRECTION IS ',F5.1,/)
8010    FORMAT(/,1X,I3,' LIFT N/A (PLUME MISSES HILL)')
8020    FORMAT(1X,I3,' WRAP N/A (PLUME MISSES HILL)')
9364    FORMAT(/' FLOW FIELD ALGORITHM SUBJECTED TO INPUT DATA BEYOND ',
     *  'ITS DESIGN CRITERIA;',/,' NO PREDICTIONS: SIMULATION = ',I10/)
9365    FORMAT(/' FLOW FIELD ALGORITHM SUBJECTED TO INPUT DATA BEYOND ',
     *  'ITS DESIGN CRITERIA;',/,' NO PREDICTIONS: YEAR = ',
     *  I2,'  MONTH = ',I2,'  DAY = ',I2,'  JCD = ',I3,'  HOUR = ',I2/)
9366    FORMAT(/' ENDLESS LOOP IN PATH; STACK ',I2,' HILL ',I2,
     *  /' NO PREDICTIONS: YEAR = ',
     *  I2,'  MONTH = ',I2,'  DAY = ',I2,'  JCD = ',I3,'  HOUR = ',I2/)
9367    FORMAT(/' ENDLESS LOOP IN PATH; STACK ',I2,' HILL ',I2,
     *  /' NO PREDICTIONS: SIMULATION = ',I10/)
9375    FORMAT(/' WIND SPEED LT 1 M/S, NO PREDICTIONS THIS HOUR',
     *  /'   YEAR=',I2,' MONTH=',I2,' DAY=',I2,' JCD=',I3,' HOUR=',I2/)


        END




