        REAL FUNCTION PENFCT(U,PTZI,VDTHDZ,XMH)
C*************************************************************************
C   FUNCTION PENFCT CALCULATES THE PENETRATION FACTOR ACCORDING TO BRIGGS
C   (1984)
C*************************************************************************
C
C     ARGUMENTS
C     PASSED: 
C          U        WIND SPEED, FROM FUNCTION GETU
C          PTZI     POTENTIAL TEMPERATURE AT ZI FROM DTHDZ
C          VDTHDZ   DEL THETA/DEL Z FROM DTHDZ
C
C*************************************************************************
        
        INCLUDE  'STACK.CMN'
C        INCLUDE  'SFCMET.CMN'

        REAL P, PTZI, S, U, VDTHDZ, XMH, ZB

        PENFCT=0.0
        IF (VDTHDZ.LE.0.0005) THEN
          VDTHDZ = 0.0005
        ENDIF
        S = (9.80616/PTZI)*VDTHDZ
        ZB = XMH - HS

        IF (FB .EQ. 0.0) THEN
          P = 0.0
        ELSE
          P = (3.9-(ZB/(FB/(U*S))**.333333))/2.6
           IF (P .LT. 0.0) P = 0.0 
           IF (P .GT. 1.0) P = 1.0 
        ENDIF

        PENFCT=P
        RETURN
        END


