      SUBROUTINE TERAX( SMAJ, SMIN, EMAJ, EMIN, RELIEF, HT,
     *                  BASE, ABMAX, AAX, BAX)
C-----------------------------------------------------------------------
C  DESCRIPTION: GIVEN A CONTOUR HEIGHT, SUBROUTINE RETURNS THE MAJOR
C               AND MINOR AXIS LENGTHS.
C
C  ARGUMENTS:
C    PASSED
C       SMAJ    REAL    SCALE LENGTH FOR MAJOR AXIS
C       SMIN    REAL    SCALE LENGTH FOR MINOR AXIS
C       EMAJ    REAL    EXPONENT FOR MAJOR AXIS
C       EMIN    REAL    EXPONENT FOR MINOR AXIS
C       RELIEF  REAL    RELIEF HEIGHT
C       HT      REAL    HEIGHT OF CONTOUR
C       BASE    REAL    HILL BASE HEIGHT
C       ABMAX   REAL    MAX VALUE OF AAX, BAX ( AAX <= BAX < ABMAX )
C                        (AXIS LENGTHS NOT ALLOWED TO EXCEED DISTANCE
C                         FROM SOURCE TO HILL CENTER)
C    RETURNED
C       AAX     REAL    MAJOR AXIS LENGTH
C       BAX     REAL    MINOR AXIS LENGTH
C
C CALLING ROUTINES: SEQMOD
C
C EXTERNAL ROUTINES: NONE
C
C INTRINSIC FUNCTIONS: NONE
C
C COMMON BLOCKS: CONST
C
C-----------------------------------------------------------------------
C
C     DEFINE ARGUMENTS
      REAL SMAJ, SMIN, EMAJ, EMIN, RELIEF, HT, BASE, ABMAX, AAX, BAX
C
C      INCLUDE   'CONST.CMN'
C
C     DEFINE LOCAL VARIABLES
      REAL HCONTR, SMALL
      DATA SMALL/0.00001/
C
C     START
      HCONTR = HT - BASE
      IF(HCONTR .LE. SMALL) THEN
         AAX=ABMAX*0.99
         BAX=ABMAX*0.99
         RETURN
      ENDIF
C
C     SEE EQN 13 IN TERRAIN PREPROCESSOR MANUAL FOR AAX, BAX
C
      AAX = SMAJ * (RELIEF/HCONTR-1.)**(1./EMAJ)
      BAX = SMIN * (RELIEF/HCONTR-1.)**(1./EMIN)
C
      IF(AAX .GT. ABMAX) AAX = ABMAX * 0.99
      IF(BAX .GT. AAX) BAX = AAX
C
      RETURN
      END
