      SUBROUTINE WFLAT(EFFSH,WP,PW,PWTOT,WHAT,GM,SWPLUS,SWMINUS,
     *           US,ZELEV,BOUNCE)
C *********************************************************************
c       THIS SUBROUTINE PROVIDES A SERIES OF WP AND PW VALUES FOR 
C       RECEPTORS ON FLAT TERRAIN.  This is done for a direct path
c       or a reflected path from the ground.  Reflections from the mixed
c       layer must be accounted for by the use of an image source.
C   
C       PASSED: ZS      PLUME HEIGHT (HPL)
C               WHAT    W-HAT = -SWBAR*WBETA*(8/PI)**0.5
C               GM      GM = 1/(SWBAR*SQR2PI)
C               SWPLUS  SWPLUS = SWBAR*(1+WBETA)
C               SWMINUS SWMINUS = SWBAR*(1-WBETA)
C               XMH     MIXING HEIGHT
C               US      SCALAR-AVERAGE WIND SPEED AT PLUME HEIGHT
C
C     RETURNED: WP      ARRAY OF WPRIME VALUES
C               PW      ARRAY OF PROBABILITIES DERIVED FROM WP VALUES
C               PWTOT   TOTAL OF ALL PWs
C
C **********************************************************************
      INCLUDE 'PARAMS.INC'
C      INCLUDE 'CONST.CMN'
C      INCLUDE 'PASVAL.CMN'
      INCLUDE 'PASL.CMN'
C      INCLUDE 'VARS.CMN'

      REAL BOUNCE(6), DISTI, EFFSH(6), GM, PW(6), PWTOT, 
     X     SWMINUS, SWPLUS, US, WHAT, WP(6), WPMWH, 
     X     ZELEV, ZR

      INTEGER I

      zr=zelev
      disti=(1./(XEPL-XSEPL))

        DO 261 I = 1,6
           WP(I) = -999.0
           PW(I) = 0.0
261     CONTINUE

C  CALCULATE THE WP VALUES FOR EACH PATH
        DO 263 I = 1,6
          IF ((I .EQ. 2 .OR. I .EQ. 4 .OR. I .EQ. 6) .AND.
     $      ZELEV .EQ. 0.0) THEN
            WP(I) = WP(I-1)
          ELSE
            WP(I) = US * (BOUNCE(I)*ZR - EFFSH(I)) * DISTI
          ENDIF
263     CONTINUE

C  RESET THE SIGN FOR PATHS HAVING AN INITIAL UPWARD TRAJECTORY
         WP(3) = -WP(3)
         WP(4) = -WP(4)

C  CALCULATE THE PROBABILITY FOR EACH PATH
        DO 264 I = 1,6
          IF (WP(I) .EQ. -999.0) THEN
            PW(I) = 0.0
          ELSE
            WPMWH = WP(I) - WHAT
            IF (WPMWH .GE. 0) THEN
              ARG = (WPMWH**2)/(2.0*SWPLUS**2)
            ELSE
              ARG = (WPMWH**2)/(2.0*SWMINUS**2)
            ENDIF
            IF (ARG .GT. 30.0) THEN
              PW(I) = 0.0
            ELSE
              PW(I) = GM * EXP(-ARG)
            ENDIF
          ENDIF
264     CONTINUE

        PWTOT = 0
        DO 280 I= 1,6
            PWTOT = PWTOT + PW(I)
280     CONTINUE

        RETURN

        END
