       SUBROUTINE WRITSCR(CONC,SCONC,IFLAG,NZI)
C ******************************************************************
C  THIS SUBROUTINE WRITES THE CONCENTRATION FILES FOR CTSCREEN.  IT
C  ALSO WRITES THE SUMRE FILE WHICH CONTAINS THE OVERALL MAXIMUM
C  CONCENTRATIONS AND REGULATORY AVERAGE CONCENTRATIONS, THE MAX 
C  CONCENTRATION FOR EACH SIMULATION AND THE METEOROLOGY ASSOCIATED
C  WITH THAT SIMULATION, AND THE MAXIMUM CONCENTRATION AT EACH RECEPTOR
C  AND THE ASSOCIATED METEOROLOGY.
C ******************************************************************

        INCLUDE 'PARAMS.INC'
        INCLUDE 'HEAD.CMN'
        INCLUDE 'HILL.CMN'
        INCLUDE 'IO.CMN'
        INCLUDE 'PARAMS.CMN'
        INCLUDE 'PROFIL.CMN'
        INCLUDE 'RECEPT.CMN'
        INCLUDE 'SCREN.CMN'
        INCLUDE 'SFCMET.CMN'
        INCLUDE 'STACKS.CMN'
        INCLUDE 'TIME.CMN'
        INCLUDE 'VARS.CMN'

        REAL  CONC(NRECPT),SCONC(MAXREC,MAXSOR),STCONC(MAXREC),
     &        STSCC(MAXREC),STHPL(MAXREC),UNCONC(MAXREC),
     &        UNSCC(MAXREC),UNHPL(MAXREC),UNPEN(MAXREC)
        INTEGER STSIM(MAXREC),UNSIM(MAXREC),STNS(MAXREC),UNNS(MAXREC),
     &          SIMNS, SMXSIM, UMXSIM, TOTSIM, PCTCOM
        CHARACTER*20 UNITS
        CHARACTER*1  UNITS2

        IF (IFLAG .EQ. 1) GO TO 700
        IF (IFLAG .EQ. 2) GO TO 500

C INITIALIZE  VALUES
        UNSTMAX = 0.0
        STABMAX = 0.0
        DO 50 NR = 1,NRECPT
           UNCONC(NR) = 0.0
           STCONC(NR) = 0.0
50      CONTINUE

C  SET CONCENTRATION UNITS
       IF (ICHIQ .EQ. 0) THEN
         UNITS = '  MICROGRAMS/M**3'
         UNITS2 = 'G'
       ELSE
         UNITS = '  MICROSECONDS/M**3'
         UNITS2 = 'S'
       END IF

C OPEN THE SCRATCH FILE FOR TEMPORARILY KEEPING TRACK OF MET DATA
       OPEN(ISCRTCH,STATUS='SCRATCH',ACCESS='DIRECT',RECL=160)

C CALCULATE THE TOTAL NUMBER OF SIMULATIONS TO BE RUN AND PRINT TO SCREEN
C NUMBER OF WD (NWD) DEPENDS ON THE WIND DIRECTION SELECTION METHOD
C NUMBER OF ZI VALUES (NZI) IS 3 * NUMBER OF HILLS
C ANY OR ALL OF THE OPTIONS FOR WIND DIRECTION SELECTION CAN BE SELECTED,
C SO TOTAL OVER ALL METHODS.  NOTE THAT THE ACTUAL NUMBER OF SIMULATIONS
C RUN MAY BE LESS THAN TOTSIM BECAUSE SOME ZI VALUES MAY GET SKIPPED
       NPSRC = 0
       TOTSIM = 0
       DO 75 NS = 1,NSTACK
         IF (ISEC(NS) .EQ. 0) NPSRC = NPSRC + 1
75     CONTINUE
       IF (NPSRC .EQ. 0 .AND. IAUTO .GT. 0) THEN
         WRITE(IOUT,760)
760      FORMAT(1X,'AUTOMATIC DETERMINATION OF WIND DIRECTION SELECTED'
     &          /,'BUT NO PRIMARY SOURCES HAVE BEEN INDICATED')
         STOP
       ENDIF
C       NZI = NHILLS * 3
       IF (IAUTO .GE. 1) THEN
         NWD = NHILLS * NPSRC
         IF (ISCRN .EQ. 1 .OR. ISCRN .EQ. 3) 
     &     TOTSIM = TOTSIM + (96 * NWD)
         IF (ISCRN .GE. 2) TOTSIM = TOTSIM + (36 * NWD * NZI)
       ENDIF
       IF (IAUTO .EQ. 2) THEN
         NWD = NWD * (NWD-1)/2
         IF (ISCRN .EQ. 1 .OR. ISCRN .EQ. 3) 
     &     TOTSIM = TOTSIM + (96 * NWD)
         IF (ISCRN .GE. 2) TOTSIM = TOTSIM + (36 * NWD * NZI)
       ENDIF
       IF (IRANGE .EQ. 1) THEN
         NWD =  INT(ABS(DELWD(WDUP,WDLOW))/WDINC) + 1
         IF (ISCRN .EQ. 1 .OR. ISCRN .EQ. 3) 
     &     TOTSIM = TOTSIM + (96 * NWD)
         IF (ISCRN .GE. 2) TOTSIM = TOTSIM + (36* NWD * NZI)
       ENDIF
       IF (IDISCR .EQ. 1) THEN
         NWD = NUMWD
         IF (ISCRN .EQ. 1 .OR. ISCRN .EQ. 3) 
     &     TOTSIM = TOTSIM + (96 * NWD)
         IF (ISCRN .GE. 2) TOTSIM = TOTSIM + (36*NWD * NZI)
       ENDIF

       WRITE(0,2010) TOTSIM
       GO TO 999

C INCREMENT THE SIMULATION NUMBER & WRITE TO SCREEN EVERY TENTH ONE
C CALCULATE PERCENT OF SIMULATIONS COMPLETED
700    ISIM = ISIM + 1
       PCTCOM = 100 * ISIM/TOTSIM
       IF (MOD(ISIM,10) .EQ. 0) WRITE(0,2000) ISIM, PCTCOM

C  FIND THE SOURCE WITH THE MAXIMUM CONTRIBUTION FOR NRMAX
        SCMAX = 0.0
        NSMAX = 0
        IF (NRMAX .GT. 0) THEN
          DO 800 NS = 1,NSTACK
            IF (SCONC(NRMAX,NS) .GT. SCMAX) THEN
              SCMAX = SCONC(NRMAX,NS)
              NSMAX = NS
            ENDIF
800       CONTINUE
        ENDIF

C  WRITE MET VARIABLE SUMMARY FOR EACH SIMULATION TO SCRATCH FILE
          IF (NRMAX .EQ. 0) THEN
            HCRIT = -999.
            HPL   = -999.
            PEN   = -.99
          ELSE
            HPL = PLMHTS(NSMAX)
            IF (EL .GT. 0) THEN
              HCRIT = HCHILL(NRHILL(NRMAX))
              PEN   = -.99
            ELSE
              HCRIT = -999.
              PEN   = PENET(NSMAX)
            ENDIF
          ENDIF
          WRITE(ISCRTCH,REC=ISIM) ISIM,THTA,WSHR(1),SVHR(1),SWHR(1),
     &       DTH,XMH,WSTAR,EL,NRMAX,CHIMAX,HCRIT,SCMAX,HPL,NSMAX,PEN

C  KEEP TRACK OF MAX STABLE AND MAX UNSTABLE CONCENTRATION FOR THE
C  RUN AND AT EACH RECEPTOR, AND THE SIMULATION ASSOCIATED WITH IT.
      
        IF (EL .LT. 0) THEN

C  KEEP TRACK OF WHICH SIMULATION GAVE MAX CONC UNSTABLE CONDITIONS
          IF (CHIMAX .GT. UNSTMAX) THEN
            UNSTMAX = CHIMAX
            UMXSIM  = ISIM
          ENDIF

C  WRITE UNCONC FILE HEADER AND CONCENTRATIONS
          IF (ICONC .EQ. 2) THEN
            WRITE(IUNOUT,61) KYR,KMO,KDY,ISIM,NRMAX,NRECPT,UNITS
            WRITE(IUNOUT,62) CONC
          ELSE IF (ICONC .EQ. 1) THEN
            WRITE(IUNOUT) KYR,KMO,KDY,ISIM,NRMAX,NRECPT,CONC
          ENDIF

C   UPDATE ARRAYS FOR MAX CONC AND SIMULATION NUMBER AT EACH RECEPTOR
          DO 100 NR = 1,NRECPT
            IF (CONC(NR) .GT. UNCONC(NR)) THEN
              UNCONC(NR) = CONC(NR)
              UNSIM(NR)  = ISIM
              UNSCC(NR) = 0.0
              DO 99 NS = 1,NSTACK
                IF (SCONC(NR,NS) .GT. UNSCC(NR)) THEN
                  UNSCC(NR) = SCONC(NR,NS)
                  UNNS(NR)  = NS
                  UNHPL(NR) = PLMHTS(NS)
                  UNPEN(NR) = PENET(NS)
                ENDIF
99            CONTINUE
            ENDIF
100       CONTINUE
        ELSE

C  UPDATE VALUES FOR STABLE CONDITIONS
          IF (CHIMAX .GT. STABMAX) THEN
            STABMAX = CHIMAX
            SMXSIM = ISIM
          ENDIF

C  WRITE STCONC FILE HEADER AND CONCENTRATIONS
          IF (ICONC .EQ. 2) THEN 
            WRITE(ISTOUT,61) KYR,KMO,KDY,ISIM,NRMAX,NRECPT,UNITS
            WRITE(ISTOUT,62) CONC
          ELSE IF (ICONC .EQ. 1) THEN
            WRITE(ISTOUT) KYR,KMO,KDY,ISIM,NRMAX,NRECPT,CONC
          ENDIF

C   UPDATE ARRAYS FOR MAX CONC AND SIMULATION NUMBER AT EACH RECEPTOR
          DO 200 NR = 1,NRECPT
            IF (CONC(NR) .GT. STCONC(NR)) THEN
              STCONC(NR) = CONC(NR)
              STSIM(NR)  = ISIM
              STSCC(NR) = 0.0
              DO 199 NS = 1,NSTACK
                IF (SCONC(NR,NS) .GT. STSCC(NR)) THEN
                  STSCC(NR) = SCONC(NR,NS)
                  STNS(NR)  = NS
                  STHPL(NR) = PLMHTS(NS)
                ENDIF
199           CONTINUE
            ENDIF
200       CONTINUE

        ENDIF
        GO TO 999

C   ALL SIMULATIONS FINISHED - WRITE OUTPUT FILES

500     SIMTOT = ISIM
        WRITE(ISUMRE,90) TITLE

C   WRITE OVERALL MAX VALUES AND ASSOCIATED METEOROLOGY TO SUMRE FILE
        IF ((ISCRN .EQ. 1 .OR. ISCRN .EQ. 3).AND.(SMXSIM .NE. 0)) THEN
          READ(ISCRTCH,REC=SMXSIM) ISIM,THTA,WS,SIGV,
     &                    SIGW,DTH,XMH,WSTAR,EL,NRSTAB,STABMAX,
     &                    HC,SIMMAX,HPL,SIMNS,PEN
          WRITE(ISUMRE,1000) 
          WRITE(ISUMRE,63)
          WRITE(ISUMRE,64) 
          WRITE(ISUMRE,70) UNITS2,UNITS2
          WRITE(ISUMRE,66)  NRSTAB, STABMAX, THTA, WS, 
     &                      SIGV, SIGW, DTH, HC, 
     &                      SIMNS, SIMMAX, HPL
        ENDIF
        IF (ISCRN .GE. 2 .AND. UMXSIM .NE. 0) THEN
          READ(ISCRTCH,REC=UMXSIM) ISIM,THTA,WS,SIGV,
     &                    SIGW,DTH,XMH,WSTAR,EL,NRUNST,UNSTMAX,
     &                    HC,SIMMAX,HPL,SIMNS,PEN
          WRITE(ISUMRE,1002)  
          WRITE(ISUMRE,69)
          WRITE(ISUMRE,65) 
          WRITE(ISUMRE,71) UNITS2,UNITS2
          WRITE(ISUMRE,72) NRUNST, UNSTMAX, THTA, WS,
     &                     XMH, WSTAR, EL, SIMNS,
     &                     SIMMAX, HPL, PEN
        ENDIF

C  WRITE MAX OVERALL AND 3-HR, 24-HOUR, AND ANNUAL VALUES TO SUMRE
        IF (STABMAX .GE. UNSTMAX) THEN
          OVERMAX = STABMAX
          NROVER = NRSTAB
        ELSE
          OVERMAX = UNSTMAX
          NROVER = NRUNST
        ENDIF
        REG3HR = OVERMAX * 0.70
        REG24HR = OVERMAX * 0.15
        REGANN =  OVERMAX * 0.03
        WRITE(ISUMRE,81)
        WRITE(ISUMRE,82) UNITS2,UNITS2,UNITS2,UNITS2
        WRITE(ISUMRE,83) NROVER,OVERMAX,REG3HR,REG24HR,REGANN

C       WRITE THE RECEPTOR INFORMATION TO THE SUMRE FILE
505     IF (ISCRN .EQ. 1 .OR. ISCRN .EQ. 3) THEN
          WRITE(ISUMRE,67)
          WRITE(ISUMRE,63)
          WRITE(ISUMRE,64) 
          WRITE(ISUMRE,70) UNITS2,UNITS2
          DO 510 NR = 1,NRECPT
            IREC = STSIM(NR)
            IF (IREC .NE. 0) THEN
              READ(ISCRTCH,REC=IREC) ISIM,THTA,WS,SIGV,
     &                    SIGW,DTH,XMH,WSTAR,EL,NRMAX,CHIMAX,
     &                    HC,SIMMAX,HPL,SIMNS,PEN

              WRITE (ISUMRE,66) NR,STCONC(NR),THTA,WS,SIGV,SIGW,DTH,
     &                        HC,STNS(NR),STSCC(NR),STHPL(NR)
            ELSE
              WRITE(ISUMRE,76)
            ENDIF
510       CONTINUE
        ENDIF

        IF (ISCRN .GE. 2) THEN 
          WRITE(ISUMRE,68)
          WRITE(ISUMRE,69)
          WRITE(ISUMRE,65) 
          WRITE(ISUMRE,71) UNITS2,UNITS2
          DO 610 NR = 1,NRECPT
            IREC = UNSIM(NR)
            IF (IREC .NE. 0) THEN
              READ(ISCRTCH,REC=IREC) ISIM,THTA,WS,SIGV,
     &                    SIGW,DTH,XMH,WSTAR,EL,NRMAX,CHIMAX,
     &                    HC,SIMMAX,HPL,SIMNS,PEN
              WRITE (ISUMRE,72) NR,UNCONC(NR),THTA,WS,XMH,WSTAR,EL,
     &                        UNNS(NR),UNSCC(NR),UNHPL(NR),UNPEN(NR)
            ELSE
              WRITE(ISUMRE,76)
            ENDIF
610       CONTINUE        
        ENDIF

C  WRITE THE FINAL VERSION OF THE METEORLOGY FILE
C  WRITE TITLE OF RUN TO FILE
        WRITE(IMET,90) TITLE

C  WRITE HEADER FOR STABLE HOURS (IF NEEDED)
        IF (ISCRN .EQ. 1 .OR. ISCRN .EQ. 3) THEN
          WRITE(IMET,1000)
          WRITE(IMET,91) UNITS2,UNITS2
        ENDIF

        IHEAD = 1
        DO 810 NSIM = 1,SIMTOT
            READ(ISCRTCH,REC=NSIM) ISIM,THTA,WS,SIGV,
     &                    SIGW,DTH,XMH,WSTAR,EL,NRMAX,CHIMAX,
     &                    HC,SIMMAX,HPL,SIMNS,PEN
            IF (EL .GT. 0) THEN
              WRITE(IMET,93) ISIM,THTA,WS,SIGV,SIGW,DTH,NRMAX,CHIMAX,
     &                       HC,SIMNS,SIMMAX,HPL
            ELSE
              IF (IHEAD .GT. 0) THEN
C  WRITE HEADER FOR UNSTABLE HOURS
                WRITE(IMET,1002)
                WRITE(IMET,92) UNITS2,UNITS2
                IHEAD = 0
              ENDIF
              WRITE(IMET,94) ISIM,THTA,WS,XMH,WSTAR,EL,NRMAX,CHIMAX,
     &                       SIMNS,SIMMAX,HPL,PEN
            ENDIF
810     CONTINUE

999     RETURN

2000    FORMAT('  SIMULATION = ',I8,2X,'(',I5,'% COMPLETE)')
2010    FORMAT(///'  MAXIMUM NUMBER OF SIMULATIONS EXPECTED = ',I8)
61      FORMAT (6I5,A20)
62      FORMAT (8E10.3)
63      FORMAT (57X,'<--- PEAK SOURCE -->')
64      FORMAT (1X,' REC',2X,'  CONC  ',2X,'  WD ',2X, '  WS',
     &         2X,'SIGV',2X,'SIGW',2X,'DTHDZ',2X,' HCRIT',2X,
     &         'NS',2X,'SRC CTRB',2X,'  HPL ')
70      FORMAT (1X,'  # ',2X,' U',A1,'/M**3',2X,' DEG ',2X,
     &         ' M/S',2X,' M/S',2X,' M/S',2X,' K/M ',2x,
     &         '   M  ',6X,' U',A1,'/M**3',2X,'   M  ')
66      FORMAT (1X,I4,2X,F9.2,2X,F5.1,2X,F4.1,2X,F4.2,2X,
     &          F4.2,2X,F5.3,2X,F6.1,2X,I2,2X,F9.2,2X,F6.1)
69      FORMAT (51X,'<------ PEAK SOURCE ----->')
65      FORMAT (1X,' REC',2X,'  CONC  ',2X,'  WD ',2X, '  WS',
     &          2X,'  ZI  ',2X,'  W*',2X,'  L  ',2X,
     &          'NS',2X,'SRC CTRB',2X,'  HPL ',2X,' PEN')
71      FORMAT (1X,'  # ',2X,' U',A1,'/M**3',2X,' DEG ',2X,
     &         ' M/S',2X,'   M ',2X,' M/S',2X,'  M  ',
     &         6X,' U',A1,'/M**3',2X,'   M  ')
72      FORMAT (1X,I4,2X,F9.2,2X,F5.1,2X,F4.1,2X,F6.1,2X,
     &          F4.2,2X,F5.1,2X,I2,2X,F9.2,2X,F6.1,2X,F4.2)
76      FORMAT (1X,I4,2X,'********',2X,'*****',2X,'****',
     &         2X,'****',2X,'*****',2X,'**',2X,'********',
     &         2X,'******',2X,'****')
81      FORMAT (//,1X,'SUMMARY FOR ALL HOURS',/)
80      FORMAT (A20,5X,I4)
82      FORMAT (1X,' REC ',2X,'   CONC ',5X,'    3HR  ',5X,
     &          '  24HR   ',5X,' ANNUAL ',/,
     &          1X,'  #   ',2X,' U',A1,'/M**3',
     &          5X,' U',A1,'/M**3',5X,' U',A1,'/M**3',
     &          5X,' U',A1,'/M**3')
83      FORMAT (1X,I5,2X,F9.2,5X,F8.2,5X,F8.2,5X,F8.2)
67      FORMAT (//,1X,'RECEPTOR SUMMARY FOR STABLE HOURS',/)
68      FORMAT (//,1X,'RECEPTOR SUMMARY FOR UNSTABLE HOURS',/)
1000    FORMAT (1X,'SUMMARY FOR ALL STABLE HOURS',/)
1002    FORMAT (//,1X,'SUMMARY FOR ALL UNSTABLE HOURS',/)
90      FORMAT(20A4,/)
91      FORMAT(38X,'<- PEAK REC ->',8X,'<-- PEAK SOURCE --->',/,
     &         1X,' SIM',2X,'  WD ',2X,'  WS',2X,'SIGV',2X,'SIGW',
     &         2X,'DTHDZ',2X,' NR',2X,'  CONC  ',2X,' HCRIT',2X,
     &         'NS',1X,'SRC CTRB',2X,'  HPL ',/,
     &         1X,'  # ',2X,' DEG ',2X,' M/S',2X,' M/S',2X,' M/S',
     &         2X,' K/M ',7X,' U',A1,'/M**3',2X,'   M  ',5X,
     &         ' U',A1,'/M**3',2X,'   M  ')
92      FORMAT(40X,'<- PEAK REC ->',1X,'<----- PEAK SOURCE ----->',/,
     &         1X,' SIM',2X,'  WD ',2X,'  WS',2X,'  ZI  ',2X,'  W*',
     &         2X,'  L  ',2X,' NR',2X,'  CONC  ',2X,
     &         'NS',2X,'SRC CTRB',2X,'  HPL ',1X,' PEN',/,
     &         1X,'  # ',2X,' DEG ',2X,' M/S',2X,'   M  ',
     &         2X,' M/S',2X,'  M  ',6X,' U',A1,'/M**3',7X,
     &         ' U',A1,'/M**3',2X,'   M  ')
93      FORMAT(1X,I4,2X,F5.1,2X,F4.1,2X,F4.2,2X,F4.2,2X,F5.3,2X,
     &         I3,1X,F9.2,2X,F6.1,2X,I2,1X,F9.2,2X,F6.1)
94      FORMAT(1X,I4,2X,F5.1,2X,F4.1,2X,F6.1,2X,F4.2,2X,F5.1,2X,
     &         I3,1X,F9.2,2X,I2,2X,F9.2,2X,F6.1,1X,F4.2)
        END

