        REAL FUNCTION XINTRP( X1, X2, X, Y1, Y2 )
C-----------------------------------------------------------------------
C FUNCTION: XINTRP
C
C PURPOSE: THIS FUNCTION LINEARLY INTERPOLATES BETWEEN TWO POINTS
C               (Y1,Y2) GIVEN THREE OTHER POINTS (X1,X2,X) WHERE
C               X1 AND X2 ARE ENDPOINTS AND X IS BETWEEN X1 AND X2
C
C ASSUMPTIONS: X IS BETWEEN X1 AND X2
C
C REMARKS: IF X1 = X2 THEN THE MIDPOINT BETWEEN Y1 AND Y2 IS RETURNED
C
C ARGUMENTS:
C  PASSED:
C       X1,X2   REAL    ENDPOINTS OF FIRST LINE
C       X       REAL    POINT BETWEEN X1 AND X2
C       Y1,Y2   REAL    ENDPOINTS OF LINE TO BE INTERPOLATED
C
C FUNCTION VALUE:
C       XINTER  REAL    INTERPOLATED VALUE BETWEEN Y1 AND Y2
C
C CALLING ROUTINES: SEQMOD
C
C EXTERNAL ROUTINES: NONE
C
C INTRINSIC FUNCTIONS: NONE
C
C COMMON BLOCKS: NONE
C
C-----------------------------------------------------------------------
C
C       DEFINE ARGUMENTS
        REAL X1, X2, X, Y1, Y2
C       DEFINE LOCAL VARIABLES
        REAL DX
C       START
        DX = X2 - X1
        IF( DX .NE. 0.0 ) THEN
                XINTRP = Y1 + (Y2-Y1) * (X-X1)/DX
         ELSE
                XINTRP = (Y1+Y2) * 0.5
        ENDIF
        RETURN
        END
