*         system: tscreen
*   program name: avetime.prg
*original author: kevin stroupe, pes
*modifications by: roger brode, pes
*   modified to correct the confidence interval for annual averages
*   from "+/- 0.2" to "+/- 0.02".  April 1, 1994

SET TALK OFF
do_ave = .F.
*IPColor = 'W+/BG'
*SLColor = 'GR+/B,W+/BG,W+/B,W+/B,W+/B,N/W,GR+/B,W/N,W+/B'
DEFINE WINDOW surround FROM 0,0 TO 24,79 COLOR &IPColor NONE
DEFINE WINDOW avetime FROM 6,20 TO 21,59 SHADOW TITLE ' Averaging Time ' COLOR &PopColor
ACTIVATE WINDOW surround
ACTIVATE WINDOW avetime
@ 0,0 SAY "  The default averaging time is 1 hour. " COLOR &ELColor
@ 1,0 SAY "   select one or more from below. . .   " COLOR &ELColor
@ 2,0 SAY "  " COLOR W+/B && &ELColor
@ 9,0 SAY "  " COLOR W+/B && &ELColor
@ 10,0 SAY "             <>Up  <>Down     " COLOR &ELColor
@ 11,0 SAY "    <Enter>/<Space> Mark/Unmark Time    " COLOR &ELColor
@ 12,0 SAY "        <F5> Select Marked Times        " COLOR &ELColor
@ 13,0 SAY "      <Esc> Abort Without Selection     " COLOR &ELColor

DIMENSION men(6)
men(1) = "             15 Minutes               "
men(2) = "             30 Minutes               "
men(3) = "              3 Hours                 "
men(4) = "              8 Hours                 "
men(5) = "             24 Hours                 "
men(6) = "             Annual                   "

ON KEY LABEL SPACEBAR KEYBOARD CHR(13)
ON KEY LABEL F5 DO doave
SET COLOR TO W+/B,N/W,N/W,N/W,N/W,N/W

ave_hold = 1
DO WHILE .T.
   FOR i = 1 TO 6
      @ 2+i,0 PROMPT men(i)
   NEXT i

   MENU TO ave_hold
   
   DO CASE
      CASE LASTKEY() = 27
         do_ave = .F.
         EXIT
      CASE do_ave = .T.
         EXIT
   ENDCASE
   IF '*'$men(ave_hold)      
      men(ave_hold) = SPACE(12) + RIGHT(men(ave_hold),26)
   ELSE
      men(ave_hold) = SPACE(11) + '*' + RIGHT(men(ave_hold),26) 
   ENDIF
ENDDO
     
ON KEY LABEL SPACEBAR
ON KEY LABEL F5 =1 
RELEASE WINDOW avetime

IF .NOT. do_ave
   RELEASE WINDOW surround
   RETURN
ENDIF

ifp = FOPEN('graph.fil')
line = FGETS(ifp)
DO WHILE !FEOF(ifp)
*   line_hold = line
   line = FGETS(ifp)
ENDDO
=FCLOSE(ifp)


*OutputNum = VAL(line_hold)
OutputNum = VAL(line)

SelectedTime = .F.
TimeCounter = 0
ifp = FOPEN("screen.out",2)
*DO WHILE .NOT. FEOF(ifp)
*   line = FGET(ifp)
*ENDDO


=FSEEK(ifp,-1,2)

FOR i = 1 TO 6
   IF '*'$men(i)
      bytes = FPUTS(ifp,"")
      bytes = FPUTS(ifp,"")
      bytes = FPUTS(ifp,"**************************************")
      bytes = FPUTS(ifp,"*** USER SPECIFIED AVERAGING TIMES ***")
      bytes = FPUTS(ifp,"**************************************")
      bytes = FPUTS(ifp,"")
      EXIT
   ENDIF
NEXT i

FOR i = 1 to 6
   IF '*'$men(i) 
      SelectedTime = .T.
      DO CASE 
         CASE i = 1
            num = OutputNum * (60/15)^.2
            ErrorStr = " "
            TimeStr = "15 MIN"        
         CASE i = 2
            num = OutputNum
            ErrorStr = " "
            TimeStr = "30 MIN"
         CASE i = 3
            num = OutputNum * .9
            ErrorStr = " (+/- "
            ErrorNum = OutputNum * .1
            TimeStr = "3 HR"
         CASE i = 4
            num = OutputNum * .7
            ErrorStr = " (+/- "
            ErrorNum = OutputNum * .2
            TimeStr = "8 HR"
         CASE i = 5
            num = OutputNum * .4
            ErrorStr = " (+/- "
            ErrorNum = OutputNum * .2
            TimeStr = "24 HR"
         CASE i = 6
            num = OutputNum * .08
            ErrorStr = " (+/- "
            ErrorNum = OutputNum * .02
            TimeStr = "ANNUAL"      
      ENDCASE
*      IF i < 3 
*         st = "ESTIMATED MAXIMUM CONCENTRATION FOR " + TimeStr + " AVERAGING TIME = " + ALLTRIM(STR(num,20,4))
*      ELSE 
*         st = "ESTIMATED MAXIMUM CONCENTRATION FOR " + TimeStr + " AVERAGING TIME = " + ALLTRIM(STR(num,20,4)) + ErrorStr + ALLTRIM(STR(ErrorNum,20,4)) + ")"   
*      ENDIF

      IF i < 3 
         st1 = "ESTIMATED MAXIMUM CONCENTRATION FOR " + TimeStr + " AVERAGING TIME: "&& = " + ALLTRIM(convert(num))
         st2 = ALLTRIM(convert(num)) + ' UG/M**3'
         IF PpmYN = 'Y'
            numppm = num * (.0245/VAL(Mw))
            st2 = st2 +'   '+ALLTRIM(convert(numppm)) + ' PPM'
         ENDIF   
      ELSE 
         st1 = "ESTIMATED MAXIMUM CONCENTRATION FOR " + TimeStr + " AVERAGING TIME: " &&+ ALLTRIM(STR(num,20,4)) + ErrorStr + ALLTRIM(STR(ErrorNum,20,4)) + ")"   
         st2 = ALLTRIM(convert(num)) + ErrorStr + ALLTRIM(convert(ErrorNum)) + ")"   + ' UG/M**3'
         IF PpmYN = 'Y'
            numppm = num * (.0245/VAL(Mw))
            PPMErrorNum = ErrorNum * (.0245/VAL(Mw))
            st2 = st2 +'   '+ ALLTRIM(convert(numppm)) + ErrorStr + ALLTRIM(convert(PPMErrorNum)) + ")"   + ' PPM'           
         ENDIF   
      ENDIF
      bytes = FPUTS(ifp,st1)
      bytes = FPUTS(ifp,st2)
      bytes = FPUTS(ifp," ") 
      TimeCounter = TimeCounter + 1
   ENDIF
NEXT i
= FCLOSE(ifp)

IF SelectedTime THEN
   DEFINE WINDOW msg FROM 9,12 TO 16,71 SHADOW COLOR SCHEME 1
   ACTIVATE WINDOW msg
   IF (TimeCounter > 1) 
      st= "Maximum concentrations for the new averaging times"
   ELSE
      st= "Maximum concentration for the new averaging time"
   ENDIF
   @ 1,0 SAY PADC(st,59)
   st = " will appear at the end of the output file."
   @ 3,0 SAY PADC(st,59) 
   WAIT
   RELEASE WINDOW msg
ENDIF 


RELEASE WINDOW surround
RELEASE men
RETURN


PROCEDURE doave
ON KEY LABEL F5 1
KEYBOARD CHR(23)
do_ave = .T.
RETURN
