*         system: tscreen
*   program name: graf.prg
*original author: kevin stroupe, pes
*  original data: 6/26/1991
*        purpose: display menu for selection of output device for graph
*  update author:
* update purpose:
*        comment:
*    called from: viewrpt.prg
*         calles: graph.exe


SET COLOR OF SCHEME 2 TO &GrfPopClr
IF review 
   DO Split_File
*   COPY FILE &grffile TO GRAPH.FIL
   SET COLOR TO W+/BG 
   CLEAR 
   SET COLOR OF SCHEME 1 TO &WindColor
   SET COLOR OF SCHEME 2 TO &PopColor
ENDIF

IF .NOT. FILE('graph.exe')
   DEFINE WINDOW msg FROM 9,10 TO 15,70 SHADOW COLOR &MesColor
   ACTIVATE WINDOW msg
   @ 1,0 SAY PADC('GRAPH.EXE must be in current directory to plot graph.',60)
   WAIT
   RELEASE WINDOW msg
   SET COLOR OF SCHEME 2 TO &PopColor
   RETURN
ENDIF

DEFINE WINDOW surrnd FROM 0,0 TO 24,79 COLOR &IPColor NONE
ACTIVATE WINDOW surrnd


DIMENSION conc(77)
DIMENSION dst(77)

*+++++++++++++++++++++++++++ Eliminate Points Before Fenceline ++++++++++++++++

ifp = FOPEN('GRAPH.FIL')
title = FGETS(ifp)
NumDist = FGETS(ifp)
fence = FGETS(ifp)
MaxConc = FGETS(ifp)
DistToMax = FGETS(ifp)
FenDistCntr = 0

num = VAL(NumDist)
FOR i = 1 TO num
   conc(i) = FGETS(ifp)
   dst(i) = FGETS(ifp)
   IF VAL(dst(i)) < VAL(fence)
      FenDistCntr = FenDistCntr + 1
   ENDIF
NEXT i
=FCLOSE(ifp)

NumDistOld = VAL(NumDist)
NumDist = STR(VAL(NumDist) - FenDistCntr)
ifp = FCREATE('temp.grf')
bytes = FPUTS(ifp,LEFT(ALLTRIM(title),40))
bytes = FPUTS(ifp,ALLTRIM(NumDist))
bytes = FPUTS(ifp,ALLTRIM(fence))
bytes = FPUTS(ifp,ALLTRIM(MaxConc))
bytes = FPUTS(ifp,ALLTRIM(DistToMax))
FOR i = FenDistCntr + 1 TO NumDistOld
   bytes = FPUTS(ifp,ALLTRIM(conc(i)))
   bytes = FPUTS(ifp,ALLTRIM(dst(i)))
NEXT i
=FCLOSE(ifp)

RELEASE conc
RELEASE dst
COPY FILE 'temp.grf' TO 'GRAPH.FIL'
DELETE FILE 'temp.grf'


*+++++++++++++++++++++++++ Get Maximum Distance +++++++++++++++
dstance = ''
DO GetDist WITH dstance

*+++++++++++++++++++++++++++ Get Output Destination +++++++++++
*DEFINE WINDOW grfmen FROM 2,22 TO 21,58 COLOR &SelColor ;
* TITLE ' Graphics - Main Menu ' SHADOW
DEFINE WINDOW grfmen FROM 2,19 TO 21,59 COLOR &SelColor ;
 TITLE ' Graphics - Main Menu ' SHADOW
SET COLOR OF SCHEME 1 TO &WindColor
SET COLOR OF SCHEME 2 TO &PopColor
graph_card = LEFT(SYS(2006),1)

IF .NOT. (graph_card$'HVCE')
   no_card = .T.
ELSE 
   no_card = .F.
ENDIF

DO WHILE .T.
   ACTIVATE WINDOW grfmen 
   @ 16,1 SAY PADC('',37,'') COLOR W+/B
   @ 17,0 SAY PADC('<Esc> Exit Graphics',38)
   IF no_card
      @ 0,2   PROMPT '\Screen                             '
   ELSE
      @ 0,2  PROMPT '\<Screen                             '   
   ENDIF
   @ 1,2  PROMPT '\<EPSON FX, MX  - Draft Quality      '
   @ 2,2  PROMPT 'E\<PSON FX, MX  - High Quality       '  
   @ 3,2  PROMPT 'EPSON \<LQ      - Draft Quality      '      
   @ 4,2  PROMPT 'EPSON L\<Q      - High Quality       '      
   @ 5,2  PROMPT '\<NEC Pinwriter - Draft Quality      '      
   @ 6,2  PROMPT 'NE\<C Pinwriter - High Quality       '      
   @ 7,2  PROMPT '\<OKIDATA       - Draft Quality      '      
   @ 8,2  PROMPT 'O\<KIDATA       - High Quality       '      
   @ 9,2  PROMPT 'HP Laser\<Jet/DeskJet - Draft Quality'   
   @ 10,2 PROMPT '\<HP LaserJet/DeskJet - High Quality '      
   @ 11,2 PROMPT 'He\<wlett-Packard plotter            '      
   @ 12,2 PROMPT 'Houston \<Instruments plotter        '      
   @ 13,2 PROMPT 'Change \<Distance for Graph          '      
   @ 14,2 PROMPT 'Save Graph to \<File                 '     
   MENU TO choice
   IF LASTKEY() = 27
      EXIT
   ENDIF
   DO CASE
      CASE choice = 1                     && screen
         dosdev = 0         && con:
         DO CASE
            CASE graph_card = 'H'
               grafdev = 4       && hgc1
            CASE graph_card = 'C'
               grafdev = 0       && cga3
            CASE graph_card = 'E'
               grafdev = 1       && ega4
            CASE graph_card = 'V'
               grafdev = 3       && vga2
         ENDCASE
      CASE choice >1 .AND. choice <= 11   && printer
         dosdev = 1         && lpt1:
         DO CASE 
            CASE choice = 2
               grafdev = 5   && esp1
            CASE choice = 3
               grafdev = 6   && esp2
            CASE choice = 4
               grafdev = 7   && esplq1
            CASE choice = 5
               grafdev = 8   && esplq2
            CASE choice = 6
               grafdev = 9   && necpw1
            CASE choice = 7
               grafdev = 10  && necpw2
            CASE choice = 8
               grafdev = 11  && oki1
            CASE choice = 9
               grafdev = 12  && oki2
            CASE choice = 10
               grafdev = 13  && hplj1
            CASE choice = 11
               grafdev = 14  && hplj3            
         ENDCASE
      CASE choice > 11 .AND. choice <= 13 && plotter
         dosdev = 2         && com1:                                
         DO CASE 
            CASE choice = 12
               grafdev = 15   && hpgl1
            CASE choice = 13
               grafdev = 16   && dmpl1
         ENDCASE      
      CASE choice = 14
         DEACTIVATE WINDOW grfmen
         DO GetDist WITH dstance
         LOOP
      CASE choice = 15
         DEACTIVATE WINDOW grfmen
         DO SavGrf
         LOOP
   ENDCASE

   ifp = FCREATE('devices')
   bytes = FPUTS(ifp,ALLTRIM(STR(grafdev)))
   bytes = FPUTS(ifp,ALLTRIM(STR(dosdev)))
   bytes = FPUTS(ifp,dstance)
   DO CASE
      CASE model = 'Puff'
         bytes = FPUTS(ifp,'1')
      CASE model = 'ScrnA' .OR.  model = 'ScrnF' .OR.  model = 'ScrnP' 
         bytes = FPUTS(ifp,'2')
*      CASE model = 'ScrnA2'
*         bytes = FPUTS(ifp,'2')
      CASE model = 'RVD'
         bytes = FPUTS(ifp,'3')
   ENDCASE

   =FCLOSE(ifp)

   !/0 graph
*   !/0 graphbw
   DELETE FILE devices
ENDDO

RELEASE WINDOW grfmen
RELEASE WINDOW surrnd
IF review 
   DO clrmenu WITH 'menu'
   IF model = 'ScrnP' .OR. model = 'ScrnF'
      DELETE FILE 'htdist.fil'
   ENDIF
   DELETE FILE 'graph.fil'
ENDIF
SET COLOR OF SCHEME 2 TO &PopColor
RETURN

*************************** Get Distance ******************************
PROCEDURE GetDist
PARAMETERS dstance


IF model = 'ScrnP' .OR. model = 'ScrnF' 
   endrow = 17
ELSE
   endrow = 15
ENDIF   
DEFINE WINDOW entrywind FROM 9,15 TO endrow,65 COLOR &SelColor SHADOW ;
 TITLE ' Graphics - Distance '

ifp = FOPEN('GRAPH.FIL')
holder = FGETS(ifp)
NumDist = FGETS(ifp)
fence = FGETS(ifp)
holder = FGETS(ifp)
holder = FGETS(ifp)

FenDistCntr = 0

num = VAL(NumDist)

FOR i = 1 TO num
   holder = FGETS(ifp)
   distance = FGETS(ifp)
NEXT i
=FCLOSE(ifp)

MaxDist = ALLTRIM(STR(VAL(distance)/1000,5,2))

dstance = '    '
ACTIVATE WINDOW entrywind
IF model = 'ScrnP' .OR. model = 'ScrnF' 
   @ 3,1 SAY PADC('Graph is for Simple terrain only.',48) COLOR W+/B
   @ 5,1 SAY PADC('',47,'') COLOR W+/B
   @ 6,0 SAY PADC('<Esc> Use '+ALLTRIM(MaxDist)+ ' Km',50) 
ELSE
   @ 3,1 SAY PADC('',47,'') COLOR W+/B
   @ 4,0 SAY PADC('<Esc> Use '+ALLTRIM(MaxDist)+ ' Km',50)    
ENDIF   
  
@ 1,0 SAY PADC('Enter Maximum Distance for Graph ->      Km',50) COLOR &HLColor
@ 1,39 FILL TO 1,42 COLOR &IPColor
@ 1,39 GET dstance VALID ChkDist(dstance) COLOR &IPColor
READ
RELEASE WINDOW entrywind

IF LASTKEY() = 27
   dstance = MaxDist
ENDIF
*IF VAL(dstance) < 1 
*   dstance = '1'
*ENDIF
IF VAL(dstance) <> INT(VAL(dstance)) 
*   dstance = STR(INT(VAL(dstance) +.5))
   dstance = STR(VAL(dstance),5,2)
ENDIF
RETURN


***************************** Save Graph ****************************
PROCEDURE SavGrf

grfname = SPACE(8)
DEFINE WINDOW question FROM 8,6 TO 14,73 SHADOW COLOR &SelColor;
 TITLE ' Graphics - Save '
ACTIVATE WINDOW question 
@ 1,53 FILL TO 1,61 COLOR &IPColor
@ 3,1 SAY PADC('',64,'') COLOR W+/B
@ 4, 0 SAY PADC('<Esc> Exit/ No Save',67)
@ 1,1 SAY 'Enter a unique file name for this graphic output ->         .GRF' ;
 COLOR &HLColor
@ 1,53 GET grfname PICTURE '@! NNNNNNNN'  VALID ChkGrfN(grfname) COLOR &IPColor
READ
RELEASE WINDOW question                  
IF LASTKEY() = 27 
   RETURN   
ENDIF
grfname = ALLTRIM(grfname)+'.GRF'

handle = FCREATE('temp')
bytes = FPUTS(handle,model)
=FCLOSE(handle)
line_command = 'copy temp + GRAPH.FIL '+ grfname +' > nul'
!/0 &line_command

DELETE FILE 'temp'
IF model = 'ScrnP' .OR. model = 'ScrnF'
   handle = FOPEN(grfname,2)   
   =FSEEK(handle,-1,2)   
   bytes = FPUTS(handle,'*****')
   =FCLOSE(handle)
   line_command = 'copy '+ grfname +'+ htdist.fil '+ grfname+' > nul'
   !/0 &line_command 
ENDIF

*COPY FILE 'GRAPH.FIL' TO &grfname

RETURN

***************************** Split_File *******************************
PROCEDURE Split_File

handle1 = FOPEN(grffile)
handle2 = FCREATE('GRAPH.FIL')
model = ALLTRIM(FGETS(handle1))

IF model = 'ScrnP' .OR. model = 'ScrnF'
    handle3 = FCREATE('HTDIST.FIL')
	line = FGETS(handle1)
	DO WHILE ALLTRIM(line) <> '*****'
	   = FPUTS(handle2,line)
	   line = FGETS(handle1)
	ENDDO
	=FCLOSE(handle2)
	line = FGETS(handle1)
	DO WHILE !FEOF(handle1)
	   = FPUTS(handle3,line)
	   line = FGETS(handle1)
	ENDDO
	=FCLOSE(handle1)
	=FCLOSE(handle3)
ELSE
	line = FGETS(handle1)
	DO WHILE !FEOF(handle1)
	   = FPUTS(handle2,line)
	   line = FGETS(handle1)
	ENDDO
	=FCLOSE(handle1)
	=FCLOSE(handle2)
ENDIF
RETURN
