      DIMENSION HLID(4), SPD(6), XDIS(12), XR(100), RR(100), ZR(100), CH
     1IM(12), AVGT(5)    
      CHARACTER*3 YAN(2)
      CHARACTER*79 TITLE
      DATA YAN /'YES',' NO'/
      DATA AVGT /60.,300.,900.,3600.,10800./
      DATA XDIS /.01,.03,.05,.07,.1,.5,1.,3.,5.,7.,10.,30./ 
      DATA HLID /500.,1000.,2000.,4000./
      DATA SPD /1.,3.,3.,10.,1.,3./ 
      OPEN (5,FILE='IPUF.DAT')
      OPEN (6,FILE='PUFF.OUT')
C PES ADDED CODE BEGINS
      OPEN (7,FILE='GRAPH.FIL',STATUS='UNKNOWN')
      OPEN (8,FILE='ERROR.OUT')
C      WRITE(6,*) CHAR(15)
C     READ TITLE
      READ (5,7) TITLE
7     FORMAT (A79)
C PES ADDED CODE ENDS
10    READ (5,*) KTL
      IF (KTL.GE.100) GO TO 320 
C   
C         KTL=1  NEW PROBLEM READ ALL INPUT DATA.   
C         KTL=2  CHANGE THE OPTIONS ONLY.   
C         KTL=3  CHANGE OPTIONS AND SOURCE DATA.
C         KTL=4  CHANGE OPTIONS AND METEOROLOGY.
C         KTL=5  CHANGE OPTIONS AND LOCATIONS OF CONCENTRATION  
C                ESTIMATES. 
C         KTL=6  CHANGE OPTIONS, METEOROLOGY, AND LOCATIONS OF  
C                CONCENTRATION ESTIMATES.   
C   
      READ (5,*) IOUT1,IOUT2,IOUT3,IOUT4
C   
C         IOUT1,IOUT2, AND IOUT3 ARE OUTPUT OPTIONS. A VALUE OF 1   
C         INDICATES THE OPTION WILL BE EXECUTED.
C   
C         IOUT1=1  TABLE OF CONCENTRATIONS FOR DIFFERENT STABILITY  
C                   CLASSES, SAMPLING TIMES, AND DOWNWIND DISTANCES.
C         IOUT2=1  CONCENTRATION ESTIMATES FOR THE GIVEN INPUT DATA ONLY
C         IOUT3=1  A CRITICAL CONCENTRATION MUST BE INPUT. THE PROGRAM  
C                   WILL COMPUTE DISTANCE TO CRITICAL CONCENTRATION.
C         IOUT4=1  MAXIMUM CONCENTRATION VERSUS DISTANCE
C   
      GO TO (20,50,20,30,40,30), KTL
C       READ SOURCE CARD
20    READ (5,*) Q,H,SYOP,SZOP
C   
C    Q         SOURCE STRENGTH                         (G)  
C    H         EFFECTIVE SOURCE HEIGHT                 (M)  
C    SYOP      INITIAL SIGMA R                         (M)  
C    SZOP      INITIAL SIGMA Z                         (M)  
C   
      GO TO (30,50,50,30,40,30), KTL
C       READ METEOROLOGY CARD   
30    READ (5,*) U,HL,AVT,KST
C   
C    U         WIND SPEED                              (M/SEC)  
C    HL        MIXING HEIGHT                           (M)  
C    AVT       SAMPLING TIME FOR CONCENTRATION  
C              ESTIMATES                               (SEC)
C    KST       STABILITY CLASS     1-3  
C   
      GO TO (40,50,50,50,40,40), KTL
C       READ DOWNWIND DISTANCE, RADIAL DISTANCE FROM PUFF CENTER
C       AND HEIGHT  
40    READ (5,*) NREC,(XR(I),RR(I),ZR(I),I=1,NREC)
C   
C    NREC      NUMBER OF LOCATIONS FOR WHICH CONCENTRATION  
C              ESTIMATES ARE MADE   
C    XR        DISTANCE DOWNWIND FROM RELEASE POINT    (KM) 
C    RR        RADIAL DISTANCE FROM PUFF CENTER        (M)  
C    ZR        HEIGHT ABOVE GROUND                     (M)  
C   
50    IF (IOUT3.EQ.1) READ (5,*) XCHI 
C   
C    XCHI      CRITICAL CONCENTRATION                  (G/M**3) 
C
      READ (5,*) IPLOTAV
      IF(IOUT4.EQ.1) READ (5,*) XMIN
      IF(XMIN.LT.0.01) XMIN=.01
C    XMIN      MINIMUM DISTANCE FOR CONCENTRATION CALCULATIONS (KM)
C              MIMIMUM VALUE FOR XMIN IS .01 KM
C
      IF (IOUT1.NE.1) IOUT1=2   
      IF (IOUT2.NE.1) IOUT2=2   
      IF (IOUT3.NE.1) IOUT3=2   
      IF (IOUT4.NE.1) IOUT4=2
C      WRITE (6,340) YAN(IOUT1),YAN(IOUT2),YAN(IOUT3),YAN(IOUT4)
C      WRITE (6,350) Q,H,SYOP,SZOP
       WRITE (6,8) TITLE
8      FORMAT (/,' ',A79,/)
       WRITE (7,9) TITLE
9      FORMAT (A79)
C PES ADDED CODE BEGINS
      WRITE (6,11) Q,H,SYOP,SZOP
11    FORMAT('    TOTAL AMOUNT OF MATERIAL RELEASED (G): ',G11.4,
     &/,     '          RELEASE HEIGHT ABOVE GROUND (M): ',G11.4
     &/,     ' INITIAL LATERAL DISPERSION SIGMA (Y) (M): ',G11.4
     &/,     'INITIAL VERTICAL DISPERSION SIGMA (Z) (M): ',G11.4)
C PES ADDED CODE ENDS
C      WRITE (6,360) U,HL,AVT,KST
C      WRITE (6,370)
      DO 60 I=1,NREC
C      WRITE (6,380) I,XR(I),RR(I),ZR(I)
60    CONTINUE  
      CON1=2./(2.*3.14159265)**1.5 
      CON2=1./(2.*3.14159265)  
      CON3=1./(2.*3.14159265)**1.5 
      IF (IOUT1.NE.1) GO TO 180 
      DO 100 ILID=1,4   
      HLL=HLID(ILID)
      HLE=0.8*HLL   
C      WRITE (6,390) HLL
      DO 90 ISTA=1,3
      DO 80 IDIS=1,12   
      XX=XDIS(IDIS) 
      CALL PUFSIG (XX,ISTA,SR,SZ)   
      SZ=SQRT(SZ*SZ+SZOP*SZOP)  
      SR=SQRT(SR*SR+SYOP*SYOP)  
      EA=-0.5*(H/SZ)**2
      IF(EA.GT.-80) THEN
      E=EXP(EA) 
      ELSE
      E=0.
      END IF
      CHIM(IDIS)=Q*E*CON1/(SR*SR*SZ)
      IF (ISTA.EQ.3) GO TO 70   
      IF (SZ.GE.HLE) CHIM(IDIS)=Q*CON2/(SR*SR*HLL)  
70    CONTINUE  
80    CONTINUE  
C      WRITE (6,400) ISTA,(CHIM(I),I=1,12)
90    CONTINUE  
100   CONTINUE  
      DO 170 ILID=1,4   
      HLL=HLID(ILID)
      HLE=0.8*HLL   
      DO 160 ISTA=1,3   
      DO 150 IS=1,2 
      ISN=(ISTA-1)*2+IS 
      US=SPD(ISN)   
C      WRITE (6,410) HLL,ISTA,US
      DO 140 IAVT=1,5   
      AVG=AVGT(IAVT)
      DO 130 IDIS=1,12  
      XX=XDIS(IDIS) 
      CALL PUFSIG (XX,ISTA,SR,SZ)   
      SZ=SQRT(SZ*SZ+SZOP*SZOP)  
      SR=SQRT(SR*SR+SYOP*SYOP)  
      EA=-0.5*(H/SZ)**2
      IF(EA.GT.-80) THEN
      E=EXP(EA) 
      ELSE
      E=0.
      END IF
      CHIMAX=Q*E*CON1/(SR*SR*SZ)
      IF (ISTA.EQ.3) GO TO 110  
      IF (SZ.GE.HLE) CHIMAX=Q*CON2/(SR*SR*HLL)  
110   CONTINUE  
      AVGC=1.   
      IF (AVG.LT.1.) GO TO 120  
      SGWT=AVG*US/(SR*2.)   
      CALL AVCOR (SGWT,AVGC)
120   CHIM(IDIS)=CHIMAX*AVGC
130   CONTINUE  
C      WRITE (6,420) AVG,(CHIM(I),I=1,12)
140   CONTINUE  
150   CONTINUE  
160   CONTINUE  
170   CONTINUE  
180   CONTINUE  
      IF (IOUT2.NE.1) GO TO 230 
C      WRITE (6,430) KST,U,HL,AVT
      HLE=0.8*HL
      DO 220 IR=1,NREC  
      XX=XR(IR) 
      CALL PUFSIG (XX,KST,SR,SZ)
      SZ=SQRT(SZ*SZ+SZOP*SZOP)  
      SR=SQRT(SR*SR+SYOP*SYOP)  
      IF (SZ.GE.HLE.AND.KST.LE.2) GO TO 190 
      EA=-0.5*(RR(IR)/SR)**2
      IF(EA.GT.-80) THEN
      EXP1=EXP(EA) 
      ELSE
      EXP1=0.
      END IF
C
      EA=-0.5*(((ZR(IR)+H)/SZ)**2)  
      IF(EA.GT.-80) THEN
      EXP2=EXP(EA) 
      ELSE
      EXP2=0.
      END IF
C
      EA=-0.5*(((ZR(IR)-H)/SZ)**2)  
      IF(EA.GT.-80) THEN
      EXP3=EXP(EA) 
      ELSE
      EXP3=0.
      END IF
      CHI=(Q*CON3/(SZ*SR*SR))*(EXP1*(EXP2+EXP3))   
      GO TO 200 
190   CONTINUE  
      EA=-0.5*(RR(IR)/SR)**2
      IF(EA.GT.-80) THEN
      E1=EXP(EA) 
      ELSE
      E1=0.
      END IF
      CHI=(Q*CON2/(SR**2*HL))*E1
200   CONTINUE  
C      IF (AVT.LT.1.) GO TO 210
      IF (AVT.LT.1.) GO TO 220
      SGWT=AVT*U/(SR*2.)
      CALL AVCOR (SGWT,AVGC)
      CHI=CHI*AVGC  
C210   WRITE (6,440) XR(IR),RR(IR),ZR(IR),CHI
220   CONTINUE  
230   CONTINUE  
      IF (IOUT3.NE.1) GO TO 310 
      CL=0. 
      XPK=0.
      IF (H.GT.1.) CALL DBTMX (Q,KST,H,U,AVT,SYOP,SZOP,XPK,CL)  
      IF (H.GT.1..AND.XCHI.GT.CL) GO TO 300 
      X=0.  
      HLE=0.8*HL
      KD=9  
      DO 280 K=1,KD 
      DX=10.**(KD-K)
      DO 260 J=1,10 
      X=X+DX
      XI=X/10000.   
      IF (XI.LT.XPK) XI=XPK 
      XX=XI 
      CALL PUFSIG (XX,KST,SR,SZ)
      SZ=SQRT(SZ*SZ+SZOP*SZOP)  
      SR=SQRT(SR*SR+SYOP*SYOP)  
      EA=-0.5*(H/SZ)**2
      IF(EA.GT.-80) THEN
      E=EXP(EA) 
      ELSE
      E=0.
      END IF
      CHI=(Q*CON1/(SR**2*SZ))*E 
      IF (KST.EQ.3) GO TO 240   
      IF (SZ.GE.HLE) CHI=Q*CON2/(SR**2*HL)  
240   CONTINUE  
      IF (AVT.LT.1.) GO TO 250  
      SGWT=AVT*U/(SR*2.)
      CALL AVCOR (SGWT,AVGC)
      CHI=CHI*AVGC  
250   DIFF=XCHI-CHI 
      IF (DIFF) 260,290,270 
260   CONTINUE  
270   X=X-DX
280   CONTINUE  
290   CONTINUE  
C      WRITE (6,450) Q,H,SYOP,SZOP,U,HL,KST,AVT,XCHI
C      WRITE (6,460) XI,CHI
C      IF (H.GT.1.) WRITE (6,470) XPK,CL
      GO TO 310 
300   CONTINUE  
C      WRITE (6,480) XPK,XCHI,CL
310   CONTINUE  
      IF (IOUT4.NE.1) GO TO 315
      CALL OPT4(Q,H,SYOP,SZOP,XDIS,XMIN,IPLOTAV)
      IF (IOUT4.EQ.1) GO TO 481
315   CONTINUE
      GO TO 10  
320   STOP
C   
340   FORMAT ('1',8X,'OPTION 1',5X,A3,/,9X,'OPTION 2',5X,A3,/,9X,'OPTION
     1 3',5X,A3,/,9X,'OPTION 4',5X,A3,///)
350   FORMAT (15X,'SOURCE INFORMATION',//,5X,'SOURCE STRENGTH (G)', 6X,F
     110.1,/,5X,'SOURCE HEIGHT (M)', 7X,F6.1,/,5X,'INITIAL SIGMA R (M)',
     2 5X,F6.1,/,5X,'INITIAL SIGMA Z (M)', 5X,F6.1,///) 
360   FORMAT (15X,'METEOROLOGICAL DATA',//,5X,'WIND SPEED (M/SEC)', 6X,F
     14.1,/,5X,'MIXING HEIGHT (M)', 7X,F6.1,/,5X,'SAMPLING TIME (SEC)',
     28X,F7.1,/,5X,'STABILITY CLASS',12X,I1,///)
370   FORMAT (16X,'RECEPTOR DATA',/,5X,'LOCATION', 7X,'DOWNWIND', 7X,'RA
     1DIAL', 9X,'HEIGHT ABOVE',/,6X,'NUMBER', 8X,'DISTANCE', 7X,'DISTANC
     2E',13X,'GROUND',/,23X,'(KM)',10X,'(M)',16X,'(M)',/)   
380   FORMAT (7X,I3,9X,F8.3,4X,F8.2,11X,F8.2) 
390   FORMAT (//////,5X,'MIXING HEIGHT (M)',2X,F6.0,/,1X,'STAB.',
     133X,'DOWNWIND DISTANCE  (KM)',/,1X,'CLAS',/,8X,'0.01', 6X,'0.03',
     2 6X,'0.05', 6X,'0.07', 7X,'0.1', 7X,'0.5', 7X,'1.0', 7X
     3,'3.0', 7X,'5.0', 7X,'7.0',6X,'10.0',6X,'30.0',//)
400   FORMAT (2X,I1,3X,12(1PE9.3,1X))   
410   FORMAT (////,1X,'MIXING HEIGHT (M)',2X,F5.0,/,1X,'STABILITY CLASS'
     1,2X,I1,/,1X,'WIND SPEED (M/SEC)',2X,F5.1,//,4X,'SMP.', 7X,'DOWNWIN
     2D DISTANCE (KM)',/,4X,'TIME (SEC)',/,13X,'0.01', 6X,'0.03', 6X,'0.
     305', 6X,'0.07',7X,'0.1',7X,'0.5',7X,'1.0',7X,'3.0',7X,'5.0',
     47X,'7.0',6X,'10.0',6X,'30.0',//) 
420   FORMAT (2X,F7.0,2X,12(1PE9.3,1X)) 
430   FORMAT ('1',4X,'STABILITY CLASS',2X,I1,/,5X,'WIND SPEED (M/SEC)',2
     1X,F5.1,/,5X,'MIXING HEIGHT (M)',2X,F5.0,/,5X,'SAMPLING TIME (SEC)'
     2,2X,F7.1,//,1X,'DOWNWIND', 4X,'DISTANCE FROM', 4X,'RECEPTOR', 8X,'
     3CONCENTRATION',/,1X,'DISTANCE', 5X,'PUFF CENTER', 6X,'HEIGHT',12X,
     4'(G/M**3)',/,3X,'(KM)',10X,'(M)',12X,'(M)',/) 
440   FORMAT (1X,F8.3,4X,F8.3,9X,F8.3,9X,1PE9.3) 
450   FORMAT ('1',4X,'EMISSION STRENGTH (G)', 9X,F10.1,/,5X,'EMISSION HE
     1IGHT (M)',10X,F6.1,/,5X,'INITIAL SIGMA R (M)',10X,F5.1,/,5X,'INITI
     2AL SIGMA Z (M)',10X,F5.1,/,5X,'WIND SPEED (M/SEC)',10X,F5.1,/,5X,'
     3MIXING HEIGHT (M)',11X,F6.1,/,5X,'STABILITY CLASS  ',11X,I1,/,5X,'
     4SAMPLING TIME (SEC) ', 9X,F7.1,/,5X,'CRITICAL CONCENTRATION',' (G/
     5M**3)',8X,1PE9.3,/)  
460   FORMAT (5X,'CRITICAL DOWNWIND DISTANCE (KM) ', 7X,F9.3,/,5X,'CONCE
     1NTRATION AT CONVERGENCE (G/M**3) ', 1X,1PE9.3,////////)   
470   FORMAT (///,5X,'ELEVATED RELEASE',/,5X,'DISTANCE OUT TO PEAK CONCE
     1NTRATION (KM) ',F8.3,/,5X,'PEAK CONCENTRATION (G/M**3) ',1PE9.3)  
480   FORMAT ('1',5X,'CRITICAL CONCENTRATION IS GREATER ','THAN PEAK CON
     1CENTRATION',/,5X,'DISTANCE OUT TO PEAK CONCENTRATION (KM) ',F8.3,/
     2,5X,'CRITICAL CONCENTRATION (G/M**3) ',1PE9.3,/,5X,'PEAK CONCENTRA
     3TION (G/M**3) ',1PE9.3)   
C
C PES MODIFIED CODE BEGINS
481   CLOSE (8, STATUS = 'DELETE')

      END
C PES MODIFIED CODE ENDS
C
      SUBROUTINE PUFSIG (X,KST,SR,SZ)
      DIMENSION AY(3), AZ(3), BY(3), BZ(3)  
      DATA AY /0.14,0.06,0.02/  
      DATA AZ /0.53,0.15,0.05/  
      DATA BY /0.92,0.92,0.89/  
      DATA BZ /0.73,0.70,0.61/  
C   
C       PUFSIG COMPUTES SIGMA R AND SIGMA Z, USING THE CURVES   
C       RECOMMENDED IN METEOROLOGY AND ATOMIC ENERGY (1968) P. 175  
C   
C        X       DOWNWIND DISTANCE                     (KM) 
C        KST     STABILITY CLASS
C        SR      SIGMA R                               (M)  
C        SZ      SIGMA Z                               (M)  
C
      XK=1000.*X
      GO TO (10,20,30), KST
10    SR=AY(1)*XK**BY(1)
      SZ=AZ(1)*XK**BZ(1)
      RETURN
20    SR=AY(2)*XK**BY(2)
      SZ=AZ(2)*XK**BZ(2)
      RETURN
30    SR=AY(3)*XK**BY(3)
      SZ=AZ(3)*XK**BZ(3)
      RETURN
C   
      END   
C
      SUBROUTINE AVCOR(SGWT,AVGC)   
C   
C      AVCOR COMPUTES AREA UNDER NORMAL CURVE.  
C   
C      SGWT      NUMBER OF STANDARD DEVIATIONS  
C      AVGC      AREA UNDER NORMAL CURVE
C   
      R=0.2316419   
      B1=0.319381530
      B2=-0.356563782   
      B3=1.781477937
      B4=-1.821255978   
      B5=1.330274429
      C=1./SQRT(2.*3.14159) 
      X=SGWT
C       X IS THE NUMBER OF STANDARD DEVIATIONS ABOUT THE MEAN   
      EA=-(X**2/2.)
      IF(EA.GT.-80) THEN
      E=EXP(EA) 
      ELSE
      E=0.
      END IF
      T=1./(1.+R*X) 
      RR=C*E*(B1*T+B2*T**2+B3*T**3+B4*T**4+B5*T**5) 
      A=1.-RR   
      AVGC=2.*(A-0.5)/(2.*X*0.398942)   
      RETURN
      END   
C
      SUBROUTINE DBTMX (Q,KST,H,U,AVT,SYOP,SZOP,XL,CL)  
C   
C       DBTMX COMPUTES DISTANCE TO MAXIMUM CONCENTRATION.   
C   
C    Q         SOURCE STRENGTH                          (G) 
C    KST       STABILITY CLASS  
C    H         EFFECTIVE PUFF HEIGHT                    (M) 
C    U         WIND SPEED                               (M/SEC) 
C    AVT       SAMPLING TIME                            (SEC)   
C    SYOP      INITIAL HORIZONTAL DISPERSION            (M) 
C    SZOP      INITIAL VERTICAL DISPERSION              (M) 
C    XL        DISTANCE TO MAXIMUM CONCENTRATION        (KM)
C    CL        MAXIMUM CONCENTRATION                    (G/M**3)
C   
      CON1=2./(2.*3.14159)**1.5 
      IA=1  
      XL=0.0
      RC=0.0
      X=0.01
      DX=0.01   
10    CL=RC 
      XX=X
      CALL PUFSIG (XX,KST,SR,SZ)
      SR=SQRT(SR*SR+SYOP*SYOP)  
      SZ=SQRT(SZ*SZ+SZOP*SZOP)  
      EA=-0.5*(H/SZ)**2
      IF(EA.GT.-80) THEN
      E=EXP(EA) 
      ELSE
      E=0.
      END IF
      RC=(Q*CON1/(SR**2*SZ))*E  
      IF (AVT.LT.1.) GO TO 20   
      SGWT=AVT*U/(SR*2.)
      CALL AVCOR (SGWT,AVGC)
      RC=RC*AVGC
20    IF (RC-CL) 110,30,30  
30    XL=X  
      X=X+DX
      GO TO (40,60,80,100), IA  
40    IF (X-0.192) 10,10,50 
50    IA=2  
      X=0.2 
      DX=0.1
      GO TO 10  
60    IF (X-3.92) 10,10,70  
70    IA=3  
      X=4.0 
      DX=1.0
      GO TO 10  
80    IF (X-19.2) 10,10,90  
90    IA=4  
      X=20.0
      DX=10.0   
      GO TO 10  
100   IF (X-305.0) 10,10,200
110   IF (DX-0.001) 120,120,130 
120   RETURN
130   DX=0.1*DX 
140   XL=X  
      X=X-DX
      CL=RC 
      XX=X
      CALL PUFSIG (XX,KST,SR,SZ)
      SR=SQRT(SR*SR+SYOP*SYOP)  
      SZ=SQRT(SZ*SZ+SZOP*SZOP)  
      EA=-0.5*(H/SZ)**2
      IF(EA.GT.-80) THEN
      E=EXP(EA) 
      ELSE
      E=0.
      END IF
      RC=(Q*CON1/(SR**2*SZ))*E  
      IF (AVT.LT.1.) GO TO 150  
      SGWT=AVT*U/(SR*2.)
      CALL AVCOR (SGWT,AVGC)
      RC=RC*AVGC
150   IF (RC-CL) 160,140,140
160   IF (DX-0.001) 120,120,170 
170   DX=0.1*DX 
180   XL=X  
      X=X+DX
      CL=RC 
      XX=X
      CALL PUFSIG (XX,KST,SR,SZ)
      SR=SQRT(SR*SR+SYOP*SYOP)  
      SZ=SQRT(SZ*SZ+SZOP*SZOP)  
      EA=-0.5*(H/SZ)**2
      IF(EA.GT.-80) THEN
      E=EXP(EA) 
      ELSE
      E=0.
      END IF
      RC=(Q*CON1/(SR**2*SZ))*E  
      SGWT=AVT*U/(SR*2.)
      CALL AVCOR (SGWT,AVGC)
      RC=RC*AVGC
      IF (RC-CL) 190,180,180
190   IF (DX-0.001) 120,120,130 
200   XL=999.0  
      CL=99.0   
      RETURN
C   
      END   
C
      SUBROUTINE OPT4(Q,HGT,SYOP,SZOP,XDIS,XMIN,IPLOTAV)
      DIMENSION XDIS(13),CONX(5,13),STM(5),CXS(5),DXS(5)
      CHARACTER*1 STAB(5,12),ISTAB(5),DCHAR(74),PLT(5)
      CHARACTER*15 STM0(5),STM1(5)
      REAL*4 NXPK,NCHI,NCL,XNUM,XDISTEMP1,CONXTEMP1,XDISTEMP2,CONXTEMP2
      REAL PERCENT,XCOUNT,XTOT
      DATA STM /1.,60.,300.,900.,3600./
      DATA STM0 /'INSTANTANEOUS ','      1 ','      5 ','      15 ',
     *'      60 '/
      DATA STM1 /'INST. ','1 ','5 ','15 ','60 '/
C      WRITE(6,900) XMIN
CC900   FORMAT(' THE FIRST TABLE SHOWS ',
C     *'THE MAXIMUM CONCENTRATION AND THE DISTANCE',/,' TO MAXIMUM ',
C     *'CONCENTRATION FOR DISTANCES BEYOND',F7.3,' (KM). ',
C     */,' THE SECOND TABLE '
C     *,'SHOWS THE MAXIMUM CONCENTRATION AS A FUNCTION OF DOWNWIND',/,
C     *' DISTANCE AND THE CONDITIONS THAT PRODUCED THE MAXIMUM AT THAT'
C     *,' DISTANCE.',//)
      XTOT = 10
      DO 2 I = 1, 5
         IF (I .EQ. IPLOTAV) THEN
            PLT(I) = '*'
         ELSE
            PLT(I) = ' '
         ENDIF
2     CONTINUE
      DO 5 I=1,74
5     DCHAR(I)='='
      H=HGT
      HLL=320.
      HLE=0.8*HLL
C PES CHANGED CODE PER CONVERSATION WITH BILL PETERSEN BEBINS
CCC      IF(H.LT.1.0) H=0.
      IF(H.LE.1.0) H=0.
C PES CHANGED CODE PER CONVERSATION WITH BILL PETERSEN ENDS
      UM=1.
C
C     PES ADDED CODE BEGINS
C
      DO 19 I = 1,1
         WRITE(*,*)
19    CONTINUE
      WRITE(*,*)
      XCOUNT = 0
C
C    PES ADDED CODE ENDS
C
      DO 10 I=1,5
C
C    PES ADDED CODE BEGINS
C
      XCOUNT = XCOUNT + 1
      PERCENT = XCOUNT/XTOT*100
      IPERCENT = NINT(PERCENT)
      WRITE(*,101) IPERCENT
101   FORMAT('+',30X,I3,' % Complete')
C
C    PES ADDED CODE ENDS
C
C PES CHANGED CODE PER CONVERSATION WITH BILL PETERSEN BEGINS
CCC      IF (H.GE.1.) THEN
      IF (H.GT.1.) THEN
C PES CHANGED CODE PER CONVERSATION WITH BILL PETERSEN ENDS
C     ELEVATED SOURCE
      KST=1
      CALL DBTMX (Q,KST,H,UM,STM(I),SYOP,SZOP,XPK,CL)  
            IF(XPK.LT.XMIN) THEN
C            ITERATE TO THE CONDITIONS WHICH PRODUCE MAX. CONC'S
C            AT A DISTANCE GREATER THAN XMIN
C
            KST=1
            CALL CONC(Q,H,XMIN,KST,UM,STM(I),SZOP,SYOP,CHI)      
            UXPK=XMIN
            UCL=CHI
C           MAX CONC FOR NEUTRAL STAB.
            KST=2
            CALL DBTMX (Q,KST,H,UM,STM(I),SYOP,SZOP,XPK,CL)  
            NXPK=XPK
            NCL=CL
C           MAX CONC FOR STABLE STAB
            KST=3
            CALL DBTMX (Q,KST,H,UM,STM(I),SYOP,SZOP,XPK,CL)  
            SXPK=XPK
            SCL=CL
                  IF(NXPK.LT.XMIN.AND.SXPK.LT.XMIN) THEN
C                  IF DISTANCE TO MAX CONC IS LT XMIN FOR ALL 3
C                  STAB CALCULATE CONC FOR ALL 3 STAB AT XMIN AND
C                  USED THE HIGHEST
                  KST=1
C                  UNSTABLE
                  CALL CONC(Q,H,XMIN,KST,UM,STM(I),SZOP,SYOP,CHI)      
                  UCHI=CHI
                  KST=2
C                  NEUTRAL
                  CALL CONC(Q,H,XMIN,KST,UM,STM(I),SZOP,SYOP,CHI)      
                  NCHI=CHI
                  KST=3
C                  STABLE
                  CALL CONC(Q,H,XMIN,KST,UM,STM(I),SZOP,SYOP,CHI)      
                  SCHI=CHI                  
                  CXS(I)=AMAX1(UCHI,NCHI,SCHI)
                  DXS(I)=XMIN
                  IF(CXS(I).EQ.UCHI) ISTAB(I)='U'
                  IF(CXS(I).EQ.NCHI) ISTAB(I)='N'
                  IF(CXS(I).EQ.SCHI) ISTAB(I)='S'
C
                  ELSE
C                   A DIST TO MAX CONC GT XMIN FOR NEUTRAL OR STABLE 
C                   OR BOTH.
                        IF(NXPK.GT.XMIN.AND.SXPK.GT.XMIN) THEN
                        CXS(I)=AMAX1(UCL,NCL,SCL)
                        IF(CXS(I).EQ.UCL) DXS(I)=XMIN
                        IF(CXS(I).EQ.UCL) ISTAB(I)='U'
                        IF(CXS(I).EQ.NCL) DXS(I)=NXPK
                        IF(CXS(I).EQ.NCL) ISTAB(I)='N'
                        IF(CXS(I).EQ.SCL) DXS(I)=SXPK
                        IF(CXS(I).EQ.SCL) ISTAB(I)='S'
                        ELSE
C                        DISTANCE TO MAX FOR NEUTRAL IS LT XMIN
                        KST=2
                        CALL CONC(Q,H,XMIN,KST,UM,STM(I),SZOP,SYOP,CHI)
                        NCHI=CHI
                        CXS(I)=AMAX1(UCL,NCHI,SCL)      
                        IF(CXS(I).EQ.UCL) DXS(I)=XMIN
                        IF(CXS(I).EQ.UCL) ISTAB(I)='U'
                        IF(CXS(I).EQ.NCHI) DXS(I)=XMIN
                        IF(CXS(I).EQ.NCHI) ISTAB(I)='N'
                        IF(CXS(I).EQ.SCL) DXS(I)=SXPK
                        IF(CXS(I).EQ.SCL) ISTAB(I)='S'
                        END IF
                  END IF
            ELSE
C           MAX CONC IS AT DISTANCE GREATER THAN XMIN
            CXS(I)=CL
            DXS(I)=XPK
            ISTAB(I)='U'
            END IF
      ELSE
C      SURFACE RELEASE MAX CONC'S IS ALWAYS FOR STAB=3 AND AT XMIN
      CALL CONC(Q,H,XMIN,3,UM,STM(I),SZOP,SYOP,CHI)      
      CXS(I)=CHI
      DXS(I)=XMIN
      ISTAB(I)='S'
      END IF
C
10    CONTINUE
      WRITE(6,950)
950   FORMAT(/,' *****************************************************'
     *,'*',/,' ***         SUMMARY OF PUFF MODEL RESULTS          ***',/,
     *' ******************************************************',/)
      WRITE(6,960) XMIN
960   FORMAT('THE MAXIMUM CONCENTRATION AND THE DISTANCE TO MAXIMUM',/,
     *'CONCENTRATION FOR DISTANCES BEYOND FENCELINE ',F7.3,' (KM). ',/,
     *'FOR NEAR SURFACE RELEASE MAXIMUM CONCENTRATION WILL OCCUR AT ',/,
     *'THE FENCELINE.')
      WRITE(6,1000)
1000  FORMAT(/,T5,'AVERAGING',T25,'MAXIMUM',T45,'DISTANCE TO',T65,
     *'STABILITY',/,T5,'TIME (MIN)',T20,'CONCENTRATION (G/M**3)',
     *T45,'MAX. CONC. (KM)',T65,'CLASS',/)
      DO 20 I=1,5
      WRITE(6,2000) PLT(I),STM0(I),CXS(I),DXS(I),ISTAB(I)
C2000  FORMAT(A1,T5,F5.0,T25,1PE12.3,T45,0PF8.3,T68,A1)
2000  FORMAT(A1,A14,T25,1PE12.3,T45,0PF8.3,T68,A1)
20    CONTINUE
      WRITE(6,2010)
2010  FORMAT(/,' *****************************************************'
     *,'*',/,' **   REMEMBER TO INCLUDE BACKGROUND CONCENTRATIONS  **'
     *,/,
     *' ******************************************************',/)
      DO 50 I=1,5
C
C     PES ADDED CODE BEGINS
C
      XCOUNT = XCOUNT + 1
      PERCENT = XCOUNT/XTOT*100
      IPERCENT = NINT(PERCENT)
      WRITE(*,101) IPERCENT
C
C     PES ADDED CODE ENDS
C
      DO 40 J=1,12
C PES CHANGED CODE PER CONVERSATION WITH BILL PETERSEN BEGINS
CCC      IF(H.GE.1.) THEN
      IF(H.GT.1.) THEN
C PES CHANGED CODE PER CONVERSATION WITH BILL PETERSEN ENDS
      CALL PUFSIG (XDIS(J),1,SR,SZ)
            IF(SZ.LT.HLE) THEN
            CALL CONC(Q,H,XDIS(J),1,UM,STM(I),SZOP,SYOP,CHI)
            ELSE
            CALL CONCM(Q,H,XDIS(J),1,UM,STM(I),SYOP,HLL,CHI)
            END IF
      UCHI=CHI
      CALL CONC(Q,H,XDIS(J),2,UM,STM(I),SZOP,SYOP,CHI)
      NCHI=CHI
      CALL CONC(Q,H,XDIS(J),3,UM,STM(I),SZOP,SYOP,CHI)
      SCHI=CHI
      CONX(I,J)=AMAX1(UCHI,NCHI,SCHI)
      IF(CONX(I,J).EQ.UCHI) STAB(I,J)='U'
      IF(CONX(I,J).EQ.NCHI) STAB(I,J)='N'
      IF(CONX(I,J).EQ.SCHI) STAB(I,J)='S'
      ELSE
C      SURFACE RELEASE MAX CONC'S IS ALWAYS FOR STAB=3
      CALL CONC(Q,H,XDIS(J),3,UM,STM(I),SZOP,SYOP,CHI)
      CONX(I,J) = CHI
      STAB(I,J) = 'S'
      END IF
40    CONTINUE
50    CONTINUE
      DO 55 I=1,5
      DO 55 J=1,12
      IF(CONX(I,J).EQ.0.) STAB(I,J)=' '
55    CONTINUE
C
C    PES CHANGED CODE BEGINS
C
      WRITE (6,58)
58    FORMAT (/,' *********************************',/
     *,' ***      PUFF DISTANCES       ***',/
     *,' *********************************',/)
      WRITE (6,70)
70    FORMAT(' THE MAXIMUM CONCENTRATION AS A FUNCTION OF',
     *' DOWNWIND DISTANCE',/,
     *' AND THE CONDITIONS THAT PRODUCED THE MAXIMUM AT THAT'
     *,' DISTANCE.')
      WRITE (6,410) HLL,UM,DCHAR
410   FORMAT (//,1X,'MIXING HEIGHT (M)',2X,F5.0,
     1/,1X,'WIND SPEED (M/SEC)',2X,F5.1,//,' AVERAGING',25X,'DOWNWIND ',
     2'DISTANCE (KM)',/,1X,'TIME (MIN)',3X,'MAXIMUM CONCENTRATION ',
     *'(G/M**3) AT VARIOUS DOWNWIND DISTANCES.',/,16X,'  STABILITY'
     3,' CLASS THAT PRODUCED THE MAX. LISTED BELOW'
     4,/,13X,'0.01', 6X,'0.03', 6X,'0.05'
     5,6X,'0.07',7X,'0.1',7X,'0.5',/,1X,74A1)
      DO 60 I=1,5
      WRITE(6,400) PLT(I),STM1(I),(CONX(I,J),J=1,6)
400   FORMAT (A1,A5,3X,12(1PE9.3,1X))
      WRITE(6,420) (STAB(I,J),J=1,6)
420   FORMAT(15X,11(A1,9X),A1)
60    CONTINUE
C
      WRITE (6,411) DCHAR
411   FORMAT (////,' AVERAGING', 25X,'DOWNWIND ',
     1'DISTANCE (KM)',/,1X,'TIME (MIN)',3X,'MAXIMUM CONCENTRATION ',
     *'(G/M**3) AT VARIOUS DOWNWIND DISTANCES.',/,16X,'  STABILITY'
     2,' CLASS THAT PRODUCED THE MAX. LISTED BELOW'
     3,/,13X,'1.0',7X,'3.0',7X,'5.0',7X,'7.0',6X,'10.0',6X,'30.0',
     4/,1X,74A1)
      DO 61 I=1,5
      WRITE(6,401) PLT(I),STM1(I),(CONX(I,J),J=7,12)
401   FORMAT (A1,A5,3X,12(1PE9.3,1X))
      WRITE(6,421) (STAB(I,J),J=7,12)
421   FORMAT(15X,11(A1,9X),A1)
61    CONTINUE
C
C     PES CHANGED CODE ENDS
C
C
C
C     PES ADDED CODE BEGINS
C

      WRITE (6,65)
65    FORMAT (/,' STABILITY CLASSES',/,' U = UNSTABLE',/,' N = NEUTRAL',
     &       /,' S = STABLE')
      WRITE (6,67)
67    FORMAT (/,' * INDICATES AVERAGING TIME THAT WAS SELECTED FOR ',
     &'PLOTTING')
C INSERT MAX CONCENTRATION INTO CONCX ARRAY
      DO 498 I = 1, 12
         IF (DXS(IPLOTAV) .LT. XDIS(I)) EXIT
498   CONTINUE
      IF (I .LE. 12) THEN
         CONXTEMP1 = CONX(IPLOTAV,I)
         XDISTEMP1 = XDIS(I)
         CONX(IPLOTAV,I) = CXS(IPLOTAV)
         XDIS(I) = DXS(IPLOTAV)
         INEW = I + 1
         DO 499 I = INEW,13
            IF (I .LT. 13) THEN
               CONXTEMP2 = CONX(IPLOTAV,I)
               XDISTEMP2 = XDIS(I)
            ENDIF
            CONX(IPLOTAV,I) = CONXTEMP1
            XDIS(I) = XDISTEMP1
            IF (I .LE. 13) THEN
               CONXTEMP1 = CONXTEMP2
               XDISTEMP1 = XDISTEMP2
            ENDIF
499      CONTINUE
      ELSE
         CONX(IPLOTAV,13) = CXS(IPLOTAV)
         XDIS(13) = DXS(IPLOTAV)
      ENDIF
      XNUM = 13
      WRITE(7,500) XNUM,XMIN*1000,CXS(IPLOTAV)*10**6,DXS(IPLOTAV)*1000,
     &     (CONX(IPLOTAV,I)*10**6,XDIS(I)*1000,I = 1,13)
500   FORMAT(G12.4)
C
C     PES ADDED CODE ENDS
C
C      STOP
      RETURN
      END
C
      SUBROUTINE CONC(Q,H,X,KST,U,AVT,SZOP,SYOP,CHI)      
      CON1=2./(2.*3.14159265)**1.5 
      CALL PUFSIG (X,KST,SR,SZ)
      SZ=SQRT(SZ*SZ+SZOP*SZOP)  
      SR=SQRT(SR*SR+SYOP*SYOP)  
      EA=-0.5*(H/SZ)**2
      IF(EA.GT.-80) THEN
      E=EXP(EA) 
      ELSE
      E=0.
      END IF
      CHI=(Q*CON1/(SR**2*SZ))*E 
      SGWT=AVT*U/(SR*2.)
      CALL AVCOR (SGWT,AVGC)
      CHI=CHI*AVGC  
      RETURN
      END                  
C
      SUBROUTINE CONCM(Q,H,X,KST,U,AVT,SYOP,HL,CHI)      
      CON2=1./(2.*3.14159265)  
      CALL PUFSIG (X,KST,SR,SZ)
      SR=SQRT(SR*SR+SYOP*SYOP)  
      CHI=(Q*CON2/(SR**2*HL))
      SGWT=AVT*U/(SR*2.)
      CALL AVCOR (SGWT,AVGC)
      CHI=CHI*AVGC  
      RETURN
      END
