* system : tscreen
* program : rvdsub
* author : Kevin Stroupe, PES
* modified by: Roger Brode, PES, 4/7/94
*   Modifications to variables QC and MO passed to RVD model.

model = 'RVD'
*IF VAL(Exitv) = 0 THEN
*   Exitv = convert(VAL(V) / (3.14159 * (VAL(D) / 2) ^ 2))
*ENDIF

ACTIVATE WINDOW datawind
DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 0, 3 SAY 'Based on user input, RVD model has been selected.'
   @ 2, 3 SAY 'RVD MODEL INPUTS - Page 1 of 3'
   @ 4, 3 SAY 'RELEASE PARAMETERS'
   @ 5, 3 SAY '                   Release Height above Ground -> '+LEFT(Hs+SPACE(8),8)+' m'
   @ 6, 3 SAY '                     Exhaust Gas Exit Velocity -> '+LEFT(Exitv+SPACE(8),8)+' m/s' 
   @ 8, 3 SAY 'POLLUTANT INFORMATION'
   @ 9, 3 SAY '                 Pollutant Concentration (vol) -> '+LEFT(Vol+SPACE(8),8) + ' %'
   @ 10,3 SAY '                    Pollutant Molecular Weight -> '+LEFT(Mwc+SPACE(8),8) + ' g/g-mole'
   @ 12,3 SAY 'TIME'
   @ 13,3 SAY '    Desired Averaging Time for the Calculation'
   @ 14,3 SAY '                             of Concentrations -> ' + LEFT(Av+SPACE(8),8) + ' min'      
   
  * @ 13,3 SAY '                       Duration of the Release -> '+LEFT(Dur+SPACE(8),8) + ' min'
  * @ 14,3 SAY '    Desired Averaging Time for the Calculation'
  * @ 15,3 SAY '                             of Concentrations -> ' + LEFT(Av+SPACE(8),8) + ' min'      
   
   @ 5, 53 FILL TO 5,60 COLOR &IPColor  
   @ 6, 53 FILL TO 6,60 COLOR &IPColor 
   @ 9, 53 FILL TO 9,60 COLOR &IPColor 
   @ 10, 53 FILL TO 10,60 COLOR &IPColor  
   *@ 13, 53 FILL TO 13,60 COLOR &IPColor 
   @ 14, 53 FILL TO 14,60 COLOR &IPColor 
   *@ 15, 53 FILL TO 15,60 COLOR &IPColor 
   
   cntr = 1
   DO WHILE .NOT. abort
      DO CASE 
         CASE cntr = 1
            @ 5,53 GET Hs PICTURE '@!' VALID Chk(Hs,3)
            @ 6,53 GET Exitv  PICTURE '@!' VALID Chk(Exitv,3)
            @ 9,53 GET Vol PICTURE '@!' VALID Chk(Vol,16)
            @ 10,53 GET Mwc PICTURE '@!' VALID Chk(Mwc,8)
            @ 14,53 GET Av PICTURE '@!' VALID Chk(Av,3)
            
            *@ 13,53 GET Dur PICTURE '@!' VALID Chk(Dur,3)
            *@ 15,53 GET Av PICTURE '@!' VALID Chk(Av,3)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 1
               CASE prev  && F9            
                  model = ''               
                  RETURN                
               OTHERWISE                 
                  cntr = 2
            ENDCASE
         CASE cntr = 2
            mo = convert(VAL(Qm)/1000)
            qc = convert(VAL(Qm)/1000 * VAL(Vol)/100 * VAL(Mwc)/VAL(Mw))
            DO EL2Keys
            IF prev           && F9
               model = ''
               RETURN
            ENDIF                 
            IF prcd           && F10
               DO rvdx2
            ENDIF   
            EXIT                               
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO
             
DEACTIVATE WINDOW datawind
model = ''
RETURN

****************************** RVD x 2 ********************************
PROCEDURE RVDx2

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 1, 3 SAY 'RVD MODEL INPUTS - Page 2 of 3'
   @ 3, 3 SAY 'URBAN/RURAL CLASSIFICATION'
   @ 4, 3 SAY '               Enter U for Urban - R for Rural -> '+LEFT(Ruclass+' ',1)
   @ 6, 3 SAY 'FENCELINE DISTANCE'
   @ 7, 3 SAY ' Enter the distance from the base of the stack' 
   @ 8, 3 SAY '                        to the plant fenceline -> '+LEFT(Fence+SPACE(8),8) + ' m'
   @ 10,3 SAY 'RECEPTOR LOCATIONS'
   @ 11,3 SAY 'Do you have specific locations where you would'
   @ 12,3 SAY 'like pollutant concentrations calculated (Y/N) -> '+LEFT(Isd+' ',1)
   
   @ 4, 53 FILL TO 4,53 COLOR &IPColor 
   @ 8, 53 FILL TO 8,60 COLOR &IPColor    
   @ 12, 53 FILL TO 12,53 COLOR &IPColor 
   
   cntr = 1
   DO WHILE .NOT. abort
      DO CASE 
         CASE cntr = 1
            @ 4,53 GET Ruclass PICTURE '@!' VALID ChkRU(Ruclass)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               OTHERWISE 
                  IF Ruclass = 'U'
                     ru = '0'
                  ELSE
                     ru = '1'
                  ENDIF
                  cntr = 2
            ENDCASE 
         CASE cntr = 2
            @ 8,53 GET Fence PICTURE '@!' VALID Chk(Fence,3)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               OTHERWISE 
                  IF VAL(Fence) > 50000
                     WAIT 'Fenceline must be  50000, '+press WINDOW
                     cntr = 2
                     LOOP
                  ENDIF                  
                  cntr = 3
            ENDCASE                   
         CASE cntr = 3
            @ 12,53 GET Isd PICTURE '@!' VALID ChkYN(Isd)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 2
               CASE prev             && F9
                  RETURN   
               OTHERWISE 
                  cntr = 4
             ENDCASE 
          CASE cntr = 4
             IF ALLTRIM(Isd) = 'Y'
                DO EL2Keys
             ELSE
                DO EL3Keys
             ENDIF
             IF prev           && F9
                RETURN
             ENDIF                 
             IF prcd           && F10
                IF ALLTRIM(Isd) = 'Y'
                   DO rvdx3
                ELSE
                   * create automated distances
                   **Dist(1) = fence
                   **fenceconvert = VAL(Fence)
                   **fenceconvert = INT(fenceconvert)
                   *DO WHILE MOD(fenceconvert,100) > 0
                   *   fenceconvert = fenceconvert - 1
                   *ENDDO                   
                   *Dist(2) = convert(fenceconvert + 100)
                   **Dist(2) = fenceconvert + (100-MOD(fenceconvert,100))
                   **blankout = .T.
                   **x = 100
                   **y = 1000
                   **FOR i = 3 TO 30
                   **  IF i < 17
                   **      Dist(i) = convert(VAL(dist(i-1)) + 100)
                   **   ENDIF
                   **   IF i > 16 .AND. i < 25 
                   **      Dist(i) = convert(VAL(Dist(i-1)) + 200)
                   **   ENDIF
                   **   IF i > 24 
                   **      Dist(i) = convert(VAL(Dist(i-1)) + 300)
                   **   ENDIF
                   **NEXT i                   
                   num_dist = 30
                   DO RVDSav                   
                   DO RunModel
                   abort = .T.
                ENDIF
             ENDIF   
             EXIT                               
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO
RETURN


****************************** RVD x 3 ********************************
PROCEDURE RVDx3

Dist(1) = Fence
**IF blankout
**   FOR i = 2 TO 30
**      Dist(i) = SPACE(8)
**   NEXT i
**ENDIF
**blankout = .F.
DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 1, 3 SAY 'RVD MODEL INPUTS - Page 3 of 3'
   @ 2, 3 SAY 'RECEPTOR LOCATIONS:  Enter (up to 30) distances from'
   @ 3, 3 SAY 'the source at which concentrations should be calculated.'
   @ 4, 3 SAY 'Enter a blank after the last distance to stop input.'
   @ 6, 3 SAY '   Distance from          Distance from          Distance from'
   @ 7, 3 SAY '  source (meters)        source (meters)        source (meters)'
   @ 8, 3 SAY '                '
   @ 9, 3 SAY '    1          fence      11                     21'
   @ 10,3 SAY '    2                     12                     22'
   @ 11,3 SAY '    3                     13                     23'
   @ 12,3 SAY '    4                     14                     24'
   @ 13,3 SAY '    5                     15                     25'
   @ 14,3 SAY '    6                     16                     26'
   @ 15,3 SAY '    7                     17                     27'
   @ 16,3 SAY '    8                     18                     28'
   @ 17,3 SAY '    9                     19                     29'
   @ 18,3 SAY '   10                     20                     30'
   
   FOR i = 0 TO 2
      FOR j = 1 TO 10
         DO CASE
            CASE i = 0
               col = 9
            CASE i = 1
               col = 32
            CASE i = 2
               col = 55
         ENDCASE
         @ 8+j, col SAY LEFT(Dist((10*i)+j)+SPACE(8),8)
      NEXT j
   NEXT i
   @ 10,9 FILL TO 18,16 COLOR &IPColor
   @ 9,32 FILL TO 18,39 COLOR &IPColor
   @ 9,55 FILL TO 18,62 COLOR &IPColor
   cntr = 1
   dist_cntr = 2
   DO WHILE .NOT. abort
      DO CASE 
         CASE cntr = 1
            DO WHILE dist_cntr <= 30               
               IF dist_cntr <=10 
                  row = 8+dist_cntr
                  col = 9
               ELSE
                  IF dist_cntr <= 20 
                     row = 8+(dist_cntr-10)
                     col = 32
                  ELSE
                     row = 8+(dist_cntr-20)
                     col = 55
                  ENDIF
               ENDIF
            
               @ row, col GET Dist(dist_cntr) PICTURE '@!' VALID Chk(Dist(dist_cntr),-1)
               READ
               DO CASE
                  CASE LASTKEY() = 27  && ESCAPE
                     abort = .T.
                     EXIT
                  CASE LASTKEY() = 5   && UP 
                     IF dist_cntr > 2   
                        dist_cntr = dist_cntr -1
                     ENDIF
                  CASE prev  && F9            
                     RETURN                
                  OTHERWISE                       
                     IF LEN(ALLTRIM(Dist(dist_cntr))) = 0  
                        IF LEN(ALLTRIM(Dist(dist_cntr+1))) > 0
                           WAIT 'Enter a DISTANCE, '+press WINDOW
                           LOOP
                        ELSE
                           *num_dist = dist_cntr - 1                                                                                                            
                           EXIT
                        ENDIF
                     ENDIF
                     IF VAL(Dist(dist_cntr)) <= VAL(Dist(dist_cntr-1))
                        WAIT 'Distance must be > previous distance, '+press WINDOW
                        LOOP
                     ENDIF
                     IF VAL(Dist(dist_cntr)) > 100000
                        WAIT 'Distance must be  100000, '+press WINDOW
                        LOOP
                     ENDIF
                     dist_cntr = dist_cntr + 1
               ENDCASE
            ENDDO
            num_dist = dist_cntr - 1
            cntr = 2 
         CASE cntr = 2
             DO EL3Keys
             IF prev           && F9
                RETURN
             ENDIF                 
             IF prcd           && F10                         
                DO RVDSav   
                DO RunModel 
                abort = .T.    
             ENDIF      
             EXIT                               
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO
RETURN

****************************** RVD Save ********************************
PROCEDURE RVDSav

ifp = FCREATE('RVDIN.DAT')
bytes = FPUTS(ifp,Title)
bytes = FPUTS(ifp,qc)
bytes = FPUTS(ifp,Exitv)
bytes = FPUTS(ifp,D)
bytes = FPUTS(ifp,Ts)
bytes = FPUTS(ifp,Hs)   
bytes = FPUTS(ifp,Vol)      
bytes = FPUTS(ifp,Mw)          
bytes = FPUTS(ifp,mo)
bytes = FPUTS(ifp,Mwc)
bytes = FPUTS(ifp,Dur)
bytes = FPUTS(ifp,Av)  
icop = '2'       
bytes = FPUTS(ifp,icop)        
bytes = FPUTS(ifp,'9')         
bytes = FPUTS(ifp,'1,2,3,4,5,8,10,15,20')  

*+++++++ Save distances +++++++++++
IF ALLTRIM(Isd) = 'Y' 
   *  30 -  TSCREEN automated distances +
   *  num_dist - user entered discrete distances -
   *  1 - fenceline is in both catagories      
   totndist = 30 + num_dist - 1
   bytes = FPUTS(ifp,ALLTRIM(STR(totndist)))
ELSE  && only 30 automated distances 
   bytes = FPUTS(ifp,ALLTRIM(STR(num_dist)))
ENDIF   
dist_hold = fence
bytes = FPUTS(ifp,dist_hold)
fenceconvert = VAL(fence)
fenceconvert = INT(fenceconvert)
distance = convert(fenceconvert + (100-MOD(fenceconvert,100)))
j = 2
FOR i = 2 TO 31
   IF ALLTRIM(Isd) = 'Y' 
      FOR x = 1 TO 60
         IF j <= num_dist          
           DO CASE       
               CASE (i = 31) .AND. (j <= num_dist)
                  bytes = FPUTS(ifp,Dist(j))     
                  j = j + 1               
               CASE (VAL(Dist(j)) > VAL(dist_hold)) .AND. (VAL(Dist(j)) < VAL(distance)) 
                  bytes = FPUTS(ifp,Dist(j))     
                  j = j + 1               
               CASE (VAL(Dist(j)) = VAL(dist_hold)) .OR. (VAL(Dist(j)) = VAL(distance))  
                  j = j + 1
                  EXIT
               OTHERWISE   
                  EXIT   
            ENDCASE 
         ENDIF   
      NEXT x
   ENDIF
   IF i = 31   
      EXIT
   ENDIF
   bytes = FPUTS(ifp,distance)     
   dist_hold = distance
   IF i < 17
      distance = convert(VAL(distance) + 100)
   ENDIF
   IF i > 16 .AND. i < 25 
      distance = convert(VAL(distance) + 200)
   ENDIF
   IF i > 24 .AND. i < 29
      distance = convert(VAL(distance) + 300)
   ENDIF         
   IF i = 29
      distance = convert(VAL(distance) + 500)
   ENDIF   
NEXT i

FOR i = 1 TO 6
   bytes = FPUTS(ifp,Ta)     
NEXT i
bytes = FPUTS(ifp,ru)     
bytes = FPUTS(ifp,'rvd.out')
bytes = FPUTS(ifp,'0')
=FCLOSE(ifp)

RETURN
