' PES ADDED CODE BEGINS
REM $INCLUDE: 'ERRECORD.BAS'
' PES ADDED ENDS
10 '-------------Relief Valve Discharge (RVD) Screening Program----------
20 '                           Version 2.0
30 '                           Developed by
40 '                 US EPA  Source Receptor Analysis Branch
50 '                     Model Application Section
60 '                     Original version May, 1986
70 ' Version 2.0 created 12/88 by Dave Guinnup, modified 3/90, D. Guinnup
80 '
90 '   Based on the Hoot, Meroney, and Peterka equations, this screening
100 'technique will estimate for short term denser-than-air gas releases
110 'from vertical stacks or pipes (such as for relief valve discharges):
120 'plume rise, plume touchdown distance, concentration at touchdown, and
130 'the concentrations at up to 30 downwind distances specified by the user.
140 '
150 'Note:  While the US EPA does not require or recommend the use of this
160 '     program, the Agency does provide it as a general service.
170 '
180 '   ALSO NOTE THAT THE CONSERVATIVE "FACTOR OF 5" IS NO LONGER USED
190 '                   IN THIS VERSION OF RVD !!
200 '
210 ' Additional information can be obtained by contacting Dave Guinnup
220 '               at (919) 541-5368 or FTS 629-5368.
230 '
240 '
250 ' Citations:
260 ' Hoot, T.G., R.N. Meroney, and J.A. Peterka (1973). "Wind Tunnel Tests
270 '      of Negatively Buoyant Plumes," EPA-650/3-74-003, U.S. Environmental
280 '      Protection Agency, Research Triangle Park, NC, 104 p.
290 '
300 ' Puttock, J.S., D.R. Blackmore, and G.W. Colenbrander (1982). "Field
310 '      Experiments on Dense Gas Dispersion," Dense Gas Dispersion
320 '      (R.E. Britter and R.F. Griffiths, ed.), Elsevier Scientific
330 '      Publishing Comp., New York, pp 13-41.
340 '
'
' PES ADDED CODE BEGINS
344 DIM ErMsg AS ErRecordType
345 COLOR 15,3
346 ON ERROR GOTO 6000
' PES ADDED ENDS
'
350 KEY OFF
360 LET FMT$ = " #####.#### #####.#### #####.#### #####.####"
370 FT1$ = "    !     ###.#  #####.#  #.#####^^^^   #.####^^^^"
375 FT5$ = "#####.#  #.#####^^^^        !     ###.#     #.####^^^^"
380 FT3$ = "###.#    #   #   #   #   #   #"
390 FT$ = "    !     ###.#  ###.# ####.##   #.#####^^^^   #.#####^^^^"
400 FT2$ = "####.#"
410 FT4$ = "  ##.#    ######.#  ######.#  ######.#  ######.#  ######.#  ######.#"
420 '
430 '  INITIALIZE ARRAYS
440 '
'PES CHANGED DIMENSIONS FROM 30 TO 60 BEGINS
'450 DIM ARHO(6), DEL(6), RI(9, 6), A(9, 6), SG(6), TA(6), RV(9, 6), FR(6), FRH(9, 6)
'460 DIM CALH(6), VHS(9, 6), CRH(9, 6), DRH(9, 6), MWH(9, 6), TH(9, 6),STAB$(6)
'470 DIM DELTA(9, 6), DISTH(9, 6), DISTD(9, 6), DISTF(9, 6), DIST(30), CMAX(30),WSMAX(30),SCMAX$(30)
'480 DIM CONCD(9, 6), CONC(9,6,30), P(6), USTAR(6), V(9), HA(9, 6), L(6)
'
450 DIM ARHO(6), DEL(6), RI(9, 6), A(9, 6), SG(6), TA(6), RV(9, 6), FR(6), FRH(9, 6)
460 DIM CALH(6), VHS(9, 6), CRH(9, 6), DRH(9, 6), MWH(9, 6), TH(9, 6),STAB$(6)
470 DIM DELTA(9, 6), DISTH(9, 6), DISTD(9, 6), DISTF(9, 6), DIST(60), CMAX(60),WSMAX(60),SCMAX$(60)
480 DIM CONCD(9, 6), CONC(9,6,60), P(6), USTAR(6), V(9), HA(9, 6), L(6)
'PES CHANGED DIMENSIONS FROM 30 TO 60  ENDS
'
490 P(1) = .15: P(2) = .15: P(3) = .2: P(4) = .25: P(5) = .3: P(6) = .3
500 V(1)=1!:V(2)=2!:V(3)=3!:V(4)=4!:V(5)=5!:V(6)=8!:V(7)=10:V(8)=15!:V(9)=20!
510 STAB$(1)="A":STAB$(2)="B":STAB$(3)="C":STAB$(4)="D":STAB$(5)="E":STAB$(6)="F"
520 NWS=9:IBAT=0
530 FOR I = 1 TO 6: TA(I) = 298: USTAR(I) = .06: NEXT I
540 LET D$ = DATE$
550 'COLOR 3, 1: CLS
560 '
570 '
580 '  INTERACTIVE DATA ENTRY
590 '
600 '
610 '
620 '  TO RUN RVD IN BATCH ONLY USING RVDIN.DAT AS INPUT, REMOVE
630 '  COMMENT DELIMITER FROM THE NEXT LINE
640  IBAT=1:GOTO 2340
650 '
660 PRINT "-----------Relief Valve Discharge (RVD 2.0) Screening Program------- "
670 PRINT "                         December 1988                                      "
680 PRINT ""
690 PRINT "   Based on the Hoot, Meroney, and Peterka equations, this"
700 PRINT "screening technique will estimate for short term denser-than-"
710 PRINT "air gas releases from vertical stacks or pipes (such as for"
720 PRINT "relief valve discharges): plume rise, plume touchdown distance,"
730 PRINT "centerline concentration at touchdown, and the centerline"
740 PRINT "concentrations at up to 30 user-specified downwind distances."
750 PRINT ""
760 PRINT " Notes:": PRINT ""
770 PRINT "   *  'Pollutant' refers to the chemical in whose concentration"
780 PRINT "            you are specifically interested.": PRINT ""
790 PRINT "   *  'Exhaust gas' refers to the entire gas stream which is"
800 PRINT "            being released."
810 PRINT "   *  This version of RVD includes no 'safety factors' (see manual)."
820 PRINT ""
830 PRINT "   *  Concentration estimates are most appropriate for neutral "
840 PRINT "          to stable atmospheric conditions (see manual)."
850 GOSUB 5440
860 PRINT "YOU MAY ENTER DATA FROM THE KEYBOARD OR YOU MAY USE"
870 PRINT "AN EXISTING INPUT FILE AND EDIT THE APPROPRIATE VALUES."
880 PRINT ""
890 IF ICALC = 1 THEN PRINT "TO USE SAME STARTING DATA BASE AS THE PREVIOUS"
900 IF ICALC = 1 THEN INPUT "RUN, ENTER 1 NOW -- ",IOLD
910 IF IOLD = 1 GOTO 1230
920 INPUT "DATA INPUT VIA KEYBOARD(0) OR EXISTING FILE(1) -- "; INDAT
930 IF INDAT = 0 GOTO 1020
940 INPUT "FILENAME -- "; FIL$
950 OPEN "I", #2, FIL$
960 INPUT #2, T$, QC, EXITV, D, T0, HS, VOL, MW, MO, MWC, TDUR, TAV, PR, NWS
970 FOR J = 1 TO NWS: INPUT #2, V(J): NEXT J
980 INPUT #2, ISD: FOR J = 1 TO ISD: INPUT #2, DIST(J): NEXT J
990 FOR J = 1 TO 6: INPUT #2, TA(J): NEXT J
1000 INPUT #2, IWSP
1010 CLOSE #2: GOTO 1230
1020 INPUT "Enter title (with out commas) -- ", T$: IF II = 1 GOTO 1230
1030 INPUT "Enter Emission Rate of Specific Pollutant (kg/sec) -- ", QC
1040 IF II = 1 THEN II2 = 1: GOTO 1170
1050 INPUT "Enter Exhaust Gas Exit Velocity (m/sec) -- ", EXITV: IF II = 1 GOTO 1230
1060 INPUT "Enter Stack Diameter (m) -- ", D: IF II = 1 GOTO 1230
1070 INPUT "Enter Exit Gas Temperature (K) -- ", T0: IF II = 1 GOTO 1230
1080 INPUT "Enter Stack Height (m) -- ", HS: IF II = 1 GOTO 1230
1090 INPUT "Enter Pollutant Concentration (vol%) -- ", VOL: IF II = 1 THEN II2 = 1: GOTO 1230
1100 INPUT "Enter Pollutant Molecular Weight -- ", MWC: IF II = 1 THEN II2 = 1: GOTO 1230
1110 PRINT "You must choose to enter either:"
1120 PRINT "   (1) Exhaust Gas Molecular Weight, or"
1130 PRINT "   (2) Exhaust Gas Mass Flow Rate."
1140 PRINT "": INPUT "Choose (1) or (2) -- ", ICH
1150 ON ICH GOTO 1160, 1190
1160 INPUT "Enter Exhaust Gas Molecular Weight -- ", MW
1170 MO = 100! * QC * MW / VOL / MWC: IF II2 = 1 GOTO 1200: IF II = 1 GOTO 1230
1180 GOTO 1210
1190 INPUT "Enter Exhaust Gas Mass Flow Rate (kg/sec) -- ", MO
1200 MW = MO * VOL * MWC / 100! / QC: IF II = 1 GOTO 1230
1210 INPUT "Enter duration of release (min) -- ", TDUR: IF II = 1 GOTO 1230
1220 INPUT "Enter desired averaging time (min) -- ", TAV: IF II = 1 GOTO 1230
1230 PRINT "#1. "; T$
1240 PRINT "#2. Pollutant emission rate (kg/sec) = "; QC
1250 PRINT "#3. Exit gas velocity (m/sec)= "; EXITV
1260 PRINT "#4. Diameter (m) = "; D
1270 PRINT "#5. Exit Temperature (K)= "; T0
1280 PRINT "#6. Stack Height (m) = "; HS
1290 PRINT "#7. Pollutant Concentration (volume %) = "; VOL
1300 PRINT "#8. Pollutant Molecular Weight = "; MWC
1310 PRINT "#9. Exhaust Gas Molecular Weight = "; MW
1320 PRINT "#10. Exhaust Gas Mass Flow Rate (kg/sec) = "; MO
1330 PRINT "#11. Duration of Release (min) = "; TDUR
1340 PRINT "#12. Averaging Time (min) = "; TAV
1350 PRINT ""
1360 PRINT "If a value is incorrect, enter its number."
1370 INPUT "If all values are OK, enter 0. -- ", ICOR
1380 IF ICOR = 0 GOTO 1400
1390 II = 1: ON ICOR GOTO 1020, 1030, 1050, 1060, 1070, 1080, 1090, 1100, 1160, 1190, 1210, 1220
1400 IF INDAT = 1 GOTO 1480
1410 INPUT "Use default wind speeds (1) or input your own (2) -- ", NWND
1420 IF NWND = 1 GOTO 1480
1430 INPUT "Enter desired number of wind speeds (maximum=9) -- ", NWS
1440 PRINT "Enter "; NWS; " wind speed(s) (m/sec) separated by <Enter>s"
1450 FOR IJ = 1 TO NWS
1460 INPUT ; V(IJ): IF V(IJ) >= 1! GOTO 1470 ELSE PRINT "  No wind speeds less than 1.0 m/s are allowed!": GOTO 1460
1470 NEXT IJ
1480 PRINT ""
1490 PRINT "Here are your wind speeds:":IF NWND = 1 THEN PRINT "(These are the defaults)"
1500 FOR IJ = 1 TO NWS
1510 PRINT USING FMT$; V(IJ): NEXT IJ
1520 INPUT "Is everything OK? (Y or n) -- ", ANS$
1530 IF ANS$ = "N" OR ANS$ = "n" GOTO 1430
1540 IF INDAT = 1 GOTO 1650
1550 INPUT "Number of downwind receptor distances (max = 30) -- "; ISD
1560 IF ISD > 1 GOTO 1620
1570 INPUT "Enter the nearest fenceline distance (m) -- ", DIST(1)
1580 PRINT "The nearest fenceline is ";DIST(1);" (m) away"
1590 INPUT "Is this correct? (Y or n) -- ",ANS$
1600 IF ANS$ = "N" OR ANS$ = "n" GOTO 1570
1610 GOTO 1690
1620 PRINT "Enter"; ISD; " specific distances (m) separated by <Enters>"
1630 PRINT "NOTE: The first distance entered should be the nearest fenceline distance."
1640 FOR J = 1 TO ISD: INPUT ; DIST(J): NEXT J
1650 PRINT "": PRINT "Receptor distances are:"
1660 FOR J = 1 TO ISD: PRINT USING FMT$; DIST(J): NEXT J
1670 INPUT "Are values correct? (Y or n) -- ", ANS$
1680 IF ANS$ = "N" OR ANS$ = "n" GOTO 1550
1690 IF INDAT = 1 GOTO 1790
1700 PRINT "Ambient temperatures (degrees K) vs stability class default to:"
1710 PRINT ""
1720 PRINT "(A) 298   (B) 298   (C) 298   (D) 298   (E) 298   (F) 298"
1730 PRINT ""
1740 INPUT "Would you like to enter your own? (y or N) -- ", ANS$
1750 IF ANS$ <> "Y" AND ANS$ <> "y" GOTO 1860
1760 PRINT "Enter the ambient air temperatures (K) for each stability"
1770 PRINT " separated by <Enter>s"
1780 FOR I = 1 TO 6: INPUT ; TA(I): NEXT I
1790 PRINT ""
1800 PRINT "Ambient temperatures vs stability class are:":PRINT ""
1810 PRINT "     A         B         C         D         E         F"
1820 PRINT USING "  ####.#  "; TA(1), TA(2), TA(3), TA(4), TA(5), TA(6)
1830 PRINT "":INPUT "Are values correct? (Y or n) -- ", ANS$
1840 IF ANS$ = "N" OR ANS$ = "n" GOTO 1760
1850 IF INDAT = 1 GOTO 1890
1860 PRINT "Wind speed profile exponents are for (0) urban"
1870 PRINT " or (1) rural conditions - choose one: -- "
1880 INPUT IWSP
1890 IF IWSP = 1 THEN P(1) = .07: P(2) = .07: P(3) = .1: P(4) = .15: P(5) = .35: P(6) = .55
1900 IF IWSP = 0 THEN PRINT "":PRINT "Dispersion is for URBAN location"
1910 IF IWSP = 1 THEN PRINT "":PRINT "Dispersion is for RURAL location"
1920 INPUT "Is this OK? (Y or n) -- ", ANS$
1930 IF ANS$ =  "N" OR  ANS$ =  "n" GOTO 1860
1940 PRINT ""
1950 PRINT ""
1960 PRINT "OUTPUT OPTIONS -- (0) SCROLL TO SCREEN"
1970 PRINT "                  (1) HARDCOPY"
1980 PRINT "                  (2) DISK FILE"
1990 PRINT"":INPUT "Choose 0, 1, or 2 -- ",ICOP:IF ICOP <> 2 GOTO 2030
2000 PRINT "":INPUT "Output filename";FILOUT$
2010 PRINT "":PRINT "Output file is ";FILOUT$:INPUT "Is this OK? (Y or n) -- ",ANS$
2020 IF ANS$ = "N" OR ANS$ = "n" GOTO 2000
2030 IPLTPRT=1:PRINT "":INPUT "Do you want a plot? (Y or n) -- ", ANS$
2040 IF ANS$="N" OR ANS$="n" THEN IPLTPRT=0
2050 PRINT "":PRINT "This ends the interactive data entry portion of RVD"
2060 PRINT "":PRINT "Your input data are being stored in the file RVDIN.DAT"
2070 '
2080 '  END INTERACTIVE DATA ENTRY
2090 '
2100 '
2110 '  STORE INPUT VALUES IN RVDIN.DAT
2120 '
2130 '
2140 OPEN "O", #2, "RVDIN.DAT"
2150 PRINT #2, T$
2160 PRINT #2, QC
2170 PRINT #2, EXITV
2180 PRINT #2, D
2190 PRINT #2, T0
2200 PRINT #2, HS
2210 PRINT #2, VOL
2220 PRINT #2, MW
2230 PRINT #2, MO
2240 PRINT #2, MWC
2250 PRINT #2, TDUR
2260 PRINT #2, TAV
2270 PRINT #2, ICOP
2280 PRINT #2, NWS
2290 FOR J = 1 TO NWS: PRINT #2, V(J); : NEXT J: PRINT #2, ""
2300 PRINT #2, ISD: FOR J = 1 TO ISD: PRINT #2, DIST(J); : NEXT J: PRINT #2, ""
2310 FOR J = 1 TO 6: PRINT #2, TA(J); : NEXT J: PRINT #2, ""
2320 PRINT #2, IWSP:PRINT #2, FILOUT$:PRINT #2, IPLTPRT
2330 CLOSE #2
2340 '
2350 '  BEGIN BATCH RVD OPERATION
2360 '
2370 '  READ INPUT VALUES FROM RVDIN.DAT
2380 '
2390 OPEN "I", #2, "RVDIN.DAT"
2400 INPUT #2, T$, QC, EXITV, D, T0, HS, VOL, MW, MO, MWC, TDUR, TAV, ICOP, NWS
2410 FOR J = 1 TO NWS: INPUT #2, V(J): NEXT J
2420 INPUT #2, ISD: FOR J = 1 TO ISD: INPUT #2, DIST(J): NEXT J
2430 FOR J = 1 TO 6: INPUT #2, TA(J): NEXT J
2440 INPUT #2, IWSP, FILOUT$, IPLTPRT
2450 CLOSE #2
2460 '
2470 '
2480 '  Begin RVD Calculations
2490 '
2500 '
'2510 PRINT "":PRINT "   RVD simulation is underway"
2520 TRAT = TDUR / TAV
2530 IF TDUR > TAV THEN TRAT = 1!: IF TAV < 60 THEN TRAT = TRAT * (60 / TAV) ^ .2
2540 RHO = 1.183 * MW / 29! * 298 / T0
2550 VM = 29! / (1183!)
2560 CFM = EXITV * 3.14159 * D ^ 2 / 4!
2570 ' Acceleration of gravity (m/sec2)
2580 LET G = 9.8
2590 CONCG = 5000! * MWC / VM
2600 '
2610 ' Because the ratio (friction velocity)/(wind speed at z=10m) is used
2620 ' in place of the friction velocity, the "V(I)^2" term is included
2630 ' in the Richardson number calculations.
2640 '
2650 FOR J = 1 TO 6
2660 ' Calculate the ambient air density which is dependent upon temperature.
2670 LET ARHO(J) = 1.183 * 298! / TA(J)
2680 LET DEL(J) = (RHO - ARHO(J)) / ARHO(J)
2690 IF DEL(J) > 0 GOTO 2710
2700 FOR I = 1 TO NWS: A(I, J) = 0: NEXT I
2710 NEXT J
'
2715 LOCATE 14,35:PRINT "10 % Complete"
'
2720 FOR J = 1 TO 6
2730 FOR I = 1 TO NWS
2740 ' Richardson number test
2750 ' If RI is less than or equal to 30 then treat as a stack source.
2760 ' Wind speed at stack height.
2770 LET VHS(I, J) = V(I) * (HS / 10!) ^ P(J)
2780 LET RI(I, J) = (G * DEL(J) * MO) / (VHS(I, J) * D * RHO * (USTAR(J) ^ 2!) * (V(I) ^ 2!))
2790 IF RI(I, J) <= 30! THEN GOTO 2810
2800 LET A(I, J) = 1
2810 NEXT I
2820 NEXT J
'
2825 LOCATE 14,35:PRINT "20 % Complete"
'
2830 ' The following loop identifies those wind speed and stability class
2840 ' combinations which do not exist based on the Turner (1964)
2850 ' definitions of stability classes (see the CRSTER User's Manual).
2860 FOR J = 1 TO 6
2870 IF J = 4 GOTO 3040
2880 FOR I = 1 TO NWS
2890 IF J = 3 GOTO 3030
2900 IF J > 1 THEN GOTO 2930
2910 IF V(I) >= 3.1 THEN A(I, J) = 2
2920 GOTO 3030
2930 IF J = 2 THEN GOTO 2970
2940 IF J = 5 THEN GOTO 2990
2950 IF V(I) >= 3.1 THEN A(I, J) = 2
2960 GOTO 3030
2970 IF V(I) >= 5.1 THEN A(I, J) = 2
2980 GOTO 3030
2990 IF V(I) < 2! THEN A(I, J) = 2
3000 IF V(I) > 5! THEN A(I, J) = 2
3010 GOTO 3030
3020 IF V(I) < 2! THEN A(I, J) = 2
3030 NEXT I
3040 NEXT J
'
3045 LOCATE 14,35:PRINT "30 % Complete"
'
3050  N = 0
3060  FOR I = 1 TO NWS
3070  FOR J = 1 TO 6
3080  IF A(I, J) <> 1 THEN N = N + 1
3090  NEXT J
3100 NEXT I
'
3105 LOCATE 14,35:PRINT "35 % Complete"
'
3110  IF N = NWS * 6 THEN IGETOUT=1
3120 FOR J = 1 TO 6
3130 ' Vertical Densimetric Froude Number
3140 IF DEL(J) <= 0 GOTO 3200
3150 LET FR(J) = EXITV * (((RHO / (RHO - ARHO(J))) / (G * D)) ^ .5)
3160 ' Specific Gravity
3170 LET SG(J) = RHO / ARHO(J)
3180 ' Plume rise for negatively bouyant jet at calm conditions.
3190 LET CALH(J) = 2.96 * FR(J) * D
3200 FOR I = 1 TO NWS
3210 IF A(I, J) <> 1 THEN GOTO 3510
3220 ' Wind speed at stack height.
3230 LET VHS(I, J) = V(I) * (HS / 10!) ^ P(J)
3240 ' Velocity ratio.
3250 LET RV(I, J) = EXITV / VHS(I, J)
3260 ' Plume rise for negatively bouyant jet with crosswind.
3270 LET CRH(I, J) = 1.32 * D * (RV(I, J) ^ .333) * (SG(J) ^ .333) * (FR(J) ^ .667)
3280 LET H = CRH(I, J)
3290 IF CRH(I, J) > CALH(J) THEN LET H = CALH(J)
3300 LET HA(I, J) = H
3310 ' Dilution Ratio at maximum plume rise.
3320 DRH(I, J) = ((H ^ 1.85) * VHS(I, J) * MW * 298! * (D ^ .15)) / (2150! * MO * .02445 * TA(J))
3330 LET MWH(I, J) = (MW + 28.96 * (DRH(I, J) - 1!)) / DRH(I, J)
3340 ' Temperature at maximum plume rise
3350 LET TH(I, J) = TA(J) - (MW * (TA(J) - T0) / (MWH(I, J) * DRH(I, J)))
3360 LET DELTA(I, J) = (MWH(I, J) * TA(J) / (TH(I, J) * 28.96)) - 1!
3370 IF DELTA(I, J) <= .005 THEN GOTO 3500
3380 ' Distance to maximum plume rise.
3390 LET DISTH(I, J) = D * (FR(J) ^ 2!) / RV(I, J)
3400 ' Concentration at plume touchdown.
3410 LET CONCD(I, J) = 5.100001E+09 * QC * (2! * H + HS) ^ (-1.95) / (VHS(I, J) * (D ^ .05))
3420 ' Horizontal Densimetric Froude Number
3430 LET FRH(I, J) = VHS(I, J) * (((ARHO(J) / (RHO - ARHO(J))) / (G * D)) ^ .5)
3440 LET CSQR = (((H / D) ^ 3! * ((2! + HS / H) ^ 3! - 1!))) ^ .5
3450 ' Distance to plume touchdown.
3460 LET DISTD(I, J) = DISTH(I, J) + .56 * FRH(I, J) * CSQR * D * (RV(I, J) ^ (-.5))
3470 ' Distance at which 5000 ppm occurs.
3480 LET DISTF(I, J) = DISTD(I, J) * ((CONCG / CONCD(I, J)) ^ (-1.538))
3490 GOTO 3530
3500 LET A(I, J) = 0
3510 LET CONCD(I, J) = 0!
3520 LET DISTD(I, J) = 0!
3530 NEXT I
3540 NEXT J
'
3545 LOCATE 14,35:PRINT "45 % Complete"
'
3550 '
3560 ' Calculation of post-touchdown concentrations
3570 '
3579 CMX = 0!:KX = 0: IX = 0: JX = 0
3580 FOR J = 1 TO 6
3600 FOR K = 1 TO ISD
3610 FOR I = 1 TO NWS
3620 IF A(I, J) <> 1 GOTO 3730
3630 LET DIFF = DIST(K) - DISTD(I, J)
3640 IF K > 1 THEN GOTO 3650
3641 IF DIFF > 0 THEN GOTO 3660
'3642 IF K = 1 AND DIFF < 0! THEN CMX=CONCD(I,J):IX=I:JX=J:DMX=DISTD(I,J):GOTO 3730
3642 IF CONCD(I,J) > CMX THEN CMX=CONCD(I,J):IX=I:JX=J:DMX=DISTD(I,J):GOTO 3730
3650 IF DIFF < 0! THEN GOTO 3730
3660 IF DISTF(I, J) < DISTD(I, J) THEN DISTF(I, J) = DISTD(I, J)
3670 IF DIST(K) < DISTF(I, J) THEN GOTO 3700
3680 CONC(I,J,K) = CONCD(I,J)*((DISTF(I,J)/DISTD(I,J))^(-.65))*((DIST(K)/DISTF(I,J))^(-1.7))
3690 GOTO 3720
3700 LET CONC(I,J,K) = CONCD(I,J) * ((DIST(K) / DISTD(I, J)) ^ (-.65))
3710 IF K > 1 THEN GOTO 3730
3720 IF CONC(I,J,K) > CMX THEN CMX=CONC(I,J,K):IX=I:JX=J:DMX=DIST(K)
3730 NEXT I
3740 NEXT K
3750 NEXT J
'
3755 LOCATE 14,35:PRINT "60 % Complete"
'
3760 ICALC = 1

'PES added code begins
'Get max conc for windspeed and stab class
3761 FOR K = 1 TO ISD
3762   CMAX(K) = 0.0 : WSMAX(K) = V(1) : SCMAX$(K) = STAB$(1)
3763   FOR I = 1 TO NWS
3764      FOR J = 1 to 6
3765         IF (CONC(I,J,K) >= CMAX(K)) THEN CMAX(K) = CONC(I,J,K):WSMAX(K) = V(I):SCMAX$(K)=STAB$(J)
3766      NEXT J
3767   NEXT I
3768 NEXT K
'  'Save data to file
'3769 OPEN "graph.fil" FOR OUTPUT AS #5
3769 OPEN "rvd.fil" FOR OUTPUT AS #5
3770 PRINT #5, T$
3771 PRINT #5, ISD+1
3772 XFEN=(DIST(1))
3773 PRINT #5, XFEN
3774 PRINT #5, CMX*TRAT
3775 PRINT #5, DMX
3777 FOR K = 1 TO ISD
3778    PRINT #5, CMAX(K)*TRAT
3779    PRINT #5, DIST(K)
3780    IF K = ISD THEN GOTO 3783
3781    IF (DMX >= DIST(K)) AND (DMX<DIST(K+1)) THEN PRINT #5, CMX*TRAT:PRINT #5,DMX
3782 NEXT K
3783 CLOSE #5
'
3785 LOCATE 14,35:PRINT "65 % Complete"
'
'PES added code ends

'3770 '
'3780 '  OUTPUT RESULTS TO DESIGNATED AREA
'3790 '
3800 IF ICOP = 0 GOTO 3840
3810 IF ICOP = 2 GOTO 3850
3820 OPEN "O", #1, "LPT1:": IPR = 1
3830 GOTO 3860
3840 OPEN "O", #1, "SCRN:": GOTO 3860
3850 OPEN "O", #1, FILOUT$: IPR = 1:IFIL=1
'PES MODIFIED CODE BEGINS
3860 PRINT #1, T$; "    "; D$
'PES MODIFIED CODE ENDS
3870 PRINT #1, " "
3880 PRINT #1, "                                Input Data"
3890 PRINT #1, " "
3900 PRINT #1, "Pollutant emission rate (kg/sec) = "; QC
3910 PRINT #1, "Exit gas velocity (m/sec)= "; EXITV
3920 PRINT #1, "Exit Temperature (K)= "; T0
3930 PRINT #1, "Stack Height (m) = "; HS; "    Diameter (m) = "; D
3940 PRINT #1, "Pollutant Concentration (volume %) = "; VOL
3950 PRINT #1, "Exhaust Gas Density (kg/m3) = "; RHO
3960 PRINT #1, "Exhaust Gas Molecular Weight = "; MW
3970 PRINT #1, "Exhaust Gas Mass Flow Rate (kg/sec) = "; MO
3980 PRINT #1, "Pollutant Molecular Weight = "; MWC
3990 PRINT #1, "Release duration (min) = "; TDUR; " Av. Time (min) = "; TAV
4000 PRINT #1, "Wind Speeds (m/sec) = ";
4010 FOR I = 1 TO NWS - 1: PRINT #1, USING "##.#   "; V(I);
4015 IF I = 5 THEN PRINT #1, "":PRINT #1,"                      ";
4020 NEXT I: PRINT #1, USING "##.#"; V(NWS)
4030 IF ISD > 1 GOTO 4060
4040 PRINT #1, "Distance (m) = "; DIST(1)
4050 GOTO 4080
4060 PRINT #1, "Distances (m) = ";
'PES MODIFIED CODE BEGINS
'4070 FOR I = 1 TO ISD: PRINT #1, DIST(I); SPC(2); : NEXT I: PRINT #1, ""
4062 I = 1
4064 WHILE I <= ISD
4066    IF (I MOD 7) > 0 THEN GOTO 4071
4068    PRINT #1, DIST(I):IF I <> ISD THEN PRINT #1, "                " ;
4070    GOTO 4072
4071    PRINT #1, DIST(I); SPC(2);
4072    I = I + 1
4074 WEND
4076 IF (ISD MOD 7) > 0 THEN PRINT #1, ""
'PES MODIFIED CODE ENDS
4080 PRINT #1, "Ambient Temperature (K) = "; TA(1); TA(2); TA(3); TA(4); TA(5); TA(6)
4090 IF IWSP = 0 THEN PRINT #1, "Urban Wind Speed Profile Exponents": GOTO 4101
'
'PES ADDED CODE BEGINS
'
4095 LOCATE 14,35:PRINT "70 % Complete"
'
4096 OPEN "RVDMAX" FOR OUTPUT AS #9
4097 PRINT #9, CMX*TRAT
4098 CLOSE #9
'PES ADDED CODE ENDS
'
4100 PRINT #1, "Rural Wind Speed Profile Exponents"
'4101 '
'4102 '  MAX IMPACT INFORMATION
'4103 '

'PES added code begins
4101 PRINT #1,"":PRINT #1,""
4102 PRINT #1,"*************************************************************"
4103 PRINT #1,"***              SUMMARY OF RVD MODEL RESULTS             ***"
4104 PRINT #1,"*************************************************************"
4105 PRINT #1,""
'PES added code end
'PES moved code begins
4106 PRINT #1, "Maximum offsite concentration is ";CMX*TRAT;" ug/m3"
4107 PRINT #1, "                or equivalently  ";CMX*TRAT*.0245/MWC;" ppm"
4108 PRINT #1, "                 occurring at    ";DMX;" m downwind "
4109 PRINT #1, "              when wind speed is ";V(IX);" m/sec"
4110 PRINT #1, "                and stability is  ";STAB$(JX)
4111 PRINT ""
'PES moved code ends
'PES added code begins
4112 PRINT #1,""
4113 PRINT #1,"*************************************************************"
4114 PRINT #1,"***      REMEMBER TO INCLUDE BACKGROUND CONCENTRATIONS    ***"
4115 PRINT #1,"*************************************************************"
4116 GOSUB 5600 'RVD AUTOMATED DISTANCES
'PES added code ends

4118 GOSUB 5440
4120 PRINT #1, "":PRINT #1, "":PRINT #1, ""
4130 PRINT #1, "          Dense Gas Behavior"
4140 PRINT #1, " "
4150 PRINT #1, "           Stability  Class"
4160 PRINT #1, " "
4170 PRINT #1, " Wind    A   B   C   D   E   F"
4180 PRINT #1, "Speed"
4190 NLI = 7
4200 FOR I = 1 TO NWS
4210 PRINT #1, USING FT3$;V(I);A(I,1);A(I,2);A(I,3);A(I,4);A(I,5);A(I,6)
4220 NLI = NLI + 1: IF NLI > 20 THEN GOSUB 5440
4230 NEXT I
'
4235 LOCATE 14,35:PRINT "75 % Complete"
'
4240 PRINT #1, " "
4250 PRINT #1, "(0=Non-Dense Behavior   1=Dense Gas Behavior"
4260 PRINT #1, "     2=Combinations that cannot occur)"
4270 PRINT #1, " "
4280 GOSUB 5440
4290 PRINT #1, "             Release Richardson Numbers"
4300 PRINT #1, " "
4310 PRINT #1, "                   Stability Class"
4320 PRINT #1, " "
4330 PRINT #1, "   Wind       A         B         C         D         E         F"
4340 PRINT #1, "   Speed"
4350 NLI = 6
4360 FOR I = 1 TO NWS
4370 FOR J = 1 TO 6: IF RI(I, J) > 1000000! THEN RI(I, J) = 999999.9
4375 NEXT J
4380 PRINT #1, USING FT4$; V(I); RI(I, 1); RI(I, 2); RI(I, 3); RI(I, 4); RI(I, 5); RI(I, 6)
4390 NEXT I
'
4395 LOCATE 14,35:PRINT "80 % Complete"
'
4400 IF IGETOUT = 1 GOTO 5380
4410 GOSUB 5440
4420 PRINT #1, "":PRINT #1, "":PRINT #1, ""
4430 PRINT #1, "             Dense Plume Trajectory"
4440 PRINT #1, "                                             "
4450 PRINT #1, "Stability  Wind Plume Touchdown        Touchdown  "
4460 PRINT #1, "  Class   Speed  Rise  Distance      Concentration"
4470 PRINT #1, "         (m/sec)  (m)     (m)      (ug/m3)     (ppm)    "
4480 NLI = NLI + 6
4490 FOR J = 1 TO 6
4500 PRINT #1, "----------------------------------------------------------": NLI = NLI + 1
4510 FOR I = 1 TO NWS
4520 IF A(I, J) <> 1 GOTO 4550
4530 PRINT #1, USING FT$; STAB$(J); V(I); HA(I, J); DISTD(I, J); CONCD(I, J) * TRAT; CONCD(I, J) * .0245/ MWC * TRAT
4540 NLI = NLI + 1: IF NLI > 19 THEN GOSUB 5440
4550 NEXT I
4560 NEXT J
'
4565 LOCATE 14,35:PRINT "85 % Complete"
'
4570 GOSUB 5440
4580 PRINT #1, "":PRINT #1, ""
4590 PRINT #1, " Concentrations at Specific Receptor Distances"
4600 PRINT #1, "                                                 "
4610 PRINT #1, "Stability  Wind Distance Concentration           "
4620 PRINT #1, "  Class   Speed                                  "
4630 PRINT #1, "         (m/sec)   (m)      (ug/m3)      (ppm)        "
4640 NLI = 6
4650 FOR J = 1 TO 6
4660 PRINT #1, "--------------------------------------------------": NLI = NLI + 1
4670 FOR K = 1 TO ISD
4680 FOR I = 1 TO NWS
4690 IF CONC(I,J,K)=0! GOTO 4720
4700 PRINT #1, USING FT1$; STAB$(J); V(I); DIST(K); CONC(I,J,K) * TRAT; CONC(I,J,K) * .0245 / MWC * TRAT
4710 NLI = NLI + 1: IF NLI > 19 THEN GOSUB 5440
4720 NEXT I
4730 PRINT #1, "":NEXT K
4740 NEXT J
'
4745 LOCATE 14,35:PRINT "100 % Complete"
FOR I = 1 TO 1000: NEXT I
'
'code commented out by PES begins
'4750 '
'4760 '  MAX IMPACT INFORMATION
'4770 '
'4780 PRINT #1,"":PRINT #1,""
'4790 PRINT #1, "Maximum offsite concentration is ";CMX*TRAT;" ug/m3"
'4800 PRINT #1, "                or equivalently  ";CMX*TRAT*.0245/MWC;" ppm"
'4810 PRINT #1, "                 occurring at    ";DMX;" m downwind
'4820 PRINT #1, "              when wind speed is ";V(IX);" m/sec"
'4830 PRINT #1, "                and stability is  ";STAB$(JX)
'4840 PRINT ""
'4850 '
'4860 '
'4870 '  Plot of centerline concentration vs downwind distance
'4880 '
'4890 '


'4900 IF IPLTPRT=0 GOTO 5330
' code commented out by PES ends

4905 GOTO 5390

4910 IF IFIL=1 GOTO 4930
4920 IF IPR=1 GOTO 5340
4930 PRINT "The next screen will be a plot of concentration vs downwind"
4940 PRINT "   distance for the worst-case meteorological conditions."
4950 PRINT "":PRINT "                 Press any key to view plot"
4960 GOSUB 5480
4970 SCREEN 9:IPLF=0
4980 WINDOW (-30,-20) - (130,90):LINE (0,0)-(100,0)
4990 LINE (0,0) - (0,50):LOCATE 23,30:PRINT "Downwind distance (km)"
5000 FOR I=1 TO 5:LINE (20*I,0)-(20*I,-1):LINE (0,10*I)-(-2,10*I):NEXT I
5010 LOCATE 14,3:PRINT "Conc":LOCATE 15,3:PRINT "ug/m3"
5020 FOR I=1 TO 5:LOCATE 22,14+10*I:PRINT .2*I:NEXT I
5030 INCON=INT(LOG(CONCD(IX,JX)*TRAT)/LOG(10))+1:YLIM=10!^INCON
5040 LOCATE 10,9:PRINT"10E";INCON-1:LOCATE 12,10:PRINT "8E";INCON-1
5050 LOCATE 17,10:PRINT "4E";INCON-1:LOCATE 19,10:PRINT "2E";INCON-1
5060 LOCATE 14,10:PRINT "6E";INCON-1
5070 YSCAL=50!/YLIM:XSCAL=.1:XF=DISTF(IX,JX)*XSCAL
5080 XFEN=INT(DIST(1)*XSCAL)
5090 Y1=INT(CONCD(IX,JX)*TRAT*YSCAL):X1=INT(DISTD(IX,JX)*XSCAL):XD=X1
5100 LINE (X1,Y1) - (X1,Y1):DRAW "e2 g4 e2 h2 f4 h2 l2 r4"
5110 FOR I=1 TO 50:X2=X1+2*I:IF X2>100! GOTO 5160:IF X2>XF GOTO 5130
5120 Y2=Y1*(X2/XD)^(-.65):GOTO 5140
5130 Y2=Y1*((X2/XF)^(-1.7))*((XF/XD)^(-.65))
5140 IF X2>=XFEN THEN YFEN=Y2
5150 LINE (X1,Y1) - (X2,Y2):X1=X2:Y1=Y2:NEXT I
5160 FOR I=0 TO 6
5170 LINE (XFEN,4*I)-(XFEN,4*I+2)
5180 IF 4*I>=YFEN GOTO 5200
5190 NEXT I
5200 LOCATE 12,45:PRINT "- - - Fenceline"
5210 LOCATE 8,29:PRINT "RVD Simulation Results"
5220 LOCATE 13,45:PRINT "  *   Touchdown"
5230 LOCATE 14,45:PRINT " ";V(IX);"  m/sec wind"
5240 LOCATE 15,45:PRINT "  "STAB$(JX);"   stability"
5250 LOCATE 9,22:PRINT "CENTERLINE GROUNDLEVEL CONCENTRATIONS"
5260 JTI=LEN(T$):LOCATE 10,40-JTI/2:PRINT T$
5270 IF IPLF = 0 GOTO 5300
5280 'LCOPY
5290 GOSUB 5480:GOTO 5330
5300 LOCATE 24,1:PRINT "Would you like a hardcopy of this plot? (y or N)"
5310 INPUT "(your system may or may not allow this option)",ANS$
5320 IF ANS$ = "Y" OR ANS$ = "y" GOTO 5340
5330 SCREEN 9:IPLF=0:GOTO 5390
5340 SCREEN 2:IPLF=1:GOTO 4980
5350 '
5360 '  EXIT FOR NO DENSE GAS EFFECTS
5370 '
5380 PRINT #1, "": PRINT #1, "Treat as neutrally-buoyant for all stabilities and wind speeds"
5390 CLOSE #1:
5393 KILL "ERROR.OUT" :END
5400 IF IBAT=1 GOTO 5430
5410 INPUT "Another RVD run? (y or N) -- ", ANS$
5420 IF ANS$ = "y" OR ANS$ = "Y" THEN IPR = 0:GOTO 860
5430 SYSTEM
5440 IF IPR = 1 THEN RETURN
5450 PRINT "": PRINT "": PRINT "                  Press any key to continue"
5460 A$ = INKEY$: IF A$ = "" THEN 5460
5470 NLI = 0:  RETURN
5480 PRINT ""
5490 A$ = INKEY$: IF A$ = "" THEN 5490
5500 NLI = 0:  RETURN

'PES added code begins
5600 '
5610 ' RVD DISTANCES
5620 '
5625 PRINT #1,"":PRINT #1,""
5630 PRINT #1,"***********************"
5640 PRINT #1,"***  RVD DISTANCES  ***"
5650 PRINT #1,"***********************"
5660 PRINT #1, "                                                 "
5670 PRINT #1, "Distance Concentration  Stability  Wind           "
5680 PRINT #1, "                          Class    Speed          "
5690 PRINT #1, "  (m)      (ug/m3)                (m/sec)      (ppm)  "
5720 PRINT #1, "------------------------------------------------------"
5730 FOR K = 1 TO ISD
5760    PRINT #1, USING FT5$;DIST(K); CMAX(K) * TRAT; SCMAX$(K); WSMAX(K); CMAX(K) * .0245 / MWC * TRAT
5800 NEXT K
5810 PRINT #1,""
5820 RETURN


6000 'Error routine
6010 OPEN "ErMsg.Dat" FOR RANDOM AS #7 LEN = 35
6020 GET #7,err,ErMsg.ErText:ErrorMsg$ = LTRIM$(RTRIM$(ErMsg.ErText))
6030 PRINT ErrorMsg$
6040 CLOSE #7
6050 END
'PES added code ends
