* system : tscreen
* program : s22
* author : Kevin Stroupe, PES
* update author: Gerry Chike, Chike
* update purpose: * changed ideal gas constant rate (R) from 
*						  R = .08206 to R = 8314
*						* changed ambient pressure (Pa) from Pa = 1
*						  to Pa = 101325


* Constants
R 	= 8314			&& ideal gas constant, 8314 J/Kg-mole * K
Pa = 101325			&& ambient pressure (assumed to equal 101325)
Ma = 28.9			&& molecular weight of air (assumed to equal 28.9kg/kg-mole)



ACTIVATE WINDOW datawind

*IF Payn <> 'Y' .OR. Payn <> 'N'
*   Payn = ' '
*ENDIF

DO WHILE .NOT. abort
   rho2 = SPACE(8)
   rhoair = SPACE(8)

   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 1, 3 SAY 'SOURCE PARAMETERS - Page 1 of 2'
   @ 6, 3 SAY 'GAS DENSITY'
   @ 7, 3 SAY '               Do you want to check for release '
   @ 8, 3 SAY '                              gas density (Y/N) -> '+LEFT(Payn+' ',1)
  
   @ 8, 54 FILL TO 8,54 COLOR &IPColor  
 
   cntr = 0
   DO WHILE .NOT. abort
      DO CASE 
         CASE cntr = 0
            DO title
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 0
               CASE prev  && F9            
                  RETURN                
               OTHERWISE  
                  cntr = 1
            ENDCASE
         CASE cntr = 1
            @ 8,54 GET Payn PICTURE '@!' VALID ChkYN(Payn)  
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 0
               CASE prev  && F9            
                  RETURN                
               OTHERWISE  
                  IF Payn = 'Y'
                     cntr = 2
                  ELSE
                     @ 9,3 CLEAR TO 19,75    
                     cntr = 4
                  ENDIF       
            ENDCASE
        CASE cntr = 2        
            @  9, 3 SAY 'BUOYANCY CHECK'
            IF VAL(rho2) = 0
               @ 10, 3 SAY '                         Discharge Density (2) ->          kg/cubic m'   
            ELSE
               @ 10, 3 SAY '                         Discharge Density (2) -> '+LEFT(rho2+SPACE(8),8)+' kg/cubic m'   
            ENDIF   
            @ 11, 3 TO 14, 75
            @ 12, 5 SAY '        Temperature of Material Released (Ts) -> '+LEFT(Ts+SPACE(8),8)+ ' K'
            @ 13, 5 SAY '            Exhaust Gas Molecular Weight (Mw) -> '+LEFT(Mw+SPACE(8),8)+ ' kg/kg-mole'

            IF VAL(rhoair) = 0
               @ 15, 3 SAY '                          Density of Air (air) ->          kg/cubic m'
            ELSE
               @ 15, 3 SAY '                          Density of Air (air) -> '+LEFT(rhoair+SPACE(8),8)+' kg/cubic m'   
            ENDIF   
            @ 16, 3 TO 18, 75
            @ 17, 5 SAY '                     Ambient Temperature (Ta) -> '+LEFT(Ta+SPACE(8),8) +' K'
            
            @ 12, 54 FILL TO 12,61 COLOR &IPColor
            @ 13, 54 FILL TO 13,61 COLOR &IPColor
            @ 17, 54 FILL TO 17,61 COLOR &IPColor
            
            @ 12,54 GET Ts PICTURE '@!' VALID Chk(Ts,9)  
            @ 13,54 GET Mw PICTURE '@!' VALID Chk(Mw,8)                          
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 1
               CASE prev  && F9            
                  RETURN                
               OTHERWISE
                  * Calculate discharge density Ambient pressure (Pa) = 1                  
                  *R = .08206
                  rho2 = convert(Pa*VAL(Mw)/(R*VAL(Ts)))	 && changed 1 to Pa
                  @ 10,54 SAY LEFT(rho2+SPACE(8),8)
                  cntr = 3
            ENDCASE 
         CASE cntr = 3            
            @ 17,54 GET Ta PICTURE '@!' VALID Chk(Ta,9)  
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 2
                  KEYBOARD CHR(13)
               CASE prev  && F9            
                  RETURN                
               OTHERWISE
                  * Calculate density of air; Ambient pressure (Pa) = 1                  
                  *R = .08206
                  rhoair = Convert(Pa * Ma/(R*VAL(Ta)))		&& changed 1 to Pa
                  @ 15,54 SAY LEFT(rhoair+SPACE(8),8)
                  cntr = 4
                  IF VAL(rho2)/VAL(rhoair) > 1.02
                     buoyancy = 'N'
                     @ 19,3 SAY 'Buoyancy is Negative'
                  ELSE    
                     buoyancy = 'P'
                     @ 19,3 SAY 'Buoyancy is Positive'
                     IF VAL(rho2)/VAL(rhoair) > 1.00
                        DO DenseMsg
                     ENDIF
                  ENDIF                  
            ENDCASE             
         CASE cntr = 4
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF                 
            IF prcd           && F10
               IF Payn = 'N'
                  direct = .T.
                  DO scrnpsub
               ELSE 
                  direct = .F.   
                  IF buoyancy = 'P' 
                     screenlong = .T.
                     DO scrnpsub
                  ELSE 
                     DO s22x2
                  ENDIF
               ENDIF   
            ENDIF   
            EXIT                                 
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO
             
DEACTIVATE WINDOW datawind

RETURN


******************************* s22x2 ************************************
PROCEDURE s22x2

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 1, 3 SAY 'SOURCE PARAMETERS - Page 2 of 2'
   @ 3, 3 SAY 'RICHARDSON NUMBER CHECK'  
   @ 4, 3 SAY '                       Richardson Number ->'
   @ 5, 3 TO 8,75
   @ 6, 5 SAY '     Total Material Emission Rate (Qm) -> '+LEFT(Qm+SPACE(8),8)+' g/s'   
   @ 7, 5 SAY '         Diameter at Release Point (D) -> '+LEFT(D+SPACE(8),8)+' m' 
   
   @ 6, 47 FILL TO 6,54 COLOR &IPColor
   @ 7, 47 FILL TO 7,54 COLOR &IPColor
   cntr = 1
   DO WHILE .NOT. abort  
      DO CASE
         CASE cntr = 1
            @ 6,47 GET Qm PICTURE '@!' VALID Chk(Qm,3)
            @ 7,47 GET D PICTURE '@!' VALID Chk(D,3)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  g = 9.81
                  * Calculate Richardson Number-RVD
                  RiRVD = convert(2725 * ( (VAL(rho2)/VAL(RhoAir) - 1) * VAL(Qm) ) / (VAL(D) * VAL(rho2)*1000))
                  IF VAL(RiRVD) > 30
                     DenseRVD = .T.
                     @ 4,47 SAY LEFT(RiRVD+SPACE(8),8)+' (Dense)'            
                  ELSE
                     DenseRVD = .F.
                     @ 4,47 SAY LEFT(RiRVD+SPACE(8),8)+' (Passive)'               
                  ENDIF   
                  cntr = 2
             ENDCASE 
          CASE cntr = 2
             DO EL2Keys
             IF prev           && F9
                RETURN
             ENDIF                 
             IF prcd           && F10
                IF .NOT. DenseRVD
                   screenlong = .F.
                   DO scrnpsub
                ELSE
                   DEFINE WINDOW msg FROM 7,10 TO 14,64 SHADOW COLOR &MesColor
                   ACTIVATE WINDOW msg  
                   @ 1,1 SAY 'This release is determined to be denser than air.'              
                   @ 2,1 SAY 'Hint: Goto Scenario 2.3 (Gaseous Leaks from Tanks,'
                   @ 3,1 SAY 'Pipes, Relief Valves), it may be more appropriate.'
                   @ 4,2 
                   WAIT              
                   RELEASE WINDOW msg
                   abort = .T.
                   RETURN
                 ENDIF
             ENDIF   
             EXIT             
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO

RETURN
