* program : s24.prg
* system : TSCREEN
* Modified by: Roger Brode, PES, 4/7/94
*   Corrected equation for BETA (removed factor of 2.)

two_phase = .F.
R = 8314

ACTIVATE WINDOW datawind

DO Inst_warning

DO WHILE .NOT. abort
   CLEAR
   DO ClrEl1Key
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 1 of 4'
   @  5,3 SAY 'SOURCE OF LEAK'
   @  6,3 SAY '                Area (Ao) of Hole or Opening -> ' + LEFT(A0CM+SPACE(8),8) + ' cm'
   @  7,3 SAY '               Enter P for Pipe - T for tank -> '+ LEFT(Type+' ',1)   
   @  9,3 SAY 'FLOW CHARACTERISTIC'
   @ 10,3 SAY '                      Critical Pressure (P*) ->          Pa'                             
   @ 11,3 TO 15,75                                                
   @ 12,5 SAY '                    Gas Heat Capacity (Cp) -> ' + LEFT(Cp+SPACE(8),8) + ' J/kg K'   
   @ 13,5 SAY '                   Reservoir Pressure (P1) -> '+LEFT(Pr+SPACE(8),8) + ' Pa'
   @ 14,5 SAY '                     Molecular Weight (Mw) -> '+LEFT(Mw+SPACE(8),8) + ' kg/kmol'
   @ 16,3 SAY '                         Flow Characteristic ->'
   @ 17,3 TO 19,75
   @ 18,5 SAY '                     Ambient Pressure (Pa) -> '+LEFT(Pa+SPACE(8),8) + ' Pa'

   @ 6, 51 FILL TO 6,58 COLOR &IPColor  
   @ 7, 51 FILL TO 7,51 COLOR &IPColor  
   @ 12, 51 FILL TO 12,58 COLOR &IPColor  
   @ 13, 51 FILL TO 13,58 COLOR &IPColor  
   @ 14, 51 FILL TO 14,58 COLOR &IPColor     
   @ 18, 51 FILL TO 18,58 COLOR &IPColor  

   cntr = 0
   DO WHILE .NOT. abort
      DO CASE 
         CASE cntr = 0
            DO title
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 0
               CASE prev  && F9            
                  RETURN                
               OTHERWISE  
                  cntr = 1
            ENDCASE
         CASE cntr = 1
            @ 6,51 GET A0CM PICTURE '@!' VALID Chk(A0CM,3)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 0
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  A0 = convert(VAL(A0CM)/10000)
                  D0 = convert(SQRT((4 * VAL(A0))/3.14159))
                  cntr = 2
            ENDCASE             
         CASE cntr = 2
            @ 7,51 GET Type PICTURE '@!' VALID ChkPT(Type)  
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  cntr = 3
            ENDCASE 
         CASE cntr = 3   
            IF Type = 'T'
               @ 8, 3 CLEAR TO 8,75
               cntr = 4
            ELSE   
               @ 8, 3 SAY '                       Diameter of Pipe (Dp) -> ' + LEFT(Dp+SPACE(8),8) + ' m'
               @ 8,51 FILL TO 8,58 COLOR &IPColor  
               @ 8,51 GET Dp PICTURE '@!' VALID Chk(Dp,3)                         
               READ
               DO CASE
                  CASE LASTKEY() = 27  && ESCAPE
                     abort = .T.
                     EXIT
                  CASE LASTKEY() = 5   && UP
                     cntr = 2
                  CASE prev             && F9
                     RETURN
                  OTHERWISE
                     cntr = 4
               ENDCASE
            ENDIF
         CASE cntr = 4
            * Calculate Beta
            IF Type = 'T'
               beta = 0
            ELSE   
               A1 = 3.14159 * (VAL(Dp)/2)^2
*               beta = 2 * SQRT(VAL(A0)/A1)
               beta = SQRT(VAL(A0)/A1)
               IF beta > .2 
                  DEFINE WINDOW question FROM 11,13 TO 18,65 SHADOW COLOR &MesColor
                  ACTIVATE WINDOW question
                  @ 1,0 SAY PADC('Scenario 2.6 -',53)
                  @ 2,0 SAY PADC('Instantaneous Leaks from a Pipe Attached to Reservoir',53)
                  @ 3,0 SAY PADC('may be more appropriate.',53)
                  WAIT
                  RELEASE WINDOW question
                  abort = .T.
               ELSE
                  DEFINE WINDOW question FROM 11,13 TO 18,65 SHADOW COLOR &MesColor
                  ACTIVATE WINDOW question
                  @ 1,0 SAY PADC('Use upstream conditions',53)
                  @ 2,0 SAY PADC('for data entry fields.',53)
                  WAIT
                  RELEASE WINDOW question
                 
               ENDIF   
            ENDIF
            cntr = 5
         CASE cntr = 5
            @ 12,51 GET Cp PICTURE '@!' VALID Chk(Cp,3)
            @ 13,51 GET Pr PICTURE '@!' VALID Chk(Pr,3)
            @ 14,51 GET Mw PICTURE '@!' VALID Chk(Mw,8)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP
                  IF Type = 'T'
                     cntr = 2
                  ELSE
                     cntr = 3
                  ENDIF
               CASE prev             && F9
                  RETURN
               OTHERWISE               
                  * Calculate Gamma 
                  Gamma = 1/(1-(R/(VAL(Cp)*VAL(Mw))))
                  IF Gamma < 0 
                     DEFINE WINDOW msg FROM 6,12 TO 11,58 SHADOW COLOR &MesColor
                     ACTIVATE WINDOW msg
                     @ 1,0 SAY PADC('Invalid  combination of inputs !!!',44)
                     @ 3,0 SAY PADC('Press any key to continue...',44)
                     WAIT ""
                     RELEASE WINDOW msg            
                     cntr = 5
                     LOOP
                  ENDIF
                  
                  * Calculate Choked Pressure (Px)
                  Px = VAL(Pr) * (2/(Gamma+1))^(Gamma/(Gamma-1))

                  @ 10,51 SAY LEFT(convert(Px) + SPACE(8),8)
                  cntr = 6
            ENDCASE
         CASE cntr = 6
            @ 18,51 GET Pa PICTURE '@!' VALID Chk(Pa,18)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP
                  KEYBOARD CHR(13)
                  cntr = 5
               CASE prev             && F9
                  RETURN
               OTHERWISE
                  * Determine Flow characteristic
                  IF Px >= VAL(Pa)
                     @ 16,51 SAY 'Choked     '
                     FlowChar = 'C'
                  ELSE 
                     @ 16,51 SAY 'Subcritical'
                     FlowChar = 'S'
                  ENDIF
                  cntr = 7
            ENDCASE
         CASE cntr = 7
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF                             
            IF prcd           && F10
               IF FlowChar = 'C'
                  DO s24x2C
               ELSE
                  D = D0
                  DO s24x2S
               ENDIF      
            ENDIF   
            EXIT         
      ENDCASE         
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO
             
DEACTIVATE WINDOW datawind

RETURN


******************************* s24x2C ************************************
PROCEDURE s24x2C
            
Ptx = '0      '

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.

   @  1,3 SAY 'SOURCE PARAMETERS - Page 2 of 4'
   @  3,3 SAY 'TEMPERATURES'
   @  4,3 SAY '     Gas Temperature (T*) at Critical Pressure ->          K'
   @  5,3 TO 7,75 
   @  6,5 SAY '                  Reservoir Temperature (T1) -> ' + LEFT(T1+SPACE(8),8) + ' K'
   @  9,3 SAY '                     Critical Temperature (Tc) -> ' + LEFT(Tc+SPACE(8),8) + ' K'
  
   @ 6, 53 FILL TO 6,60 COLOR &IPColor
   @ 9, 53 FILL TO 9,60 COLOR &IPColor

   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1
            @ 6,53 GET T1 PICTURE '@!' VALID Chk(T1,9)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP
                  cntr = 1
               CASE prev             && F9
                  RETURN
               OTHERWISE
                  *Calculate Gas Temperature
                  Tx = Convert(VAL(T1)*(2/(Gamma+1)))
                  @ 4,53 SAY LEFT(Tx +SPACE(8),8)
                  cntr = 2
            ENDCASE
         CASE cntr = 2
            @ 9,53 GET Tc PICTURE '@!' VALID Chk(Tc,9)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
               abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP
                  cntr = 1
               CASE prev
                  RETURN
               OTHERWISE
                  IF VAL(Tx) > VAL(Tc)
                     two_phase = .F.
                     cntr = 5
                     @ 10,3 CLEAR TO 19,75
                     Got_Tb_Lvap = .F.
                  ELSE
                     Got_Tb_Lvap = .T.
                     cntr = 3
                  ENDIF   
            ENDCASE
         CASE cntr = 3
            @ 10,3 SAY 'VAPOR PRESSURE'
            IF VAL(Ptx) > 0 
		         @ 11,3 SAY '         Vapor Pressure (p) at Gas Temperature -> '+LEFT(Ptx+SPACE(8),8) + ' Pa'
		      ELSE
		         @ 11,3 SAY '         Vapor Pressure (p) at Gas Temperature ->          Pa'
		      ENDIF   
            @ 12,3 TO 15,75
            @ 13,5 SAY '    Latent Heat of Vaporization (Lvap) at Tb -> ' + LEFT(Lvap+SPACE(8),8) + ' J/kg'
            @ 14,5 SAY '              Boiling Point Temperature (Tb) -> ' + LEFT(Tb+SPACE(8),8) + ' K'
            
            @ 13,53 GET Lvap PICTURE '@!' VALID Chk(Lvap,0)
            @ 14,53 GET Tb PICTURE '@!' VALID Chk(Tb,9)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
               abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP
                  cntr = 2
               CASE prev
                  RETURN
               OTHERWISE
                  * Calculate Vapor Pressure at Gas Temperature (Ptx)
                  exponent = (VAL(Lvap)*VAL(Mw)/R)*((1/VAL(Tb)) - (1/VAL(Tx)))
                  IF exponent > 88.02969
                     WAIT 'Invalid combination of inputs, '+press WINDOW
                     cntr = 3
                     LOOP
                  ELSE
                     Ptx = LEFT(convert(101325*EXP(exponent))+SPACE(8),8)
                     @ 11,53 SAY LEFT(Ptx+SPACE(8),8)
                     IF VAL(Ptx) <= 0
                        WAIT 'Vapor Pressure must be > 0, '+press WINDOW
                        cntr = 3
                        LOOP
                     ENDIF
                  ENDIF                                   
                  cntr = 4
            ENDCASE
         CASE cntr = 4
            * Perform Check
            IF VAL(Ptx) <= Px
               DEFINE WINDOW question FROM 5,13 TO 11,65 SHADOW COLOR &MesColor
               ACTIVATE WINDOW question
               @ 0,0 SAY PADC('Pressure  Choked Pressure',53)
               @ 2,0 SAY PADC('This is a two-phase release.',53)
               WAIT
               RELEASE WINDOW question
               two_phase = .T.
            ELSE
               two_phase = .F.   
            ENDIF
            cntr = 5
         CASE cntr = 5
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF            
            IF prcd           && F10
               IF two_phase 
                  DO s24x3C2P            
               ELSE               
                  DO s24x3C
               ENDIF   
            ENDIF
            EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF
   ENDDO
ENDDO   
RETURN


******************************* s24x3C ************************************
PROCEDURE s24x3C
           
* For Choked flow conditions:
*    modify the diameter to account for initial air dilution 
*    due to jetting or momentum effects
*D = convert(VAL(D0) * SQRT(Px/VAL(Pa)))
D = D0

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  0,3 SAY 'SOURCE PARAMETERS - Page 3 of 4'
*   @  1,3 SAY 'DIAMETER'
*   @  2,3 SAY '  Diameter accounting for initial air dilution -> '+LEFT(D+SPACE(8),8)+' m'
   @  3,3 SAY 'EMISSION RATE'
   @  4,3 SAY '                            Emission Rate (Qm) ->           g/s'
   @  5,3 TO 7,75
   @  6,5 SAY '        Density at Reservoir Conditions (1) -> ' + LEFT(Pl+SPACE(8),8) + ' kg/cubic m'
   @  8,3 SAY 'DISCHARGE CHARACTERISTICS'
   @  9,3 SAY '                    Discharge Temperature (T2) ->          K'
   @ 10,3 SAY '                        Discharge Density (2) ->          kg/cubic m'
   @ 15,3 SAY '                         Density of Air (air) ->          kg/cubic m'
   @ 16,3 TO 18,75
   @ 17,5 SAY '                    Ambient Temperature (Ta) -> '+ LEFT(Ta+SPACE(8),8) +' K'

   @ 6, 53 FILL TO 6,60 COLOR &IPColor
   @ 17,53 FILL TO 17,60 COLOR &IPColor
 
   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1
            @ 6,53 GET Pl PICTURE '@!' VALID Chk(Pl,3)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN                     
               OTHERWISE
                  * calculate emission rate
                  c = .75
                  Qm = Convert(c * VAL(A0)*;
                  SQRT(VAL(Pr) * VAL(Pl) * Gamma * (2/(Gamma+1))^((Gamma+1)/(Gamma-1)) ))
                  * Convert to g/s
                  Qm = convert(VAL(Qm)*1000)
                  @ 4, 53 SAY  LEFT(Qm+SPACE(8),8)               
                  IF VAL(Qm) <= 0
                     WAIT 'Emission rate must be > 0, '+press WINDOW
                     cntr = 1
                     LOOP                      
                  ELSE
                     cntr = 2
                  ENDIF   
            ENDCASE      
         CASE cntr = 2
            *  Calculate Discharge Temperature
            epsilon = .85
            Ts = Convert(VAL(T1) * (1-epsilon*((Gamma-1)/(Gamma+1))))
            @ 9,53 SAY LEFT(Ts+SPACE(8),8)
            cntr = 3
         CASE cntr = 3
            * Calculate discharge density
            rho2 = Convert(VAL(Pa)*VAL(Mw)/(R*VAL(Ts)))
            @ 10,53 SAY LEFT(rho2+SPACE(8),8)
            cntr = 4
         CASE cntr = 4
            @ 17,53 GET Ta PICTURE '@!' VALID Chk(Ta,9)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 3
               CASE prev             && F9
                  RETURN                     
               OTHERWISE 
                  rhoair = convert(VAL(Pa)*28.9/(R*VAL(Ta)))
                  @ 15,53 SAY LEFT(rhoair + SPACE(8),8)
                  IF VAL(rho2)/VAL(rhoair) > 1.02
                     buoyancy = 'N'
                     @ 19,3 SAY 'Buoyancy is Negative'
                  ELSE    
                     buoyancy = 'P'
                     @ 19,3 SAY 'Buoyancy is Positive'
                     IF VAL(rho2)/VAL(rhoair) > 1.00
                        DO DenseMsg
                     ENDIF
                  ENDIF
                  cntr = 5
            ENDCASE         
         CASE cntr = 5   
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF                             
            IF prcd           && F10
               *IF buoyancy = 'P'
               *   DO puffsub
               *ELSE
                  DO s24x4
               *ENDIF             
            ENDIF   
            EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO   
RETURN

******************************* s24x4 ************************************
PROCEDURE s24x4

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  0,3 SAY 'SOURCE PARAMETERS - Page 4 of 4'   
   @  2,3 SAY 'TIME'
   @  3,3 SAY '                         Release Duration (Td) ->          min'            
   @  4,3 TO 6,75
   @  5,5 SAY '       Total Amount of Material Released (Q) -> ' + LEFT(QKG+SPACE(8),8) + ' kg'
   @  5, 53 FILL TO 5,60 COLOR &IPColor                           
      
   IF buoyancy = 'N'
      @  8,3 SAY 'VERTICALLY DIRECTED JET'
      @  9,3 SAY '       Does the release result in a vertically '
      @ 10,3 SAY '                            directed jet (Y/N) -> '+LEFT(YN+' ',1)
      @ 10, 53 FILL TO 10,53 COLOR &IPColor   
   ENDIF   
 
   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1            
            @ 5,53 GET QKG PICTURE '@!' VALID Chk(QKG,3)   
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN                     
               OTHERWISE
                  Q = convert(VAL(QKG)*1000)
                  * Calculate Release Duration (Dur)
                  Dur = convert(VAL(Q) / VAL(Qm) /60)
                  @ 3,53 SAY LEFT(Dur+SPACE(8),8) 
                  IF buoyancy = 'P'
                     cntr = 3
                  ELSE                     
                     cntr = 2
                  ENDIF                           
            ENDCASE                        
         CASE cntr = 2
         
            @ 10,53 GET YN PICTURE '@!' VALID ChkYN(YN)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN                     
               OTHERWISE
                  cntr = 3
            ENDCASE      
         CASE cntr = 3
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF                 
            IF prcd           && F10
               IF buoyancy = 'P'
                  DO puffsub
               ELSE   
                  IF YN = 'Y'
                     DO rvdsub
                  ELSE
                     DO bmsub
                  ENDIF
               ENDIF   
            ENDIF   
            EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO   
RETURN


****************************** s24x3C2P ***********************************
PROCEDURE s24x3C2P

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 3 of 4'
   @  3,3 SAY 'EMISSION RATE'
   @  4,3 SAY '                            Emission Rate (Qm) ->          g/s'        
   IF Type = 'T'
      @  5,3 TO 7,75
      @  6,5 SAY '        Density at Reservoir Conditions (1) -> ' + LEFT(Pl+SPACE(8),8) + ' kg/cubic m'       
   ELSE 
      @  5,3 TO 8,75
      @  6,5 SAY '        Density at Reservoir Conditions (1) -> ' + LEFT(Pl+SPACE(8),8) + ' kg/cubic m'       
      @  7,5 SAY '                            Pipe Length (Lp) -> ' + LEFT(P+SPACE(8),8) + ' m'
   ENDIF              
   @ 10,3 SAY 'DISCHARGE CHARACTERISTICS'
   @ 11,3 SAY '                    Discharge Temperature (T2) ->          K'
   @ 12,3 SAY '                        Discharge Density (2) ->          kg/cubic m'
   @ 13,3 SAY 'Vapor Fraction at Discharge Flow Conditions(X2)->          '
   *@ 13,3 SAY '  Diameter accounting for initial air dilution ->          m'
   @ 15,3 SAY '                         Density of Air (air) ->          kg/cubic m'
   @ 16,3 TO 18,75
   @ 17,5 SAY '                    Ambient Temperature (Ta) -> ' + LEFT(Ta+SPACE(8),8) + ' K'
   
   @ 6, 53 FILL TO 6,60 COLOR &IPColor
   IF Type = 'P'
      @ 7,53 FILL TO 7,60 COLOR &IPColor
   ENDIF
   @ 17, 53 FILL TO 17,60 COLOR &IPColor

   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1
            @ 6,53 GET Pl PICTURE '@!' VALID Chk(Pl,3)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN                     
               OTHERWISE
                  IF Type = 'P'                  
                     cntr = 2
                  ELSE 
                     cntr = 3
                  ENDIF   
            ENDCASE
         CASE cntr = 2
            @ 7,53 GET P PICTURE '@!' VALID Chk(P,3)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN                     
               OTHERWISE
                  cntr = 3
            ENDCASE
         CASE cntr = 3
           * Calculate Tx
           Tx = Convert(1 / ( 1/VAL(Tb) - R/(VAL(Lvap) * VAL(Mw)) * LOG(Px/101325) ))

           IF VAL(Tx) <= 0 
              cntr = 7
              LOOP
           ENDIF

           * Calculate vapor fraction at choked flow conditions Xx
           Xx = 1 + (VAL(Tx)/(VAL(Lvap) * VAL(Mw))) * (VAL(Mw)*VAL(Cp)*LOG(VAL(T1)/VAL(Tx)) - R*LOG(VAL(Pr)/Px) )
           
           * Calculate enthalpy change (H1-Hx)
           H1Hx = VAL(Cp)*(VAL(T1)-VAL(Tx)) + VAL(Lvap)*(1-Xx)
           
           * Calculate Density RHOx
           rhox = 1/( (Xx*(R*VAL(Tx))/(Px*VAL(Mw))) + (1-Xx)/VAL(Pl) )  
           cntr = 4
         CASE cntr = 4
            * Calculate Emission rate
            constf = .0045
            IF Type = 'P'
               IF (2 * .85 * (H1Hx/((1+(4*constf*VAL(P)/VAL(Dp))))) ) < 0
                  cntr = 7
                  LOOP
               ENDIF
               Qm = convert(1000 * VAL(A0) * rhox * SQRT(2 * .85 * (H1Hx/((1+(4*constf*VAL(P)/VAL(Dp))))) ) )
            ELSE
               IF (2 * .85 * H1Hx) < 0
                  cntr = 7
                  LOOP   
               ENDIF
               Qm = convert(1000 * VAL(A0) * rhox * SQRT(2 * .85 * H1Hx ) )
            ENDIF 
            
            @ 4,53 SAY LEFT(Qm+SPACE(8),8)                                                                                  
 
            cntr = 5
         CASE cntr = 5
            * Calculate Discharge Temperature T2
            Ts = Convert(1 / ( 1/VAL(Tb) - R/(VAL(Lvap) * VAL(Mw)) * LOG(VAL(Pa)/101325) ))

            * Calculate vapor fraction at discharge flow conditions X2
            X2 = Convert(Xx + ( VAL(Cp) * (VAL(Tx)-VAL(Ts)) / VAL(Lvap) ))
            
            IF VAL(X2) <= 0 .OR. VAL(X2) >=1 
               * Calculate Discharge Temperature Ts
               Ts = convert( VAL(Tx) + ( VAL(Lvap) * (1-Xx) / VAL(Cp) ) )
             
               * Calculate Discharge Density rho2
               rho2 = Convert(VAL(Pa)*VAL(Mw)/(R*VAL(Ts)))
            ELSE
               * Calculate Discharge Density rho2
               rho2 = convert(1/( (VAL(X2)*(R*VAL(Ts))/(VAL(Pa)*VAL(Mw))) + (1-VAL(X2))/VAL(Pl) ) )
            ENDIF
            @ 11,53 SAY LEFT(Ts+SPACE(8),8)                               
            @ 12,53 SAY LEFT(rho2+SPACE(8),8)            
            @ 13,53 SAY LEFT(X2+SPACE(8),8)

            * For Choked flow conditions:
            *    modify the diameter to account for initial air dilution 
            *    due to jetting or momentum effects
            *D = convert(VAL(D0) * SQRT(rhox/VAL(rho2)))            
            *@ 13,53 SAY LEFT(D+SPACE(8),8)                                    
            D = D0            
            cntr = 6
         CASE cntr = 6   
            @ 17,53 GET Ta PICTURE '@!' VALID Chk(Ta,9)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  IF Type = 'T'
                     KEYBOARD CHR(13)
                     cntr = 1
                  ELSE
                     cntr = 2
                  ENDIF   
               CASE prev             && F9
                  RETURN                     
               OTHERWISE
                  rhoair = convert(VAL(Pa)*28.9/(R*VAL(Ta)))
                  @ 15,53 SAY LEFT(rhoair + SPACE(8),8)
                  IF VAL(rho2)/VAL(rhoair) > 1.02
                     buoyancy = 'N'
                     @ 19,3 SAY 'Buoyancy is Negative'
                  ELSE    
                     buoyancy = 'P'
                     @ 19,3 SAY 'Buoyancy is Positive'
                     IF VAL(rho2)/VAL(rhoair) > 1.00
                        DO DenseMsg
                     ENDIF
                  ENDIF
                  cntr = 8                  
            ENDCASE
         CASE cntr = 7
            DEFINE WINDOW msg FROM 6,12 TO 11,58 SHADOW COLOR &MesColor
            ACTIVATE WINDOW msg
            @ 1,0 SAY PADC('Invalid  combination of inputs !!!',44)
            @ 3,0 SAY PADC('Press any key to continue...',44)
            WAIT ""
            RELEASE WINDOW msg            
            cntr = 1
         CASE cntr = 8         
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF                 
            
            IF prcd           && F10
              * IF buoyancy = 'P'
              *    DO puffsub
              * ELSE
                  DO s24x4
              * ENDIF             
            ENDIF   
            EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO   
RETURN   
         
******************************* s24x2S ************************************
PROCEDURE s24x2S            

D = D0

DO WHILE .NOT. abort
   CLEAR 
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 2 of 4'
   @  3,3 SAY 'EMISSION RATE'
   @  4,3 SAY '                            Emission Rate (Qm) ->          g/s'     
   @  5,3 TO 7,75
   @  6,5 SAY '                      Reservoir Density (1) -> '+ LEFT(Pl+SPACE(8),8) + ' kg/cubic m'   
   @  9,3 SAY 'DISCHARGE TEMPERATURE'
   @ 10,3 SAY '                    Discharge Temperature (T2) ->          K'
   @ 11,3 TO 13,75 
   @ 12,5 SAY '                  Reservoir Temperature (T1) -> '+ LEFT(T1+SPACE(8),8) + ' K'

   @ 6, 53 FILL TO 6,60 COLOR &IPColor
   @ 12, 53 FILL TO 12,60 COLOR &IPColor

   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1
            @ 6,53 GET Pl PICTURE '@!' VALID Chk(Pl,3)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN                     
               OTHERWISE
                  * Calculate Emission Rate
                  c = .62
                  ConstK = c/SQRT(1-Beta^4)
                  y = 1 - (VAL(Pr)-VAL(Pa))/(VAL(Pr)*Gamma) * (0.41 + 0.35*Beta^4)  
                  Qm = Convert(ConstK * y * VAL(A0) * SQRT(2*VAL(Pl)*(VAL(Pr)-VAL(Pa))))                      
                  * Convert to g/s         
                  Qm = convert(VAL(Qm)*1000)
                  @ 4, 53 SAY  LEFT(Qm+SPACE(8),8)                                                    
                  IF VAL(Qm) <= 0
                     WAIT 'Emission rate must be > 0, '+press WINDOW
                     cntr = 1
                     LOOP                      
                  ELSE
                     cntr = 2 
                  ENDIF
            ENDCASE         
         CASE cntr = 2
            @ 12,53 GET T1 PICTURE '@!' VALID Chk(T1,9)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN                     
               OTHERWISE
                  ConstA = (1/(2*VAL(Cp)))*( ((VAL(Qm)/1000)*R)/(VAL(Pa)*VAL(Mw)*VAL(A0)) )^2
                  Ts = Convert( 2*VAL(T1)/(1+SQRT(1+4*ConstA*VAL(T1))) )
                  @ 10,53 SAY LEFT(Ts+SPACE(8),8)
                  cntr = 3                  
             ENDCASE            
          CASE cntr = 3
             DO EL2Keys             
             IF prev           && F9
                RETURN
             ENDIF                              
             IF prcd           && F10
                DO s24x3S
             ENDIF
             EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO      
ENDDO   

RETURN
   

******************************* s24x3S ************************************
PROCEDURE s24x3S
             
Pt2 = '0'

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 3 of 4'
   @  3,3 SAY 'CRITICAL TEMPERATURE'
   @  4,3 SAY '                     Critical Temperature (Tc) -> '+ LEFT(Tc+SPACE(8),8) + ' K'
   @ 12,3 SAY 'DISCHARGE DENSITY'
   @ 13,3 SAY '                        Discharge Density (2) ->          kg/cubic m'
   @ 15,3 SAY '                         Density of Air (air) ->          kg/cubic m'
   @ 16,3 TO 18,75
   @ 17,5 SAY '                    Ambient Temperature (Ta) -> '+ LEFT(Ta+SPACE(8),8) +' K'
  
   @ 4, 53 FILL TO 4,60 COLOR &IPColor
   @ 17, 53 FILL TO 17,60 COLOR &IPColor

   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1
            @ 4,53 GET Tc PICTURE '@!' VALID Chk(Tc,9)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
               abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP
                  cntr = 1
               CASE prev
                  RETURN
               OTHERWISE
                  IF VAL(Ts) > VAL(Tc)
                     two_phase = .F.
                     @ 5,3 CLEAR TO 11,75
                     cntr = 4
                     Got_Tb_Lvap = .F.
                  ELSE                     
                     cntr = 2
                     @ 5,3 CLEAR TO 11,75
                     Got_Tb_Lvap = .T.
                  ENDIF   
            ENDCASE
         CASE cntr = 2
            @ 6,3 SAY 'VAPOR PRESSURE'
            IF VAL(Pt2) > 0
               @ 7,3 SAY '   Vapor Pressure (p) at Discharge Temperature -> '+LEFT(Pt2+SPACE(8),8) + ' Pa'
            ELSE
               @ 7,3 SAY '   Vapor Pressure (p) at Discharge Temperature ->          Pa'
            ENDIF   
            @  8,3 TO 11,75
            @  9,5 SAY '    Latent Heat of Vaporization (Lvap) at Tb -> ' + LEFT(Lvap+SPACE(8),8) + ' cal/g-mole'
            @ 10,5 SAY '              Boiling Point Temperature (Tb) -> ' + LEFT(Tb+SPACE(8),8) + ' K'
            
            @ 9,53 GET Lvap PICTURE '@!' VALID Chk(Lvap,0)
            @ 10,53 GET Tb PICTURE '@!' VALID Chk(Tb,9)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP
                  cntr = 1
               CASE prev
                  RETURN
               OTHERWISE
                  * Calculate Vapor Pressure at Discharge Temperature (Pt2)
                  exponent = ((VAL(Lvap)*VAL(Mw))/R)*((1/VAL(Tb)) - (1/VAL(Ts)))
                  IF exponent > 88.02969
                     WAIT 'Invalid combination of inputs, '+press WINDOW
                     cntr = 2
                     LOOP
                  ELSE
                     Pt2 = LEFT(convert(101325*EXP(exponent))+SPACE(8),8)
                     @ 7,53 SAY LEFT(Pt2+SPACE(8),8)
                     IF VAL(Pt2) <= 0
                        WAIT 'Vapor Pressure must be > 0, '+press WINDOW
                        cntr = 2
                        LOOP
                     ENDIF
                  ENDIF
                  cntr = 3
            ENDCASE
         CASE cntr = 3
            * Perform Check
            IF VAL(Pt2) <= VAL(Pa)
               DEFINE WINDOW question FROM 10,13 TO 16,65 SHADOW COLOR &MesColor
               ACTIVATE WINDOW question
               @ 0,0 SAY PADC('Vapor Pressure  Ambient Pressure',53)
               @ 2,0 SAY PADC('This is a two-phase release.',53)
               WAIT           
               RELEASE WINDOW question    
               two_phase = .T.
               cntr = 6
            ELSE
               two_phase = .F.
               cntr = 4   
            ENDIF            
         CASE cntr = 4
            * Calculate discharge density         
            rho2 = Convert(VAL(Pa)*VAL(Mw)/(R*VAL(Ts)))
            @ 13,53 SAY LEFT(rho2+SPACE(8),8)
            cntr = 5
         CASE cntr = 5
             @ 17,53 GET Ta PICTURE '@!' VALID Chk(Ta,9)           
             READ   
             DO CASE
                CASE LASTKEY() = 27  && ESCAPE
                   abort = .T.
                   EXIT 
                CASE LASTKEY() = 5   && UP 
                   IF VAL(Ts) > VAL(Tc)
                      cntr = 1
                   ELSE
                      KEYBOARD CHR(13)
                      cntr = 2
                   ENDIF   
                CASE prev             && F9
                   RETURN                     
                OTHERWISE
                   rhoair = convert(VAL(Pa)*28.9/(R*VAL(Ta)))
                   @ 15,53 SAY LEFT(rhoair+SPACE(8),8)
                   IF VAL(rho2)/VAL(rhoair) > 1.02
                      buoyancy = 'N'
                      @ 19,3 SAY 'Buoyancy is Negative'
                   ELSE
                      buoyancy = 'P'
                      @ 19,3 SAY 'Buoyancy is Positive'
                      IF VAL(rho2)/VAL(rhoair) > 1.00
                         DO DenseMsg
                      ENDIF
                   ENDIF
                   cntr = 6
             ENDCASE   
          CASE cntr = 6   
             DO EL2Keys
             IF prev           && F9
                RETURN
             ENDIF             
             IF prcd           && F10
                IF two_phase 
                   DO s24x3S2P
                ELSE             
                   *IF buoyancy = 'P'
                   *   DO puffsub
                   *ELSE
                      DO s24x4
                   *ENDIF
                ENDIF      
             ENDIF
             EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO   

RETURN

****************************** s24x3S2P ***********************************
PROCEDURE s24x3S2P
             
DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  0,3 SAY 'SOURCE PARAMETERS - Page 3 of 4'
   @  2,3 SAY 'DISCHARGE CHARACTERISTICS'
   @  4,3 SAY '                    Discharge Temperature (T2) ->          K' 
   @  5,3 SAY 'Vapor Fraction at Discharge Flow Conditions(X2)->          '
   @  7,3 SAY '                        Discharge Density (2) ->          kg/cubic m'
   @  8,3 SAY 'EMISSION RATE'
   @  9,3 SAY '                           Emissions Rate (Qm) ->          g/s'
   IF Type = 'P'   
      @  10,3 TO 12,75
      @  11,5 SAY '                            Pipe Length (Lp) -> '+ LEFT(P+SPACE(8),8) + ' m'
   ENDIF   
   @ 13,3 SAY 'DENSITY OF AIR'
   @ 14,3 SAY '                         Density of Air (air) ->          kg/cubic m'
   @ 15,3 TO 17,75
   @ 16,5 SAY '                    Ambient Temperature (Ta) -> ' + LEFT(Ta+SPACE(8),8) +' K'

   IF Type = 'P'
      @ 11,53 FILL TO 11,60 COLOR &IPColor
   ENDIF   
   @ 16,53 FILL TO 16,60 COLOR &IPColor
   
   cntr = 1

   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1
            * Calculate Discharge Temperature (Ts)
            Ts = convert(1/( (1/VAL(Tb)) - LOG(VAL(Pa)/101325)*R/(VAL(Lvap)*VAL(Mw)) ))
            @ 4,53 SAY LEFT(Ts+SPACE(8),8)

            IF VAL(Ts) <= 0
               cntr = 7
               LOOP
            ENDIF
            
            cntr = 3
          CASE cntr = 3
             * Calculate vapor fraction at discharge conditions X2
             X2 = Convert(1 + (VAL(Ts)/(VAL(Lvap)*VAL(Mw))) * (VAL(Mw)*VAL(Cp)*LOG(VAL(T1)/VAL(Ts)) - R*LOG(VAL(Pr)/VAL(Pa)) ))
             @ 5,53 SAY LEFT(X2+SPACE(8),8)
             
             * Calculate enthalpy change H1-Hx
             H1Hx = VAL(Cp)*(VAL(T1)-VAL(Ts)) + VAL(Lvap)*(1-VAL(X2))             
             
             * Calculate Discharge Density RHO2
             rho2 = Convert(1/( (VAL(X2)*(R*VAL(Ts))/(VAL(Pa)*VAL(Mw))) + (1-VAL(X2))/VAL(Pl) )  )
             
             @ 7,53 SAY LEFT(rho2+SPACE(8),8)
             IF Type = 'P'         
                cntr = 4
             ELSE 
                cntr = 5
             ENDIF   
          CASE cntr = 4
            @ 11,53 GET P PICTURE '@!' VALID Chk(P,3)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP
                  cntr = 4
               CASE prev
                  RETURN
               OTHERWISE
                  cntr = 5
            ENDCASE
          CASE cntr = 5
            * Calculate Emission rate
            constf = .0045
            IF Type = 'P'
               IF (2 * .85 * (H1Hx/((1+(4*constf*VAL(P)/VAL(Dp))))) ) < 0
                  cntr = 7
                  LOOP
               ENDIF
               Qm = convert(1000 * VAL(A0) * VAL(rho2) * SQRT(2 * .85 * (H1Hx/((1+(4*constf*VAL(P)/VAL(Dp))))) ) )
            ELSE
               IF (2 * .85 * H1Hx) < 0
                  cntr = 7
                  LOOP
               ENDIF
               Qm = convert(1000 * VAL(A0) * VAL(rho2) * SQRT(2 * .85 * H1Hx/1) )
            ENDIF 
            
            @ 9,53 SAY LEFT(Qm+SPACE(8),8)                                                                                  
            cntr = 6
        CASE cntr = 6
            @ 16,53 GET Ta PICTURE '@!' VALID Chk(Ta,9)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  IF Type = 'T'            
                     cntr = 2
                  ELSE
                     cntr = 4
                  ENDIF   
               CASE prev             && F9
                  RETURN                     
               OTHERWISE
                  rhoair = convert(VAL(Pa)*28.9/(R*VAL(Ta)))
                  @ 14,53 SAY LEFT(rhoair + SPACE(8),8)
                  IF VAL(rho2)/VAL(rhoair) > 1.02
                     buoyancy = 'N'
                     @ 18,3 SAY 'Buoyancy is Negative'
                  ELSE
                     buoyancy = 'P'
                     @ 18,3 SAY 'Buoyancy is Positive'
                     IF VAL(rho2)/VAL(rhoair) > 1.00
                        DO DenseMsg
                     ENDIF
                  ENDIF
                  cntr = 8
            ENDCASE
         CASE cntr = 7   
            DEFINE WINDOW msg FROM 6,10 TO 11,70 SHADOW COLOR &MesColor
            ACTIVATE WINDOW msg
            @ 1,0 SAY PADC('Invalid combination of inputs from previous page !!!',58)
            @ 3,0 SAY PADC('Press any key to continue...',58)
            WAIT ""
            RELEASE WINDOW msg            
            IF type = 'P'
               cntr = 4
            ELSE    
               cntr = 6
            ENDIF   
         CASE cntr = 8         
             DO EL2Keys
             IF prev           && F9
                RETURN
             ENDIF
             
             IF prcd           && F10
                *IF buoyancy = 'P'
                *   DO puffsub
                *ELSE
                   DO s24x4
                *ENDIF        
             ENDIF
             EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
  ENDDO  
ENDDO   

RETURN
