* system : tscreen
* program : s25
* author : Kevin Stroupe, PES
* Modified by: Roger Brode, PES, 4/7/94
*   Corrected equation for BETA (removed factor of 2.)
*   Corrected density ratio check.

* initialize
Pt3 = '0       '
Two_phase = .F.
simult_eqs_err = .F.
R = 8314

ACTIVATE WINDOW datawind
DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1
   DO EL1Keys
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 1 of 4'
   @  6,3 SAY 'INPUT INFORMATION'
   @  7,3 SAY '                  Area (Ao) of Hole or Opening -> '+ LEFT(A0CM+SPACE(8),8) + ' cm'
   @  8,3 SAY '                            Pipe Diameter (Dp) -> '+ LEFT(Dp+SPACE(8),8) + ' m'
   @  9,3 SAY '                              Pipe Length (Lp) -> '+ LEFT(P+SPACE(8),8) + ' m'   
   @ 10,3 SAY '                         Molecular Weight (Mw) -> '+ LEFT(Mw+SPACE(8),8) + ' kg/kmol'
   @ 11,3 SAY '                    Number of Pipe Elbows (Ne) -> '+ LEFT(Ne+SPACE(8),8) 
   @ 12,3 SAY '                         Ambient Pressure (Pa) -> '+ LEFT(Pa+SPACE(8),8) + ' Pa'
   @ 13,3 SAY '                       Reservoir Pressure (P1) -> '+ LEFT(Pr+SPACE(8),8) + ' Pa'
   @ 14,3 SAY '                    Reservoir Temperature (T1) -> '+ LEFT(T1+SPACE(8),8) + ' K'
   @ 15,3 SAY '                        Gas Heat Capacity (Cp) -> '+ LEFT(Cp+SPACE(8),8) + ' J/kg K'

   @  7, 53 FILL TO  7,60 COLOR &IPColor  
   @  8, 53 FILL TO  8,60 COLOR &IPColor  
   @  9, 53 FILL TO  9,60 COLOR &IPColor  
   @ 10, 53 FILL TO 10,60 COLOR &IPColor 
   @ 11, 53 FILL TO 11,60 COLOR &IPColor 
   @ 12, 53 FILL TO 12,60 COLOR &IPColor 
   @ 13, 53 FILL TO 13,60 COLOR &IPColor  
   @ 14, 53 FILL TO 14,60 COLOR &IPColor  
   @ 15, 53 FILL TO 15,60 COLOR &IPColor  

* simult_eqs_err indicates if the simultaneous equation program PIPERES returned an error
* if so the inputs must be re-entered so program loops back, prints an error message
*    and requests inputs
* else if .NOT. simult_eqs_err do not print warning and begin inputs with title

   IF simult_eqs_err 
      KEYBOARD CHR(13)    && skip title field after it is rewritten
      DO title            && rewrite title field
      DEFINE WINDOW msg FROM 6,12 TO 11,58 SHADOW COLOR &MesColor
      ACTIVATE WINDOW msg
      @ 1,0 SAY PADC('Invalid  combination of inputs !!!',44)
      @ 3,0 SAY PADC('Press any key to continue...',44)
      WAIT ""
      RELEASE WINDOW msg
      cntr = 1
      err = .F.
   ELSE
      cntr = 0
   ENDIF 
     
   DO WHILE .NOT. abort
      DO CASE 
         CASE cntr = 0
            DO title
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 0
               CASE prev  && F9            
                  RETURN                
               OTHERWISE                 
                  cntr = 1
            ENDCASE
         CASE cntr = 1
            @ 7,53 GET A0CM PICTURE '@!' VALID Chk(A0CM,3)           
            @ 8,53 GET Dp PICTURE '@!' VALID Chk(Dp,3)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 0
               CASE prev             && F9
                  RETURN   
               OTHERWISE 
                  * Check Beta
                  A0 = convert(VAL(A0CM)/10000)
                  A1 = 3.14159 * (VAL(Dp)/2)^2
*                  beta = 2 * SQRT(VAL(A0)/A1)
                  beta = SQRT(VAL(A0)/A1)
                  IF beta <= .2 
                     DEFINE WINDOW question FROM 8,13 TO 18,65 SHADOW COLOR &MesColor
                     ACTIVATE WINDOW question
                     @ 1,0 SAY PADC('Scenario 2.3 -',53)
                     @ 2,0 SAY PADC('Continuous Leaks from Reservoir',53)
                     @ 3,0 SAY PADC('may be more appropriate.',53)
                     WAIT
                     RELEASE WINDOW question
                     abort = .T.
                     EXIT
                  ENDIF                     
                  * Calculate Diameter of hole or opening (D0)
                  D0 = convert(SQRT(4 * VAL(A0)/3.14159))
                  D = D0
                  cntr = 2
             ENDCASE 
         CASE cntr = 2 
            @ 9,53 GET P PICTURE '@!' VALID Chk(P,3)           
            @ 10,53 GET Mw PICTURE '@!' VALID Chk(Mw,8)         
            @ 11,53 GET Ne PICTURE '@!' VALID Chk(Ne,3)
            @ 12,53 GET Pa PICTURE '@!' VALID Chk(Pa,3)            
            @ 13,53 GET Pr PICTURE '@!' VALID Chk(Pr,3)           
            @ 14,53 GET T1 PICTURE '@!' VALID Chk(T1,9)           
            @ 15,53 GET Cp PICTURE '@!' VALID Chk(Cp,3)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               OTHERWISE 
                  *R = 1.987
                  * Calculate Gamma 
                  Gamma = 1/(1-(R/(VAL(Cp)*VAL(Mw))))               
                  IF Gamma < 0 
                     DEFINE WINDOW msg FROM 6,12 TO 11,58 SHADOW COLOR &MesColor
                     ACTIVATE WINDOW msg
                     @ 1,0 SAY PADC('Invalid  combination of inputs !!!',44)
                     @ 3,0 SAY PADC('Press any key to continue...',44)
                     WAIT ""
                     RELEASE WINDOW msg            
                     cntr = 2
                     LOOP
                  ENDIF                  
                  cntr = 3
             ENDCASE              
          CASE cntr = 3
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF
            IF prcd           && F10
               simult_eqs_err = .F.
                          
               HIDE MENUS ALL
               HIDE POPUPS ALL
               DEACTIVATE WINDOW datawind

               SET COLOR TO W+/BG
               @ 0,0 SAY PADC("",80,' ')

               @ 10,14 FILL TO 16,64 COLOR N/N
               @ 9,12 TO 15,61 COLOR &MesColor
               @ 9,12 FILL TO 15,62 COLOR &MesColor
               @ 12,16 SAY 'Performing Calculations, Please stand by...' COLOR &MesColor

               * Create Input file into PIPERES.EXE
               IF FILE('PIPE.DAT')
                  DELETE FILE 'PIPE.DAT'
               ENDIF
               ifp = FCREATE('PIPE.DAT')
               bytes = FPUTS(ifp,D)
               bytes = FPUTS(ifp,Dp)
               bytes = FPUTS(ifp,P)
               bytes = FPUTS(ifp,Mw)
               bytes = FPUTS(ifp,Ne)
               bytes = FPUTS(ifp,Pa)
               bytes = FPUTS(ifp,Pr)
               bytes = FPUTS(ifp,T1)
               bytes = FPUTS(ifp,convert(Gamma))
               =FCLOSE(ifp)

               * Run program to perform simultaneous equations
               !/0 PIPERES > nul
               
 
               * Get output from PIPERES   
               ifp = FOPEN('PIPE.OUT')
               FlowChar = ALLTRIM(FGETS(ifp))
               IF .NOT. FlowChar $ 'S C'
                  simult_eqs_err = .T.
               ELSE
                  Qm   = ALLTRIM(FGETS(ifp))
                  Qm = Convert(VAL(Qm) * 1000)
                  Ts   = ALLTRIM(FGETS(ifp))
                  rho3 = ALLTRIM(FGETS(ifp))
                  N    = ALLTRIM(FGETS(ifp))
                  P3   = ALLTRIM(FGETS(ifp))
                  G_mass_flux = ALLTRIM(FGETS(ifp))
               ENDIF   
               =FCLOSE(ifp)
               DELETE FILE 'PIPE.DAT'
               DELETE FILE 'PIPE.OUT'

               @ 9,10 CLEAR TO 16,70
 
               SET COLOR TO W+/B
               @0,0 SAY PADC("",80,' ')
  
               SHOW MENUS ALL
               SHOW POPUPS ALL
 
	       DEFINE WINDOW datawind FROM 0,1 TO 24,79 TITLE label COLOR SCHEME 1
               ACTIVATE WINDOW datawind
            
               IF .NOT. simult_eqs_err
                  DO s25x2
               ENDIF   
            ENDIF
            EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF
   ENDDO
ENDDO   
RETURN
   
******************************* s25x2 ************************************
PROCEDURE s25x2

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1
   DO EL1Keys
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 2 of 4'
   @  3,3 SAY 'CRITICAL TEMPERATURE'
   @  4,3 SAY '                     Critical Temperature (Tc) -> '+ LEFT(Tc+SPACE(8),8) + ' K'
  
   @ 4, 53 FILL TO 4,60 COLOR &IPColor

   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1
            @ 4,53 GET Tc PICTURE '@!' VALID Chk(Tc,9)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
               abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP
                  cntr = 1
               CASE prev
                  RETURN
               OTHERWISE
                  IF VAL(Ts) > VAL(Tc)
                     two_phase = .F.
                     cntr = 4
                     @ 6,3 CLEAR TO 11,75
                     Got_Tb_Lvap = .F.
                  ELSE
                     Got_Tb_Lvap = .T.
                     cntr = 2
                  ENDIF                  
            ENDCASE                         
         CASE cntr = 2  
            @ 6,3 SAY 'VAPOR PRESSURE'
            *IF Pt3 = '0'
               @ 7,3 SAY '  Vapor Pressure (Pv) at Discharge Temperature ->          Pa'
            *ELSE   
            *   @ 7,3 SAY '  Vapor Pressure (Pv) at Discharge Temperature -> ' + LEFT(Pt3+SPACE(8),8) + ' atm'            
            *ENDIF           
            @  8,3 TO 11,75
            @  9,5 SAY '    Latent Heat of Vaporization (Lvap) at Tb -> ' + LEFT(Lvap+SPACE(8),8) + ' kg/kmol'
            @ 10,5 SAY '              Boiling Point Temperature (Tb) -> ' + LEFT(Tb+SPACE(8),8) + ' K'
            
            @ 9,53 GET Lvap PICTURE '@!' VALID Chk(Lvap,0)
            @ 10,53 GET Tb PICTURE '@!' VALID Chk(Tb,9)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP
                  cntr = 1
               CASE prev
                  RETURN
               OTHERWISE
                  * Calculate Vapor Pressure at Discharge Temperature (Pt3)
                  exponent = ((VAL(Lvap)*VAL(Mw))/R)*((1/VAL(Tb)) - (1/VAL(Ts)))
                  IF exponent > 88.02969
                     WAIT 'Invalid combination of inputs, '+press WINDOW
                     cntr = 2
                     LOOP
                  ELSE
                     Pt3 = LEFT(convert(101325*EXP(exponent))+SPACE(8),8)
                     @ 7,53 SAY LEFT(Pt3+SPACE(8),8)
                     IF VAL(Pt3) <= 0
                        WAIT 'Vapor Pressure must be > 0, '+press WINDOW
                        cntr = 2
                        LOOP
                     ENDIF
                  ENDIF
                  cntr = 3
            ENDCASE
         CASE cntr = 3
            * Perform Check
            IF VAL(Pt3) <= VAL(Pa)
               * Calculate choked pressure Px                  
               Px = VAL(Pr)*(2/(gamma+1))^(gamma/(gamma-1))
               DEFINE WINDOW msg FROM 5,13 TO 11,65 SHADOW COLOR &MesColor
               ACTIVATE WINDOW msg
               @ 0,0 SAY PADC('Vapor Pressure  Ambient Pressure',53)
               IF Px >= VAL(Pa)   
                  FlowChar = 'C'
                  @ 2,0 SAY PADC('This is a two-phase choked release.',53)
               ELSE   
                  FlowChar = 'S'
                  @ 2,0 SAY PADC('This is a two-phase subcritical release.',53)
               ENDIF               
               WAIT
               RELEASE WINDOW msg
               two_phase = .T.
               @ 12,3 CLEAR TO 19,75
               IF FlowChar = 'C'
                  *D = convert(VAL(D0) * SQRT(Px/VAL(Pa)))
                  D = D0
                  *@  13,3 SAY 'DIAMETER'
                  *@  14,3 SAY '  Diameter accounting for initial air dilution -> '+LEFT(D+SPACE(8),8)+' m'
               ENDIF   
               cntr = 5
            ELSE
               two_phase = .F.   
               cntr = 4
            ENDIF
         CASE cntr = 4
            @ 12,3 SAY 'EMISSION CHARACTERISTICS'
            @ 13,3 SAY '                           Flow Characteristic -> ' + IIF(FlowChar='C','Choked','Subcritical')
            @ 14,3 SAY '                            Emission Rate (Qm) -> ' + LEFT(Qm+SPACE(8),8) + ' g/s'
            @ 15,3 SAY '                         Exit Temperature (T3) -> ' + LEFT(Ts+SPACE(8),8) + ' K'
            @ 16,3 SAY '                        Discharge Density (3) -> ' + LEFT(rho3+SPACE(8),8) + ' kg/cubic m'
            @ 17,3 SAY '                        Pipe Friction Loss (N) -> ' + LEFT(N+SPACE(8),8) 
            @ 18,3 SAY '                            Exit Pressure (P3) -> ' + LEFT(P3+SPACE(8),8) + ' Pa' 
            @ 19,3 SAY '                                 Mass Flux (G) -> ' + LEFT(G_mass_flux+SPACE(8),8) + ' kg/ms' 
            IF FlowChar = 'C'
               *D = convert(VAL(D0) * SQRT(VAL(P3)/VAL(Pa)))
               D = D0
               *@  19,3 SAY '  Diameter accounting for initial air dilution -> '+LEFT(D+SPACE(8),8)+' m'
            ELSE
               D = D0   
            ENDIF   
            cntr = 5
            rho2 = rho3
         CASE cntr = 5
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF
            IF prcd           && F10
               IF two_phase 
                  IF FlowChar = 'C'
                     DO s25x3C2P  
                  ELSE   
                     D = D0
                     DO s25x3S2P  
                  ENDIF
               ELSE               
                  DO s25x3
               ENDIF   
            ENDIF
            EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF
   ENDDO
ENDDO   
RETURN            

******************************* s25x3 ************************************
PROCEDURE s25x3

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 3 of 4'
   @  3,3 SAY 'DENSITY'
   @  4,3 SAY '                         Density of Air (air) ->          kg/cubic m'
   @  5,3 TO 7,75
   @  6,5 SAY '                    Ambient Temperature (Ta) -> '+ LEFT(Ta+SPACE(8),8) +' K'
  
   @ 6, 53 FILL TO 6,60 COLOR &IPColor

   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1
            @ 6,53 GET Ta PICTURE '@!' VALID Chk(Ta,9)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN                     
               OTHERWISE 
                  rhoair = convert(VAL(Pa)*28.9/(R*VAL(Ta)))
                  @ 4,53 SAY LEFT(rhoair + SPACE(8),8)
                  IF VAL(rho3)/VAL(rhoair) > 1.02
                     buoyancy = 'N'
                     @ 8,3 SAY 'Buoyancy is Negative'
                  ELSE    
                     buoyancy = 'P'
                     @ 8,3 SAY 'Buoyancy is Positive'
                     IF VAL(rho2)/VAL(rhoair) > 1.00
                        DO DenseMsg
                     ENDIF
                  ENDIF
                  cntr = 2
            ENDCASE   
         CASE cntr = 2
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF                 
            IF prcd           && F10
               IF buoyancy = 'P'
                  DO scrnpsub
               ELSE
                  DO S25x4
               ENDIF             
            ENDIF   
            EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO   
RETURN
               
****************************** s25x3C2P ***********************************
PROCEDURE s25x3C2P

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 3 of 4'
   @  3,3 SAY 'EMISSION RATE'
   @  4,3 SAY '                            Emission Rate (Qm) ->          g/s'        
   @  5,3 TO 7,75
   @  6,5 SAY '        Density at Reservoir Conditions (1) -> ' + LEFT(Pl+SPACE(8),8) + ' kg/cubic m'       

   @ 10,3 SAY 'DISCHARGE CHARACTERISTICS'
   @ 11,3 SAY '                    Discharge Temperature (T2) ->          K'
   @ 12,3 SAY '                        Discharge Density (2) ->          kg/cubic m'
   *@ 13,3 SAY '  Diameter accounting for initial air dilution ->          m'
   @ 15,3 SAY '                         Density of Air (air) ->          kg/cubic m'
   @ 16,3 TO 18,75
   @ 17,5 SAY '                    Ambient Temperature (Ta) -> ' + LEFT(Ta+SPACE(8),8) + ' K'
   
   @ 6, 53 FILL TO 6,60 COLOR &IPColor

   @ 17, 53 FILL TO 17,60 COLOR &IPColor

   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1
            @ 6,53 GET Pl PICTURE '@!' VALID Chk(Pl,3)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN                     
               OTHERWISE
                  cntr = 2
            ENDCASE
         CASE cntr = 2          
           * Calculate Tx
           Tx = Convert(1 / ( 1/VAL(Tb) - R/(VAL(Lvap)*VAL(Mw)) * LOG(Px/101325) ))
           
           IF VAL(Tx) <=0  .OR. Px <= 0 
              cntr = 6
              LOOP
           ENDIF           
            
           * Calculate vapor fraction at choked flow conditions Xx
           Xx = 1 + (VAL(Tx)/(VAL(Lvap)*VAL(Mw))) * (VAL(Mw)* VAL(Cp)*LOG(VAL(T1)/VAL(Tx)) - R*LOG(VAL(Pr)/Px) )
           
           * Calculate enthalpy change (H1-Hx)
           H1Hx = VAL(Cp)*(VAL(T1)-VAL(Tx)) + VAL(Lvap)*(1-Xx)
           
           * Calculate Density RHOx
           rhox = 1/( (Xx*(R*VAL(Tx))/(Px*VAL(Mw))) + (1-Xx)/VAL(Pl) )  
           cntr = 3
         CASE cntr = 3
            * Calculate Emission rate
            constf = .0045

            IF (2 * .85 * (H1Hx/((1+(4*constf*VAL(P)/VAL(Dp))))) ) < 0
               cntr = 6
               LOOP
            ENDIF

            Qm = convert(1000 * VAL(A0) * rhox * SQRT(2 * .85 * (H1Hx/((1+(4*constf*VAL(P)/VAL(Dp))))) ) )
            
            @ 4,53 SAY LEFT(Qm+SPACE(8),8)                                                                                  
            IF VAL(Qm) <= 0
               WAIT 'Emission rate must be > 0, '+press WINDOW
               cntr = 1
               LOOP                      
             ELSE
               cntr = 4
             ENDIF   
         CASE cntr = 4
            * Calculate Discharge Temperature T2
            *R = 1.987            
            Ts = Convert(1 / ( 1/VAL(Tb) - R/(VAL(Lvap)*VAL(Mw)) * LOG(VAL(Pa)/101325)) )

            * Calculate vapor fraction at discharge flow conditions X2
            X2 = Xx + ( VAL(Cp) * (VAL(Tx)-VAL(Ts)) / VAL(Lvap) )
            
            IF X2 <= 0 .OR. X2 >=1 
               * Calculate Discharge Temperature Ts
               Ts = convert( VAL(Tx) + ( VAL(Lvap) * (1-Xx) / VAL(Cp) ) )
             
               * Calculate Discharge Density rho2
               rho2 = Convert(VAL(Pa)*VAL(Mw)/(R*VAL(Ts)))
            ELSE
               * Calculate Discharge Density rho2
               rho2 = convert(1/( (X2*(R*VAL(Ts))/(VAL(Pa)*VAL(Mw))) + (1-X2)/VAL(Pl) ) )
            ENDIF
            @ 11,53 SAY LEFT(Ts+SPACE(8),8)                               
            @ 12,53 SAY LEFT(rho2+SPACE(8),8)

            * For Choked flow conditions:
            *    modify the diameter to account for initial air dilution 
            *    due to jetting or momentum effects
            *D = convert(VAL(D0) * SQRT(rhox/VAL(rho2)))
            *@ 13,53 SAY LEFT(D+SPACE(8),8)                                    
            D = D0
            
            cntr = 5
         CASE cntr = 5
            @ 17,53 GET Ta PICTURE '@!' VALID Chk(Ta,9)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 2
               CASE prev             && F9
                  RETURN                     
               OTHERWISE
                  rhoair = convert(VAL(Pa)*28.9/(R*VAL(Ta)))
                  @ 15,53 SAY LEFT(rhoair + SPACE(8),8)
                  IF VAL(rho2)/VAL(rhoair) > 1.02
                     buoyancy = 'N'
                     @ 19,3 SAY 'Buoyancy is Negative'
                  ELSE    
                     buoyancy = 'P'
                     @ 19,3 SAY 'Buoyancy is Positive'
                     IF VAL(rho2)/VAL(rhoair) > 1.00
                        DO DenseMsg
                     ENDIF
                  ENDIF
                  cntr = 7
            ENDCASE
         CASE cntr = 6
            DEFINE WINDOW msg FROM 6,12 TO 11,58 SHADOW COLOR &MesColor
            ACTIVATE WINDOW msg
            @ 1,0 SAY PADC('Invalid  combination of inputs !!!',44)
            @ 3,0 SAY PADC('Press any key to continue...',44)
            WAIT ""
            RELEASE WINDOW msg            
            cntr = 1            
         CASE cntr = 7
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF                 
            IF prcd           && F10
               IF buoyancy = 'P'
                  DO scrnpsub
               ELSE
                  DO s25x4
               ENDIF             
            ENDIF   
            EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO   
RETURN   
         
****************************** s25x3S2P ***********************************
PROCEDURE s25x3S2P

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  0,3 SAY 'SOURCE PARAMETERS - Page 3 of 4'
   @  2,3 SAY 'DISCHARGE CHARACTERISTICS'
   @  4,3 SAY '                    Discharge Temperature (T2) ->          K' 
   @  6,3 SAY '                        Discharge Density (2) ->          kg/cubic m'
   @  8,3 SAY 'EMISSION RATE'
   @  9,3 SAY '                           Emissions Rate (Qm) ->          g/s'
   @ 13,3 SAY 'DENSITY OF AIR'
   @ 14,3 SAY '                         Density of Air (air) ->          kg/cubic m'
   @ 15,3 TO 17,75
   @ 16,5 SAY '                    Ambient Temperature (Ta) -> ' + LEFT(Ta+SPACE(8),8) +' K'

   @ 16,53 FILL TO 16,60 COLOR &IPColor
   
   cntr = 1

   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1
            * Calculate Discharge Temperature (Ts)
            Ts = convert(1/( (1/VAL(Tb)) - LOG(VAL(Pa)/101325)*R/(VAL(Lvap)* VAL(Mw)) ))
            @ 4,53 SAY LEFT(Ts+SPACE(8),8)
            IF VAL(Ts) <= 0 
               cntr = 5
               LOOP
            ENDIF
            cntr = 2
          CASE cntr = 2
             * Calculate vapor fraction at discharge conditions X2
             X2 = 1 + (VAL(Ts)/(VAL(Lvap)*VAL(Mw))) * (VAL(Mw)*VAL(Cp)*LOG(VAL(T1)/VAL(Ts)) - R*LOG(VAL(Pr)/VAL(Pa)) )
             
             * Calculate enthalpy change H1-Hx
             H1Hx = VAL(Cp)*(VAL(T1)-VAL(Ts)) + VAL(Lvap)*(1-X2)             
             
             * Calculate Discharge Density RHO2
             rho2 = Convert(1/( (X2*(R*VAL(Ts))/(VAL(Pa)*VAL(Mw))) + (1-X2)/VAL(Pl) )  )
             
             @ 6,53 SAY LEFT(rho2+SPACE(8),8)
             cntr = 3
          CASE cntr = 3
            * Calculate Emission rate
            constf = .0045
            IF (2 * .85 * (H1Hx/((1+(4*constf*VAL(P)/VAL(Dp))))) ) < 0
               cntr = 5
               LOOP
            ENDIF
            Qm = convert(1000 * VAL(A0) * VAL(rho2) * SQRT(2 * .85 * (H1Hx/((1+(4*constf*VAL(P)/VAL(Dp))))) ) )
            
            @ 9,53 SAY LEFT(Qm+SPACE(8),8)                                                                                  
            cntr = 4
          CASE cntr = 4
            @ 16,53 GET Ta PICTURE '@!' VALID Chk(Ta,9)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 4
               CASE prev             && F9
                  RETURN                     
               OTHERWISE
                  rhoair = convert(VAL(Pa)*28.9/(R*VAL(Ta)))
                  @ 14,53 SAY LEFT(rhoair + SPACE(8),8)
                  IF VAL(rho2)/VAL(rhoair) > 1.02
                     buoyancy = 'N'
                     @ 18,3 SAY 'Buoyancy is Negative'
                  ELSE
                     buoyancy = 'P'
                     @ 18,3 SAY 'Buoyancy is Positive'
                     IF VAL(rho2)/VAL(rhoair) > 1.00
                        DO DenseMsg
                     ENDIF
                  ENDIF
                  cntr = 6
            ENDCASE
         CASE cntr = 5
            DEFINE WINDOW msg FROM 6,10 TO 11,70 SHADOW COLOR &MesColor
            ACTIVATE WINDOW msg
            @ 1,0 SAY PADC('Invalid  combination of inputs on previous page !!!',58)
            @ 3,0 SAY PADC('Press any key to continue...',58)
            WAIT ""
            RELEASE WINDOW msg            
            cntr = 4
         CASE cntr = 6
             DO EL2Keys
             IF prev           && F9
                RETURN
             ENDIF
             IF prcd           && F10
                IF buoyancy = 'P'
                   DO scrnpsub
                 ELSE
                   DO s25x4
                ENDIF        
             ENDIF
             EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
  ENDDO  
ENDDO   

RETURN


******************************* s25x4 ************************************
PROCEDURE s25x4

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  0,3 SAY 'SOURCE PARAMETERS - Page 4 of 4'
   @  2,3 SAY 'VERTICALLY DIRECTED JET'
   @  3,3 SAY '       Does the release result in a vertically '
   @  4,3 SAY '                            directed jet (Y/N) -> '+LEFT(YN+' ',1)
   @  6,3 SAY 'TIME'
   @  7,3 SAY '                         Release Duration (Td) ->          min'            
   @  8,3 TO 10,75
   @  9,5 SAY '       Total Amount of Material Released (Q) -> ' + LEFT(QKG+SPACE(8),8) + ' kg'

   @ 4, 53 FILL TO 4,53 COLOR &IPColor   
   @  9, 53 FILL TO 9,60 COLOR &IPColor                           

   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1
            @ 4,53 GET YN PICTURE '@!' VALID ChkYN(YN)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN                     
               OTHERWISE
                  cntr = 2
            ENDCASE      
         CASE cntr = 2            
            @ 9,53 GET QKG PICTURE '@!' VALID Chk(QKG,3)   
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN                     
               OTHERWISE
                  Q = convert(VAL(QKG)*1000)
                  * Calculate Release Duration (Dur)
                  Dur = convert(VAL(Q) / VAL(Qm) /60)
                  @ 7,53 SAY LEFT(Dur+SPACE(8),8) 
                  cntr = 3
            ENDCASE                  
         CASE cntr = 3
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF                 
            IF prcd           && F10
               IF YN = 'Y'
                  DO rvdsub
               ELSE
                  DO bmsub
               ENDIF
            ENDIF   
            EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO   
RETURN
