* system : tscreen
* program : s28
* author : Kevin Stroupe, PES

R = 8314

ACTIVATE WINDOW datawind
DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 1, 3 SAY 'SOURCE PARAMETERS - Page 1 of 2'
   @ 6, 3 SAY 'EMISSIONS RATE'
   @ 7, 3 SAY '      Is the Emission Rate (Qm) known (Y/N) -> '+LEFT(Emyn+' ',1)   
   @ 7, 50 FILL TO 7,50 COLOR &IPColor         
   cntr = 0
   DO WHILE .NOT. abort
      DO CASE 
         CASE cntr = 0
            DO title
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 0
               CASE prev  && F9            
                  RETURN                
               OTHERWISE  
                  cntr = 1
            ENDCASE 
         CASE cntr = 1
            @ 7,50 GET Emyn PICTURE '@!' VALID ChkYN(Emyn)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE prev            && F9
                  RETURN   
               CASE LASTKEY() = 5   && UP 
                 cntr = 0
               OTHERWISE  
                 cntr = 2
            ENDCASE 
         CASE cntr = 2         
            IF Emyn = 'Y'
               cntr = 3
            ELSE 
               cntr = 4
            ENDIF
         CASE cntr = 3
            @ 9,3 CLEAR TO 17,75            
            @ 9, 3 SAY '                   Enter Emission Rate (Qm) ->          g/s' 
            @ 9, 50 FILL TO 9,57 COLOR &IPColor
            @ 9, 50 GET Qm PICTURE '@!' VALID Chk(Qm,3)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE prev
                  RETURN   
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               OTHERWISE 
                  DO EL2Keys
                  IF prev           && F9
                     RETURN
                  ENDIF
                  IF prcd           && F10
                     GotArea = .F.                    
                     DO scrnasub
                  ENDIF
                  EXIT      
            ENDCASE 
         CASE cntr = 4    
            @ 9,3 CLEAR TO 9,75
            @ 9,3 SAY 'VAPOR PRESSURE'
            @ 10,3 SAY 'Enter the Vapor Pressure of the Constituent (Pv),if unknown'
            @ 11,3 SAY '        enter the variables below to calculate -> '+LEFT(Pr+SPACE(8),8) +' Pa'
            @ 12,3 TO 16,75               
            @ 13,5 SAY '          Latent Heat of Vaporization (Lvap) -> '+LEFT(Lvap+SPACE(8),8)+' J/kg'
            @ 14,5 SAY '              Boiling Point Temperature (Tb) -> '+LEFT(Tb+SPACE(8),8)+' K'
            @ 15,5 SAY '                       Molecular Weight (Mw) -> '+LEFT(Mw+SPACE(8),8)+' kg/kmol'    
                
            @ 11,53 FILL TO 11,60 COLOR &IPColor
            @ 13,53 FILL TO 13,60 COLOR &IPColor
            @ 14,53 FILL TO 14,60 COLOR &IPColor
            @ 15,53 FILL TO 15,60 COLOR &IPColor
            
            holdf = Pr
            @ 11,53 GET Pr PICTURE '@!' VALID Chk(Pr,-3)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               CASE LEN(ALLTRIM(Pr)) = 0
                  cntr = 5
               OTHERWISE
                  IF Pr <> holdf
                     Lvap =SPACE(8)
                     Tb = SPACE(8)                
                     
                     @ 13,53 SAY Lvap 
                     @ 14,53 SAY Tb                  
                     @ 13, 53 FILL TO 13,60 COLOR &IPColor
                     @ 14, 53 FILL TO 14,60 COLOR &IPColor                        
                  ENDIF   
                  cntr = 6
            ENDCASE
         CASE cntr = 5
            @ 13,53 GET Lvap PICTURE '@!' VALID Chk(Lvap,3)
            @ 14,53 GET Tb PICTURE '@!' VALID Chk(Tb,11)  	               
            @ 15,53 GET Mw PICTURE '@!' VALID Chk(Mw,8)  	               
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 2
               CASE prev
                  RETURN   
               OTHERWISE 
                  exponent = (VAL(Lvap)*VAL(Mw)/R)*( (1/VAL(Tb)) - (1/298) )                
                  IF exponent > 88.02969
                     WAIT 'Invalid combination of inputs, '+press WINDOW
                     cntr = 5
                     LOOP
                  ENDIF                
                  Pr = convert(101325*EXP(exponent))           
                  Pr = LEFT(Pr+SPACE(8),8)
                  @ 11,53 SAY Pr                                                     
                  @ 11, 53 FILL TO 11,60 COLOR &IPColor  
                  cntr = 6                
               ENDCASE
                    
            CASE cntr = 6
               IF VAL(Pr) <= 0                    
                  WAIT 'Vapor Pressure must be > 0, '+press WINDOW      
                  cntr = 4
                  LOOP
               ENDIF
               DO EL2Keys
               IF prev           && F9
                  RETURN 
               ENDIF
                   
               IF prcd           && F10
                  DO s28x2
               ENDIF   
               EXIT                                   
      ENDCASE 
   ENDDO
   IF LASTKEY() = 27
      abort = .T.
      EXIT
   ENDIF               
ENDDO            
DEACTIVATE WINDOW datawind

RETURN


******************************* s28x2 ************************************
PROCEDURE s28x2

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 1, 3 SAY 'SOURCE PARAMETERS - Page 2 of 2'
   @ 3, 3 SAY 'EMISSION RATE'    
   @ 4, 3 SAY '                             Emission Rate (Qm) ->          g/s'   
   @ 5, 3 TO 8,75
   @ 6, 5 SAY 'Parts of Organic Component in Waste Oil (ppm) -> '+LEFT(Ppm+SPACE(8),8)+' g/Mg' 
   @ 7, 5 SAY '                             Release Area (A) -> '+LEFT(A+SPACE(8),8)+' m'
   
   @ 6, 54 FILL TO 6,60 COLOR &IPColor
   @ 7, 54 FILL TO 7,60 COLOR &IPColor  
   
   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1
            @ 6,54 GET Ppm PICTURE '@!' VALID Chk(Ppm,3) 
            @ 7,54 GET A PICTURE '@!' VALID Chk(A,3)                         
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               CASE LEN(ALLTRIM(Pr)) = 0
                  cntr = 2
               OTHERWISE
                  Qm = convert((9.101e-10) * VAL(Ppm) * VAL(A) * SQRT(VAL(Pr)) )
                  @ 4,54 SAY Qm
                  cntr = 2
            ENDCASE         
           
         CASE cntr = 2
            IF VAL(Qm) <= 0                    
               WAIT 'Emission Rate must be > 0, '+press WINDOW      
               cntr = 1
               LOOP
            ENDIF
  
            DO EL2Keys
            IF prev           && F9
               RETURN 
            ENDIF
                  
            IF prcd           && F10
               IF LEN(ALLTRIM(A)) = 0 
                  GotArea = .F.
               ELSE 
                  GotArea = .T.
               ENDIF  
               DO scrnasub                     
             ENDIF   
             EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO

RETURN


