* Program: S38.prg
* System : TSCREEN
* Programmer: Kevin Stroupe, PES
* Modified by: Roger Brode, PES, 4/7/94
*   Corrected equation for BETA (removed factor of 2.)
*   Corrected calculation of Ts to use MAX instead of MIN.

R = 8314

ACTIVATE WINDOW datawind
DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1
   DO EL1Keys
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 1 of 4'
   @  6,3 SAY 'SOURCE OF LEAK'
   @  7,3 SAY '                Area (Ao) of Hole or Opening -> '+ LEFT(A0CM+SPACE(8),8) + ' cm'
   @  8,3 SAY '               Enter P for Pipe - T for Tank -> '+ LEFT(Type+' ',1)
 
   @ 11,3 SAY 'TEMPERATURE'
   @ 12,3 SAY '                  Discharge Temperature (T2) ->          K'
   @ 13,3 TO 16,75
   @ 14,5 SAY '                  Storage Temperature (T1) -> '+LEFT(T1+SPACE(8),8) + ' K'
   @ 15,5 SAY '                  Ambient Temperature (Ta) -> '+LEFT(Ta+SPACE(8),8) + ' K'   
   @ 17,3 SAY 'PUDDLE AREA'  
   @ 18,3 SAY '     Is Maximum Puddle Area (Ap) Known (Y/N) -> '+LEFT(YN+SPACE(8),8)

   @ 7, 51 FILL TO 7,58 COLOR &IPColor  
   @ 8, 51 FILL TO 8,51 COLOR &IPColor   
   @ 14, 51 FILL TO 14,58 COLOR &IPColor   
   @ 15, 51 FILL TO 15,58 COLOR &IPColor   
   @ 18, 51 FILL TO 18,51 COLOR &IPColor   
   cntr = 0
   DO WHILE .NOT. abort
      DO CASE 
         CASE cntr = 0
            DO title
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 0
               CASE prev  && F9            
                  RETURN                
               OTHERWISE  
                  cntr = 1
            ENDCASE
         CASE cntr = 1
            @ 7,51 GET A0CM PICTURE '@!' VALID Chk(A0CM,3)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 0
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                   A0 = convert(VAL(A0CM)/10000)
                  *D = convert(SQRT((4 * VAL(A0))/3.14159))                            
                  cntr = 2   
            ENDCASE         
         CASE cntr = 2
            @ 8,51 GET Type PICTURE '@!' VALID ChkPT(Type)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  IF Type = 'P'
                     H = '0       '
                     cntr = 3                     
                  ELSE
                     Beta = 0
                     Dp = '1       '
                     @ 9, 3 CLEAR TO 9,75
                     cntr = 4   
                  ENDIF   
            ENDCASE      
         CASE cntr = 3
            @ 9,5 SAY '                        Pipe Diameter (Dp) -> '+LEFT(Dp+SPACE(8),8)+' m'                   
            @ 9,51 FILL TO 9,58 
            @ 9,51 GET Dp PICTURE '@!' VALID Chk(Dp,3)                        
            READ           
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 2
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  * Calculate flow area A1
                  A1 = 3.14159 * (VAL(Dp)/2)^2
*                  Beta = 2 * SQRT(VAL(A0)/A1)
                  Beta = SQRT(VAL(A0)/A1)
                  cntr = 4   
            ENDCASE   
         CASE cntr = 4
            @ 14,51 GET T1 PICTURE '@!' VALID Chk(T1,9)            
            @ 15,51 GET Ta PICTURE '@!' VALID Chk(Ta,9)            
            READ           
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  IF Type = 'P'
                     cntr = 3
                  ELSE                   
                     cntr = 2
                  ENDIF
               CASE prev             && F9
                  RETURN   
               OTHERWISE
*                  Ts = Convert(MIN(VAL(T1),VAL(Ta)))
                  Ts = Convert(MAX(VAL(T1),VAL(Ta)))
                  @ 12,51 SAY LEFT(Ts+SPACE(8),8)                  
                  cntr = 5
            ENDCASE   
         CASE cntr = 5   
            @ 18,51 GET YN PICTURE '@!' VALID ChkYN(YN)                  
            READ           
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  KEYBOARD CHR(13)
                  cntr = 4
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  IF YN = 'Y'
                     cntr = 6
                  ELSE
                     @ 19, 3 CLEAR TO 19,75
                     cntr = 7
                  ENDIF   
            ENDCASE   
         CASE cntr = 6
            @ 19,5 SAY '                  Maximum Puddle Area (Ap) -> '+LEFT(Ap+SPACE(8),8)+' m'                   
            @ 19,51 FILL TO 19,58 
            @ 19,51 GET Ap PICTURE '@!' VALID Chk(Ap,3)                        
            READ           
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 5
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  cntr = 7
            ENDCASE               
         CASE cntr = 7
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF                 
            IF prcd           && F10
               DO s38x2
            ENDIF   
            EXIT           
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO
             
DEACTIVATE WINDOW datawind

RETURN

******************************* s38x2 ************************************
PROCEDURE s38x2

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1
   DO EL1Keys
   prcd = .F.
   @  0,3 SAY 'SOURCE PARAMETERS - Page 2 of 4'
   @  2,3 SAY 'PRESSURE'
   @  3,3 SAY '                        Liquid Pressure (P*) ->          Pa'
   IF Type = 'T'
      @ 4,3 TO 10,75
   ELSE
      @ 4,3 TO 8,75
   ENDIF
   @  5,5 SAY '                     Ambient Pressure (Pa) -> ' + LEFT(Pa+SPACE(8),8) + ' Pa'
   @  6,5 SAY '                   Reservoir Pressure (P1) -> ' + LEFT(Pr+SPACE(8),8) + ' Pa'
   @  7,5 SAY '           Contaminant Liquid Density (1) -> ' + LEFT(Pl+SPACE(8),8) + ' kg/cubic m'
   IF Type = 'T'
      @  8,5 SAY '          Distance between Hole or Opening'
      @  9,5 SAY '          and Top of the Liquid Level (Hl) -> ' + LEFT(H+SPACE(8),8) + ' m'
   ENDIF
   @ 12,3 SAY 'VAPOR PRESSURE'
   @ 13,3 SAY '                         Vapor Pressure (Pv) ->          Pa'     
   @ 14,3 TO 18,75   
   @ 15,5 SAY '                     Molecular Weight (Mw) -> ' + LEFT(Mw+SPACE(8),8) + ' kg/kmol'
   @ 16,5 SAY '        Latent Heat of Vaporization (Lvap) -> ' + LEFT(Lvap+SPACE(8),8) + ' J/kg'
   @ 17,5 SAY '            Boiling Point Temperature (Tb) -> ' + LEFT(Tb+SPACE(8),8) + ' K'
*   @ 18,5 SAY '                  Storage Temperature (T1) -> ' + LEFT(Ts+SPACE(8),8) + ' K'

   @ 5, 51 FILL TO 5,58 COLOR &IPColor  
   @ 6, 51 FILL TO 6,58 COLOR &IPColor  
   @ 7, 51 FILL TO 7,58 COLOR &IPColor  
   IF Type = 'T'
      @ 9, 51 FILL TO 9,58 COLOR &IPColor   
   ENDIF   
   @ 15, 51 FILL TO 15,58 COLOR &IPColor   
   @ 16, 51 FILL TO 16,58 COLOR &IPColor   
   @ 17, 51 FILL TO 17,58 COLOR &IPColor   
*   @ 18, 51 FILL TO 18,58 COLOR &IPColor   
   
   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1
            @ 5,51 GET Pa PICTURE '@!' VALID Chk(Pa,3)
            @ 6,51 GET Pr PICTURE '@!' VALID Chk(Pr,3)
            @ 7,51 GET Pl PICTURE '@!' VALID Chk(Pl,3)
            IF Type = 'T'
               @ 9,51 GET H PICTURE '@!' VALID Chk(H,2)
            ENDIF   
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  * Calculate liquid pressure at the hole or opening Px
                  g = 9.81
                  Px = convert(MAX(VAL(Pa),VAL(Pr)) + VAL(Pl)*g*VAL(H))
                  @ 3,51 SAY LEFT(Px+SPACE(8),8)                  
                  IF VAL(Px) = VAL(Pr)
                     DEFINE WINDOW msg FROM 11,13 TO 18,65 SHADOW COLOR &MesColor
                     ACTIVATE WINDOW msg
                     @ 2,0 SAY PADC('P* cannot = P1 ',53)
                     WAIT
                     RELEASE WINDOW msg
                     cntr = 1
                  ELSE
                     cntr = 2
                  ENDIF      
             ENDCASE          
         CASE cntr = 2
            @ 15,51 GET Mw PICTURE '@!' VALID Chk(Mw,8)
            @ 16,51 GET Lvap PICTURE '@!' VALID Chk(Lvap,3)
            @ 17,51 GET Tb PICTURE '@!' VALID Chk(Tb,9)
 *           @ 18,51 GET Ts PICTURE '@!' VALID Chk(Ts,9)            
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  KEYBOARD CHR(13)
                  KEYBOARD CHR(13)
                  IF Type = 'T'
                     KEYBOARD CHR(13)
                  ENDIF   
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  * Calculate vapor pressure Pv                  
                  exponent = (VAL(Lvap)*VAL(Mw)/R) * ( (1/VAL(Tb)) - (1/VAL(Ts)) )                  
                  
                  IF exponent > 88.02969
                     WAIT 'Invalid combination of inputs, '+press WINDOW
                     cntr = 2
                     LOOP
                  ELSE
                     Pv = convert(101325*EXP(exponent))
                     @ 13,51 SAY LEFT(Pv+SPACE(8),8) 
                     IF VAL(Pv) <= 0
                        WAIT 'Vapor Pressure must be > 0, '+press WINDOW
                        cntr = 2
                        LOOP
                     ENDIF
                  ENDIF               
                  cntr = 3
             ENDCASE          
          CASE cntr = 3
             DO EL2Keys
             IF prev           && F9
                RETURN
             ENDIF
             IF prcd           && F10
                DO s38x3
             ENDIF
             EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO

RETURN


************************* s38x3 ****************************************
PROCEDURE s38x3

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1   
   DO EL1Keys
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 3 of 4'   
   @  3,3 SAY 'EMISSION RATE'
   @  4,3 SAY '                          Emission Rate (Qm) ->          g/s'
   @  5,3 TO 7,75
   @  6,5 SAY '                           Wind Speed (Ur) -> '+LEFT(U+SPACE(8),8)+ ' m/s'
   @  9,3 SAY 'AREA'
   @ 10,3 SAY '                                        Area ->          m'   
   @ 12,3 SAY 'DISCHARGE DENSITY'
   @ 13,3 SAY '                      Discharge Density (2) ->          kg/cubic m'
   @ 15,3 SAY 'DENSITY OF AIR'
   @ 16,3 SAY '                       Density of Air (air) ->          kg/cubic m'
*   @ 16,3 TO 18,75
*   @ 17,5 SAY '                  Ambient Temperature (Ta) -> ' + LEFT(Ta+SPACE(8),8) + ' K'


   @  6,51 FILL TO 6,58 COLOR &IPColor
*   @  17,51 FILL TO 17,58 COLOR &IPColor
   
   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
          CASE cntr = 1
             @  6,51 GET U PICTURE '@!' VALID Chk(U,3)  	      
             READ
             DO CASE
                CASE LASTKEY() = 27  && ESCAPE
                   abort = .T.
                   EXIT 
                CASE LASTKEY() = 5   && UP 
                   cntr = 2
                CASE prev
                   RETURN   
                OTHERWISE 
                   ConstC = .65
                   ConstK = ConstC/SQRT(1-Beta^4)

                   IF ( 2 * VAL(Pl) * (VAL(Px)-VAL(Pa)) ) < 0
                      cntr = 4
                      LOOP
                   ENDIF 

                   * Calculate Emission Rate E1
                   E1 = ConstK * VAL(A0) * SQRT( 2 * VAL(Pl) * (VAL(Px)-VAL(Pa)) )
                   
                   * Calculate Vapor Pressure Pvh of hydrazine at Ts
                   Pvh = EXP( 76.8580 - (7245.2/VAL(Ts)) - 8.22*LOG(VAL(Ts)) ;
                         + 0.0061557*VAL(Ts) )
                         
                  * Calculate Puddle Area Ap2
                  Ap2 = E1*Pvh/( 6.94E-7 * (1+.0043*IIF(VAL(Ts)-273.15 < 0,0,(VAL(Ts)-273.15)^2));
                        * VAL(U)^.75 * VAL(Mw) * VAL(Pv))
                        
                  IF YN = 'Y'
                     * Calculate Emission Rate E2
                     E2 = 6.94E-7 * (1+.0043*IIF(VAL(Ts)-273.15 < 0,0,(VAL(Ts)-273.15)^2));
                          * VAL(U)^.75 * VAL(Ap) * VAL(Mw) * VAL(Pv)/Pvh                  
                     
                     IF E2 < E1
                        Qm = convert(E2 *  1000)
                        A = Ap
                     ELSE
                        Qm = convert(E1 * 1000)
                        A = convert(Ap2)
                     ENDIF   
                  ELSE
                     Qm = convert(E1 * 1000)
                     A = convert(Ap2)                  
                  ENDIF             
                                    
                  @ 4,51 SAY LEFT(Qm+SPACE(8),8)
                  @ 10,51 SAY LEFT(A+SPACE(8),8)
                  cntr = 2
                  
                  * Calculate diameter of the puddle
                  D = convert(SQRT((4 * VAL(A))/3.14159))                            
             ENDCASE  
          CASE cntr = 2             
             * Calculate Discharge Density RHO2
             rho2 = convert(VAL(Pa)*VAL(Mw)/(R*VAL(Ts)))
             @  13,51 SAY LEFT(rho2+SPACE(8),8)
             cntr = 3
          CASE cntr = 3
*             @  17,51 GET Ta PICTURE '@!' VALID Chk(Ta,9)  	      
*             READ
*             DO CASE
*                CASE LASTKEY() = 27  && ESCAPE
*                   abort = .T.
*                   EXIT 
*                CASE LASTKEY() = 5   && UP 
*                   cntr = 2
*                CASE prev
*                   RETURN   
*                OTHERWISE 
*                  *R = .08206
                  rhoair = convert(VAL(Pa)*28.9/(R*VAL(Ta)))
                  @ 16,51 SAY LEFT(rhoair + SPACE(8),8)
                  IF VAL(rho2)/VAL(rhoair) > 1.02
                     buoyancy = 'N'
                     @ 18,3 SAY 'Buoyancy is Negative'
                  ELSE    
                     buoyancy = 'P'
                     @ 18,3 SAY 'Buoyancy is Positive'
                     IF VAL(rho2)/VAL(rhoair) > 1.00
                        DO DenseMsg
                     ENDIF
                  ENDIF
                   cntr = 5
*             ENDCASE
         CASE cntr = 4
            DEFINE WINDOW msg FROM 6,12 TO 11,58 SHADOW COLOR &MesColor
            ACTIVATE WINDOW msg
            @ 1,0 SAY PADC('Invalid  combination of inputs !!!',44)
            @ 3,0 SAY PADC('Press any key to continue...',44)
            WAIT ""
            RELEASE WINDOW msg            
            cntr = 1                                    
         CASE cntr = 5
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF                 
            IF prcd           && F10
               GotArea = .T.
               IF buoyancy = 'P'                  
                  DO scrnasub
               ELSE
                  DO s38x4
               ENDIF             
            ENDIF   
            EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO   
RETURN

******************************* s38x4 ************************************
PROCEDURE s38x4

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  0,3 SAY 'SOURCE PARAMETERS - Page 4 of 4'   
   @  2,3 SAY 'TIME'
   @  3,3 SAY '                         Release Duration (Td) ->          min'            
   @  4,3 TO 6,75
   @  5,5 SAY '       Total Amount of Material Released (Q) -> ' + LEFT(QKG+SPACE(8),8) + ' kg'
   @  5, 53 FILL TO 5,60 COLOR &IPColor                           
       
   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1            
            @ 5,53 GET QKG PICTURE '@!' VALID Chk(QKG,3)   
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN                     
               OTHERWISE
                  Q = convert(VAL(QKG)*1000)
                  * Calculate Release Duration (Dur)
                  Dur = convert(VAL(Q) / VAL(Qm) /60)
                  @ 3,53 SAY LEFT(Dur+SPACE(8),8) 
                  cntr = 2
            ENDCASE                        
         CASE cntr = 2
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF                 
            IF prcd           && F10
               DO bmsub
            ENDIF   
            EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO   
RETURN


                        
