* system : tscreen
* program : s42
* author : Roger W. Brode, PES, 4/11/94
* comment: Soil Vapor Extraction - Scenario 4.4.2, uses SCREEN3 Point Source

****  Constants ****
R = 8314                && Ideal Gas Constant - units J/(kg-mole)(K)
****  Default Values *****
Ksoil = '298     '      && Soil Temperature (K)
Qext  = '85      '      && Vapor Extraction Rate (m^3/min)


ACTIVATE WINDOW datawind
DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 0, 3 SAY 'SOURCE PARAMETERS - Page 1 of 2'
   @ 5, 3 SAY 'UNCONTROLLED EMISSION RATE'
   @ 6, 3 SAY '     Enter the Uncontrolled Emission Rate (Qm) -> ' +LEFT(Qunc+SPACE(8),8) +' g/s'
   @ 7, 3 SAY '     If unknown, enter variables below to calculate'
   @ 6, 53 FILL TO 6,60 COLOR &IPColor

   @ 8,3 TO 11,75
   @ 9 ,5 SAY '           Enter Soil Extraction Rate (Qext) -> '+LEFT(Qext+SPACE(8),8)+' m^3/min'
   @ 9 ,53 FILL TO 9 ,60 COLOR &IPColor
   @ 10,5 SAY '   Enter Vent Gas Conc. (or variables below) -> '+LEFT(Cg+SPACE(8),8) +' g/m^3'

   @ 12,3 TO 16,75
   @ 13,5 SAY '                       Molecular Weight (Mw) -> '+LEFT(Mw+SPACE(8),8)+' kg/kgmol'
   @ 14,5 SAY '                       Soil Temperature (Ts) -> '+LEFT(Ksoil+SPACE(8),8)+' K'
   @ 15,5 SAY '   Enter Vapor Pressure (or variables below) -> '+LEFT(Pvap+SPACE(8),8)+' Pa'

   @ 10,53 FILL TO 10,60 COLOR &IPColor
   @ 13,53 FILL TO 13,60 COLOR &IPColor
   @ 14,53 FILL TO 14,60 COLOR &IPColor
   @ 15,53 FILL TO 15,60 COLOR &IPColor

   @ 17,3 TO 20,75
   @ 18,5 SAY '          Latent Heat of Vaporization (Lvap) -> '+LEFT(Lvap+SPACE(8),8)+' J/kg'
   @ 19,5 SAY '              Boiling Point Temperature (Tb) -> '+LEFT(Tb+SPACE(8),8)+' K'

   @ 18,53 FILL TO 18,60 COLOR &IPColor
   @ 19,53 FILL TO 19,60 COLOR &IPColor

   cntr = 0
   DO WHILE .NOT. abort
      holdf = Qunc
      DO CASE 
         CASE cntr = 0
*            DO title
            Title = LEFT(Title+SPACE(63),63)
            @ 2,3 SAY "Enter a unique title for this data's model run:"
            @ 3,3 GET Title VALID ChkTitle(Title)
            READ
            Title = STRTRAN(Title,',',' ')
            @ 3,3 SAY Title COLOR &IPColor
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 0
               CASE prev            && F9
                  RETURN                
               OTHERWISE  
                  cntr = 1
            ENDCASE 
         CASE cntr = 1
            @ 6,53 GET Qunc PICTURE '@!' VALID Chk(Qunc,-9)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE prev            && F9
                  RETURN   
               CASE LASTKEY() = 5   && UP 
                  cntr = 0
               CASE LEN(ALLTRIM(Qunc)) = 0   && No Qunc input
                  cntr = 2
               OTHERWISE
                  DO EL2Keys
                  IF prev           && F9
                     RETURN
                  ENDIF
                  IF prcd           && F10
                     DO s42x2
                  ENDIF
                  EXIT
            ENDCASE 
         CASE cntr = 2         
            @ 9 ,53 GET Qext  PICTURE '@!' VALID Chk(Qext,-3)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 1
               CASE prev            && F9
                  RETURN                
               OTHERWISE  
                  cntr = 3
            ENDCASE 
         CASE cntr = 3
            holdf = Cg
            @ 10,53 GET Cg PICTURE '@!' VALID Chk(Cg,-3)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev            && F9
                  RETURN   
               CASE LEN(ALLTRIM(Cg)) = 0  && No Cg input
                  cntr = 4
               OTHERWISE
                  cntr = 7
            ENDCASE
         CASE cntr = 4
            @ 13,53 GET Mw       PICTURE '@!' VALID Chk(Mw,8)
            @ 14,53 GET Ksoil    PICTURE '@!' VALID Chk(Ksoil,9)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 3
               CASE prev            && F9
                  RETURN   
               OTHERWISE 
                  cntr = 5
            ENDCASE
                    
         CASE cntr = 5
            holdg = Pvap
            @ 15,53 GET Pvap     PICTURE '@!' VALID Chk(Pvap,-3)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP
                  cntr = 4
               CASE prev            && F9
                  RETURN
               CASE LEN(ALLTRIM(Pvap)) = 0  && No Pvap input
                  cntr = 6
               OTHERWISE
                * Calculate Vent Gas Concentration (Cg)
                  Cg = convert((VAL(Pvap) / 101325) * VAL(Mw) * 1.0E9 / (R * VAL(Ksoil)))
                  Cg = LEFT(Cg+SPACE(8),8)
                  @ 10,53 SAY Cg
                  @ 10,53 FILL TO 10,60 COLOR &IPColor
                  cntr = 7
            ENDCASE

         CASE cntr = 6
            @ 18,53 GET Lvap     PICTURE '@!' VALID Chk(Lvap,15)
            @ 19,53 GET Tb       PICTURE '@!' VALID Chk(Tb,9)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE prev            && F9
                  RETURN
               CASE LASTKEY() = 5   && UP
                  cntr = 5
               OTHERWISE
                * Calculate Vapor Pressure (Pvap)
                  Pvap = convert(101325 * EXP( (VAL(Lvap)*VAL(Mw) / R) * (1/VAL(Tb) - 1/VAL(Ksoil)) ))
                  @ 15,53 SAY Pvap
                  @ 15,53 FILL TO 15,60 COLOR &IPColor
                * Calculate Vent Gas Concentration (Cg)
                  Cg = convert((VAL(Pvap) / 101325) * VAL(Mw) * 1.0E9 / (R * VAL(Ksoil)))
                  Cg = LEFT(Cg+SPACE(8),8)
                  @ 10,53 SAY Cg
                  @ 10,53 FILL TO 10,60 COLOR &IPColor
                  cntr = 7
            ENDCASE
         CASE cntr = 7
            * Calculate Uncontrolled Emission Rate, Qunc
              Qunc = convert(VAL(Cg) * VAL(Qext) * 1.67E-5)
              Qunc = LEFT(Qunc+SPACE(8),8)
              @ 6,53 SAY Qunc
              @ 6,53 FILL TO 6,60 COLOR &IPColor
              DO EL2Keys
              IF prev           && F9
                 RETURN
              ENDIF
              IF prcd           && F10
                 DO s42x2
              ENDIF
              EXIT
         OTHERWISE
            ABORT = .T.
            EXIT
                    
      ENDCASE 
   ENDDO
   IF LASTKEY() = 27
      abort = .T.
      EXIT
   ENDIF               
ENDDO            
DEACTIVATE WINDOW datawind

RETURN


******************************* s42x2 ************************************
* Screen 2 of Source Parameters for Soil Vapor Extraction - Scenario 4.4.2
PROCEDURE s42x2

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 2 of 2'
   @  3,3 SAY 'EMISSIONS CONTROL'
   @  5,3 SAY '   Is a Control Device Present in the SVE System? (Y/N) -> '+LEFT(Emyn+' ',1)
   @  5,62 FILL TO 5,62 COLOR &IPColor
   cntr = 1
   DO WHILE .NOT. abort
      DO CASE 
         CASE cntr = 1
            @ 5,62 GET Emyn PICTURE '@!' VALID ChkYN(Emyn)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE prev            && F9
                  RETURN   
               CASE LASTKEY() = 5   && UP 
                 cntr = 0
               OTHERWISE  
                 cntr = 2
            ENDCASE 
         CASE cntr = 2         
            IF Emyn = 'Y'
               cntr = 3
            ELSE
               Qm = Qunc
               DO CASE
                  CASE VAL(Qext) = 85
                     Exitv = '12.5    '
                     Hs = '7.6     '
                     D = '0.38    '
                     Ts = '323     '
                     Ta = '293     '
                     Hb = '0       '
                  CASE VAL(Qext) = 1.4
                     Exitv = '3.0     '
                     Hs = '3.0     '
                     D = '0.10    '
                     Ts = '323     '
                     Ta = '293     '
                     Hb = '0       '
                  CASE VAL(Qext) = 14
                     Exitv = '7.4     '
                     Hs = '4.6     '
                     D = '0.20    '
                     Ts = '323     '
                     Ta = '293     '
                     Hb = '0       '
                  CASE VAL(Qext) = 425
                     Exitv = '14.2    '
                     Hs = '9.1     '
                     D = '0.46    '
                     Ts = '323     '
                     Ta = '293     '
                     Hb = '0       '
                  OTHERWISE
                     Exitv = '        '
                     Hs = '        '
                     D = '        '
                     Ts = '        '
                     Ta = '        '
                     Hb = '0       '
               ENDCASE
               cntr = 4
            ENDIF
         CASE cntr = 3
            @ 9,3 CLEAR TO 17,75            
            @ 9, 3 SAY '         Enter Control Device Type (1 or 2) -> ' +LEFT(Ctype+' ',1)
            @ 10,3 SAY '               1 - Carbon Adsorber'
            @ 11,3 SAY '               2 - Catalytic Oxidizer'
            @ 9, 50 FILL TO 9,50 COLOR &IPColor
            @ 9, 50 GET Ctype PICTURE '@!' VALID ChkCTYPE(Ctype)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE prev
                  RETURN   
               CASE LASTKEY() = 5   && UP 
                  cntr = 2
               CASE VAL(Ctype) = 1
                  Ceff = '90      '
                  @ 13,3 SAY '         Enter Control Efficiency -> '+LEFT(Ceff+SPACE(8),8)+' %'
                  @ 13,40 FILL TO 13,47 COLOR &IPColor
                  @ 13,40 GET Ceff PICTURE '@!' VALID Chk(Ceff,3)
                  READ
                  Qm = convert(VAL(Qunc) * VAL(Ceff)/100)
                  @ 15,3 SAY '         Controlled Emission Rate (g/s) = '+Qm
                  Exitv = '11.5    '
                  Hs = '7.6     '
                  D = '0.38    '
                  Ts = '298     '
                  Ta = '293     '
                  Hb = '0       '
                  cntr = 4
               CASE VAL(Ctype) = 2
                  Ceff = '95      '
                  @ 13,3 SAY '         Enter Control Efficiency -> '+LEFT(Ceff+SPACE(8),8)+' %'
                  @ 13,40 FILL TO 13,47 COLOR &IPColor
                  @ 13,40 GET Ceff PICTURE '@!' VALID Chk(Ceff,3)
                  READ
                  Qm = convert(VAL(Qunc) * VAL(Ceff)/100)
                  @ 15,3 SAY '         Controlled Emission Rate (g/s) = '+Qm
                  Exitv = '22.9    '
                  Hs = '7.6     '
                  D = '0.38    '
                  Ts = '593     '
                  Ta = '293     '
                  Hb = '0       '
                  cntr = 4
            ENDCASE
         CASE cntr = 4
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF
            IF prcd           && F10
               DO scrnpsub    && do SCREEN3 model (for point) input screens
            ENDIF
            EXIT
      ENDCASE

   ENDDO
   IF LASTKEY() = 27
      abort = .T.
      EXIT
   ENDIF               
ENDDO            
DEACTIVATE WINDOW datawind

RETURN
