* system : tscreen
* program : s43
* author : Gerry E. Chike, PES
* comment: Soil Excavation - Scenario 4.4.3, uses SCREEN AREA model


* Variables unique to this scenario
* Csoil	 = SPACE(8)		&& Concentration of Contaminated Soil 		
* Vsoil	 = SPACE(8)		&& Volume of Soil Excavated 
* Asoil	 = SPACE(8)		&& Exposed Surface Area of Contaminated Soil
* BDsoil  = SPACE(8)		&& Bulk Density of Soil
* time	 = SPACE(8)		&& Time to Excavate Soil
* Ksoil	 = SPACE(8)		&& Soil Temperature

* Variables shared by other scenarios
* Pv             = SPACE(8)     && Vapor Pressure in Pa units
* Qm		 = SPACE(8) 	&& Total Emission Rate
* Mw             = SPACE(8)     && Molecular weight

* Private Memory Variables 
* Used for internal calculation of Vapor Pressure and Total Emission Rate
PRIVATE Mass        = 0   && Mass (in g)
PRIVATE ER_ps       = 0   && Emission Rate of Contaminants in Pore Space in Soil(in g/s)
PRIVATE ER_diff     = 0   && Emission Rate of Contaminants from Diffusion (in g/s)
PRIVATE C3          = 0   && Mass Loading of Contaminants (in g/cm^3)
PRIVATE ER_tot      = 0   && Total Emission Rate
PRIVATE Pv_atm      = 0   && Vapor Pressure (Pv) in atm units

****  Constant ****
R = 8314		&& Ideal Gas Constant - units J/(kg-mole)(K) 


ACTIVATE WINDOW datawind
DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 1, 3 SAY 'SOURCE PARAMETERS - Page 1 of 2'
   @ 6, 3 SAY 'EMISSIONS RATE'
   @ 7, 3 SAY '      Is the Emission Rate (Qm) known (Y/N) -> '+LEFT(Emyn+' ',1)   
   @ 7, 50 FILL TO 7,50 COLOR &IPColor         
   cntr = 0
   DO WHILE .NOT. abort
      DO CASE 
         CASE cntr = 0
            DO title
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 0
               CASE prev  && F9            
                  RETURN                
               OTHERWISE  
                  cntr = 1
            ENDCASE 
         CASE cntr = 1
            @ 7,50 GET Emyn PICTURE '@!' VALID ChkYN(Emyn) 	&& get y/n for emission rate (Qm)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE prev            && F9
                  RETURN   
               CASE LASTKEY() = 5   && UP 
                 cntr = 0
               OTHERWISE  
                 cntr = 2
            ENDCASE 
         CASE cntr = 2         
            IF Emyn = 'Y'
               cntr = 3
            ELSE 
               cntr = 4
            ENDIF
         CASE cntr = 3
            @ 9,3 CLEAR TO 17,75            
            @ 9, 3 SAY '                   Enter Emission Rate (Qm) ->          g/s' 
            @ 9, 50 FILL TO 9,57 COLOR &IPColor
            @ 9, 50 GET Qm PICTURE '@!' VALID Chk(Qm,3)
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE prev
                  RETURN   
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               OTHERWISE 
                  DO EL2Keys
                  IF prev           && F9
                     RETURN
                  ENDIF
                  IF prcd           && F10
                     GotArea = .F.                    
                     DO scrnasub		&& do screen model (for area) input screens
                  ENDIF
                  EXIT      
            ENDCASE 
         CASE cntr = 4    
            @ 9,3 CLEAR TO 9,75
            @ 9,3 SAY 'VAPOR PRESSURE'
            @ 10,3 SAY 'Enter the Vapor Pressure of the Constituent (Pv),if unknown'
            @ 11,3 SAY '        enter the variables below to calculate -> '+LEFT(Pv+SPACE(8),8) +' Pa'
            @ 12,3 TO 17,75               
            @ 13,5 SAY '          Latent Heat of Vaporization (Lvap) -> '+LEFT(Lvap+SPACE(8),8)+' J/kg'
            @ 14,5 SAY '              Boiling Point Temperature (Tb) -> '+LEFT(Tb+SPACE(8),8)+' K'
            @ 15,5 SAY '                       Soil Temperature (Ts) -> '+LEFT(Ksoil+SPACE(8),8)+' K'
            @ 16,5 SAY '                       Molecular Weight (Mw) -> '+LEFT(Mw+SPACE(8),8)+' kg/kgmol'    
                
            @ 11,53 FILL TO 11,60 COLOR &IPColor
            @ 13,53 FILL TO 13,60 COLOR &IPColor
            @ 14,53 FILL TO 14,60 COLOR &IPColor
            @ 15,53 FILL TO 15,60 COLOR &IPColor
            @ 16,53 FILL TO 16,60 COLOR &IPColor
            
            holdf = Pv
            @ 11,53 GET Pv PICTURE '@!' VALID Chk(Pv,-3)           
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               CASE LEN(ALLTRIM(Pv)) = 0
                  cntr = 5
               OTHERWISE
                  IF Pv <> holdf
                     Lvap       =  SPACE(8)
                     Tb         =  SPACE(8)
                     Ksoil	=  SPACE(8)
                     Mw		=  SPACE(8)               
                     @ 13,53 SAY Lvap 
                     @ 14,53 SAY Tb
                     @ 15,53 SAY Ksoil
                     @ 16,53 SAY Mw               
                     @ 13,53 FILL TO 13,60 COLOR &IPColor
                     @ 14,53 FILL TO 14,60 COLOR &IPColor
            			@ 15,53 FILL TO 15,60 COLOR &IPColor
            			@ 16,53 FILL TO 16,60 COLOR &IPColor                   
                  ENDIF   
                  cntr = 6
            ENDCASE
         CASE cntr = 5
            @ 13,53 GET Lvap	 PICTURE '@!' VALID Chk(Lvap,3)
            @ 14,53 GET Tb		 PICTURE '@!' VALID Chk(Tb,11)
            @ 15,53 GET Ksoil	 PICTURE '@!' VALID Chk(Ksoil,9) 	               
            @ 16,53 GET Mw		 PICTURE '@!' VALID Chk(Mw,8)  	               
            READ
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 2
               CASE prev
                  RETURN   
               OTHERWISE 
               	* Calculate Vapor Pressure (Pv)
                  exponent = (VAL(Lvap)*VAL(Mw)/R)*( (1/VAL(Tb)) - (1/VAL(Ksoil)) )                
                  IF exponent > 88.02969
                     WAIT 'Invalid combination of inputs, '+press WINDOW
                     cntr = 5
                     LOOP
                  ENDIF                
                  Pv = convert(101325*EXP(exponent))           
                  Pv = LEFT(Pv+SPACE(8),8)
                  @ 11,53 SAY Pv                                                     
                  @ 11,53 FILL TO 11,60 COLOR &IPColor  
                  cntr = 6                
               ENDCASE
                    
            CASE cntr = 6
               IF VAL(Pv) <= 0                    
                  WAIT 'Vapor Pressure must be > 0, '+press WINDOW      
                  cntr = 4
                  LOOP
               ENDIF
               DO EL2Keys
               IF prev           && F9
                  RETURN 
               ENDIF
                   
               IF prcd           && F10
                  DO s43x2
               ENDIF   
               EXIT                                   
      ENDCASE 
   ENDDO
   IF LASTKEY() = 27
      abort = .T.
      EXIT
   ENDIF               
ENDDO            
DEACTIVATE WINDOW datawind

RETURN


******************************* s43x2 ************************************
PROCEDURE s43x2

DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @  1,3 SAY 'SOURCE PARAMETERS - Page 2 of 2'
   @  3,3 SAY 'EMISSION RATE'    
   @  4,3 SAY '                             Emission Rate (Qm) ->          g/s'   
   @  5,3 TO 11,75
   @  6,5 SAY "       Concentration of Contaminated Soil (C) -> " + LEFT(Csoil+SPACE(8),8) + " g/g"
   @  7,5 SAY "                Volume of Soil Excavated (Sv) -> " + LEFT(VSoil+SPACE(8),8) + " m^3"
   @  8,5 SAY "Exposed Surface Area of Contaminated Soil(SA) -> " + LEFT(ASoil+SPACE(8),8) + " m"
   @  9,5 SAY "                      Bulk Density of Soil(B) -> " + LEFT(BDsoil+SPACE(8),8) + " g/cm^3"
   @ 10,5 SAY "                     Time to Excavate Soil(t) -> " + LEFT(time+SPACE(8),8) + " hrs"
    
   @  6,54 FILL TO  6,61 COLOR &IPColor
   @  7,54 FILL TO  7,61 COLOR &IPColor 
   @  8,54 FILL TO  8,61 COLOR &IPColor
   @  9,54 FILL TO  9,61 COLOR &IPColor
   @ 10,54 FILL TO 10,61 COLOR &IPColor 
   
   cntr = 1
   DO WHILE .NOT. abort
      DO CASE
         CASE cntr = 1
            @  6,54 GET Csoil	 PICTURE '@!' VALID Chk(Csoil,3)
            @  7,54 GET Vsoil    PICTURE '@!' VALID Chk(Vsoil,3)
            @  8,54 GET Asoil    PICTURE '@!' VALID Chk(Asoil,3)
            @  9,54 GET BDsoil   PICTURE '@!' VALID Chk(BDsoil,3)
            @ 10,54 GET time     PICTURE '@!' VALID Chk(time,3)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN   
               CASE LEN(ALLTRIM(Pv)) = 0
                  cntr = 2
               OTHERWISE
                * Calculate total emissions
                  Pv_atm = VAL(Pv)/101325
                  Mass = VAL(BDsoil) * VAL(Vsoil) * VAL(Csoil)
                  ER_ps = Pv_atm * VAL(Vsoil) * 0.0013 * VAL(time)/3600
                  IF      ER_ps > ((1/3) * Mass)
                          ER_ps = (Mass * 0.33 * 3600)/VAL(time)
                  ENDIF
                  C3 = VAL(Csoil) * VAL(BDsoil) * 10^-6
                  ER_diff = (VAL(Csoil) * VAL(Asoil) * 10000) / ;
                                           (((9.27 * 10^8) * (C3/Pv_atm)) + ((1.36 * 10^12) * (C3/Pv_atm)))
                  ER_tot = ER_ps + ER_diff
                  Qm = convert(ER_tot)
                  @ 4,54 SAY Qm
                  cntr = 2
            ENDCASE         
           
         CASE cntr = 2
            IF VAL(Qm) <= 0                    
               WAIT 'Emission Rate must be > 0, '+press WINDOW      
               cntr = 1
               LOOP
            ENDIF
            DO EL2Keys
            IF prev           && F9
               RETURN
            ENDIF
            IF prcd           && F10
               GotArea = .F.
               DO scrnasub   && do screen model (area) input screens                   
             ENDIF   
             EXIT
      ENDCASE
      IF LASTKEY() = 27
         abort = .T.
         EXIT
      ENDIF               
   ENDDO  
ENDDO

RETURN
