* system : tscreen
* program : s44
* author : Roger W. Brode, PES, 4/12/94
* comment: Thermal Incinerator - Scenario 4.4.4, uses SCREEN3 Point Source

ACTIVATE WINDOW datawind
DO WHILE .NOT. abort
   CLEAR
   DO ClrEL1Key 
   DO endline1
   DO EL1Keys
   edit = .F.
   prcd = .F.
   @ 1, 3 SAY 'SOURCE PARAMETERS - Page 1 of 1'
   @ 6, 3 SAY 'EMISSION RATE'
   @ 7, 3 SAY ' Enter the Emission Rate (Qm), if unknown enter'
   @ 8, 3 SAY '         the boxed variables below to calculate -> ' +LEFT(Qm+SPACE(8),8) +' g/s' 
   @ 9,3 TO 13,75
   @ 10,5 SAY '     Destruction and Removal Efficiency (DRE) -> ' +LEFT(Dre+SPACE(8),8) +' %'
   @ 11,5 SAY '        Feed Rate of Organic Contaminant (F),'
   @ 12,5 SAY '             if unknown enter variables below -> ' +LEFT(Frate+SPACE(8),8) +' kg/hr'
   @ 14,3 TO 17,75
   @ 15,5 SAY '    Total Feed Rate of Waste into Incinerator -> ' +LEFT(Trate+SPACE(8),8) +' kg/hr'
   @ 16,5 SAY '     Concentration of Contaminant of Interest -> ' +LEFT(Conc+SPACE(8),8) +' g/g'
   @ 8, 54 FILL TO 8,61 COLOR &IPColor  
   @ 10, 54 FILL TO 10,61 COLOR &IPColor 
   @ 12, 54 FILL TO 12,61 COLOR &IPColor
   @ 15, 54 FILL TO 15,61 COLOR &IPColor
   @ 16, 54 FILL TO 16,61 COLOR &IPColor
   
   cntr = 0
   DO WHILE .NOT. abort
      holdf = Qm
      DO CASE 
         CASE cntr = 0
            DO title
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT
               CASE LASTKEY() = 5   && UP    
                  cntr = 0
               CASE prev  && F9                           
                  RETURN                                  
               OTHERWISE                 
                  cntr = 1
            ENDCASE
         CASE cntr = 1
            @ 8,54 GET Qm PICTURE '@!' VALID Chk(Qm,-3)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 0
               CASE prev             && F9
                  RETURN   
               CASE LEN(ALLTRIM(Qm)) = 0
                  cntr = 2   
               OTHERWISE 
                  IF Qm <> holdf
                     Dre = '99.99'
                     Frate =SPACE(8)
                     @ 10,54 SAY Dre
                     @ 12,54 SAY Frate
                     @ 10, 54 FILL TO 10,61 COLOR &IPColor   
                     @ 12, 54 FILL TO 12,61 COLOR &IPColor
                  ENDIF   

                  cntr = 4
            ENDCASE 
   
         CASE cntr = 2
            holdg = Frate
            @ 10,54 GET Dre PICTURE '@!' VALID Chk(Dre,3)
            @ 12,54 GET Frate PICTURE '@!' VALID Chk(Frate,-3)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
                  cntr = 1
               CASE prev             && F9
                  RETURN   
	       CASE LEN(ALLTRIM(Frate))	= 0
		  cntr = 3
               OTHERWISE
                  IF Frate <> holdg
                     Trate = SPACE(8)
                     Conc =SPACE(8)
                     @ 15,54 SAY Trate
                     @ 16,54 SAY Conc
                     @ 15, 54 FILL TO 15,61 COLOR &IPColor
                     @ 16, 54 FILL TO 16,61 COLOR &IPColor
                  ENDIF   
                  Qm = convert(0.278 * VAL(Frate) * (1.0 - VAL(Dre)/100))
                  @ 8,54 SAY Qm
                  @ 8,54 FILL TO 8,61 COLOR &IPColor
                  cntr = 4
             ENDCASE 
         CASE cntr = 3
            @ 15,54 GET Trate PICTURE '@!' VALID Chk(Trate,3)
            @ 16,54 GET Conc PICTURE '@!' VALID Chk(Conc,3)
            READ   
            DO CASE
               CASE LASTKEY() = 27  && ESCAPE
                  abort = .T.
                  EXIT 
               CASE LASTKEY() = 5   && UP 
		  cntr = 2
               CASE prev             && F9
                  RETURN   
               OTHERWISE
                  Frate = convert(VAL(Trate) * VAL(Conc) * 1.0E-6)
                  Qm = convert(0.278 * VAL(Frate) * (1.0 - VAL(Dre)/100))
                  @ 8,54 SAY Qm
                  @ 8,54 FILL TO 8,61 COLOR &IPColor
                  cntr = 4
             ENDCASE 
          CASE cntr = 4
             IF VAL(Qm) <= 0
                WAIT 'Emission Rate must be > 0, '+press WINDOW
                cntr = 1
                LOOP
             ENDIF         
             DO EL2Keys
             IF prev           && F9
                RETURN
             ENDIF                 
             IF prcd           && F10
                DO CASE
                   CASE VAL(Frate) < 2000 .AND. VAL(Frate) > 0
                      Exitv = '7.0     '
                      Hs = '6.0     '
                      D = '0.3     '
                      Ts = '343     '
                      Ta = '293     '
                      Hb = '0       '
*                     Bmin = '3.6     '
*                     Bmax = '3.6     '
                   CASE VAL(Frate) < 9000
                      Exitv = '10.0    '
                      Hs = '8.0     '
                      D = '0.5     '
                      Ts = '343     '
                      Ta = '293     '
                      Hb = '0       '
                   CASE VAL(Frate) >= 9000
                      Exitv = '20.0    '
                      Hs = '20.0    '
                      D = '1.0     '
                      Ts = '343     '
                      Ta = '293     '
                      Hb = '0       '
                ENDCASE
                DO scrnpsub
             ENDIF
             EXIT
      ENDCASE
      IF LASTKEY() = 27		&& Esc
           	abort = .T.
          	EXIT
      ENDIF
   ENDDO
ENDDO
     
     
DEACTIVATE WINDOW datawind

RETURN     
