* program : TSMAIN.PRG
* system  : TSCREEN
* programmer: Kevin Stroupe, PES
* last revision: Gerry E. Chike, Nov 6, 1992

CLOSE ALL
CLEAR ALL

RESTORE MACROS FROM tsmacro
SET COMPATIBLE FOXPLUS
SET SYSMENU OFF
SET CONFIRM OFF
SET EXACT ON
SET DECIMALS TO 10
SET BELL OFF
SET HEADING OFF
SET SAFETY OFF
SET SCOREBOARD OFF
SET STATUS OFF
SET TALK OFF
SET ESCAPE OFF
SET INTENSITY ON
SET DATE AMERICAN
SET DEFAULT TO
SET DELETED ON
SET NEAR ON

SET COLOR TO W+/BG
CLEAR
*SET COLOR TO W+/B
*@0,1 SAY PADC("",79,' ')
SET BORDER TO SINGLE
****ON KEY LABEL f11 SUSPEND

ELColor = 'GR+/B'
LEColor = 'N/W+'
HLColor = 'W+/B' 
IPColor = 'W+/BG'
MesColor = 'W+/BR'
GrfPopClr = 'B/B,W+/B,W+/B,W+/B,W+/B,W+/BG,GR+/B,W/N,W+/B'
*PopColor = 'W+/B,W+/B,W+/B,W+/B,W+/B,W+/BG,GR+/B,N/N,W+/B'
*PopColor = 'W+/B,W+/B,W+/B,W+/B,W+/B,W+/BG,GR+/B,W/N,W+/B'
PopColor = 'W+/B,W+/B,W+/B,W+/B,W+/B,N/W,GR+/B,W/N,W+/B'
WindColor = 'W+/B,W+/BG,W+/B,W+/B,W+/B,W+/BG,GR+/B,W/N,W+/B'
SelColor = 'GR+/B,W+/BG,W+/B,W+/B,W+/B,W+/BG,GR+/B,W/N,W+/B'
PColor = 'W+/B,W+/B,B/B,W+/B,W+/B,N/W,GR+/B,W/N,W+/B'
BrowColor = 'W+/B,GR+/B,B/B,W+/B,W+/B,GR+/B,GR+/B,W/N,W+/B'

SET COLOR OF SCHEME 1 TO &WindColor
SET COLOR  OF SCHEME 2 TO &PopColor

ON ERROR DO erprog WITH MESSAGE(),PROGRAM(),LINENO(),ERROR()

DEFINE MENU mainmenu && COLOR W+/B,W+/B,W+/B,W+/B,W+/B,W+/BG,GR+/B,W+/B,W+/B 
     
DEFINE PAD filemenu  OF mainmenu PROMPT ' \<File '  AT 00,00
DEFINE PAD relmenu OF mainmenu PROMPT ' \<Initial Form of Release ' AT 00,09
DEFINE PAD chemmenu  OF mainmenu PROMPT ' \<Chemical Database '  AT 00,37
DEFINE PAD quitmenu  OF mainmenu PROMPT ' \<Quit '  AT 00,58
   
SET PROCEDURE TO subs
DO makepub
*file_hold = 1
*rel_hold = 1
*part_hold = 1
*gas_hold = 1
*liq_hold = 1
*stk_hold = 1
*tim_hold = 1
*chem_hold = 1

ON SELECTION MENU mainmenu DO mainmen WITH PAD()

DO init
DO loadkey
DO titlmain
DO EndLin4

ON KEY LABEL F1 DO MenuHelp

DO WHILE .T.
   ACTIVATE MENU mainmenu
ENDDO


RETURN


******************************* Main Menu ***********************************
PROCEDURE mainmen
PARAMETERS mpad

DO EL4menu
DO CASE
   CASE mpad = 'FILEMENU'
      DEFINE POPUP filemen FROM 01,00 SHADOW COLOR &PopColor TITLE ' File '
      DEFINE BAR  1 OF filemen PROMPT '\<Access Data from Previous Scenario'
      DEFINE BAR  2 OF filemen PROMPT 'Access \<Model Printer Output'
      DEFINE BAR  3 OF filemen PROMPT 'Access Model \<Graphic Output'
*      DEFINE BAR  4 OF filemen PROMPT '\<Quit'
      ON SELECTION POPUP filemen DO filemen WITH BAR()
      ACTIVATE POPUP filemen BAR file_hold 
      RELEASE POPUP filemen
   CASE mpad = 'RELMENU'
      DEFINE POPUP relmen FROM 01,09 SHADOW COLOR &PopColor TITLE ' Initial Form of Release '
      DEFINE BAR  1 OF relmen PROMPT '\<Particulate Matter Release Type'
      DEFINE BAR  2 OF relmen PROMPT '\<Gaseous Release Type'
      DEFINE BAR  3 OF relmen PROMPT '\<Liquid Release Type'
      DEFINE BAR  4 OF relmen PROMPT '\<Superfund Release Type'
      ON SELECTION POPUP relmen DO relmen WITH BAR()
      ACTIVATE POPUP relmen BAR rel_hold
      RELEASE POPUP relmen
   CASE mpad = 'CHEMMENU'
      DEFINE POPUP chemmen FROM 1,37 SHADOW COLOR &PopColor TITLE ' Chemical Database '
      DEFINE BAR 1 OF chemmen PROMPT '\<Search the Database'
      DEFINE BAR 2 OF chemmen PROMPT '\<Add a Chemical to Database'
      ON SELECTION POPUP chemmen DO chemmen WITH BAR()
      ACTIVATE POPUP chemmen &&BAR chem_hold
      RELEASE POPUP chemmen
   CASE mpad = 'QUITMENU'
      DEFINE POPUP quitmen FROM 1,58 SHADOW COLOR &PopColor TITLE ' Quit TSCREEN ? '
      DEFINE BAR 1 OF quitmen PROMPT '         \<Yes'
      DEFINE BAR 2 OF quitmen PROMPT '         \<No'
      ON SELECTION POPUP quitmen DO quitmen WITH BAR()
      ACTIVATE POPUP quitmen BAR quit_hold
      RELEASE POPUP quitmen      
ENDCASE
DO EL4Menu 
DO ClrEL4Keys  

RETURN


******************************* File Menu ***********************************
PROCEDURE filemen
PARAMETER fileread

IF fileread = file_hold
   abort = .F.
ELSE
   DO init
ENDIF

DO CASE
   CASE fileread = 1
      DO ClrEl4All
      DO reinit
   CASE fileread = 2  
      DO ClrEl4All
      fil = ''
      DO rptpick WITH fil   
      IF fil <> ''
         DO viewrpt
      ENDIF 
   CASE fileread = 3
      DO ClrEl4All
      grffile = ''
      review = .T.
      DO grfpick WITH grffile   
      IF grffile <> ''
         DO graf
      ENDIF          
*   CASE fileread = 4
*      DO restore        
*      CANCEL
*     * QUIT 
ENDCASE
file_hold = fileread

DO EL4Menu 
*DO ClrEL4Keys  
      
RETURN

********************************** Release Menu ******************************
PROCEDURE relmen
PARAMETER relread

IF relread = rel_hold
   abort = .F.
ELSE
   DO init
ENDIF

DO CASE
   CASE relread = 1    
      DEFINE POPUP partmen FROM 03,12 SHADOW COLOR &PopColor TITLE ' Particulate Matter Release Type '
      DEFINE BAR  1 OF partmen PROMPT '\                              Workbook Scenario ' COLOR &ELColor
      DEFINE BAR  2 OF partmen PROMPT '\<Stacks,Vents                      - 1.1'
      DEFINE BAR  3 OF partmen PROMPT '\<Fugitive/Windblown Dust Emissions - 1.2'
      DEFINE BAR  4 OF partmen PROMPT '\<Ducting/Connector Failures        - 1.3'
      ON SELECTION POPUP partmen DO partmen WITH BAR()
      ACTIVATE POPUP partmen BAR part_hold
      RELEASE POPUP partmen
   CASE relread = 2
      DEFINE POPUP gasmen FROM 04,12 SHADOW COLOR &PopColor TITLE ' Gaseous Release Type '
      DEFINE BAR  1 OF gasmen PROMPT '\                                            Workbook Scenario ' COLOR &ELColor
      DEFINE BAR  2 OF gasmen PROMPT '\<Flared Stack Emissions                          - 2.1'
      DEFINE BAR  3 OF gasmen PROMPT '\<Stacks, Vents, Conventional Point Sources       - 2.2'
      DEFINE BAR  4 OF gasmen PROMPT '\<Leaks from Reservoir                            - 2.3,2.4'
      DEFINE BAR  5 OF gasmen PROMPT '\<Leaks from a Pipe Attached to Reservoir         - 2.5,2.6'
      DEFINE BAR  6 OF gasmen PROMPT '\<Multiple Fugitive Sources                       - 2.7'
      DEFINE BAR  7 OF gasmen PROMPT 'Land \<Treatment Facilities                       - 2.8'
      DEFINE BAR  8 OF gasmen PROMPT 'Municipal Solid \<Waste Landfills                 - 2.9'
      DEFINE BAR  9 OF gasmen PROMPT '\<Pesticide/Herbicide Applications                - 2.10'
      DEFINE BAR 10 OF gasmen PROMPT '\<Discharges from Equipment Openings              - 2.11'
      ON SELECTION POPUP gasmen DO gasmen WITH BAR() 
      ACTIVATE POPUP gasmen BAR gas_hold
      RELEASE POPUP gasmen
   CASE relread = 3
      DEFINE POPUP liqmen FROM 05,12 SHADOW COLOR &PopColor TITLE ' Liquid Release Type '
      DEFINE BAR  1 OF liqmen PROMPT '\                                               Workbook Scenario' COLOR &ELColor
      DEFINE BAR  2 OF liqmen PROMPT '\<Surface Impoundments (Lagoons)                    - 3.1'
      DEFINE BAR  3 OF liqmen PROMPT '\<2-Phase Saturated Liquid from Pressurized Storage - 3.2,3.3'
      DEFINE BAR  4 OF liqmen PROMPT '2-\<Phase Subcooled Liquid from Pressurized Storage - 3.4,3.5'
      DEFINE BAR  5 OF liqmen PROMPT '\<High Volatility Liquid Leaks                      - 3.6,3.7'
      DEFINE BAR  6 OF liqmen PROMPT '\<Low Volatility Liquid Leaks                       - 3.8,3.9'
*      DEFINE BAR  4 OF liqmen PROMPT '\<Low Volatility (Pooled) Liquid Leaks from Pipes   - 3.4'
*      DEFINE BAR  5 OF liqmen PROMPT 'Low \<Volatility (Pooled) Liquid Leaks from Tanks   - 3.5'
*      DEFINE BAR  6 OF liqmen PROMPT '\<High Volatility Liquid Leaks from Pipes           - 3.6'
*      DEFINE BAR  7 OF liqmen PROMPT 'H\<igh Volatility Liquid Leaks from Tanks           - 3.7'
      ON SELECTION POPUP liqmen DO liqmen WITH  BAR() 
      ACTIVATE POPUP liqmen BAR liq_hold
      RELEASE POPUP liqmen
   CASE relread = 4
      DEFINE POPUP supmen FROM 06,12 SHADOW COLOR &PopColor TITLE ' Superfund Release Type '
      DEFINE BAR  1 OF supmen PROMPT '\                           Workbook Scenario ' COLOR &ELColor
      DEFINE BAR  2 OF supmen PROMPT '\<Air Stripper                   - 4.1'
      DEFINE BAR  3 OF supmen PROMPT '\<Soil Vapor Extraction (SVE)    - 4.2'
      DEFINE BAR  4 OF supmen PROMPT 'Soil \<Excavation                - 4.3'
      DEFINE BAR  5 OF supmen PROMPT '\<Thermal Incineration           - 4.4'
      ON SELECTION POPUP supmen DO supmen WITH  BAR() 
      ACTIVATE POPUP supmen BAR sup_hold
      RELEASE POPUP supmen
ENDCASE
rel_hold = relread
IF prev_menu
   prev_menu = .F.
   abort = .F.
ELSE
   IF LASTKEY() = 27
      abort = .T.
   ENDIF   
ENDIF

IF abort        
   KEYBOARD CHR(27)
ENDIF

DO El4Menu
*DO ClrEL4Keys
RETURN

****************************** Particulate Menu *****************************
PROCEDURE partmen
PARAMETERS partread


IF partread = part_hold
   abort = .F.
ELSE
   DO init
ENDIF

DO CASE
   CASE partread = 2
      DO ClrEl4All
      direct = .T.
      label = ' Continuous Particulate Releases from Stacks, Vents - Scenario 1.1 '
      scenario = '1.1'
      DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label  COLOR SCHEME 1      
      DO scrnpsub
   CASE partread = 3
      DO ClrEl4All
      label = ' Fugitive/Windblown Dust Emissions - Scenario 1.2 '
      scenario = '1.2'
      DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label  COLOR SCHEME 1
      IF make_p_0
         P = '0       '
         make_p_0 = .F.
      ENDIF
      DO s12
   CASE partread = 4
      DO ClrEl4All
      label = ' Ducting/Connector Failures - Scenario 1.3 '
      scenario = '1.3'
      DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1
      direct = .T.
      DO puffsub
ENDCASE
part_hold = partread
    
IF prev_menu
   prev_menu = .F.
   abort = .F.
ELSE
   IF LASTKEY() = 27
      abort = .T.
   ENDIF   
ENDIF
 
IF abort
    KEYBOARD CHR(27)
ENDIF
RELEASE WINDOW datawind

DO El4Menu
RETURN

****************************** Gaseous Menu *****************************
PROCEDURE gasmen
PARAMETER gasread

IF gasread = gas_hold
   abort = .F.
ELSE
   DO init
ENDIF
 
DO CASE
   CASE gasread = 2
      DO ClrEl4All
      label = ' Flared Stack Emissions - Scenario 2.1 '
      Scenario = '2.1'
      DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1
      DO scrnfsub
   CASE gasread = 3
      DO ClrEl4All
      label = ' Continuous Releases from Stacks, Vents, Point Sources - Scenario 2.2 '
      scenario = '2.2'
      DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1
      direct = .F.
      DO s22
   CASE gasread = 4   
      DEFINE POPUP timemen FROM 11,20 SHADOW COLOR &PopColor TITLE ' Release Duration '
      DEFINE BAR  1 OF timemen PROMPT '\<Continuous'
      DEFINE BAR  2 OF timemen PROMPT '\<Instantaneous'
      ON SELECTION POPUP timemen DO timemen WITH BAR(),PROGRAM(),gasread
      ACTIVATE POPUP timemen BAR tim_hold
      RELEASE POPUP timemen
   CASE gasread = 5
      DEFINE POPUP timemen FROM 11,20 SHADOW COLOR &PopColor TITLE ' Release Duration '
      DEFINE BAR  1 OF timemen PROMPT '\<Continuous'
      DEFINE BAR  2 OF timemen PROMPT '\<Instantaneous'
      ON SELECTION POPUP timemen DO timemen WITH BAR(),PROGRAM(),gasread
      ACTIVATE POPUP timemen BAR tim_hold
      RELEASE POPUP timemen
   CASE gasread = 6
      DO ClrEl4All
      label = ' Gaseous Emissions from Multiple Fugitive Sources - Scenario 2.7 '
      scenario = '2.7'
      DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1
      IF make_hs_0 
         Hs = '0       '
         make_hs_0 = .F.
      ENDIF
      DO s27
   CASE gasread = 7
      DO ClrEl4All
      label = ' Gaseous Emissions from Land Treatment Facilities - Scenario 2.8 '
      scenario = '2.8'
      DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1      
      DO s28
   CASE gasread = 8
      DO ClrEl4All
      label = ' Emissions from Municipal Solid Waste Landfills - Scenario 2.9 '
      scenario = '2.9'
      DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1
      DO s29
   CASE gasread = 9
      DO ClrEl4All
      label = ' Emissions from Pesticide/Herbicide Applications - Scenario 2.10 '
      scenario = '2.10'
      DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1
      DO s210
   CASE gasread = 10
      DO ClrEl4All
      label = ' Discharges from Equipment Openings - Scenario 2.11 '
      scenario = '2.11'
      DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1
      direct = .F.
      DO s211
ENDCASE
RELEASE WINDOW datawind

gas_hold = gasread
IF prev_menu
   prev_menu = .F.
   abort = .F.
ELSE
   IF LASTKEY() = 27
      abort = .T.
   ENDIF   
ENDIF
IF abort
   KEYBOARD CHR(27)   
ENDIF
DO El4Menu  
RETURN

****************************** Liquid Menu *****************************
PROCEDURE liqmen
PARAMETER liqread

IF liqread = liq_hold
   abort = .F.
ELSE
   DO init
ENDIF

DO CASE
   CASE liqread = 2
      DO ClrEl4All
      label = ' Evaporation from Surface Impoundments (Lagoons) - Scenario 3.1 '
      scenario = '3.1'
      DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1
      DO s31
   CASE liqread = 3
      DEFINE POPUP timemen FROM 9,20 SHADOW COLOR &PopColor TITLE ' Release Duration '
      DEFINE BAR  1 OF timemen PROMPT '\<Continuous'
      DEFINE BAR  2 OF timemen PROMPT '\<Instantaneous'
      ON SELECTION POPUP timemen DO timemen WITH BAR(),PROGRAM(),liqread
      ACTIVATE POPUP timemen BAR tim_hold
      RELEASE POPUP timemen
   CASE liqread = 4
      DEFINE POPUP timemen FROM 10,20 SHADOW COLOR &PopColor TITLE ' Release Duration '
      DEFINE BAR  1 OF timemen PROMPT '\<Continuous'
      DEFINE BAR  2 OF timemen PROMPT '\<Instantaneous'
      ON SELECTION POPUP timemen DO timemen WITH BAR(),PROGRAM(),liqread
      ACTIVATE POPUP timemen BAR tim_hold
      RELEASE POPUP timemen
   CASE liqread = 5
      DEFINE POPUP timemen FROM 11,20 SHADOW COLOR &PopColor TITLE ' Release Duration '
      DEFINE BAR  1 OF timemen PROMPT '\<Continuous'
      DEFINE BAR  2 OF timemen PROMPT '\<Instantaneous'
      ON SELECTION POPUP timemen DO timemen WITH BAR(),PROGRAM(),liqread
      ACTIVATE POPUP timemen BAR tim_hold
      RELEASE POPUP timemen
   CASE liqread = 6
      DEFINE POPUP timemen FROM 12,20 SHADOW COLOR &PopColor TITLE ' Release Duration '
      DEFINE BAR  1 OF timemen PROMPT '\<Continuous'
      DEFINE BAR  2 OF timemen PROMPT '\<Instantaneous'
      ON SELECTION POPUP timemen DO timemen WITH BAR(),PROGRAM(),liqread
      ACTIVATE POPUP timemen BAR tim_hold
      RELEASE POPUP timemen      
ENDCASE
RELEASE WINDOW datawind

liq_hold = liqread
IF prev_menu
   prev_menu = .F.
   abort = .F.
ELSE
   IF LASTKEY() = 27
      abort = .T.
   ENDIF   
ENDIF
IF abort
   KEYBOARD CHR(27)
ENDIF
DO EL4Menu
RETURN

****************************** Superfund Menu *****************************
PROCEDURE supmen
PARAMETER supread

IF supread = sup_hold
   abort = .F.
ELSE
   DO init
ENDIF

DO CASE
   CASE supread = 2
      DO ClrEl4All
      direct = .T.
*      screenlong = .T.
      label =  ' Air Strippers - Scenario 4.4.1 '
      scenario = '4.1'
      DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1      
      DO s41
   CASE supread = 3
      DO ClrEl4All
      direct = .T.
      label =  ' Soil Vapor Extraction - Scenario 4.4.2 '
      scenario = '4.2'
      DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1
*      WAIT "Scenario will be added on the next update, " + press WINDOW
      DO s42
*                RETURN
   CASE supread = 4
      DO ClrEl4All
      direct = .T.
      label =  ' Soil Excavation - Scenario 4.4.3 '
      scenario = '4.3'
      DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1      
      DO s43
   CASE supread = 5
      DO ClrEl4All
      direct = .T.
      label =  ' Thermal Incineration - Scenario 4.4.4 '
      scenario = '4.4'
      DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1      
      DO s44
ENDCASE
RELEASE WINDOW datawind

sup_hold = supread
IF prev_menu
   prev_menu = .F.
   abort = .F.
ELSE
   IF LASTKEY() = 27
      abort = .T.
   ENDIF   
ENDIF
IF abort
   KEYBOARD CHR(27)
ENDIF
DO EL4Menu
RETURN

********************************** TimeMen **********************************
PROCEDURE TimeMen
PARAMETERS timeread,mprogram,mprevbar

IF timeread = tim_hold
   abort = .F.
ELSE
   DO init
ENDIF
DO CASE
   CASE mprogram = 'GASMEN'
      DO CASE 
         CASE mprevbar = 4
            IF timeread = 1
               DO ClrEl4All
               label = ' Continuous Leaks from Reservoir - Scenario 2.3 '
               scenario = '2.3'
               DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1
               direct = .F.
               screenlong = .F.
               two_phase = .F.
               DO s23
            ELSE
               DO ClrEl4All 
               label = ' Instantaneous Leaks from Reservoir - Scenario 2.4 '
               scenario = '2.4'
               DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1             
               two_phase = .F.
               direct = .F.
               DO s24
            ENDIF
         CASE mprevbar = 5
            IF timeread = 1
               DO ClrEl4All
               label = ' Continuous Leaks from Pipe Attached to Reservoir - Scenario 2.5 '
               scenario = '2.5'
               DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1
               direct = .F.
               screenlong = .F.
               two_phase = .F.
               DO s25
            ELSE
               DO ClrEl4All 
               label = ' Instantaneous Leaks from Pipe Attached to Reservoir - Scenario 2.6 '
               scenario = '2.6'
               DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1
               two_phase = .F.
               direct = .F.
               DO s26
            ENDIF            
         ENDCASE         
   CASE mprogram = 'LIQMEN'
      DO CASE
        CASE mprevbar = 3
           IF timeread = 1
              DO ClrEl4All
              label = ' Continuous 2-Phase Saturated Liquid from Pressurized Storage - 3.2 '
              scenario = '3.2'
              DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1
              direct = .F.
              two_phase = .T.
              screenlong = .F.
              DO s32
           ELSE
              DO ClrEl4All
              label = ' Instantaneous 2-Phase Saturated Liquid from Pressurized Storage - 3.3 '
              scenario = '3.3'
              DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1
              two_phase = .T.
              direct = .F.
              DO s33              
           ENDIF
        CASE mprevbar = 4
           IF timeread = 1
              DO ClrEl4All
              label = ' Continuous 2-Phase Subcooled Liquid from Pressurized Storage - 3.4 ' 
              scenario = '3.4'
              DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1
              direct = .F.
              two_phase = .T.
              screenlong = .F.
              DO s34
           ELSE
              DO ClrEl4All
              label = ' Instantaneous 2-Phase Subcooled Liquid from Pressurized Storage - 3.5 '
              scenario = '3.5'
              DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1
              two_phase = .T.
              direct = .F.
              DO s35
           ENDIF           
        CASE mprevbar = 5
           IF timeread = 1
              DO ClrEl4All
              label = ' Continuous High Volatility Liquid Leaks - 3.6 '
              scenario = '3.6'
              DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1
              direct = .F.
              screenlong = .F.
              two_phase = .F.
              DO s36
           ELSE
              DO ClrEl4All
              label = ' Instantaneous High Volatility Liquid Leaks - 3.7 '
              scenario = '3.7'
              DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1              
              direct = .F.
              two_phase = .F.
              DO s37
           ENDIF           
        CASE mprevbar = 6
           IF timeread = 1
              DO ClrEl4All
              label = ' Continuous Low Volatility Liquid Leaks - 3.8 '
              scenario = '3.8'
              DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1
              two_phase = .F.
              DO s38
           ELSE
              DO ClrEl4All
              label = ' Instantaneous Low Volatility Liquid Leaks - 3.9 '
              scenario = '3.9'
              DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1
              two_phase = .F.
              direct = .F.
              DO s39
           ENDIF                      
     ENDCASE
ENDCASE
RELEASE WINDOW datawind

tim_hold = timeread
DO EL4Menu
IF prev_menu
   prev_menu = .F.
   abort = .F.
ELSE
   IF LASTKEY() = 27
      abort = .T.
   ENDIF   
ENDIF

IF abort 
   KEYBOARD CHR(27)
ENDIF
RETURN

****************************** Stack Menu *****************************
*PROCEDURE stkmen
*PARAMETER stkread
*
*IF stkread = stk_hold
*   abort = .F.
*ELSE
*   DO init
*ENDIF
*
*DO CASE
*   CASE stkread = 1
*      DO ClrEl4All
*      label = ' Releases from Stacks, Vents, Point Sources - Scenario 1.2 '
*      scenario = '1.2'
*      DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1
*      direct = .F.         
*      DO s1x2                   
*   CASE stkread = 4   
*      DO ClrEl4All
*      direct = .T.
**      screenlong = .T.
*      label =  ' Air Strippers '
*      scenario = 'StkxAS'
*      DEFINE WINDOW datawind FROM 0,0 TO 24,79 TITLE label COLOR SCHEME 1      
*      DO stkxas            
*ENDCASE
*RELEASE WINDOW datawind
*
*stk_hold = stkread
*IF prev_menu
*   prev_menu = .F.
*   abort = .F.
*ELSE
*   IF LASTKEY() = 27
*      abort = .T.
*   ENDIF   
*ENDIF
*IF abort
*   KEYBOARD CHR(27)
*ENDIF
*DO EL4menu   
*RETURN
*
************************ Chemical Database Menu ***************************
PROCEDURE chemmen
PARAMETER chemread

IF chemread = chem_hold
   abort = .F.
ELSE
   DO init
ENDIF

DO CASE
   CASE chemread = 1
      DO ClrEl4All
      DO chempick WITH VARREAD(), PROGRAM()
   CASE chemread = 2
      DO ClrEl4All
      DO chembase WITH '','', PROGRAM()
ENDCASE
chem_hold = chemread
    
IF abort 
*       EXIT
ENDIF

DO El4Menu
*DO ClrEL4Keys
RETURN

******************************* Quit Menu ***********************************
PROCEDURE quitmen
PARAMETER quitread

DO CASE
   CASE quitread = 1
      DO restore        
*      HIDE MENU ALL
*      HIDE POPUP ALL
*      !DEL Help*.PCX
      CLOSE ALL
	  RELEASE ALL
*	  CANCEL
      QUIT 
   CASE quitread = 2  
      KEYBOARD CHR(27)   
      RETURN      
ENDCASE
     
RETURN
